# -*- coding: utf-8 -*-
from setuptools import setup

packages = \
['tjutils']

package_data = \
{'': ['*'], 'tjutils': ['templates/nbdev/*']}

install_requires = \
['GitPython>=3.1.27,<4.0.0',
 'bandit>=1.7.4,<2.0.0',
 'black[jupyter]>=22.10.0,<23.0.0',
 'fastcore>=1.5.27,<2.0.0',
 'flake8>=5.0.4,<6.0.0',
 'ipykernel>=6.15.3,<7.0.0',
 'mypy>=0.971,<0.972',
 'nbdev>=2.3.7,<3.0.0',
 'tomli>=2.0.1,<3.0.0']

entry_points = \
{'console_scripts': ['tjdev_export = tjutils.nbdev:export',
                     'tjdev_generate = tjutils.nbdev:generate',
                     'tjdev_nbdev_gha = tjutils.nbdev:github_actions',
                     'tjdev_nbdev_gitignore = tjutils.nbdev:gitignore',
                     'tjdev_release = tjutils.nbdev:release',
                     'tjdev_version = tjutils.nbdev:version']}

setup_kwargs = {
    'name': 'tjutils',
    'version': '0.7.1',
    'description': 'Python Utilities for TJ P',
    'long_description': 'TJUtils (Python)\n================\n\n<!-- WARNING: THIS FILE WAS AUTOGENERATED! DO NOT EDIT! -->\n\n> This is a set of utilities to assist in development in Python. See the\n> notebooks folder for the various functionality included in this\n> package.\n',
    'author': 'TJ P',
    'author_email': 'mail@tjpalanca.com',
    'maintainer': 'None',
    'maintainer_email': 'None',
    'url': 'None',
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
