"use strict";
var _a, _b;
Object.defineProperty(exports, "__esModule", { value: true });
exports.SelfManagedKafkaEventSource = exports.ManagedKafkaEventSource = exports.AuthenticationMethod = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const crypto = require("crypto");
const iam = require("@aws-cdk/aws-iam");
const lambda = require("@aws-cdk/aws-lambda");
const core_1 = require("@aws-cdk/core");
const stream_1 = require("./stream");
// keep this import separate from other imports to reduce chance for merge conflicts with v2-main
// eslint-disable-next-line no-duplicate-imports, import/order
const core_2 = require("@aws-cdk/core");
/**
 * The authentication method to use with SelfManagedKafkaEventSource.
 *
 * @stability stable
 */
var AuthenticationMethod;
(function (AuthenticationMethod) {
    AuthenticationMethod["SASL_SCRAM_512_AUTH"] = "SASL_SCRAM_512_AUTH";
    AuthenticationMethod["SASL_SCRAM_256_AUTH"] = "SASL_SCRAM_256_AUTH";
})(AuthenticationMethod = exports.AuthenticationMethod || (exports.AuthenticationMethod = {}));
/**
 * Use a MSK cluster as a streaming source for AWS Lambda.
 *
 * @stability stable
 */
class ManagedKafkaEventSource extends stream_1.StreamEventSource {
    /**
     * @stability stable
     */
    constructor(props) {
        super(props);
        this.innerProps = props;
    }
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target) {
        var _c;
        target.addEventSourceMapping(`KafkaEventSource:${this.innerProps.clusterArn}${this.innerProps.topic}`, this.enrichMappingOptions({
            eventSourceArn: this.innerProps.clusterArn,
            startingPosition: this.innerProps.startingPosition,
            // From https://docs.aws.amazon.com/msk/latest/developerguide/msk-password.html#msk-password-limitations, "Amazon MSK only supports SCRAM-SHA-512 authentication."
            sourceAccessConfigurations: [{ type: lambda.SourceAccessConfigurationType.SASL_SCRAM_512_AUTH, uri: this.innerProps.secret.secretArn }],
            kafkaTopic: this.innerProps.topic,
        }));
        this.innerProps.secret.grantRead(target);
        target.addToRolePolicy(new iam.PolicyStatement({
            actions: ['kafka:DescribeCluster', 'kafka:GetBootstrapBrokers', 'kafka:ListScramSecrets'],
            resources: [this.innerProps.clusterArn],
        }));
        (_c = target.role) === null || _c === void 0 ? void 0 : _c.addManagedPolicy(iam.ManagedPolicy.fromAwsManagedPolicyName('service-role/AWSLambdaMSKExecutionRole'));
    }
}
exports.ManagedKafkaEventSource = ManagedKafkaEventSource;
_a = JSII_RTTI_SYMBOL_1;
ManagedKafkaEventSource[_a] = { fqn: "@aws-cdk/aws-lambda-event-sources.ManagedKafkaEventSource", version: "1.108.0" };
/**
 * Use a self hosted Kafka installation as a streaming source for AWS Lambda.
 *
 * @stability stable
 */
class SelfManagedKafkaEventSource extends stream_1.StreamEventSource {
    /**
     * @stability stable
     */
    constructor(props) {
        super(props);
        if (props.vpc) {
            if (!props.securityGroup) {
                throw new Error('securityGroup must be set when providing vpc');
            }
            if (!props.vpcSubnets) {
                throw new Error('vpcSubnets must be set when providing vpc');
            }
        }
        this.innerProps = props;
    }
    /**
     * Called by `lambda.addEventSource` to allow the event source to bind to this function.
     *
     * @stability stable
     */
    bind(target) {
        if (!core_2.Construct.isConstruct(target)) {
            throw new Error('Function is not a construct. Unexpected error.');
        }
        target.addEventSourceMapping(this.mappingId(target), this.enrichMappingOptions({
            kafkaBootstrapServers: this.innerProps.bootstrapServers,
            kafkaTopic: this.innerProps.topic,
            startingPosition: this.innerProps.startingPosition,
            sourceAccessConfigurations: this.sourceAccessConfigurations(),
        }));
        this.innerProps.secret.grantRead(target);
    }
    mappingId(target) {
        let hash = crypto.createHash('md5');
        hash.update(JSON.stringify(core_1.Stack.of(target).resolve(this.innerProps.bootstrapServers)));
        const idHash = hash.digest('hex');
        return `KafkaEventSource:${idHash}:${this.innerProps.topic}`;
    }
    sourceAccessConfigurations() {
        var _c;
        let authType;
        switch (this.innerProps.authenticationMethod) {
            case AuthenticationMethod.SASL_SCRAM_256_AUTH:
                authType = lambda.SourceAccessConfigurationType.SASL_SCRAM_256_AUTH;
                break;
            case AuthenticationMethod.SASL_SCRAM_512_AUTH:
            default:
                authType = lambda.SourceAccessConfigurationType.SASL_SCRAM_512_AUTH;
                break;
        }
        let sourceAccessConfigurations = [{ type: authType, uri: this.innerProps.secret.secretArn }];
        if (this.innerProps.vpcSubnets !== undefined && this.innerProps.securityGroup !== undefined) {
            sourceAccessConfigurations.push({
                type: lambda.SourceAccessConfigurationType.VPC_SECURITY_GROUP,
                uri: this.innerProps.securityGroup.securityGroupId,
            });
            (_c = this.innerProps.vpc) === null || _c === void 0 ? void 0 : _c.selectSubnets(this.innerProps.vpcSubnets).subnetIds.forEach((id) => {
                sourceAccessConfigurations.push({ type: lambda.SourceAccessConfigurationType.VPC_SUBNET, uri: id });
            });
        }
        return sourceAccessConfigurations;
    }
}
exports.SelfManagedKafkaEventSource = SelfManagedKafkaEventSource;
_b = JSII_RTTI_SYMBOL_1;
SelfManagedKafkaEventSource[_b] = { fqn: "@aws-cdk/aws-lambda-event-sources.SelfManagedKafkaEventSource", version: "1.108.0" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoia2Fma2EuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyJrYWZrYS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOzs7OztBQUFBLGlDQUFpQztBQUVqQyx3Q0FBd0M7QUFDeEMsOENBQThDO0FBRTlDLHdDQUFzQztBQUN0QyxxQ0FBcUU7QUFFckUsaUdBQWlHO0FBQ2pHLDhEQUE4RDtBQUM5RCx3Q0FBMEM7Ozs7OztBQWlCMUMsSUFBWSxvQkFLWDtBQUxELFdBQVksb0JBQW9CO0lBRTlCLG1FQUEyQyxDQUFBO0lBRTNDLG1FQUEyQyxDQUFBO0FBQzdDLENBQUMsRUFMVyxvQkFBb0IsR0FBcEIsNEJBQW9CLEtBQXBCLDRCQUFvQixRQUsvQjs7Ozs7O0FBcUJELE1BQWEsdUJBQXdCLFNBQVEsMEJBQWlCOzs7O0lBSTVELFlBQVksS0FBbUM7UUFDN0MsS0FBSyxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2IsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE1BQXdCOztRQUNsQyxNQUFNLENBQUMscUJBQXFCLENBQzFCLG9CQUFvQixJQUFJLENBQUMsVUFBVSxDQUFDLFVBQVUsR0FBRyxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxFQUN4RSxJQUFJLENBQUMsb0JBQW9CLENBQUM7WUFDeEIsY0FBYyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsVUFBVTtZQUMxQyxnQkFBZ0IsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLGdCQUFnQjtZQUNsRCxrS0FBa0s7WUFDbEssMEJBQTBCLEVBQUUsQ0FBQyxFQUFFLElBQUksRUFBRSxNQUFNLENBQUMsNkJBQTZCLENBQUMsbUJBQW1CLEVBQUUsR0FBRyxFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsTUFBTSxDQUFDLFNBQVMsRUFBRSxDQUFDO1lBQ3ZJLFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUs7U0FDbEMsQ0FBQyxDQUNILENBQUM7UUFFRixJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxTQUFTLENBQUMsTUFBTSxDQUFDLENBQUM7UUFFekMsTUFBTSxDQUFDLGVBQWUsQ0FBQyxJQUFJLEdBQUcsQ0FBQyxlQUFlLENBQzVDO1lBQ0UsT0FBTyxFQUFFLENBQUMsdUJBQXVCLEVBQUUsMkJBQTJCLEVBQUUsd0JBQXdCLENBQUM7WUFDekYsU0FBUyxFQUFFLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLENBQUM7U0FDeEMsQ0FDRixDQUFDLENBQUM7UUFFSCxNQUFBLE1BQU0sQ0FBQyxJQUFJLDBDQUFFLGdCQUFnQixDQUFDLEdBQUcsQ0FBQyxhQUFhLENBQUMsd0JBQXdCLENBQUMsd0NBQXdDLENBQUMsRUFBRTtJQUN0SCxDQUFDOztBQS9CSCwwREFnQ0M7Ozs7Ozs7O0FBR0QsTUFBYSwyQkFBNEIsU0FBUSwwQkFBaUI7Ozs7SUFJaEUsWUFBWSxLQUF1QztRQUNqRCxLQUFLLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDYixJQUFJLEtBQUssQ0FBQyxHQUFHLEVBQUU7WUFDYixJQUFJLENBQUMsS0FBSyxDQUFDLGFBQWEsRUFBRTtnQkFDeEIsTUFBTSxJQUFJLEtBQUssQ0FBQyw4Q0FBOEMsQ0FBQyxDQUFDO2FBQ2pFO1lBQ0QsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLEVBQUU7Z0JBQ3JCLE1BQU0sSUFBSSxLQUFLLENBQUMsMkNBQTJDLENBQUMsQ0FBQzthQUM5RDtTQUNGO1FBQ0QsSUFBSSxDQUFDLFVBQVUsR0FBRyxLQUFLLENBQUM7SUFDMUIsQ0FBQzs7Ozs7O0lBRU0sSUFBSSxDQUFDLE1BQXdCO1FBQ2xDLElBQUksQ0FBQyxnQkFBUyxDQUFDLFdBQVcsQ0FBQyxNQUFNLENBQUMsRUFBRTtZQUFFLE1BQU0sSUFBSSxLQUFLLENBQUMsZ0RBQWdELENBQUMsQ0FBQztTQUFFO1FBQzFHLE1BQU0sQ0FBQyxxQkFBcUIsQ0FDMUIsSUFBSSxDQUFDLFNBQVMsQ0FBQyxNQUFNLENBQUMsRUFDdEIsSUFBSSxDQUFDLG9CQUFvQixDQUFDO1lBQ3hCLHFCQUFxQixFQUFFLElBQUksQ0FBQyxVQUFVLENBQUMsZ0JBQWdCO1lBQ3ZELFVBQVUsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUs7WUFDakMsZ0JBQWdCLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0I7WUFDbEQsMEJBQTBCLEVBQUUsSUFBSSxDQUFDLDBCQUEwQixFQUFFO1NBQzlELENBQUMsQ0FDSCxDQUFDO1FBQ0YsSUFBSSxDQUFDLFVBQVUsQ0FBQyxNQUFNLENBQUMsU0FBUyxDQUFDLE1BQU0sQ0FBQyxDQUFDO0lBQzNDLENBQUM7SUFFTyxTQUFTLENBQUMsTUFBd0I7UUFDeEMsSUFBSSxJQUFJLEdBQUcsTUFBTSxDQUFDLFVBQVUsQ0FBQyxLQUFLLENBQUMsQ0FBQztRQUNwQyxJQUFJLENBQUMsTUFBTSxDQUFDLElBQUksQ0FBQyxTQUFTLENBQUMsWUFBSyxDQUFDLEVBQUUsQ0FBQyxNQUFNLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxnQkFBZ0IsQ0FBQyxDQUFDLENBQUMsQ0FBQztRQUN4RixNQUFNLE1BQU0sR0FBRyxJQUFJLENBQUMsTUFBTSxDQUFDLEtBQUssQ0FBQyxDQUFDO1FBQ2xDLE9BQU8sb0JBQW9CLE1BQU0sSUFBSSxJQUFJLENBQUMsVUFBVSxDQUFDLEtBQUssRUFBRSxDQUFDO0lBQy9ELENBQUM7SUFFTywwQkFBMEI7O1FBQ2hDLElBQUksUUFBUSxDQUFDO1FBQ2IsUUFBUSxJQUFJLENBQUMsVUFBVSxDQUFDLG9CQUFvQixFQUFFO1lBQzVDLEtBQUssb0JBQW9CLENBQUMsbUJBQW1CO2dCQUMzQyxRQUFRLEdBQUcsTUFBTSxDQUFDLDZCQUE2QixDQUFDLG1CQUFtQixDQUFDO2dCQUNwRSxNQUFNO1lBQ1IsS0FBSyxvQkFBb0IsQ0FBQyxtQkFBbUIsQ0FBQztZQUM5QztnQkFDRSxRQUFRLEdBQUcsTUFBTSxDQUFDLDZCQUE2QixDQUFDLG1CQUFtQixDQUFDO2dCQUNwRSxNQUFNO1NBQ1Q7UUFDRCxJQUFJLDBCQUEwQixHQUFHLENBQUMsRUFBRSxJQUFJLEVBQUUsUUFBUSxFQUFFLEdBQUcsRUFBRSxJQUFJLENBQUMsVUFBVSxDQUFDLE1BQU0sQ0FBQyxTQUFTLEVBQUUsQ0FBQyxDQUFDO1FBQzdGLElBQUksSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLEtBQUssU0FBUyxJQUFJLElBQUksQ0FBQyxVQUFVLENBQUMsYUFBYSxLQUFLLFNBQVMsRUFBRTtZQUMzRiwwQkFBMEIsQ0FBQyxJQUFJLENBQUM7Z0JBQzlCLElBQUksRUFBRSxNQUFNLENBQUMsNkJBQTZCLENBQUMsa0JBQWtCO2dCQUM3RCxHQUFHLEVBQUUsSUFBSSxDQUFDLFVBQVUsQ0FBQyxhQUFhLENBQUMsZUFBZTthQUNuRCxDQUNBLENBQUM7WUFDRixNQUFBLElBQUksQ0FBQyxVQUFVLENBQUMsR0FBRywwQ0FBRSxhQUFhLENBQUMsSUFBSSxDQUFDLFVBQVUsQ0FBQyxVQUFVLEVBQUUsU0FBUyxDQUFDLE9BQU8sQ0FBQyxDQUFDLEVBQUUsRUFBRSxFQUFFO2dCQUN0RiwwQkFBMEIsQ0FBQyxJQUFJLENBQUMsRUFBRSxJQUFJLEVBQUUsTUFBTSxDQUFDLDZCQUE2QixDQUFDLFVBQVUsRUFBRSxHQUFHLEVBQUUsRUFBRSxFQUFFLENBQUMsQ0FBQztZQUN0RyxDQUFDLEVBQUU7U0FDSjtRQUNELE9BQU8sMEJBQTBCLENBQUM7SUFDcEMsQ0FBQzs7QUE3REgsa0VBOERDIiwic291cmNlc0NvbnRlbnQiOlsiaW1wb3J0ICogYXMgY3J5cHRvIGZyb20gJ2NyeXB0byc7XG5pbXBvcnQgeyBJU2VjdXJpdHlHcm91cCwgSVZwYywgU3VibmV0U2VsZWN0aW9uIH0gZnJvbSAnQGF3cy1jZGsvYXdzLWVjMic7XG5pbXBvcnQgKiBhcyBpYW0gZnJvbSAnQGF3cy1jZGsvYXdzLWlhbSc7XG5pbXBvcnQgKiBhcyBsYW1iZGEgZnJvbSAnQGF3cy1jZGsvYXdzLWxhbWJkYSc7XG5pbXBvcnQgKiBhcyBzZWNyZXRzbWFuYWdlciBmcm9tICdAYXdzLWNkay9hd3Mtc2VjcmV0c21hbmFnZXInO1xuaW1wb3J0IHsgU3RhY2sgfSBmcm9tICdAYXdzLWNkay9jb3JlJztcbmltcG9ydCB7IFN0cmVhbUV2ZW50U291cmNlLCBTdHJlYW1FdmVudFNvdXJjZVByb3BzIH0gZnJvbSAnLi9zdHJlYW0nO1xuXG4vLyBrZWVwIHRoaXMgaW1wb3J0IHNlcGFyYXRlIGZyb20gb3RoZXIgaW1wb3J0cyB0byByZWR1Y2UgY2hhbmNlIGZvciBtZXJnZSBjb25mbGljdHMgd2l0aCB2Mi1tYWluXG4vLyBlc2xpbnQtZGlzYWJsZS1uZXh0LWxpbmUgbm8tZHVwbGljYXRlLWltcG9ydHMsIGltcG9ydC9vcmRlclxuaW1wb3J0IHsgQ29uc3RydWN0IH0gZnJvbSAnQGF3cy1jZGsvY29yZSc7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgS2Fma2FFdmVudFNvdXJjZVByb3BzIGV4dGVuZHMgU3RyZWFtRXZlbnRTb3VyY2VQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgdG9waWM6IHN0cmluZyxcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNlY3JldDogc2VjcmV0c21hbmFnZXIuSVNlY3JldFxufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGludGVyZmFjZSBNYW5hZ2VkS2Fma2FFdmVudFNvdXJjZVByb3BzIGV4dGVuZHMgS2Fma2FFdmVudFNvdXJjZVByb3BzIHtcbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGNsdXN0ZXJBcm46IHN0cmluZztcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGVudW0gQXV0aGVudGljYXRpb25NZXRob2Qge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIFNBU0xfU0NSQU1fNTEyX0FVVEggPSAnU0FTTF9TQ1JBTV81MTJfQVVUSCcsXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgU0FTTF9TQ1JBTV8yNTZfQVVUSCA9ICdTQVNMX1NDUkFNXzI1Nl9BVVRIJyxcbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbmV4cG9ydCBpbnRlcmZhY2UgU2VsZk1hbmFnZWRLYWZrYUV2ZW50U291cmNlUHJvcHMgZXh0ZW5kcyBLYWZrYUV2ZW50U291cmNlUHJvcHMge1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IGJvb3RzdHJhcFNlcnZlcnM6IHN0cmluZ1tdXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZwYz86IElWcGM7XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHZwY1N1Ym5ldHM/OiBTdWJuZXRTZWxlY3Rpb24sXG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG4gIHJlYWRvbmx5IHNlY3VyaXR5R3JvdXA/OiBJU2VjdXJpdHlHcm91cFxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBhdXRoZW50aWNhdGlvbk1ldGhvZD86IEF1dGhlbnRpY2F0aW9uTWV0aG9kXG59XG5cbiAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgXG5leHBvcnQgY2xhc3MgTWFuYWdlZEthZmthRXZlbnRTb3VyY2UgZXh0ZW5kcyBTdHJlYW1FdmVudFNvdXJjZSB7XG4gIC8vIFRoaXMgaXMgdG8gd29yayBhcm91bmQgSlNJSSBpbmhlcml0YW5jZSBwcm9ibGVtc1xuICBwcml2YXRlIGlubmVyUHJvcHM6IE1hbmFnZWRLYWZrYUV2ZW50U291cmNlUHJvcHM7XG5cbiAgY29uc3RydWN0b3IocHJvcHM6IE1hbmFnZWRLYWZrYUV2ZW50U291cmNlUHJvcHMpIHtcbiAgICBzdXBlcihwcm9wcyk7XG4gICAgdGhpcy5pbm5lclByb3BzID0gcHJvcHM7XG4gIH1cblxuICBwdWJsaWMgYmluZCh0YXJnZXQ6IGxhbWJkYS5JRnVuY3Rpb24pIHtcbiAgICB0YXJnZXQuYWRkRXZlbnRTb3VyY2VNYXBwaW5nKFxuICAgICAgYEthZmthRXZlbnRTb3VyY2U6JHt0aGlzLmlubmVyUHJvcHMuY2x1c3RlckFybn0ke3RoaXMuaW5uZXJQcm9wcy50b3BpY31gLFxuICAgICAgdGhpcy5lbnJpY2hNYXBwaW5nT3B0aW9ucyh7XG4gICAgICAgIGV2ZW50U291cmNlQXJuOiB0aGlzLmlubmVyUHJvcHMuY2x1c3RlckFybixcbiAgICAgICAgc3RhcnRpbmdQb3NpdGlvbjogdGhpcy5pbm5lclByb3BzLnN0YXJ0aW5nUG9zaXRpb24sXG4gICAgICAgIC8vIEZyb20gaHR0cHM6Ly9kb2NzLmF3cy5hbWF6b24uY29tL21zay9sYXRlc3QvZGV2ZWxvcGVyZ3VpZGUvbXNrLXBhc3N3b3JkLmh0bWwjbXNrLXBhc3N3b3JkLWxpbWl0YXRpb25zLCBcIkFtYXpvbiBNU0sgb25seSBzdXBwb3J0cyBTQ1JBTS1TSEEtNTEyIGF1dGhlbnRpY2F0aW9uLlwiXG4gICAgICAgIHNvdXJjZUFjY2Vzc0NvbmZpZ3VyYXRpb25zOiBbeyB0eXBlOiBsYW1iZGEuU291cmNlQWNjZXNzQ29uZmlndXJhdGlvblR5cGUuU0FTTF9TQ1JBTV81MTJfQVVUSCwgdXJpOiB0aGlzLmlubmVyUHJvcHMuc2VjcmV0LnNlY3JldEFybiB9XSxcbiAgICAgICAga2Fma2FUb3BpYzogdGhpcy5pbm5lclByb3BzLnRvcGljLFxuICAgICAgfSksXG4gICAgKTtcblxuICAgIHRoaXMuaW5uZXJQcm9wcy5zZWNyZXQuZ3JhbnRSZWFkKHRhcmdldCk7XG5cbiAgICB0YXJnZXQuYWRkVG9Sb2xlUG9saWN5KG5ldyBpYW0uUG9saWN5U3RhdGVtZW50KFxuICAgICAge1xuICAgICAgICBhY3Rpb25zOiBbJ2thZmthOkRlc2NyaWJlQ2x1c3RlcicsICdrYWZrYTpHZXRCb290c3RyYXBCcm9rZXJzJywgJ2thZmthOkxpc3RTY3JhbVNlY3JldHMnXSxcbiAgICAgICAgcmVzb3VyY2VzOiBbdGhpcy5pbm5lclByb3BzLmNsdXN0ZXJBcm5dLFxuICAgICAgfSxcbiAgICApKTtcblxuICAgIHRhcmdldC5yb2xlPy5hZGRNYW5hZ2VkUG9saWN5KGlhbS5NYW5hZ2VkUG9saWN5LmZyb21Bd3NNYW5hZ2VkUG9saWN5TmFtZSgnc2VydmljZS1yb2xlL0FXU0xhbWJkYU1TS0V4ZWN1dGlvblJvbGUnKSk7XG4gIH1cbn1cblxuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIFNlbGZNYW5hZ2VkS2Fma2FFdmVudFNvdXJjZSBleHRlbmRzIFN0cmVhbUV2ZW50U291cmNlIHtcbiAgLy8gVGhpcyBpcyB0byB3b3JrIGFyb3VuZCBKU0lJIGluaGVyaXRhbmNlIHByb2JsZW1zXG4gIHByaXZhdGUgaW5uZXJQcm9wczogU2VsZk1hbmFnZWRLYWZrYUV2ZW50U291cmNlUHJvcHM7XG5cbiAgY29uc3RydWN0b3IocHJvcHM6IFNlbGZNYW5hZ2VkS2Fma2FFdmVudFNvdXJjZVByb3BzKSB7XG4gICAgc3VwZXIocHJvcHMpO1xuICAgIGlmIChwcm9wcy52cGMpIHtcbiAgICAgIGlmICghcHJvcHMuc2VjdXJpdHlHcm91cCkge1xuICAgICAgICB0aHJvdyBuZXcgRXJyb3IoJ3NlY3VyaXR5R3JvdXAgbXVzdCBiZSBzZXQgd2hlbiBwcm92aWRpbmcgdnBjJyk7XG4gICAgICB9XG4gICAgICBpZiAoIXByb3BzLnZwY1N1Ym5ldHMpIHtcbiAgICAgICAgdGhyb3cgbmV3IEVycm9yKCd2cGNTdWJuZXRzIG11c3QgYmUgc2V0IHdoZW4gcHJvdmlkaW5nIHZwYycpO1xuICAgICAgfVxuICAgIH1cbiAgICB0aGlzLmlubmVyUHJvcHMgPSBwcm9wcztcbiAgfVxuXG4gIHB1YmxpYyBiaW5kKHRhcmdldDogbGFtYmRhLklGdW5jdGlvbikge1xuICAgIGlmICghQ29uc3RydWN0LmlzQ29uc3RydWN0KHRhcmdldCkpIHsgdGhyb3cgbmV3IEVycm9yKCdGdW5jdGlvbiBpcyBub3QgYSBjb25zdHJ1Y3QuIFVuZXhwZWN0ZWQgZXJyb3IuJyk7IH1cbiAgICB0YXJnZXQuYWRkRXZlbnRTb3VyY2VNYXBwaW5nKFxuICAgICAgdGhpcy5tYXBwaW5nSWQodGFyZ2V0KSxcbiAgICAgIHRoaXMuZW5yaWNoTWFwcGluZ09wdGlvbnMoe1xuICAgICAgICBrYWZrYUJvb3RzdHJhcFNlcnZlcnM6IHRoaXMuaW5uZXJQcm9wcy5ib290c3RyYXBTZXJ2ZXJzLFxuICAgICAgICBrYWZrYVRvcGljOiB0aGlzLmlubmVyUHJvcHMudG9waWMsXG4gICAgICAgIHN0YXJ0aW5nUG9zaXRpb246IHRoaXMuaW5uZXJQcm9wcy5zdGFydGluZ1Bvc2l0aW9uLFxuICAgICAgICBzb3VyY2VBY2Nlc3NDb25maWd1cmF0aW9uczogdGhpcy5zb3VyY2VBY2Nlc3NDb25maWd1cmF0aW9ucygpLFxuICAgICAgfSksXG4gICAgKTtcbiAgICB0aGlzLmlubmVyUHJvcHMuc2VjcmV0LmdyYW50UmVhZCh0YXJnZXQpO1xuICB9XG5cbiAgcHJpdmF0ZSBtYXBwaW5nSWQodGFyZ2V0OiBsYW1iZGEuSUZ1bmN0aW9uKSB7XG4gICAgbGV0IGhhc2ggPSBjcnlwdG8uY3JlYXRlSGFzaCgnbWQ1Jyk7XG4gICAgaGFzaC51cGRhdGUoSlNPTi5zdHJpbmdpZnkoU3RhY2sub2YodGFyZ2V0KS5yZXNvbHZlKHRoaXMuaW5uZXJQcm9wcy5ib290c3RyYXBTZXJ2ZXJzKSkpO1xuICAgIGNvbnN0IGlkSGFzaCA9IGhhc2guZGlnZXN0KCdoZXgnKTtcbiAgICByZXR1cm4gYEthZmthRXZlbnRTb3VyY2U6JHtpZEhhc2h9OiR7dGhpcy5pbm5lclByb3BzLnRvcGljfWA7XG4gIH1cblxuICBwcml2YXRlIHNvdXJjZUFjY2Vzc0NvbmZpZ3VyYXRpb25zKCkge1xuICAgIGxldCBhdXRoVHlwZTtcbiAgICBzd2l0Y2ggKHRoaXMuaW5uZXJQcm9wcy5hdXRoZW50aWNhdGlvbk1ldGhvZCkge1xuICAgICAgY2FzZSBBdXRoZW50aWNhdGlvbk1ldGhvZC5TQVNMX1NDUkFNXzI1Nl9BVVRIOlxuICAgICAgICBhdXRoVHlwZSA9IGxhbWJkYS5Tb3VyY2VBY2Nlc3NDb25maWd1cmF0aW9uVHlwZS5TQVNMX1NDUkFNXzI1Nl9BVVRIO1xuICAgICAgICBicmVhaztcbiAgICAgIGNhc2UgQXV0aGVudGljYXRpb25NZXRob2QuU0FTTF9TQ1JBTV81MTJfQVVUSDpcbiAgICAgIGRlZmF1bHQ6XG4gICAgICAgIGF1dGhUeXBlID0gbGFtYmRhLlNvdXJjZUFjY2Vzc0NvbmZpZ3VyYXRpb25UeXBlLlNBU0xfU0NSQU1fNTEyX0FVVEg7XG4gICAgICAgIGJyZWFrO1xuICAgIH1cbiAgICBsZXQgc291cmNlQWNjZXNzQ29uZmlndXJhdGlvbnMgPSBbeyB0eXBlOiBhdXRoVHlwZSwgdXJpOiB0aGlzLmlubmVyUHJvcHMuc2VjcmV0LnNlY3JldEFybiB9XTtcbiAgICBpZiAodGhpcy5pbm5lclByb3BzLnZwY1N1Ym5ldHMgIT09IHVuZGVmaW5lZCAmJiB0aGlzLmlubmVyUHJvcHMuc2VjdXJpdHlHcm91cCAhPT0gdW5kZWZpbmVkKSB7XG4gICAgICBzb3VyY2VBY2Nlc3NDb25maWd1cmF0aW9ucy5wdXNoKHtcbiAgICAgICAgdHlwZTogbGFtYmRhLlNvdXJjZUFjY2Vzc0NvbmZpZ3VyYXRpb25UeXBlLlZQQ19TRUNVUklUWV9HUk9VUCxcbiAgICAgICAgdXJpOiB0aGlzLmlubmVyUHJvcHMuc2VjdXJpdHlHcm91cC5zZWN1cml0eUdyb3VwSWQsXG4gICAgICB9LFxuICAgICAgKTtcbiAgICAgIHRoaXMuaW5uZXJQcm9wcy52cGM/LnNlbGVjdFN1Ym5ldHModGhpcy5pbm5lclByb3BzLnZwY1N1Ym5ldHMpLnN1Ym5ldElkcy5mb3JFYWNoKChpZCkgPT4ge1xuICAgICAgICBzb3VyY2VBY2Nlc3NDb25maWd1cmF0aW9ucy5wdXNoKHsgdHlwZTogbGFtYmRhLlNvdXJjZUFjY2Vzc0NvbmZpZ3VyYXRpb25UeXBlLlZQQ19TVUJORVQsIHVyaTogaWQgfSk7XG4gICAgICB9KTtcbiAgICB9XG4gICAgcmV0dXJuIHNvdXJjZUFjY2Vzc0NvbmZpZ3VyYXRpb25zO1xuICB9XG59XG4iXX0=