import setuptools
with open("README.md", "r", encoding="utf-8") as fh:
    long_description = fh.read()

setuptools.setup(
    name="mapyllary", # Replace with your own username
    version="0.0.5",
    author="Boyce Tsang",
    author_email="boyce.tsang@gmail.com",
    description="Unofficial Mapillary API",
    long_description=long_description,
    long_description_content_type="text/markdown",
    url="https://github.com/boycetsang/mapyllary/blob/main/README.md",
    packages=setuptools.find_packages(include=['mapyllary']),
    classifiers=[
        "Programming Language :: Python :: 3",
        "License :: OSI Approved :: MIT License",
        "Operating System :: OS Independent",
    ],
    python_requires='>=3.5',
    # install_reqs = parse_requirements('requirements.txt', session='hack')

    install_requires=[
    'absl-py==0.11.0',
    'argon2-cffi==20.1.0',
    'astunparse==1.6.3',
    'attrs==20.3.0',
    'backcall==0.2.0',
    'beautifulsoup4==4.9.3',
    'bleach==3.2.1',
    'bs4==0.0.1',
    'cachetools==4.1.1',
    'certifi==2020.12.5',
    'cffi==1.14.4',
    'chardet==3.0.4',
    'colorlog==4.7.2',
    'cycler==0.10.0',
    'decorator==4.4.2',
    'defusedxml==0.6.0',
    'docutils==0.16',
    'entrypoints==0.3',
    'flatbuffers==1.12',
    'gast==0.3.3',
    'google-auth==1.23.0',
    'google-auth-oauthlib==0.4.1',
    'google-pasta==0.2.0',
    'grpcio==1.34.0',
    'h5py==2.10.0',
    'html5lib==1.1',
    'idna==2.10',
    'imageio==2.9.0',
    'importlib-metadata==2.1.1',
    'imutils==0.5.3',
    'ipdb==0.13.4',
    'ipykernel==5.4.2',
    'ipython==7.9.0',
    'ipython-genutils==0.2.0',
    'ipywidgets==7.5.1',
    'jedi==0.17.2',
    'Jinja2==2.11.2',
    'joblib==0.14.1',
    'jsonschema==3.2.0',
    'jupyter==1.0.0',
    'jupyter-client==6.1.7',
    'jupyter-console==6.1.0',
    'jupyter-core==4.6.3',
    'Keras==2.4.3',
    'Keras-Preprocessing==1.1.2',
    'kiwisolver==1.1.0',
    'matplotlib==3.0.3',
    'mistune==0.8.4',
    'nbconvert==5.6.1',
    'nbformat==5.0.8',
    'networkx==2.4',
    'notebook==6.1.5',
    'numpy==1.18.5',
    'oauthlib==3.1.0',
    'opt-einsum==3.3.0',
    'overpy==0.4',
    'opencv-python',
    'packaging==20.8',
    'pandas==0.24.2',
    'pandocfilters==1.4.3',
    'parso==0.7.1',
    'pexpect==4.8.0',
    'pickleshare==0.7.5',
    'Pillow',
    'pkginfo==1.7.0',
    'portpicker==1.3.1',
    'prometheus-client==0.9.0',
    'prompt-toolkit==2.0.10',
    'protobuf==3.14.0',
    'ptyprocess==0.6.0',
    'pyasn1==0.4.8',
    'pyasn1-modules==0.2.8',
    'pycparser==2.20',
    'Pygments==2.7.3',
    'pyparsing==2.4.7',
    'pyrsistent==0.17.3',
    'python-dateutil==2.8.1',
    'pytz==2020.4',
    'PyYAML==5.3.1',
    'pyzmq==20.0.0',
    'readline==6.2.4.1',
    'readme-renderer==28.0',
    'requests==2.25.0',
    'requests-oauthlib==1.3.0',
    'requests-toolbelt==0.9.1',
    'rsa==4.6',
    'scikit-image==0.15.0',
    'scikit-learn==0.22.2.post1',
    'scipy==1.4.1',
    'Send2Trash==1.5.0',
    'six==1.15.0',
    'soupsieve==2.1',
    'tensorboard==2.4.0',
    'tensorboard-plugin-wit==1.7.0',
    'tensorflow==2.3.1',
    'tensorflow-estimator==2.3.0',
    'termcolor==1.1.0',
    'terminado==0.8.3',
    'testpath==0.4.4',
    'tk==0.1.0',
    'tornado==6.1',
    'tqdm==4.56.0',
    'traitlets==4.3.3',
    'typing-extensions==3.7.4.3',
    'urllib3',
    'wcwidth==0.2.5',
    'webencodings==0.5.1',
    'Werkzeug==1.0.1',
    'widgetsnbextension==3.5.1',
    'wrapt==1.12.1',
    'zipp==1.2.0',
    ]
)