# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import Dict, List, Optional, Union

import msrest.serialization

from ._compute_management_client_enums import *


class ApiError(msrest.serialization.Model):
    """Api error.

    :param details: The Api error details.
    :type details: list[~azure.mgmt.compute.v2021_03_01.models.ApiErrorBase]
    :param innererror: The Api inner error.
    :type innererror: ~azure.mgmt.compute.v2021_03_01.models.InnerError
    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    :param target: The target of the particular error.
    :type target: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["ApiErrorBase"]] = None,
        innererror: Optional["InnerError"] = None,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.message = message
        self.target = target


class ApiErrorBase(msrest.serialization.Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param message: The error message.
    :type message: str
    :param target: The target of the particular error.
    :type target: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        message: Optional[str] = None,
        target: Optional[str] = None,
        **kwargs
    ):
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.message = message
        self.target = target


class CloudService(msrest.serialization.Model):
    """Describes the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param properties: Cloud service properties.
    :type properties: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'properties': {'key': 'properties', 'type': 'CloudServiceProperties'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        properties: Optional["CloudServiceProperties"] = None,
        **kwargs
    ):
        super(CloudService, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags
        self.properties = properties


class CloudServiceExtensionProfile(msrest.serialization.Model):
    """Describes a cloud service extension profile.

    :param extensions: List of extensions for the cloud service.
    :type extensions: list[~azure.mgmt.compute.v2021_03_01.models.Extension]
    """

    _attribute_map = {
        'extensions': {'key': 'extensions', 'type': '[Extension]'},
    }

    def __init__(
        self,
        *,
        extensions: Optional[List["Extension"]] = None,
        **kwargs
    ):
        super(CloudServiceExtensionProfile, self).__init__(**kwargs)
        self.extensions = extensions


class CloudServiceExtensionProperties(msrest.serialization.Model):
    """Extension Properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension.
    :type type: str
    :param type_handler_version: Specifies the version of the extension. Specifies the version of
     the extension. If this element is not specified or an asterisk (*) is used as the value, the
     latest version of the extension is used. If the value is specified with a major version number
     and an asterisk as the minor version number (X.), the latest minor version of the specified
     major version is selected. If a major version number and a minor version number are specified
     (X.Y), the specific extension version is selected. If a version is specified, an auto-upgrade
     is performed on the role instance.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Explicitly specify whether platform can automatically
     upgrade typeHandlerVersion to higher minor versions when they become available.
    :type auto_upgrade_minor_version: bool
    :param settings: Public settings for the extension. For JSON extensions, this is the JSON
     settings for the extension. For XML Extension (like RDP), this is the XML setting for the
     extension.
    :type settings: str
    :param protected_settings: Protected settings for the extension which are encrypted before sent
     to the role instance.
    :type protected_settings: str
    :param protected_settings_from_key_vault:
    :type protected_settings_from_key_vault:
     ~azure.mgmt.compute.v2021_03_01.models.CloudServiceVaultAndSecretReference
    :param force_update_tag: Tag to force apply the provided public and protected settings.
     Changing the tag value allows for re-running the extension without changing any of the public
     or protected settings.
     If forceUpdateTag is not changed, updates to public or protected settings would still be
     applied by the handler.
     If neither forceUpdateTag nor any of public or protected settings change, extension would flow
     to the role instance with the same sequence-number, and
     it is up to handler implementation whether to re-run it or not.
    :type force_update_tag: str
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param roles_applied_to: Optional list of roles to apply this extension. If property is not
     specified or '*' is specified, extension is applied to all roles in the cloud service.
    :type roles_applied_to: list[str]
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'settings', 'type': 'str'},
        'protected_settings': {'key': 'protectedSettings', 'type': 'str'},
        'protected_settings_from_key_vault': {'key': 'protectedSettingsFromKeyVault', 'type': 'CloudServiceVaultAndSecretReference'},
        'force_update_tag': {'key': 'forceUpdateTag', 'type': 'str'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'roles_applied_to': {'key': 'rolesAppliedTo', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[str] = None,
        protected_settings: Optional[str] = None,
        protected_settings_from_key_vault: Optional["CloudServiceVaultAndSecretReference"] = None,
        force_update_tag: Optional[str] = None,
        roles_applied_to: Optional[List[str]] = None,
        **kwargs
    ):
        super(CloudServiceExtensionProperties, self).__init__(**kwargs)
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.protected_settings_from_key_vault = protected_settings_from_key_vault
        self.force_update_tag = force_update_tag
        self.provisioning_state = None
        self.roles_applied_to = roles_applied_to


class CloudServiceInstanceView(msrest.serialization.Model):
    """InstanceView of CloudService as a whole.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param role_instance: Instance view statuses.
    :type role_instance: ~azure.mgmt.compute.v2021_03_01.models.InstanceViewStatusesSummary
    :ivar sdk_version: The version of the SDK that was used to generate the package for the cloud
     service.
    :vartype sdk_version: str
    :ivar private_ids: Specifies a list of unique identifiers generated internally for the cloud
     service. :code:`<br />`:code:`<br />` NOTE: If you are using Azure Diagnostics extension, this
     property can be used as 'DeploymentId' for querying details.
    :vartype private_ids: list[str]
    :ivar statuses:
    :vartype statuses: list[~azure.mgmt.compute.v2021_03_01.models.ResourceInstanceViewStatus]
    """

    _validation = {
        'sdk_version': {'readonly': True},
        'private_ids': {'readonly': True},
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'role_instance': {'key': 'roleInstance', 'type': 'InstanceViewStatusesSummary'},
        'sdk_version': {'key': 'sdkVersion', 'type': 'str'},
        'private_ids': {'key': 'privateIds', 'type': '[str]'},
        'statuses': {'key': 'statuses', 'type': '[ResourceInstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        role_instance: Optional["InstanceViewStatusesSummary"] = None,
        **kwargs
    ):
        super(CloudServiceInstanceView, self).__init__(**kwargs)
        self.role_instance = role_instance
        self.sdk_version = None
        self.private_ids = None
        self.statuses = None


class CloudServiceListResult(msrest.serialization.Model):
    """CloudServiceListResult.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.compute.v2021_03_01.models.CloudService]
    :param next_link:
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CloudService]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CloudService"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CloudServiceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceNetworkProfile(msrest.serialization.Model):
    """Network Profile for the cloud service.

    :param load_balancer_configurations: List of Load balancer configurations. Cloud service can
     have up to two load balancer configurations, corresponding to a Public Load Balancer and an
     Internal Load Balancer.
    :type load_balancer_configurations:
     list[~azure.mgmt.compute.v2021_03_01.models.LoadBalancerConfiguration]
    :param swappable_cloud_service: The id reference of the cloud service containing the target IP
     with which the subject cloud service can perform a swap. This property cannot be updated once
     it is set. The swappable cloud service referred by this id must be present otherwise an error
     will be thrown.
    :type swappable_cloud_service: ~azure.mgmt.compute.v2021_03_01.models.SubResource
    """

    _attribute_map = {
        'load_balancer_configurations': {'key': 'loadBalancerConfigurations', 'type': '[LoadBalancerConfiguration]'},
        'swappable_cloud_service': {'key': 'swappableCloudService', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        load_balancer_configurations: Optional[List["LoadBalancerConfiguration"]] = None,
        swappable_cloud_service: Optional["SubResource"] = None,
        **kwargs
    ):
        super(CloudServiceNetworkProfile, self).__init__(**kwargs)
        self.load_balancer_configurations = load_balancer_configurations
        self.swappable_cloud_service = swappable_cloud_service


class CloudServiceOsProfile(msrest.serialization.Model):
    """Describes the OS profile for the cloud service.

    :param secrets: Specifies set of certificates that should be installed onto the role instances.
    :type secrets: list[~azure.mgmt.compute.v2021_03_01.models.CloudServiceVaultSecretGroup]
    """

    _attribute_map = {
        'secrets': {'key': 'secrets', 'type': '[CloudServiceVaultSecretGroup]'},
    }

    def __init__(
        self,
        *,
        secrets: Optional[List["CloudServiceVaultSecretGroup"]] = None,
        **kwargs
    ):
        super(CloudServiceOsProfile, self).__init__(**kwargs)
        self.secrets = secrets


class CloudServiceProperties(msrest.serialization.Model):
    """Cloud service properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param package_url: Specifies a URL that refers to the location of the service package in the
     Blob service. The service package URL can be Shared Access Signature (SAS) URI from any storage
     account.
     This is a write-only property and is not returned in GET calls.
    :type package_url: str
    :param configuration: Specifies the XML service configuration (.cscfg) for the cloud service.
    :type configuration: str
    :param configuration_url: Specifies a URL that refers to the location of the service
     configuration in the Blob service. The service package URL  can be Shared Access Signature
     (SAS) URI from any storage account.
     This is a write-only property and is not returned in GET calls.
    :type configuration_url: str
    :param start_cloud_service: (Optional) Indicates whether to start the cloud service immediately
     after it is created. The default value is ``true``.
     If false, the service model is still deployed, but the code is not run immediately. Instead,
     the service is PoweredOff until you call Start, at which time the service will be started. A
     deployed service still incurs charges, even if it is poweredoff.
    :type start_cloud_service: bool
    :param allow_model_override: (Optional) Indicates whether the role sku properties
     (roleProfile.roles.sku) specified in the model/template should override the role instance count
     and vm size specified in the .cscfg and .csdef respectively.
     The default value is ``false``.
    :type allow_model_override: bool
    :param upgrade_mode: Update mode for the cloud service. Role instances are allocated to update
     domains when the service is deployed. Updates can be initiated manually in each update domain
     or initiated automatically in all update domains.
     Possible Values are :code:`<br />`:code:`<br />`\ **Auto**\ :code:`<br />`:code:`<br />`\
     **Manual** :code:`<br />`:code:`<br />`\ **Simultaneous**\ :code:`<br />`:code:`<br />`
     If not specified, the default value is Auto. If set to Manual, PUT UpdateDomain must be called
     to apply the update. If set to Auto, the update is automatically applied to each update domain
     in sequence. Possible values include: "Auto", "Manual", "Simultaneous".
    :type upgrade_mode: str or ~azure.mgmt.compute.v2021_03_01.models.CloudServiceUpgradeMode
    :param role_profile: Describes the role profile for the cloud service.
    :type role_profile: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceRoleProfile
    :param os_profile: Describes the OS profile for the cloud service.
    :type os_profile: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceOsProfile
    :param network_profile: Network Profile for the cloud service.
    :type network_profile: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceNetworkProfile
    :param extension_profile: Describes a cloud service extension profile.
    :type extension_profile: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceExtensionProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar unique_id: The unique identifier for the cloud service.
    :vartype unique_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'unique_id': {'readonly': True},
    }

    _attribute_map = {
        'package_url': {'key': 'packageUrl', 'type': 'str'},
        'configuration': {'key': 'configuration', 'type': 'str'},
        'configuration_url': {'key': 'configurationUrl', 'type': 'str'},
        'start_cloud_service': {'key': 'startCloudService', 'type': 'bool'},
        'allow_model_override': {'key': 'allowModelOverride', 'type': 'bool'},
        'upgrade_mode': {'key': 'upgradeMode', 'type': 'str'},
        'role_profile': {'key': 'roleProfile', 'type': 'CloudServiceRoleProfile'},
        'os_profile': {'key': 'osProfile', 'type': 'CloudServiceOsProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'CloudServiceNetworkProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'CloudServiceExtensionProfile'},
        'provisioning_state': {'key': 'provisioningState', 'type': 'str'},
        'unique_id': {'key': 'uniqueId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        package_url: Optional[str] = None,
        configuration: Optional[str] = None,
        configuration_url: Optional[str] = None,
        start_cloud_service: Optional[bool] = None,
        allow_model_override: Optional[bool] = None,
        upgrade_mode: Optional[Union[str, "CloudServiceUpgradeMode"]] = None,
        role_profile: Optional["CloudServiceRoleProfile"] = None,
        os_profile: Optional["CloudServiceOsProfile"] = None,
        network_profile: Optional["CloudServiceNetworkProfile"] = None,
        extension_profile: Optional["CloudServiceExtensionProfile"] = None,
        **kwargs
    ):
        super(CloudServiceProperties, self).__init__(**kwargs)
        self.package_url = package_url
        self.configuration = configuration
        self.configuration_url = configuration_url
        self.start_cloud_service = start_cloud_service
        self.allow_model_override = allow_model_override
        self.upgrade_mode = upgrade_mode
        self.role_profile = role_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.extension_profile = extension_profile
        self.provisioning_state = None
        self.unique_id = None


class CloudServiceRole(msrest.serialization.Model):
    """Describes a role of the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param sku: Describes the cloud service role sku.
    :type sku: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceRoleSku
    :param properties:
    :type properties: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceRoleProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'CloudServiceRoleSku'},
        'properties': {'key': 'properties', 'type': 'CloudServiceRoleProperties'},
    }

    def __init__(
        self,
        *,
        sku: Optional["CloudServiceRoleSku"] = None,
        properties: Optional["CloudServiceRoleProperties"] = None,
        **kwargs
    ):
        super(CloudServiceRole, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.sku = sku
        self.properties = properties


class CloudServiceRoleListResult(msrest.serialization.Model):
    """CloudServiceRoleListResult.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.compute.v2021_03_01.models.CloudServiceRole]
    :param next_link:
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[CloudServiceRole]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["CloudServiceRole"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(CloudServiceRoleListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class CloudServiceRoleProfile(msrest.serialization.Model):
    """Describes the role profile for the cloud service.

    :param roles: List of roles for the cloud service.
    :type roles: list[~azure.mgmt.compute.v2021_03_01.models.CloudServiceRoleProfileProperties]
    """

    _attribute_map = {
        'roles': {'key': 'roles', 'type': '[CloudServiceRoleProfileProperties]'},
    }

    def __init__(
        self,
        *,
        roles: Optional[List["CloudServiceRoleProfileProperties"]] = None,
        **kwargs
    ):
        super(CloudServiceRoleProfile, self).__init__(**kwargs)
        self.roles = roles


class CloudServiceRoleProfileProperties(msrest.serialization.Model):
    """Describes the role properties.

    :param name: Resource name.
    :type name: str
    :param sku: Describes the cloud service role sku.
    :type sku: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceRoleSku
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'CloudServiceRoleSku'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        sku: Optional["CloudServiceRoleSku"] = None,
        **kwargs
    ):
        super(CloudServiceRoleProfileProperties, self).__init__(**kwargs)
        self.name = name
        self.sku = sku


class CloudServiceRoleProperties(msrest.serialization.Model):
    """CloudServiceRoleProperties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar unique_id: Specifies the ID which uniquely identifies a cloud service role.
    :vartype unique_id: str
    """

    _validation = {
        'unique_id': {'readonly': True},
    }

    _attribute_map = {
        'unique_id': {'key': 'uniqueId', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(CloudServiceRoleProperties, self).__init__(**kwargs)
        self.unique_id = None


class CloudServiceRoleSku(msrest.serialization.Model):
    """Describes the cloud service role sku.

    :param name: The sku name. NOTE: If the new SKU is not supported on the hardware the cloud
     service is currently on, you need to delete and recreate the cloud service or move back to the
     old sku.
    :type name: str
    :param tier: Specifies the tier of the cloud service. Possible Values are :code:`<br
     />`:code:`<br />` **Standard** :code:`<br />`:code:`<br />` **Basic**.
    :type tier: str
    :param capacity: Specifies the number of role instances in the cloud service.
    :type capacity: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(CloudServiceRoleSku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class CloudServiceUpdate(msrest.serialization.Model):
    """CloudServiceUpdate.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(CloudServiceUpdate, self).__init__(**kwargs)
        self.tags = tags


class CloudServiceVaultAndSecretReference(msrest.serialization.Model):
    """CloudServiceVaultAndSecretReference.

    :param source_vault:
    :type source_vault: ~azure.mgmt.compute.v2021_03_01.models.SubResource
    :param secret_url:
    :type secret_url: str
    """

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["SubResource"] = None,
        secret_url: Optional[str] = None,
        **kwargs
    ):
        super(CloudServiceVaultAndSecretReference, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class CloudServiceVaultCertificate(msrest.serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the role instance.

    :param certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret.
    :type certificate_url: str
    """

    _attribute_map = {
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate_url: Optional[str] = None,
        **kwargs
    ):
        super(CloudServiceVaultCertificate, self).__init__(**kwargs)
        self.certificate_url = certificate_url


class CloudServiceVaultSecretGroup(msrest.serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :param source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :type source_vault: ~azure.mgmt.compute.v2021_03_01.models.SubResource
    :param vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :type vault_certificates:
     list[~azure.mgmt.compute.v2021_03_01.models.CloudServiceVaultCertificate]
    """

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'vault_certificates': {'key': 'vaultCertificates', 'type': '[CloudServiceVaultCertificate]'},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["SubResource"] = None,
        vault_certificates: Optional[List["CloudServiceVaultCertificate"]] = None,
        **kwargs
    ):
        super(CloudServiceVaultSecretGroup, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class Extension(msrest.serialization.Model):
    """Describes a cloud service Extension.

    :param name: The name of the extension.
    :type name: str
    :param properties: Extension Properties.
    :type properties: ~azure.mgmt.compute.v2021_03_01.models.CloudServiceExtensionProperties
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'CloudServiceExtensionProperties'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        properties: Optional["CloudServiceExtensionProperties"] = None,
        **kwargs
    ):
        super(Extension, self).__init__(**kwargs)
        self.name = name
        self.properties = properties


class InnerError(msrest.serialization.Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exceptiontype: Optional[str] = None,
        errordetail: Optional[str] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceSku(msrest.serialization.Model):
    """InstanceSku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The sku name.
    :vartype name: str
    :ivar tier: The tier of the cloud service role instance.
    :vartype tier: str
    """

    _validation = {
        'name': {'readonly': True},
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstanceSku, self).__init__(**kwargs)
        self.name = None
        self.tier = None


class InstanceViewStatusesSummary(msrest.serialization.Model):
    """Instance view statuses.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary:
    :vartype statuses_summary: list[~azure.mgmt.compute.v2021_03_01.models.StatusCodeCount]
    """

    _validation = {
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'statuses_summary': {'key': 'statusesSummary', 'type': '[StatusCodeCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(InstanceViewStatusesSummary, self).__init__(**kwargs)
        self.statuses_summary = None


class LoadBalancerConfiguration(msrest.serialization.Model):
    """Describes the load balancer configuration.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The name of the Load balancer.
    :type name: str
    :param properties: Required. Properties of the load balancer configuration.
    :type properties: ~azure.mgmt.compute.v2021_03_01.models.LoadBalancerConfigurationProperties
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LoadBalancerConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        name: str,
        properties: "LoadBalancerConfigurationProperties",
        id: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancerConfiguration, self).__init__(**kwargs)
        self.id = id
        self.name = name
        self.properties = properties


class LoadBalancerConfigurationProperties(msrest.serialization.Model):
    """LoadBalancerConfigurationProperties.

    All required parameters must be populated in order to send to Azure.

    :param frontend_ip_configurations: Required. Specifies the frontend IP to be used for the load
     balancer. Only IPv4 frontend IP address is supported. Each load balancer configuration must
     have exactly one frontend IP configuration.
    :type frontend_ip_configurations:
     list[~azure.mgmt.compute.v2021_03_01.models.LoadBalancerFrontendIPConfiguration]
    """

    _validation = {
        'frontend_ip_configurations': {'required': True},
    }

    _attribute_map = {
        'frontend_ip_configurations': {'key': 'frontendIPConfigurations', 'type': '[LoadBalancerFrontendIPConfiguration]'},
    }

    def __init__(
        self,
        *,
        frontend_ip_configurations: List["LoadBalancerFrontendIPConfiguration"],
        **kwargs
    ):
        super(LoadBalancerConfigurationProperties, self).__init__(**kwargs)
        self.frontend_ip_configurations = frontend_ip_configurations


class LoadBalancerFrontendIPConfiguration(msrest.serialization.Model):
    """LoadBalancerFrontendIPConfiguration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The name of the resource that is unique within the set of frontend IP
     configurations used by the load balancer. This name can be used to access the resource.
    :type name: str
    :param properties: Required. Properties of load balancer frontend ip configuration.
    :type properties:
     ~azure.mgmt.compute.v2021_03_01.models.LoadBalancerFrontendIPConfigurationProperties
    """

    _validation = {
        'name': {'required': True},
        'properties': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'LoadBalancerFrontendIPConfigurationProperties'},
    }

    def __init__(
        self,
        *,
        name: str,
        properties: "LoadBalancerFrontendIPConfigurationProperties",
        **kwargs
    ):
        super(LoadBalancerFrontendIPConfiguration, self).__init__(**kwargs)
        self.name = name
        self.properties = properties


class LoadBalancerFrontendIPConfigurationProperties(msrest.serialization.Model):
    """Describes a cloud service IP Configuration.

    :param public_ip_address: The reference to the public ip address resource.
    :type public_ip_address: ~azure.mgmt.compute.v2021_03_01.models.SubResource
    :param subnet: The reference to the virtual network subnet resource.
    :type subnet: ~azure.mgmt.compute.v2021_03_01.models.SubResource
    :param private_ip_address: The virtual network private IP address of the IP configuration.
    :type private_ip_address: str
    """

    _attribute_map = {
        'public_ip_address': {'key': 'publicIPAddress', 'type': 'SubResource'},
        'subnet': {'key': 'subnet', 'type': 'SubResource'},
        'private_ip_address': {'key': 'privateIPAddress', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        public_ip_address: Optional["SubResource"] = None,
        subnet: Optional["SubResource"] = None,
        private_ip_address: Optional[str] = None,
        **kwargs
    ):
        super(LoadBalancerFrontendIPConfigurationProperties, self).__init__(**kwargs)
        self.public_ip_address = public_ip_address
        self.subnet = subnet
        self.private_ip_address = private_ip_address


class OSFamily(msrest.serialization.Model):
    """Describes a cloud service OS family.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param properties: OS family properties.
    :type properties: ~azure.mgmt.compute.v2021_03_01.models.OSFamilyProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OSFamilyProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["OSFamilyProperties"] = None,
        **kwargs
    ):
        super(OSFamily, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class OSFamilyListResult(msrest.serialization.Model):
    """OSFamilyListResult.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.compute.v2021_03_01.models.OSFamily]
    :param next_link:
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OSFamily]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["OSFamily"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OSFamilyListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSFamilyProperties(msrest.serialization.Model):
    """OS family properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The OS family name.
    :vartype name: str
    :ivar label: The OS family label.
    :vartype label: str
    :ivar versions: List of OS versions belonging to this family.
    :vartype versions: list[~azure.mgmt.compute.v2021_03_01.models.OSVersionPropertiesBase]
    """

    _validation = {
        'name': {'readonly': True},
        'label': {'readonly': True},
        'versions': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'versions': {'key': 'versions', 'type': '[OSVersionPropertiesBase]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSFamilyProperties, self).__init__(**kwargs)
        self.name = None
        self.label = None
        self.versions = None


class OSVersion(msrest.serialization.Model):
    """Describes a cloud service OS version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    :param properties: OS version properties.
    :type properties: ~azure.mgmt.compute.v2021_03_01.models.OSVersionProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'properties': {'key': 'properties', 'type': 'OSVersionProperties'},
    }

    def __init__(
        self,
        *,
        properties: Optional["OSVersionProperties"] = None,
        **kwargs
    ):
        super(OSVersion, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.properties = properties


class OSVersionListResult(msrest.serialization.Model):
    """OSVersionListResult.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.compute.v2021_03_01.models.OSVersion]
    :param next_link:
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[OSVersion]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["OSVersion"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(OSVersionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class OSVersionProperties(msrest.serialization.Model):
    """OS version properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar family: The family of this OS version.
    :vartype family: str
    :ivar family_label: The family label of this OS version.
    :vartype family_label: str
    :ivar version: The OS version.
    :vartype version: str
    :ivar label: The OS version label.
    :vartype label: str
    :ivar is_default: Specifies whether this is the default OS version for its family.
    :vartype is_default: bool
    :ivar is_active: Specifies whether this OS version is active.
    :vartype is_active: bool
    """

    _validation = {
        'family': {'readonly': True},
        'family_label': {'readonly': True},
        'version': {'readonly': True},
        'label': {'readonly': True},
        'is_default': {'readonly': True},
        'is_active': {'readonly': True},
    }

    _attribute_map = {
        'family': {'key': 'family', 'type': 'str'},
        'family_label': {'key': 'familyLabel', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSVersionProperties, self).__init__(**kwargs)
        self.family = None
        self.family_label = None
        self.version = None
        self.label = None
        self.is_default = None
        self.is_active = None


class OSVersionPropertiesBase(msrest.serialization.Model):
    """Configuration view of an OS version.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar version: The OS version.
    :vartype version: str
    :ivar label: The OS version label.
    :vartype label: str
    :ivar is_default: Specifies whether this is the default OS version for its family.
    :vartype is_default: bool
    :ivar is_active: Specifies whether this OS version is active.
    :vartype is_active: bool
    """

    _validation = {
        'version': {'readonly': True},
        'label': {'readonly': True},
        'is_default': {'readonly': True},
        'is_active': {'readonly': True},
    }

    _attribute_map = {
        'version': {'key': 'version', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'is_default': {'key': 'isDefault', 'type': 'bool'},
        'is_active': {'key': 'isActive', 'type': 'bool'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(OSVersionPropertiesBase, self).__init__(**kwargs)
        self.version = None
        self.label = None
        self.is_default = None
        self.is_active = None


class ResourceInstanceViewStatus(msrest.serialization.Model):
    """Instance view status.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The status code.
    :vartype code: str
    :ivar display_status: The short localizable label for the status.
    :vartype display_status: str
    :ivar message: The detailed status message, including for alerts and error messages.
    :vartype message: str
    :ivar time: The time of the status.
    :vartype time: ~datetime.datetime
    :param level: The level code. Possible values include: "Info", "Warning", "Error".
    :type level: str or ~azure.mgmt.compute.v2021_03_01.models.StatusLevelTypes
    """

    _validation = {
        'code': {'readonly': True},
        'display_status': {'readonly': True},
        'message': {'readonly': True},
        'time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
        'level': {'key': 'level', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        level: Optional[Union[str, "StatusLevelTypes"]] = None,
        **kwargs
    ):
        super(ResourceInstanceViewStatus, self).__init__(**kwargs)
        self.code = None
        self.display_status = None
        self.message = None
        self.time = None
        self.level = level


class RoleInstance(msrest.serialization.Model):
    """RoleInstance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    :ivar type: Resource Type.
    :vartype type: str
    :ivar location: Resource Location.
    :vartype location: str
    :ivar tags: A set of tags. Resource tags.
    :vartype tags: dict[str, str]
    :param sku:
    :type sku: ~azure.mgmt.compute.v2021_03_01.models.InstanceSku
    :param properties:
    :type properties: ~azure.mgmt.compute.v2021_03_01.models.RoleInstanceProperties
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
        'tags': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'InstanceSku'},
        'properties': {'key': 'properties', 'type': 'RoleInstanceProperties'},
    }

    def __init__(
        self,
        *,
        sku: Optional["InstanceSku"] = None,
        properties: Optional["RoleInstanceProperties"] = None,
        **kwargs
    ):
        super(RoleInstance, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = None
        self.tags = None
        self.sku = sku
        self.properties = properties


class RoleInstanceListResult(msrest.serialization.Model):
    """RoleInstanceListResult.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.compute.v2021_03_01.models.RoleInstance]
    :param next_link:
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RoleInstance]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["RoleInstance"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RoleInstanceListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RoleInstanceNetworkProfile(msrest.serialization.Model):
    """Describes the network profile for the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the role instance.
    :vartype network_interfaces: list[~azure.mgmt.compute.v2021_03_01.models.SubResource]
    """

    _validation = {
        'network_interfaces': {'readonly': True},
    }

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleInstanceNetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = None


class RoleInstanceProperties(msrest.serialization.Model):
    """RoleInstanceProperties.

    :param network_profile: Describes the network profile for the role instance.
    :type network_profile: ~azure.mgmt.compute.v2021_03_01.models.RoleInstanceNetworkProfile
    :param instance_view: The instance view of the role instance.
    :type instance_view: ~azure.mgmt.compute.v2021_03_01.models.RoleInstanceView
    """

    _attribute_map = {
        'network_profile': {'key': 'networkProfile', 'type': 'RoleInstanceNetworkProfile'},
        'instance_view': {'key': 'instanceView', 'type': 'RoleInstanceView'},
    }

    def __init__(
        self,
        *,
        network_profile: Optional["RoleInstanceNetworkProfile"] = None,
        instance_view: Optional["RoleInstanceView"] = None,
        **kwargs
    ):
        super(RoleInstanceProperties, self).__init__(**kwargs)
        self.network_profile = network_profile
        self.instance_view = instance_view


class RoleInstances(msrest.serialization.Model):
    """Specifies a list of role instances from the cloud service.

    All required parameters must be populated in order to send to Azure.

    :param role_instances: Required. List of cloud service role instance names. Value of '*' will
     signify all role instances of the cloud service.
    :type role_instances: list[str]
    """

    _validation = {
        'role_instances': {'required': True},
    }

    _attribute_map = {
        'role_instances': {'key': 'roleInstances', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        role_instances: List[str],
        **kwargs
    ):
        super(RoleInstances, self).__init__(**kwargs)
        self.role_instances = role_instances


class RoleInstanceView(msrest.serialization.Model):
    """The instance view of the role instance.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar platform_update_domain: The Update Domain.
    :vartype platform_update_domain: int
    :ivar platform_fault_domain: The Fault Domain.
    :vartype platform_fault_domain: int
    :ivar private_id: Specifies a unique identifier generated internally for the cloud service
     associated with this role instance. :code:`<br />`:code:`<br />` NOTE: If you are using Azure
     Diagnostics extension, this property can be used as 'DeploymentId' for querying details.
    :vartype private_id: str
    :ivar statuses:
    :vartype statuses: list[~azure.mgmt.compute.v2021_03_01.models.ResourceInstanceViewStatus]
    """

    _validation = {
        'platform_update_domain': {'readonly': True},
        'platform_fault_domain': {'readonly': True},
        'private_id': {'readonly': True},
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'private_id': {'key': 'privateId', 'type': 'str'},
        'statuses': {'key': 'statuses', 'type': '[ResourceInstanceViewStatus]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RoleInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = None
        self.platform_fault_domain = None
        self.private_id = None
        self.statuses = None


class StatusCodeCount(msrest.serialization.Model):
    """StatusCodeCount.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: Number of instances having this status code.
    :vartype count: int
    """

    _validation = {
        'code': {'readonly': True},
        'count': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(StatusCodeCount, self).__init__(**kwargs)
        self.code = None
        self.count = None


class SubResource(msrest.serialization.Model):
    """SubResource.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class UpdateDomain(msrest.serialization.Model):
    """Defines an update domain for the cloud service.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource Name.
    :vartype name: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpdateDomain, self).__init__(**kwargs)
        self.id = None
        self.name = None


class UpdateDomainListResult(msrest.serialization.Model):
    """UpdateDomainListResult.

    All required parameters must be populated in order to send to Azure.

    :param value: Required.
    :type value: list[~azure.mgmt.compute.v2021_03_01.models.UpdateDomain]
    :param next_link:
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpdateDomain]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["UpdateDomain"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(UpdateDomainListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link
