# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

from typing import TYPE_CHECKING

from azure.mgmt.core import ARMPipelineClient
from msrest import Deserializer, Serializer

if TYPE_CHECKING:
    # pylint: disable=unused-import,ungrouped-imports
    from typing import Any, Optional

    from azure.core.credentials import TokenCredential

from ._configuration import ComputeManagementClientConfiguration
from .operations import CloudServiceRoleInstancesOperations
from .operations import CloudServiceRolesOperations
from .operations import CloudServicesOperations
from .operations import CloudServicesUpdateDomainOperations
from .operations import CloudServiceOperatingSystemsOperations
from . import models


class ComputeManagementClient(object):
    """Compute Client.

    :ivar cloud_service_role_instances: CloudServiceRoleInstancesOperations operations
    :vartype cloud_service_role_instances: azure.mgmt.compute.v2021_03_01.operations.CloudServiceRoleInstancesOperations
    :ivar cloud_service_roles: CloudServiceRolesOperations operations
    :vartype cloud_service_roles: azure.mgmt.compute.v2021_03_01.operations.CloudServiceRolesOperations
    :ivar cloud_services: CloudServicesOperations operations
    :vartype cloud_services: azure.mgmt.compute.v2021_03_01.operations.CloudServicesOperations
    :ivar cloud_services_update_domain: CloudServicesUpdateDomainOperations operations
    :vartype cloud_services_update_domain: azure.mgmt.compute.v2021_03_01.operations.CloudServicesUpdateDomainOperations
    :ivar cloud_service_operating_systems: CloudServiceOperatingSystemsOperations operations
    :vartype cloud_service_operating_systems: azure.mgmt.compute.v2021_03_01.operations.CloudServiceOperatingSystemsOperations
    :param credential: Credential needed for the client to connect to Azure.
    :type credential: ~azure.core.credentials.TokenCredential
    :param subscription_id: Subscription credentials which uniquely identify Microsoft Azure subscription. The subscription ID forms part of the URI for every service call.
    :type subscription_id: str
    :param str base_url: Service URL
    :keyword int polling_interval: Default waiting time between two polls for LRO operations if no Retry-After header is present.
    """

    def __init__(
        self,
        credential,  # type: "TokenCredential"
        subscription_id,  # type: str
        base_url=None,  # type: Optional[str]
        **kwargs  # type: Any
    ):
        # type: (...) -> None
        if not base_url:
            base_url = 'https://management.azure.com'
        self._config = ComputeManagementClientConfiguration(credential, subscription_id, **kwargs)
        self._client = ARMPipelineClient(base_url=base_url, config=self._config, **kwargs)

        client_models = {k: v for k, v in models.__dict__.items() if isinstance(v, type)}
        self._serialize = Serializer(client_models)
        self._serialize.client_side_validation = False
        self._deserialize = Deserializer(client_models)

        self.cloud_service_role_instances = CloudServiceRoleInstancesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cloud_service_roles = CloudServiceRolesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cloud_services = CloudServicesOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cloud_services_update_domain = CloudServicesUpdateDomainOperations(
            self._client, self._config, self._serialize, self._deserialize)
        self.cloud_service_operating_systems = CloudServiceOperatingSystemsOperations(
            self._client, self._config, self._serialize, self._deserialize)

    def close(self):
        # type: () -> None
        self._client.close()

    def __enter__(self):
        # type: () -> ComputeManagementClient
        self._client.__enter__()
        return self

    def __exit__(self, *exc_details):
        # type: (Any) -> None
        self._client.__exit__(*exc_details)
