# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------

import datetime
from typing import Dict, List, Optional, Union

import msrest.serialization

from ._compute_management_client_enums import *


class AccessUri(msrest.serialization.Model):
    """A disk access SAS uri.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar access_sas: A SAS uri for accessing a disk.
    :vartype access_sas: str
    """

    _validation = {
        'access_sas': {'readonly': True},
    }

    _attribute_map = {
        'access_sas': {'key': 'accessSAS', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(AccessUri, self).__init__(**kwargs)
        self.access_sas = None


class AdditionalUnattendContent(msrest.serialization.Model):
    """Specifies additional XML formatted information that can be included in the Unattend.xml file, which is used by Windows Setup. Contents are defined by setting name, component name, and the pass in which the content is applied.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar pass_name: The pass name. Currently, the only allowable value is OobeSystem. Default
     value: "OobeSystem".
    :vartype pass_name: str
    :ivar component_name: The component name. Currently, the only allowable value is Microsoft-
     Windows-Shell-Setup. Default value: "Microsoft-Windows-Shell-Setup".
    :vartype component_name: str
    :param setting_name: Specifies the name of the setting to which the content applies. Possible
     values are: FirstLogonCommands and AutoLogon. Possible values include: "AutoLogon",
     "FirstLogonCommands".
    :type setting_name: str or ~azure.mgmt.compute.v2018_04_01.models.SettingNames
    :param content: Specifies the XML formatted content that is added to the unattend.xml file for
     the specified path and component. The XML must be less than 4KB and must include the root
     element for the setting or feature that is being inserted.
    :type content: str
    """

    _validation = {
        'pass_name': {'constant': True},
        'component_name': {'constant': True},
    }

    _attribute_map = {
        'pass_name': {'key': 'passName', 'type': 'str'},
        'component_name': {'key': 'componentName', 'type': 'str'},
        'setting_name': {'key': 'settingName', 'type': 'str'},
        'content': {'key': 'content', 'type': 'str'},
    }

    pass_name = "OobeSystem"
    component_name = "Microsoft-Windows-Shell-Setup"

    def __init__(
        self,
        *,
        setting_name: Optional[Union[str, "SettingNames"]] = None,
        content: Optional[str] = None,
        **kwargs
    ):
        super(AdditionalUnattendContent, self).__init__(**kwargs)
        self.setting_name = setting_name
        self.content = content


class ApiEntityReference(msrest.serialization.Model):
    """The API entity reference.

    :param id: The ARM resource id in the form of
     /subscriptions/{SubscriptionId}/resourceGroups/{ResourceGroupName}/...
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(ApiEntityReference, self).__init__(**kwargs)
        self.id = id


class ApiError(msrest.serialization.Model):
    """Api error.

    :param details: The Api error details.
    :type details: list[~azure.mgmt.compute.v2018_04_01.models.ApiErrorBase]
    :param innererror: The Api inner error.
    :type innererror: ~azure.mgmt.compute.v2018_04_01.models.InnerError
    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'details': {'key': 'details', 'type': '[ApiErrorBase]'},
        'innererror': {'key': 'innererror', 'type': 'InnerError'},
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        details: Optional[List["ApiErrorBase"]] = None,
        innererror: Optional["InnerError"] = None,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiError, self).__init__(**kwargs)
        self.details = details
        self.innererror = innererror
        self.code = code
        self.target = target
        self.message = message


class ApiErrorBase(msrest.serialization.Model):
    """Api error base.

    :param code: The error code.
    :type code: str
    :param target: The target of the particular error.
    :type target: str
    :param message: The error message.
    :type message: str
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'target': {'key': 'target', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        target: Optional[str] = None,
        message: Optional[str] = None,
        **kwargs
    ):
        super(ApiErrorBase, self).__init__(**kwargs)
        self.code = code
        self.target = target
        self.message = message


class AutoOSUpgradePolicy(msrest.serialization.Model):
    """The configuration parameters used for performing automatic OS upgrade.

    :param disable_auto_rollback: Whether OS image rollback feature should be disabled. Default
     value is false.
    :type disable_auto_rollback: bool
    """

    _attribute_map = {
        'disable_auto_rollback': {'key': 'disableAutoRollback', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        disable_auto_rollback: Optional[bool] = None,
        **kwargs
    ):
        super(AutoOSUpgradePolicy, self).__init__(**kwargs)
        self.disable_auto_rollback = disable_auto_rollback


class Resource(msrest.serialization.Model):
    """The Resource model definition.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(Resource, self).__init__(**kwargs)
        self.id = None
        self.name = None
        self.type = None
        self.location = location
        self.tags = tags


class AvailabilitySet(Resource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Virtual machines specified in the same availability set are allocated to different nodes to maximize availability. For more information about availability sets, see `Manage the availability of virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>` For more information on Azure planned maintenance, see `Planned maintenance for virtual machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation time. An existing VM cannot be added to an availability set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Sku of the availability set.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.Sku
    :param platform_update_domain_count: Update Domain count.
    :type platform_update_domain_count: int
    :param platform_fault_domain_count: Fault Domain count.
    :type platform_fault_domain_count: int
    :param virtual_machines: A list of references to all virtual machines in the availability set.
    :type virtual_machines: list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["SubResource"]] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(AvailabilitySet, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None


class AvailabilitySetListResult(msrest.serialization.Model):
    """The List Availability Set operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of availability sets.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.AvailabilitySet]
    :param next_link: The URI to fetch the next page of AvailabilitySets. Call ListNext() with this
     URI to fetch the next page of AvailabilitySets.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[AvailabilitySet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["AvailabilitySet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(AvailabilitySetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class UpdateResource(msrest.serialization.Model):
    """The Update Resource model definition.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(UpdateResource, self).__init__(**kwargs)
        self.tags = tags


class AvailabilitySetUpdate(UpdateResource):
    """Specifies information about the availability set that the virtual machine should be assigned to. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: Sku of the availability set.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.Sku
    :param platform_update_domain_count: Update Domain count.
    :type platform_update_domain_count: int
    :param platform_fault_domain_count: Fault Domain count.
    :type platform_fault_domain_count: int
    :param virtual_machines: A list of references to all virtual machines in the availability set.
    :type virtual_machines: list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the availability set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :ivar statuses: The resource status information.
    :vartype statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _validation = {
        'statuses': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'platform_update_domain_count': {'key': 'properties.platformUpdateDomainCount', 'type': 'int'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'statuses': {'key': 'properties.statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        platform_update_domain_count: Optional[int] = None,
        platform_fault_domain_count: Optional[int] = None,
        virtual_machines: Optional[List["SubResource"]] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(AvailabilitySetUpdate, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.platform_update_domain_count = platform_update_domain_count
        self.platform_fault_domain_count = platform_fault_domain_count
        self.virtual_machines = virtual_machines
        self.proximity_placement_group = proximity_placement_group
        self.statuses = None


class BootDiagnostics(msrest.serialization.Model):
    """Boot Diagnostics is a debugging feature which allows you to view Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a screenshot of the VM from the hypervisor.

    :param enabled: Whether boot diagnostics should be enabled on the Virtual Machine.
    :type enabled: bool
    :param storage_uri: Uri of the storage account to use for placing the console output and
     screenshot.
    :type storage_uri: str
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'storage_uri': {'key': 'storageUri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        storage_uri: Optional[str] = None,
        **kwargs
    ):
        super(BootDiagnostics, self).__init__(**kwargs)
        self.enabled = enabled
        self.storage_uri = storage_uri


class BootDiagnosticsInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine boot diagnostics.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar console_screenshot_blob_uri: The console screenshot blob URI.
    :vartype console_screenshot_blob_uri: str
    :ivar serial_console_log_blob_uri: The Linux serial console log blob Uri.
    :vartype serial_console_log_blob_uri: str
    :ivar status: The boot diagnostics status information for the VM. :code:`<br>`:code:`<br>`
     NOTE: It will be set only if there are errors encountered in enabling boot diagnostics.
    :vartype status: ~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus
    """

    _validation = {
        'console_screenshot_blob_uri': {'readonly': True},
        'serial_console_log_blob_uri': {'readonly': True},
        'status': {'readonly': True},
    }

    _attribute_map = {
        'console_screenshot_blob_uri': {'key': 'consoleScreenshotBlobUri', 'type': 'str'},
        'serial_console_log_blob_uri': {'key': 'serialConsoleLogBlobUri', 'type': 'str'},
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(BootDiagnosticsInstanceView, self).__init__(**kwargs)
        self.console_screenshot_blob_uri = None
        self.serial_console_log_blob_uri = None
        self.status = None


class ComputeOperationListResult(msrest.serialization.Model):
    """The List Compute Operation operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar value: The list of compute operations.
    :vartype value: list[~azure.mgmt.compute.v2018_04_01.models.ComputeOperationValue]
    """

    _validation = {
        'value': {'readonly': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ComputeOperationValue]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeOperationListResult, self).__init__(**kwargs)
        self.value = None


class ComputeOperationValue(msrest.serialization.Model):
    """Describes the properties of a Compute Operation value.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar origin: The origin of the compute operation.
    :vartype origin: str
    :ivar name: The name of the compute operation.
    :vartype name: str
    :ivar operation: The display name of the compute operation.
    :vartype operation: str
    :ivar resource: The display name of the resource the operation applies to.
    :vartype resource: str
    :ivar description: The description of the operation.
    :vartype description: str
    :ivar provider: The resource provider for the operation.
    :vartype provider: str
    """

    _validation = {
        'origin': {'readonly': True},
        'name': {'readonly': True},
        'operation': {'readonly': True},
        'resource': {'readonly': True},
        'description': {'readonly': True},
        'provider': {'readonly': True},
    }

    _attribute_map = {
        'origin': {'key': 'origin', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'operation': {'key': 'display.operation', 'type': 'str'},
        'resource': {'key': 'display.resource', 'type': 'str'},
        'description': {'key': 'display.description', 'type': 'str'},
        'provider': {'key': 'display.provider', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(ComputeOperationValue, self).__init__(**kwargs)
        self.origin = None
        self.name = None
        self.operation = None
        self.resource = None
        self.description = None
        self.provider = None


class CreationData(msrest.serialization.Model):
    """Data used when creating a disk.

    All required parameters must be populated in order to send to Azure.

    :param create_option: Required. This enumerates the possible sources of a disk's creation.
     Possible values include: "Empty", "Attach", "FromImage", "Import", "Copy", "Restore".
    :type create_option: str or ~azure.mgmt.compute.v2018_04_01.models.DiskCreateOption
    :param storage_account_id: If createOption is Import, the Azure Resource Manager identifier of
     the storage account containing the blob to import as a disk. Required only if the blob is in a
     different subscription.
    :type storage_account_id: str
    :param image_reference: Disk source information.
    :type image_reference: ~azure.mgmt.compute.v2018_04_01.models.ImageDiskReference
    :param source_uri: If createOption is Import, this is the URI of a blob to be imported into a
     managed disk.
    :type source_uri: str
    :param source_resource_id: If createOption is Copy, this is the ARM id of the source snapshot
     or disk.
    :type source_resource_id: str
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'create_option': {'key': 'createOption', 'type': 'str'},
        'storage_account_id': {'key': 'storageAccountId', 'type': 'str'},
        'image_reference': {'key': 'imageReference', 'type': 'ImageDiskReference'},
        'source_uri': {'key': 'sourceUri', 'type': 'str'},
        'source_resource_id': {'key': 'sourceResourceId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "DiskCreateOption"],
        storage_account_id: Optional[str] = None,
        image_reference: Optional["ImageDiskReference"] = None,
        source_uri: Optional[str] = None,
        source_resource_id: Optional[str] = None,
        **kwargs
    ):
        super(CreationData, self).__init__(**kwargs)
        self.create_option = create_option
        self.storage_account_id = storage_account_id
        self.image_reference = image_reference
        self.source_uri = source_uri
        self.source_resource_id = source_resource_id


class DataDisk(msrest.serialization.Model):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    :param name: The disk name.
    :type name: str
    :param vhd: The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2018_04_01.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :type image: ~azure.mgmt.compute.v2018_04_01.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2018_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Possible values include: "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2018_04_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk: ~azure.mgmt.compute.v2018_04_01.models.ManagedDiskParameters
    """

    _validation = {
        'lun': {'required': True},
        'create_option': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "DiskCreateOptionTypes"],
        name: Optional[str] = None,
        vhd: Optional["VirtualHardDisk"] = None,
        image: Optional["VirtualHardDisk"] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["ManagedDiskParameters"] = None,
        **kwargs
    ):
        super(DataDisk, self).__init__(**kwargs)
        self.lun = lun
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class DataDiskImage(msrest.serialization.Model):
    """Contains the data disk images information.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar lun: Specifies the logical unit number of the data disk. This value is used to identify
     data disks within the VM and therefore must be unique for each data disk attached to a VM.
    :vartype lun: int
    """

    _validation = {
        'lun': {'readonly': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(DataDiskImage, self).__init__(**kwargs)
        self.lun = None


class DiagnosticsProfile(msrest.serialization.Model):
    """Specifies the boot diagnostic settings state. :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.

    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2018_04_01.models.BootDiagnostics
    """

    _attribute_map = {
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnostics'},
    }

    def __init__(
        self,
        *,
        boot_diagnostics: Optional["BootDiagnostics"] = None,
        **kwargs
    ):
        super(DiagnosticsProfile, self).__init__(**kwargs)
        self.boot_diagnostics = boot_diagnostics


class Disk(Resource):
    """Disk resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar managed_by: A relative URI containing the ID of the VM that has the disk attached.
    :vartype managed_by: str
    :param sku: The disks sku name. Can be Standard_LRS, Premium_LRS, or StandardSSD_LRS.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.DiskSku
    :param zones: The Logical zone list for Disk.
    :type zones: list[str]
    :ivar time_created: The time when the disk was created.
    :vartype time_created: ~datetime.datetime
    :param os_type: The Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :type creation_data: ~azure.mgmt.compute.v2018_04_01.models.CreationData
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings: Encryption settings for disk or snapshot.
    :type encryption_settings: ~azure.mgmt.compute.v2018_04_01.models.EncryptionSettings
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_by': {'readonly': True},
        'time_created': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'DiskSku'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings': {'key': 'properties.encryptionSettings', 'type': 'EncryptionSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["DiskSku"] = None,
        zones: Optional[List[str]] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        creation_data: Optional["CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["EncryptionSettings"] = None,
        **kwargs
    ):
        super(Disk, self).__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.sku = sku
        self.zones = zones
        self.time_created = None
        self.os_type = os_type
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings
        self.provisioning_state = None


class DiskEncryptionSettings(msrest.serialization.Model):
    """Describes a Encryption Settings for a Disk.

    :param disk_encryption_key: Specifies the location of the disk encryption key, which is a Key
     Vault Secret.
    :type disk_encryption_key: ~azure.mgmt.compute.v2018_04_01.models.KeyVaultSecretReference
    :param key_encryption_key: Specifies the location of the key encryption key in Key Vault.
    :type key_encryption_key: ~azure.mgmt.compute.v2018_04_01.models.KeyVaultKeyReference
    :param enabled: Specifies whether disk encryption should be enabled on the virtual machine.
    :type enabled: bool
    """

    _attribute_map = {
        'disk_encryption_key': {'key': 'diskEncryptionKey', 'type': 'KeyVaultSecretReference'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultKeyReference'},
        'enabled': {'key': 'enabled', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        disk_encryption_key: Optional["KeyVaultSecretReference"] = None,
        key_encryption_key: Optional["KeyVaultKeyReference"] = None,
        enabled: Optional[bool] = None,
        **kwargs
    ):
        super(DiskEncryptionSettings, self).__init__(**kwargs)
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key
        self.enabled = enabled


class DiskInstanceView(msrest.serialization.Model):
    """The instance view of the disk.

    :param name: The disk name.
    :type name: str
    :param encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type encryption_settings: list[~azure.mgmt.compute.v2018_04_01.models.DiskEncryptionSettings]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': '[DiskEncryptionSettings]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        encryption_settings: Optional[List["DiskEncryptionSettings"]] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(DiskInstanceView, self).__init__(**kwargs)
        self.name = name
        self.encryption_settings = encryption_settings
        self.statuses = statuses


class DiskList(msrest.serialization.Model):
    """The List Disks operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of disks.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.Disk]
    :param next_link: The uri to fetch the next page of disks. Call ListNext() with this to fetch
     the next page of disks.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Disk]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Disk"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(DiskList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class DiskSku(msrest.serialization.Model):
    """The disks sku name. Can be Standard_LRS, Premium_LRS, or StandardSSD_LRS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The sku name. Possible values include: "Standard_LRS", "Premium_LRS",
     "StandardSSD_LRS".
    :type name: str or ~azure.mgmt.compute.v2018_04_01.models.StorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "StorageAccountTypes"]] = None,
        **kwargs
    ):
        super(DiskSku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class DiskUpdate(msrest.serialization.Model):
    """Disk update resource.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The disks sku name. Can be Standard_LRS, Premium_LRS, or StandardSSD_LRS.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.DiskSku
    :param os_type: the Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings: Encryption settings for disk or snapshot.
    :type encryption_settings: ~azure.mgmt.compute.v2018_04_01.models.EncryptionSettings
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'DiskSku'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings': {'key': 'properties.encryptionSettings', 'type': 'EncryptionSettings'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["DiskSku"] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["EncryptionSettings"] = None,
        **kwargs
    ):
        super(DiskUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings


class EncryptionSettings(msrest.serialization.Model):
    """Encryption settings for disk or snapshot.

    :param enabled: Set this flag to true and provide DiskEncryptionKey and optional
     KeyEncryptionKey to enable encryption. Set this flag to false and remove DiskEncryptionKey and
     KeyEncryptionKey to disable encryption. If EncryptionSettings is null in the request object,
     the existing settings remain unchanged.
    :type enabled: bool
    :param disk_encryption_key: Key Vault Secret Url and vault id of the disk encryption key.
    :type disk_encryption_key: ~azure.mgmt.compute.v2018_04_01.models.KeyVaultAndSecretReference
    :param key_encryption_key: Key Vault Key Url and vault id of the key encryption key.
    :type key_encryption_key: ~azure.mgmt.compute.v2018_04_01.models.KeyVaultAndKeyReference
    """

    _attribute_map = {
        'enabled': {'key': 'enabled', 'type': 'bool'},
        'disk_encryption_key': {'key': 'diskEncryptionKey', 'type': 'KeyVaultAndSecretReference'},
        'key_encryption_key': {'key': 'keyEncryptionKey', 'type': 'KeyVaultAndKeyReference'},
    }

    def __init__(
        self,
        *,
        enabled: Optional[bool] = None,
        disk_encryption_key: Optional["KeyVaultAndSecretReference"] = None,
        key_encryption_key: Optional["KeyVaultAndKeyReference"] = None,
        **kwargs
    ):
        super(EncryptionSettings, self).__init__(**kwargs)
        self.enabled = enabled
        self.disk_encryption_key = disk_encryption_key
        self.key_encryption_key = key_encryption_key


class GrantAccessData(msrest.serialization.Model):
    """Data used for requesting a SAS.

    All required parameters must be populated in order to send to Azure.

    :param access: Required.  Possible values include: "None", "Read".
    :type access: str or ~azure.mgmt.compute.v2018_04_01.models.AccessLevel
    :param duration_in_seconds: Required. Time duration in seconds until the SAS access expires.
    :type duration_in_seconds: int
    """

    _validation = {
        'access': {'required': True},
        'duration_in_seconds': {'required': True},
    }

    _attribute_map = {
        'access': {'key': 'access', 'type': 'str'},
        'duration_in_seconds': {'key': 'durationInSeconds', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        access: Union[str, "AccessLevel"],
        duration_in_seconds: int,
        **kwargs
    ):
        super(GrantAccessData, self).__init__(**kwargs)
        self.access = access
        self.duration_in_seconds = duration_in_seconds


class HardwareProfile(msrest.serialization.Model):
    """Specifies the hardware settings for the virtual machine.

    :param vm_size: Specifies the size of the virtual machine. For more information about virtual
     machine sizes, see `Sizes for virtual machines <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-windows-sizes?toc=%2fazure%2fvirtual-
     machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>` The available VM sizes depend on
     region and availability set. For a list of available sizes use these APIs:
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in an availability set
     <https://docs.microsoft.com/rest/api/compute/availabilitysets/listavailablesizes>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes in a region
     <https://docs.microsoft.com/rest/api/compute/virtualmachinesizes/list>`_
     :code:`<br>`:code:`<br>` `List all available virtual machine sizes for resizing
     <https://docs.microsoft.com/rest/api/compute/virtualmachines/listavailablesizes>`_. Possible
     values include: "Basic_A0", "Basic_A1", "Basic_A2", "Basic_A3", "Basic_A4", "Standard_A0",
     "Standard_A1", "Standard_A2", "Standard_A3", "Standard_A4", "Standard_A5", "Standard_A6",
     "Standard_A7", "Standard_A8", "Standard_A9", "Standard_A10", "Standard_A11", "Standard_A1_v2",
     "Standard_A2_v2", "Standard_A4_v2", "Standard_A8_v2", "Standard_A2m_v2", "Standard_A4m_v2",
     "Standard_A8m_v2", "Standard_B1s", "Standard_B1ms", "Standard_B2s", "Standard_B2ms",
     "Standard_B4ms", "Standard_B8ms", "Standard_D1", "Standard_D2", "Standard_D3", "Standard_D4",
     "Standard_D11", "Standard_D12", "Standard_D13", "Standard_D14", "Standard_D1_v2",
     "Standard_D2_v2", "Standard_D3_v2", "Standard_D4_v2", "Standard_D5_v2", "Standard_D2_v3",
     "Standard_D4_v3", "Standard_D8_v3", "Standard_D16_v3", "Standard_D32_v3", "Standard_D64_v3",
     "Standard_D2s_v3", "Standard_D4s_v3", "Standard_D8s_v3", "Standard_D16s_v3",
     "Standard_D32s_v3", "Standard_D64s_v3", "Standard_D11_v2", "Standard_D12_v2",
     "Standard_D13_v2", "Standard_D14_v2", "Standard_D15_v2", "Standard_DS1", "Standard_DS2",
     "Standard_DS3", "Standard_DS4", "Standard_DS11", "Standard_DS12", "Standard_DS13",
     "Standard_DS14", "Standard_DS1_v2", "Standard_DS2_v2", "Standard_DS3_v2", "Standard_DS4_v2",
     "Standard_DS5_v2", "Standard_DS11_v2", "Standard_DS12_v2", "Standard_DS13_v2",
     "Standard_DS14_v2", "Standard_DS15_v2", "Standard_DS13-4_v2", "Standard_DS13-2_v2",
     "Standard_DS14-8_v2", "Standard_DS14-4_v2", "Standard_E2_v3", "Standard_E4_v3",
     "Standard_E8_v3", "Standard_E16_v3", "Standard_E32_v3", "Standard_E64_v3", "Standard_E2s_v3",
     "Standard_E4s_v3", "Standard_E8s_v3", "Standard_E16s_v3", "Standard_E32s_v3",
     "Standard_E64s_v3", "Standard_E32-16_v3", "Standard_E32-8s_v3", "Standard_E64-32s_v3",
     "Standard_E64-16s_v3", "Standard_F1", "Standard_F2", "Standard_F4", "Standard_F8",
     "Standard_F16", "Standard_F1s", "Standard_F2s", "Standard_F4s", "Standard_F8s",
     "Standard_F16s", "Standard_F2s_v2", "Standard_F4s_v2", "Standard_F8s_v2", "Standard_F16s_v2",
     "Standard_F32s_v2", "Standard_F64s_v2", "Standard_F72s_v2", "Standard_G1", "Standard_G2",
     "Standard_G3", "Standard_G4", "Standard_G5", "Standard_GS1", "Standard_GS2", "Standard_GS3",
     "Standard_GS4", "Standard_GS5", "Standard_GS4-8", "Standard_GS4-4", "Standard_GS5-16",
     "Standard_GS5-8", "Standard_H8", "Standard_H16", "Standard_H8m", "Standard_H16m",
     "Standard_H16r", "Standard_H16mr", "Standard_L4s", "Standard_L8s", "Standard_L16s",
     "Standard_L32s", "Standard_M64s", "Standard_M64ms", "Standard_M128s", "Standard_M128ms",
     "Standard_M64-32ms", "Standard_M64-16ms", "Standard_M128-64ms", "Standard_M128-32ms",
     "Standard_NC6", "Standard_NC12", "Standard_NC24", "Standard_NC24r", "Standard_NC6s_v2",
     "Standard_NC12s_v2", "Standard_NC24s_v2", "Standard_NC24rs_v2", "Standard_NC6s_v3",
     "Standard_NC12s_v3", "Standard_NC24s_v3", "Standard_NC24rs_v3", "Standard_ND6s",
     "Standard_ND12s", "Standard_ND24s", "Standard_ND24rs", "Standard_NV6", "Standard_NV12",
     "Standard_NV24".
    :type vm_size: str or ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineSizeTypes
    """

    _attribute_map = {
        'vm_size': {'key': 'vmSize', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        vm_size: Optional[Union[str, "VirtualMachineSizeTypes"]] = None,
        **kwargs
    ):
        super(HardwareProfile, self).__init__(**kwargs)
        self.vm_size = vm_size


class Image(Resource):
    """The source user image virtual hard disk. The virtual hard disk will be copied before being attached to the virtual machine. If SourceImage is provided, the destination virtual hard drive must not exist.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source_virtual_machine: The source virtual machine from which Image is created.
    :type source_virtual_machine: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2018_04_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'source_virtual_machine': {'key': 'properties.sourceVirtualMachine', 'type': 'SubResource'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'ImageStorageProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["SubResource"] = None,
        storage_profile: Optional["ImageStorageProfile"] = None,
        **kwargs
    ):
        super(Image, self).__init__(location=location, tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None


class ImageDataDisk(msrest.serialization.Model):
    """Describes a data disk.

    All required parameters must be populated in order to send to Azure.

    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2018_04_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS, Premium_LRS, and StandardSSD_LRS. Possible values include:
     "Standard_LRS", "Premium_LRS", "StandardSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2018_04_01.models.StorageAccountTypes
    """

    _validation = {
        'lun': {'required': True},
    }

    _attribute_map = {
        'lun': {'key': 'lun', 'type': 'int'},
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        lun: int,
        snapshot: Optional["SubResource"] = None,
        managed_disk: Optional["SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        **kwargs
    ):
        super(ImageDataDisk, self).__init__(**kwargs)
        self.lun = lun
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type


class ImageDiskReference(msrest.serialization.Model):
    """The source image used for creating the disk.

    All required parameters must be populated in order to send to Azure.

    :param id: Required. A relative uri containing either a Platform Image Repository or user image
     reference.
    :type id: str
    :param lun: If the disk is created from an image's data disk, this is an index that indicates
     which of the data disks in the image to use. For OS disks, this field is null.
    :type lun: int
    """

    _validation = {
        'id': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        id: str,
        lun: Optional[int] = None,
        **kwargs
    ):
        super(ImageDiskReference, self).__init__(**kwargs)
        self.id = id
        self.lun = lun


class ImageListResult(msrest.serialization.Model):
    """The List Image operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of Images.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.Image]
    :param next_link: The uri to fetch the next page of Images. Call ListNext() with this to fetch
     the next page of Images.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Image]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Image"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ImageListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ImageOSDisk(msrest.serialization.Model):
    """Describes an Operating System disk.

    All required parameters must be populated in order to send to Azure.

    :param os_type: Required. This property allows you to specify the type of the OS that is
     included in the disk if creating a VM from a custom image. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param os_state: Required. The OS State. Possible values include: "Generalized", "Specialized".
    :type os_state: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemStateTypes
    :param snapshot: The snapshot.
    :type snapshot: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param managed_disk: The managedDisk.
    :type managed_disk: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param blob_uri: The Virtual Hard Disk.
    :type blob_uri: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2018_04_01.models.CachingTypes
    :param disk_size_gb: Specifies the size of empty data disks in gigabytes. This element can be
     used to overwrite the name of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS, Premium_LRS, and StandardSSD_LRS. Possible values include:
     "Standard_LRS", "Premium_LRS", "StandardSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2018_04_01.models.StorageAccountTypes
    """

    _validation = {
        'os_type': {'required': True},
        'os_state': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'os_state': {'key': 'osState', 'type': 'str'},
        'snapshot': {'key': 'snapshot', 'type': 'SubResource'},
        'managed_disk': {'key': 'managedDisk', 'type': 'SubResource'},
        'blob_uri': {'key': 'blobUri', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_type: Union[str, "OperatingSystemTypes"],
        os_state: Union[str, "OperatingSystemStateTypes"],
        snapshot: Optional["SubResource"] = None,
        managed_disk: Optional["SubResource"] = None,
        blob_uri: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        **kwargs
    ):
        super(ImageOSDisk, self).__init__(**kwargs)
        self.os_type = os_type
        self.os_state = os_state
        self.snapshot = snapshot
        self.managed_disk = managed_disk
        self.blob_uri = blob_uri
        self.caching = caching
        self.disk_size_gb = disk_size_gb
        self.storage_account_type = storage_account_type


class SubResource(msrest.serialization.Model):
    """SubResource.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SubResource, self).__init__(**kwargs)
        self.id = id


class ImageReference(SubResource):
    """Specifies information about the image to use. You can specify information about platform images, marketplace images, or virtual machine images. This element is required when you want to use a platform image, marketplace image, or virtual machine image, but is not used in other creation operations. NOTE: Image reference publisher and offer can only be set when you create the scale set.

    :param id: Resource Id.
    :type id: str
    :param publisher: The image publisher.
    :type publisher: str
    :param offer: Specifies the offer of the platform image or marketplace image used to create the
     virtual machine.
    :type offer: str
    :param sku: The image SKU.
    :type sku: str
    :param version: Specifies the version of the platform image or marketplace image used to create
     the virtual machine. The allowed formats are Major.Minor.Build or 'latest'. Major, Minor, and
     Build are decimal numbers. Specify 'latest' to use the latest version of an image available at
     deploy time. Even if you use 'latest', the VM image will not automatically update after deploy
     time even if a new version becomes available.
    :type version: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'offer': {'key': 'offer', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'str'},
        'version': {'key': 'version', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        publisher: Optional[str] = None,
        offer: Optional[str] = None,
        sku: Optional[str] = None,
        version: Optional[str] = None,
        **kwargs
    ):
        super(ImageReference, self).__init__(id=id, **kwargs)
        self.publisher = publisher
        self.offer = offer
        self.sku = sku
        self.version = version


class ImageStorageProfile(msrest.serialization.Model):
    """Describes a storage profile.

    :param os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type os_disk: ~azure.mgmt.compute.v2018_04_01.models.ImageOSDisk
    :param data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type data_disks: list[~azure.mgmt.compute.v2018_04_01.models.ImageDataDisk]
    :param zone_resilient: Specifies whether an image is zone resilient or not. Default is false.
     Zone resilient images can be created only in regions that provide Zone Redundant Storage (ZRS).
    :type zone_resilient: bool
    """

    _attribute_map = {
        'os_disk': {'key': 'osDisk', 'type': 'ImageOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[ImageDataDisk]'},
        'zone_resilient': {'key': 'zoneResilient', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        os_disk: Optional["ImageOSDisk"] = None,
        data_disks: Optional[List["ImageDataDisk"]] = None,
        zone_resilient: Optional[bool] = None,
        **kwargs
    ):
        super(ImageStorageProfile, self).__init__(**kwargs)
        self.os_disk = os_disk
        self.data_disks = data_disks
        self.zone_resilient = zone_resilient


class ImageUpdate(UpdateResource):
    """The source user image virtual hard disk. Only tags may be updated.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param source_virtual_machine: The source virtual machine from which Image is created.
    :type source_virtual_machine: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2018_04_01.models.ImageStorageProfile
    :ivar provisioning_state: The provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'source_virtual_machine': {'key': 'properties.sourceVirtualMachine', 'type': 'SubResource'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'ImageStorageProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        source_virtual_machine: Optional["SubResource"] = None,
        storage_profile: Optional["ImageStorageProfile"] = None,
        **kwargs
    ):
        super(ImageUpdate, self).__init__(tags=tags, **kwargs)
        self.source_virtual_machine = source_virtual_machine
        self.storage_profile = storage_profile
        self.provisioning_state = None


class InnerError(msrest.serialization.Model):
    """Inner error details.

    :param exceptiontype: The exception type.
    :type exceptiontype: str
    :param errordetail: The internal error message or exception dump.
    :type errordetail: str
    """

    _attribute_map = {
        'exceptiontype': {'key': 'exceptiontype', 'type': 'str'},
        'errordetail': {'key': 'errordetail', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        exceptiontype: Optional[str] = None,
        errordetail: Optional[str] = None,
        **kwargs
    ):
        super(InnerError, self).__init__(**kwargs)
        self.exceptiontype = exceptiontype
        self.errordetail = errordetail


class InstanceViewStatus(msrest.serialization.Model):
    """Instance view status.

    :param code: The status code.
    :type code: str
    :param level: The level code. Possible values include: "Info", "Warning", "Error".
    :type level: str or ~azure.mgmt.compute.v2018_04_01.models.StatusLevelTypes
    :param display_status: The short localizable label for the status.
    :type display_status: str
    :param message: The detailed status message, including for alerts and error messages.
    :type message: str
    :param time: The time of the status.
    :type time: ~datetime.datetime
    """

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'level': {'key': 'level', 'type': 'str'},
        'display_status': {'key': 'displayStatus', 'type': 'str'},
        'message': {'key': 'message', 'type': 'str'},
        'time': {'key': 'time', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        *,
        code: Optional[str] = None,
        level: Optional[Union[str, "StatusLevelTypes"]] = None,
        display_status: Optional[str] = None,
        message: Optional[str] = None,
        time: Optional[datetime.datetime] = None,
        **kwargs
    ):
        super(InstanceViewStatus, self).__init__(**kwargs)
        self.code = code
        self.level = level
        self.display_status = display_status
        self.message = message
        self.time = time


class KeyVaultAndKeyReference(msrest.serialization.Model):
    """Key Vault Key Url and vault id of KeK, KeK is optional and when provided is used to unwrap the encryptionKey.

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Required. Resource id of the KeyVault containing the key or secret.
    :type source_vault: ~azure.mgmt.compute.v2018_04_01.models.SourceVault
    :param key_url: Required. Url pointing to a key or secret in KeyVault.
    :type key_url: str
    """

    _validation = {
        'source_vault': {'required': True},
        'key_url': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SourceVault'},
        'key_url': {'key': 'keyUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_vault: "SourceVault",
        key_url: str,
        **kwargs
    ):
        super(KeyVaultAndKeyReference, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.key_url = key_url


class KeyVaultAndSecretReference(msrest.serialization.Model):
    """Key Vault Secret Url and vault id of the encryption key.

    All required parameters must be populated in order to send to Azure.

    :param source_vault: Required. Resource id of the KeyVault containing the key or secret.
    :type source_vault: ~azure.mgmt.compute.v2018_04_01.models.SourceVault
    :param secret_url: Required. Url pointing to a key or secret in KeyVault.
    :type secret_url: str
    """

    _validation = {
        'source_vault': {'required': True},
        'secret_url': {'required': True},
    }

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SourceVault'},
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        source_vault: "SourceVault",
        secret_url: str,
        **kwargs
    ):
        super(KeyVaultAndSecretReference, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.secret_url = secret_url


class KeyVaultKeyReference(msrest.serialization.Model):
    """Describes a reference to Key Vault Key.

    All required parameters must be populated in order to send to Azure.

    :param key_url: Required. The URL referencing a key encryption key in Key Vault.
    :type key_url: str
    :param source_vault: Required. The relative URL of the Key Vault containing the key.
    :type source_vault: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    """

    _validation = {
        'key_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'key_url': {'key': 'keyUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        key_url: str,
        source_vault: "SubResource",
        **kwargs
    ):
        super(KeyVaultKeyReference, self).__init__(**kwargs)
        self.key_url = key_url
        self.source_vault = source_vault


class KeyVaultSecretReference(msrest.serialization.Model):
    """Describes a reference to Key Vault Secret.

    All required parameters must be populated in order to send to Azure.

    :param secret_url: Required. The URL referencing a secret in a Key Vault.
    :type secret_url: str
    :param source_vault: Required. The relative URL of the Key Vault containing the secret.
    :type source_vault: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    """

    _validation = {
        'secret_url': {'required': True},
        'source_vault': {'required': True},
    }

    _attribute_map = {
        'secret_url': {'key': 'secretUrl', 'type': 'str'},
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        secret_url: str,
        source_vault: "SubResource",
        **kwargs
    ):
        super(KeyVaultSecretReference, self).__init__(**kwargs)
        self.secret_url = secret_url
        self.source_vault = source_vault


class LinuxConfiguration(msrest.serialization.Model):
    """Specifies the Linux operating system settings on the virtual machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_ :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for Non-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.

    :param disable_password_authentication: Specifies whether password authentication should be
     disabled.
    :type disable_password_authentication: bool
    :param ssh: Specifies the ssh key configuration for a Linux OS.
    :type ssh: ~azure.mgmt.compute.v2018_04_01.models.SshConfiguration
    """

    _attribute_map = {
        'disable_password_authentication': {'key': 'disablePasswordAuthentication', 'type': 'bool'},
        'ssh': {'key': 'ssh', 'type': 'SshConfiguration'},
    }

    def __init__(
        self,
        *,
        disable_password_authentication: Optional[bool] = None,
        ssh: Optional["SshConfiguration"] = None,
        **kwargs
    ):
        super(LinuxConfiguration, self).__init__(**kwargs)
        self.disable_password_authentication = disable_password_authentication
        self.ssh = ssh


class ListUsagesResult(msrest.serialization.Model):
    """The List Usages operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of compute resource usages.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.Usage]
    :param next_link: The URI to fetch the next page of compute resource usage information. Call
     ListNext() with this to fetch the next page of compute resource usage information.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Usage]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Usage"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ListUsagesResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class LogAnalyticsInputBase(msrest.serialization.Model):
    """Api input base class for LogAnalytics Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        **kwargs
    ):
        super(LogAnalyticsInputBase, self).__init__(**kwargs)
        self.blob_container_sas_uri = blob_container_sas_uri
        self.from_time = from_time
        self.to_time = to_time
        self.group_by_throttle_policy = group_by_throttle_policy
        self.group_by_operation_name = group_by_operation_name
        self.group_by_resource_name = group_by_resource_name


class LogAnalyticsOperationResult(msrest.serialization.Model):
    """LogAnalytics operation status response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: LogAnalyticsOutput.
    :vartype properties: ~azure.mgmt.compute.v2018_04_01.models.LogAnalyticsOutput
    """

    _validation = {
        'properties': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'LogAnalyticsOutput'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsOperationResult, self).__init__(**kwargs)
        self.properties = None


class LogAnalyticsOutput(msrest.serialization.Model):
    """LogAnalytics output properties.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar output: Output file Uri path to blob container.
    :vartype output: str
    """

    _validation = {
        'output': {'readonly': True},
    }

    _attribute_map = {
        'output': {'key': 'output', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(LogAnalyticsOutput, self).__init__(**kwargs)
        self.output = None


class MaintenanceRedeployStatus(msrest.serialization.Model):
    """Maintenance Operation Status.

    :param is_customer_initiated_maintenance_allowed: True, if customer is allowed to perform
     Maintenance.
    :type is_customer_initiated_maintenance_allowed: bool
    :param pre_maintenance_window_start_time: Start Time for the Pre Maintenance Window.
    :type pre_maintenance_window_start_time: ~datetime.datetime
    :param pre_maintenance_window_end_time: End Time for the Pre Maintenance Window.
    :type pre_maintenance_window_end_time: ~datetime.datetime
    :param maintenance_window_start_time: Start Time for the Maintenance Window.
    :type maintenance_window_start_time: ~datetime.datetime
    :param maintenance_window_end_time: End Time for the Maintenance Window.
    :type maintenance_window_end_time: ~datetime.datetime
    :param last_operation_result_code: The Last Maintenance Operation Result Code. Possible values
     include: "None", "RetryLater", "MaintenanceAborted", "MaintenanceCompleted".
    :type last_operation_result_code: str or
     ~azure.mgmt.compute.v2018_04_01.models.MaintenanceOperationResultCodeTypes
    :param last_operation_message: Message returned for the last Maintenance Operation.
    :type last_operation_message: str
    """

    _attribute_map = {
        'is_customer_initiated_maintenance_allowed': {'key': 'isCustomerInitiatedMaintenanceAllowed', 'type': 'bool'},
        'pre_maintenance_window_start_time': {'key': 'preMaintenanceWindowStartTime', 'type': 'iso-8601'},
        'pre_maintenance_window_end_time': {'key': 'preMaintenanceWindowEndTime', 'type': 'iso-8601'},
        'maintenance_window_start_time': {'key': 'maintenanceWindowStartTime', 'type': 'iso-8601'},
        'maintenance_window_end_time': {'key': 'maintenanceWindowEndTime', 'type': 'iso-8601'},
        'last_operation_result_code': {'key': 'lastOperationResultCode', 'type': 'str'},
        'last_operation_message': {'key': 'lastOperationMessage', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        is_customer_initiated_maintenance_allowed: Optional[bool] = None,
        pre_maintenance_window_start_time: Optional[datetime.datetime] = None,
        pre_maintenance_window_end_time: Optional[datetime.datetime] = None,
        maintenance_window_start_time: Optional[datetime.datetime] = None,
        maintenance_window_end_time: Optional[datetime.datetime] = None,
        last_operation_result_code: Optional[Union[str, "MaintenanceOperationResultCodeTypes"]] = None,
        last_operation_message: Optional[str] = None,
        **kwargs
    ):
        super(MaintenanceRedeployStatus, self).__init__(**kwargs)
        self.is_customer_initiated_maintenance_allowed = is_customer_initiated_maintenance_allowed
        self.pre_maintenance_window_start_time = pre_maintenance_window_start_time
        self.pre_maintenance_window_end_time = pre_maintenance_window_end_time
        self.maintenance_window_start_time = maintenance_window_start_time
        self.maintenance_window_end_time = maintenance_window_end_time
        self.last_operation_result_code = last_operation_result_code
        self.last_operation_message = last_operation_message


class ManagedDiskParameters(SubResource):
    """The parameters of a managed disk.

    :param id: Resource Id.
    :type id: str
    :param storage_account_type: Specifies the storage account type for the managed disk. Possible
     values are: Standard_LRS, Premium_LRS, and StandardSSD_LRS. Possible values include:
     "Standard_LRS", "Premium_LRS", "StandardSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2018_04_01.models.StorageAccountTypes
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        **kwargs
    ):
        super(ManagedDiskParameters, self).__init__(id=id, **kwargs)
        self.storage_account_type = storage_account_type


class NetworkInterfaceReference(SubResource):
    """Describes a network interface reference.

    :param id: Resource Id.
    :type id: str
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        primary: Optional[bool] = None,
        **kwargs
    ):
        super(NetworkInterfaceReference, self).__init__(id=id, **kwargs)
        self.primary = primary


class NetworkProfile(msrest.serialization.Model):
    """Specifies the network interfaces of the virtual machine.

    :param network_interfaces: Specifies the list of resource Ids for the network interfaces
     associated with the virtual machine.
    :type network_interfaces:
     list[~azure.mgmt.compute.v2018_04_01.models.NetworkInterfaceReference]
    """

    _attribute_map = {
        'network_interfaces': {'key': 'networkInterfaces', 'type': '[NetworkInterfaceReference]'},
    }

    def __init__(
        self,
        *,
        network_interfaces: Optional[List["NetworkInterfaceReference"]] = None,
        **kwargs
    ):
        super(NetworkProfile, self).__init__(**kwargs)
        self.network_interfaces = network_interfaces


class OSDisk(msrest.serialization.Model):
    """Specifies information about the operating system disk used by the virtual machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.

    All required parameters must be populated in order to send to Azure.

    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param encryption_settings: Specifies the encryption settings for the OS Disk.
     :code:`<br>`:code:`<br>` Minimum api-version: 2015-06-15.
    :type encryption_settings: ~azure.mgmt.compute.v2018_04_01.models.DiskEncryptionSettings
    :param name: The disk name.
    :type name: str
    :param vhd: The virtual hard disk.
    :type vhd: ~azure.mgmt.compute.v2018_04_01.models.VirtualHardDisk
    :param image: The source user image virtual hard disk. The virtual hard disk will be copied
     before being attached to the virtual machine. If SourceImage is provided, the destination
     virtual hard drive must not exist.
    :type image: ~azure.mgmt.compute.v2018_04_01.models.VirtualHardDisk
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2018_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. Specifies how the virtual machine should be
     created.:code:`<br>`:code:`<br>` Possible values are::code:`<br>`:code:`<br>` **Attach** \u2013
     This value is used when you are using a specialized disk to create the virtual
     machine.:code:`<br>`:code:`<br>` **FromImage** \u2013 This value is used when you are using an
     image to create the virtual machine. If you are using a platform image, you also use the
     imageReference element described above. If you are using a marketplace image, you  also use the
     plan element previously described. Possible values include: "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2018_04_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk: ~azure.mgmt.compute.v2018_04_01.models.ManagedDiskParameters
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'os_type': {'key': 'osType', 'type': 'str'},
        'encryption_settings': {'key': 'encryptionSettings', 'type': 'DiskEncryptionSettings'},
        'name': {'key': 'name', 'type': 'str'},
        'vhd': {'key': 'vhd', 'type': 'VirtualHardDisk'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'ManagedDiskParameters'},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "DiskCreateOptionTypes"],
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        encryption_settings: Optional["DiskEncryptionSettings"] = None,
        name: Optional[str] = None,
        vhd: Optional["VirtualHardDisk"] = None,
        image: Optional["VirtualHardDisk"] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["ManagedDiskParameters"] = None,
        **kwargs
    ):
        super(OSDisk, self).__init__(**kwargs)
        self.os_type = os_type
        self.encryption_settings = encryption_settings
        self.name = name
        self.vhd = vhd
        self.image = image
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class OSDiskImage(msrest.serialization.Model):
    """Contains the os disk image information.

    All required parameters must be populated in order to send to Azure.

    :param operating_system: Required. The operating system of the osDiskImage. Possible values
     include: "Windows", "Linux".
    :type operating_system: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    """

    _validation = {
        'operating_system': {'required': True},
    }

    _attribute_map = {
        'operating_system': {'key': 'operatingSystem', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        operating_system: Union[str, "OperatingSystemTypes"],
        **kwargs
    ):
        super(OSDiskImage, self).__init__(**kwargs)
        self.operating_system = operating_system


class OSProfile(msrest.serialization.Model):
    """Specifies the operating system settings for the virtual machine.

    :param computer_name: Specifies the host OS name of the virtual machine.
     :code:`<br>`:code:`<br>` This name cannot be updated after the VM is created.
     :code:`<br>`:code:`<br>` **Max-length (Windows):** 15 characters :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters. :code:`<br>`:code:`<br>` For naming conventions and
     restrictions see `Azure infrastructure services implementation guidelines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-infrastructure-
     subscription-accounts-guidelines?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json#1-naming-
     conventions>`_.
    :type computer_name: str
    :param admin_username: Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
     :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
     "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
     "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
     "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
     characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
     root privileges on Linux virtual machines in Azure <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json>`_\ :code:`<br>`:code:`<li>` For a list of built-in system users on
     Linux that should not be used in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-
     usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-
     rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>` For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json#reset-root-password>`_.
    :type admin_password: str
    :param custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-
     init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type custom_data: str
    :param windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :type windows_configuration: ~azure.mgmt.compute.v2018_04_01.models.WindowsConfiguration
    :param linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for Non-
     Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type linux_configuration: ~azure.mgmt.compute.v2018_04_01.models.LinuxConfiguration
    :param secrets: Specifies set of certificates that should be installed onto the virtual
     machine.
    :type secrets: list[~azure.mgmt.compute.v2018_04_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(
        self,
        *,
        computer_name: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        linux_configuration: Optional["LinuxConfiguration"] = None,
        secrets: Optional[List["VaultSecretGroup"]] = None,
        **kwargs
    ):
        super(OSProfile, self).__init__(**kwargs)
        self.computer_name = computer_name
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class Plan(msrest.serialization.Model):
    """Specifies information about the marketplace image used to create the virtual machine. This element is only used for marketplace images. Before you can use a marketplace image from an API, you must enable the image for programmatic use.  In the Azure portal, find the marketplace image that you want to use and then click **Want to deploy programmatically, Get Started ->**. Enter any required information and then click **Save**.

    :param name: The plan ID.
    :type name: str
    :param publisher: The publisher ID.
    :type publisher: str
    :param product: Specifies the product of the image from the marketplace. This is the same value
     as Offer under the imageReference element.
    :type product: str
    :param promotion_code: The promotion code.
    :type promotion_code: str
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'publisher': {'key': 'publisher', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
        'promotion_code': {'key': 'promotionCode', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        publisher: Optional[str] = None,
        product: Optional[str] = None,
        promotion_code: Optional[str] = None,
        **kwargs
    ):
        super(Plan, self).__init__(**kwargs)
        self.name = name
        self.publisher = publisher
        self.product = product
        self.promotion_code = promotion_code


class ProximityPlacementGroup(Resource):
    """Specifies information about the proximity placement group.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param proximity_placement_group_type: Specifies the type of the proximity placement group.
     :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` **Standard** : Co-locate
     resources within an Azure region or Availability Zone. :code:`<br>`:code:`<br>` **Ultra** : For
     future use. Possible values include: "Standard", "Ultra".
    :type proximity_placement_group_type: str or
     ~azure.mgmt.compute.v2018_04_01.models.ProximityPlacementGroupType
    :ivar virtual_machines: A list of references to all virtual machines in the proximity placement
     group.
    :vartype virtual_machines: list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :ivar virtual_machine_scale_sets: A list of references to all virtual machine scale sets in the
     proximity placement group.
    :vartype virtual_machine_scale_sets: list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :ivar availability_sets: A list of references to all availability sets in the proximity
     placement group.
    :vartype availability_sets: list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'virtual_machines': {'readonly': True},
        'virtual_machine_scale_sets': {'readonly': True},
        'availability_sets': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'proximity_placement_group_type': {'key': 'properties.proximityPlacementGroupType', 'type': 'str'},
        'virtual_machines': {'key': 'properties.virtualMachines', 'type': '[SubResource]'},
        'virtual_machine_scale_sets': {'key': 'properties.virtualMachineScaleSets', 'type': '[SubResource]'},
        'availability_sets': {'key': 'properties.availabilitySets', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        proximity_placement_group_type: Optional[Union[str, "ProximityPlacementGroupType"]] = None,
        **kwargs
    ):
        super(ProximityPlacementGroup, self).__init__(location=location, tags=tags, **kwargs)
        self.proximity_placement_group_type = proximity_placement_group_type
        self.virtual_machines = None
        self.virtual_machine_scale_sets = None
        self.availability_sets = None


class ProximityPlacementGroupListResult(msrest.serialization.Model):
    """The List Proximity Placement Group operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of proximity placement groups.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.ProximityPlacementGroup]
    :param next_link: The URI to fetch the next page of proximity placement groups.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[ProximityPlacementGroup]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["ProximityPlacementGroup"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(ProximityPlacementGroupListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class ProximityPlacementGroupUpdate(UpdateResource):
    """Specifies information about the proximity placement group.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(ProximityPlacementGroupUpdate, self).__init__(tags=tags, **kwargs)


class PurchasePlan(msrest.serialization.Model):
    """Used for establishing the purchase context of any 3rd Party artifact through MarketPlace.

    All required parameters must be populated in order to send to Azure.

    :param publisher: Required. The publisher ID.
    :type publisher: str
    :param name: Required. The plan ID.
    :type name: str
    :param product: Required. Specifies the product of the image from the marketplace. This is the
     same value as Offer under the imageReference element.
    :type product: str
    """

    _validation = {
        'publisher': {'required': True},
        'name': {'required': True},
        'product': {'required': True},
    }

    _attribute_map = {
        'publisher': {'key': 'publisher', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'product': {'key': 'product', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        publisher: str,
        name: str,
        product: str,
        **kwargs
    ):
        super(PurchasePlan, self).__init__(**kwargs)
        self.publisher = publisher
        self.name = name
        self.product = product


class RecoveryWalkResponse(msrest.serialization.Model):
    """Response after calling a manual recovery walk.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar walk_performed: Whether the recovery walk was performed.
    :vartype walk_performed: bool
    :ivar next_platform_update_domain: The next update domain that needs to be walked. Null means
     walk spanning all update domains has been completed.
    :vartype next_platform_update_domain: int
    """

    _validation = {
        'walk_performed': {'readonly': True},
        'next_platform_update_domain': {'readonly': True},
    }

    _attribute_map = {
        'walk_performed': {'key': 'walkPerformed', 'type': 'bool'},
        'next_platform_update_domain': {'key': 'nextPlatformUpdateDomain', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RecoveryWalkResponse, self).__init__(**kwargs)
        self.walk_performed = None
        self.next_platform_update_domain = None


class RequestRateByIntervalInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getRequestRateByInterval Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    :param interval_length: Required. Interval value in minutes used to create LogAnalytics call
     rate logs. Possible values include: "ThreeMins", "FiveMins", "ThirtyMins", "SixtyMins".
    :type interval_length: str or ~azure.mgmt.compute.v2018_04_01.models.IntervalInMins
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
        'interval_length': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
        'interval_length': {'key': 'intervalLength', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        interval_length: Union[str, "IntervalInMins"],
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        **kwargs
    ):
        super(RequestRateByIntervalInput, self).__init__(blob_container_sas_uri=blob_container_sas_uri, from_time=from_time, to_time=to_time, group_by_throttle_policy=group_by_throttle_policy, group_by_operation_name=group_by_operation_name, group_by_resource_name=group_by_resource_name, **kwargs)
        self.interval_length = interval_length


class RollbackStatusInfo(msrest.serialization.Model):
    """Information about rollback on failed VM instances after a OS Upgrade operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successfully_rolledback_instance_count: The number of instances which have been
     successfully rolled back.
    :vartype successfully_rolledback_instance_count: int
    :ivar failed_rolledback_instance_count: The number of instances which failed to rollback.
    :vartype failed_rolledback_instance_count: int
    :ivar rollback_error: Error details if OS rollback failed.
    :vartype rollback_error: ~azure.mgmt.compute.v2018_04_01.models.ApiError
    """

    _validation = {
        'successfully_rolledback_instance_count': {'readonly': True},
        'failed_rolledback_instance_count': {'readonly': True},
        'rollback_error': {'readonly': True},
    }

    _attribute_map = {
        'successfully_rolledback_instance_count': {'key': 'successfullyRolledbackInstanceCount', 'type': 'int'},
        'failed_rolledback_instance_count': {'key': 'failedRolledbackInstanceCount', 'type': 'int'},
        'rollback_error': {'key': 'rollbackError', 'type': 'ApiError'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollbackStatusInfo, self).__init__(**kwargs)
        self.successfully_rolledback_instance_count = None
        self.failed_rolledback_instance_count = None
        self.rollback_error = None


class RollingUpgradePolicy(msrest.serialization.Model):
    """The configuration parameters used while performing a rolling upgrade.

    :param max_batch_instance_percent: The maximum percent of total virtual machine instances that
     will be upgraded simultaneously by the rolling upgrade in one batch. As this is a maximum,
     unhealthy instances in previous or future batches can cause the percentage of instances in a
     batch to decrease to ensure higher reliability. The default value for this parameter is 20%.
    :type max_batch_instance_percent: int
    :param max_unhealthy_instance_percent: The maximum percentage of the total virtual machine
     instances in the scale set that can be simultaneously unhealthy, either as a result of being
     upgraded, or by being found in an unhealthy state by the virtual machine health checks before
     the rolling upgrade aborts. This constraint will be checked prior to starting any batch. The
     default value for this parameter is 20%.
    :type max_unhealthy_instance_percent: int
    :param max_unhealthy_upgraded_instance_percent: The maximum percentage of upgraded virtual
     machine instances that can be found to be in an unhealthy state. This check will happen after
     each batch is upgraded. If this percentage is ever exceeded, the rolling update aborts. The
     default value for this parameter is 20%.
    :type max_unhealthy_upgraded_instance_percent: int
    :param pause_time_between_batches: The wait time between completing the update for all virtual
     machines in one batch and starting the next batch. The time duration should be specified in ISO
     8601 format. The default value is 0 seconds (PT0S).
    :type pause_time_between_batches: str
    """

    _validation = {
        'max_batch_instance_percent': {'maximum': 100, 'minimum': 5},
        'max_unhealthy_instance_percent': {'maximum': 100, 'minimum': 5},
        'max_unhealthy_upgraded_instance_percent': {'maximum': 100, 'minimum': 0},
    }

    _attribute_map = {
        'max_batch_instance_percent': {'key': 'maxBatchInstancePercent', 'type': 'int'},
        'max_unhealthy_instance_percent': {'key': 'maxUnhealthyInstancePercent', 'type': 'int'},
        'max_unhealthy_upgraded_instance_percent': {'key': 'maxUnhealthyUpgradedInstancePercent', 'type': 'int'},
        'pause_time_between_batches': {'key': 'pauseTimeBetweenBatches', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        max_batch_instance_percent: Optional[int] = None,
        max_unhealthy_instance_percent: Optional[int] = None,
        max_unhealthy_upgraded_instance_percent: Optional[int] = None,
        pause_time_between_batches: Optional[str] = None,
        **kwargs
    ):
        super(RollingUpgradePolicy, self).__init__(**kwargs)
        self.max_batch_instance_percent = max_batch_instance_percent
        self.max_unhealthy_instance_percent = max_unhealthy_instance_percent
        self.max_unhealthy_upgraded_instance_percent = max_unhealthy_upgraded_instance_percent
        self.pause_time_between_batches = pause_time_between_batches


class RollingUpgradeProgressInfo(msrest.serialization.Model):
    """Information about the number of virtual machine instances in each upgrade state.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar successful_instance_count: The number of instances that have been successfully upgraded.
    :vartype successful_instance_count: int
    :ivar failed_instance_count: The number of instances that have failed to be upgraded
     successfully.
    :vartype failed_instance_count: int
    :ivar in_progress_instance_count: The number of instances that are currently being upgraded.
    :vartype in_progress_instance_count: int
    :ivar pending_instance_count: The number of instances that have not yet begun to be upgraded.
    :vartype pending_instance_count: int
    """

    _validation = {
        'successful_instance_count': {'readonly': True},
        'failed_instance_count': {'readonly': True},
        'in_progress_instance_count': {'readonly': True},
        'pending_instance_count': {'readonly': True},
    }

    _attribute_map = {
        'successful_instance_count': {'key': 'successfulInstanceCount', 'type': 'int'},
        'failed_instance_count': {'key': 'failedInstanceCount', 'type': 'int'},
        'in_progress_instance_count': {'key': 'inProgressInstanceCount', 'type': 'int'},
        'pending_instance_count': {'key': 'pendingInstanceCount', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradeProgressInfo, self).__init__(**kwargs)
        self.successful_instance_count = None
        self.failed_instance_count = None
        self.in_progress_instance_count = None
        self.pending_instance_count = None


class RollingUpgradeRunningStatus(msrest.serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Possible values include:
     "RollingForward", "Cancelled", "Completed", "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2018_04_01.models.RollingUpgradeStatusCode
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar last_action: The last action performed on the rolling upgrade. Possible values include:
     "Start", "Cancel".
    :vartype last_action: str or ~azure.mgmt.compute.v2018_04_01.models.RollingUpgradeActionType
    :ivar last_action_time: Last action time of the upgrade.
    :vartype last_action_time: ~datetime.datetime
    """

    _validation = {
        'code': {'readonly': True},
        'start_time': {'readonly': True},
        'last_action': {'readonly': True},
        'last_action_time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'last_action': {'key': 'lastAction', 'type': 'str'},
        'last_action_time': {'key': 'lastActionTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(RollingUpgradeRunningStatus, self).__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.last_action = None
        self.last_action_time = None


class RollingUpgradeStatusInfo(Resource):
    """The status of the latest virtual machine scale set rolling upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar policy: The rolling upgrade policies applied for this upgrade.
    :vartype policy: ~azure.mgmt.compute.v2018_04_01.models.RollingUpgradePolicy
    :ivar running_status: Information about the current running state of the overall upgrade.
    :vartype running_status: ~azure.mgmt.compute.v2018_04_01.models.RollingUpgradeRunningStatus
    :ivar progress: Information about the number of virtual machine instances in each upgrade
     state.
    :vartype progress: ~azure.mgmt.compute.v2018_04_01.models.RollingUpgradeProgressInfo
    :ivar error: Error details for this upgrade, if there are any.
    :vartype error: ~azure.mgmt.compute.v2018_04_01.models.ApiError
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'policy': {'readonly': True},
        'running_status': {'readonly': True},
        'progress': {'readonly': True},
        'error': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'policy': {'key': 'properties.policy', 'type': 'RollingUpgradePolicy'},
        'running_status': {'key': 'properties.runningStatus', 'type': 'RollingUpgradeRunningStatus'},
        'progress': {'key': 'properties.progress', 'type': 'RollingUpgradeProgressInfo'},
        'error': {'key': 'properties.error', 'type': 'ApiError'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(RollingUpgradeStatusInfo, self).__init__(location=location, tags=tags, **kwargs)
        self.policy = None
        self.running_status = None
        self.progress = None
        self.error = None


class RunCommandDocumentBase(msrest.serialization.Model):
    """Describes the properties of a Run Command metadata.

    All required parameters must be populated in order to send to Azure.

    :param schema: Required. The VM run command schema.
    :type schema: str
    :param id: Required. The VM run command id.
    :type id: str
    :param os_type: Required. The Operating System type. Possible values include: "Windows",
     "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param label: Required. The VM run command label.
    :type label: str
    :param description: Required. The VM run command description.
    :type description: str
    """

    _validation = {
        'schema': {'required': True},
        'id': {'required': True},
        'os_type': {'required': True},
        'label': {'required': True},
        'description': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': '$schema', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,
        os_type: Union[str, "OperatingSystemTypes"],
        label: str,
        description: str,
        **kwargs
    ):
        super(RunCommandDocumentBase, self).__init__(**kwargs)
        self.schema = schema
        self.id = id
        self.os_type = os_type
        self.label = label
        self.description = description


class RunCommandDocument(RunCommandDocumentBase):
    """Describes the properties of a Run Command.

    All required parameters must be populated in order to send to Azure.

    :param schema: Required. The VM run command schema.
    :type schema: str
    :param id: Required. The VM run command id.
    :type id: str
    :param os_type: Required. The Operating System type. Possible values include: "Windows",
     "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param label: Required. The VM run command label.
    :type label: str
    :param description: Required. The VM run command description.
    :type description: str
    :param script: Required. The script to be executed.
    :type script: list[str]
    :param parameters: The parameters used by the script.
    :type parameters: list[~azure.mgmt.compute.v2018_04_01.models.RunCommandParameterDefinition]
    """

    _validation = {
        'schema': {'required': True},
        'id': {'required': True},
        'os_type': {'required': True},
        'label': {'required': True},
        'description': {'required': True},
        'script': {'required': True},
    }

    _attribute_map = {
        'schema': {'key': '$schema', 'type': 'str'},
        'id': {'key': 'id', 'type': 'str'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'label': {'key': 'label', 'type': 'str'},
        'description': {'key': 'description', 'type': 'str'},
        'script': {'key': 'script', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': '[RunCommandParameterDefinition]'},
    }

    def __init__(
        self,
        *,
        schema: str,
        id: str,
        os_type: Union[str, "OperatingSystemTypes"],
        label: str,
        description: str,
        script: List[str],
        parameters: Optional[List["RunCommandParameterDefinition"]] = None,
        **kwargs
    ):
        super(RunCommandDocument, self).__init__(schema=schema, id=id, os_type=os_type, label=label, description=description, **kwargs)
        self.script = script
        self.parameters = parameters


class RunCommandInput(msrest.serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :param command_id: Required. The run command id.
    :type command_id: str
    :param script: Optional. The script to be executed.  When this value is given, the given script
     will override the default script of the command.
    :type script: list[str]
    :param parameters: The run command parameters.
    :type parameters: list[~azure.mgmt.compute.v2018_04_01.models.RunCommandInputParameter]
    """

    _validation = {
        'command_id': {'required': True},
    }

    _attribute_map = {
        'command_id': {'key': 'commandId', 'type': 'str'},
        'script': {'key': 'script', 'type': '[str]'},
        'parameters': {'key': 'parameters', 'type': '[RunCommandInputParameter]'},
    }

    def __init__(
        self,
        *,
        command_id: str,
        script: Optional[List[str]] = None,
        parameters: Optional[List["RunCommandInputParameter"]] = None,
        **kwargs
    ):
        super(RunCommandInput, self).__init__(**kwargs)
        self.command_id = command_id
        self.script = script
        self.parameters = parameters


class RunCommandInputParameter(msrest.serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The run command parameter name.
    :type name: str
    :param value: Required. The run command parameter value.
    :type value: str
    """

    _validation = {
        'name': {'required': True},
        'value': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'value': {'key': 'value', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: str,
        value: str,
        **kwargs
    ):
        super(RunCommandInputParameter, self).__init__(**kwargs)
        self.name = name
        self.value = value


class RunCommandListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine run commands.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.RunCommandDocumentBase]
    :param next_link: The uri to fetch the next page of run commands. Call ListNext() with this to
     fetch the next page of run commands.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[RunCommandDocumentBase]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["RunCommandDocumentBase"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(RunCommandListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class RunCommandParameterDefinition(msrest.serialization.Model):
    """Describes the properties of a run command parameter.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The run command parameter name.
    :type name: str
    :param type: Required. The run command parameter type.
    :type type: str
    :param default_value: The run command parameter default value.
    :type default_value: str
    :param required: The run command parameter required.
    :type required: bool
    """

    _validation = {
        'name': {'required': True},
        'type': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'default_value': {'key': 'defaultValue', 'type': 'str'},
        'required': {'key': 'required', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        type: str,
        default_value: Optional[str] = None,
        required: Optional[bool] = False,
        **kwargs
    ):
        super(RunCommandParameterDefinition, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.default_value = default_value
        self.required = required


class RunCommandResult(msrest.serialization.Model):
    """RunCommandResult.

    :param value: Run command operation response.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(RunCommandResult, self).__init__(**kwargs)
        self.value = value


class Sku(msrest.serialization.Model):
    """Describes a virtual machine scale set sku. NOTE: If the new VM SKU is not supported on the hardware the scale set is currently on, you need to deallocate the VMs in the scale set before you modify the SKU name.

    :param name: The sku name.
    :type name: str
    :param tier: Specifies the tier of virtual machines in a scale set.:code:`<br />`:code:`<br />`
     Possible Values::code:`<br />`:code:`<br />` **Standard**\ :code:`<br />`:code:`<br />`
     **Basic**.
    :type tier: str
    :param capacity: Specifies the number of virtual machines in the scale set.
    :type capacity: long
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
        'capacity': {'key': 'capacity', 'type': 'long'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        tier: Optional[str] = None,
        capacity: Optional[int] = None,
        **kwargs
    ):
        super(Sku, self).__init__(**kwargs)
        self.name = name
        self.tier = tier
        self.capacity = capacity


class Snapshot(Resource):
    """Snapshot resource.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar managed_by: Unused. Always Null.
    :vartype managed_by: str
    :param sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.SnapshotSku
    :ivar time_created: The time when the disk was created.
    :vartype time_created: ~datetime.datetime
    :param os_type: The Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param creation_data: Disk source information. CreationData information cannot be changed after
     the disk has been created.
    :type creation_data: ~azure.mgmt.compute.v2018_04_01.models.CreationData
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings: Encryption settings for disk or snapshot.
    :type encryption_settings: ~azure.mgmt.compute.v2018_04_01.models.EncryptionSettings
    :ivar provisioning_state: The disk provisioning state.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'managed_by': {'readonly': True},
        'time_created': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'managed_by': {'key': 'managedBy', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'SnapshotSku'},
        'time_created': {'key': 'properties.timeCreated', 'type': 'iso-8601'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'creation_data': {'key': 'properties.creationData', 'type': 'CreationData'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings': {'key': 'properties.encryptionSettings', 'type': 'EncryptionSettings'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SnapshotSku"] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        creation_data: Optional["CreationData"] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["EncryptionSettings"] = None,
        **kwargs
    ):
        super(Snapshot, self).__init__(location=location, tags=tags, **kwargs)
        self.managed_by = None
        self.sku = sku
        self.time_created = None
        self.os_type = os_type
        self.creation_data = creation_data
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings
        self.provisioning_state = None


class SnapshotList(msrest.serialization.Model):
    """The List Snapshots operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. A list of snapshots.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.Snapshot]
    :param next_link: The uri to fetch the next page of snapshots. Call ListNext() with this to
     fetch the next page of snapshots.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[Snapshot]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["Snapshot"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(SnapshotList, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class SnapshotSku(msrest.serialization.Model):
    """The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param name: The sku name. Possible values include: "Standard_LRS", "Premium_LRS",
     "Standard_ZRS".
    :type name: str or ~azure.mgmt.compute.v2018_04_01.models.SnapshotStorageAccountTypes
    :ivar tier: The sku tier.
    :vartype tier: str
    """

    _validation = {
        'tier': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'tier': {'key': 'tier', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[Union[str, "SnapshotStorageAccountTypes"]] = None,
        **kwargs
    ):
        super(SnapshotSku, self).__init__(**kwargs)
        self.name = name
        self.tier = None


class SnapshotUpdate(msrest.serialization.Model):
    """Snapshot update resource.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The snapshots sku name. Can be Standard_LRS, Premium_LRS, or Standard_ZRS.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.SnapshotSku
    :param os_type: the Operating System type. Possible values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param disk_size_gb: If creationData.createOption is Empty, this field is mandatory and it
     indicates the size of the VHD to create. If this field is present for updates or creation with
     other options, it indicates a resize. Resizes are only allowed if the disk is not attached to a
     running VM, and can only increase the disk's size.
    :type disk_size_gb: int
    :param encryption_settings: Encryption settings for disk or snapshot.
    :type encryption_settings: ~azure.mgmt.compute.v2018_04_01.models.EncryptionSettings
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'SnapshotSku'},
        'os_type': {'key': 'properties.osType', 'type': 'str'},
        'disk_size_gb': {'key': 'properties.diskSizeGB', 'type': 'int'},
        'encryption_settings': {'key': 'properties.encryptionSettings', 'type': 'EncryptionSettings'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["SnapshotSku"] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        disk_size_gb: Optional[int] = None,
        encryption_settings: Optional["EncryptionSettings"] = None,
        **kwargs
    ):
        super(SnapshotUpdate, self).__init__(**kwargs)
        self.tags = tags
        self.sku = sku
        self.os_type = os_type
        self.disk_size_gb = disk_size_gb
        self.encryption_settings = encryption_settings


class SourceVault(msrest.serialization.Model):
    """The vault id is an Azure Resource Manager Resource id in the form /subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.KeyVault/vaults/{vaultName}.

    :param id: Resource Id.
    :type id: str
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(SourceVault, self).__init__(**kwargs)
        self.id = id


class SshConfiguration(msrest.serialization.Model):
    """SSH configuration for Linux based VMs running on Azure.

    :param public_keys: The list of SSH public keys used to authenticate with linux based VMs.
    :type public_keys: list[~azure.mgmt.compute.v2018_04_01.models.SshPublicKey]
    """

    _attribute_map = {
        'public_keys': {'key': 'publicKeys', 'type': '[SshPublicKey]'},
    }

    def __init__(
        self,
        *,
        public_keys: Optional[List["SshPublicKey"]] = None,
        **kwargs
    ):
        super(SshConfiguration, self).__init__(**kwargs)
        self.public_keys = public_keys


class SshPublicKey(msrest.serialization.Model):
    """Contains information about SSH certificate public key and the path on the Linux VM where the public key is placed.

    :param path: Specifies the full path on the created VM where ssh public key is stored. If the
     file already exists, the specified key is appended to the file. Example:
     /home/user/.ssh/authorized_keys.
    :type path: str
    :param key_data: SSH public key certificate used to authenticate with the VM through ssh. The
     key needs to be at least 2048-bit and in ssh-rsa format. :code:`<br>`:code:`<br>` For creating
     ssh keys, see `Create SSH keys on Linux and Mac for Linux VMs in Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-mac-create-ssh-
     keys?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type key_data: str
    """

    _attribute_map = {
        'path': {'key': 'path', 'type': 'str'},
        'key_data': {'key': 'keyData', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        path: Optional[str] = None,
        key_data: Optional[str] = None,
        **kwargs
    ):
        super(SshPublicKey, self).__init__(**kwargs)
        self.path = path
        self.key_data = key_data


class StorageProfile(msrest.serialization.Model):
    """Specifies the storage settings for the virtual machine disks.

    :param image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :type image_reference: ~azure.mgmt.compute.v2018_04_01.models.ImageReference
    :param os_disk: Specifies information about the operating system disk used by the virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type os_disk: ~azure.mgmt.compute.v2018_04_01.models.OSDisk
    :param data_disks: Specifies the parameters that are used to add a data disk to a virtual
     machine. :code:`<br>`:code:`<br>` For more information about disks, see `About disks and VHDs
     for Azure virtual machines <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     windows-about-disks-vhds?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_.
    :type data_disks: list[~azure.mgmt.compute.v2018_04_01.models.DataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'OSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[DataDisk]'},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["ImageReference"] = None,
        os_disk: Optional["OSDisk"] = None,
        data_disks: Optional[List["DataDisk"]] = None,
        **kwargs
    ):
        super(StorageProfile, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class SubResourceReadOnly(msrest.serialization.Model):
    """SubResourceReadOnly.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    """

    _validation = {
        'id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(SubResourceReadOnly, self).__init__(**kwargs)
        self.id = None


class ThrottledRequestsInput(LogAnalyticsInputBase):
    """Api request input for LogAnalytics getThrottledRequests Api.

    All required parameters must be populated in order to send to Azure.

    :param blob_container_sas_uri: Required. SAS Uri of the logging blob container to which
     LogAnalytics Api writes output logs to.
    :type blob_container_sas_uri: str
    :param from_time: Required. From time of the query.
    :type from_time: ~datetime.datetime
    :param to_time: Required. To time of the query.
    :type to_time: ~datetime.datetime
    :param group_by_throttle_policy: Group query result by Throttle Policy applied.
    :type group_by_throttle_policy: bool
    :param group_by_operation_name: Group query result by Operation Name.
    :type group_by_operation_name: bool
    :param group_by_resource_name: Group query result by Resource Name.
    :type group_by_resource_name: bool
    """

    _validation = {
        'blob_container_sas_uri': {'required': True},
        'from_time': {'required': True},
        'to_time': {'required': True},
    }

    _attribute_map = {
        'blob_container_sas_uri': {'key': 'blobContainerSasUri', 'type': 'str'},
        'from_time': {'key': 'fromTime', 'type': 'iso-8601'},
        'to_time': {'key': 'toTime', 'type': 'iso-8601'},
        'group_by_throttle_policy': {'key': 'groupByThrottlePolicy', 'type': 'bool'},
        'group_by_operation_name': {'key': 'groupByOperationName', 'type': 'bool'},
        'group_by_resource_name': {'key': 'groupByResourceName', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        blob_container_sas_uri: str,
        from_time: datetime.datetime,
        to_time: datetime.datetime,
        group_by_throttle_policy: Optional[bool] = None,
        group_by_operation_name: Optional[bool] = None,
        group_by_resource_name: Optional[bool] = None,
        **kwargs
    ):
        super(ThrottledRequestsInput, self).__init__(blob_container_sas_uri=blob_container_sas_uri, from_time=from_time, to_time=to_time, group_by_throttle_policy=group_by_throttle_policy, group_by_operation_name=group_by_operation_name, group_by_resource_name=group_by_resource_name, **kwargs)


class UpgradeOperationHistoricalStatusInfo(msrest.serialization.Model):
    """Virtual Machine Scale Set OS Upgrade History operation response.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar properties: Information about the properties of the upgrade operation.
    :vartype properties:
     ~azure.mgmt.compute.v2018_04_01.models.UpgradeOperationHistoricalStatusInfoProperties
    :ivar type: Resource type.
    :vartype type: str
    :ivar location: Resource location.
    :vartype location: str
    """

    _validation = {
        'properties': {'readonly': True},
        'type': {'readonly': True},
        'location': {'readonly': True},
    }

    _attribute_map = {
        'properties': {'key': 'properties', 'type': 'UpgradeOperationHistoricalStatusInfoProperties'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoricalStatusInfo, self).__init__(**kwargs)
        self.properties = None
        self.type = None
        self.location = None


class UpgradeOperationHistoricalStatusInfoProperties(msrest.serialization.Model):
    """Describes each OS upgrade on the Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar running_status: Information about the overall status of the upgrade operation.
    :vartype running_status: ~azure.mgmt.compute.v2018_04_01.models.UpgradeOperationHistoryStatus
    :ivar progress: Counts of the VMs in each state.
    :vartype progress: ~azure.mgmt.compute.v2018_04_01.models.RollingUpgradeProgressInfo
    :ivar error: Error Details for this upgrade if there are any.
    :vartype error: ~azure.mgmt.compute.v2018_04_01.models.ApiError
    :ivar started_by: Invoker of the Upgrade Operation. Possible values include: "Unknown", "User",
     "Platform".
    :vartype started_by: str or ~azure.mgmt.compute.v2018_04_01.models.UpgradeOperationInvoker
    :ivar target_image_reference: Image Reference details.
    :vartype target_image_reference: ~azure.mgmt.compute.v2018_04_01.models.ImageReference
    :ivar rollback_info: Information about OS rollback if performed.
    :vartype rollback_info: ~azure.mgmt.compute.v2018_04_01.models.RollbackStatusInfo
    """

    _validation = {
        'running_status': {'readonly': True},
        'progress': {'readonly': True},
        'error': {'readonly': True},
        'started_by': {'readonly': True},
        'target_image_reference': {'readonly': True},
        'rollback_info': {'readonly': True},
    }

    _attribute_map = {
        'running_status': {'key': 'runningStatus', 'type': 'UpgradeOperationHistoryStatus'},
        'progress': {'key': 'progress', 'type': 'RollingUpgradeProgressInfo'},
        'error': {'key': 'error', 'type': 'ApiError'},
        'started_by': {'key': 'startedBy', 'type': 'str'},
        'target_image_reference': {'key': 'targetImageReference', 'type': 'ImageReference'},
        'rollback_info': {'key': 'rollbackInfo', 'type': 'RollbackStatusInfo'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoricalStatusInfoProperties, self).__init__(**kwargs)
        self.running_status = None
        self.progress = None
        self.error = None
        self.started_by = None
        self.target_image_reference = None
        self.rollback_info = None


class UpgradeOperationHistoryStatus(msrest.serialization.Model):
    """Information about the current running state of the overall upgrade.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: Code indicating the current status of the upgrade. Possible values include:
     "RollingForward", "Cancelled", "Completed", "Faulted".
    :vartype code: str or ~azure.mgmt.compute.v2018_04_01.models.UpgradeState
    :ivar start_time: Start time of the upgrade.
    :vartype start_time: ~datetime.datetime
    :ivar end_time: End time of the upgrade.
    :vartype end_time: ~datetime.datetime
    """

    _validation = {
        'code': {'readonly': True},
        'start_time': {'readonly': True},
        'end_time': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'start_time': {'key': 'startTime', 'type': 'iso-8601'},
        'end_time': {'key': 'endTime', 'type': 'iso-8601'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(UpgradeOperationHistoryStatus, self).__init__(**kwargs)
        self.code = None
        self.start_time = None
        self.end_time = None


class UpgradePolicy(msrest.serialization.Model):
    """Describes an upgrade policy - automatic, manual, or rolling.

    :param mode: Specifies the mode of an upgrade to virtual machines in the scale set.:code:`<br
     />`:code:`<br />` Possible values are::code:`<br />`:code:`<br />` **Manual** - You  control
     the application of updates to virtual machines in the scale set. You do this by using the
     manualUpgrade action.:code:`<br />`:code:`<br />` **Automatic** - All virtual machines in the
     scale set are  automatically updated at the same time. Possible values include: "Automatic",
     "Manual", "Rolling".
    :type mode: str or ~azure.mgmt.compute.v2018_04_01.models.UpgradeMode
    :param rolling_upgrade_policy: The configuration parameters used while performing a rolling
     upgrade.
    :type rolling_upgrade_policy: ~azure.mgmt.compute.v2018_04_01.models.RollingUpgradePolicy
    :param automatic_os_upgrade: Whether OS upgrades should automatically be applied to scale set
     instances in a rolling fashion when a newer version of the image becomes available.
    :type automatic_os_upgrade: bool
    :param auto_os_upgrade_policy: Configuration parameters used for performing automatic OS
     Upgrade.
    :type auto_os_upgrade_policy: ~azure.mgmt.compute.v2018_04_01.models.AutoOSUpgradePolicy
    """

    _attribute_map = {
        'mode': {'key': 'mode', 'type': 'str'},
        'rolling_upgrade_policy': {'key': 'rollingUpgradePolicy', 'type': 'RollingUpgradePolicy'},
        'automatic_os_upgrade': {'key': 'automaticOSUpgrade', 'type': 'bool'},
        'auto_os_upgrade_policy': {'key': 'autoOSUpgradePolicy', 'type': 'AutoOSUpgradePolicy'},
    }

    def __init__(
        self,
        *,
        mode: Optional[Union[str, "UpgradeMode"]] = None,
        rolling_upgrade_policy: Optional["RollingUpgradePolicy"] = None,
        automatic_os_upgrade: Optional[bool] = None,
        auto_os_upgrade_policy: Optional["AutoOSUpgradePolicy"] = None,
        **kwargs
    ):
        super(UpgradePolicy, self).__init__(**kwargs)
        self.mode = mode
        self.rolling_upgrade_policy = rolling_upgrade_policy
        self.automatic_os_upgrade = automatic_os_upgrade
        self.auto_os_upgrade_policy = auto_os_upgrade_policy


class Usage(msrest.serialization.Model):
    """Describes Compute Resource Usage.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar unit: Required. An enum describing the unit of usage measurement. Default value: "Count".
    :vartype unit: str
    :param current_value: Required. The current usage of the resource.
    :type current_value: int
    :param limit: Required. The maximum permitted usage of the resource.
    :type limit: long
    :param name: Required. The name of the type of usage.
    :type name: ~azure.mgmt.compute.v2018_04_01.models.UsageName
    """

    _validation = {
        'unit': {'required': True, 'constant': True},
        'current_value': {'required': True},
        'limit': {'required': True},
        'name': {'required': True},
    }

    _attribute_map = {
        'unit': {'key': 'unit', 'type': 'str'},
        'current_value': {'key': 'currentValue', 'type': 'int'},
        'limit': {'key': 'limit', 'type': 'long'},
        'name': {'key': 'name', 'type': 'UsageName'},
    }

    unit = "Count"

    def __init__(
        self,
        *,
        current_value: int,
        limit: int,
        name: "UsageName",
        **kwargs
    ):
        super(Usage, self).__init__(**kwargs)
        self.current_value = current_value
        self.limit = limit
        self.name = name


class UsageName(msrest.serialization.Model):
    """The Usage Names.

    :param value: The name of the resource.
    :type value: str
    :param localized_value: The localized name of the resource.
    :type localized_value: str
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': 'str'},
        'localized_value': {'key': 'localizedValue', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: Optional[str] = None,
        localized_value: Optional[str] = None,
        **kwargs
    ):
        super(UsageName, self).__init__(**kwargs)
        self.value = value
        self.localized_value = localized_value


class VaultCertificate(msrest.serialization.Model):
    """Describes a single certificate reference in a Key Vault, and where the certificate should reside on the VM.

    :param certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`  "data":":code:`<Base64-encoded-
     certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`  "password":":code:`<pfx-file-
     password>`":code:`<br>`}.
    :type certificate_url: str
    :param certificate_store: For Windows VMs, specifies the certificate store on the Virtual
     Machine to which the certificate should be added. The specified certificate store is implicitly
     in the LocalMachine account. :code:`<br>`:code:`<br>`For Linux VMs, the certificate file is
     placed under the /var/lib/waagent directory, with the file name &lt;UppercaseThumbprint&gt;.crt
     for the X509 certificate file and &lt;UppercaseThumbprint&gt;.prv for private key. Both of
     these files are .pem formatted.
    :type certificate_store: str
    """

    _attribute_map = {
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
        'certificate_store': {'key': 'certificateStore', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        certificate_url: Optional[str] = None,
        certificate_store: Optional[str] = None,
        **kwargs
    ):
        super(VaultCertificate, self).__init__(**kwargs)
        self.certificate_url = certificate_url
        self.certificate_store = certificate_store


class VaultSecretGroup(msrest.serialization.Model):
    """Describes a set of certificates which are all in the same Key Vault.

    :param source_vault: The relative URL of the Key Vault containing all of the certificates in
     VaultCertificates.
    :type source_vault: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param vault_certificates: The list of key vault references in SourceVault which contain
     certificates.
    :type vault_certificates: list[~azure.mgmt.compute.v2018_04_01.models.VaultCertificate]
    """

    _attribute_map = {
        'source_vault': {'key': 'sourceVault', 'type': 'SubResource'},
        'vault_certificates': {'key': 'vaultCertificates', 'type': '[VaultCertificate]'},
    }

    def __init__(
        self,
        *,
        source_vault: Optional["SubResource"] = None,
        vault_certificates: Optional[List["VaultCertificate"]] = None,
        **kwargs
    ):
        super(VaultSecretGroup, self).__init__(**kwargs)
        self.source_vault = source_vault
        self.vault_certificates = vault_certificates


class VirtualHardDisk(msrest.serialization.Model):
    """Describes the uri of a disk.

    :param uri: Specifies the virtual hard disk's uri.
    :type uri: str
    """

    _attribute_map = {
        'uri': {'key': 'uri', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        uri: Optional[str] = None,
        **kwargs
    ):
        super(VirtualHardDisk, self).__init__(**kwargs)
        self.uri = uri


class VirtualMachine(Resource):
    """Describes a Virtual Machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2018_04_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineExtension]
    :param identity: The identity of the virtual machine, if configured.
    :type identity: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineIdentity
    :param zones: The virtual machine zones.
    :type zones: list[str]
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2018_04_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2018_04_01.models.StorageProfile
    :param os_profile: Specifies the operating system settings for the virtual machine.
    :type os_profile: ~azure.mgmt.compute.v2018_04_01.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2018_04_01.models.NetworkProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2018_04_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-
     availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>`
     For more information on Azure planned maintenance, see `Planned maintenance for virtual
     machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-
     planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :type availability_set: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineInstanceView
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-
     licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>`
     Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'resources': {'readonly': True},
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
        'vm_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        hardware_profile: Optional["HardwareProfile"] = None,
        storage_profile: Optional["StorageProfile"] = None,
        os_profile: Optional["OSProfile"] = None,
        network_profile: Optional["NetworkProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        availability_set: Optional["SubResource"] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachine, self).__init__(location=location, tags=tags, **kwargs)
        self.plan = plan
        self.resources = None
        self.identity = identity
        self.zones = zones
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.proximity_placement_group = proximity_placement_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None


class VirtualMachineAgentInstanceView(msrest.serialization.Model):
    """The instance view of the VM Agent running on the virtual machine.

    :param vm_agent_version: The VM Agent full version.
    :type vm_agent_version: str
    :param extension_handlers: The virtual machine extension handler instance view.
    :type extension_handlers:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineExtensionHandlerInstanceView]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'vm_agent_version': {'key': 'vmAgentVersion', 'type': 'str'},
        'extension_handlers': {'key': 'extensionHandlers', 'type': '[VirtualMachineExtensionHandlerInstanceView]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        vm_agent_version: Optional[str] = None,
        extension_handlers: Optional[List["VirtualMachineExtensionHandlerInstanceView"]] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineAgentInstanceView, self).__init__(**kwargs)
        self.vm_agent_version = vm_agent_version
        self.extension_handlers = extension_handlers
        self.statuses = statuses


class VirtualMachineCaptureParameters(msrest.serialization.Model):
    """Capture Virtual Machine parameters.

    All required parameters must be populated in order to send to Azure.

    :param vhd_prefix: Required. The captured virtual hard disk's name prefix.
    :type vhd_prefix: str
    :param destination_container_name: Required. The destination container name.
    :type destination_container_name: str
    :param overwrite_vhds: Required. Specifies whether to overwrite the destination virtual hard
     disk, in case of conflict.
    :type overwrite_vhds: bool
    """

    _validation = {
        'vhd_prefix': {'required': True},
        'destination_container_name': {'required': True},
        'overwrite_vhds': {'required': True},
    }

    _attribute_map = {
        'vhd_prefix': {'key': 'vhdPrefix', 'type': 'str'},
        'destination_container_name': {'key': 'destinationContainerName', 'type': 'str'},
        'overwrite_vhds': {'key': 'overwriteVhds', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        vhd_prefix: str,
        destination_container_name: str,
        overwrite_vhds: bool,
        **kwargs
    ):
        super(VirtualMachineCaptureParameters, self).__init__(**kwargs)
        self.vhd_prefix = vhd_prefix
        self.destination_container_name = destination_container_name
        self.overwrite_vhds = overwrite_vhds


class VirtualMachineCaptureResult(SubResource):
    """Output of virtual machine capture operation.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param id: Resource Id.
    :type id: str
    :ivar schema: the schema of the captured virtual machine.
    :vartype schema: str
    :ivar content_version: the version of the content.
    :vartype content_version: str
    :ivar parameters: parameters of the captured virtual machine.
    :vartype parameters: object
    :ivar resources: a list of resource items of the captured virtual machine.
    :vartype resources: list[object]
    """

    _validation = {
        'schema': {'readonly': True},
        'content_version': {'readonly': True},
        'parameters': {'readonly': True},
        'resources': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'schema': {'key': '$schema', 'type': 'str'},
        'content_version': {'key': 'contentVersion', 'type': 'str'},
        'parameters': {'key': 'parameters', 'type': 'object'},
        'resources': {'key': 'resources', 'type': '[object]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineCaptureResult, self).__init__(id=id, **kwargs)
        self.schema = None
        self.content_version = None
        self.parameters = None
        self.resources = None


class VirtualMachineExtension(Resource):
    """Describes a Virtual Machine Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type_properties_type: Specifies the type of the extension; an example is
     "CustomScriptExtension".
    :type type_properties_type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param instance_view: The virtual machine extension instance view.
    :type instance_view: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineExtensionInstanceView
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type_properties_type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineExtensionInstanceView'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type_properties_type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[object] = None,
        protected_settings: Optional[object] = None,
        instance_view: Optional["VirtualMachineExtensionInstanceView"] = None,
        **kwargs
    ):
        super(VirtualMachineExtension, self).__init__(location=location, tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type_properties_type = type_properties_type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None
        self.instance_view = instance_view


class VirtualMachineExtensionHandlerInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine extension handler.

    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param status: The extension handler status.
    :type status: ~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus
    """

    _attribute_map = {
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        *,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        status: Optional["InstanceViewStatus"] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionHandlerInstanceView, self).__init__(**kwargs)
        self.type = type
        self.type_handler_version = type_handler_version
        self.status = status


class VirtualMachineExtensionImage(Resource):
    """Describes a Virtual Machine Extension Image.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param operating_system: The operating system this extension supports.
    :type operating_system: str
    :param compute_role: The type of role (IaaS or PaaS) this extension supports.
    :type compute_role: str
    :param handler_schema: The schema defined by publisher, where extension consumers should
     provide settings in a matching schema.
    :type handler_schema: str
    :param vm_scale_set_enabled: Whether the extension can be used on xRP VMScaleSets. By default
     existing extensions are usable on scalesets, but there might be cases where a publisher wants
     to explicitly indicate the extension is only enabled for CRP VMs but not VMSS.
    :type vm_scale_set_enabled: bool
    :param supports_multiple_extensions: Whether the handler can support multiple extensions.
    :type supports_multiple_extensions: bool
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'operating_system': {'key': 'properties.operatingSystem', 'type': 'str'},
        'compute_role': {'key': 'properties.computeRole', 'type': 'str'},
        'handler_schema': {'key': 'properties.handlerSchema', 'type': 'str'},
        'vm_scale_set_enabled': {'key': 'properties.vmScaleSetEnabled', 'type': 'bool'},
        'supports_multiple_extensions': {'key': 'properties.supportsMultipleExtensions', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        operating_system: Optional[str] = None,
        compute_role: Optional[str] = None,
        handler_schema: Optional[str] = None,
        vm_scale_set_enabled: Optional[bool] = None,
        supports_multiple_extensions: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionImage, self).__init__(location=location, tags=tags, **kwargs)
        self.operating_system = operating_system
        self.compute_role = compute_role
        self.handler_schema = handler_schema
        self.vm_scale_set_enabled = vm_scale_set_enabled
        self.supports_multiple_extensions = supports_multiple_extensions


class VirtualMachineExtensionInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine extension.

    :param name: The virtual machine extension name.
    :type name: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param substatuses: The resource status information.
    :type substatuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'type_handler_version': {'key': 'typeHandlerVersion', 'type': 'str'},
        'substatuses': {'key': 'substatuses', 'type': '[InstanceViewStatus]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        substatuses: Optional[List["InstanceViewStatus"]] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionInstanceView, self).__init__(**kwargs)
        self.name = name
        self.type = type
        self.type_handler_version = type_handler_version
        self.substatuses = substatuses
        self.statuses = statuses


class VirtualMachineExtensionsListResult(msrest.serialization.Model):
    """The List Extension operation response.

    :param value: The list of extensions.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineExtension]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineExtension]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualMachineExtension"]] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionsListResult, self).__init__(**kwargs)
        self.value = value


class VirtualMachineExtensionUpdate(UpdateResource):
    """Describes a Virtual Machine Extension.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param force_update_tag: How the extension handler should be forced to update even if the
     extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[object] = None,
        protected_settings: Optional[object] = None,
        **kwargs
    ):
        super(VirtualMachineExtensionUpdate, self).__init__(tags=tags, **kwargs)
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings


class VirtualMachineHealthStatus(msrest.serialization.Model):
    """The health status of the VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar status: The health status information for the VM.
    :vartype status: ~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus
    """

    _validation = {
        'status': {'readonly': True},
    }

    _attribute_map = {
        'status': {'key': 'status', 'type': 'InstanceViewStatus'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineHealthStatus, self).__init__(**kwargs)
        self.status = None


class VirtualMachineIdentity(msrest.serialization.Model):
    """Identity for the virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine identity. This property will only be
     provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine. This property will only be
     provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the virtual machine. The type 'SystemAssigned,
     UserAssigned' includes both an implicitly created identity and a set of user assigned
     identities. The type 'None' will remove any identities from the virtual machine. Possible
     values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned", "None".
    :type type: str or ~azure.mgmt.compute.v2018_04_01.models.ResourceIdentityType
    :param identity_ids: The list of user identities associated with the Virtual Machine. The user
     identity references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
    :type identity_ids: list[str]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity_ids': {'key': 'identityIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        identity_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.identity_ids = identity_ids


class VirtualMachineImageResource(SubResource):
    """Virtual machine image resource information.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: A set of tags. Specifies the tags that are assigned to the virtual machine. For
     more information about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :type tags: dict[str, str]
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        **kwargs
    ):
        super(VirtualMachineImageResource, self).__init__(id=id, **kwargs)
        self.name = name
        self.location = location
        self.tags = tags


class VirtualMachineImage(VirtualMachineImageResource):
    """Describes a Virtual Machine Image.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The name of the resource.
    :type name: str
    :param location: Required. The supported Azure location of the resource.
    :type location: str
    :param tags: A set of tags. Specifies the tags that are assigned to the virtual machine. For
     more information about using tags, see `Using tags to organize your Azure resources
     <https://docs.microsoft.com/azure/azure-resource-manager/resource-group-using-tags.md>`_.
    :type tags: dict[str, str]
    :param plan: Used for establishing the purchase context of any 3rd Party artifact through
     MarketPlace.
    :type plan: ~azure.mgmt.compute.v2018_04_01.models.PurchasePlan
    :param os_disk_image: Contains the os disk image information.
    :type os_disk_image: ~azure.mgmt.compute.v2018_04_01.models.OSDiskImage
    :param data_disk_images:
    :type data_disk_images: list[~azure.mgmt.compute.v2018_04_01.models.DataDiskImage]
    """

    _validation = {
        'name': {'required': True},
        'location': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'properties.plan', 'type': 'PurchasePlan'},
        'os_disk_image': {'key': 'properties.osDiskImage', 'type': 'OSDiskImage'},
        'data_disk_images': {'key': 'properties.dataDiskImages', 'type': '[DataDiskImage]'},
    }

    def __init__(
        self,
        *,
        name: str,
        location: str,
        id: Optional[str] = None,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["PurchasePlan"] = None,
        os_disk_image: Optional["OSDiskImage"] = None,
        data_disk_images: Optional[List["DataDiskImage"]] = None,
        **kwargs
    ):
        super(VirtualMachineImage, self).__init__(id=id, name=name, location=location, tags=tags, **kwargs)
        self.plan = plan
        self.os_disk_image = os_disk_image
        self.data_disk_images = data_disk_images


class VirtualMachineInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine.

    :param platform_update_domain: Specifies the update domain of the virtual machine.
    :type platform_update_domain: int
    :param platform_fault_domain: Specifies the fault domain of the virtual machine.
    :type platform_fault_domain: int
    :param computer_name: The computer name assigned to the virtual machine.
    :type computer_name: str
    :param os_name: The Operating System running on the virtual machine.
    :type os_name: str
    :param os_version: The version of Operating System running on the virtual machine.
    :type os_version: str
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineAgentInstanceView
    :param maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :type maintenance_redeploy_status:
     ~azure.mgmt.compute.v2018_04_01.models.MaintenanceRedeployStatus
    :param disks: The virtual machine disk information.
    :type disks: list[~azure.mgmt.compute.v2018_04_01.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineExtensionInstanceView]
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2018_04_01.models.BootDiagnosticsInstanceView
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'computer_name': {'key': 'computerName', 'type': 'str'},
        'os_name': {'key': 'osName', 'type': 'str'},
        'os_version': {'key': 'osVersion', 'type': 'str'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'maintenance_redeploy_status': {'key': 'maintenanceRedeployStatus', 'type': 'MaintenanceRedeployStatus'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        computer_name: Optional[str] = None,
        os_name: Optional[str] = None,
        os_version: Optional[str] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["MaintenanceRedeployStatus"] = None,
        disks: Optional[List["DiskInstanceView"]] = None,
        extensions: Optional[List["VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.computer_name = computer_name
        self.os_name = os_name
        self.os_version = os_version
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses


class VirtualMachineListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machines.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachine]
    :param next_link: The URI to fetch the next page of VMs. Call ListNext() with this URI to fetch
     the next page of Virtual Machines.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachine]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachine"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSet(Resource):
    """Describes a Virtual Machine Scale Set.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The virtual machine scale set sku.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.Sku
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2018_04_01.models.Plan
    :param identity: The identity of the virtual machine scale set, if configured.
    :type identity: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetIdentity
    :param zones: The virtual machine scale set zones. NOTE: Availability zones can only be set
     when you create the scale set.
    :type zones: list[str]
    :param upgrade_policy: The upgrade policy.
    :type upgrade_policy: ~azure.mgmt.compute.v2018_04_01.models.UpgradePolicy
    :param virtual_machine_profile: The virtual machine profile.
    :type virtual_machine_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetVMProfile
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param overprovision: Specifies whether the Virtual Machine Scale Set should be
     overprovisioned.
    :type overprovision: bool
    :ivar unique_id: Specifies the ID which uniquely identifies a Virtual Machine Scale Set.
    :vartype unique_id: str
    :param single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines.
    :type single_placement_group: bool
    :param zone_balance: Whether to force strictly even Virtual Machine distribution cross x-zones
     in case there is zone outage.
    :type zone_balance: bool
    :param platform_fault_domain_count: Fault Domain count for each placement group.
    :type platform_fault_domain_count: int
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-
     version: 2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'provisioning_state': {'readonly': True},
        'unique_id': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineScaleSetIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'UpgradePolicy'},
        'virtual_machine_profile': {'key': 'properties.virtualMachineProfile', 'type': 'VirtualMachineScaleSetVMProfile'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'overprovision': {'key': 'properties.overprovision', 'type': 'bool'},
        'unique_id': {'key': 'properties.uniqueId', 'type': 'str'},
        'single_placement_group': {'key': 'properties.singlePlacementGroup', 'type': 'bool'},
        'zone_balance': {'key': 'properties.zoneBalance', 'type': 'bool'},
        'platform_fault_domain_count': {'key': 'properties.platformFaultDomainCount', 'type': 'int'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineScaleSetIdentity"] = None,
        zones: Optional[List[str]] = None,
        upgrade_policy: Optional["UpgradePolicy"] = None,
        virtual_machine_profile: Optional["VirtualMachineScaleSetVMProfile"] = None,
        overprovision: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        zone_balance: Optional[bool] = None,
        platform_fault_domain_count: Optional[int] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSet, self).__init__(location=location, tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.upgrade_policy = upgrade_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.provisioning_state = None
        self.overprovision = overprovision
        self.unique_id = None
        self.single_placement_group = single_placement_group
        self.zone_balance = zone_balance
        self.platform_fault_domain_count = platform_fault_domain_count
        self.proximity_placement_group = proximity_placement_group


class VirtualMachineScaleSetDataDisk(msrest.serialization.Model):
    """Describes a virtual machine scale set data disk.

    All required parameters must be populated in order to send to Azure.

    :param name: The disk name.
    :type name: str
    :param lun: Required. Specifies the logical unit number of the data disk. This value is used to
     identify data disks within the VM and therefore must be unique for each data disk attached to a
     VM.
    :type lun: int
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2018_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. The create option. Possible values include: "FromImage",
     "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2018_04_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of an empty data disk in gigabytes. This element can be
     used to overwrite the size of the disk in a virtual machine image. :code:`<br>`:code:`<br>`
     This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        'lun': {'required': True},
        'create_option': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'lun': {'key': 'lun', 'type': 'int'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
    }

    def __init__(
        self,
        *,
        lun: int,
        create_option: Union[str, "DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        managed_disk: Optional["VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetDataDisk, self).__init__(**kwargs)
        self.name = name
        self.lun = lun
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.managed_disk = managed_disk


class VirtualMachineScaleSetExtension(SubResourceReadOnly):
    """Describes a Virtual Machine Scale Set Extension.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar id: Resource Id.
    :vartype id: str
    :param name: The name of the extension.
    :type name: str
    :param force_update_tag: If a value is provided and is different from the previous value, the
     extension handler will be forced to update even if the extension configuration has not changed.
    :type force_update_tag: str
    :param publisher: The name of the extension handler publisher.
    :type publisher: str
    :param type: Specifies the type of the extension; an example is "CustomScriptExtension".
    :type type: str
    :param type_handler_version: Specifies the version of the script handler.
    :type type_handler_version: str
    :param auto_upgrade_minor_version: Indicates whether the extension should use a newer minor
     version if one is available at deployment time. Once deployed, however, the extension will not
     upgrade minor versions unless redeployed, even with this property set to true.
    :type auto_upgrade_minor_version: bool
    :param settings: Json formatted public settings for the extension.
    :type settings: object
    :param protected_settings: The extension can contain either protectedSettings or
     protectedSettingsFromKeyVault or no protected settings at all.
    :type protected_settings: object
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    """

    _validation = {
        'id': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'force_update_tag': {'key': 'properties.forceUpdateTag', 'type': 'str'},
        'publisher': {'key': 'properties.publisher', 'type': 'str'},
        'type': {'key': 'properties.type', 'type': 'str'},
        'type_handler_version': {'key': 'properties.typeHandlerVersion', 'type': 'str'},
        'auto_upgrade_minor_version': {'key': 'properties.autoUpgradeMinorVersion', 'type': 'bool'},
        'settings': {'key': 'properties.settings', 'type': 'object'},
        'protected_settings': {'key': 'properties.protectedSettings', 'type': 'object'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        force_update_tag: Optional[str] = None,
        publisher: Optional[str] = None,
        type: Optional[str] = None,
        type_handler_version: Optional[str] = None,
        auto_upgrade_minor_version: Optional[bool] = None,
        settings: Optional[object] = None,
        protected_settings: Optional[object] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtension, self).__init__(**kwargs)
        self.name = name
        self.force_update_tag = force_update_tag
        self.publisher = publisher
        self.type = type
        self.type_handler_version = type_handler_version
        self.auto_upgrade_minor_version = auto_upgrade_minor_version
        self.settings = settings
        self.protected_settings = protected_settings
        self.provisioning_state = None


class VirtualMachineScaleSetExtensionListResult(msrest.serialization.Model):
    """The List VM scale set extension operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of VM scale set extensions.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetExtension]
    :param next_link: The uri to fetch the next page of VM scale set extensions. Call ListNext()
     with this to fetch the next page of VM scale set extensions.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetExtension]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSetExtension"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetExtensionProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set extension profile.

    :param extensions: The virtual machine scale set child extension resources.
    :type extensions: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetExtension]
    """

    _attribute_map = {
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetExtension]'},
    }

    def __init__(
        self,
        *,
        extensions: Optional[List["VirtualMachineScaleSetExtension"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetExtensionProfile, self).__init__(**kwargs)
        self.extensions = extensions


class VirtualMachineScaleSetIdentity(msrest.serialization.Model):
    """Identity for the virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar principal_id: The principal id of virtual machine scale set identity. This property will
     only be provided for a system assigned identity.
    :vartype principal_id: str
    :ivar tenant_id: The tenant id associated with the virtual machine scale set. This property
     will only be provided for a system assigned identity.
    :vartype tenant_id: str
    :param type: The type of identity used for the virtual machine scale set. The type
     'SystemAssigned, UserAssigned' includes both an implicitly created identity and a set of user
     assigned identities. The type 'None' will remove any identities from the virtual machine scale
     set. Possible values include: "SystemAssigned", "UserAssigned", "SystemAssigned, UserAssigned",
     "None".
    :type type: str or ~azure.mgmt.compute.v2018_04_01.models.ResourceIdentityType
    :param identity_ids: The list of user identities associated with the virtual machine scale set.
     The user identity references will be ARM resource ids in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.ManagedIdentity/identities/{identityName}'.
    :type identity_ids: list[str]
    """

    _validation = {
        'principal_id': {'readonly': True},
        'tenant_id': {'readonly': True},
    }

    _attribute_map = {
        'principal_id': {'key': 'principalId', 'type': 'str'},
        'tenant_id': {'key': 'tenantId', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'identity_ids': {'key': 'identityIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        type: Optional[Union[str, "ResourceIdentityType"]] = None,
        identity_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetIdentity, self).__init__(**kwargs)
        self.principal_id = None
        self.tenant_id = None
        self.type = type
        self.identity_ids = identity_ids


class VirtualMachineScaleSetInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar virtual_machine: The instance view status summary for the virtual machine scale set.
    :vartype virtual_machine:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetInstanceViewStatusesSummary
    :ivar extensions: The extensions information.
    :vartype extensions:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetVMExtensionsSummary]
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    """

    _validation = {
        'virtual_machine': {'readonly': True},
        'extensions': {'readonly': True},
    }

    _attribute_map = {
        'virtual_machine': {'key': 'virtualMachine', 'type': 'VirtualMachineScaleSetInstanceViewStatusesSummary'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineScaleSetVMExtensionsSummary]'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
    }

    def __init__(
        self,
        *,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetInstanceView, self).__init__(**kwargs)
        self.virtual_machine = None
        self.extensions = None
        self.statuses = statuses


class VirtualMachineScaleSetInstanceViewStatusesSummary(msrest.serialization.Model):
    """Instance view statuses summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetInstanceViewStatusesSummary, self).__init__(**kwargs)
        self.statuses_summary = None


class VirtualMachineScaleSetIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The IP configuration name.
    :type name: str
    :param subnet: Specifies the identifier of the subnet.
    :type subnet: ~azure.mgmt.compute.v2018_04_01.models.ApiEntityReference
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param public_ip_address_configuration: The publicIPAddressConfiguration.
    :type public_ip_address_configuration:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetPublicIPAddressConfiguration
    :param private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.compute.v2018_04_01.models.IPVersion
    :param application_gateway_backend_address_pools: Specifies an array of references to backend
     address pools of application gateways. A scale set can reference backend address pools of
     multiple application gateways. Multiple scale sets cannot use the same application gateway.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :param load_balancer_backend_address_pools: Specifies an array of references to backend address
     pools of load balancers. A scale set can reference backend address pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same load balancer.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :param load_balancer_inbound_nat_pools: Specifies an array of references to inbound Nat pools
     of the load balancers. A scale set can reference inbound nat pools of one public and one
     internal load balancer. Multiple scale sets cannot use the same load balancer.
    :type load_balancer_inbound_nat_pools: list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address_configuration': {'key': 'properties.publicIPAddressConfiguration', 'type': 'VirtualMachineScaleSetPublicIPAddressConfiguration'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,
        subnet: Optional["ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["VirtualMachineScaleSetPublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetIpTag(msrest.serialization.Model):
    """Contains the IP tag associated with the public IP address.

    :param ip_tag_type: IP tag type. Example: FirstPartyUsage.
    :type ip_tag_type: str
    :param tag: IP tag associated with the public IP. Example: SQL, Storage etc.
    :type tag: str
    """

    _attribute_map = {
        'ip_tag_type': {'key': 'ipTagType', 'type': 'str'},
        'tag': {'key': 'tag', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        ip_tag_type: Optional[str] = None,
        tag: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetIpTag, self).__init__(**kwargs)
        self.ip_tag_type = ip_tag_type
        self.tag = tag


class VirtualMachineScaleSetListOSUpgradeHistory(msrest.serialization.Model):
    """List of Virtual Machine Scale Set OS Upgrade History operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of OS upgrades performed on the virtual machine scale set.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.UpgradeOperationHistoricalStatusInfo]
    :param next_link: The uri to fetch the next page of OS Upgrade History. Call ListNext() with
     this to fetch the next page of history of upgrades.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[UpgradeOperationHistoricalStatusInfo]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["UpgradeOperationHistoricalStatusInfo"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListOSUpgradeHistory, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSet]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of VMSS.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListSkusResult(msrest.serialization.Model):
    """The Virtual Machine Scale Set List Skus operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of skus available for the virtual machine scale set.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetSku]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Set Skus. Call
     ListNext() with this to fetch the next page of VMSS Skus.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetSku]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSetSku"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListSkusResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetListWithLinkResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSet]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Sets. Call ListNext()
     with this to fetch the next page of Virtual Machine Scale Sets.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSet]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSet"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetListWithLinkResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetManagedDiskParameters(msrest.serialization.Model):
    """Describes the parameters of a ScaleSet managed disk.

    :param storage_account_type: Specifies the storage account type for the managed disk. Managed
     OS disk storage account type can only be set when you create the scale set. Possible values
     are: Standard_LRS, Premium_LRS, and StandardSSD_LRS. Possible values include: "Standard_LRS",
     "Premium_LRS", "StandardSSD_LRS".
    :type storage_account_type: str or ~azure.mgmt.compute.v2018_04_01.models.StorageAccountTypes
    """

    _attribute_map = {
        'storage_account_type': {'key': 'storageAccountType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        storage_account_type: Optional[Union[str, "StorageAccountTypes"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetManagedDiskParameters, self).__init__(**kwargs)
        self.storage_account_type = storage_account_type


class VirtualMachineScaleSetNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    All required parameters must be populated in order to send to Azure.

    :param id: Resource Id.
    :type id: str
    :param name: Required. The network configuration name.
    :type name: str
    :param primary: Specifies the primary network interface in case the virtual machine has more
     than 1 network interface.
    :type primary: bool
    :param enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :type enable_accelerated_networking: bool
    :param network_security_group: The network security group.
    :type network_security_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param dns_settings: The dns settings to be applied on the network interfaces.
    :type dns_settings:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :param ip_configurations: Specifies the IP configurations of the network interface.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetIPConfiguration]
    :param enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :type enable_ip_forwarding: bool
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'SubResource'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetNetworkConfigurationDnsSettings'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineScaleSetIPConfiguration]'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        name: str,
        id: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        network_security_group: Optional["SubResource"] = None,
        dns_settings: Optional["VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["VirtualMachineScaleSetIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding


class VirtualMachineScaleSetNetworkConfigurationDnsSettings(msrest.serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    :param dns_servers: List of DNS servers IP addresses.
    :type dns_servers: list[str]
    """

    _attribute_map = {
        'dns_servers': {'key': 'dnsServers', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        dns_servers: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkConfigurationDnsSettings, self).__init__(**kwargs)
        self.dns_servers = dns_servers


class VirtualMachineScaleSetNetworkProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set network profile.

    :param health_probe: A reference to a load balancer probe used to determine the health of an
     instance in the virtual machine scale set. The reference will be in the form:
     '/subscriptions/{subscriptionId}/resourceGroups/{resourceGroupName}/providers/Microsoft.Network/loadBalancers/{loadBalancerName}/probes/{probeName}'.
    :type health_probe: ~azure.mgmt.compute.v2018_04_01.models.ApiEntityReference
    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetNetworkConfiguration]
    """

    _attribute_map = {
        'health_probe': {'key': 'healthProbe', 'type': 'ApiEntityReference'},
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetNetworkConfiguration]'},
    }

    def __init__(
        self,
        *,
        health_probe: Optional["ApiEntityReference"] = None,
        network_interface_configurations: Optional[List["VirtualMachineScaleSetNetworkConfiguration"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetNetworkProfile, self).__init__(**kwargs)
        self.health_probe = health_probe
        self.network_interface_configurations = network_interface_configurations


class VirtualMachineScaleSetOSDisk(msrest.serialization.Model):
    """Describes a virtual machine scale set operating system disk.

    All required parameters must be populated in order to send to Azure.

    :param name: The disk name.
    :type name: str
    :param caching: Specifies the caching requirements. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`:code:`<br>` **None** :code:`<br>`:code:`<br>` **ReadOnly**
     :code:`<br>`:code:`<br>` **ReadWrite** :code:`<br>`:code:`<br>` Default: **None for Standard
     storage. ReadOnly for Premium storage**. Possible values include: "None", "ReadOnly",
     "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2018_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param create_option: Required. Specifies how the virtual machines in the scale set should be
     created.:code:`<br>`:code:`<br>` The only allowed value is: **FromImage** \u2013 This value is
     used when you are using an image to create the virtual machine. If you are using a platform
     image, you also use the imageReference element described above. If you are using a marketplace
     image, you  also use the plan element previously described. Possible values include:
     "FromImage", "Empty", "Attach".
    :type create_option: str or ~azure.mgmt.compute.v2018_04_01.models.DiskCreateOptionTypes
    :param disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param os_type: This property allows you to specify the type of the OS that is included in the
     disk if creating a VM from user-image or a specialized VHD. :code:`<br>`:code:`<br>` Possible
     values are: :code:`<br>`:code:`<br>` **Windows** :code:`<br>`:code:`<br>` **Linux**. Possible
     values include: "Windows", "Linux".
    :type os_type: str or ~azure.mgmt.compute.v2018_04_01.models.OperatingSystemTypes
    :param image: Specifies information about the unmanaged user image to base the scale set on.
    :type image: ~azure.mgmt.compute.v2018_04_01.models.VirtualHardDisk
    :param vhd_containers: Specifies the container urls that are used to store operating system
     disks for the scale set.
    :type vhd_containers: list[str]
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _validation = {
        'create_option': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'create_option': {'key': 'createOption', 'type': 'str'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'os_type': {'key': 'osType', 'type': 'str'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'vhd_containers': {'key': 'vhdContainers', 'type': '[str]'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
    }

    def __init__(
        self,
        *,
        create_option: Union[str, "DiskCreateOptionTypes"],
        name: Optional[str] = None,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        os_type: Optional[Union[str, "OperatingSystemTypes"]] = None,
        image: Optional["VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetOSDisk, self).__init__(**kwargs)
        self.name = name
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.create_option = create_option
        self.disk_size_gb = disk_size_gb
        self.os_type = os_type
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetOSProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :param computer_name_prefix: Specifies the computer name prefix for all of the virtual machines
     in the scale set. Computer name prefixes must be 1 to 15 characters long.
    :type computer_name_prefix: str
    :param admin_username: Specifies the name of the administrator account.
     :code:`<br>`:code:`<br>` **Windows-only restriction:** Cannot end in "."
     :code:`<br>`:code:`<br>` **Disallowed values:** "administrator", "admin", "user", "user1",
     "test", "user2", "test1", "user3", "admin1", "1", "123", "a", "actuser", "adm", "admin2",
     "aspnet", "backup", "console", "david", "guest", "john", "owner", "root", "server", "sql",
     "support", "support_388945a0", "sys", "test2", "test3", "user4", "user5".
     :code:`<br>`:code:`<br>` **Minimum-length (Linux):** 1  character :code:`<br>`:code:`<br>`
     **Max-length (Linux):** 64 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 20
     characters  :code:`<br>`:code:`<br>`:code:`<li>` For root access to the Linux VM, see `Using
     root privileges on Linux virtual machines in Azure <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-linux-use-root-privileges?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json>`_\ :code:`<br>`:code:`<li>` For a list of built-in system users on
     Linux that should not be used in this field, see `Selecting User Names for Linux on Azure
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-
     usernames?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type admin_username: str
    :param admin_password: Specifies the password of the administrator account.
     :code:`<br>`:code:`<br>` **Minimum-length (Windows):** 8 characters :code:`<br>`:code:`<br>`
     **Minimum-length (Linux):** 6 characters :code:`<br>`:code:`<br>` **Max-length (Windows):** 123
     characters :code:`<br>`:code:`<br>` **Max-length (Linux):** 72 characters
     :code:`<br>`:code:`<br>` **Complexity requirements:** 3 out of 4 conditions below need to be
     fulfilled :code:`<br>` Has lower characters :code:`<br>`Has upper characters :code:`<br>` Has a
     digit :code:`<br>` Has a special character (Regex match [\W_]) :code:`<br>`:code:`<br>`
     **Disallowed values:** "abc@123", "P@$$w0rd", "P@ssw0rd", "P@ssword123", "Pa$$word",
     "pass@word1", "Password!", "Password1", "Password22", "iloveyou!" :code:`<br>`:code:`<br>` For
     resetting the password, see `How to reset the Remote Desktop service or its login password in a
     Windows VM <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-reset-
     rdp?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>` For
     resetting root password, see `Manage users, SSH, and check or repair disks on Azure Linux VMs
     using the VMAccess Extension <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-using-vmaccess-extension?toc=%2fazure%2fvirtual-
     machines%2flinux%2ftoc.json#reset-root-password>`_.
    :type admin_password: str
    :param custom_data: Specifies a base-64 encoded string of custom data. The base-64 encoded
     string is decoded to a binary array that is saved as a file on the Virtual Machine. The maximum
     length of the binary array is 65535 bytes. :code:`<br>`:code:`<br>` For using cloud-init for
     your VM, see `Using cloud-init to customize a Linux VM during creation
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-linux-using-cloud-
     init?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type custom_data: str
    :param windows_configuration: Specifies Windows operating system settings on the virtual
     machine.
    :type windows_configuration: ~azure.mgmt.compute.v2018_04_01.models.WindowsConfiguration
    :param linux_configuration: Specifies the Linux operating system settings on the virtual
     machine. :code:`<br>`:code:`<br>`For a list of supported Linux distributions, see `Linux on
     Azure-Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-
     machines-linux-endorsed-distros?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_
     :code:`<br>`:code:`<br>` For running non-endorsed distributions, see `Information for Non-
     Endorsed Distributions <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-
     linux-create-upload-generic?toc=%2fazure%2fvirtual-machines%2flinux%2ftoc.json>`_.
    :type linux_configuration: ~azure.mgmt.compute.v2018_04_01.models.LinuxConfiguration
    :param secrets: Specifies set of certificates that should be installed onto the virtual
     machines in the scale set.
    :type secrets: list[~azure.mgmt.compute.v2018_04_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        'computer_name_prefix': {'key': 'computerNamePrefix', 'type': 'str'},
        'admin_username': {'key': 'adminUsername', 'type': 'str'},
        'admin_password': {'key': 'adminPassword', 'type': 'str'},
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(
        self,
        *,
        computer_name_prefix: Optional[str] = None,
        admin_username: Optional[str] = None,
        admin_password: Optional[str] = None,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        linux_configuration: Optional["LinuxConfiguration"] = None,
        secrets: Optional[List["VaultSecretGroup"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetOSProfile, self).__init__(**kwargs)
        self.computer_name_prefix = computer_name_prefix
        self.admin_username = admin_username
        self.admin_password = admin_password
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetPublicIPAddressConfiguration(msrest.serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    All required parameters must be populated in order to send to Azure.

    :param name: Required. The publicIP address configuration name.
    :type name: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param dns_settings: The dns settings to be applied on the publicIP addresses .
    :type dns_settings:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    :param ip_tags: The list of IP tags associated with the public IP address.
    :type ip_tags: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetIpTag]
    """

    _validation = {
        'name': {'required': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings'},
        'ip_tags': {'key': 'properties.ipTags', 'type': '[VirtualMachineScaleSetIpTag]'},
    }

    def __init__(
        self,
        *,
        name: str,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        ip_tags: Optional[List["VirtualMachineScaleSetIpTag"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetPublicIPAddressConfiguration, self).__init__(**kwargs)
        self.name = name
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings
        self.ip_tags = ip_tags


class VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings(msrest.serialization.Model):
    """Describes a virtual machines scale sets network configuration's DNS settings.

    All required parameters must be populated in order to send to Azure.

    :param domain_name_label: Required. The Domain name label.The concatenation of the domain name
     label and vm index will be the domain name labels of the PublicIPAddress resources that will be
     created.
    :type domain_name_label: str
    """

    _validation = {
        'domain_name_label': {'required': True},
    }

    _attribute_map = {
        'domain_name_label': {'key': 'domainNameLabel', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        domain_name_label: str,
        **kwargs
    ):
        super(VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings, self).__init__(**kwargs)
        self.domain_name_label = domain_name_label


class VirtualMachineScaleSetSku(msrest.serialization.Model):
    """Describes an available virtual machine scale set sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar resource_type: The type of resource the sku applies to.
    :vartype resource_type: str
    :ivar sku: The Sku.
    :vartype sku: ~azure.mgmt.compute.v2018_04_01.models.Sku
    :ivar capacity: Specifies the number of virtual machines in the scale set.
    :vartype capacity: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetSkuCapacity
    """

    _validation = {
        'resource_type': {'readonly': True},
        'sku': {'readonly': True},
        'capacity': {'readonly': True},
    }

    _attribute_map = {
        'resource_type': {'key': 'resourceType', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'capacity': {'key': 'capacity', 'type': 'VirtualMachineScaleSetSkuCapacity'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetSku, self).__init__(**kwargs)
        self.resource_type = None
        self.sku = None
        self.capacity = None


class VirtualMachineScaleSetSkuCapacity(msrest.serialization.Model):
    """Describes scaling information of a sku.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar minimum: The minimum capacity.
    :vartype minimum: long
    :ivar maximum: The maximum capacity that can be set.
    :vartype maximum: long
    :ivar default_capacity: The default capacity.
    :vartype default_capacity: long
    :ivar scale_type: The scale type applicable to the sku. Possible values include: "Automatic",
     "None".
    :vartype scale_type: str or
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetSkuScaleType
    """

    _validation = {
        'minimum': {'readonly': True},
        'maximum': {'readonly': True},
        'default_capacity': {'readonly': True},
        'scale_type': {'readonly': True},
    }

    _attribute_map = {
        'minimum': {'key': 'minimum', 'type': 'long'},
        'maximum': {'key': 'maximum', 'type': 'long'},
        'default_capacity': {'key': 'defaultCapacity', 'type': 'long'},
        'scale_type': {'key': 'scaleType', 'type': 'str'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetSkuCapacity, self).__init__(**kwargs)
        self.minimum = None
        self.maximum = None
        self.default_capacity = None
        self.scale_type = None


class VirtualMachineScaleSetStorageProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :param image_reference: Specifies information about the image to use. You can specify
     information about platform images, marketplace images, or virtual machine images. This element
     is required when you want to use a platform image, marketplace image, or virtual machine image,
     but is not used in other creation operations.
    :type image_reference: ~azure.mgmt.compute.v2018_04_01.models.ImageReference
    :param os_disk: Specifies information about the operating system disk used by the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-
     machines%2fwindows%2ftoc.json>`_.
    :type os_disk: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetOSDisk
    :param data_disks: Specifies the parameters that are used to add data disks to the virtual
     machines in the scale set. :code:`<br>`:code:`<br>` For more information about disks, see
     `About disks and VHDs for Azure virtual machines <https://docs.microsoft.com/azure/virtual-
     machines/virtual-machines-windows-about-disks-vhds?toc=%2fazure%2fvirtual-
     machines%2fwindows%2ftoc.json>`_.
    :type data_disks: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'VirtualMachineScaleSetOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[VirtualMachineScaleSetDataDisk]'},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["ImageReference"] = None,
        os_disk: Optional["VirtualMachineScaleSetOSDisk"] = None,
        data_disks: Optional[List["VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetStorageProfile, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdate(UpdateResource):
    """Describes a Virtual Machine Scale Set.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param sku: The virtual machine scale set sku.
    :type sku: ~azure.mgmt.compute.v2018_04_01.models.Sku
    :param plan: The purchase plan when deploying a virtual machine scale set from VM Marketplace
     images.
    :type plan: ~azure.mgmt.compute.v2018_04_01.models.Plan
    :param identity: The identity of the virtual machine scale set, if configured.
    :type identity: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetIdentity
    :param upgrade_policy: The upgrade policy.
    :type upgrade_policy: ~azure.mgmt.compute.v2018_04_01.models.UpgradePolicy
    :param virtual_machine_profile: The virtual machine profile.
    :type virtual_machine_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdateVMProfile
    :param overprovision: Specifies whether the Virtual Machine Scale Set should be
     overprovisioned.
    :type overprovision: bool
    :param single_placement_group: When true this limits the scale set to a single placement group,
     of max size 100 virtual machines. NOTE: If singlePlacementGroup is true, it may be modified to
     false. However, if singlePlacementGroup is false, it may not be modified to true.
    :type single_placement_group: bool
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine scale set should be assigned to. :code:`<br>`:code:`<br>`Minimum api-
     version: 2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    """

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineScaleSetIdentity'},
        'upgrade_policy': {'key': 'properties.upgradePolicy', 'type': 'UpgradePolicy'},
        'virtual_machine_profile': {'key': 'properties.virtualMachineProfile', 'type': 'VirtualMachineScaleSetUpdateVMProfile'},
        'overprovision': {'key': 'properties.overprovision', 'type': 'bool'},
        'single_placement_group': {'key': 'properties.singlePlacementGroup', 'type': 'bool'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        sku: Optional["Sku"] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineScaleSetIdentity"] = None,
        upgrade_policy: Optional["UpgradePolicy"] = None,
        virtual_machine_profile: Optional["VirtualMachineScaleSetUpdateVMProfile"] = None,
        overprovision: Optional[bool] = None,
        single_placement_group: Optional[bool] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdate, self).__init__(tags=tags, **kwargs)
        self.sku = sku
        self.plan = plan
        self.identity = identity
        self.upgrade_policy = upgrade_policy
        self.virtual_machine_profile = virtual_machine_profile
        self.overprovision = overprovision
        self.single_placement_group = single_placement_group
        self.proximity_placement_group = proximity_placement_group


class VirtualMachineScaleSetUpdateIPConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's IP configuration.

    :param id: Resource Id.
    :type id: str
    :param name: The IP configuration name.
    :type name: str
    :param subnet: The subnet.
    :type subnet: ~azure.mgmt.compute.v2018_04_01.models.ApiEntityReference
    :param primary: Specifies the primary IP Configuration in case the network interface has more
     than one IP Configuration.
    :type primary: bool
    :param public_ip_address_configuration: The publicIPAddressConfiguration.
    :type public_ip_address_configuration:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdatePublicIPAddressConfiguration
    :param private_ip_address_version: Available from Api-Version 2017-03-30 onwards, it represents
     whether the specific ipconfiguration is IPv4 or IPv6. Default is taken as IPv4.  Possible
     values are: 'IPv4' and 'IPv6'. Possible values include: "IPv4", "IPv6".
    :type private_ip_address_version: str or ~azure.mgmt.compute.v2018_04_01.models.IPVersion
    :param application_gateway_backend_address_pools: The application gateway backend address
     pools.
    :type application_gateway_backend_address_pools:
     list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :param load_balancer_backend_address_pools: The load balancer backend address pools.
    :type load_balancer_backend_address_pools:
     list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    :param load_balancer_inbound_nat_pools: The load balancer inbound nat pools.
    :type load_balancer_inbound_nat_pools: list[~azure.mgmt.compute.v2018_04_01.models.SubResource]
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'subnet': {'key': 'properties.subnet', 'type': 'ApiEntityReference'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'public_ip_address_configuration': {'key': 'properties.publicIPAddressConfiguration', 'type': 'VirtualMachineScaleSetUpdatePublicIPAddressConfiguration'},
        'private_ip_address_version': {'key': 'properties.privateIPAddressVersion', 'type': 'str'},
        'application_gateway_backend_address_pools': {'key': 'properties.applicationGatewayBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_backend_address_pools': {'key': 'properties.loadBalancerBackendAddressPools', 'type': '[SubResource]'},
        'load_balancer_inbound_nat_pools': {'key': 'properties.loadBalancerInboundNatPools', 'type': '[SubResource]'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        subnet: Optional["ApiEntityReference"] = None,
        primary: Optional[bool] = None,
        public_ip_address_configuration: Optional["VirtualMachineScaleSetUpdatePublicIPAddressConfiguration"] = None,
        private_ip_address_version: Optional[Union[str, "IPVersion"]] = None,
        application_gateway_backend_address_pools: Optional[List["SubResource"]] = None,
        load_balancer_backend_address_pools: Optional[List["SubResource"]] = None,
        load_balancer_inbound_nat_pools: Optional[List["SubResource"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateIPConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.subnet = subnet
        self.primary = primary
        self.public_ip_address_configuration = public_ip_address_configuration
        self.private_ip_address_version = private_ip_address_version
        self.application_gateway_backend_address_pools = application_gateway_backend_address_pools
        self.load_balancer_backend_address_pools = load_balancer_backend_address_pools
        self.load_balancer_inbound_nat_pools = load_balancer_inbound_nat_pools


class VirtualMachineScaleSetUpdateNetworkConfiguration(SubResource):
    """Describes a virtual machine scale set network profile's network configurations.

    :param id: Resource Id.
    :type id: str
    :param name: The network configuration name.
    :type name: str
    :param primary: Whether this is a primary NIC on a virtual machine.
    :type primary: bool
    :param enable_accelerated_networking: Specifies whether the network interface is accelerated
     networking-enabled.
    :type enable_accelerated_networking: bool
    :param network_security_group: The network security group.
    :type network_security_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param dns_settings: The dns settings to be applied on the network interfaces.
    :type dns_settings:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetNetworkConfigurationDnsSettings
    :param ip_configurations: The virtual machine scale set IP Configuration.
    :type ip_configurations:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdateIPConfiguration]
    :param enable_ip_forwarding: Whether IP forwarding enabled on this NIC.
    :type enable_ip_forwarding: bool
    """

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'primary': {'key': 'properties.primary', 'type': 'bool'},
        'enable_accelerated_networking': {'key': 'properties.enableAcceleratedNetworking', 'type': 'bool'},
        'network_security_group': {'key': 'properties.networkSecurityGroup', 'type': 'SubResource'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetNetworkConfigurationDnsSettings'},
        'ip_configurations': {'key': 'properties.ipConfigurations', 'type': '[VirtualMachineScaleSetUpdateIPConfiguration]'},
        'enable_ip_forwarding': {'key': 'properties.enableIPForwarding', 'type': 'bool'},
    }

    def __init__(
        self,
        *,
        id: Optional[str] = None,
        name: Optional[str] = None,
        primary: Optional[bool] = None,
        enable_accelerated_networking: Optional[bool] = None,
        network_security_group: Optional["SubResource"] = None,
        dns_settings: Optional["VirtualMachineScaleSetNetworkConfigurationDnsSettings"] = None,
        ip_configurations: Optional[List["VirtualMachineScaleSetUpdateIPConfiguration"]] = None,
        enable_ip_forwarding: Optional[bool] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateNetworkConfiguration, self).__init__(id=id, **kwargs)
        self.name = name
        self.primary = primary
        self.enable_accelerated_networking = enable_accelerated_networking
        self.network_security_group = network_security_group
        self.dns_settings = dns_settings
        self.ip_configurations = ip_configurations
        self.enable_ip_forwarding = enable_ip_forwarding


class VirtualMachineScaleSetUpdateNetworkProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set network profile.

    :param network_interface_configurations: The list of network configurations.
    :type network_interface_configurations:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdateNetworkConfiguration]
    """

    _attribute_map = {
        'network_interface_configurations': {'key': 'networkInterfaceConfigurations', 'type': '[VirtualMachineScaleSetUpdateNetworkConfiguration]'},
    }

    def __init__(
        self,
        *,
        network_interface_configurations: Optional[List["VirtualMachineScaleSetUpdateNetworkConfiguration"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateNetworkProfile, self).__init__(**kwargs)
        self.network_interface_configurations = network_interface_configurations


class VirtualMachineScaleSetUpdateOSDisk(msrest.serialization.Model):
    """Describes virtual machine scale set operating system disk Update Object. This should be used for Updating VMSS OS Disk.

    :param caching: The caching type. Possible values include: "None", "ReadOnly", "ReadWrite".
    :type caching: str or ~azure.mgmt.compute.v2018_04_01.models.CachingTypes
    :param write_accelerator_enabled: Specifies whether writeAccelerator should be enabled or
     disabled on the disk.
    :type write_accelerator_enabled: bool
    :param disk_size_gb: Specifies the size of the operating system disk in gigabytes. This element
     can be used to overwrite the size of the disk in a virtual machine image.
     :code:`<br>`:code:`<br>` This value cannot be larger than 1023 GB.
    :type disk_size_gb: int
    :param image: The Source User Image VirtualHardDisk. This VirtualHardDisk will be copied before
     using it to attach to the Virtual Machine. If SourceImage is provided, the destination
     VirtualHardDisk should not exist.
    :type image: ~azure.mgmt.compute.v2018_04_01.models.VirtualHardDisk
    :param vhd_containers: The list of virtual hard disk container uris.
    :type vhd_containers: list[str]
    :param managed_disk: The managed disk parameters.
    :type managed_disk:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetManagedDiskParameters
    """

    _attribute_map = {
        'caching': {'key': 'caching', 'type': 'str'},
        'write_accelerator_enabled': {'key': 'writeAcceleratorEnabled', 'type': 'bool'},
        'disk_size_gb': {'key': 'diskSizeGB', 'type': 'int'},
        'image': {'key': 'image', 'type': 'VirtualHardDisk'},
        'vhd_containers': {'key': 'vhdContainers', 'type': '[str]'},
        'managed_disk': {'key': 'managedDisk', 'type': 'VirtualMachineScaleSetManagedDiskParameters'},
    }

    def __init__(
        self,
        *,
        caching: Optional[Union[str, "CachingTypes"]] = None,
        write_accelerator_enabled: Optional[bool] = None,
        disk_size_gb: Optional[int] = None,
        image: Optional["VirtualHardDisk"] = None,
        vhd_containers: Optional[List[str]] = None,
        managed_disk: Optional["VirtualMachineScaleSetManagedDiskParameters"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateOSDisk, self).__init__(**kwargs)
        self.caching = caching
        self.write_accelerator_enabled = write_accelerator_enabled
        self.disk_size_gb = disk_size_gb
        self.image = image
        self.vhd_containers = vhd_containers
        self.managed_disk = managed_disk


class VirtualMachineScaleSetUpdateOSProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set OS profile.

    :param custom_data: A base-64 encoded string of custom data.
    :type custom_data: str
    :param windows_configuration: The Windows Configuration of the OS profile.
    :type windows_configuration: ~azure.mgmt.compute.v2018_04_01.models.WindowsConfiguration
    :param linux_configuration: The Linux Configuration of the OS profile.
    :type linux_configuration: ~azure.mgmt.compute.v2018_04_01.models.LinuxConfiguration
    :param secrets: The List of certificates for addition to the VM.
    :type secrets: list[~azure.mgmt.compute.v2018_04_01.models.VaultSecretGroup]
    """

    _attribute_map = {
        'custom_data': {'key': 'customData', 'type': 'str'},
        'windows_configuration': {'key': 'windowsConfiguration', 'type': 'WindowsConfiguration'},
        'linux_configuration': {'key': 'linuxConfiguration', 'type': 'LinuxConfiguration'},
        'secrets': {'key': 'secrets', 'type': '[VaultSecretGroup]'},
    }

    def __init__(
        self,
        *,
        custom_data: Optional[str] = None,
        windows_configuration: Optional["WindowsConfiguration"] = None,
        linux_configuration: Optional["LinuxConfiguration"] = None,
        secrets: Optional[List["VaultSecretGroup"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateOSProfile, self).__init__(**kwargs)
        self.custom_data = custom_data
        self.windows_configuration = windows_configuration
        self.linux_configuration = linux_configuration
        self.secrets = secrets


class VirtualMachineScaleSetUpdatePublicIPAddressConfiguration(msrest.serialization.Model):
    """Describes a virtual machines scale set IP Configuration's PublicIPAddress configuration.

    :param name: The publicIP address configuration name.
    :type name: str
    :param idle_timeout_in_minutes: The idle timeout of the public IP address.
    :type idle_timeout_in_minutes: int
    :param dns_settings: The dns settings to be applied on the publicIP addresses .
    :type dns_settings:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'idle_timeout_in_minutes': {'key': 'properties.idleTimeoutInMinutes', 'type': 'int'},
        'dns_settings': {'key': 'properties.dnsSettings', 'type': 'VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        idle_timeout_in_minutes: Optional[int] = None,
        dns_settings: Optional["VirtualMachineScaleSetPublicIPAddressConfigurationDnsSettings"] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdatePublicIPAddressConfiguration, self).__init__(**kwargs)
        self.name = name
        self.idle_timeout_in_minutes = idle_timeout_in_minutes
        self.dns_settings = dns_settings


class VirtualMachineScaleSetUpdateStorageProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set storage profile.

    :param image_reference: The image reference.
    :type image_reference: ~azure.mgmt.compute.v2018_04_01.models.ImageReference
    :param os_disk: The OS disk.
    :type os_disk: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdateOSDisk
    :param data_disks: The data disks.
    :type data_disks: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetDataDisk]
    """

    _attribute_map = {
        'image_reference': {'key': 'imageReference', 'type': 'ImageReference'},
        'os_disk': {'key': 'osDisk', 'type': 'VirtualMachineScaleSetUpdateOSDisk'},
        'data_disks': {'key': 'dataDisks', 'type': '[VirtualMachineScaleSetDataDisk]'},
    }

    def __init__(
        self,
        *,
        image_reference: Optional["ImageReference"] = None,
        os_disk: Optional["VirtualMachineScaleSetUpdateOSDisk"] = None,
        data_disks: Optional[List["VirtualMachineScaleSetDataDisk"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateStorageProfile, self).__init__(**kwargs)
        self.image_reference = image_reference
        self.os_disk = os_disk
        self.data_disks = data_disks


class VirtualMachineScaleSetUpdateVMProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :param os_profile: The virtual machine scale set OS profile.
    :type os_profile: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdateOSProfile
    :param storage_profile: The virtual machine scale set storage profile.
    :type storage_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdateStorageProfile
    :param network_profile: The virtual machine scale set network profile.
    :type network_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetUpdateNetworkProfile
    :param diagnostics_profile: The virtual machine scale set diagnostics profile.
    :type diagnostics_profile: ~azure.mgmt.compute.v2018_04_01.models.DiagnosticsProfile
    :param extension_profile: The virtual machine scale set extension profile.
    :type extension_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetExtensionProfile
    :param license_type: The license type, which is for bring your own license scenario.
    :type license_type: str
    """

    _attribute_map = {
        'os_profile': {'key': 'osProfile', 'type': 'VirtualMachineScaleSetUpdateOSProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'VirtualMachineScaleSetUpdateStorageProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'VirtualMachineScaleSetUpdateNetworkProfile'},
        'diagnostics_profile': {'key': 'diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'VirtualMachineScaleSetExtensionProfile'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["VirtualMachineScaleSetUpdateOSProfile"] = None,
        storage_profile: Optional["VirtualMachineScaleSetUpdateStorageProfile"] = None,
        network_profile: Optional["VirtualMachineScaleSetUpdateNetworkProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        extension_profile: Optional["VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetUpdateVMProfile, self).__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type


class VirtualMachineScaleSetVM(Resource):
    """Describes a virtual machine scale set virtual machine.

    Variables are only populated by the server, and will be ignored when sending a request.

    All required parameters must be populated in order to send to Azure.

    :ivar id: Resource Id.
    :vartype id: str
    :ivar name: Resource name.
    :vartype name: str
    :ivar type: Resource type.
    :vartype type: str
    :param location: Required. Resource location.
    :type location: str
    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :ivar instance_id: The virtual machine instance ID.
    :vartype instance_id: str
    :ivar sku: The virtual machine SKU.
    :vartype sku: ~azure.mgmt.compute.v2018_04_01.models.Sku
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2018_04_01.models.Plan
    :ivar resources: The virtual machine child extension resources.
    :vartype resources: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineExtension]
    :ivar zones: The virtual machine zones.
    :vartype zones: list[str]
    :ivar latest_model_applied: Specifies whether the latest model has been applied to the virtual
     machine.
    :vartype latest_model_applied: bool
    :ivar vm_id: Azure VM unique ID.
    :vartype vm_id: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetVMInstanceView
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2018_04_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2018_04_01.models.StorageProfile
    :param os_profile: Specifies the operating system settings for the virtual machine.
    :type os_profile: ~azure.mgmt.compute.v2018_04_01.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2018_04_01.models.NetworkProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2018_04_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-
     availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>`
     For more information on Azure planned maintenance, see `Planned maintenance for virtual
     machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-
     planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :type availability_set: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-
     licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>`
     Minimum api-version: 2015-06-15.
    :type license_type: str
    """

    _validation = {
        'id': {'readonly': True},
        'name': {'readonly': True},
        'type': {'readonly': True},
        'location': {'required': True},
        'instance_id': {'readonly': True},
        'sku': {'readonly': True},
        'resources': {'readonly': True},
        'zones': {'readonly': True},
        'latest_model_applied': {'readonly': True},
        'vm_id': {'readonly': True},
        'instance_view': {'readonly': True},
        'provisioning_state': {'readonly': True},
    }

    _attribute_map = {
        'id': {'key': 'id', 'type': 'str'},
        'name': {'key': 'name', 'type': 'str'},
        'type': {'key': 'type', 'type': 'str'},
        'location': {'key': 'location', 'type': 'str'},
        'tags': {'key': 'tags', 'type': '{str}'},
        'instance_id': {'key': 'instanceId', 'type': 'str'},
        'sku': {'key': 'sku', 'type': 'Sku'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'resources': {'key': 'resources', 'type': '[VirtualMachineExtension]'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'latest_model_applied': {'key': 'properties.latestModelApplied', 'type': 'bool'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineScaleSetVMInstanceView'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        location: str,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        hardware_profile: Optional["HardwareProfile"] = None,
        storage_profile: Optional["StorageProfile"] = None,
        os_profile: Optional["OSProfile"] = None,
        network_profile: Optional["NetworkProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        availability_set: Optional["SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVM, self).__init__(location=location, tags=tags, **kwargs)
        self.instance_id = None
        self.sku = None
        self.plan = plan
        self.resources = None
        self.zones = None
        self.latest_model_applied = None
        self.vm_id = None
        self.instance_view = None
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.provisioning_state = None
        self.license_type = license_type


class VirtualMachineScaleSetVMExtensionsSummary(msrest.serialization.Model):
    """Extensions summary for virtual machines of a virtual machine scale set.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar name: The extension name.
    :vartype name: str
    :ivar statuses_summary: The extensions information.
    :vartype statuses_summary:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineStatusCodeCount]
    """

    _validation = {
        'name': {'readonly': True},
        'statuses_summary': {'readonly': True},
    }

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'statuses_summary': {'key': 'statusesSummary', 'type': '[VirtualMachineStatusCodeCount]'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMExtensionsSummary, self).__init__(**kwargs)
        self.name = None
        self.statuses_summary = None


class VirtualMachineScaleSetVMInstanceIDs(msrest.serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    :param instance_ids: The virtual machine scale set instance ids. Omitting the virtual machine
     scale set instance ids will result in the operation being performed on all virtual machines in
     the virtual machine scale set.
    :type instance_ids: list[str]
    """

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        instance_ids: Optional[List[str]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceIDs, self).__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceRequiredIDs(msrest.serialization.Model):
    """Specifies a list of virtual machine instance IDs from the VM scale set.

    All required parameters must be populated in order to send to Azure.

    :param instance_ids: Required. The virtual machine scale set instance ids.
    :type instance_ids: list[str]
    """

    _validation = {
        'instance_ids': {'required': True},
    }

    _attribute_map = {
        'instance_ids': {'key': 'instanceIds', 'type': '[str]'},
    }

    def __init__(
        self,
        *,
        instance_ids: List[str],
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceRequiredIDs, self).__init__(**kwargs)
        self.instance_ids = instance_ids


class VirtualMachineScaleSetVMInstanceView(msrest.serialization.Model):
    """The instance view of a virtual machine scale set VM.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param platform_update_domain: The Update Domain count.
    :type platform_update_domain: int
    :param platform_fault_domain: The Fault Domain count.
    :type platform_fault_domain: int
    :param rdp_thumb_print: The Remote desktop certificate thumbprint.
    :type rdp_thumb_print: str
    :param vm_agent: The VM Agent running on the virtual machine.
    :type vm_agent: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineAgentInstanceView
    :param maintenance_redeploy_status: The Maintenance Operation status on the virtual machine.
    :type maintenance_redeploy_status:
     ~azure.mgmt.compute.v2018_04_01.models.MaintenanceRedeployStatus
    :param disks: The disks information.
    :type disks: list[~azure.mgmt.compute.v2018_04_01.models.DiskInstanceView]
    :param extensions: The extensions information.
    :type extensions:
     list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineExtensionInstanceView]
    :ivar vm_health: The health status for the VM.
    :vartype vm_health: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineHealthStatus
    :param boot_diagnostics: Boot Diagnostics is a debugging feature which allows you to view
     Console Output and Screenshot to diagnose VM status. :code:`<br>`:code:`<br>` You can easily
     view the output of your console log. :code:`<br>`:code:`<br>` Azure also enables you to see a
     screenshot of the VM from the hypervisor.
    :type boot_diagnostics: ~azure.mgmt.compute.v2018_04_01.models.BootDiagnosticsInstanceView
    :param statuses: The resource status information.
    :type statuses: list[~azure.mgmt.compute.v2018_04_01.models.InstanceViewStatus]
    :param placement_group_id: The placement group in which the VM is running. If the VM is
     deallocated it will not have a placementGroupId.
    :type placement_group_id: str
    """

    _validation = {
        'vm_health': {'readonly': True},
    }

    _attribute_map = {
        'platform_update_domain': {'key': 'platformUpdateDomain', 'type': 'int'},
        'platform_fault_domain': {'key': 'platformFaultDomain', 'type': 'int'},
        'rdp_thumb_print': {'key': 'rdpThumbPrint', 'type': 'str'},
        'vm_agent': {'key': 'vmAgent', 'type': 'VirtualMachineAgentInstanceView'},
        'maintenance_redeploy_status': {'key': 'maintenanceRedeployStatus', 'type': 'MaintenanceRedeployStatus'},
        'disks': {'key': 'disks', 'type': '[DiskInstanceView]'},
        'extensions': {'key': 'extensions', 'type': '[VirtualMachineExtensionInstanceView]'},
        'vm_health': {'key': 'vmHealth', 'type': 'VirtualMachineHealthStatus'},
        'boot_diagnostics': {'key': 'bootDiagnostics', 'type': 'BootDiagnosticsInstanceView'},
        'statuses': {'key': 'statuses', 'type': '[InstanceViewStatus]'},
        'placement_group_id': {'key': 'placementGroupId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        platform_update_domain: Optional[int] = None,
        platform_fault_domain: Optional[int] = None,
        rdp_thumb_print: Optional[str] = None,
        vm_agent: Optional["VirtualMachineAgentInstanceView"] = None,
        maintenance_redeploy_status: Optional["MaintenanceRedeployStatus"] = None,
        disks: Optional[List["DiskInstanceView"]] = None,
        extensions: Optional[List["VirtualMachineExtensionInstanceView"]] = None,
        boot_diagnostics: Optional["BootDiagnosticsInstanceView"] = None,
        statuses: Optional[List["InstanceViewStatus"]] = None,
        placement_group_id: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMInstanceView, self).__init__(**kwargs)
        self.platform_update_domain = platform_update_domain
        self.platform_fault_domain = platform_fault_domain
        self.rdp_thumb_print = rdp_thumb_print
        self.vm_agent = vm_agent
        self.maintenance_redeploy_status = maintenance_redeploy_status
        self.disks = disks
        self.extensions = extensions
        self.vm_health = None
        self.boot_diagnostics = boot_diagnostics
        self.statuses = statuses
        self.placement_group_id = placement_group_id


class VirtualMachineScaleSetVMListResult(msrest.serialization.Model):
    """The List Virtual Machine Scale Set VMs operation response.

    All required parameters must be populated in order to send to Azure.

    :param value: Required. The list of virtual machine scale sets VMs.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetVM]
    :param next_link: The uri to fetch the next page of Virtual Machine Scale Set VMs. Call
     ListNext() with this to fetch the next page of VMSS VMs.
    :type next_link: str
    """

    _validation = {
        'value': {'required': True},
    }

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineScaleSetVM]'},
        'next_link': {'key': 'nextLink', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        value: List["VirtualMachineScaleSetVM"],
        next_link: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMListResult, self).__init__(**kwargs)
        self.value = value
        self.next_link = next_link


class VirtualMachineScaleSetVMProfile(msrest.serialization.Model):
    """Describes a virtual machine scale set virtual machine profile.

    :param os_profile: Specifies the operating system settings for the virtual machines in the
     scale set.
    :type os_profile: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetOSProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetStorageProfile
    :param network_profile: Specifies properties of the network interfaces of the virtual machines
     in the scale set.
    :type network_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetNetworkProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2018_04_01.models.DiagnosticsProfile
    :param extension_profile: Specifies a collection of settings for extensions installed on
     virtual machines in the scale set.
    :type extension_profile:
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineScaleSetExtensionProfile
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-
     licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>`
     Minimum api-version: 2015-06-15.
    :type license_type: str
    :param priority: Specifies the priority for the virtual machines in the scale set.
     :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Possible values include:
     "Regular", "Low".
    :type priority: str or ~azure.mgmt.compute.v2018_04_01.models.VirtualMachinePriorityTypes
    :param eviction_policy: Specifies the eviction policy for virtual machines in a low priority
     scale set. :code:`<br>`:code:`<br>`Minimum api-version: 2017-10-30-preview. Possible values
     include: "Deallocate", "Delete".
    :type eviction_policy: str or
     ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineEvictionPolicyTypes
    """

    _attribute_map = {
        'os_profile': {'key': 'osProfile', 'type': 'VirtualMachineScaleSetOSProfile'},
        'storage_profile': {'key': 'storageProfile', 'type': 'VirtualMachineScaleSetStorageProfile'},
        'network_profile': {'key': 'networkProfile', 'type': 'VirtualMachineScaleSetNetworkProfile'},
        'diagnostics_profile': {'key': 'diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'extension_profile': {'key': 'extensionProfile', 'type': 'VirtualMachineScaleSetExtensionProfile'},
        'license_type': {'key': 'licenseType', 'type': 'str'},
        'priority': {'key': 'priority', 'type': 'str'},
        'eviction_policy': {'key': 'evictionPolicy', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        os_profile: Optional["VirtualMachineScaleSetOSProfile"] = None,
        storage_profile: Optional["VirtualMachineScaleSetStorageProfile"] = None,
        network_profile: Optional["VirtualMachineScaleSetNetworkProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        extension_profile: Optional["VirtualMachineScaleSetExtensionProfile"] = None,
        license_type: Optional[str] = None,
        priority: Optional[Union[str, "VirtualMachinePriorityTypes"]] = None,
        eviction_policy: Optional[Union[str, "VirtualMachineEvictionPolicyTypes"]] = None,
        **kwargs
    ):
        super(VirtualMachineScaleSetVMProfile, self).__init__(**kwargs)
        self.os_profile = os_profile
        self.storage_profile = storage_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.extension_profile = extension_profile
        self.license_type = license_type
        self.priority = priority
        self.eviction_policy = eviction_policy


class VirtualMachineSize(msrest.serialization.Model):
    """Describes the properties of a VM size.

    :param name: The name of the virtual machine size.
    :type name: str
    :param number_of_cores: The number of cores supported by the virtual machine size.
    :type number_of_cores: int
    :param os_disk_size_in_mb: The OS disk size, in MB, allowed by the virtual machine size.
    :type os_disk_size_in_mb: int
    :param resource_disk_size_in_mb: The resource disk size, in MB, allowed by the virtual machine
     size.
    :type resource_disk_size_in_mb: int
    :param memory_in_mb: The amount of memory, in MB, supported by the virtual machine size.
    :type memory_in_mb: int
    :param max_data_disk_count: The maximum number of data disks that can be attached to the
     virtual machine size.
    :type max_data_disk_count: int
    """

    _attribute_map = {
        'name': {'key': 'name', 'type': 'str'},
        'number_of_cores': {'key': 'numberOfCores', 'type': 'int'},
        'os_disk_size_in_mb': {'key': 'osDiskSizeInMB', 'type': 'int'},
        'resource_disk_size_in_mb': {'key': 'resourceDiskSizeInMB', 'type': 'int'},
        'memory_in_mb': {'key': 'memoryInMB', 'type': 'int'},
        'max_data_disk_count': {'key': 'maxDataDiskCount', 'type': 'int'},
    }

    def __init__(
        self,
        *,
        name: Optional[str] = None,
        number_of_cores: Optional[int] = None,
        os_disk_size_in_mb: Optional[int] = None,
        resource_disk_size_in_mb: Optional[int] = None,
        memory_in_mb: Optional[int] = None,
        max_data_disk_count: Optional[int] = None,
        **kwargs
    ):
        super(VirtualMachineSize, self).__init__(**kwargs)
        self.name = name
        self.number_of_cores = number_of_cores
        self.os_disk_size_in_mb = os_disk_size_in_mb
        self.resource_disk_size_in_mb = resource_disk_size_in_mb
        self.memory_in_mb = memory_in_mb
        self.max_data_disk_count = max_data_disk_count


class VirtualMachineSizeListResult(msrest.serialization.Model):
    """The List Virtual Machine operation response.

    :param value: The list of virtual machine sizes.
    :type value: list[~azure.mgmt.compute.v2018_04_01.models.VirtualMachineSize]
    """

    _attribute_map = {
        'value': {'key': 'value', 'type': '[VirtualMachineSize]'},
    }

    def __init__(
        self,
        *,
        value: Optional[List["VirtualMachineSize"]] = None,
        **kwargs
    ):
        super(VirtualMachineSizeListResult, self).__init__(**kwargs)
        self.value = value


class VirtualMachineStatusCodeCount(msrest.serialization.Model):
    """The status code and count of the virtual machine scale set instance view status summary.

    Variables are only populated by the server, and will be ignored when sending a request.

    :ivar code: The instance view status code.
    :vartype code: str
    :ivar count: The number of instances having a particular status code.
    :vartype count: int
    """

    _validation = {
        'code': {'readonly': True},
        'count': {'readonly': True},
    }

    _attribute_map = {
        'code': {'key': 'code', 'type': 'str'},
        'count': {'key': 'count', 'type': 'int'},
    }

    def __init__(
        self,
        **kwargs
    ):
        super(VirtualMachineStatusCodeCount, self).__init__(**kwargs)
        self.code = None
        self.count = None


class VirtualMachineUpdate(UpdateResource):
    """Describes a Virtual Machine Update.

    Variables are only populated by the server, and will be ignored when sending a request.

    :param tags: A set of tags. Resource tags.
    :type tags: dict[str, str]
    :param plan: Specifies information about the marketplace image used to create the virtual
     machine. This element is only used for marketplace images. Before you can use a marketplace
     image from an API, you must enable the image for programmatic use.  In the Azure portal, find
     the marketplace image that you want to use and then click **Want to deploy programmatically,
     Get Started ->**. Enter any required information and then click **Save**.
    :type plan: ~azure.mgmt.compute.v2018_04_01.models.Plan
    :param identity: The identity of the virtual machine, if configured.
    :type identity: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineIdentity
    :param zones: The virtual machine zones.
    :type zones: list[str]
    :param hardware_profile: Specifies the hardware settings for the virtual machine.
    :type hardware_profile: ~azure.mgmt.compute.v2018_04_01.models.HardwareProfile
    :param storage_profile: Specifies the storage settings for the virtual machine disks.
    :type storage_profile: ~azure.mgmt.compute.v2018_04_01.models.StorageProfile
    :param os_profile: Specifies the operating system settings for the virtual machine.
    :type os_profile: ~azure.mgmt.compute.v2018_04_01.models.OSProfile
    :param network_profile: Specifies the network interfaces of the virtual machine.
    :type network_profile: ~azure.mgmt.compute.v2018_04_01.models.NetworkProfile
    :param diagnostics_profile: Specifies the boot diagnostic settings state.
     :code:`<br>`:code:`<br>`Minimum api-version: 2015-06-15.
    :type diagnostics_profile: ~azure.mgmt.compute.v2018_04_01.models.DiagnosticsProfile
    :param availability_set: Specifies information about the availability set that the virtual
     machine should be assigned to. Virtual machines specified in the same availability set are
     allocated to different nodes to maximize availability. For more information about availability
     sets, see `Manage the availability of virtual machines
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-manage-
     availability?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_. :code:`<br>`:code:`<br>`
     For more information on Azure planned maintenance, see `Planned maintenance for virtual
     machines in Azure <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-
     planned-maintenance?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_
     :code:`<br>`:code:`<br>` Currently, a VM can only be added to availability set at creation
     time. An existing VM cannot be added to an availability set.
    :type availability_set: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :param proximity_placement_group: Specifies information about the proximity placement group
     that the virtual machine should be assigned to. :code:`<br>`:code:`<br>`Minimum api-version:
     2018-04-01.
    :type proximity_placement_group: ~azure.mgmt.compute.v2018_04_01.models.SubResource
    :ivar provisioning_state: The provisioning state, which only appears in the response.
    :vartype provisioning_state: str
    :ivar instance_view: The virtual machine instance view.
    :vartype instance_view: ~azure.mgmt.compute.v2018_04_01.models.VirtualMachineInstanceView
    :param license_type: Specifies that the image or disk that is being used was licensed on-
     premises. This element is only used for images that contain the Windows Server operating
     system. :code:`<br>`:code:`<br>` Possible values are: :code:`<br>`:code:`<br>` Windows_Client
     :code:`<br>`:code:`<br>` Windows_Server :code:`<br>`:code:`<br>` If this element is included in
     a request for an update, the value must match the initial value. This value cannot be updated.
     :code:`<br>`:code:`<br>` For more information, see `Azure Hybrid Use Benefit for Windows Server
     <https://docs.microsoft.com/azure/virtual-machines/virtual-machines-windows-hybrid-use-benefit-
     licensing?toc=%2fazure%2fvirtual-machines%2fwindows%2ftoc.json>`_ :code:`<br>`:code:`<br>`
     Minimum api-version: 2015-06-15.
    :type license_type: str
    :ivar vm_id: Specifies the VM unique ID which is a 128-bits identifier that is encoded and
     stored in all Azure IaaS VMs SMBIOS and can be read using platform BIOS commands.
    :vartype vm_id: str
    """

    _validation = {
        'provisioning_state': {'readonly': True},
        'instance_view': {'readonly': True},
        'vm_id': {'readonly': True},
    }

    _attribute_map = {
        'tags': {'key': 'tags', 'type': '{str}'},
        'plan': {'key': 'plan', 'type': 'Plan'},
        'identity': {'key': 'identity', 'type': 'VirtualMachineIdentity'},
        'zones': {'key': 'zones', 'type': '[str]'},
        'hardware_profile': {'key': 'properties.hardwareProfile', 'type': 'HardwareProfile'},
        'storage_profile': {'key': 'properties.storageProfile', 'type': 'StorageProfile'},
        'os_profile': {'key': 'properties.osProfile', 'type': 'OSProfile'},
        'network_profile': {'key': 'properties.networkProfile', 'type': 'NetworkProfile'},
        'diagnostics_profile': {'key': 'properties.diagnosticsProfile', 'type': 'DiagnosticsProfile'},
        'availability_set': {'key': 'properties.availabilitySet', 'type': 'SubResource'},
        'proximity_placement_group': {'key': 'properties.proximityPlacementGroup', 'type': 'SubResource'},
        'provisioning_state': {'key': 'properties.provisioningState', 'type': 'str'},
        'instance_view': {'key': 'properties.instanceView', 'type': 'VirtualMachineInstanceView'},
        'license_type': {'key': 'properties.licenseType', 'type': 'str'},
        'vm_id': {'key': 'properties.vmId', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        tags: Optional[Dict[str, str]] = None,
        plan: Optional["Plan"] = None,
        identity: Optional["VirtualMachineIdentity"] = None,
        zones: Optional[List[str]] = None,
        hardware_profile: Optional["HardwareProfile"] = None,
        storage_profile: Optional["StorageProfile"] = None,
        os_profile: Optional["OSProfile"] = None,
        network_profile: Optional["NetworkProfile"] = None,
        diagnostics_profile: Optional["DiagnosticsProfile"] = None,
        availability_set: Optional["SubResource"] = None,
        proximity_placement_group: Optional["SubResource"] = None,
        license_type: Optional[str] = None,
        **kwargs
    ):
        super(VirtualMachineUpdate, self).__init__(tags=tags, **kwargs)
        self.plan = plan
        self.identity = identity
        self.zones = zones
        self.hardware_profile = hardware_profile
        self.storage_profile = storage_profile
        self.os_profile = os_profile
        self.network_profile = network_profile
        self.diagnostics_profile = diagnostics_profile
        self.availability_set = availability_set
        self.proximity_placement_group = proximity_placement_group
        self.provisioning_state = None
        self.instance_view = None
        self.license_type = license_type
        self.vm_id = None


class WindowsConfiguration(msrest.serialization.Model):
    """Specifies Windows operating system settings on the virtual machine.

    :param provision_vm_agent: Indicates whether virtual machine agent should be provisioned on the
     virtual machine. :code:`<br>`:code:`<br>` When this property is not specified in the request
     body, default behavior is to set it to true.  This will ensure that VM Agent is installed on
     the VM so that extensions can be added to the VM later.
    :type provision_vm_agent: bool
    :param enable_automatic_updates: Indicates whether virtual machine is enabled for automatic
     updates.
    :type enable_automatic_updates: bool
    :param time_zone: Specifies the time zone of the virtual machine. e.g. "Pacific Standard Time".
    :type time_zone: str
    :param additional_unattend_content: Specifies additional base-64 encoded XML formatted
     information that can be included in the Unattend.xml file, which is used by Windows Setup.
    :type additional_unattend_content:
     list[~azure.mgmt.compute.v2018_04_01.models.AdditionalUnattendContent]
    :param win_rm: Specifies the Windows Remote Management listeners. This enables remote Windows
     PowerShell.
    :type win_rm: ~azure.mgmt.compute.v2018_04_01.models.WinRMConfiguration
    """

    _attribute_map = {
        'provision_vm_agent': {'key': 'provisionVMAgent', 'type': 'bool'},
        'enable_automatic_updates': {'key': 'enableAutomaticUpdates', 'type': 'bool'},
        'time_zone': {'key': 'timeZone', 'type': 'str'},
        'additional_unattend_content': {'key': 'additionalUnattendContent', 'type': '[AdditionalUnattendContent]'},
        'win_rm': {'key': 'winRM', 'type': 'WinRMConfiguration'},
    }

    def __init__(
        self,
        *,
        provision_vm_agent: Optional[bool] = None,
        enable_automatic_updates: Optional[bool] = None,
        time_zone: Optional[str] = None,
        additional_unattend_content: Optional[List["AdditionalUnattendContent"]] = None,
        win_rm: Optional["WinRMConfiguration"] = None,
        **kwargs
    ):
        super(WindowsConfiguration, self).__init__(**kwargs)
        self.provision_vm_agent = provision_vm_agent
        self.enable_automatic_updates = enable_automatic_updates
        self.time_zone = time_zone
        self.additional_unattend_content = additional_unattend_content
        self.win_rm = win_rm


class WinRMConfiguration(msrest.serialization.Model):
    """Describes Windows Remote Management configuration of the VM.

    :param listeners: The list of Windows Remote Management listeners.
    :type listeners: list[~azure.mgmt.compute.v2018_04_01.models.WinRMListener]
    """

    _attribute_map = {
        'listeners': {'key': 'listeners', 'type': '[WinRMListener]'},
    }

    def __init__(
        self,
        *,
        listeners: Optional[List["WinRMListener"]] = None,
        **kwargs
    ):
        super(WinRMConfiguration, self).__init__(**kwargs)
        self.listeners = listeners


class WinRMListener(msrest.serialization.Model):
    """Describes Protocol and thumbprint of Windows Remote Management listener.

    :param protocol: Specifies the protocol of listener. :code:`<br>`:code:`<br>` Possible values
     are: :code:`<br>`\ **http** :code:`<br>`:code:`<br>` **https**. Possible values include:
     "Http", "Https".
    :type protocol: str or ~azure.mgmt.compute.v2018_04_01.models.ProtocolTypes
    :param certificate_url: This is the URL of a certificate that has been uploaded to Key Vault as
     a secret. For adding a secret to the Key Vault, see `Add a key or secret to the key vault
     <https://docs.microsoft.com/azure/key-vault/key-vault-get-started/#add>`_. In this case, your
     certificate needs to be It is the Base64 encoding of the following JSON Object which is encoded
     in UTF-8: :code:`<br>`:code:`<br>` {:code:`<br>`  "data":":code:`<Base64-encoded-
     certificate>`",:code:`<br>`  "dataType":"pfx",:code:`<br>`  "password":":code:`<pfx-file-
     password>`":code:`<br>`}.
    :type certificate_url: str
    """

    _attribute_map = {
        'protocol': {'key': 'protocol', 'type': 'str'},
        'certificate_url': {'key': 'certificateUrl', 'type': 'str'},
    }

    def __init__(
        self,
        *,
        protocol: Optional[Union[str, "ProtocolTypes"]] = None,
        certificate_url: Optional[str] = None,
        **kwargs
    ):
        super(WinRMListener, self).__init__(**kwargs)
        self.protocol = protocol
        self.certificate_url = certificate_url
