# Copyright 2019 NullConvergence
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Singleton metaclass"""


class Singleton(type):
  """
  Define an Instance operation that lets clients access its unique
  instance.
  """

  def __init__(cls, name, bases, attrs, **kwargs):
    super().__init__(name, bases, attrs)
    cls._instance = None

  def __call__(cls, *args, **kwargs):
    if cls._instance is None:
      cls._instance = super().__call__(*args, **kwargs)
    return cls._instance
