# mypy-boto3-mturk

[![PyPI - mypy-boto3-mturk](https://img.shields.io/pypi/v/mypy-boto3-mturk.svg?color=blue)](https://pypi.org/project/mypy-boto3-mturk)
[![PyPI - Python Version](https://img.shields.io/pypi/pyversions/mypy-boto3-mturk.svg?color=blue)](https://pypi.org/project/mypy-boto3-mturk)
[![Docs](https://img.shields.io/readthedocs/mypy-boto3-builder.svg?color=blue)](https://mypy-boto3-builder.readthedocs.io/)

Type annotations for
[boto3.MTurk 1.14.59](https://boto3.amazonaws.com/v1/documentation/api/1.14.59/reference/services/mturk.html#MTurk) service
compatible with
[VSCode](https://code.visualstudio.com/),
[PyCharm](https://www.jetbrains.com/pycharm/),
[mypy](https://github.com/python/mypy),
[pyright](https://github.com/microsoft/pyright)
and other tools.

Generated by [mypy-boto3-buider 3.1.0](https://github.com/vemel/mypy_boto3_builder).

More information can be found on [boto3-stubs](https://pypi.org/project/boto3-stubs/) page.

- [mypy-boto3-mturk](#mypy-boto3-mturk)
  - [How to install](#how-to-install)
  - [Usage](#usage)
    - [VSCode](#vscode)
    - [PyCharm](#pycharm)
    - [Other IDEs](#other-ides)
    - [mypy](#mypy)
    - [pyright](#pyright)
  - [Explicit type annotations](#explicit-type-annotations)
    - [Client annotations](#client-annotations)
    - [Paginators annotations](#paginators-annotations)
    - [Waiters annotations](#waiters-annotations)
    - [Service Resource annotations](#service-resource-annotations)
    - [Other resources annotations](#other-resources-annotations)
    - [Collections annotations](#collections-annotations)
    - [Typed dictionations](#typed-dictionations)

## How to install

Install `boto3-stubs` for `MTurk` service.

```bash
python -m pip install boto3-stubs[mturk]
```

## Usage

### VSCode

- Install [Python extension](https://marketplace.visualstudio.com/items?itemName=ms-python.python)
- Install [Pylance extension](https://marketplace.visualstudio.com/items?itemName=ms-python.vscode-pylance)
- Set `Pylance` as your Python Language Server
- Install `boto-stubs[mturk]` in your environment: `python -m pip install 'boto3-stubs[mturk]'`

Both type checking and auto-complete should work for `MTurk` service.
No explicit type annotations required, write your `boto3` code as usual.

### PyCharm

- Install `boto-stubs[mturk]` in your environment: `python -m pip install 'boto3-stubs[mturk]'`

Both type checking and auto-complete should work for `MTurk` service.
No explicit type annotations required, write your `boto3` code as usual.
Auto-complete can be slow on big projects or if you have a lot of installed `boto3-stubs` submodules.

### Other IDEs

Not tested, but as long as your IDE support `mypy` or `pyright`, everything should work.

### mypy

- Install `mypy`: `python -m pip install mypy`
- Install `boto-stubs[mturk]` in your environment: `python -m pip install 'boto3-stubs[mturk]'`
- Run `mypy` as usual

Type checking should work for `MTurk` service.
No explicit type annotations required, write your `boto3` code as usual.

### pyright

- Install `pyright`: `yarn global add pyright`
- Install `boto-stubs[mturk]` in your environment: `python -m pip install 'boto3-stubs[mturk]'`
- Optionally, you can install `boto3-stubs` to `typings` folder.

Type checking should work for `MTurk` service.
No explicit type annotations required, write your `boto3` code as usual.

## Explicit type annotations

### Client annotations

`MTurkClient` provides annotations for `boto3.client("mturk")`.

```python
import boto3

from mypy_boto3_mturk import MTurkClient

client: MTurkClient = boto3.client("mturk")

# now client usage is checked by mypy and IDE should provide code auto-complete

# works for session as well
session = boto3.session.Session(region="us-west-1")
session_client: MTurkClient = session.client("mturk")
```

### Paginators annotations

`mypy_boto3_mturk.paginator` module contains type annotations for all paginators.

```python
from mypy_boto3_mturk import MTurkClient
from mypy_boto3_mturk.paginator import (
    ListAssignmentsForHITPaginator,
    ListBonusPaymentsPaginator,
    ListHITsForQualificationTypePaginator,
    ListHITsPaginator,
    ListQualificationRequestsPaginator,
    ListQualificationTypesPaginator,
    ListReviewableHITsPaginator,
    ListWorkerBlocksPaginator,
    ListWorkersWithQualificationTypePaginator,
)

client: MTurkClient = boto3.client("mturk")

# Explicit type annotations are optional here
# Type should be correctly discovered by mypy and IDEs
# VSCode requires explicit type annotations
list_assignments_for_hit_paginator: ListAssignmentsForHITPaginator = client.get_paginator("list_assignments_for_hit")
list_bonus_payments_paginator: ListBonusPaymentsPaginator = client.get_paginator("list_bonus_payments")
list_hits_paginator: ListHITsPaginator = client.get_paginator("list_hits")
list_hits_for_qualification_type_paginator: ListHITsForQualificationTypePaginator = client.get_paginator("list_hits_for_qualification_type")
list_qualification_requests_paginator: ListQualificationRequestsPaginator = client.get_paginator("list_qualification_requests")
list_qualification_types_paginator: ListQualificationTypesPaginator = client.get_paginator("list_qualification_types")
list_reviewable_hits_paginator: ListReviewableHITsPaginator = client.get_paginator("list_reviewable_hits")
list_worker_blocks_paginator: ListWorkerBlocksPaginator = client.get_paginator("list_worker_blocks")
list_workers_with_qualification_type_paginator: ListWorkersWithQualificationTypePaginator = client.get_paginator("list_workers_with_qualification_type")
```







### Typed dictionations

`mypy_boto3_mturk.type_defs` module contains structures and shapes assembled
to typed dictionaries for additional type checking.

```python
from mypy_boto3_mturk.type_defs import (
    AssignmentTypeDef,
    BonusPaymentTypeDef,
    CreateHITResponseTypeDef,
    CreateHITTypeResponseTypeDef,
    CreateHITWithHITTypeResponseTypeDef,
    CreateQualificationTypeResponseTypeDef,
    GetAccountBalanceResponseTypeDef,
    GetAssignmentResponseTypeDef,
    GetFileUploadURLResponseTypeDef,
    GetHITResponseTypeDef,
    GetQualificationScoreResponseTypeDef,
    GetQualificationTypeResponseTypeDef,
    HITLayoutParameterTypeDef,
    HITTypeDef,
    ListAssignmentsForHITResponseTypeDef,
    ListBonusPaymentsResponseTypeDef,
    ListHITsForQualificationTypeResponseTypeDef,
    ListHITsResponseTypeDef,
    ListQualificationRequestsResponseTypeDef,
    ListQualificationTypesResponseTypeDef,
    ListReviewableHITsResponseTypeDef,
    ListReviewPolicyResultsForHITResponseTypeDef,
    ListWorkerBlocksResponseTypeDef,
    ListWorkersWithQualificationTypeResponseTypeDef,
    LocaleTypeDef,
    NotificationSpecificationTypeDef,
    NotifyWorkersFailureStatusTypeDef,
    NotifyWorkersResponseTypeDef,
    PaginatorConfigTypeDef,
    ParameterMapEntryTypeDef,
    PolicyParameterTypeDef,
    QualificationRequestTypeDef,
    QualificationRequirementTypeDef,
    QualificationTypeDef,
    QualificationTypeTypeDef,
    ReviewActionDetailTypeDef,
    ReviewPolicyTypeDef,
    ReviewReportTypeDef,
    ReviewResultDetailTypeDef,
    UpdateQualificationTypeResponseTypeDef,
    WorkerBlockTypeDef,
)

def get_structure() -> AssignmentTypeDef:
    return {
      ...
    }
```
