<p align="center">
  <a href="https://github.com/tesseradecade/vbml">
    <img src="/logo.jpeg" width="200px" style="display: inline-block;">
  </a>
</p>
<h1 align="center">
  [VBML] perfect pythonistic parser / string manipulator :sparkles:
</h1>
<p align="center">
  <img alt="PyPI - License" src="https://img.shields.io/pypi/l/vbml?style=flat-square">
  <img alt="PyPI - Downloads" src="https://img.shields.io/pypi/dw/vbml?style=flat-square">
  <img alt="GitHub repo size" src="https://img.shields.io/github/repo-size/tesseradecade/vbml?style=flat-square">
  <img alt="GitHub issues by-label" src="https://img.shields.io/github/issues/tesseradecade/vbml/bug?style=flat-square">
</p>

## Features

* Fast `regex`-based parser
* Easy-to-understand validators / Custom validators
* Lots of features out-of-box

`I am <name>, i am <age:int> years old` + `I am Steven, i am 20 years old` = `{"name": "Steven", "age": 20}`

## Installation

Install with pip:

```shell script
pip install vbml
```

Or with poetry:

```shell script
poetry add vbml
```

## Run tests

Clone repo from git:

```shell script
git clone https://github.com/tesseradecade/vbml.git
```

Go to repository and run tests with `poetry`:

```shell script
cd vbml
poetry install
poetry run pytest
```

## :book: Documentation

Full documentation contents are available in [docs/index.md](/docs/index.md)

## Simple example

```python
from vbml import Patcher, Pattern

patcher = Patcher()
pattern = Pattern("He is <description> like he has right just turned <age:int> years old")

result1 = patcher.check(pattern, "He is so spontaneous like he has right just turned 10 years old")
result2 = patcher.check(pattern, "He is silly like he has right just turned t3n years old")
result3 = patcher.check(pattern, "Haha regex go brrr")

result1 # {"description": "so spontaneous", "age": 10}
result2 # None
result3 # None
```

Leave a :star: if this project helped you  
Made with :heart: by [timoniq](https://github.com/timoniq)
