from copy import copy
from cryptography.fernet import Fernet
import hashlib
import random


def self_consistency_check() -> bool:
    random.seed(0)
    rs = random.getstate()
    assert rs == (
        3,
        (
            2147483648,
            766982754,
            497961170,
            3952298588,
            2331775348,
            1811986599,
            3100132149,
            3188119873,
            3937547222,
            215718963,
            3315684082,
            2978012849,
            2428261856,
            1298227695,
            1704729580,
            54668373,
            3285201915,
            3285178464,
            1552935063,
            988471319,
            3135387943,
            1691402966,
            2757551880,
            416056905,
            907387413,
            1072924981,
            33903495,
            2168419592,
            2429050353,
            831159753,
            430343641,
            3315943586,
            1761671042,
            864453023,
            334804929,
            1627478028,
            2596811275,
            3468733638,
            3994375553,
            1457139722,
            3139722021,
            1334790738,
            2656639915,
            3535811098,
            1464315470,
            2397423927,
            885719490,
            1140895889,
            3284299483,
            2854516462,
            2734973817,
            147484763,
            792049954,
            114360641,
            3345458839,
            1159898878,
            1410498733,
            2242989638,
            453922141,
            1344019764,
            413870456,
            3089405849,
            1494382840,
            470157779,
            4266372830,
            2831181573,
            1361928602,
            1589253513,
            1381373062,
            753045124,
            987032420,
            781978839,
            2953638767,
            3258570111,
            3006718191,
            1675218601,
            1854232715,
            3655829819,
            1731242722,
            2192104666,
            1736665161,
            740150002,
            1195833394,
            1610203160,
            159492766,
            4041488705,
            3128952632,
            2867295744,
            3272632449,
            886824304,
            1791482600,
            221114776,
            3867175393,
            4020804062,
            1077871826,
            1298953503,
            996366221,
            4149754679,
            2483052703,
            2615558283,
            274318093,
            1716359450,
            4099129961,
            1026774175,
            288240973,
            1459347562,
            2365566296,
            3690105224,
            3065780221,
            2050634722,
            2652606621,
            3185241207,
            3026457375,
            3456165734,
            1880121515,
            3398461093,
            1795638629,
            2379692076,
            608668379,
            1261955525,
            84456522,
            1913485156,
            106878280,
            757183891,
            2913957588,
            160418091,
            2025664758,
            141497907,
            1657818026,
            3053760160,
            672193054,
            4157546743,
            223046484,
            1623470498,
            1201972930,
            675008814,
            684162366,
            1738776330,
            3025656654,
            159760723,
            1908867305,
            3933381342,
            2545706671,
            467196949,
            1427819885,
            842150314,
            4032903454,
            2140851898,
            3269883445,
            975813755,
            4177392955,
            1556690684,
            2535611513,
            462962732,
            67591358,
            1729610528,
            2025206740,
            3153739740,
            3255032049,
            4186226368,
            1070144624,
            3107867195,
            1621006038,
            63742485,
            835629717,
            3189842019,
            3950227584,
            3184714559,
            841836938,
            1685394870,
            657939920,
            766156242,
            1412314179,
            1048281639,
            4037161120,
            2044490307,
            1923947830,
            3900790422,
            907554295,
            276417304,
            860658646,
            3574201134,
            3508771399,
            2110232300,
            1636296241,
            1405006077,
            1093408401,
            3243057343,
            1519791182,
            1994660136,
            3829840937,
            2644974199,
            957955566,
            3487641161,
            1646922510,
            1907939989,
            3836029453,
            3429168778,
            201307778,
            72550089,
            2464394982,
            1695794191,
            3344785682,
            996786130,
            3589457196,
            1241754792,
            1291082245,
            4224603667,
            1194379475,
            2693491244,
            881186965,
            2705535111,
            445306946,
            440274268,
            1980827733,
            2482488861,
            3205215943,
            2119332222,
            2928713046,
            1418736938,
            652581136,
            2474070665,
            2208621536,
            4171251876,
            2303664214,
            443762656,
            2981912989,
            2199228311,
            2652261633,
            3166738494,
            3443009210,
            3498764432,
            424010848,
            4065487566,
            2262993542,
            1756076712,
            1477098233,
            2742171915,
            306185806,
            3610666541,
            923091830,
            1034267993,
            2336668648,
            1880719718,
            676878038,
            3788797208,
            3763351494,
            3985428106,
            1101865631,
            1130501258,
            3672967388,
            3432003530,
            4124438011,
            1660392285,
            4025484827,
            2108074566,
            3815409682,
            42955331,
            3248965569,
            1643835718,
            1246665668,
            1071162194,
            3814069229,
            115491158,
            985096811,
            3311029186,
            2990827378,
            3101633320,
            1648574497,
            1470117052,
            174145027,
            2019894819,
            2035501481,
            459104123,
            3507464599,
            2093352659,
            3369174406,
            618767835,
            4009895756,
            935587447,
            3956987426,
            33753995,
            307782427,
            2473424805,
            1440371818,
            2382619594,
            2138695812,
            3164510238,
            1318650933,
            2910086616,
            3886677510,
            566832801,
            3718063320,
            1559818704,
            183047272,
            1142362855,
            26306548,
            645536402,
            3875596208,
            2272778168,
            3512733409,
            1897046338,
            38248886,
            2570759766,
            1806313150,
            860304898,
            2433450338,
            4124013408,
            1216634590,
            1275388896,
            1169566669,
            652504502,
            761221427,
            1448403764,
            3129135949,
            2513214949,
            1269533687,
            2413509541,
            1226750363,
            2450740925,
            4094137910,
            945759293,
            3636927736,
            3178020081,
            2509964157,
            3878869300,
            1848504895,
            2018369720,
            1579755740,
            1023627943,
            924838836,
            2653160914,
            1812804174,
            1521323076,
            4012390528,
            1338763317,
            2608655937,
            16022784,
            1672945066,
            2177189646,
            2944458483,
            2213810972,
            1369873847,
            1224017670,
            130901785,
            3595066712,
            2259115284,
            3316038259,
            455873927,
            2917250465,
            3599550610,
            1502173758,
            684943436,
            3079863840,
            3144992244,
            942855823,
            1771140188,
            2118780653,
            3411494225,
            2711180217,
            4239611184,
            1371891067,
            3398566397,
            3105518599,
            1310665701,
            3345178451,
            2959821156,
            242241789,
            2148966880,
            3192740583,
            404401893,
            3605380577,
            1446464038,
            3920522056,
            2577523013,
            1079274576,
            286634372,
            1752710796,
            2351075979,
            981312309,
            3410516352,
            3468455736,
            1938779182,
            1592494371,
            1533303080,
            88045436,
            438252489,
            1220512168,
            3487004938,
            3724852871,
            1073434882,
            3728218947,
            2977555283,
            4105408406,
            3553772656,
            1462006821,
            3917158017,
            119003006,
            3470530198,
            3439192457,
            2829375771,
            3555715155,
            32324691,
            588735808,
            1459221702,
            803072782,
            2699519868,
            1530797005,
            79738580,
            671990400,
            4289511388,
            3207115447,
            2584684068,
            832698998,
            760958416,
            1217440464,
            2517898131,
            2418819938,
            3629956222,
            3445024962,
            206619378,
            365007395,
            522114139,
            1707954431,
            540423623,
            1786750801,
            369253262,
            4239016754,
            147889201,
            1637777773,
            236798285,
            2806120188,
            586972608,
            2201782716,
            1323327827,
            819485723,
            406078680,
            3407345698,
            1537169369,
            1821691865,
            527271655,
            3751827102,
            1465426495,
            3321682429,
            2179672664,
            401355478,
            1068871880,
            24609462,
            1403522408,
            2311580015,
            1532058170,
            3877815340,
            1768430711,
            1619755157,
            2832904331,
            475102697,
            354987331,
            3295386430,
            2816873951,
            1039415736,
            363972779,
            1499307670,
            2895506264,
            3746345349,
            2678027234,
            3251899088,
            955392878,
            2329157295,
            1343358773,
            309573887,
            2410178377,
            2843173466,
            361132917,
            1755816798,
            1319204283,
            609284796,
            1998842567,
            1892325921,
            223190385,
            1483015769,
            2876023365,
            3876009312,
            3199738344,
            491524099,
            160383137,
            1219178873,
            3870310498,
            1114580266,
            4279604166,
            855339774,
            1983818547,
            2297848784,
            4118592947,
            4084409863,
            2225095054,
            4215601993,
            946447434,
            4205503762,
            146088676,
            778046685,
            1876936928,
            3157333726,
            2173097090,
            3215738813,
            4135448234,
            1219619643,
            1936128689,
            2897130162,
            3336043946,
            3779039524,
            4200886837,
            1359380925,
            3402593091,
            3140713935,
            50855190,
            3122065768,
            1501584468,
            2512255124,
            687125154,
            2666013386,
            837819715,
            3057258172,
            3653455791,
            2868624990,
            322131992,
            42534870,
            4036564806,
            798099710,
            3533853670,
            190914037,
            3726947981,
            2601169403,
            602059656,
            1365668439,
            1918780004,
            394790500,
            277566007,
            3891847777,
            3365421094,
            3139612253,
            1380519090,
            1183088424,
            4203794803,
            3049949521,
            4214159484,
            3446206962,
            1875544460,
            3207220027,
            3288287026,
            913535288,
            178159620,
            1410694581,
            4190575040,
            880731713,
            1427805121,
            404869072,
            3413191414,
            2865934056,
            2899472677,
            4239222733,
            688404529,
            3923323887,
            933651074,
            1199453686,
            642723732,
            2850614853,
            3104368451,
            3054041024,
            3129913503,
            2805843726,
            1829781129,
            3479062313,
            650272704,
            4224852052,
            4085038685,
            2616580676,
            1793860711,
            585126334,
            2995262791,
            520446536,
            3855655015,
            1571815563,
            2240778227,
            2051010344,
            1694977983,
            788402852,
            1988089041,
            2035558649,
            1800063056,
            1234412692,
            2490862867,
            417320514,
            2415019489,
            3374117797,
            136034611,
            898704236,
            1247106941,
            3923519397,
            3563607190,
            2454738671,
            3522360389,
            2672645476,
            146828884,
            3985140042,
            4233949333,
            1184742586,
            860278824,
            2815489967,
            983483427,
            3190081845,
            3288865305,
            3575181235,
            1292151129,
            4007823805,
            4049420597,
            3499391972,
            1611182906,
            1721268432,
            2944249577,
            2487212557,
            789127738,
            4027610014,
            1057334138,
            2902720905,
            624,
        ),
        None,
    )
    a = list(range(50))
    random.shuffle(a)
    if a == [
        43,
        1,
        28,
        14,
        36,
        12,
        0,
        27,
        47,
        7,
        33,
        34,
        20,
        49,
        5,
        38,
        11,
        23,
        40,
        15,
        10,
        21,
        46,
        3,
        9,
        4,
        41,
        42,
        39,
        17,
        29,
        45,
        6,
        35,
        18,
        8,
        44,
        13,
        37,
        22,
        30,
        19,
        25,
        31,
        32,
        16,
        2,
        26,
        48,
        24,
    ]:
        return True
    else:
        return False


def check_hashseed() -> bool:
    """Need to set PYTHONHASHSEED=0 in env variable"""
    if hash("GOD") == -3890164749404887474:
        print("Hash seed confirmed.")
        return True
    else:
        print("Hash seed incorrect.")
        return False


def permutate(input: str, key: str = None):
    """Input should be a space delimited word string"""
    if not self_consistency_check():
        print("Failed self consistency check. DO NOT PROCEED!")
        quit(1)

    if not key:
        print("No key specified, will used the default: test")
        key = "test"

    words = [w.strip() for w in input.split()]
    wc = len(words)
    seq_orig = list(range(wc))
    seq = copy(seq_orig)
    m = hashlib.sha256()
    m.update(key.encode() if isinstance(key, str) else key)
    random.seed(m.hexdigest())
    random.shuffle(seq)
    return " ".join([words[i] for i in seq])


def reverse_permutate(input: str, key: str = None):
    """Input should be a space delimited word string"""
    if not self_consistency_check():
        print("Failed self consistency check. DO NOT PROCEED!")
        quit(1)

    if not key:
        print("No key specified, will used the default: test")
        key = "test"

    words = [w.strip() for w in input.split()]
    wc = len(words)
    seq_orig = list(range(wc))
    seq = copy(seq_orig)
    m = hashlib.sha256()
    m.update(key.encode() if isinstance(key, str) else key)
    random.seed(m.hexdigest())
    random.shuffle(seq)
    tp = list(zip(seq_orig, seq))
    tp.sort(key=lambda x: x[1])
    seq_rev = [t[0] for t in tp]
    return " ".join([words[i] for i in seq_rev])


def encrypt(message: bytes, key: bytes) -> bytes:
    return Fernet(key).encrypt(message)


def decrypt(token: bytes, key: bytes) -> bytes:
    return Fernet(key).decrypt(token)
