import { Construct } from 'constructs';
/**
 * @stability stable
 */
export declare enum AmazonLinuxGeneration {
    /**
     * @stability stable
     */
    AMAZON_LINUX = 0,
    /**
     * @stability stable
     */
    AMAZON_LINUX_2 = 1
}
/**
 * @stability stable
 */
export declare enum AmiHardwareType {
    /**
     * Use the standard Amazon ECS-optimized AMI.
     *
     * @stability stable
     */
    STANDARD = "Standard",
    /**
     * Use the Amazon ECS GPU-optimized AMI.
     *
     * @stability stable
     */
    GPU = "GPU",
    /**
     * Use the Amazon ECS-optimized Amazon Linux 2 (arm64) AMI.
     *
     * @stability stable
     */
    ARM = "ARM64"
}
/**
 * Identifies an instance's CPU architecture.
 *
 * @stability stable
 */
export declare enum InstanceArchitecture {
    /**
     * ARM64 architecture.
     *
     * @stability stable
     */
    ARM_64 = "arm64",
    /**
     * x86-64 architecture.
     *
     * @stability stable
     */
    X86_64 = "x86_64"
}
/**
 * @stability stable
 */
export interface IEcsMachineImage {
    /**
     * @stability stable
     */
    readonly amiId: string;
}
/**
 * @stability stable
 */
export interface EcsOptimizedAmiProps {
    /**
     * @stability stable
     */
    readonly generation?: AmazonLinuxGeneration;
    /**
     * @stability stable
     */
    readonly hwtype?: AmiHardwareType;
}
/**
 * @stability stable
 */
export declare class EcsOptimizedAmi implements IEcsMachineImage {
    /**
     * @stability stable
     */
    readonly amiParameterName: string;
    /**
     * @stability stable
     */
    readonly generation: AmazonLinuxGeneration;
    /**
     * @stability stable
     */
    readonly hwType: AmiHardwareType;
    /**
     * @stability stable
     */
    readonly scope: Construct;
    /**
     * @stability stable
     */
    constructor(scope: Construct, props?: EcsOptimizedAmiProps);
    /**
     * Return the correct image.
     *
     * @stability stable
     */
    get amiId(): string;
}
/**
 * Amazon ECS variant
 */
export declare enum BottlerocketEcsVariant {
    /**
     * Amazon ECS variant.
     *
     * @stability stable
     */
    AWS_ECS_1 = "aws-ecs-1"
}
/**
 * Properties for BottleRocketImage.
 *
 * @stability stable
 */
export interface BottleRocketImageProps {
    /**
     * The Amazon ECS variant to use.
     *
     * Only `aws-ecs-1` is currently available
     *
     * @default - BottlerocketEcsVariant.AWS_ECS_1
     * @stability stable
     */
    readonly variant?: BottlerocketEcsVariant;
    /**
     * The CPU architecture.
     *
     * @default - x86_64
     * @stability stable
     */
    readonly architecture?: InstanceArchitecture;
}
/**
 * Construct an Bottlerocket image from the latest AMI published in SSM.
 *
 * @stability stable
 */
export declare class BottleRocketImage implements IEcsMachineImage {
    private readonly amiParameterName;
    /**
     * Amazon ECS variant for Bottlerocket AMI
     */
    private readonly variant;
    /**
     * Instance architecture
     */
    private readonly architecture;
    private readonly scope;
    /**
     * Constructs a new instance of the BottleRocketImage class.
     *
     * @stability stable
     */
    constructor(scope: Construct, props?: BottleRocketImageProps);
    /**
     * Return the correct image.
     *
     * @stability stable
     */
    get amiId(): string;
}
