# -*- coding: utf-8 -*-
"""`TSIC2552 Standard <http://statstd.nso.go.th/classification/downloadcffile.aspx?id=73>`_.

.. note::

    Descriptions were translated using Google Translate.
"""
from ...types import Classification, Standard, Standards

TSIC2552 = Standard(
    standard=Standards.TSIC2552,
    classes=[
        Classification("A", "Agriculture, Forestry And Fisheries"),
        Classification("1", "Cultivation And Animal Husbandry, Hunting And Related Service Activities"),
        Classification("11", "Biennial Planting"),
        Classification("111", "Cultivation Of Cereals (Except Rice), Legumes And Oilseed Plants"),
        Classification("1111", "Cultivation Of Corn Using Mature Seeds"),
        Classification("1112", "Cereal Planting (Except Rice And Corn)"),
        Classification("1113", "Growing Legumes"),
        Classification("1114", "Soybean Cultivation"),
        Classification("1115", "Cultivation Of Oilseeds (Except Soybeans)"),
        Classification("112", "Rice Planting"),
        Classification("1121", "Rice Cultivation"),
        Classification("1122", "Glutinous Rice Cultivation"),
        Classification("113", "Cultivation Of Vegetables, Melons And Tubers"),
        Classification("1131", "Cultivation Of Leafy Vegetables And Herbivorous Plants"),
        Classification("1132", "Growing Vegetables Including Different Types Of Melons"),
        Classification("1133", "Growing Root Vegetables And Tubers"),
        Classification("1134", "Growing Root Vegetables And Tubers With High Starches And Inulin (Except Cassava)"),
        Classification("1135", "Cassava Cultivation"),
        Classification("1136", "Mushroom Cultivation"),
        Classification("1139", "Other Vegetable Cultivation"),
        Classification("114", "Sugarcane Planting"),
        Classification("1140", "Sugarcane Planting"),
        Classification("115", "Tobacco Cultivation"),
        Classification("1150", "Tobacco Cultivation"),
        Classification("116", "Fiber Crops"),
        Classification("1161", "Cotton Planting"),
        Classification("1169", "Other Fiber Crops"),
        Classification("119", "Cultivation Of Other Herbaceous Plants"),
        Classification("1191", "Cultivation Of Maize"),
        Classification("1192", "Cultivation Of Herbaceous Plants Used As Animal Feed (Except Maize)"),
        Classification("1193", "Orchid Planting"),
        Classification("1194", "Other Flower Plantings (Except Orchids)"),
        Classification("1199", "Cultivation Of Other Herbaceous Plants Which Are Not Classified Elsewhere"),
        Classification("12", "Perennial Planting"),
        Classification("121", "Viticulture"),
        Classification("1210", "Viticulture"),
        Classification("122", "Cultivation Of Tropical And Semi-Tropical Fruits"),
        Classification("1221", "Pineapple Planting"),
        Classification("1222", "Durian Cultivation"),
        Classification("1223", "Longan Cultivation"),
        Classification("1224", "Mango Cultivation"),
        Classification("1225", "Banana Planting"),
        Classification("1226", "Mangosteen Cultivation"),
        Classification("1227", "Rambutan Cultivation"),
        Classification("1228", "Planting Lychees"),
        Classification("1229", "Cultivation Of Other Tropical And Subtropical Fruits"),
        Classification("123", "Cultivation Of Citrus Fruits"),
        Classification("1231", "Orange Planting"),
        Classification("1239", "Cultivation Of Other Citrus Fruits"),
        Classification("124", "Cultivation Of Apple And Hard Seed Fruit Trees"),
        Classification("1241", "Apple Cultivation"),
        Classification("1249", "Other Hard Seed Plantings"),
        Classification("125", "Perennial Planting Bushy Fruit Trees And Edible Fruit Trees"),
        Classification("1251", "Growing Edible Bark Fruit Trees"),
        Classification("1252", "Cultivation Of Fruit Trees With Shrubs"),
        Classification("1259", "Planting Other Perennial Fruit Trees"),
        Classification("126", "Cultivation Of Oily Perennials"),
        Classification("1261", "Oil Palm Plantation"),
        Classification("1262", "Coconut Planting"),
        Classification("1269", "Planting Other Perennials That Provide Oil"),
        Classification("127", "Cultivation Of Plants That Are Used To Make Beverages"),
        Classification("1271", "Tea Planting"),
        Classification("1272", "Coffee Plantation"),
        Classification("1279", "Other Crops Used To Make Drinks"),
        Classification("128", "Cultivation Of Plants Used To Make Spices, Fragrances, Medicines And Medicinal Plants."),
        Classification("1281", "Growing Peppers"),
        Classification("1282", "Pepper Planting"),
        Classification("1289", "Other Crops Used To Make Spices, Incense, Medicines And Pharmaceutical Plants"),
        Classification("129", "Cultivation Of Other Types Of Perennial Plants"),
        Classification("1291", "Rubber Tree Planting"),
        Classification("1292", "Planting Plants For Weaving"),
        Classification("1299", "Cultivation Of Other Types Of Perennial Plants Which Are Not Classified Elsewhere"),
        Classification("13", "Ornamental Gardening And Plant Propagation"),
        Classification("130", "Ornamental Gardening And Plant Propagation"),
        Classification("1301", "Ornamental Gardening"),
        Classification("1302", "Plant Propagation"),
        Classification("14", "Animal Husbandry"),
        Classification("141", "Cattle And Buffalo Rearing"),
        Classification("1411", "Dairy And Beef Cattle Raising"),
        Classification("1412", "Raising Milk Buffaloes And Meat Buffaloes"),
        Classification("1419", "Raising Cattle And Buffaloes For Other Purposes"),
        Classification("142", "Raising Horses, Donkeys, Mules, Mules And Other Equine Animals"),
        Classification("1420", "Raising Horses, Donkeys, Mules, Mules And Other Equine Animals"),
        Classification("143", "Camel Farming"),
        Classification("1430", "Camel Farming"),
        Classification("144", "Raising Sheep And Goats"),
        Classification("1441", "Sheep Farming"),
        Classification("1442", "Goat Farming"),
        Classification("145", "Pig Farming"),
        Classification("1450", "Pig Farming"),
        Classification("146", "Poultry Farming"),
        Classification("1461", "Laying Hens"),
        Classification("1462", "Broiler Farming"),
        Classification("1463", "Duck Farming"),
        Classification("1469", "Other Poultry Farming"),
        Classification("149", "Other Animal Husbandry"),
        Classification("1491", "Raising Ostriches And Emu"),
        Classification("1492", "Raising Silkworms, Butterflies And Insects"),
        Classification("1493", "Beekeeping"),
        Classification("1494", "Raising Swallows"),
        Classification("1495", "Snake Farming"),
        Classification("1496", "Animal Farming (Except Aquatic Animals)"),
        Classification("1499", "Other Animal Husbandry Which Are Not Classified Elsewhere"),
        Classification("15", "Mixed Farming"),
        Classification("150", "Mixed Farming"),
        Classification("1500", "Mixed Farming"),
        Classification("16", "Activities That Support Agriculture And Post-Harvest Activities"),
        Classification("161", "Activities That Support Crop Production"),
        Classification("1611", "Insect And Pest Control"),
        Classification("1612", "Operations On Irrigation Equipment And Agricultural Irrigation Equipment"),
        Classification("1619", "Other Activities That Support Crop Production"),
        Classification("162", "Activities That Support Animal Husbandry"),
        Classification("1621", "Activities That Support The Breeding Of Animals"),
        Classification("1629", "Other Activities That Support Animal Husbandry"),
        Classification("163", "Post-Harvest Activities"),
        Classification("1630", "Post-Harvest Activities"),
        Classification("164", "Seed Management For Propagation"),
        Classification("1640", "Seed Management For Propagation"),
        Classification("17", "Hunting, Trapping And Other Service Activities Related"),
        Classification("170", "Hunting, Trapping And Other Service Activities Related"),
        Classification("1700", "Hunting, Trapping And Other Service Activities Related"),
        Classification("2", "Forestry And Logging"),
        Classification("21", "Forestry And Other Activities Forestry"),
        Classification("210", "Forestry And Other Activities Forestry"),
        Classification("2100", "Forestry And Other Activities Forestry"),
        Classification("22", "Woodworking"),
        Classification("220", "Woodworking"),
        Classification("2200", "Woodworking"),
        Classification("23", "Wild Collecting"),
        Classification("230", "Wild Collecting"),
        Classification("2300", "Wild Collecting"),
        Classification("24", "Services That Support Forestry"),
        Classification("240", "Services That Support Forestry"),
        Classification("2400", "Services That Support Forestry"),
        Classification("3", "Fisheries And Aquaculture"),
        Classification("31", "Fishery"),
        Classification("311", "Sea ​​Fishing"),
        Classification("3111", "Sea ​​Fishing"),
        Classification("3112", "Catching Seafood Shrimp"),
        Classification("3113", "Catching Sea Crabs"),
        Classification("3114", "Ink Capture"),
        Classification("3115", "Catching Sea Snails"),
        Classification("3119", "Other Marine Fisheries"),
        Classification("312", "Freshwater Fishery"),
        Classification("3121", "Freshwater Fishing"),
        Classification("3122", "Catching Freshwater Shrimp"),
        Classification("3129", "Other Freshwater Fisheries"),
        Classification("32", "Aquaculture"),
        Classification("321", "Marine Aquaculture"),
        Classification("3211", "Marine Fish Farming"),
        Classification("3212", "Shrimp Farming"),
        Classification("3213", "Clam Cultivation"),
        Classification("3214", "Beautiful Marine Aquaculture"),
        Classification("3219", "Other Marine Aquaculture"),
        Classification("322", "Freshwater Aquaculture"),
        Classification("3221", "Freshwater Fish Farming"),
        Classification("3222", "Freshwater Shrimp Cultivation"),
        Classification("3223", "Frog Farming"),
        Classification("3224", "Crocodile Farming"),
        Classification("3225", "Beautiful Freshwater Aquaculture"),
        Classification("3229", "Other Freshwater Aquaculture"),
        Classification("B", "Mining And Quarrying"),
        Classification("5", "Coal And Lignite Mining"),
        Classification("51", "High Quality Coal Mining"),
        Classification("510", "High Quality Coal Mining"),
        Classification("5100", "High Quality Coal Mining"),
        Classification("52", "Lignite Mining"),
        Classification("520", "Lignite Mining"),
        Classification("5200", "Lignite Mining"),
        Classification("6", "Crude Petroleum And Natural Gas Drilling"),
        Classification("61", "Crude Petroleum Drilling"),
        Classification("610", "Crude Petroleum Drilling"),
        Classification("6100", "Crude Petroleum Drilling"),
        Classification("62", "Natural Gas Drilling"),
        Classification("620", "Natural Gas Drilling"),
        Classification("6200", "Natural Gas Drilling"),
        Classification("7", "Metal Ore Mining"),
        Classification("71", "Iron Ore Mining"),
        Classification("710", "Iron Ore Mining"),
        Classification("7100", "Iron Ore Mining"),
        Classification("72", "Mining Of Non-Ferrous Metal Ores (Except Precious Metals)"),
        Classification("721", "Mining Of Uranium And Thorium"),
        Classification("7210", "Mining Of Uranium And Thorium"),
        Classification("729", "Mining Of Other Metal Ores Non-Iron Ore"),
        Classification("7291", "Tin Mining"),
        Classification("7292", "Zinc Ore Mining"),
        Classification("7299", "Mining Of Other Metal Ores Non-Iron Ore Which Are Not Classified Elsewhere"),
        Classification("73", "Mining Of Precious Metals"),
        Classification("730", "Mining Of Precious Metals"),
        Classification("7300", "Mining Of Precious Metals"),
        Classification("8", "Mining And Other Quarrying"),
        Classification("81", "Mining Of Stone, Sand And Soil"),
        Classification("810", "Mining Of Stone, Sand And Soil"),
        Classification("8101", "Quarrying Of Stone Used In Construction"),
        Classification("8102", "Mining Of Limestone, Gypsum, Chalk And Dolomite"),
        Classification("8103", "Gravel And Sand Digging"),
        Classification("8104", "Soil Mining"),
        Classification("89", "Mining And Quarrying Which Are Not Classified Elsewhere"),
        Classification("891", "Mining Of Chemicals And Fertilizers"),
        Classification("8910", "Mining Of Chemicals And Fertilizers"),
        Classification("892", "Cultivating Peat"),
        Classification("8920", "Cultivating Peat"),
        Classification("893", "Salt Mining"),
        Classification("8931", "Rock Salt Mining"),
        Classification("8932", "Sea ​​Salt Mining"),
        Classification("899", "Mining And Other Quarrying Which Are Not Classified Elsewhere"),
        Classification("8991", "Mining Of Gems And Semi-Precious Stones"),
        Classification("8999", "Mining And Other Quarrying Which Are Not Classified Elsewhere"),
        Classification("9", "Service Activities That Support Mining"),
        Classification("91", "Activities That Support Petroleum And Natural Gas Drilling"),
        Classification("910", "Activities That Support Petroleum And Natural Gas Drilling"),
        Classification("9100", "Activities That Support Petroleum And Natural Gas Drilling"),
        Classification("99", "Activities That Support Mining And Other Quarrying"),
        Classification("990", "Activities That Support Mining And Other Quarrying"),
        Classification("9900", "Activities That Support Mining And Other Quarrying"),
        Classification("C", "Production"),
        Classification("10", "Food Product Production"),
        Classification("101", "Meat Processing And Preservation"),
        Classification("1011", "Meat Production (Except Poultry)"),
        Classification("10111", "Slaughter (Except Poultry)"),
        Classification("10112", "Meat Production (Except Poultry), Fresh, Chilled Or Frozen"),
        Classification("1012", "Poultry Slaughter And Fresh, Chilled Or Frozen Poultry Production"),
        Classification("10120", "Poultry Slaughter And Fresh, Chilled Or Frozen Poultry Production"),
        Classification("1013", "Production Of Meat And Poultry Products"),
        Classification("10131", "Manufacture Of Dried, Salted Or Smoked Meat And Poultry"),
        Classification("10132", "Manufacture Of Sausages, Meatballs And Similar Products Made From Meat And Poultry"),
        Classification("10133", "Canned Meat And Poultry Production"),
        Classification("10134", "Production Of Animal And Poultry By-Products"),
        Classification("10139", "Production Of Other Products From Meat And Poultry"),
        Classification("102", "Processing And Preservation Of Aquatic Animals"),
        Classification("1021", "Production Of Fresh, Chilled Or Frozen Aquatic Animals And Products"),
        Classification("10211", "Manufacture Of Fresh, Chilled Or Frozen Fish And Fish Products"),
        Classification(
            "10212", "Manufacture Of Aquatic Animals And Aquatic Products (Except Fish), Fresh, Chilled Or Frozen"
        ),
        Classification("1022", "Canned Fish Production"),
        Classification("10221", "Canned Fish Production"),
        Classification("10222", "Production Of Aquatic Animals (Except Fish) Canned"),
        Classification("1029", "Production Of Other Processed Aquatic Products"),
        Classification(
            "10291", "Manufacture Of Aquatic Products That Have Been Dried, Smoked, Salted, Soaked In Brine Or Vinegar"
        ),
        Classification("10292", "Manufacture Of Sausages, Meatballs And Similar Products Made Of Aquatic Animals"),
        Classification("10293", "Production Of Fish Sauce And Fermented Aquatic Products"),
        Classification("10294", "Production Of Fish Meal For Animal Feed"),
        Classification("10295", "Seaweed Processing"),
        Classification("10299", "Production Of Other Processed Aquatic Products Which Are Not Classified Elsewhere"),
        Classification("103", "Processing And Preserving Of Fruits And Vegetables"),
        Classification("1030", "Processing And Preserving Of Fruits And Vegetables"),
        Classification("10301", "Frozen Fruit And Vegetable Production"),
        Classification("10302", "Canned Fruit And Vegetable Production"),
        Classification("10303", "Fruit And Vegetable Juice Production"),
        Classification("10304", "Preserving Fruits And Vegetables By Drying, Salting, Soaking In Oil Or Vinegar."),
        Classification("10305", "Production Of Jams, Marmalades And Jellies"),
        Classification("10306", "Processing And Preserving Potatoes"),
        Classification("10307", "Production Of Fruit Products (Nuts)"),
        Classification("10309", "Other Processing And Preservation Of Fruits And Vegetables"),
        Classification("104", "Production Of Vegetable And Animal Oils And Fats"),
        Classification("1041", "Vegetable Oil Production (Except Palm Oil)"),
        Classification("10411", "Soybean Oil Production"),
        Classification("10412", "Rice Bran Oil Production"),
        Classification("10413", "Corn Oil Production"),
        Classification("10414", "Coconut Oil Production"),
        Classification("10419", "Other Vegetable Oil Production (Except Palm Oil)"),
        Classification("1042", "Palm Oil Production"),
        Classification("10420", "Palm Oil Production"),
        Classification("1049", "Production Of Animal Oils And Fats And Other Products Derived From Vegetable Oil"),
        Classification("10491", "Production Of Animal Oils And Fats"),
        Classification(
            "10499", "Production Of Other Products Derived From Vegetable Oil Which Are Not Classified Elsewhere"
        ),
        Classification("105", "Dairy Production"),
        Classification("1050", "Dairy Production"),
        Classification(
            "10501", "Production Of Fresh Milk, Pasteurized Milk, Sterilized Milk, Homogenized And/Or Uht Milk"
        ),
        Classification("10502", "Production Of Condensed Milk Or Powdered Milk"),
        Classification("10503", "Production Of Ice Cream And Sweet Ice Cream"),
        Classification("10504", "Yogurt And Curd Production"),
        Classification("10505", "Butter Production"),
        Classification("10509", "Production Of Other Dairy Products"),
        Classification(
            "106", "Production Of Products Obtained From Milling And Milling Of Grains Starch And Starch Products"
        ),
        Classification("1061", "Production Of Products Obtained From Milling And Milling Of Grains"),
        Classification("10611", "Rice Milling"),
        Classification("10612", "Production Of Starch From Rice"),
        Classification("10613", "Production Of Products Obtained From Milling And Milling Of Wheat"),
        Classification("10614", "Production Of Products Obtained From Milling And Milling Of Corn"),
        Classification("10615", "Manufacture Of Other Grain Milling And Milling Products"),
        Classification("10616", "Production Of Ready-Mixed Flours For Baking And Other Food Preparation"),
        Classification("10617", "Grain Juice Production"),
        Classification("10619", "Production Of Other Products Obtained From Milling - Milling Grains"),
        Classification("1062", "Starch Production And Starch Products"),
        Classification("10621", "Production Of Cassava Chips And Pellets"),
        Classification("10622", "Production Of Starches From Cassava"),
        Classification("10623", "Production Of Starches From Corn, Grains And Other Vegetables (Except Cassava)"),
        Classification("10629", "Manufacture Of Other Starch Products"),
        Classification("107", "Production Of Other Food Products"),
        Classification("1071", "Production Of Baked Goods"),
        Classification("10711", "Production Of Bread, Cakes And Pastries"),
        Classification("10712", "Production Of Biscuits And Similar Biscuits"),
        Classification("10713", "Baked Thai Dessert Production"),
        Classification("1072", "Sugar Production"),
        Classification("10721", "Production Of Raw Sugar From Sugar Cane"),
        Classification("10722", "Production Of White Sugar And Refined Sugar"),
        Classification("10723", "Production Of Sugar From Plants (Except Sugar Cane)"),
        Classification("1073", "Production Of Cocoa, Chocolate, Confectionery And Sugar Confectionery"),
        Classification("10731", "Cocoa Production And Cocoa Products"),
        Classification("10732", "Production Of Chocolate And Chocolate Confectionery"),
        Classification("10733", "Chewing Gum Production"),
        Classification(
            "10734", "Preservation Of Fruit, Hard Fruits, Fruit Peels And Other Parts Of Plants By Using Sugar."
        ),
        Classification("10739", "Production Of Confectionery And Other Confectionery Made Of Sugar"),
        Classification("1074", "Macaroni Production Noodles And Similar Starchy Food Products"),
        Classification("10741", "Pasta Production"),
        Classification("10742", "Production Of Noodles, Noodles, Vermicelli"),
        Classification("10743", "Production Of Instant And Semi-Finished Starchy Food Products"),
        Classification("10749", "Manufacture Of Other Similar Starchy Food Products"),
        Classification("1075", "Ready-To-Eat Food Production"),
        Classification("10751", "Frozen Food Production"),
        Classification("10752", "Production Of Ready-To-Eat Food In Sealed Containers By Vacuum Method"),
        Classification("1076", "Production Of Coffee, Tea And Herbal Powders For Beverages"),
        Classification("10761", "Coffee Production"),
        Classification("10762", "Tea Production"),
        Classification("10769", "Production Of Herbal Powders For Brewing Into Beverages"),
        Classification("1077", "Production Of Tableware And Cooking Utensils"),
        Classification("10771", "Production Of Ready-Made Spices And Curries"),
        Classification("10772", "Production Of Table Sauces And Condiments"),
        Classification("10773", "Soy Sauce Production"),
        Classification("10774", "Msg Production"),
        Classification("10775", "Edible Salt Production"),
        Classification("10779", "Production Of Other Cooking Utensils"),
        Classification("1079", "Production Of Other Food Products Which Are Not Classified Elsewhere"),
        Classification("10791", "Production Of Snacks/Crunchy Snacks"),
        Classification("10792", "Production Of Thai Desserts And Local Desserts (Except Pastries)"),
        Classification("10793", "Production Of Soups And Specialty Foods"),
        Classification("10794", "Production Of Ready-To-Cook And Perishable Foodstuffs"),
        Classification("10795", "Production Of Ice For Consumption"),
        Classification("10796", "Egg Production"),
        Classification("10799", "Production Of Other Food Products Which Are Not Classified Elsewhere"),
        Classification("108", "Finished Animal Feed Production"),
        Classification("1080", "Finished Animal Feed Production"),
        Classification("10801", "Pet Food Production"),
        Classification("10802", "Production Of Ready Meals For Livestock"),
        Classification("11", "Beverage Production"),
        Classification("110", "Beverage Production"),
        Classification("1101", "Brewing, Distilling And Blending Spirits"),
        Classification("11011", "Distilled Spirits Production"),
        Classification("11012", "Mixed Liquor Production"),
        Classification("1102", "Winemaking"),
        Classification("11021", "Grape Wine Production"),
        Classification("11022", "Fruit Wine Production (Except Grapes)"),
        Classification("11029", "Other Winemaking"),
        Classification("1103", "Malt Production And Malted Spirits"),
        Classification("11030", "Malt Production And Malted Spirits"),
        Classification("1104", "Production Of Non-Alcoholic Beverages Mineral Water And Other Types Of Bottled Water"),
        Classification("11041", "Production Of Pure Drinking Water And Bottled Mineral Water"),
        Classification("11042", "Soft Drink And Soda Production"),
        Classification("11043", "Production Of Ready-To-Drink Coffee, Tea And Herbal Teas"),
        Classification("11044", "Energy Drink Production Including Sports Drinks"),
        Classification("11049", "Production Of Other Beverages Non-Alcoholic"),
        Classification("12", "Production Of Tobacco Products"),
        Classification("120", "Production Of Tobacco Products"),
        Classification("1200", "Production Of Tobacco Products"),
        Classification("12001", "Separating The Stems And Drying Tobacco Leaves"),
        Classification("12002", "Cigarette And Cigar Production"),
        Classification(
            "12009", "Manufacture Of Tobacco Products And Other Tobacco Substitutes (Except Cigarettes And Cigars)"
        ),
        Classification("13", "Textile Production"),
        Classification("131", "Spinning, Weaving And Finishing Of Textiles"),
        Classification("1311", "Preparation And Spinning Of Textile Fibers"),
        Classification("13111", "Textile Fiber Preparation"),
        Classification("13112", "Spinning From Natural Fibers"),
        Classification("13113", "Spinning Yarn From Artificial Fibers"),
        Classification("1312", "Weaving"),
        Classification("13121", "Weaving From Natural Fibers"),
        Classification("13122", "Weaving From Artificial Fibers"),
        Classification("13129", "Weaving From Other Fibers"),
        Classification("1313", "Finishing Of Textiles"),
        Classification("13131", "Degreasing And Dirt Removal, Bleaching And Dyeing."),
        Classification("13132", "Silk Screen Printing"),
        Classification("13139", "Finishing Textiles By Other Methods"),
        Classification("139", "Production Of Other Types Of Textiles"),
        Classification("1391", "Production Of Knitted And Crocheted Fabrics"),
        Classification("13910", "Production Of Knitted And Crocheted Fabrics"),
        Classification("1392", "Ready-Made Textile Production (Except Costumes)"),
        Classification("13921", "Bedding Production Tableware, Bathroom And Kitchen Linens"),
        Classification("13922", "Manufacture Of Products From Canvas And Similar Fabrics"),
        Classification("13929", "Manufacture Of Other Finished Textiles (Except Costumes)"),
        Classification("1393", "Manufacture Of Carpets And Textile Floor Coverings"),
        Classification("13930", "Manufacture Of Carpets And Textile Floor Coverings"),
        Classification("1394", "Manufacture Of Ropes, Twine, Nets, Nets And Nets"),
        Classification("13940", "Manufacture Of Ropes, Twine, Nets, Nets And Nets"),
        Classification("1399", "Production Of Other Types Of Textiles Which Are Not Classified Elsewhere"),
        Classification("13991", "Non-Woven Fabric Production"),
        Classification("13992", "Manufacturing Of Industrial Textiles"),
        Classification("13999", "Production Of Other Types Of Textiles Which Are Not Classified Elsewhere"),
        Classification("14", "Apparel Production"),
        Classification("141", "Apparel Production (Except Fur Clothing)"),
        Classification("1411", "Apparel Production (Except The Tailor Shop)"),
        Classification("14111", "Manufacture Of Apparel For Industrial, Professional, Students And Students"),
        Classification("14112", "Outerwear Production"),
        Classification("14113", "Underwear Production"),
        Classification("14114", "Manufacture Of Baby Clothes"),
        Classification("14115", "Sports Apparel Production"),
        Classification("14116", "Production Of Garments From Leather"),
        Classification("1412", "Tailor Shop"),
        Classification("14120", "Tailor Shop"),
        Classification("1413", "Manufacturing Of Costume Accessories"),
        Classification("14131", "Manufacturing Of Hats And Headgear"),
        Classification("14139", "Manufacture Of Other Costume Accessories"),
        Classification("142", "Production Of Fur Articles"),
        Classification("1420", "Production Of Fur Articles"),
        Classification("14200", "Production Of Fur Articles"),
        Classification("143", "Manufacture Of Knitted And Crocheted Apparel"),
        Classification("1430", "Manufacture Of Knitted And Crocheted Apparel"),
        Classification("14301", "Manufacture Of Knitted And Crocheted Apparel"),
        Classification("14302", "Manufacture Of Socks, Tights, Tights Made By Knitting And Crocheting."),
        Classification("15", "Manufacture Of Leather And Related Products"),
        Classification(
            "151",
            "Tanning And Dressing Of Leather Manufacture Of Luggage, Handbags, Saddles And Harnesses Fur Dressing And Dyeing",
        ),
        Classification("1511", "Tanning And Dressing Of Leather Fur Dressing And Dyeing"),
        Classification("15110", "Tanning And Dressing Of Leather Fur Dressing And Dyeing"),
        Classification("1512", "Manufacture Of Luggage, Handbags And The Like Saddles And Harnesses"),
        Classification("15121", "Manufacture Of Luggage, Handbags And The Like"),
        Classification("15122", "Manufacture Of Animal Harnesses And Animal Toys"),
        Classification("15129", "Production Of Other Things Made Of Tanned Or Pressed Leather"),
        Classification("152", "Shoe Production"),
        Classification("1520", "Shoe Production"),
        Classification("15201", "Leather Shoes Production"),
        Classification("15202", "Rubber Shoe Production"),
        Classification("15203", "Wooden Shoe Production"),
        Classification("15204", "Production Of Sports Shoes"),
        Classification("15209", "Other Shoe Production"),
        Classification(
            "16",
            "Manufacture Of Wood And Products From Wood And Cork (Except Furniture) Manufacture Of Articles Of Straw And Other Plaiting Materials",
        ),
        Classification("161", "Sawing And Planing"),
        Classification("1610", "Sawing And Planing"),
        Classification("16101", "Sawing Wood"),
        Classification("16102", "Baking And Pressing Of Wood Solution"),
        Classification("162", "Manufacture Of Products From Wood, Cork, Straw And Plaiting Materials"),
        Classification("1621", "Manufacture Of Thin Boards And Similar Boards"),
        Classification("16210", "Manufacture Of Thin Boards And Similar Boards"),
        Classification("1622", "Manufacture Of Wooden Products Used In The Construction And Assembly Of Buildings"),
        Classification("16220", "Manufacture Of Wooden Products Used In The Construction And Assembly Of Buildings"),
        Classification("1623", "Production Of Wooden Containers"),
        Classification("16230", "Production Of Wooden Containers"),
        Classification(
            "1629",
            "Manufacture Of Other Products Of Wood; Manufacture Of Articles Of Cork, Straw And Plaiting Materials",
        ),
        Classification("16291", "Manufacture Of Home Appliances Made Of Wood And Cork"),
        Classification("16292", "Manufacture Of Straw Products And Plaiting Materials"),
        Classification(
            "16299", "Production Of Other Products Made Of Wood And Cork Which Are Not Classified Elsewhere"
        ),
        Classification("17", "Production Of Paper And Paper Products"),
        Classification("170", "Production Of Paper And Paper Products"),
        Classification("1701", "Pulp, Paper And Cardboard Production"),
        Classification("17011", "Pulp Production"),
        Classification("17012", "Paper And Cardboard Production"),
        Classification(
            "1702",
            "Production Of Corrugated Paper And Corrugated Cardboard And The Manufacture Of Packaging Made Of Paper And Cardboard.",
        ),
        Classification(
            "17020",
            "Production Of Corrugated Paper And Corrugated Cardboard And The Manufacture Of Packaging Made Of Paper And Cardboard.",
        ),
        Classification("1709", "Production Of Other Products Made Of Paper And Cardboard"),
        Classification("17091", "Manufacture Of Paper Products For Household And Hygiene Purposes"),
        Classification("17092", "Production Of Stationery Equipment From Paper"),
        Classification(
            "17099", "Production Of Other Products Made Of Paper And Cardboard Which Are Not Classified Elsewhere"
        ),
        Classification("18", "Printing And Reproducing Media"),
        Classification("181", "Printing And Printing-Related Service Activities"),
        Classification("1811", "Typing"),
        Classification("18111", "Printing Of Newspapers, Periodicals And Magazines"),
        Classification("18112", "Label Printing"),
        Classification("18119", "Other Printing"),
        Classification("1812", "Service Activities Related To Printing"),
        Classification("18121", "Service Before Printing"),
        Classification("18122", "Other Services Related To Printing"),
        Classification("182", "Reproduction Of Storage Media"),
        Classification("1820", "Reproduction Of Storage Media"),
        Classification("18200", "Reproduction Of Storage Media"),
        Classification("19", "Production Of Coke And Petroleum Refining Products"),
        Classification("191", "Coke Production"),
        Classification("1910", "Coke Production"),
        Classification("19100", "Coke Production"),
        Classification("192", "Production Of Petroleum Refining Products"),
        Classification("1920", "Production Of Petroleum Refining Products"),
        Classification("19201", "Production Of Products From Petroleum Refineries"),
        Classification("19202", "Biofuel Production"),
        Classification("19209", "Production Of Other Products Obtained From Petroleum Refining"),
        Classification("20", "Manufacturing Of Chemicals And Chemical Products"),
        Classification(
            "201",
            "Basic Chemical Production Chemical Fertilizers And Nitrogen Compounds Primary Plastics And Synthetic Rubber",
        ),
        Classification("2011", "Basic Chemical Production"),
        Classification("20111", "Production Of Industrial Gases"),
        Classification("20112", "Production Of Dyes And Pigments"),
        Classification("20113", "Production Of Other Basic Inorganic Chemicals"),
        Classification("20114", "Ethanol And Ester Production"),
        Classification("20115", "Production Of Other Basic Organic Chemicals"),
        Classification("2012", "Production Of Chemical Fertilizers And Nitrogen Compounds"),
        Classification("20121", "Chemical Fertilizer Production"),
        Classification("20122", "Production Of Nitrogen Compounds"),
        Classification("2013", "Primary Production Of Plastics And Synthetic Rubber"),
        Classification("20131", "Production Of Plastic Pellets And Primary Plastics"),
        Classification("20132", "Primary Synthetic Rubber Production"),
        Classification("202", "Manufacturing Of Other Chemical Products"),
        Classification("2021", "Manufacture Of Pesticides And Other Agricultural Chemical Products"),
        Classification("20210", "Manufacture Of Pesticides And Other Agricultural Chemical Products"),
        Classification("2022", "Manufacture Of Paints, Varnishes And Similar Coatings, Printing Inks And Varnishes"),
        Classification("20221", "Manufacture Of Paints, Varnishes And Similar Coatings And Wood Oil"),
        Classification("20222", "Printing Ink Production"),
        Classification(
            "2023",
            "Soap And Detergent Production Chemical Products Used For Cleaning And Polishing Perfume And Make-Up",
        ),
        Classification("20231", "Soap And Detergent Production Chemical Products Used For Cleaning And Polishing"),
        Classification("20232", "Manufacture Of Perfumes, Cosmetics And Make-Up Products"),
        Classification("2029", "Manufacturing Of Other Chemical Products Which Are Not Classified Elsewhere"),
        Classification("20291", "Production Of Explosives"),
        Classification("20292", "Manufacture Of Glue And Gelatin"),
        Classification("20293", "Essential Oil Production (Essential Oil)"),
        Classification("20294", "Production Of Photographic Chemical Products"),
        Classification("20299", "Manufacturing Of Other Chemical Products Which Are Not Classified Elsewhere"),
        Classification("203", "Artificial Fiber Production"),
        Classification("2030", "Artificial Fiber Production"),
        Classification("20300", "Artificial Fiber Production"),
        Classification(
            "21",
            "Pharmaceutical Production Chemicals Used To Treat Disease And Products From Plants And Animals Used To Treat Diseases",
        ),
        Classification(
            "210",
            "Pharmaceutical Production Chemicals Used To Treat Disease And Products From Plants And Animals Used To Treat Diseases",
        ),
        Classification(
            "2100",
            "Pharmaceutical Production Chemicals Used To Treat Disease And Products From Plants And Animals Used To Treat Diseases",
        ),
        Classification("21001", "Manufacture Of Pharmaceuticals And Medicinal Chemicals"),
        Classification("21002", "Production Of Medicinal Plant And Animal Products"),
        Classification("22", "Manufacture Of Rubber And Plastic Products"),
        Classification("221", "Production Of Rubber Products"),
        Classification("2211", "Production Of Tires And Inner Tubes Tire Retreading And Tire Repair"),
        Classification("22111", "Production Of Tires And Inner Tubes"),
        Classification("22112", "Tire Retreading And Tire Repair"),
        Classification("2219", "Manufacture Of Other Rubber Products"),
        Classification("22191", "Manufacture Of Rubber Sheets, Rods, Lumps And Shapes"),
        Classification("22192", "Latex Production"),
        Classification("22193", "Manufacture Of Rubber Sanitary Or Pharmaceutical Articles"),
        Classification("22199", "Manufacture Of Other Rubber Products Which Are Not Classified Elsewhere"),
        Classification("222", "Plastic Product Manufacturing"),
        Classification("2221", "Manufacture Of Plastic Building/Construction Products"),
        Classification("22210", "Manufacture Of Plastic Building/Construction Products"),
        Classification("2222", "Plastic Packaging Production"),
        Classification("22220", "Plastic Packaging Production"),
        Classification("2223", "Production Of Semi-Finished And Finished Plastic Products"),
        Classification("22230", "Production Of Semi-Finished And Finished Plastic Products"),
        Classification("2229", "Manufacture Of Other Plastic Products"),
        Classification("22291", "Manufacture Of Plastic Tableware, Kitchen And Bathroom Utensils"),
        Classification("22292", "Production Of Fiberglass Products"),
        Classification("22299", "Manufacture Of Other Plastic Products Which Are Not Classified Elsewhere"),
        Classification("23", "Production Of Other Products Made Of Non-Metallic Minerals"),
        Classification("231", "Manufacture Of Glass And Glass Products"),
        Classification("2310", "Manufacture Of Glass And Glass Products"),
        Classification("23101", "Production Of Glass/Glass Plates"),
        Classification("23102", "Manufacture Of Glass Containers And Tableware"),
        Classification("23103", "Fiberglass Production"),
        Classification("23109", "Manufacture Of Other Glass Products"),
        Classification(
            "239", "Production Of Other Products Made Of Non-Metallic Minerals Which Are Not Classified Elsewhere"
        ),
        Classification("1848", "Manufacturing Of Refractory Products"),
        Classification("23910", "Manufacturing Of Refractory Products"),
        Classification("1849", "Production Of Building Materials Made Of Clay"),
        Classification("23921", "Brick Production"),
        Classification("23922", "Production Of Floor Tiles And Ceramic Plates"),
        Classification("23923", "Ceramic Sanitary Ware Production"),
        Classification("23929", "Production Of Other Building Materials Made Of Clay"),
        Classification("1850", "Manufacture Of Porcelain Ceramic Products And Other Ceramic Products"),
        Classification("23931", "Manufacture Of Ceramic Tableware Products"),
        Classification("23932", "Manufacture Of Sculpture And Decorative Products Made Of Ceramics"),
        Classification(
            "23933", "Manufacturing Of Electrical Insulators And Fixtures Which Is Used As An Insulator Made Of Ceramic"
        ),
        Classification(
            "23939",
            "Manufacture Of Porcelain Ceramic Products And Other Ceramic Products Which Are Not Classified Elsewhere",
        ),
        Classification("1851", "Production Of Cement, Lime (Lime) And Plaster"),
        Classification("23941", "Cement Production"),
        Classification("23942", "Production Of Lime (Lime) And Plaster"),
        Classification("2395", "Manufacture Of Concrete, Cement And Plaster Products"),
        Classification("23951", "Production Of Concrete Products Used In Construction"),
        Classification("23952", "Production Of Plaster Products Used In Construction"),
        Classification("23953", "Ready-Mixed Concrete Production"),
        Classification("23954", "Production Of Fiber Cement Products"),
        Classification("23959", "Production Of Other Products Made Of Concrete, Cement And Plaster"),
        Classification("1853", "Cutting, Forming And Finishing Stone"),
        Classification("23961", "Production Of Stone Products Used In Construction"),
        Classification("23969", "Manufacture Of Other Products Made Of Stone"),
        Classification(
            "2399", "Production Of Other Products Made Of Non-Metallic Minerals Which Are Not Classified Elsewhere"
        ),
        Classification("23991", "Production Of Abrasive Products"),
        Classification("23992", "Production Of Mineral Insulating Materials"),
        Classification(
            "23999", "Production Of Other Products Made Of Non-Metallic Minerals Which Are Not Classified Elsewhere"
        ),
        Classification("24", "Basic Metal Production"),
        Classification("241", "Basic Iron And Steel Production"),
        Classification("2410", "Basic Iron And Steel Production"),
        Classification("24101", "Primary And Intermediate Iron And Steel Production"),
        Classification("24102", "Iron And Steel Sheet Production"),
        Classification("24103", "Manufacture Of Tubes, Pipes, Hollow Profiles And Related Fixtures Made Of Steel"),
        Classification("24109", "Other Basic Iron And Steel Production"),
        Classification("242", "Precious Metal And Other Metal Production Basic Non-Ferrous"),
        Classification("1877", "Precious Metal And Other Metal Production Basic Non-Ferrous"),
        Classification("24201", "Basic Precious Metal Production"),
        Classification("24202", "Production Of Aluminum And Basic Aluminum Products"),
        Classification("24203", "Basic Manufacture Of Zinc, Lead And Tin And Their Products"),
        Classification("24204", "Production Of Copper And Basic Copper Products"),
        Classification("24209", "Other Metal Production Basic Non-Ferrous Which Are Not Classified Elsewhere"),
        Classification("243", "Metal Casting"),
        Classification("1888", "Casting Iron And Steel"),
        Classification("24311", "Steel Casting"),
        Classification("24312", "Steel Casting"),
        Classification("1889", "Casting Of Non-Ferrous Metals And Steels"),
        Classification("24320", "Casting Of Non-Ferrous Metals And Steels"),
        Classification("25", "Manufacture Of Fabricated Metal Products (Except Machinery And Equipment)"),
        Classification(
            "251", "Manufacture Of Structural Metal Products Large Water Tank Water Storage And Steam Generator"
        ),
        Classification("1968", "Manufacture Of Structural Metal Products"),
        Classification("25111", "Manufacture Of Metal Structures For Use In Construction"),
        Classification("25112", "Manufacture Of Prefabricated Buildings With Metal As The Main Component"),
        Classification(
            "25113", "Manufacture Of Doors, Windows, Sliding Doors, Fence Gates And Similar Products Of Metal"
        ),
        Classification("1976", "Production Of Other Products With A Metal Structure"),
        Classification("1969", "Production Of Large Water Tanks Water Storage And Metal Containers"),
        Classification("25121", "Manufacture Of Boilers For Central Heating And Heat Spreader"),
        Classification("25122", "Manufacture Of Compressed Gas Or Liquefied Gas Containers Made Of Metal"),
        Classification("25129", "Production Of Large Water Tanks Water Storage And Other Metal Containers"),
        Classification("1970", "Steam Generator Production (Except Boiler For Central Heating)"),
        Classification("25130", "Steam Generator Production (Except Boiler For Central Heating)"),
        Classification("252", "Manufacture Of Weapons And Ammunition"),
        Classification("1977", "Manufacture Of Weapons And Ammunition"),
        Classification("1958", "Production Of Ammunition And Bombs"),
        Classification("25209", "Manufacture Of Heavy Weapons, Firearms And Other Weapons"),
        Classification("259", "Manufacture Of Other Fabricated Metal Products And Metalworking Service Activities"),
        Classification(
            "2048",
            "Manufacture Of Metal Products By Forging, Pressing, Stamping And Metal Roll Forming. Including Powder Metallurgy",
        ),
        Classification(
            "25910",
            "Manufacture Of Metal Products By Forging, Pressing, Stamping And Metal Roll Forming. Including Powder Metallurgy",
        ),
        Classification("2592", "Metal Finishing And Coating Metal Milling"),
        Classification("25921", "Metal Finishing And Coating"),
        Classification("25922", "Metal Milling"),
        Classification("2050", "Production Of Sharp Goods Manual Tools And General Metalworking"),
        Classification("25931", "Production Of Sharp Goods"),
        Classification("25932", "Manufacturing Of Keys And Hinges"),
        Classification("25939", "Manufacturing Of Hand Tools And Other General Metalworking Machines"),
        Classification("2051", "Production Of Tanks, Cans, Large Round Tanks And Similar Containers Made Of Metal"),
        Classification("25941", "Manufacture Of Large Round Barrels And Similar Containers Of Metal"),
        Classification("25949", "Manufacture Of Metal Cans And Other Metal Packaging"),
        Classification("2595", "Manufacture Of Wire, Chains, Springs, Bolts And Screws"),
        Classification("25951", "Manufacture Of Wire, Cable And Wire Articles"),
        Classification("25952", "Manufacture Of Chains, Springs, Bolts And Screws"),
        Classification("2599", "Manufacture Of Other Fabricated Metal Products Which Are Not Classified Elsewhere"),
        Classification("25991", "Manufacture Of Sanitary Ware Made Of Metal"),
        Classification("25992", "Manufacture Of Kitchen Utensils Made Of Metal"),
        Classification("25993", "Manufacture Of Metal Safes And Office Equipment (Except Furniture)"),
        Classification("25999", "Manufacture Of Other Fabricated Metal Products Which Are Not Classified Elsewhere"),
        Classification("26", "Computer Product Manufacturing Electronics And Equipment Used In Optics"),
        Classification("261", "Manufacturing Of Electronic Components And Circuit Boards"),
        Classification("2610", "Manufacturing Of Electronic Components And Circuit Boards"),
        Classification("26101", "Production Of Display Parts"),
        Classification("26102", "Electronic Capacitor And Resistor Manufacturing"),
        Classification("26103", "Electronic Circuit Board Manufacturing"),
        Classification("26104", "Manufacturing Of Semiconductors And Integrated Circuits"),
        Classification("26109", "Manufacturing Of Other Electronic Components"),
        Classification("262", "Computer And Peripheral Manufacturing"),
        Classification("2620", "Computer And Peripheral Manufacturing"),
        Classification("26201", "Computer Manufacturing/Assembling"),
        Classification("26202", "Storage Device Manufacturing"),
        Classification("26203", "Computer Monitor Production"),
        Classification("26209", "Other Peripheral Manufacturing"),
        Classification("263", "Communication Equipment Manufacturing"),
        Classification("2630", "Communication Equipment Manufacturing"),
        Classification("26301", "Wired Telephone And Fax Production"),
        Classification("26302", "Manufacturing Of Wireless Communication Devices"),
        Classification(
            "26303",
            "Manufacture Of Communication Equipment Used For Receiving/Transmitting Radio And Television Signals.",
        ),
        Classification("26309", "Other Communication Equipment Manufacturing"),
        Classification("264", "Manufacture Of Household Electronic Appliances"),
        Classification("2640", "Manufacture Of Household Electronic Appliances"),
        Classification("26401", "Production Of Television Receivers"),
        Classification("26402", "Manufacture Of Radio Receivers, Players, Recordings And Dubbing Of Sound And Images"),
        Classification("26403", "Manufacture Of Microphones, Speakers And Amplifiers"),
        Classification("26409", "Manufacture Of Other Electronic Appliances Household Type"),
        Classification("265", "Manufacture Of Measuring, Testing, Piloting And Control Equipment, Including Watches"),
        Classification("2651", "Manufacturing Of Measuring, Testing, Piloting And Control Equipment"),
        Classification(
            "26511", "Manufacture Of Measuring, Testing, Piloting And Control Equipment (Except For Industrial Use)."
        ),
        Classification(
            "26512", "Manufacturing Of Equipment For Measuring, Testing And Controlling Industrial Processes"
        ),
        Classification("2652", "Watch Manufacturing"),
        Classification("26521", "Watch Manufacturing"),
        Classification("26529", "Production Of Other Products With A Clock Machine"),
        Classification("266", "Radiation Machine Manufacturing Medical Electrical And Physical Therapy"),
        Classification("2660", "Radiation Machine Manufacturing Medical Electrical And Physical Therapy"),
        Classification("26600", "Radiation Machine Manufacturing Medical Electrical And Physical Therapy"),
        Classification("267", "Manufacture Of Optical And Photographic Equipment"),
        Classification("2670", "Manufacture Of Optical And Photographic Equipment"),
        Classification("26701", "Production Of Optical Lenses"),
        Classification("26702", "Manufacture Of Optical Devices (Except Optical Lenses)"),
        Classification("26703", "Production Of Photographic Equipment And Cinematography"),
        Classification("268", "Magnetic And Optical Media Production"),
        Classification("2680", "Magnetic And Optical Media Production"),
        Classification("26800", "Magnetic And Optical Media Production"),
        Classification("27", "Electrical Equipment Manufacturing"),
        Classification(
            "271",
            "Electric Motor Manufacturing Generator Transformer And Electrical Control And Distribution Equipment",
        ),
        Classification(
            "2710",
            "Electric Motor Manufacturing Generator Transformer And Electrical Control And Distribution Equipment",
        ),
        Classification("27101", "Manufacture Of Electric Motors And Generators"),
        Classification("27102", "Transformer Manufacturing"),
        Classification("27103", "Manufacturing Of Electrical Control And Distribution Equipment"),
        Classification("272", "Manufacture Of Batteries And Accumulators"),
        Classification("2720", "Manufacture Of Batteries And Accumulators"),
        Classification("27200", "Manufacture Of Batteries And Accumulators"),
        Classification("273", "Manufacturing Of Wires And Electrical Wiring Equipment"),
        Classification("2731", "Fiber Optic Cable Production"),
        Classification("27310", "Fiber Optic Cable Production"),
        Classification("2732", "Manufacturing Of Other Wires And Cables Kind Used In Electronic And Electrical"),
        Classification("27320", "Manufacturing Of Other Wires And Cables Kind Used In Electronic And Electrical"),
        Classification("2733", "Manufacturing Of Electrical Wiring Devices"),
        Classification("27330", "Manufacturing Of Electrical Wiring Devices"),
        Classification("274", "Manufacturing Of Electrical Equipment For Lighting"),
        Classification("2740", "Manufacturing Of Electrical Equipment For Lighting"),
        Classification("27401", "Production Of Electric Lamps"),
        Classification("27409", "Other Electrical Equipment Manufacturing For Lighting"),
        Classification("275", "Production Of Household Appliances"),
        Classification("2750", "Production Of Household Appliances"),
        Classification("27501", "Production Of Household Electrical Appliances (Except Heated Type)"),
        Classification("27002", "Production Of Heating Household Appliances"),
        Classification("27503", "Manufacture Of Non-Electric Household Appliances For Cooking And Heating"),
        Classification("279", "Other Electrical Equipment Manufacturing"),
        Classification("2790", "Other Electrical Equipment Manufacturing"),
        Classification("27901", "Production Of Uninterruptible Power Supplies"),
        Classification("27902", "Manufacture Of Electrical Equipment For Signaling"),
        Classification("27909", "Other Electrical Equipment Manufacturing Which Are Not Classified Elsewhere"),
        Classification("28", "Machine And Tool Manufacturing Which Are Not Classified Elsewhere"),
        Classification("281", "Manufacturing Of General Purpose Machinery"),
        Classification(
            "2811", "Manufacture Of Engines And Turbines (Except Aircraft, Motor Vehicles And Motorcycle Engines)"
        ),
        Classification(
            "28110", "Manufacture Of Engines And Turbines (Except Aircraft, Motor Vehicles And Motorcycle Engines)"
        ),
        Classification("2812", "Manufacturing Of Fluid Power Control Equipment"),
        Classification("28120", "Manufacturing Of Fluid Power Control Equipment"),
        Classification("2813", "Manufacture Of Pumps, Compressors, Taps And Other Valves"),
        Classification("28131", "Manufacturing Of Other Pumps And Compressors"),
        Classification("28132", "Manufacturing Of Other Taps And Valves"),
        Classification("2814", "Manufacture Of Bearings, Gears And Drive Devices"),
        Classification("28140", "Manufacture Of Bearings, Gears And Drive Devices"),
        Classification("2815", "Manufacture Of Ovens, Furnaces And Furnace Sprayers Or Fuel Injection Machines"),
        Classification("28150", "Manufacture Of Ovens, Furnaces And Furnace Sprayers Or Fuel Injection Machines"),
        Classification("2816", "Manufacture Of Lifting And Moving Equipment"),
        Classification("28160", "Manufacture Of Lifting And Moving Equipment"),
        Classification("2817", "Manufacturing Of Machinery And Office Equipment (Except Computers And Peripherals)"),
        Classification("28170", "Manufacturing Of Machinery And Office Equipment (Except Computers And Peripherals)"),
        Classification("2818", "Manufacturing Of Power-Driven Hand-Operated Tools"),
        Classification("28180", "Manufacturing Of Power-Driven Hand-Operated Tools"),
        Classification("2819", "Other Machinery Manufacturing General Use"),
        Classification("28191", "Refrigeration Production"),
        Classification("28199", "Other Machinery Manufacturing General Use Which Are Not Classified Elsewhere"),
        Classification("282", "Manufacturing Of Machines Used For Specific Tasks"),
        Classification("2821", "Manufacture Of Machinery Used In Agriculture And Forestry"),
        Classification("28211", "Manufacture Of Agricultural Tractors"),
        Classification("28219", "Other Machinery Manufacturing Used In Agriculture And Forestry"),
        Classification("2822", "Manufacture Of Metal Forming Machines And Machine Tools"),
        Classification("28221", "Manufacturing Of Machines For Metal Forming"),
        Classification("28229", "Other Machine Tool Manufacturing"),
        Classification("2823", "Manufacture Of Machinery Used In Metalworking"),
        Classification("28230", "Manufacture Of Machinery Used In Metalworking"),
        Classification("2824", "Manufacture Of Machinery Used In Mining, Quarrying And Construction"),
        Classification("28240", "Manufacture Of Machinery Used In Mining, Quarrying And Construction"),
        Classification("2825", "Manufacture Of Machinery For The Production Of Food, Beverages And Tobacco"),
        Classification("28250", "Manufacture Of Machinery For The Production Of Food, Beverages And Tobacco"),
        Classification(
            "2826", "Manufacture Of Machinery Used In The Manufacture Of Textiles, Clothing, Apparel And Leather"
        ),
        Classification("28261", "Manufacture Of Machinery For Preparing, Spinning, Weaving And Knitting Textiles"),
        Classification("28269", "Other Machinery Manufacturing Used In Textile Production Costume And Leather"),
        Classification("2829", "Manufacture Of Machinery Used For Other Specific Tasks"),
        Classification("28291", "Manufacture Of Machinery Used In The Production Of Paper And Cardboard"),
        Classification("28292", "Manufacture Of Machinery Used In The Production Of Plastics And Rubber"),
        Classification("28299", "Manufacturing Of Machines For Other Specific Uses Which Are Not Classified Elsewhere"),
        Classification("29", "Manufacture Of Motor Vehicles, Trailers And Semi-Trailers"),
        Classification("291", "Automotive Manufacturing"),
        Classification("2910", "Automotive Manufacturing"),
        Classification("29101", "Manufacture Of Engines For Automobiles"),
        Classification("29102", "Private Car Production"),
        Classification("29103", "Production Of A 1-Ton Pickup Truck"),
        Classification("29104", "Other Automotive Manufacturing Used For Passenger"),
        Classification("29109", "Other Automotive Manufacturing Which Are Not Classified Elsewhere"),
        Classification("292", "Automotive Body Manufacturing Manufacturing Of Trailers And Semi-Trailers"),
        Classification("2920", "Automotive Body Manufacturing Manufacturing Of Trailers And Semi-Trailers"),
        Classification("29201", "Automotive Body Manufacturing"),
        Classification("29202", "Manufacturing Of Trailers And Semi-Trailers"),
        Classification("29203", "Container Manufacturing"),
        Classification("293", "Manufacture Of Parts And Accessories For Motor Vehicles"),
        Classification("2930", "Manufacture Of Parts And Accessories For Motor Vehicles"),
        Classification("29301", "Manufacturing Of Automotive Seats"),
        Classification("29302", "Manufacturing Of Electrical Equipment For Motor Vehicles"),
        Classification("29309", "Manufacture Of Other Parts And Accessories For Automotive"),
        Classification("30", "Manufacturing Of Other Transport Equipment"),
        Classification("301", "Shipbuilding"),
        Classification("3011", "Building Large Ships And Floating Structures"),
        Classification("30110", "Building Large Ships And Floating Structures"),
        Classification("3012", "Shipbuilding For Pleasure And Sport"),
        Classification("30120", "Shipbuilding For Pleasure And Sport"),
        Classification("302", "Manufacture Of Locomotives And Containers For Rail And Rail Transport"),
        Classification("3020", "Manufacture Of Locomotives And Containers For Rail And Rail Transport"),
        Classification("30200", "Manufacture Of Locomotives And Containers For Rail And Rail Transport"),
        Classification("303", "Manufacture Of Aircraft, Spacecraft And Related Machinery"),
        Classification("3030", "Manufacture Of Aircraft, Spacecraft And Related Machinery"),
        Classification("30300", "Manufacture Of Aircraft, Spacecraft And Related Machinery"),
        Classification("304", "The Manufacture Of Military Vehicles For Use In Combat"),
        Classification("3040", "The Manufacture Of Military Vehicles For Use In Combat"),
        Classification("30400", "The Manufacture Of Military Vehicles For Use In Combat"),
        Classification("309", "Production Of Transport Equipment Which Are Not Classified Elsewhere"),
        Classification("3091", "Motorcycle Production"),
        Classification("30911", "Motorcycle Production"),
        Classification("30912", "Engine Production Motorcycle Parts And Accessories"),
        Classification("3092", "Production Of Bicycles And Vehicles For The Disabled"),
        Classification("30921", "Bicycle Production"),
        Classification("30922", "Production Of Vehicles For The Disabled"),
        Classification("3099", "Manufacturing Of Other Transport Equipment Which Are Not Classified Elsewhere"),
        Classification("30990", "Manufacturing Of Other Transport Equipment Which Are Not Classified Elsewhere"),
        Classification("31", "Furniture Production"),
        Classification("310", "Furniture Production"),
        Classification("3100", "Furniture Production"),
        Classification("31001", "Wooden Furniture Production"),
        Classification("31002", "Metal Furniture Production"),
        Classification("31003", "Manufacture Of Mattress Bases And Mattresses"),
        Classification("31009", "Other Furniture Production"),
        Classification("32", "Production Of Other Products"),
        Classification("321", "Jewelery Manufacturing Jewelery And Related Things"),
        Classification("3211", "Manufacture Of Genuine Gemstone Jewelry And Related Articles"),
        Classification("32111", "Manufacture Of Jewelery And Precious Metals"),
        Classification("32112", "Manufacture Of Articles Of Jewelery And Precious Metals"),
        Classification("32113", "Grinding And Polishing Of Gemstones"),
        Classification("3212", "Manufacture Of Rhinestone Jewelry And Related Articles"),
        Classification("32120", "Manufacture Of Rhinestone Jewelry And Related Articles"),
        Classification("322", "Musical Instrument Production"),
        Classification("3220", "Musical Instrument Production"),
        Classification("32201", "Thai Musical Instrument Production"),
        Classification("32209", "Production Of Other Musical Instruments"),
        Classification("323", "Sporting Goods Production"),
        Classification("3230", "Sporting Goods Production"),
        Classification("32301", "Production Of Sports Balls"),
        Classification("32302", "Surfboard Manufacturing And Water Sports Equipment"),
        Classification("32303", "Manufacture Of Sport Fishing Equipment"),
        Classification("32309", "Manufacture Of Other Sporting Goods"),
        Classification("324", "Game And Toy Production"),
        Classification("3240", "Game And Toy Production"),
        Classification("32401", "Production Of Toys With Wheels"),
        Classification("32402", "Doll Production"),
        Classification("32409", "Manufacture Of Games And Other Toys"),
        Classification("325", "Manufacture Of Medical And Dental Instruments And Equipment"),
        Classification("3250", "Manufacture Of Medical And Dental Instruments And Equipment"),
        Classification("32501", "Manufacturing Of Medical Instruments And Equipment"),
        Classification("32502", "Manufacture Of Dental Instruments And Equipment"),
        Classification("329", "Production Of Other Products Which Are Not Classified Elsewhere"),
        Classification("3290", "Production Of Other Products Which Are Not Classified Elsewhere"),
        Classification("32901", "Production Of Brooms And Brushes"),
        Classification("32902", "Production Of Stationery"),
        Classification("32903", "Production Of Safety Equipment"),
        Classification("32904", "Production Of Artificial Flowers And Plants"),
        Classification("32909", "Production Of Other Products Which Are Not Classified Elsewhere"),
        Classification("33", "Repair And Installation Of Machinery And Equipment"),
        Classification("331", "Repair Of Fabricated Metal Products, Machines And Equipment"),
        Classification("3311", "Repair Of Fabricated Metal Products"),
        Classification("33110", "Repair Of Fabricated Metal Products"),
        Classification("3312", "Machine Repair"),
        Classification("33121", "General Maintenance Of Machinery"),
        Classification("33122", "Repairing Machines For Specific Applications"),
        Classification("3313", "Repair Of Electronic And Optical Devices"),
        Classification("33131", "Repair And Maintenance Of Equipment For Measurement, Testing, Piloting And Control."),
        Classification("33132", "Repair And Maintenance Of Irradiators Medical Electrical And Physical Therapy"),
        Classification("33133", "Repair And Maintenance Of Optical And Photographic Equipment"),
        Classification("3314", "Electrical Equipment Repair"),
        Classification(
            "33141",
            "Electric Motor Repair Generator Transformer And Equipment For Supplying And Controlling Electricity",
        ),
        Classification("33142", "Repair Of Accumulators And Batteries"),
        Classification("33149", "Repairing Other Electrical Equipment"),
        Classification("3315", "Transport Equipment Repair (Except Motor Vehicles)"),
        Classification("33151", "Boat Repair"),
        Classification("33152", "Aircraft Repair"),
        Classification("33159", "Repair Of Other Transport Equipment (Except Motor Vehicles)"),
        Classification("3319", "Other Equipment Repair"),
        Classification("33190", "Other Equipment Repair"),
        Classification("332", "Installation Of Industrial Machinery And Equipment"),
        Classification("3320", "Installation Of Industrial Machinery And Equipment"),
        Classification("33200", "Installation Of Industrial Machinery And Equipment"),
        Classification("D", "Electricity, Gas, Steam And Air Conditioning"),
        Classification("35", "Electricity, Gas, Steam And Air Conditioning"),
        Classification("351", "Generation, Transmission And Distribution Of Electricity"),
        Classification("3510", "Generation, Transmission And Distribution Of Electricity"),
        Classification("35101", "Power Generation And Transmission"),
        Classification("35102", "Electricity Supply"),
        Classification("352", "Gas Production Supply Of Gas Fuel Through Main Pipes"),
        Classification("3520", "Gas Production Supply Of Gas Fuel Through Main Pipes"),
        Classification("35201", "Gas Production"),
        Classification("35202", "Gas Fuel Supply Through Pipes"),
        Classification("353", "Steam Supply And Air Conditioning System"),
        Classification("3530", "Steam Supply And Air Conditioning System"),
        Classification("35301", "Production Of Non-Consumer Ice"),
        Classification(
            "35302", "Steam Supply And Air Conditioning System (Except For The Production Of Non-Consumed Ice)"
        ),
        Classification("E", "Water Supply, Management And Wastewater Treatment, Waste And Sewage"),
        Classification("36", "Water Storage, Water Supply And Distribution"),
        Classification("360", "Water Storage, Water Supply And Distribution"),
        Classification("3600", "Water Storage, Water Supply And Distribution"),
        Classification("36001", "Water Retention"),
        Classification(
            "36002", "Water Supply And Distribution For Household And Industrial Use Through The Water Supply System."
        ),
        Classification("36003", "Water Supply And Water Supply For Agricultural Use"),
        Classification("36009", "Water Supply And Other Water Supply"),
        Classification("37", "Wastewater Management"),
        Classification("370", "Wastewater Management"),
        Classification("3700", "Wastewater Management"),
        Classification("37000", "Wastewater Management"),
        Classification("38", "Waste Collection Waste Treatment And Disposal Including Reusing Waste"),
        Classification("381", "Waste Collection"),
        Classification("3811", "Non-Hazardous Waste Collection"),
        Classification("38110", "Non-Hazardous Waste Collection"),
        Classification("3812", "Hazardous Waste Collection"),
        Classification("38120", "Hazardous Waste Collection"),
        Classification("382", "Waste Treatment And Disposal"),
        Classification("3821", "Treatment And Disposal Of Non-Hazardous Waste"),
        Classification("38211", "Hygienic Treatment And Disposal Of Non-Hazardous Waste By Landfill"),
        Classification("38212", "Treatment And Disposal Of Non-Hazardous Waste By Incineration"),
        Classification("38213", "Biological Treatment And Disposal Of Non-Hazardous Waste"),
        Classification("38219", "Treatment And Disposal Of Non-Hazardous Waste By Other Means"),
        Classification("3822", "Hazardous Waste Treatment And Disposal"),
        Classification("38221", "Treatment And Disposal Of Radioactive Waste"),
        Classification("38222", "Hazardous Waste Treatment And Disposal (Except Radioactive Waste)"),
        Classification("383", "Reusing Used Materials"),
        Classification("3830", "Reusing Used Materials"),
        Classification("38300", "Reusing Used Materials"),
        Classification("39", "Treatment Activities And Other Waste Management Services"),
        Classification("390", "Treatment Activities And Other Waste Management Services"),
        Classification("3900", "Treatment Activities And Other Waste Management Services"),
        Classification("39000", "Treatment Activities And Other Waste Management Services"),
        Classification("F", "Construction"),
        Classification("41", "Building Construction"),
        Classification("410", "Building Construction"),
        Classification("4100", "Building Construction"),
        Classification("41001", "Construction Of Residential Buildings"),
        Classification("41002", "Construction Of Non-Residential Buildings"),
        Classification("42", "Civil Engineering"),
        Classification("421", "Road And Railway Construction"),
        Classification("4210", "Road And Railway Construction"),
        Classification("42101", "Construction Of Roads, Bridges And Tunnels"),
        Classification("42102", "Construction Of Railways And Subway Cars"),
        Classification("422", "Construction Of Utility Projects"),
        Classification("4220", "Construction Of Utility Projects"),
        Classification("42201", "Construction Of Water, Oil And Gas Utilities"),
        Classification("42202", "Construction Of Utility Projects Related To Electricity And Communications."),
        Classification("429", "Construction Of Other Civil Engineering Projects"),
        Classification("4290", "Construction Of Other Civil Engineering Projects"),
        Classification(
            "42901", "Construction Of Waterways, Ports, Dams And Other Civil Engineering Projects Related To Water"
        ),
        Classification("42909", "Construction Of Other Civil Engineering Projects Which Are Not Classified Elsewhere"),
        Classification("43", "Specialized Construction"),
        Classification("431", "Demolition And Construction Site Preparation"),
        Classification("4311", "Demolition"),
        Classification("43110", "Demolition"),
        Classification("4312", "Construction Site Preparation"),
        Classification("43120", "Construction Site Preparation"),
        Classification("432", "Electrical Installation, Piping And Other Construction Activities"),
        Classification("4321", "Electrical Installation"),
        Classification("43210", "Electrical Installation"),
        Classification("4322", "Plumbing Installation Heating System And Air Conditioning System"),
        Classification("43221", "Installation Of Water Supply And Drainage Systems"),
        Classification("43222", "Heating System Installation"),
        Classification("43223", "Installation Of Air Conditioning And Ventilation Systems"),
        Classification("4329", "Other Construction Installations"),
        Classification("43291", "Insulation Installation"),
        Classification("43299", "Other Construction Installations Which Are Not Classified Elsewhere"),
        Classification("433", "Complete The Decoration Of The Building"),
        Classification("4330", "Complete The Decoration Of The Building"),
        Classification("43301", "Installation Of Building Components And Interior Fittings"),
        Classification("43302", "Floor And Wall Coverings"),
        Classification("43303", "Painting"),
        Classification("43309", "Other Complete Building Decorations"),
        Classification("439", "Other Specific Construction Activities"),
        Classification("4390", "Other Specific Construction Activities"),
        Classification("43901", "Foundation Construction Including Piling"),
        Classification("43909", "Other Specific Construction Activities Which Are Not Classified Elsewhere"),
        Classification("G", "Wholesale And Retail Repair Of Motor Vehicles And Motorcycles"),
        Classification("45", "Wholesale And Retail Repair Of Motor Vehicles And Motorcycles"),
        Classification("451", "Automotive Sales"),
        Classification("4510", "Automotive Sales"),
        Classification(
            "45101", "Sale Of New Motor Vehicles Such As Passenger Cars, Pickup Trucks, Vans And Similar Small Vehicles"
        ),
        Classification("45102", "Sale Of New Vehicles Such As Trucks And Other Heavy Vehicles"),
        Classification(
            "45103", "Sale Of Old Motor Vehicles Such As Passenger Cars, Pickup Trucks, Vans And Similar Small Vehicles"
        ),
        Classification("45104", "Sale Of Old Vehicles Such As Trucks And Other Heavy Vehicles"),
        Classification("452", "Maintenance And Repair Of Vehicles"),
        Classification("4520", "Maintenance And Repair Of Vehicles"),
        Classification("45201", "Maintenance And Repair Of Engine Systems And Automotive Parts"),
        Classification("45202", "Body Repairs, Doors, Windows And The Like"),
        Classification("45203", "General Automotive Maintenance"),
        Classification("453", "Sales Of Automotive Parts And Accessories"),
        Classification("4530", "Sales Of Automotive Parts And Accessories"),
        Classification("45301", "Wholesale Of New Automotive Parts And Accessories"),
        Classification("45302", "Retail Sale Of New Automotive Parts And Accessories"),
        Classification("45303", "Wholesale And Retail Of Old Automotive Parts And Accessories"),
        Classification("454", "Sales, Maintenance And Repair Of Motorcycles Related Parts And Accessories"),
        Classification("4540", "Sales, Maintenance And Repair Of Motorcycles Related Parts And Accessories"),
        Classification("45401", "Motorcycle Sales"),
        Classification("45402", "Wholesale Of New Motorcycle Parts And Accessories."),
        Classification("45403", "Retail Sale Of New Motorcycle Parts And Accessories"),
        Classification("45404", "Wholesale And Retail Of Old Motorcycle Parts And Accessories."),
        Classification("45405", "Maintenance And Repair Of Motorcycles"),
        Classification("46", "Wholesale (Except Motor Vehicles And Motorcycles)"),
        Classification("461", "Wholesale On A Paid Or Contractual Basis"),
        Classification("4610", "Wholesale On A Paid Or Contractual Basis"),
        Classification(
            "46101",
            "Wholesale Of Agricultural Raw Materials And Live Animals By Receiving Compensation Or Under An Employment Contract",
        ),
        Classification("46102", "Wholesale Of Food, Beverages And Tobacco, On A Compensation Or Contract Basis"),
        Classification(
            "46103",
            "Wholesale Of Textiles, Clothing, Shoes, Leather Goods And Household Goods By Receiving Compensation Or Under An Employment Contract",
        ),
        Classification(
            "46104",
            "Wholesale Of Computers And Software Electronics And Telecommunications By Receiving Compensation Or Under An Employment Contract",
        ),
        Classification(
            "46105", "Wholesale Of Industrial Machinery By Receiving Compensation Or Under An Employment Contract"
        ),
        Classification("46106", "Wholesale Of Fuels, Ores And Metals On A Compensation Or Contract Basis"),
        Classification(
            "46107",
            "Wholesale Of Construction Materials, Metal Equipment And Pipe Fittings By Receiving Compensation Or Under An Employment Contract",
        ),
        Classification(
            "46108", "Other Specific Merchandise Sales By Receiving Compensation Or Under An Employment Contract"
        ),
        Classification("46109", "General Wholesale By Receiving Compensation Or Under An Employment Contract"),
        Classification("462", "Wholesale Of Agricultural Raw Materials And Live Animals"),
        Classification("4620", "Wholesale Of Agricultural Raw Materials And Live Animals"),
        Classification("46201", "Wholesale Of Paddy And Other Grains"),
        Classification("46202", "Wholesale Of Vegetable Oils Used In The Production Of Vegetable Oils."),
        Classification("46203", "Wholesale Of Unfinished Tobacco Products"),
        Classification("46204", "Wholesale Of Live Animals"),
        Classification("46205", "Wholesale Of Flowers, Plants And Seeds"),
        Classification("46206", "Wholesale Of Livestock Feed"),
        Classification("46209", "Wholesale Of Other Agricultural Raw Materials"),
        Classification("463", "Wholesale Of Food, Beverages And Tobacco"),
        Classification("4631", "Food Wholesale"),
        Classification("46311", "Wholesale Of Meat And Meat Products"),
        Classification("46312", "Wholesale Of Fish And Aquatic Products"),
        Classification("46313", "Wholesale Of Fruits And Vegetables"),
        Classification("46314", "Wholesale Of Dairy Products"),
        Classification("46315", "Wholesale Of Rice And Products Obtained From Rice Mills"),
        Classification("46316", "Wholesale Of Baked Goods, Eggs, Edible Oils And Fats"),
        Classification("46317", "Wholesale Of Sugar, Chocolate, Confectionery And Sugar Confectionery"),
        Classification("46318", "Wholesale Coffee, Tea, Cocoa"),
        Classification("46319", "Wholesale Of Other Food Products"),
        Classification("4632", "Wholesale Of Beverages And Tobacco"),
        Classification("46321", "Wholesale Of Alcoholic Beverages"),
        Classification("46322", "Wholesale Of Non-Alcoholic Beverages"),
        Classification("46323", "Wholesale Of Tobacco Products"),
        Classification("464", "Household Wholesale"),
        Classification("4641", "Wholesale Of Textiles, Clothing And Shoes"),
        Classification("46411", "Wholesale Of Thread And Fabric"),
        Classification("46412", "Wholesale Of Household Items Made Of Textiles."),
        Classification("46413", "Wholesale Sewing Supplies"),
        Classification("46414", "Wholesale Clothing"),
        Classification("46415", "Wholesale Shoes"),
        Classification("4642", "Wholesale Of Household Electrical And Electronic Appliances"),
        Classification(
            "46421",
            "Wholesale Of Household Electrical And Electronic Appliances (Except Electrical Equipment For Lighting)",
        ),
        Classification("46422", "Wholesale Of Electrical Equipment For Lighting"),
        Classification("4643", "Wholesale Of Cultural And Recreational Products"),
        Classification("46431", "Wholesale Of Books, Newspapers And Stationery"),
        Classification("46432", "Wholesale Of Recorded Audio And Video Media"),
        Classification("46433", "Wholesale Of Sporting Goods"),
        Classification("46434", "Wholesale Of Games And Toys"),
        Classification("46439", "Other Wholesale Culture And Recreation"),
        Classification("4644", "Wholesale Of Pharmaceutical And Medical Products, Perfumery And Make-Up Products"),
        Classification("46441", "Wholesale Of Pharmaceutical And Medical Products"),
        Classification("46442", "Wholesale Of Perfumes"),
        Classification("46443", "Wholesale Of Cosmetics And Make-Up Products"),
        Classification("4649", "Wholesale Of Other Household Items"),
        Classification("46491", "Wholesale Of Photographic Equipment And Optics"),
        Classification("46492", "Wholesale Of Watches Jewelery"),
        Classification("46493", "Wholesale Of Leather Goods And Travel Accessories"),
        Classification("46494", "Wholesale Of Household Furniture"),
        Classification("46495", "Wholesale Of Pottery, Glassware And Kitchenware"),
        Classification("46499", "Wholesale Of Other Household Items Which Are Not Classified Elsewhere"),
        Classification("465", "Wholesale Of Machinery, Equipment And Tools"),
        Classification("4651", "Wholesale Of Computers Peripherals And Software"),
        Classification("46510", "Wholesale Of Computers Peripherals And Software"),
        Classification("4652", "Wholesale Of Electronic And Telecommunication Equipment And Parts"),
        Classification("46521", "Wholesale Of Electronic Equipment And Parts"),
        Classification("46522", "Wholesale Of Telephones And Telecommunication Equipment"),
        Classification("4653", "Wholesale Of Agricultural Machinery, Equipment And Appliances"),
        Classification("46530", "Wholesale Of Agricultural Machinery, Equipment And Appliances"),
        Classification("4659", "Wholesale Of Machinery And Other Equipment"),
        Classification("46591", "Wholesale Of Transport Equipment (Except Motor Vehicles, Motorcycles And Bicycles)"),
        Classification(
            "46592", "Wholesale Of Machinery And Equipment For Civil Engineering, Mining And Construction Works"
        ),
        Classification("46593", "Wholesale Of Industrial Machinery And Equipment"),
        Classification("46594", "Wholesale Of Machinery, Equipment And Office Furniture"),
        Classification("46599", "Wholesale Of Machinery And Other Equipment Which Are Not Classified Elsewhere"),
        Classification("466", "Wholesale Of Other Specific Products"),
        Classification("4661", "Solid Fuel Wholesale Liquid Fuel And Gas Fuel Including Related Products"),
        Classification("46611", "Solid Fuel Wholesale"),
        Classification("46612", "Wholesale Of Liquid Fuels"),
        Classification("46613", "Wholesale Of Gas Fuel"),
        Classification("46614", "Wholesale Of Petroleum Refining Products"),
        Classification("4662", "Wholesale Of Metals And Metal Ores"),
        Classification("46621", "Wholesale Of Iron Ore And Non-Ferrous Metals"),
        Classification("46622", "Wholesale Of Basic Iron, Steel And Non-Ferrous Metals"),
        Classification(
            "4663",
            "Wholesale Of Construction Materials, Metal Products, Equipment And Materials For Piping And Heating Systems.",
        ),
        Classification("46631", "Wholesale Of Bricks, Stone, Cement, Sand And Concrete Products"),
        Classification("46632", "Wholesale Of Wood And Primary Wood Products"),
        Classification("46633", "Wholesale Paint, Varnish And Lacquer"),
        Classification("46634", "Wholesale Of Pipe Fittings And Sanitary Ware"),
        Classification("46639", "Wholesale Of Other Building Materials"),
        Classification(
            "4669", "Wholesale Of Waste And Scrap Materials And Other Products Which Are Not Classified Elsewhere"
        ),
        Classification("46691", "Wholesale Of Industrial Chemicals"),
        Classification("46692", "Wholesale Of Fertilizers And Agricultural Chemicals"),
        Classification("46693", "Wholesale Of Rubber And Primary Plastics"),
        Classification("46694", "Wholesale Of Industrial Packaging"),
        Classification("46695", "Wholesale Of Waste And Recyclable Waste"),
        Classification("46699", "Wholesale Of Other Products Which Are Not Classified Elsewhere"),
        Classification("469", "General Wholesale"),
        Classification("4690", "General Wholesale"),
        Classification("46900", "General Wholesale"),
        Classification("47", "Retail Sale (Except Motor Vehicles And Motorcycles)"),
        Classification("471", "General Merchandise Retailer"),
        Classification("4711", "Retail Stores Of Food, Beverages Or Tobacco Are The Main Products."),
        Classification("47111", "Supermarket"),
        Classification("47112", "Discount Store/Supercenter/Hypermarket"),
        Classification("47113", "Convenience Store/Mini Mart"),
        Classification("47114", "Grocery Store"),
        Classification("4719", "Other General Merchandise Retailers"),
        Classification("47190", "Other General Merchandise Retailers"),
        Classification("472", "Retail Stores Of Food, Beverages And Tobacco"),
        Classification("4721", "Food Retailer"),
        Classification("47211", "Meat And Meat Products Retail Stores"),
        Classification("47212", "Retail Fish And Aquatic Products"),
        Classification("47213", "Fruit And Vegetable Retail Store"),
        Classification("47214", "Rice Retailer"),
        Classification("47215", "Bakery Products Retailer"),
        Classification("47219", "Other Food Retailers"),
        Classification("4722", "Beverage Retailer"),
        Classification("47221", "Alcoholic Beverage Retailers"),
        Classification("47222", "Non-Alcoholic Beverage Retailers"),
        Classification("4723", "Tobacco Products Retailer"),
        Classification("47230", "Tobacco Products Retailer"),
        Classification("473", "Automotive Fuel Retailers"),
        Classification("4730", "Automotive Fuel Retailers"),
        Classification("47300", "Automotive Fuel Retailers"),
        Classification("474", "Information And Telecommunication Equipment Retailers"),
        Classification("4741", "Computer Retail Store Peripherals, Software And Telecommunication Equipment"),
        Classification("47411", "Computer And Peripheral Retailers"),
        Classification("47412", "Video Game Consoles And Software Retailers"),
        Classification("47413", "Telecommunication Equipment Retailers"),
        Classification("4742", "Audio Visual Equipment Retailer"),
        Classification("47420", "Audio Visual Equipment Retailer"),
        Classification("475", "Other Equipment Retailers Household Type"),
        Classification("4751", "Textile Retailer"),
        Classification("47511", "Cloth Retail Store"),
        Classification("47512", "Retail Outlets For Household Goods Made From Fabrics."),
        Classification("47513", "Sewing Supplies Retailer"),
        Classification("4752", "Metal, Paint And Glass Retailers"),
        Classification("47521", "Metal Shop"),
        Classification("47522", "Retailers Of Paint, Varnish And Lacquer"),
        Classification("47523", "Plumbing Equipment And Sanitary Ware Retailers"),
        Classification("47524", "Other Building Materials Retailers"),
        Classification(
            "47525",
            "Retailers Of Various Construction Materials Including Materials And Tools That Can Be Used To Work By Yourself",
        ),
        Classification("4753", "Retail Stores Of Carpets, Floor Coverings, Wall Coverings And Floor Coverings"),
        Classification("47530", "Retail Stores Of Carpets, Floor Coverings, Wall Coverings And Floor Coverings"),
        Classification(
            "4759",
            "Retail Stores Of Electrical Appliances, Furniture, Electrical Equipment For Lighting. And Other Household Items",
        ),
        Classification("47591", "Household Furniture Retailers"),
        Classification("47592", "Retailers Of Pottery, Glassware And Kitchenware"),
        Classification("47593", "Retail Outlets For Lighting Equipment"),
        Classification("47594", "Retail Of Musical Instruments And Related Equipment"),
        Classification("47595", "Household Electrical Appliances Retailers"),
        Classification("47599", "Retail Stores Of Other Household Goods, N.E.C."),
        Classification("476", "Retail Outlets For Cultural And Recreational Products"),
        Classification("4761", "Retailers Of Books, Newspapers And Stationery"),
        Classification("47611", "Retail Stores Of Books, Newspapers, Journals And Magazines"),
        Classification("47612", "Stationery And Office Supplies Retailers"),
        Classification("4762", "Audio And Visual Media Retailers"),
        Classification("47620", "Audio And Visual Media Retailers"),
        Classification("4763", "Sporting Goods Retailer"),
        Classification("47630", "Sporting Goods Retailer"),
        Classification("4764", "Retail Games And Toys"),
        Classification("47640", "Retail Games And Toys"),
        Classification("4769", "Other Retail Stores Culture And Recreation"),
        Classification("47691", "Retail Shop For Thai Handicraft Products And Souvenirs."),
        Classification("47699", "Other Retail Stores Culture And Recreation Which Are Not Classified Elsewhere"),
        Classification("477", "Other Retail Stores"),
        Classification("4771", "Retailers Of Clothing, Shoes And Leather Goods"),
        Classification("47711", "Clothing Retail Store"),
        Classification("47712", "Shoe Retail Store"),
        Classification("47713", "Leather Retail Store"),
        Classification("4772", "Pharmacy And Medical Supplies, Perfumery And Make-Up Stores"),
        Classification("47721", "Pharmacy And Medical Supplies Retail Store"),
        Classification("47722", "Perfume Retailer"),
        Classification("47723", "Cosmetics And Make-Up Shop"),
        Classification("4773", "Other New Merchandise Retailers"),
        Classification("47731", "Retailers Of Watches, Glasses And Photographic Equipment"),
        Classification("47732", "Jewelery Retail Store"),
        Classification("47733", "Retailers Of Flowers, Plants And Related Accessories"),
        Classification("47734", "Pet Retailers And Related Equipment"),
        Classification("47735", "Retailers Of Canned Gas, Charcoal And Other Fuels For Household"),
        Classification("47739", "Other New Merchandise Retailers Which Are Not Classified Elsewhere"),
        Classification("4774", "Used Goods Retail"),
        Classification("47741", "Antique Retail Store"),
        Classification("47742", "Retail Stores Of Used Clothing, Shoes And Leather Goods"),
        Classification("47743", "Used Computer And Telecommunication Equipment Retailers"),
        Classification("47744", "Used Household Appliances And Electronics Retailers"),
        Classification("47745", "Retail Stores For Used Books, Newspapers, Journals And Magazines"),
        Classification("47749", "Retail Stores Of Other Used Goods"),
        Classification("478", "Retailing On Stalls And Markets"),
        Classification("4781", "Retail Sale Of Food, Beverages And Tobacco Products On Stalls And Markets"),
        Classification("47811", "Retailing Of Food In Stalls And Markets"),
        Classification("47812", "Retail Sale Of Beverages In Stalls And Markets"),
        Classification("47813", "Retail Sale Of Tobacco Products On Stalls And Markets"),
        Classification("4782", "Retail Sale Of Textiles, Clothing, Footwear And Leather Goods On Stalls And Markets"),
        Classification("47821", "Retailing Of Textiles On Stalls And Markets"),
        Classification("47822", "Retail Sale Of Clothing, Shoes And Leather Goods On Stalls And Markets"),
        Classification("4789", "Other Retail Sales On Stalls And Markets"),
        Classification("47891", "Retail Sale Of Computers And Telecommunication Equipment On Stalls And Markets"),
        Classification("47892", "Retail Sale Of Household Electrical And Electronic Appliances On Stalls And Markets"),
        Classification("47893", "Retail Sale Of Books, Newspapers, Journals And Magazines On Stalls And Markets"),
        Classification("47894", "Retail Sale Of Audio And Visual Media In Stalls And Markets"),
        Classification(
            "47895",
            "Retail Sale Of Pharmaceutical And Medical Products, Perfumery And Make-Up Products On Stalls And Markets",
        ),
        Classification("47896", "Retail Sale Of Watches, Glasses, Jewelry, Jewelry. On Stalls And Markets"),
        Classification("47897", "Retail Sale Of Flowers, Plants, Pets And Pet Food On Stalls And Markets"),
        Classification("47899", "Other Retail Sales Which Are Not Classified Elsewhere On Stalls And Markets"),
        Classification("479", "Retail Without A Store"),
        Classification("4791", "Retail Sale By Mail Order, Television, Radio, Telephone And Internet"),
        Classification("47911", "Retail Sale By Mail Order, Television, Radio And Telephone"),
        Classification("47912", "Internet Retailing"),
        Classification("4799", "Retail Without A Store By Other Means"),
        Classification("47991", "Direct Sales"),
        Classification("47999", "Retail Without A Store By Other Means Which Are Not Classified Elsewhere"),
        Classification("H", "Transportation And Storage"),
        Classification("49", "Land Transportation And Pipeline Transportation"),
        Classification("491", "Rail Transport"),
        Classification("4911", "Intercity Rail Passenger Transport"),
        Classification("49110", "Intercity Rail Passenger Transport"),
        Classification("4912", "Rail Freight"),
        Classification("49120", "Rail Freight"),
        Classification("492", "Transportation Of Passengers By Bus"),
        Classification("4920", "Transportation Of Passengers By Bus"),
        Classification("49201", "Transportation Of Passengers By Bus In Bangkok And Its Vicinity"),
        Classification("49202", "Transportation Of Passengers By Bus Between Bangkok With Other Provinces"),
        Classification("49203", "Transportation Of Passengers Via Inter-Provincial Buses"),
        Classification("49204", "Rural Bus Passenger Transport"),
        Classification("49209", "Transportation Of Passengers By Other Buses"),
        Classification("493", "Other Land Transport"),
        Classification("4931", "Transportation Of Passengers In Urban And Metropolitan Areas (Except By Bus)"),
        Classification("49310", "Transportation Of Passengers In Urban And Metropolitan Areas (Except By Bus)"),
        Classification("4932", "Other Land Transport"),
        Classification("49321", "Transportation Of Passengers By Car/Taxi"),
        Classification("49322", "Transportation Of Passengers By Motor Rickshaw And Motorcycle Taxi"),
        Classification("49329", "Other Land Transport Which Are Not Classified Elsewhere"),
        Classification("4933", "Road Freight"),
        Classification("49331", "Road Transport Of Chilled Or Frozen Goods"),
        Classification("49332", "Road Transportation Of Petroleum Products"),
        Classification("49333", "Transporting Liquids Or Gases (Except Natural Gas) By Road"),
        Classification("49334", "Road Transport Of Goods Packed In Containers"),
        Classification("49339", "Other Transport By Road"),
        Classification("494", "Pipeline Transport"),
        Classification("4940", "Pipeline Transport"),
        Classification("49400", "Pipeline Transport"),
        Classification("50", "Water Transport"),
        Classification("501", "Sea And Coastal Transportation"),
        Classification("5011", "Passenger Transport By Sea And Along The Coast"),
        Classification("50111", "Transportation Of Passengers By Sea And Along The Coast By Ferry"),
        Classification(
            "50112", "Transportation Of Passengers By Sea And Along The Coast By Excursion Boats Or Cruise Ships."
        ),
        Classification("50119", "Transportation Of Passengers By Sea And Along The Coast By Other Vessels"),
        Classification("5012", "Shipping By Sea And Along The Coast"),
        Classification("50121", "Shipping By Sea And Along The Coast"),
        Classification(
            "50122", "Towing And Pushing Of Boats/Floating Structures That Operates At Sea And Along The Coast"
        ),
        Classification("502", "Inland Waterway Transport"),
        Classification("5021", "Inland Water Passenger Transport"),
        Classification("50211", "Transportation Of Passengers By Sea By Ferry"),
        Classification("50212", "Transportation Of Passengers On Inland Waterways By Excursion Boats Or Cruise Ships"),
        Classification("50219", "Transportation Of Passengers By Inland Waterways By Other Boats"),
        Classification("5022", "Inland Waterway Transport"),
        Classification("50221", "Inland Waterway Transport"),
        Classification("50222", "Towing And Pushing Of Boats/Floating Structures That Operates Inland Waterways"),
        Classification("51", "Air Transport"),
        Classification("511", "Air Passenger Transport"),
        Classification("5110", "Air Passenger Transport"),
        Classification("51101", "Scheduled Air Passenger Transport"),
        Classification("51102", "Unscheduled Air Passenger Transport"),
        Classification("512", "Air Freight"),
        Classification("5120", "Air Freight"),
        Classification("51201", "Scheduled Air Freight"),
        Classification("51202", "Unscheduled Air Freight"),
        Classification("52", "Warehousing And Logistics Support Activities"),
        Classification("521", "Warehousing And Storage Activities"),
        Classification("5210", "Warehousing And Storage Activities"),
        Classification("52101", "Warehousing Activities And Storage Of Chilled Or Frozen Goods"),
        Classification("52102", "Warehousing And Storage Activities Of Grain Products"),
        Classification("52109", "Warehousing And Other Storage Activities"),
        Classification("522", "Activities That Support Transportation"),
        Classification("5221", "Service Activities That Support Land Transportation"),
        Classification("52211", "Service Activities That Support Rail Transport"),
        Classification("52212", "Bus Station Service Activities"),
        Classification("52213", "Parking Service Activities"),
        Classification("52214", "Forklift Service Activities"),
        Classification("52219", "Other Service Activities Supporting Land Transport"),
        Classification("5222", "Service Activities That Support Water Transportation"),
        Classification("52221", "Port Operations (Except For Loading And Unloading Goods)"),
        Classification("52229", "Other Service Activities That Supports Water Transportation"),
        Classification("5223", "Service Activities That Support Air Transport"),
        Classification("52231", "Airport Operations (Except For Loading And Unloading Goods)"),
        Classification("52239", "Other Service Activities That Supports Air Transport"),
        Classification("5224", "Loading And Unloading"),
        Classification("52241", "Loading And Unloading"),
        Classification("52242", "Unloading Luggage"),
        Classification("5229", "Other Activities That Support Transportation"),
        Classification("52291", "Transportation And Storage Management Activities"),
        Classification("52292", "Activities Of Shipping Agents And Exporting Agents (Customs Clearance Agent)"),
        Classification("52293", "Packaging Service Activities For Transportation"),
        Classification("52299", "Other Activities That Support Transportation Which Are Not Classified Elsewhere"),
        Classification("53", "Postal Activities And Parcel Delivery"),
        Classification("531", "State Postal And Parcel Activities"),
        Classification("5310", "State Postal And Parcel Activities"),
        Classification("53100", "State Postal And Parcel Activities"),
        Classification("532", "Postal Activities And Non-State Parcel Delivery"),
        Classification("5320", "Postal Activities And Non-State Parcel Delivery"),
        Classification("53200", "Postal Activities And Non-State Parcel Delivery"),
        Classification("I", "Accommodation And Food Service"),
        Classification("55", "Accommodation"),
        Classification("551", "Short Term Accommodation"),
        Classification("5510", "Short Term Accommodation"),
        Classification("55101", "Hotels And Resorts"),
        Classification("55102", "Guesthouse"),
        Classification("55103", "Rural Culture Accommodation"),
        Classification("55109", "Other Short Term Hotels For Travelers/Tourists"),
        Classification("552", "Campgrounds, Trailer Parks, And Mobile Shelters"),
        Classification("5520", "Campgrounds, Trailer Parks, And Mobile Shelters"),
        Classification("55200", "Campgrounds, Trailer Parks, And Mobile Shelters"),
        Classification("559", "Other Types Of Hotels"),
        Classification("5590", "Other Types Of Hotels"),
        Classification("55901", "Room Service Or Accommodation For Students/Students"),
        Classification("55909", "Other Hotel Services Which Are Not Classified Elsewhere"),
        Classification("56", "Food And Beverage Service"),
        Classification("561", "Food Service"),
        Classification("5610", "Food Service"),
        Classification("56101", "Food Service In Restaurants/Restaurants"),
        Classification("56102", "Food Service At Stalls And Markets"),
        Classification("56103", "Mobile Food Service"),
        Classification("562", "Off-Site Catering And Other Food Services"),
        Classification("5621", "Off-Site Catering Service"),
        Classification("56210", "Off-Site Catering Service"),
        Classification("5629", "Other Food Service"),
        Classification("56291", "Food Service For Transportation Business"),
        Classification("56292", "Canteen Operation"),
        Classification("56299", "Other Food Service Which Are Not Classified Elsewhere"),
        Classification("563", "Beverage Service"),
        Classification("5630", "Beverage Service"),
        Classification("56301", "Serving Alcoholic Beverages Is A Staple In The Shop."),
        Classification("56302", "The Service Is Primarily Non-Alcoholic Beverages In The Shop."),
        Classification("56303", "Serving Drinks On Stalls And Markets"),
        Classification("56304", "Mobile Beverage Service"),
        Classification("J.", "Information And Communication"),
        Classification("58", "Publishing, Selling Or Distributing"),
        Classification("581", "Publishing, Selling Or Publishing Books, Magazines, And Other Works"),
        Classification("5811", "Publishing, Selling Or Distributing Books"),
        Classification(
            "58111",
            "Publishing And Distributing Textbooks, Dictionaries And Encyclopedias On Various Media (Except Online)",
        ),
        Classification(
            "58112",
            "Publishing, Selling Or Distributing Brochures, Flyers And Other Similar Publications On Various Media. (Except Online)",
        ),
        Classification("58113", "Publishing, Selling Or Publishing Books Online"),
        Classification("58114", "Maintaining The Right To Reproduce Books For Sale Or Publishing"),
        Classification(
            "5812", "Publishing, Distributing, Or Distributing Encyclopedias And List Of Names And Mailing Addresses."
        ),
        Classification(
            "58121",
            "Publishing, Distributing Or Distributing Encyclopedias And Postal Address Lists On Various Media (Except Online)",
        ),
        Classification(
            "58122",
            "Publishing, Distributing, Or Distributing Encyclopedias And List Of Names And Mailing Addresses Online.",
        ),
        Classification("5813", "Publishing Or Distributing Newspapers, Periodicals And Magazines"),
        Classification("58131", "Publishing Or Distributing Newspapers On Various Media (Except Online)"),
        Classification(
            "58132", "Publishing, Selling Or Publishing Periodicals And Magazines On Various Media (Except Online)"
        ),
        Classification("58133", "Publishing And Distributing Newspapers, Periodicals And Magazines Online"),
        Classification(
            "58134", "Maintaining The Right To Reproduce Newspapers, Periodicals And Magazines For Sale Or Publishing"
        ),
        Classification("5819", "Publishing, Selling Or Distributing Other Works"),
        Classification("58191", "Publishing, Selling Or Distributing Other Works On Various Media (Except Online)"),
        Classification("58192", "Publishing, Selling Or Distributing Other Works Via Online"),
        Classification("58193", "Maintaining Rights To Reproduce Other Works To Sell Or Distribute"),
        Classification("582", "Ready-Made Software"),
        Classification("5820", "Ready-Made Software"),
        Classification("58201", "Making Ready-Made Game Software"),
        Classification("58202", "Ready-Made Software (Except Ready-Made Game Software)"),
        Classification("58203", "Maintaining The Right To Reproduce The Finished Software For Sale Or Distribution"),
        Classification(
            "59",
            "Film, Video And Television Program Production Audio Recording On Media And Publishing, Distributing Or Distributing Music",
        ),
        Classification("591", "Activities Related To Movies, Videos And Television Programs"),
        Classification("5911", "Film, Video And Television Program Production"),
        Classification("59111", "Film And Video Production"),
        Classification("59112", "Tv Production"),
        Classification("5912", "Post-Production Activities Of Movies, Videos And Television Programs"),
        Classification("59121", "Video And Audio Editing Services"),
        Classification("59122", "Computer Graphics, Animation And Special Effects Services"),
        Classification("59129", "Other Activities After Film, Video And Television Program Production"),
        Classification("5913", "Publishing Of Movies, Videos And Television Programs"),
        Classification("59131", "Publishing Of Movies, Videos And Television Programs"),
        Classification(
            "59132", "Maintaining Rights To Reproduce Films, Videos And Television Programs To Sell Or Distribute"
        ),
        Classification("5914", "Movie Screening"),
        Classification("59140", "Movie Screening"),
        Classification("592", "Recording Of Sound On Media And Publishing, Selling Or Distributing Music."),
        Classification("5920", "Recording Of Sound On Media And Publishing, Selling Or Distributing Music."),
        Classification("59201", "Audio Recording On Media"),
        Classification("59202", "Publishing, Selling Or Distributing Music"),
        Classification("59203", "Maintaining The Right To Reproduce Music To Sell Or Distribute"),
        Classification("60", "Program Scheduling And Broadcasting"),
        Classification("601", "Radio Broadcasting"),
        Classification("6010", "Radio Broadcasting"),
        Classification("60101", "Radio Broadcasting (Except Online)"),
        Classification("60102", "Radio Broadcasts Are Broadcast Online."),
        Classification("602", "Program Planning And Television Broadcasting"),
        Classification("6020", "Program Planning And Television Broadcasting"),
        Classification("60201", "Program Planning And Television Broadcasting Without Subscription (Except Online)"),
        Classification("60202", "Program Planning And Television Broadcasting By Subscribing (Except Online)"),
        Classification("60203", "Program Scheduling And Online Television Broadcasting"),
        Classification("61", "Telecommunication"),
        Classification("611", "Wired Telecommunication"),
        Classification("6110", "Wired Telecommunication"),
        Classification("61101", "Wired Internet Service"),
        Classification("61102", "Cable Television/Radio Delivery Service"),
        Classification("61109", "Other Telecommunication Wired"),
        Classification("612", "Wireless Telecommunication"),
        Classification("6120", "Wireless Telecommunication"),
        Classification("61201", "Mobile Phone Service"),
        Classification("61202", "Wireless Internet Service"),
        Classification("61209", "Other Telecommunication Wireless"),
        Classification("613", "Satellite Telecommunications"),
        Classification("6130", "Satellite Telecommunications"),
        Classification("61301", "Satellite Tv/Radio Broadcasting Service"),
        Classification("61302", "Satellite Telecommunications (Except Tv/Radio Broadcasting Service Via Satellite)"),
        Classification("619", "Other Telecommunication"),
        Classification("6190", "Other Telecommunication"),
        Classification("61900", "Other Telecommunication"),
        Classification("62", "Computer Program Preparation Computer Consulting And Related Activities"),
        Classification("620", "Computer Program Preparation Computer Consulting And Related Activities"),
        Classification("6201", "Creating A Computer Program For The Purpose Of The User"),
        Classification("62011", "Programming Web Pages And Networks Based On User Objectives"),
        Classification(
            "62012", "Creating A Computer Program For The Purpose Of The User (Except Web Page And Network Programs)"
        ),
        Classification("6202", "Computer Consulting And Computer Facility Management"),
        Classification("62021", "Hardware Consulting"),
        Classification("62022", "Software Consulting"),
        Classification("62023", "Management Of Computer Facilities"),
        Classification("6209", "Other Information Technology And Computer Services"),
        Classification("62090", "Other Information Technology And Computer Services"),
        Classification("63", "Information Service"),
        Classification(
            "631",
            "Data Processing Management And Leasing Of Space On The Server And Related Activities Including The Portal",
        ),
        Classification("6311", "Data Processing Management And Leasing Of Space On The Server And Related Activities"),
        Classification("63111", "Data Management And Processing"),
        Classification("63112", "Management And Leasing Of Space On The Server"),
        Classification("6312", "Portal"),
        Classification("63120", "Portal"),
        Classification("639", "Other Information Services"),
        Classification("6391", "News Agency Activities"),
        Classification("63911", "News Media Activities"),
        Classification("63912", "Audio-Visual News Agency Activities"),
        Classification("6399", "Other Information Services Which Are Not Classified Elsewhere"),
        Classification("63990", "Other Information Services Which Are Not Classified Elsewhere"),
        Classification("K", "Financial And Insurance Activities"),
        Classification("64", "Financial Services Activities (Except Insurance And Pension Funds)"),
        Classification("641", "Currency Intermediary"),
        Classification("6411", "Central Bank"),
        Classification("64110", "Central Bank"),
        Classification("6419", "Other Currency Intermediaries"),
        Classification("64191", "Commercial Bank"),
        Classification("64192", "Finance Company"),
        Classification("64193", "Credit Foncier Company"),
        Classification("64194", "Special Purpose Bank"),
        Classification("64195", "Financial Intermediary Cooperatives"),
        Classification("642", "Holding Company Activities"),
        Classification("6420", "Holding Company Activities"),
        Classification("64201", "Activities Of Holding Companies That Mainly Invest In The Financial Business"),
        Classification("64202", "Activities Of Holding Companies That Do Not Primarily Invest In Financial Businesses"),
        Classification("643", "Trusts, Funds And Other Similar Financial Activities"),
        Classification("6430", "Trusts, Funds And Other Similar Financial Activities"),
        Classification("64301", "Fund"),
        Classification("64302", "Trust"),
        Classification("64309", "Other Financial Activities Similar To Trusts And Funds"),
        Classification("649", "Other Financial Services Activities (Except Insurance And Pension Funds)"),
        Classification("6491", "Financial Lease"),
        Classification("64911", "Financial Leases For Motor Vehicles"),
        Classification("64912", "Financial Leases For Machinery And Equipment For Business Use"),
        Classification("64913", "Financial Leases For Consumer Goods (Except Motor Vehicles And Motorcycles)"),
        Classification("6492", "Other Types Of Credit"),
        Classification("64921", "Trade And Investment Loans"),
        Classification("64922", "Consumer Credit"),
        Classification("64923", "Home Loan"),
        Classification("64924", "Credit Card Service"),
        Classification("64925", "Pawnshop Service"),
        Classification("64929", "Other Types Of Credit Which Are Not Classified Elsewhere"),
        Classification(
            "6499", "Other Financial Services Activities (Except Insurance And Pension Funds) Not Elsewhere Classified"
        ),
        Classification("64991", "Funding Other Than Lending"),
        Classification("64992", "Own Investment Activities"),
        Classification(
            "64999", "Other Financial Services Activities (Except Insurance And Pension Funds) Not Elsewhere Classified"
        ),
        Classification("65", "Insurance Reinsurance And Pension Funds (Except Compulsory Social Security)"),
        Classification("651", "Insurance"),
        Classification("6511", "Life Insurance"),
        Classification("65110", "Life Insurance"),
        Classification("6512", "Non-Life Insurance"),
        Classification("65120", "Non-Life Insurance"),
        Classification("652", "Reinsurance"),
        Classification("6520", "Reinsurance"),
        Classification("65200", "Reinsurance"),
        Classification("653", "Pension Fund"),
        Classification("6530", "Pension Fund"),
        Classification("65300", "Pension Fund"),
        Classification("66", "Activities To Support Financial Services And Insurance"),
        Classification("661", "Activities To Support Financial Services (Except Insurance And Pension Funds)"),
        Classification("6611", "Financial Market Management"),
        Classification("66111", "Money Market And Capital Market Management"),
        Classification("66112", "Derivatives Market Management"),
        Classification("66113", "Financial Market Management Supervision Service"),
        Classification("6612", "Securities And Derivatives Brokerage Activities"),
        Classification("66121", "Brokerage Activities"),
        Classification("66122", "Derivatives Brokerage Activities"),
        Classification("66123", "Foreign Exchange Activities"),
        Classification("6619", "Other Activities That Support Financial Services"),
        Classification("66191", "Financial Advisory Services"),
        Classification("66192", "Processing And Billing Of Financial Transactions"),
        Classification("66193", "Securities Maintenance Service"),
        Classification("66199", "Other Activities That Support Financial Services Which Are Not Classified Elsewhere"),
        Classification("662", "Activities To Support Insurance And Pension Funds"),
        Classification("6621", "Risk Assessment And Damage Value"),
        Classification("66210", "Risk Assessment And Damage Value"),
        Classification("6622", "Activities Of Insurance Agents And Brokers"),
        Classification("66221", "Activities Of Life Insurance Agents And Brokers"),
        Classification("66222", "Activities Of Non-Life Insurance Agents And Brokers"),
        Classification("6629", "Other Activities That Support Insurance And Pension Funds"),
        Classification("66290", "Other Activities That Support Insurance And Pension Funds"),
        Classification("663", "Fund Management"),
        Classification("6630", "Fund Management"),
        Classification("66301", "Fund And Portfolio Management (Except Pension Funds)"),
        Classification("66302", "Pension Fund Management"),
        Classification("L", "Real Estate Activities"),
        Classification("68", "Real Estate Activities"),
        Classification("681", "Real Estate Activities Owned Or Rented From Others"),
        Classification("6810", "Real Estate Activities Owned Or Rented From Others"),
        Classification("68101", "Buying And Selling Own Real Estate For Living"),
        Classification("68102", "Buying And Selling Non-Residential Property"),
        Classification(
            "68103", "Renting And Operating Real Estate Owned Or Leased From Others For Residential Purposes"
        ),
        Classification("68104", "Renting And Operating Real Estate Owned Or Leased From Others Non-Residential"),
        Classification("682", "Real Estate Activities By Receiving Compensation Or Under An Employment Contract"),
        Classification("6820", "Real Estate Activities By Receiving Compensation Or Under An Employment Contract"),
        Classification(
            "68201", "Activities Of Real Estate Agents By Receiving Compensation Or Under An Employment Contract"
        ),
        Classification(
            "68202", "Property Management Services By Receiving Compensation Or Under An Employment Contract"
        ),
        Classification("M", "Professional, Scientific And Technical Activities"),
        Classification("69", "Legal And Accounting Activities"),
        Classification("691", "Legal Activities"),
        Classification("6910", "Legal Activities"),
        Classification("69100", "Legal Activities"),
        Classification("692", "Accounting, Bookkeeping And Auditing Activities Tax Consulting"),
        Classification("6920", "Accounting, Bookkeeping And Auditing Activities Tax Consulting"),
        Classification("69200", "Accounting, Bookkeeping And Auditing Activities Tax Consulting"),
        Classification("70", "Head Office Activities And Management Consulting Services"),
        Classification("701", "Head Office Activities"),
        Classification("7010", "Head Office Activities"),
        Classification("70100", "Head Office Activities"),
        Classification("702", "Management Consulting Services"),
        Classification("7020", "Management Consulting Services"),
        Classification("70201", "Public Relations Communication Consulting Services"),
        Classification("70202", "Financial Management Consulting Services"),
        Classification("70209", "Other Management Consulting Services"),
        Classification("71", "Architecture And Engineering Activities Including Testing And Technical Analysis"),
        Classification("711", "Architecture And Engineering Activities And Related Technical Consulting"),
        Classification("7110", "Architecture And Engineering Activities And Related Technical Consulting"),
        Classification("71101", "Architectural And Consulting Related Activities"),
        Classification("71102", "Related Engineering And Consulting Activities"),
        Classification("71103", "Activities In Geophysics, Geology And Related Consulting"),
        Classification("712", "Technical Testing And Analysis"),
        Classification("7120", "Technical Testing And Analysis"),
        Classification("71201", "Chemical, Physical And Biological Composition Testing And Analysis"),
        Classification("71202", "Technical Vehicle Inspection"),
        Classification("71209", "Other Technical Testing And Analysis"),
        Classification("72", "Scientific Research And Development"),
        Classification("721", "Research And Experimental Development In Natural Science And Engineering"),
        Classification("7210", "Research And Experimental Development In Natural Science And Engineering"),
        Classification("72101", "Research And Experimental Development In Natural Sciences"),
        Classification("72102", "Research And Experimental Development In Biotechnology"),
        Classification("72109", "Research And Experimental Development In Engineering And Other Technologies"),
        Classification("722", "Research And Experimental Development In Social Sciences And Humanities"),
        Classification("7220", "Research And Experimental Development In Social Sciences And Humanities"),
        Classification("72200", "Research And Experimental Development In Social Sciences And Humanities"),
        Classification("73", "Advertising And Market Research"),
        Classification("731", "Advertising"),
        Classification("7310", "Advertising"),
        Classification("73101", "Advertising Company Activities"),
        Classification("73102", "Activities Of Advertising Media Sales Representatives"),
        Classification("732", "Market Research And Public Opinion Polls"),
        Classification("7320", "Market Research And Public Opinion Polls"),
        Classification("73200", "Market Research And Public Opinion Polls"),
        Classification("74", "Other Professional, Scientific And Technical Activities"),
        Classification("741", "Specialized Design Activities"),
        Classification("7410", "Specialized Design Activities"),
        Classification("74101", "Interior Design Activities"),
        Classification("74109", "Other Specific Design Activities"),
        Classification("742", "Photography Activity"),
        Classification("7420", "Photography Activity"),
        Classification("74200", "Photography Activity"),
        Classification(
            "749", "Other Professional, Scientific And Technical Activities Which Are Not Classified Elsewhere"
        ),
        Classification(
            "7490", "Other Professional, Scientific And Technical Activities Which Are Not Classified Elsewhere"
        ),
        Classification("74901", "Translation And Interpreting Activities"),
        Classification("74902", "Environmental Consulting Services"),
        Classification(
            "74909", "Other Professional, Scientific And Technical Activities Which Are Not Classified Elsewhere"
        ),
        Classification("75", "Veterinary Service"),
        Classification("750", "Veterinary Service"),
        Classification("7500", "Veterinary Service"),
        Classification("75000", "Veterinary Service"),
        Classification("N", "Administrative Activities And Support Services"),
        Classification("77", "Rental Activities"),
        Classification("771", "Motor Vehicle Rental"),
        Classification("7710", "Motor Vehicle Rental"),
        Classification("77101", "Rental Of Passenger Vehicles, Pickup Trucks, Vans And Similar Small Vehicles"),
        Classification("77109", "Rental Of Trucks And Other Heavy Vehicles"),
        Classification("772", "Rental Of Personal And Household Items"),
        Classification("7721", "Rental Of Equipment For Recreation And Sports"),
        Classification("77210", "Rental Of Equipment For Recreation And Sports"),
        Classification("7722", "Rental Of Audio And Visual Media"),
        Classification("77220", "Rental Of Audio And Visual Media"),
        Classification("7729", "Rental Of Personal And Other Household Items"),
        Classification("77291", "Book Rental"),
        Classification("77299", "Rental Of Personal And Other Household Items Which Are Not Classified Elsewhere"),
        Classification("773", "Rental Of Machinery, Equipment And Other Tangible Goods"),
        Classification("7730", "Rental Of Machinery, Equipment And Other Tangible Goods"),
        Classification("77301", "Land Transportation Equipment Rental (Except Motor Vehicles)"),
        Classification("77302", "Rental Of Water Transport Equipment"),
        Classification("77303", "Air Transportation Equipment Rental"),
        Classification("77304", "Rental Of Agricultural And Forestry Machinery And Equipment"),
        Classification("77305", "Renting Of Machinery And Equipment For Construction And Civil Engineering Works"),
        Classification("77306", "Rental Of Office Machinery And Equipment"),
        Classification(
            "77309", "Rental Of Machinery, Equipment And Other Tangible Goods Which Are Not Classified Elsewhere"
        ),
        Classification(
            "774", "Operating Leases For Intellectual Property And Similar Products (Except Copyrighted Works)"
        ),
        Classification(
            "7740", "Operating Leases For Intellectual Property Or Similar Products (Except Copyrighted Works)"
        ),
        Classification(
            "77400", "Operating Leases For Intellectual Property Or Similar Products (Except Copyrighted Works)"
        ),
        Classification("78", "Employment Activities"),
        Classification("781", "Activities Of The Office Or Recruitment Agency"),
        Classification("7810", "Activities Of The Office Or Recruitment Agency"),
        Classification("78101", "Casting Activities For Film, Television And Other Performances"),
        Classification("78109", "Activities Of Other Offices Or Recruiting Agents"),
        Classification("782", "Temporary Office Or Agency Activities"),
        Classification("7820", "Temporary Office Or Agency Activities"),
        Classification("78200", "Temporary Office Or Agency Activities"),
        Classification("783", "Other Human Resources Activities"),
        Classification("7830", "Other Human Resources Activities"),
        Classification("78300", "Other Human Resources Activities"),
        Classification("79", "Activities Of Travel Agents Organizing A Tour Backup Service And Related Activities"),
        Classification("791", "Activities Of Travel Agencies And Tour Arrangements"),
        Classification("7911", "Activities Of Travel Agents"),
        Classification("79110", "Activities Of Travel Agents"),
        Classification("7912", "Tour Organizing Activities"),
        Classification("79120", "Tour Organizing Activities"),
        Classification("799", "Other Service Activities And Related Activities"),
        Classification("7990", "Other Service Activities And Related Activities"),
        Classification("79901", "Guide'S Activities"),
        Classification("79909", "Other Service Activities And Related Activities Which Are Not Classified Elsewhere"),
        Classification("80", "Security And Investigation Services"),
        Classification("801", "Personal Security Service"),
        Classification("8010", "Personal Security Service"),
        Classification("80100", "Personal Security Service"),
        Classification("802", "Security Service"),
        Classification("8020", "Security Service"),
        Classification("80200", "Security Service"),
        Classification("803", "Investigative Activities"),
        Classification("8030", "Investigative Activities"),
        Classification("80300", "Investigative Activities"),
        Classification("81", "Service Activities For Buildings And Landscapes"),
        Classification("811", "Comprehensive Facilitation Support Activities"),
        Classification("8110", "Comprehensive Facilitation Support Activities"),
        Classification("81100", "Comprehensive Facilitation Support Activities"),
        Classification("812", "Cleaning Service"),
        Classification("8121", "General Cleaning Services For Buildings"),
        Classification("81210", "General Cleaning Services For Buildings"),
        Classification("8129", "Cleaning Services For Buildings And Other Industries"),
        Classification("81291", "Cleaning Services For Outdoor Surfaces"),
        Classification("81292", "Interior Cleaning Services That Use Specialized Expertise."),
        Classification("81293", "Disinfection And Disposal Services"),
        Classification(
            "81299", "Cleaning Services For Buildings And Other Industries Which Are Not Classified Elsewhere"
        ),
        Classification("813", "Landscape Care And Maintenance Services"),
        Classification("8130", "Landscape Care And Maintenance Services"),
        Classification("81300", "Landscape Care And Maintenance Services"),
        Classification("82", "Office Administration And Support Services And Other Activities Business Support"),
        Classification("821", "Office Administration And Support Services"),
        Classification("8211", "Comprehensive Office Management Services"),
        Classification("82110", "Comprehensive Office Management Services"),
        Classification(
            "8219", "Photocopying Document Preparation And Other Specific Activities That Supports Office Operations"
        ),
        Classification("82191", "Photocopying"),
        Classification(
            "82199", "Document Preparation And Other Specialized Activities That Supports Office Operations"
        ),
        Classification("822", "Call Center Activities"),
        Classification("8220", "Call Center Activities"),
        Classification("82200", "Call Center Activities"),
        Classification("823", "Organizing Meetings And Trade Shows"),
        Classification("8230", "Organizing Meetings And Trade Shows"),
        Classification("82301", "Meeting Arrangement"),
        Classification("82302", "Exhibition Management"),
        Classification("829", "Business Support Service Activities Which Are Not Classified Elsewhere"),
        Classification("8291", "Activities Of Collection Agents And Credit Information Services"),
        Classification("82911", "Collector'S Activities"),
        Classification("82912", "Credit Information Service Activities"),
        Classification("8292", "Packaging Activities"),
        Classification("82920", "Packaging Activities"),
        Classification("8299", "Other Service Activities Business Support Which Are Not Classified Elsewhere"),
        Classification("82990", "Other Service Activities Business Support Which Are Not Classified Elsewhere"),
        Classification("O", "Public Administration Defense And Compulsory Social Security"),
        Classification("84", "Public Administration Defense And Compulsory Social Security"),
        Classification("841", "Public Administration And Economic And Social Policies Of The Community."),
        Classification("8411", "General Public Administration Activities"),
        Classification("84111", "Overall Public Administration Activities"),
        Classification("84114", "Service Activities That Promote The Public Sector As A Whole"),
        Classification(
            "8412",
            "Establishing Rules On Health, Educational, Cultural And Other Social Service Activities. (Except Social Security)",
        ),
        Classification("84121", "Establishing Rules For Educational Service Activities"),
        Classification("84122", "Establishing Rules For Health Service Activities"),
        Classification("84123", "Establishing Rules For Housing, Community And Environmental Services Activities"),
        Classification("84124", "Establishing Rules For Sports, Recreation, Cultural And Religious Service Activities"),
        Classification("8413", "Rule Formulation And Support To Optimize Business Operations"),
        Classification(
            "84131",
            "Establishing Regulations And Advocacy To Optimize Agriculture, Forestry, Fisheries And Hunting Operations.",
        ),
        Classification("84132", "Establishing Regulations And Advocacy To Optimize Fuel And Energy Operations."),
        Classification("84133", "Regulation And Support To Optimize Mining, Manufacturing And Construction Operations"),
        Classification("84134", "Regulation And Support To Optimize Transport And Telecommunications Operations"),
        Classification("84135", "Regulation And Support To Optimize Wholesale And Retail Operations"),
        Classification("84136", "Formulation Of Rules And Support To Optimize Tourism Operations And Related Services"),
        Classification(
            "84137", "Regulation And Advocacy To Optimize General Scientific, Economic, Commercial And Labor Operations"
        ),
        Classification("842", "Service To Society As A Whole"),
        Classification("8421", "Foreign Affairs"),
        Classification("84210", "Foreign Affairs"),
        Classification("8422", "Defense Activities"),
        Classification("84220", "Defense Activities"),
        Classification("8423", "Public Order And Safety Activities"),
        Classification("84231", "Police Activities"),
        Classification("84232", "Court Activities And Administration Of Justice"),
        Classification("84233", "Other Activities To Maintain Public Order And Safety"),
        Classification("843", "Compulsory Social Security"),
        Classification("8430", "Compulsory Social Security"),
        Classification("84300", "Compulsory Social Security"),
        Classification("P", "Education"),
        Classification("85", "Education"),
        Classification("851", "Primary Education"),
        Classification("8510", "Primary Education"),
        Classification("85101", "Primary School Education In Normal Classrooms For Normal Children."),
        Classification("85102", "Primary Education In Normal Classrooms For Children With Disabilities"),
        Classification("85103", "Elementary Education That Is Not Taught In Regular Classrooms"),
        Classification("852", "Secondary Education"),
        Classification("8521", "Secondary Education In General Education"),
        Classification("85211", "Secondary Education, General Education In A Normal Classroom For The General Public"),
        Classification(
            "85212", "Secondary Education, General Education In Normal Classes For People With Disabilities"
        ),
        Classification("85213", "General Secondary Education That Is Not Taught In Regular Classrooms"),
        Classification("8522", "Vocational Secondary Education"),
        Classification("85220", "Vocational Secondary Education"),
        Classification("853", "Higher Education"),
        Classification("8530", "Higher Education"),
        Classification("85301", "Higher Education Below A Bachelor'S Degree"),
        Classification("85302", "Bachelor'S Degree"),
        Classification("85303", "Master'S Degree And Above"),
        Classification("854", "Other Types Of Education"),
        Classification("8541", "Sports And Recreation Education"),
        Classification("85410", "Sports And Recreation Education"),
        Classification("8542", "Cultural Studies"),
        Classification("85421", "Dance Teaching Activities"),
        Classification("85422", "Music Teaching Activities"),
        Classification("85423", "Art Teaching Activities"),
        Classification("85429", "Other Cultural Studies"),
        Classification("8549", "Other Types Of Education Which Are Not Classified Elsewhere"),
        Classification("85491", "Language Teaching Activities"),
        Classification("85492", "Information Technology Teaching And Learning Activities"),
        Classification("85493", "General Tutoring Activities"),
        Classification("85494", "Teaching Activities For Cutting Clothes And Beauty Salons"),
        Classification("85495", "Spa Therapy Teaching Activities"),
        Classification("85496", "Massage Teaching Activities"),
        Classification("85497", "Driving Instruction Activities"),
        Classification("85499", "Other Types Of Education Which Are Not Classified Elsewhere"),
        Classification("855", "Education Support Services"),
        Classification("8550", "Education Support Services"),
        Classification("85500", "Education Support Services"),
        Classification("856", "Pre-Primary Education"),
        Classification("8560", "Pre-Primary Education"),
        Classification("85601", "Pre-Primary Education For General Children"),
        Classification("85602", "Pre-Primary Education For Children With Disabilities"),
        Classification("Q", "Health And Social Work Activities"),
        Classification("86", "Human Health Activities"),
        Classification("861", "Hospital Activities"),
        Classification("8610", "Hospital Activities"),
        Classification("86101", "Hospital Activities (Except Specialized Hospitals)"),
        Classification("86102", "Special Hospital Activities"),
        Classification("862", "Medical And Dental Activities"),
        Classification("8620", "Medical And Dental Activities"),
        Classification("86201", "General Disease Clinic Activities"),
        Classification("86202", "Clinical Activities For Specific Diseases"),
        Classification("86203", "Dental Activity"),
        Classification("869", "Other Human Health Activities"),
        Classification("8690", "Other Human Health Activities"),
        Classification("86901", "Nursing And Midwifery Activities"),
        Classification("86902", "Physical Therapy Activities"),
        Classification("86903", "Medical Laboratory Activities"),
        Classification("86909", "Other Human Health Activities Which Are Not Classified Elsewhere"),
        Classification("87", "Caring Activities That Provide Accommodation"),
        Classification("871", "Nursing Services That Provide Accommodation"),
        Classification("8710", "Nursing Services That Provide Accommodation"),
        Classification("87100", "Nursing Services That Provide Accommodation"),
        Classification(
            "872",
            "Caring Activities That Provide Accommodation For People With Intellectual Disabilities People With Mental Health Problems And Drug Addicts",
        ),
        Classification(
            "8720",
            "Caring Activities That Provide Accommodation For People With Intellectual Disabilities People With Mental Health Problems And Drug Addicts",
        ),
        Classification(
            "87201", "Caring Activities That Provide Accommodation For People With Intellectual Disabilities"
        ),
        Classification("87202", "Caring Activities That Provide Accommodation For People With Mental Health Problems"),
        Classification("87203", "Caring Activities That Provide Accommodation For Drug Addicts"),
        Classification("873", "Activities Providing Accommodation For The Elderly And Disabled"),
        Classification("8730", "Activities Providing Accommodation For The Elderly And Disabled"),
        Classification("87301", "Caring Activities That Provide Accommodation For The Elderly"),
        Classification(
            "87302", "Caring Activities That Provide Accommodation For Children And Youth With Disabilities"
        ),
        Classification("87303", "Caring Activities That Provide Accommodation For Adults With Disabilities"),
        Classification("879", "Caring Activities That Provide Accommodation To Other People"),
        Classification("8790", "Caring Activities That Provide Accommodation To Other People"),
        Classification(
            "87901",
            "Caring Activities That Provide Accommodation For Children And Young People (Except Those With Disabilities, Mental Health Problems, And Drug Addiction)",
        ),
        Classification(
            "87902", "Caring Activities That Provide Accommodation For Women Suffering From Social Problems"
        ),
        Classification(
            "87909", "Caring Activities That Provide Accommodation To Other People Which Are Not Classified Elsewhere"
        ),
        Classification("88", "Social Work Activities That Do Not Provide Accommodation"),
        Classification("881", "Social Work Activities That Do Not Provide Accommodation For The Elderly And Disabled"),
        Classification("8810", "Social Work Activities That Do Not Provide Accommodation For The Elderly And Disabled"),
        Classification("88101", "Social Work Activities That Do Not Provide Accommodation For The Elderly"),
        Classification(
            "88102", "Social Work Activities That Do Not Provide Accommodation For People With Disabilities"
        ),
        Classification("889", "Other Social Work Activities That Does Not Provide Accommodation"),
        Classification("8890", "Other Social Work Activities That Does Not Provide Accommodation"),
        Classification("88901", "Day Care Activities"),
        Classification(
            "88909",
            "Other Social Work Activities That Does Not Provide Accommodation Which Are Not Classified Elsewhere",
        ),
        Classification("R", "Arts, Entertainment And Recreation"),
        Classification("90", "Creative Arts And Entertainment Activities"),
        Classification("900", "Creative Arts And Entertainment Activities"),
        Classification("9000", "Creative Arts And Entertainment Activities"),
        Classification("90001", "Creative Arts Activities"),
        Classification("90002", "Entertainment Activities"),
        Classification("91", "Library Activities, Archives, Museums And Other Cultural Activities"),
        Classification("910", "Library Activities, Archives, Museums And Other Cultural Activities"),
        Classification("9101", "Library And Archives Activities"),
        Classification("91011", "Library Activities"),
        Classification("91012", "Archives Activities"),
        Classification("9102", "Museum Activities And Operations On Historic Sites And Buildings"),
        Classification("91021", "Museum Activities"),
        Classification("91022", "Operations On Ancient Sites And Historical Buildings"),
        Classification("9103", "Botanical Garden And Zoo Activities And Conservation Of Nature"),
        Classification("91031", "Botanical Garden And Zoo Activities"),
        Classification("91032", "Nature Conservation Activities"),
        Classification("92", "Gambling And Gambling Activities"),
        Classification("920", "Gambling And Gambling Activities"),
        Classification("9200", "Gambling And Gambling Activities"),
        Classification("92001", "Lottery Operations"),
        Classification("92009", "Other Gambling And Gambling Activities"),
        Classification("93", "Sports, Entertainment And Recreational Activities"),
        Classification("931", "Sports Activities"),
        Classification("9311", "Operations On Sports Facilities"),
        Classification("93111", "Operations On Sports Facilities"),
        Classification("93112", "Fitness Center Operations And Exercises To Practice Flexibility Of The Body."),
        Classification("9312", "Sports Club Activities"),
        Classification("93120", "Sports Club Activities"),
        Classification("9319", "Other Sports Activities"),
        Classification("93191", "Sports Event Management Activities"),
        Classification("93192", "Activities Of Sports Associations/Confederations"),
        Classification("93199", "Other Sporting Activities Not Elsewhere Classified"),
        Classification("932", "Other Entertainment And Recreational Activities"),
        Classification("9321", "Amusement And Theme Park Activities"),
        Classification("93210", "Amusement And Theme Park Activities"),
        Classification("9329", "Other Entertainment And Recreational Activities Which Are Not Classified Elsewhere"),
        Classification("93291", "Park And Beach Activities"),
        Classification("93292", "Activities For Entertainment And Recreation"),
        Classification("93293", "Game Shop Operation Activities And Coin-Operated Game Machines"),
        Classification("93299", "Other Entertainment And Recreational Activities Which Are Not Classified Elsewhere"),
        Classification("S", "Other Service Activities"),
        Classification("94", "Member Organization Activities"),
        Classification("941", "Business Organization Activities Employer Organization And Professional Organizations"),
        Classification("9411", "Activities Of Business Organizations And Employers' Organizations"),
        Classification("94110", "Activities Of Business Organizations And Employers' Organizations"),
        Classification("9412", "Professional Organization Activities"),
        Classification("94120", "Professional Organization Activities"),
        Classification("942", "Union Activities"),
        Classification("9420", "Union Activities"),
        Classification("94200", "Union Activities"),
        Classification("949", "Other Member Organization Activities"),
        Classification("9491", "Religious Organization Activities"),
        Classification("94910", "Religious Organization Activities"),
        Classification("9492", "Political Organization Activities"),
        Classification("94920", "Political Organization Activities"),
        Classification("9499", "Other Member Organization Activities Which Are Not Classified Elsewhere"),
        Classification("94991", "Human Rights Organization Activities"),
        Classification("94992", "Youth Association Activities"),
        Classification("94993", "Environmental And Ecology Organization Activities"),
        Classification("94994", "Cultural And Recreational Association Activities"),
        Classification("94999", "Other Member Organization Activities Which Are Not Classified Elsewhere"),
        Classification("95", "Repairing Computers And Personal And Household Items"),
        Classification("951", "Repair Of Computer Equipment And Telecommunication Equipment"),
        Classification("9511", "Repairing Computers And Peripherals"),
        Classification("95110", "Repairing Computers And Peripherals"),
        Classification("9512", "Telecommunication Equipment Repair"),
        Classification("95120", "Telecommunication Equipment Repair"),
        Classification("952", "Repairing Personal And Household Items"),
        Classification("9521", "Repair Of Household Electronic Appliances"),
        Classification("95210", "Repair Of Household Electronic Appliances"),
        Classification("9522", "Repair Of Household Appliances And Equipment For Home And Garden"),
        Classification("95220", "Repair Of Household Appliances And Equipment For Home And Garden"),
        Classification("9523", "Shoe And Leather Repair"),
        Classification("95230", "Shoe And Leather Repair"),
        Classification("9524", "Repairing Furniture And Home Furnishings"),
        Classification("95240", "Repairing Furniture And Home Furnishings"),
        Classification("9529", "Repairing Personal And Other Household Items"),
        Classification("95291", "Watch Repair"),
        Classification("95292", "Clothing Repair"),
        Classification("95293", "Bicycle Repair"),
        Classification("95294", "Repairing Musical Instruments"),
        Classification("95295", "Repairing Sports Equipment"),
        Classification("95299", "Repairing Personal And Other Household Items Which Are Not Classified Elsewhere"),
        Classification("96", "Other Personal Service Activities"),
        Classification("961", "Service Activities To Enhance Physical Health (Except Sports Activities)"),
        Classification("9610", "Service Activities To Enhance Physical Health (Except Sports Activities)"),
        Classification("96101", "Spa Activities And Massages"),
        Classification("96102", "Weight Loss Service Activities"),
        Classification("96103", "Hair Styling Activity"),
        Classification("96104", "Beauty Care Activities Manicure And Pedicure"),
        Classification("96109", "Other Service Activities To Enhance Physical Health (Except Sports Activities)"),
        Classification("962", "Laundry And Dry Cleaning Services"),
        Classification("9620", "Laundry And Dry Cleaning Services"),
        Classification("96201", "Laundry And Dry Cleaning Services (Except By Coin-Operated Washing Machines)"),
        Classification("96202", "Laundry And Dry Cleaning Services By Coin-Operated Washing Machine"),
        Classification("96203", "Bleaching And Dyeing Services"),
        Classification("963", "Other Personal Service Activities Which Are Not Classified Elsewhere"),
        Classification("9630", "Other Personal Service Activities Which Are Not Classified Elsewhere"),
        Classification("96301", "Funeral And Related Activities"),
        Classification("96302", "Pet Care Activities"),
        Classification("96303", "Vending Machine Service Activities"),
        Classification("96304", "Astrology And Superstition Activities"),
        Classification("96305", "Baths, Massages And Similar Services"),
        Classification("96309", "Other Personal Service Activities Which Are Not Classified Elsewhere"),
        Classification(
            "T",
            "Employment Activities In Private Households Activities For The Production Of Goods And Services That Are Made For Household Use Which Cannot Clearly Classify Activities",
        ),
        Classification("97", "Employment Activities In Private Households"),
        Classification("970", "Employment Activities In Private Households"),
        Classification("9700", "Employment Activities In Private Households"),
        Classification("97000", "Employment Activities In Private Households"),
        Classification(
            "98",
            "Activities For The Production Of Goods And Services That Are Made For Household Use Which Cannot Clearly Classify Activities",
        ),
        Classification("981", "Household Goods Production Activities Which Cannot Clearly Classify Activities"),
        Classification("9810", "Household Goods Production Activities Which Cannot Clearly Classify Activities"),
        Classification("98100", "Household Goods Production Activities Which Cannot Clearly Classify Activities"),
        Classification("982", "Household Service Activities Which Cannot Clearly Classify Activities"),
        Classification("9820", "Household Service Activities Which Cannot Clearly Classify Activities"),
        Classification("98200", "Household Service Activities Which Cannot Clearly Classify Activities"),
        Classification("U", "Activities Of International Organizations And Members"),
        Classification("99", "Activities Of International Organizations And Members"),
        Classification("990", "Activities Of International Organizations And Members"),
        Classification("9900", "Activities Of International Organizations And Members"),
        Classification("99001", "Activities Of Diplomatic And Consular Missions From Different Countries"),
        Classification("99009", "Activities Of International Organizations And Other Contracting Parties"),
    ],
)
