# -*- coding: utf-8 -*-
"""`SKD 2008 - Standard Classification of Activities 2002 <https://www.stat.si/statweb/en/methods/classifications>`_.
"""
from ...types import Category, Classification, Standard, Standards

SKD2008 = Standard(
    standard=Standards.SKD2008,
    classes=[
        Classification("A", "AGRICULTURE, FORESTRY AND FISHING", Category.SECTION),
        Classification("01", "Crop and animal production, hunting and related service activities", Category.DIVISION),
        Classification("01.1", "Growing of non-perennial crops", Category.GROUP),
        Classification("01.11", "Growing of cereals (except rice), leguminous crops and oil seeds", Category.CLASS),
        Classification("01.110", "Growing of cereals (except rice), leguminous crops and oil seeds", Category.SUBCLASS),
        Classification("01.12", "Growing of rice", Category.CLASS),
        Classification("01.120", "Growing of rice", Category.SUBCLASS),
        Classification("01.13", "Growing of vegetables and melons, roots and tubers", Category.CLASS),
        Classification("01.130", "Growing of vegetables and melons, roots and tubers", Category.SUBCLASS),
        Classification("01.14", "Growing of sugar cane", Category.CLASS),
        Classification("01.140", "Growing of sugar cane", Category.SUBCLASS),
        Classification("01.15", "Growing of tobacco", Category.CLASS),
        Classification("01.150", "Growing of tobacco", Category.SUBCLASS),
        Classification("01.16", "Growing of fibre crops", Category.CLASS),
        Classification("01.160", "Growing of fibre crops", Category.SUBCLASS),
        Classification("01.19", "Growing of other non-perennial crops", Category.CLASS),
        Classification("01.190", "Growing of other non-perennial crops", Category.SUBCLASS),
        Classification("01.2", "Growing of perennial crops", Category.GROUP),
        Classification("01.21", "Growing of grapes", Category.CLASS),
        Classification("01.210", "Growing of grapes", Category.SUBCLASS),
        Classification("01.22", "Growing of tropical and subtropical fruits", Category.CLASS),
        Classification("01.220", "Growing of tropical and subtropical fruits", Category.SUBCLASS),
        Classification("01.23", "Growing of citrus fruits", Category.CLASS),
        Classification("01.230", "Growing of citrus fruits", Category.SUBCLASS),
        Classification("01.24", "Growing of pome fruits and stone fruits", Category.CLASS),
        Classification("01.240", "Growing of pome fruits and stone fruits", Category.SUBCLASS),
        Classification("01.25", "Growing of other tree and bush fruits and nuts", Category.CLASS),
        Classification("01.250", "Growing of other tree and bush fruits and nuts", Category.SUBCLASS),
        Classification("01.26", "Growing of oleaginous fruits", Category.CLASS),
        Classification("01.260", "Growing of oleaginous fruits", Category.SUBCLASS),
        Classification("01.27", "Growing of beverage crops", Category.CLASS),
        Classification("01.270", "Growing of beverage crops", Category.SUBCLASS),
        Classification("01.28", "Growing of spices, aromatic, drug and pharmaceutical crops", Category.CLASS),
        Classification("01.280", "Growing of spices, aromatic, drug and pharmaceutical crops", Category.SUBCLASS),
        Classification("01.29", "Growing of other perennial crops", Category.CLASS),
        Classification("01.290", "Growing of other perennial crops", Category.SUBCLASS),
        Classification("01.3", "Plant propagation", Category.GROUP),
        Classification("01.30", "Plant propagation", Category.CLASS),
        Classification("01.300", "Plant propagation", Category.SUBCLASS),
        Classification("01.4", "Animal production", Category.GROUP),
        Classification("01.41", "Raising of dairy cattle", Category.CLASS),
        Classification("01.410", "Raising of dairy cattle", Category.SUBCLASS),
        Classification("01.42", "Raising of other cattle and buffaloes", Category.CLASS),
        Classification("01.420", "Raising of other cattle and buffaloes", Category.SUBCLASS),
        Classification("01.43", "Raising of horses and other equines", Category.CLASS),
        Classification("01.430", "Raising of horses and other equines", Category.SUBCLASS),
        Classification("01.44", "Raising of camels and camelids", Category.CLASS),
        Classification("01.440", "Raising of camels and camelids", Category.SUBCLASS),
        Classification("01.45", "Raising of sheep and  goats", Category.CLASS),
        Classification("01.450", "Raising of sheep and  goats", Category.SUBCLASS),
        Classification("01.46", "Raising of swine/pigs", Category.CLASS),
        Classification("01.460", "Raising of swine/pigs", Category.SUBCLASS),
        Classification("01.47", "Raising of poultry", Category.CLASS),
        Classification("01.470", "Raising of poultry", Category.SUBCLASS),
        Classification("01.49", "Raising of other animals", Category.CLASS),
        Classification("01.490", "Raising of other animals", Category.SUBCLASS),
        Classification("01.5", "Mixed farming", Category.GROUP),
        Classification("01.50", "Mixed farming", Category.CLASS),
        Classification("01.500", "Mixed farming", Category.SUBCLASS),
        Classification("01.6", "Support activities to agriculture and post-harvest crop activities", Category.GROUP),
        Classification("01.61", "Support activities for crop production", Category.CLASS),
        Classification("01.610", "Support activities for crop production", Category.SUBCLASS),
        Classification("01.62", "Support activities for animal production", Category.CLASS),
        Classification("01.620", "Support activities for animal production", Category.SUBCLASS),
        Classification("01.63", "Post-harvest crop activities", Category.CLASS),
        Classification("01.630", "Post-harvest crop activities", Category.SUBCLASS),
        Classification("01.64", "Seed processing for propagation", Category.CLASS),
        Classification("01.640", "Seed processing for propagation", Category.SUBCLASS),
        Classification("01.7", "Hunting, trapping and related service activities", Category.GROUP),
        Classification("01.70", "Hunting, trapping and related service activities", Category.CLASS),
        Classification("01.700", "Hunting, trapping and related service activities", Category.SUBCLASS),
        Classification("02", "Forestry and logging", Category.DIVISION),
        Classification("02.1", "Silviculture and other forestry activities", Category.GROUP),
        Classification("02.10", "Silviculture and other forestry activities", Category.CLASS),
        Classification("02.100", "Silviculture and other forestry activities", Category.SUBCLASS),
        Classification("02.2", "Logging", Category.GROUP),
        Classification("02.20", "Logging", Category.CLASS),
        Classification("02.200", "Logging", Category.SUBCLASS),
        Classification("02.3", "Gathering of wild growing non-wood products", Category.GROUP),
        Classification("02.30", "Gathering of wild growing non-wood products", Category.CLASS),
        Classification("02.300", "Gathering of wild growing non-wood products", Category.SUBCLASS),
        Classification("02.4", "Support services to forestry", Category.GROUP),
        Classification("02.40", "Support services to forestry", Category.CLASS),
        Classification("02.400", "Support services to forestry", Category.SUBCLASS),
        Classification("03", "Fishing and aquaculture", Category.DIVISION),
        Classification("03.1", "Fishing", Category.GROUP),
        Classification("03.11", "Marine fishing", Category.CLASS),
        Classification("03.110", "Marine fishing", Category.SUBCLASS),
        Classification("03.12", "Freshwater fishing", Category.CLASS),
        Classification("03.120", "Freshwater fishing", Category.SUBCLASS),
        Classification("03.2", "Aquaculture", Category.GROUP),
        Classification("03.21", "Marine aquaculture", Category.CLASS),
        Classification("03.210", "Marine aquaculture", Category.SUBCLASS),
        Classification("03.22", "Freshwater aquaculture", Category.CLASS),
        Classification("03.220", "Freshwater aquaculture", Category.SUBCLASS),
        Classification("B", "MINING AND QUARRYING", Category.SECTION),
        Classification("05", "Mining of coal and lignite", Category.DIVISION),
        Classification("05.1", "Mining of hard coal", Category.GROUP),
        Classification("05.10", "Mining of hard coal", Category.CLASS),
        Classification("05.100", "Mining of hard coal", Category.SUBCLASS),
        Classification("05.2", "Mining of lignite", Category.GROUP),
        Classification("05.20", "Mining of lignite", Category.CLASS),
        Classification("05.200", "Mining of lignite", Category.SUBCLASS),
        Classification("06", "Extraction of crude petroleum and natural gas", Category.DIVISION),
        Classification("06.1", "Extraction of crude petroleum", Category.GROUP),
        Classification("06.10", "Extraction of crude petroleum", Category.CLASS),
        Classification("06.100", "Extraction of crude petroleum", Category.SUBCLASS),
        Classification("06.2", "Extraction of natural gas", Category.GROUP),
        Classification("06.20", "Extraction of natural gas", Category.CLASS),
        Classification("06.200", "Extraction of natural gas", Category.SUBCLASS),
        Classification("07", "Mining of metal ores", Category.DIVISION),
        Classification("07.1", "Mining of iron ores", Category.GROUP),
        Classification("07.10", "Mining of iron ores", Category.CLASS),
        Classification("07.100", "Mining of iron ores", Category.SUBCLASS),
        Classification("07.2", "Mining of non-ferrous metal ores", Category.GROUP),
        Classification("07.21", "Mining of uranium and thorium ores", Category.CLASS),
        Classification("07.210", "Mining of uranium and thorium ores", Category.SUBCLASS),
        Classification("07.29", "Mining of other non-ferrous metal ores", Category.CLASS),
        Classification("07.290", "Mining of other non-ferrous metal ores", Category.SUBCLASS),
        Classification("08", "Other mining and quarrying", Category.DIVISION),
        Classification("08.1", "Quarrying of stone, sand and clay", Category.GROUP),
        Classification(
            "08.11", "Quarrying of ornamental and building stone, limestone, gypsum, chalk and slate", Category.CLASS
        ),
        Classification(
            "08.110",
            "Quarrying of ornamental and building stone, limestone, gypsum, chalk and slate",
            Category.SUBCLASS,
        ),
        Classification("08.12", "Operation of gravel and sand pits, mining of clays and kaolin", Category.CLASS),
        Classification("08.120", "Operation of gravel and sand pits, mining of clays and kaolin", Category.SUBCLASS),
        Classification("08.9", "Mining and quarrying n.e.c.", Category.GROUP),
        Classification("08.91", "Mining of chemical and fertilizer minerals", Category.CLASS),
        Classification("08.910", "Mining of chemical and fertilizer minerals", Category.SUBCLASS),
        Classification("08.92", "Extraction of peat", Category.CLASS),
        Classification("08.920", "Extraction of peat", Category.SUBCLASS),
        Classification("08.93", "Extraction of salt", Category.CLASS),
        Classification("08.930", "Extraction of salt", Category.SUBCLASS),
        Classification("08.99", "Other mining and quarrying n.e.c.", Category.CLASS),
        Classification("08.990", "Other mining and quarrying n.e.c.", Category.SUBCLASS),
        Classification("09", "Mining support service activities", Category.DIVISION),
        Classification("09.1", "Support activities for petroleum and natural gas mining", Category.GROUP),
        Classification("09.10", "Support activities for petroleum and natural gas mining", Category.CLASS),
        Classification("09.100", "Support activities for petroleum and natural gas mining", Category.SUBCLASS),
        Classification("09.9", "Support activities for other mining and quarrying", Category.GROUP),
        Classification("09.90", "Support activities for other mining and quarrying", Category.CLASS),
        Classification("09.900", "Support activities for other mining and quarrying", Category.SUBCLASS),
        Classification("C", "MANUFACTURING", Category.SECTION),
        Classification("10", "Manufacture of food products", Category.DIVISION),
        Classification("10.1", "Processing and preserving of meat and production of meat products", Category.GROUP),
        Classification("10.11", "Processing and preserving of meat", Category.CLASS),
        Classification("10.110", "Processing and preserving of meat", Category.SUBCLASS),
        Classification("10.12", "Processing and preserving of poultry meat", Category.CLASS),
        Classification("10.120", "Processing and preserving of poultry meat", Category.SUBCLASS),
        Classification("10.13", "Production of meat and poultry meat products", Category.CLASS),
        Classification("10.130", "Production of meat and poultry meat products", Category.SUBCLASS),
        Classification("10.2", "Processing and preserving of fish, crustaceans and molluscs", Category.GROUP),
        Classification("10.20", "Processing and preserving of fish, crustaceans and molluscs", Category.CLASS),
        Classification("10.200", "Processing and preserving of fish, crustaceans and molluscs", Category.SUBCLASS),
        Classification("10.3", "Processing and preserving of fruit and vegetables", Category.GROUP),
        Classification("10.31", "Processing and preserving of potatoes", Category.CLASS),
        Classification("10.310", "Processing and preserving of potatoes", Category.SUBCLASS),
        Classification("10.32", "Manufacture of fruit and vegetable juice", Category.CLASS),
        Classification("10.320", "Manufacture of fruit and vegetable juice", Category.SUBCLASS),
        Classification("10.39", "Other processing and preserving of fruit and vegetables", Category.CLASS),
        Classification("10.390", "Other processing and preserving of fruit and vegetables", Category.SUBCLASS),
        Classification("10.4", "Manufacture of vegetable and animal oils and fats", Category.GROUP),
        Classification("10.41", "Manufacture of oils and fats", Category.CLASS),
        Classification("10.410", "Manufacture of oils and fats", Category.SUBCLASS),
        Classification("10.42", "Manufacture of margarine and similar edible fats", Category.CLASS),
        Classification("10.420", "Manufacture of margarine and similar edible fats", Category.SUBCLASS),
        Classification("10.5", "Manufacture of dairy products", Category.GROUP),
        Classification("10.51", "Operation of dairies and cheese making", Category.CLASS),
        Classification("10.510", "Operation of dairies and cheese making", Category.SUBCLASS),
        Classification("10.52", "Manufacture of ice cream", Category.CLASS),
        Classification("10.520", "Manufacture of ice cream", Category.SUBCLASS),
        Classification("10.6", "Manufacture of grain mill products, starches and starch products", Category.GROUP),
        Classification("10.61", "Manufacture of grain mill products", Category.CLASS),
        Classification("10.610", "Manufacture of grain mill products", Category.SUBCLASS),
        Classification("10.62", "Manufacture of starches and starch products", Category.CLASS),
        Classification("10.620", "Manufacture of starches and starch products", Category.SUBCLASS),
        Classification("10.7", "Manufacture of bakery and farinaceous products", Category.GROUP),
        Classification("10.71", "Manufacture of bread, manufacture of fresh pastry goods and cakes", Category.CLASS),
        Classification(
            "10.710", "Manufacture of bread, manufacture of fresh pastry goods and cakes", Category.SUBCLASS
        ),
        Classification(
            "10.72",
            "Manufacture of rusks and biscuits, manufacture of preserved pastry goods and cakes",
            Category.CLASS,
        ),
        Classification(
            "10.720",
            "Manufacture of rusks and biscuits, manufacture of preserved pastry goods and cakes",
            Category.CLASS,
        ),
        Classification(
            "10.73", "Manufacture of macaroni, noodles, couscous and similar farinaceous products", Category.CLASS
        ),
        Classification(
            "10.730", "Manufacture of macaroni, noodles, couscous and similar farinaceous products", Category.SUBCLASS
        ),
        Classification("10.8", "Manufacture of other food products", Category.GROUP),
        Classification("10.81", "Manufacture of sugar", Category.CLASS),
        Classification("10.810", "Manufacture of sugar", Category.SUBCLASS),
        Classification("10.82", "Manufacture of cocoa, chocolate and sugar confectionery", Category.CLASS),
        Classification("10.820", "Manufacture of cocoa, chocolate and sugar confectionery", Category.SUBCLASS),
        Classification("10.83", "Processing of tea and coffee", Category.CLASS),
        Classification("10.830", "Processing of tea and coffee", Category.SUBCLASS),
        Classification("10.84", "Manufacture of condiments and seasonings", Category.CLASS),
        Classification("10.840", "Manufacture of condiments and seasonings", Category.SUBCLASS),
        Classification("10.85", "Manufacture of prepared meals and dishes", Category.CLASS),
        Classification("10.850", "Manufacture of prepared meals and dishes", Category.SUBCLASS),
        Classification("10.86", "Manufacture of homogenised food preparations and dietetic food", Category.CLASS),
        Classification("10.860", "Manufacture of homogenised food preparations and dietetic food", Category.SUBCLASS),
        Classification("10.89", "Manufacture of other food products n.e.c.", Category.CLASS),
        Classification("10.890", "Manufacture of other food products n.e.c.", Category.SUBCLASS),
        Classification("10.9", "Manufacture of prepared animal feeds", Category.GROUP),
        Classification("10.91", "Manufacture of prepared feeds for farm animals", Category.CLASS),
        Classification("10.910", "Manufacture of prepared feeds for farm animals", Category.SUBCLASS),
        Classification("10.92", "Manufacture of prepared pet foods", Category.CLASS),
        Classification("10.920", "Manufacture of prepared pet foods", Category.SUBCLASS),
        Classification("11", "Manufacture of beverages", Category.DIVISION),
        Classification("11.0", "Manufacture of beverages", Category.GROUP),
        Classification("11.01", "Distilling, rectifying and blending of spirits", Category.CLASS),
        Classification("11.010", "Distilling, rectifying and blending of spirits", Category.SUBCLASS),
        Classification("11.02", "Manufacture of wine from grape", Category.CLASS),
        Classification("11.020", "Manufacture of wine from grape", Category.SUBCLASS),
        Classification("11.03", "Manufacture of cider and other fruit wines", Category.CLASS),
        Classification("11.030", "Manufacture of cider and other fruit wines", Category.SUBCLASS),
        Classification("11.04", "Manufacture of other non-distilled fermented beverages", Category.CLASS),
        Classification("11.040", "Manufacture of other non-distilled fermented beverages", Category.SUBCLASS),
        Classification("11.05", "Manufacture of beer", Category.CLASS),
        Classification("11.050", "Manufacture of beer", Category.SUBCLASS),
        Classification("11.06", "Manufacture of malt", Category.CLASS),
        Classification("11.060", "Manufacture of malt", Category.SUBCLASS),
        Classification(
            "11.07", "Manufacture of soft drinks, production of mineral waters and other bottled waters", Category.CLASS
        ),
        Classification(
            "11.070",
            "Manufacture of soft drinks, production of mineral waters and other bottled waters",
            Category.CLASS,
        ),
        Classification("12", "Manufacture of tobacco products", Category.DIVISION),
        Classification("12.0", "Manufacture of tobacco products", Category.GROUP),
        Classification("12.00", "Manufacture of tobacco products", Category.CLASS),
        Classification("12.000", "Manufacture of tobacco products", Category.SUBCLASS),
        Classification("13", "Manufacture of textiles", Category.DIVISION),
        Classification("13.1", "Preparation and spinning of textile fibres", Category.GROUP),
        Classification("13.10", "Preparation and spinning of textile fibres", Category.CLASS),
        Classification("13.100", "Preparation and spinning of textile fibres", Category.SUBCLASS),
        Classification("13.2", "Weaving of textiles", Category.GROUP),
        Classification("13.20", "Weaving of textiles", Category.CLASS),
        Classification("13.200", "Weaving of textiles", Category.SUBCLASS),
        Classification("13.3", "Finishing of textiles", Category.GROUP),
        Classification("13.30", "Finishing of textiles", Category.CLASS),
        Classification("13.300", "Finishing of textiles", Category.SUBCLASS),
        Classification("13.9", "Manufacture of other textiles", Category.GROUP),
        Classification("13.91", "Manufacture of knitted and crocheted fabrics", Category.CLASS),
        Classification("13.910", "Manufacture of knitted and crocheted fabrics", Category.SUBCLASS),
        Classification("13.92", "Manufacture of made-up textile articles, except apparel", Category.CLASS),
        Classification("13.920", "Manufacture of made-up textile articles, except apparel", Category.SUBCLASS),
        Classification("13.93", "Manufacture of carpets and rugs", Category.CLASS),
        Classification("13.930", "Manufacture of carpets and rugs", Category.SUBCLASS),
        Classification("13.94", "Manufacture of cordage, rope, twine and netting", Category.CLASS),
        Classification("13.940", "Manufacture of cordage, rope, twine and netting", Category.SUBCLASS),
        Classification(
            "13.95", "Manufacture of non-wovens and articles made from non-wovens, except apparel", Category.CLASS
        ),
        Classification(
            "13.950", "Manufacture of non-wovens and articles made from non-wovens, except apparel", Category.SUBCLASS
        ),
        Classification("13.96", "Manufacture of other technical and industrial textiles", Category.CLASS),
        Classification("13.960", "Manufacture of other technical and industrial textiles", Category.SUBCLASS),
        Classification("13.99", "Manufacture of other textiles n.e.c.", Category.CLASS),
        Classification("13.990", "Manufacture of other textiles n.e.c.", Category.SUBCLASS),
        Classification("14", "Manufacture of wearing apparel", Category.DIVISION),
        Classification("14.1", "Manufacture of wearing apparel, except fur apparel", Category.GROUP),
        Classification("14.11", "Manufacture of leather clothes", Category.CLASS),
        Classification("14.110", "Manufacture of leather clothes", Category.SUBCLASS),
        Classification("14.12", "Manufacture of workwear", Category.CLASS),
        Classification("14.120", "Manufacture of workwear", Category.SUBCLASS),
        Classification("14.13", "Manufacture of other outerwear", Category.CLASS),
        Classification("14.130", "Manufacture of other outerwear", Category.SUBCLASS),
        Classification("14.14", "Manufacture of underwear", Category.CLASS),
        Classification("14.140", "Manufacture of underwear", Category.SUBCLASS),
        Classification("14.19", "Manufacture of other wearing apparel and accessories", Category.CLASS),
        Classification("14.190", "Manufacture of other wearing apparel and accessories", Category.SUBCLASS),
        Classification("14.2", "Manufacture of articles of fur", Category.GROUP),
        Classification("14.20", "Manufacture of articles of fur", Category.CLASS),
        Classification("14.200", "Manufacture of articles of fur", Category.SUBCLASS),
        Classification("14.3", "Manufacture of knitted and crocheted apparel", Category.GROUP),
        Classification("14.31", "Manufacture of knitted and crocheted hosiery", Category.CLASS),
        Classification("14.310", "Manufacture of knitted and crocheted hosiery", Category.SUBCLASS),
        Classification("14.39", "Manufacture of other knitted and crocheted apparel", Category.CLASS),
        Classification("14.390", "Manufacture of other knitted and crocheted apparel", Category.SUBCLASS),
        Classification("15", "Manufacture of leather and related products", Category.DIVISION),
        Classification(
            "15.1",
            "Tanning and dressing of leather, manufacture of luggage, handbags, saddlery and harness, dressing and dyeing of fur",
            Category.GROUP,
        ),
        Classification("15.11", "Tanning and dressing of leather, dressing and dyeing of fur", Category.CLASS),
        Classification("15.110", "Tanning and dressing of leather, dressing and dyeing of fur", Category.SUBCLASS),
        Classification("15.12", "Manufacture of luggage, handbags and the like, saddlery and harness", Category.CLASS),
        Classification(
            "15.120", "Manufacture of luggage, handbags and the like, saddlery and harness", Category.SUBCLASS
        ),
        Classification("15.2", "Manufacture of footwear", Category.GROUP),
        Classification("15.20", "Manufacture of footwear", Category.CLASS),
        Classification("15.200", "Manufacture of footwear", Category.SUBCLASS),
        Classification(
            "16",
            "Manufacture of wood and of products of wood and cork, except furniture, manufacture of articles of straw and plaiting materials",
            Category.DIVISION,
        ),
        Classification("16.1", "Sawmilling and planing of wood", Category.GROUP),
        Classification("16.10", "Sawmilling and planing of wood", Category.CLASS),
        Classification("16.100", "Sawmilling and planing of wood", Category.SUBCLASS),
        Classification("16.2", "Manufacture of products of wood, cork, straw and plaiting materials", Category.GROUP),
        Classification("16.21", "Manufacture of veneer sheets and wood-based panels", Category.CLASS),
        Classification("16.210", "Manufacture of veneer sheets and wood-based panels", Category.SUBCLASS),
        Classification("16.22", "Manufacture of assembled parquet floors", Category.CLASS),
        Classification("16.220", "Manufacture of assembled parquet floors", Category.SUBCLASS),
        Classification("16.23", "Manufacture of other builders' carpentry and joinery", Category.CLASS),
        Classification("16.230", "Manufacture of other builders' carpentry and joinery", Category.SUBCLASS),
        Classification("16.24", "Manufacture of wooden containers", Category.CLASS),
        Classification("16.240", "Manufacture of wooden containers", Category.SUBCLASS),
        Classification(
            "16.29",
            "Manufacture of other products of wood, manufacture of articles of cork, straw and plaiting materials",
            Category.CLASS,
        ),
        Classification(
            "16.290",
            "Manufacture of other products of wood, manufacture of articles of cork, straw and plaiting materials",
            Category.CLASS,
        ),
        Classification("17", "Manufacture of paper and paper products", Category.DIVISION),
        Classification("17.1", "Manufacture of pulp, paper and paperboard", Category.GROUP),
        Classification("17.11", "Manufacture of pulp", Category.CLASS),
        Classification("17.110", "Manufacture of pulp", Category.SUBCLASS),
        Classification("17.12", "Manufacture of paper and paperboard", Category.CLASS),
        Classification("17.120", "Manufacture of paper and paperboard", Category.SUBCLASS),
        Classification("17.2", "Manufacture of articles of paper and paperboard", Category.GROUP),
        Classification(
            "17.21",
            "Manufacture of corrugated paper and paperboard and of containers of paper and paperboard",
            Category.CLASS,
        ),
        Classification(
            "17.210",
            "Manufacture of corrugated paper and paperboard and of containers of paper and paperboard",
            Category.CLASS,
        ),
        Classification("17.22", "Manufacture of household and sanitary goods and of toilet requisites", Category.CLASS),
        Classification(
            "17.220", "Manufacture of household and sanitary goods and of toilet requisites", Category.SUBCLASS
        ),
        Classification("17.23", "Manufacture of paper stationery", Category.CLASS),
        Classification("17.230", "Manufacture of paper stationery", Category.SUBCLASS),
        Classification("17.24", "Manufacture of wallpaper", Category.CLASS),
        Classification("17.240", "Manufacture of wallpaper", Category.SUBCLASS),
        Classification("17.29", "Manufacture of other articles of paper and paperboard", Category.CLASS),
        Classification("17.290", "Manufacture of other articles of paper and paperboard", Category.SUBCLASS),
        Classification("18", "Printing and reproduction of recorded media", Category.DIVISION),
        Classification("18.1", "Printing and service activities related to printing", Category.GROUP),
        Classification("18.11", "Printing of newspapers", Category.CLASS),
        Classification("18.110", "Printing of newspapers", Category.SUBCLASS),
        Classification("18.12", "Other printing", Category.CLASS),
        Classification("18.120", "Other printing", Category.SUBCLASS),
        Classification("18.13", "Pre-press and pre-media services", Category.CLASS),
        Classification("18.130", "Pre-press and pre-media services", Category.SUBCLASS),
        Classification("18.14", "Binding and related services", Category.CLASS),
        Classification("18.140", "Binding and related services", Category.SUBCLASS),
        Classification("18.2", "Reproduction of recorded media", Category.GROUP),
        Classification("18.20", "Reproduction of recorded media", Category.CLASS),
        Classification("18.200", "Reproduction of recorded media", Category.SUBCLASS),
        Classification("19", "Manufacture of coke and refined petroleum products", Category.DIVISION),
        Classification("19.1", "Manufacture of coke oven products", Category.GROUP),
        Classification("19.10", "Manufacture of coke oven products", Category.CLASS),
        Classification("19.100", "Manufacture of coke oven products", Category.SUBCLASS),
        Classification("19.2", "Manufacture of refined petroleum products", Category.GROUP),
        Classification("19.20", "Manufacture of refined petroleum products", Category.CLASS),
        Classification("19.200", "Manufacture of refined petroleum products", Category.SUBCLASS),
        Classification("20", "Manufacture of chemicals and chemical products", Category.DIVISION),
        Classification(
            "20.1",
            "Manufacture of basic chemicals, fertilizers and nitrogen compounds, plastics and synthetic rubber in primary forms",
            Category.GROUP,
        ),
        Classification("20.11", "Manufacture of industrial gases", Category.CLASS),
        Classification("20.110", "Manufacture of industrial gases", Category.SUBCLASS),
        Classification("20.12", "Manufacture of dyes and pigments", Category.CLASS),
        Classification("20.120", "Manufacture of dyes and pigments", Category.SUBCLASS),
        Classification("20.13", "Manufacture of other inorganic basic chemicals", Category.CLASS),
        Classification("20.130", "Manufacture of other inorganic basic chemicals", Category.SUBCLASS),
        Classification("20.14", "Manufacture of other organic basic chemicals", Category.CLASS),
        Classification("20.140", "Manufacture of other organic basic chemicals", Category.SUBCLASS),
        Classification("20.15", "Manufacture of fertilizers and nitrogen compounds", Category.CLASS),
        Classification("20.150", "Manufacture of fertilizers and nitrogen compounds", Category.SUBCLASS),
        Classification("20.16", "Manufacture of plastics in primary forms", Category.CLASS),
        Classification("20.160", "Manufacture of plastics in primary forms", Category.SUBCLASS),
        Classification("20.17", "Manufacture of synthetic rubber in primary forms", Category.CLASS),
        Classification("20.170", "Manufacture of synthetic rubber in primary forms", Category.SUBCLASS),
        Classification("20.2", "Manufacture of pesticides and other agrochemical products", Category.GROUP),
        Classification("20.20", "Manufacture of pesticides and other agrochemical products", Category.CLASS),
        Classification("20.200", "Manufacture of pesticides and other agrochemical products", Category.SUBCLASS),
        Classification(
            "20.3", "Manufacture of paints, varnishes and similar coatings, printing ink and mastics", Category.GROUP
        ),
        Classification(
            "20.30", "Manufacture of paints, varnishes and similar coatings, printing ink and mastics", Category.CLASS
        ),
        Classification(
            "20.300",
            "Manufacture of paints, varnishes and similar coatings, printing ink and mastics",
            Category.SUBCLASS,
        ),
        Classification(
            "20.4",
            "Manufacture of soap and detergents, cleaning and polishing preparations, perfumes and toilet preparations",
            Category.GROUP,
        ),
        Classification(
            "20.41", "Manufacture of soap and detergents, cleaning and polishing preparations", Category.CLASS
        ),
        Classification(
            "20.410", "Manufacture of soap and detergents, cleaning and polishing preparations", Category.SUBCLASS
        ),
        Classification("20.42", "Manufacture of perfumes and toilet preparations", Category.CLASS),
        Classification("20.420", "Manufacture of perfumes and toilet preparations", Category.SUBCLASS),
        Classification("20.5", "Manufacture of other chemical products", Category.GROUP),
        Classification("20.51", "Manufacture of explosives", Category.CLASS),
        Classification("20.510", "Manufacture of explosives", Category.SUBCLASS),
        Classification("20.52", "Manufacture of glues", Category.CLASS),
        Classification("20.520", "Manufacture of glues", Category.SUBCLASS),
        Classification("20.53", "Manufacture of essential oils", Category.CLASS),
        Classification("20.530", "Manufacture of essential oils", Category.SUBCLASS),
        Classification("20.59", "Manufacture of other chemical products n.e.c.", Category.CLASS),
        Classification("20.590", "Manufacture of other chemical products n.e.c.", Category.SUBCLASS),
        Classification("20.6", "Manufacture of man-made fibres", Category.GROUP),
        Classification("20.60", "Manufacture of man-made fibres", Category.CLASS),
        Classification("20.600", "Manufacture of man-made fibres", Category.SUBCLASS),
        Classification(
            "21", "Manufacture of basic pharmaceutical products and pharmaceutical preparations", Category.DIVISION
        ),
        Classification("21.1", "Manufacture of basic pharmaceutical products", Category.GROUP),
        Classification("21.10", "Manufacture of basic pharmaceutical products", Category.CLASS),
        Classification("21.100", "Manufacture of basic pharmaceutical products", Category.SUBCLASS),
        Classification("21.2", "Manufacture of pharmaceutical preparations", Category.GROUP),
        Classification("21.20", "Manufacture of pharmaceutical preparations", Category.CLASS),
        Classification("21.200", "Manufacture of pharmaceutical preparations", Category.SUBCLASS),
        Classification("22", "Manufacture of rubber and plastic products", Category.DIVISION),
        Classification("22.1", "Manufacture of rubber products", Category.GROUP),
        Classification(
            "22.11", "Manufacture of rubber tyres and tubes, retreading and rebuilding of rubber tyres", Category.CLASS
        ),
        Classification(
            "22.110",
            "Manufacture of rubber tyres and tubes, retreading and rebuilding of rubber tyres",
            Category.SUBCLASS,
        ),
        Classification("22.19", "Manufacture of other rubber products", Category.CLASS),
        Classification("22.190", "Manufacture of other rubber products", Category.SUBCLASS),
        Classification("22.2", "Manufacture of plastics products", Category.GROUP),
        Classification("22.21", "Manufacture of plastic plates, sheets, tubes and profiles", Category.CLASS),
        Classification("22.210", "Manufacture of plastic plates, sheets, tubes and profiles", Category.SUBCLASS),
        Classification("22.22", "Manufacture of plastic packing goods", Category.CLASS),
        Classification("22.220", "Manufacture of plastic packing goods", Category.SUBCLASS),
        Classification("22.23", "Manufacture of builders’ ware of plastic", Category.CLASS),
        Classification("22.230", "Manufacture of builders’ ware of plastic", Category.SUBCLASS),
        Classification("22.29", "Manufacture of other plastic products", Category.CLASS),
        Classification("22.290", "Manufacture of other plastic products", Category.SUBCLASS),
        Classification("23", "Manufacture of other non-metallic mineral products", Category.DIVISION),
        Classification("23.1", "Manufacture of glass and glass products", Category.GROUP),
        Classification("23.11", "Manufacture of flat glass", Category.CLASS),
        Classification("23.110", "Manufacture of flat glass", Category.SUBCLASS),
        Classification("23.12", "Shaping and processing of flat glass", Category.CLASS),
        Classification("23.120", "Shaping and processing of flat glass", Category.SUBCLASS),
        Classification("23.13", "Manufacture of hollow glass", Category.CLASS),
        Classification("23.130", "Manufacture of hollow glass", Category.SUBCLASS),
        Classification("23.14", "Manufacture of glass fibres", Category.CLASS),
        Classification("23.140", "Manufacture of glass fibres", Category.SUBCLASS),
        Classification(
            "23.19", "Manufacture and processing of other glass, including technical glassware", Category.CLASS
        ),
        Classification(
            "23.190", "Manufacture and processing of other glass, including technical glassware", Category.SUBCLASS
        ),
        Classification("23.2", "Manufacture of refractory products", Category.GROUP),
        Classification("23.20", "Manufacture of refractory products", Category.CLASS),
        Classification("23.200", "Manufacture of refractory products", Category.SUBCLASS),
        Classification("23.3", "Manufacture of clay building materials", Category.GROUP),
        Classification("23.31", "Manufacture of ceramic tiles and flags", Category.CLASS),
        Classification("23.310", "Manufacture of ceramic tiles and flags", Category.SUBCLASS),
        Classification(
            "23.32", "Manufacture of bricks, tiles and construction products, in baked clay", Category.CLASS
        ),
        Classification(
            "23.320", "Manufacture of bricks, tiles and construction products, in baked clay", Category.SUBCLASS
        ),
        Classification("23.4", "Manufacture of other porcelain and ceramic products", Category.GROUP),
        Classification("23.41", "Manufacture of ceramic household and ornamental articles", Category.CLASS),
        Classification("23.410", "Manufacture of ceramic household and ornamental articles", Category.SUBCLASS),
        Classification("23.42", "Manufacture of ceramic sanitary fixtures", Category.CLASS),
        Classification("23.420", "Manufacture of ceramic sanitary fixtures", Category.SUBCLASS),
        Classification("23.43", "Manufacture of ceramic insulators and insulating fittings", Category.CLASS),
        Classification("23.430", "Manufacture of ceramic insulators and insulating fittings", Category.SUBCLASS),
        Classification("23.44", "Manufacture of other technical ceramic products", Category.CLASS),
        Classification("23.440", "Manufacture of other technical ceramic products", Category.SUBCLASS),
        Classification("23.49", "Manufacture of other ceramic products", Category.CLASS),
        Classification("23.490", "Manufacture of other ceramic products", Category.SUBCLASS),
        Classification("23.5", "Manufacture of cement, lime and plaster", Category.GROUP),
        Classification("23.51", "Manufacture of cement", Category.CLASS),
        Classification("23.510", "Manufacture of cement", Category.SUBCLASS),
        Classification("23.52", "Manufacture of lime and plaster", Category.CLASS),
        Classification("23.520", "Manufacture of lime and plaster", Category.SUBCLASS),
        Classification("23.6", "Manufacture of articles of concrete, cement and plaster", Category.GROUP),
        Classification("23.61", "Manufacture of concrete products for construction purposes", Category.CLASS),
        Classification("23.610", "Manufacture of concrete products for construction purposes", Category.SUBCLASS),
        Classification("23.62", "Manufacture of plaster products for construction purposes", Category.CLASS),
        Classification("23.620", "Manufacture of plaster products for construction purposes", Category.SUBCLASS),
        Classification("23.63", "Manufacture of ready-mixed concrete", Category.CLASS),
        Classification("23.630", "Manufacture of ready-mixed concrete", Category.SUBCLASS),
        Classification("23.64", "Manufacture of mortars", Category.CLASS),
        Classification("23.640", "Manufacture of mortars", Category.SUBCLASS),
        Classification("23.65", "Manufacture of fibre cement", Category.CLASS),
        Classification("23.650", "Manufacture of fibre cement", Category.SUBCLASS),
        Classification("23.69", "Manufacture of other articles of concrete, plaster and cement", Category.CLASS),
        Classification("23.690", "Manufacture of other articles of concrete, plaster and cement", Category.SUBCLASS),
        Classification("23.7", "Cutting, shaping and finishing of stone", Category.GROUP),
        Classification("23.70", "Cutting, shaping and finishing of stone", Category.CLASS),
        Classification("23.700", "Cutting, shaping and finishing of stone", Category.SUBCLASS),
        Classification(
            "23.9", "Manufacture of abrasive products and non-metallic mineral products n.e.c.", Category.GROUP
        ),
        Classification("23.91", "Production of abrasive products", Category.CLASS),
        Classification("23.910", "Production of abrasive products", Category.SUBCLASS),
        Classification("23.99", "Manufacture of other non-metallic mineral products n.e.c.", Category.CLASS),
        Classification("23.990", "Manufacture of other non-metallic mineral products n.e.c.", Category.SUBCLASS),
        Classification("24", "Manufacture of basic metals", Category.DIVISION),
        Classification("24.1", "Manufacture of basic iron and steel and of ferro-alloys", Category.GROUP),
        Classification("24.10", "Manufacture of basic iron and steel and of ferro-alloys", Category.CLASS),
        Classification("24.100", "Manufacture of basic iron and steel and of ferro-alloys", Category.SUBCLASS),
        Classification(
            "24.2", "Manufacture of tubes, pipes, hollow profiles and related fittings, of steel", Category.GROUP
        ),
        Classification(
            "24.20", "Manufacture of tubes, pipes, hollow profiles and related fittings, of steel", Category.CLASS
        ),
        Classification(
            "24.200", "Manufacture of tubes, pipes, hollow profiles and related fittings, of steel", Category.SUBCLASS
        ),
        Classification("24.3", "Manufacture of other products of first processing of steel", Category.GROUP),
        Classification("24.31", "Cold drawing of bars", Category.CLASS),
        Classification("24.310", "Cold drawing of bars", Category.SUBCLASS),
        Classification("24.32", "Cold rolling of narrow strip", Category.CLASS),
        Classification("24.320", "Cold rolling of narrow strip", Category.SUBCLASS),
        Classification("24.33", "Cold forming or folding", Category.CLASS),
        Classification("24.330", "Cold forming or folding", Category.SUBCLASS),
        Classification("24.34", "Cold drawing of wire", Category.CLASS),
        Classification("24.340", "Cold drawing of wire", Category.SUBCLASS),
        Classification("24.4", "Manufacture of basic precious and other non-ferrous metals", Category.GROUP),
        Classification("24.41", "Precious metals production", Category.CLASS),
        Classification("24.410", "Precious metals production", Category.SUBCLASS),
        Classification("24.42", "Aluminium production", Category.CLASS),
        Classification("24.420", "Aluminium production", Category.SUBCLASS),
        Classification("24.43", "Lead, zinc and tin production", Category.CLASS),
        Classification("24.430", "Lead, zinc and tin production", Category.SUBCLASS),
        Classification("24.44", "Copper production", Category.CLASS),
        Classification("24.440", "Copper production", Category.SUBCLASS),
        Classification("24.45", "Other non-ferrous metal production", Category.CLASS),
        Classification("24.450", "Other non-ferrous metal production", Category.SUBCLASS),
        Classification("24.46", "Processing of nuclear fuel", Category.CLASS),
        Classification("24.460", "Processing of nuclear fuel", Category.SUBCLASS),
        Classification("24.5", "Casting of metals", Category.GROUP),
        Classification("24.51", "Casting of iron", Category.CLASS),
        Classification("24.510", "Casting of iron", Category.SUBCLASS),
        Classification("24.52", "Casting of steel", Category.CLASS),
        Classification("24.520", "Casting of steel", Category.SUBCLASS),
        Classification("24.53", "Casting of light metals", Category.CLASS),
        Classification("24.530", "Casting of light metals", Category.SUBCLASS),
        Classification("24.54", "Casting of other non-ferrous metals", Category.CLASS),
        Classification("24.540", "Casting of other non-ferrous metals", Category.SUBCLASS),
        Classification(
            "25", "Manufacture of fabricated metal products, except machinery and equipment", Category.DIVISION
        ),
        Classification("25.1", "Manufacture of structural metal products", Category.GROUP),
        Classification("25.11", "Manufacture of metal structures and parts of structures", Category.CLASS),
        Classification("25.110", "Manufacture of metal structures and parts of structures", Category.SUBCLASS),
        Classification("25.12", "Manufacture of doors and windows of metal", Category.CLASS),
        Classification("25.120", "Manufacture of doors and windows of metal", Category.SUBCLASS),
        Classification("25.2", "Manufacture of tanks, reservoirs and containers of metal", Category.GROUP),
        Classification("25.21", "Manufacture of central heating radiators and boilers", Category.CLASS),
        Classification("25.210", "Manufacture of central heating radiators and boilers", Category.SUBCLASS),
        Classification("25.29", "Manufacture of other tanks, reservoirs and containers of metal", Category.CLASS),
        Classification("25.290", "Manufacture of other tanks, reservoirs and containers of metal", Category.SUBCLASS),
        Classification(
            "25.3", "Manufacture of steam generators, except central heating hot water boilers", Category.GROUP
        ),
        Classification(
            "25.30", "Manufacture of steam generators, except central heating hot water boilers", Category.CLASS
        ),
        Classification(
            "25.300", "Manufacture of steam generators, except central heating hot water boilers", Category.SUBCLASS
        ),
        Classification("25.4", "Manufacture of weapons and ammunition", Category.GROUP),
        Classification("25.40", "Manufacture of weapons and ammunition", Category.CLASS),
        Classification("25.400", "Manufacture of weapons and ammunition", Category.SUBCLASS),
        Classification(
            "25.5", "Forging, pressing, stamping and roll-forming of metal, powder metallurgy", Category.GROUP
        ),
        Classification(
            "25.50", "Forging, pressing, stamping and roll-forming of metal, powder metallurgy", Category.CLASS
        ),
        Classification(
            "25.500", "Forging, pressing, stamping and roll-forming of metal, powder metallurgy", Category.SUBCLASS
        ),
        Classification("25.6", "Treatment and coating of metals, machining", Category.GROUP),
        Classification("25.61", "Treatment and coating of metals", Category.CLASS),
        Classification("25.611", "Metallic coating of metals", Category.SUBCLASS),
        Classification("25.619", "Other coating and treatment of metals", Category.SUBCLASS),
        Classification("25.62", "Machining", Category.CLASS),
        Classification("25.620", "Machining", Category.SUBCLASS),
        Classification("25.7", "Manufacture of cutlery, tools and general hardware", Category.GROUP),
        Classification("25.71", "Manufacture of cutlery", Category.CLASS),
        Classification("25.710", "Manufacture of cutlery", Category.SUBCLASS),
        Classification("25.72", "Manufacture of locks and hinges", Category.CLASS),
        Classification("25.720", "Manufacture of locks and hinges", Category.SUBCLASS),
        Classification("25.73", "Manufacture of tools", Category.CLASS),
        Classification("25.731", "Manufacture of hand tools", Category.SUBCLASS),
        Classification("25.732", "Manufacture of other tools", Category.SUBCLASS),
        Classification("25.9", "Manufacture of other fabricated metal products", Category.GROUP),
        Classification("25.91", "Manufacture of steel drums and similar containers", Category.CLASS),
        Classification("25.910", "Manufacture of steel drums and similar containers", Category.SUBCLASS),
        Classification("25.92", "Manufacture of light metal packaging", Category.CLASS),
        Classification("25.920", "Manufacture of light metal packaging", Category.SUBCLASS),
        Classification("25.93", "Manufacture of wire products, chain and springs", Category.CLASS),
        Classification("25.930", "Manufacture of wire products, chain and springs", Category.SUBCLASS),
        Classification("25.94", "Manufacture of fasteners and screw machine products", Category.CLASS),
        Classification("25.940", "Manufacture of fasteners and screw machine products", Category.SUBCLASS),
        Classification("25.99", "Manufacture of other fabricated metal products n.e.c.", Category.CLASS),
        Classification("25.990", "Manufacture of other fabricated metal products n.e.c.", Category.SUBCLASS),
        Classification("26", "Manufacture of computer, electronic and optical products", Category.DIVISION),
        Classification("26.1", "Manufacture of electronic components and boards", Category.GROUP),
        Classification("26.11", "Manufacture of electronic components", Category.CLASS),
        Classification("26.110", "Manufacture of electronic components", Category.SUBCLASS),
        Classification("26.12", "Manufacture of loaded electronic boards", Category.CLASS),
        Classification("26.120", "Manufacture of loaded electronic boards", Category.SUBCLASS),
        Classification("26.2", "Manufacture of computers and peripheral equipment", Category.GROUP),
        Classification("26.20", "Manufacture of computers and peripheral equipment", Category.CLASS),
        Classification("26.200", "Manufacture of computers and peripheral equipment", Category.SUBCLASS),
        Classification("26.3", "Manufacture of communication equipment", Category.GROUP),
        Classification("26.30", "Manufacture of communication equipment", Category.CLASS),
        Classification("26.300", "Manufacture of communication equipment", Category.SUBCLASS),
        Classification("26.4", "Manufacture of consumer electronics", Category.GROUP),
        Classification("26.40", "Manufacture of consumer electronics", Category.CLASS),
        Classification("26.400", "Manufacture of consumer electronics", Category.SUBCLASS),
        Classification(
            "26.5",
            "Manufacture of instruments and appliances for measuring, testing and navigation, watches and clocks",
            Category.GROUP,
        ),
        Classification(
            "26.51", "Manufacture of instruments and appliances for measuring, testing and navigation", Category.CLASS
        ),
        Classification(
            "26.510",
            "Manufacture of instruments and appliances for measuring, testing and navigation",
            Category.SUBCLASS,
        ),
        Classification("26.52", "Manufacture of watches and clocks", Category.CLASS),
        Classification("26.520", "Manufacture of watches and clocks", Category.SUBCLASS),
        Classification(
            "26.6", "Manufacture of irradiation, electromedical and electrotherapeutic equipment", Category.GROUP
        ),
        Classification(
            "26.60", "Manufacture of irradiation, electromedical and electrotherapeutic equipment", Category.CLASS
        ),
        Classification(
            "26.600", "Manufacture of irradiation, electromedical and electrotherapeutic equipment", Category.SUBCLASS
        ),
        Classification("26.7", "Manufacture of optical instruments and photographic equipment", Category.GROUP),
        Classification("26.70", "Manufacture of optical instruments and photographic equipment", Category.CLASS),
        Classification("26.700", "Manufacture of optical instruments and photographic equipment", Category.SUBCLASS),
        Classification("26.8", "Manufacture of magnetic and optical media", Category.GROUP),
        Classification("26.80", "Manufacture of magnetic and optical media", Category.CLASS),
        Classification("26.800", "Manufacture of magnetic and optical media", Category.SUBCLASS),
        Classification("27", "Manufacture of electrical equipment", Category.DIVISION),
        Classification(
            "27.1",
            "Manufacture of electric motors, generators, transformers and electricity distribution and control apparatus",
            Category.GROUP,
        ),
        Classification("27.11", "Manufacture of electric motors, generators and transformers", Category.CLASS),
        Classification("27.110", "Manufacture of electric motors, generators and transformers", Category.SUBCLASS),
        Classification("27.12", "Manufacture of electricity distribution and control apparatus", Category.CLASS),
        Classification("27.120", "Manufacture of electricity distribution and control apparatus", Category.SUBCLASS),
        Classification("27.2", "Manufacture of batteries and accumulators", Category.GROUP),
        Classification("27.20", "Manufacture of batteries and accumulators", Category.CLASS),
        Classification("27.200", "Manufacture of batteries and accumulators", Category.SUBCLASS),
        Classification("27.3", "Manufacture of wiring and wiring devices", Category.GROUP),
        Classification("27.31", "Manufacture of fibre optic cables", Category.CLASS),
        Classification("27.310", "Manufacture of fibre optic cables", Category.SUBCLASS),
        Classification("27.32", "Manufacture of other electronic and electric wires and cables", Category.CLASS),
        Classification("27.320", "Manufacture of other electronic and electric wires and cables", Category.SUBCLASS),
        Classification("27.33", "Manufacture of wiring devices", Category.CLASS),
        Classification("27.330", "Manufacture of wiring devices", Category.SUBCLASS),
        Classification("27.4", "Manufacture of electric lighting equipment", Category.GROUP),
        Classification("27.40", "Manufacture of electric lighting equipment", Category.CLASS),
        Classification("27.400", "Manufacture of electric lighting equipment", Category.SUBCLASS),
        Classification("27.5", "Manufacture of domestic appliances", Category.GROUP),
        Classification("27.51", "Manufacture of electric domestic appliances", Category.CLASS),
        Classification("27.510", "Manufacture of electric domestic appliances", Category.SUBCLASS),
        Classification("27.52", "Manufacture of non-electric domestic appliances", Category.CLASS),
        Classification("27.520", "Manufacture of non-electric domestic appliances", Category.SUBCLASS),
        Classification("27.9", "Manufacture of other electrical equipment", Category.GROUP),
        Classification("27.90", "Manufacture of other electrical equipment", Category.CLASS),
        Classification("27.900", "Manufacture of other electrical equipment", Category.SUBCLASS),
        Classification("28", "Manufacture of machinery and equipment n.e.c.", Category.DIVISION),
        Classification("28.1", "Manufacture of general-purpose machinery", Category.GROUP),
        Classification(
            "28.11", "Manufacture of engines and turbines, except aircraft, vehicle and cycle engines", Category.CLASS
        ),
        Classification(
            "28.110",
            "Manufacture of engines and turbines, except aircraft, vehicle and cycle engines",
            Category.SUBCLASS,
        ),
        Classification("28.12", "Manufacture of fluid power equipment", Category.CLASS),
        Classification("28.120", "Manufacture of fluid power equipment", Category.SUBCLASS),
        Classification("28.13", "Manufacture of other pumps and compressors", Category.CLASS),
        Classification("28.130", "Manufacture of other pumps and compressors", Category.SUBCLASS),
        Classification("28.14", "Manufacture of other taps and valves", Category.CLASS),
        Classification("28.140", "Manufacture of other taps and valves", Category.SUBCLASS),
        Classification("28.15", "Manufacture of bearings, gears, gearing and driving elements", Category.CLASS),
        Classification("28.150", "Manufacture of bearings, gears, gearing and driving elements", Category.SUBCLASS),
        Classification("28.2", "Manufacture of other general-purpose machinery", Category.GROUP),
        Classification("28.21", "Manufacture of ovens, furnaces and furnace burners", Category.CLASS),
        Classification("28.210", "Manufacture of ovens, furnaces and furnace burners", Category.SUBCLASS),
        Classification("28.22", "Manufacture of lifting and handling equipment", Category.CLASS),
        Classification("28.220", "Manufacture of lifting and handling equipment", Category.SUBCLASS),
        Classification(
            "28.23",
            "Manufacture of office machinery and equipment (except computers and peripheral equipment)",
            Category.CLASS,
        ),
        Classification(
            "28.230",
            "Manufacture of office machinery and equipment (except computers and peripheral equipment)",
            Category.CLASS,
        ),
        Classification("28.24", "Manufacture of power-driven hand tools", Category.CLASS),
        Classification("28.240", "Manufacture of power-driven hand tools", Category.SUBCLASS),
        Classification("28.25", "Manufacture of non-domestic cooling and ventilation equipment", Category.CLASS),
        Classification("28.250", "Manufacture of non-domestic cooling and ventilation equipment", Category.SUBCLASS),
        Classification("28.29", "Manufacture of other general-purpose machinery n.e.c.", Category.CLASS),
        Classification("28.290", "Manufacture of other general-purpose machinery n.e.c.", Category.SUBCLASS),
        Classification("28.3", "Manufacture of agricultural and forestry machinery", Category.GROUP),
        Classification("28.30", "Manufacture of agricultural and forestry machinery", Category.CLASS),
        Classification("28.300", "Manufacture of agricultural and forestry machinery", Category.SUBCLASS),
        Classification("28.4", "Manufacture of metal forming machinery and machine tools", Category.GROUP),
        Classification("28.41", "Manufacture of metal forming machinery", Category.CLASS),
        Classification("28.410", "Manufacture of metal forming machinery", Category.SUBCLASS),
        Classification("28.49", "Manufacture of other machine tools", Category.CLASS),
        Classification("28.490", "Manufacture of other machine tools", Category.SUBCLASS),
        Classification("28.9", "Manufacture of other special-purpose machinery", Category.GROUP),
        Classification("28.91", "Manufacture of machinery for metallurgy", Category.CLASS),
        Classification("28.910", "Manufacture of machinery for metallurgy", Category.SUBCLASS),
        Classification("28.92", "Manufacture of machinery for mining, quarrying and construction", Category.CLASS),
        Classification("28.920", "Manufacture of machinery for mining, quarrying and construction", Category.SUBCLASS),
        Classification("28.93", "Manufacture of machinery for food, beverage and tobacco processing", Category.CLASS),
        Classification(
            "28.930", "Manufacture of machinery for food, beverage and tobacco processing", Category.SUBCLASS
        ),
        Classification("28.94", "Manufacture of machinery for textile, apparel and leather production", Category.CLASS),
        Classification(
            "28.940", "Manufacture of machinery for textile, apparel and leather production", Category.SUBCLASS
        ),
        Classification("28.95", "Manufacture of machinery for paper and paperboard production", Category.CLASS),
        Classification("28.950", "Manufacture of machinery for paper and paperboard production", Category.SUBCLASS),
        Classification("28.96", "Manufacture of plastics and rubber machinery", Category.CLASS),
        Classification("28.960", "Manufacture of plastics and rubber machinery", Category.SUBCLASS),
        Classification("28.99", "Manufacture of other special-purpose machinery n.e.c.", Category.CLASS),
        Classification("28.990", "Manufacture of other special-purpose machinery n.e.c.", Category.SUBCLASS),
        Classification("29", "Manufacture of motor vehicles, trailers and semi-trailers", Category.DIVISION),
        Classification("29.1", "Manufacture of motor vehicles", Category.GROUP),
        Classification("29.10", "Manufacture of motor vehicles", Category.CLASS),
        Classification("29.100", "Manufacture of motor vehicles", Category.SUBCLASS),
        Classification(
            "29.2",
            "Manufacture of bodies (coachwork) for motor vehicles, manufacture of trailers and semi-trailers",
            Category.GROUP,
        ),
        Classification(
            "29.20",
            "Manufacture of bodies (coachwork) for motor vehicles, manufacture of trailers and semi-trailers",
            Category.CLASS,
        ),
        Classification(
            "29.200",
            "Manufacture of bodies (coachwork) for motor vehicles, manufacture of trailers and semi-trailers",
            Category.CLASS,
        ),
        Classification("29.3", "Manufacture of parts and accessories for motor vehicles", Category.GROUP),
        Classification(
            "29.31", "Manufacture of electrical and electronic equipment for motor vehicles", Category.CLASS
        ),
        Classification(
            "29.310", "Manufacture of electrical and electronic equipment for motor vehicles", Category.SUBCLASS
        ),
        Classification("29.32", "Manufacture of other parts and accessories for motor vehicles", Category.CLASS),
        Classification("29.320", "Manufacture of other parts and accessories for motor vehicles", Category.SUBCLASS),
        Classification("30", "Manufacture of other transport equipment", Category.DIVISION),
        Classification("30.1", "Building of ships and boats", Category.GROUP),
        Classification("30.11", "Building of ships and floating structures", Category.CLASS),
        Classification("30.110", "Building of ships and floating structures", Category.SUBCLASS),
        Classification("30.12", "Building of pleasure and sporting boats", Category.CLASS),
        Classification("30.120", "Building of pleasure and sporting boats", Category.SUBCLASS),
        Classification("30.2", "Manufacture of railway locomotives and rolling stock", Category.GROUP),
        Classification("30.20", "Manufacture of railway locomotives and rolling stock", Category.CLASS),
        Classification("30.200", "Manufacture of railway locomotives and rolling stock", Category.SUBCLASS),
        Classification("30.3", "Manufacture of air and spacecraft and related machinery", Category.GROUP),
        Classification("30.30", "Manufacture of air and spacecraft and related machinery", Category.CLASS),
        Classification("30.300", "Manufacture of air and spacecraft and related machinery", Category.SUBCLASS),
        Classification("30.4", "Manufacture of military fighting vehicles", Category.GROUP),
        Classification("30.40", "Manufacture of military fighting vehicles", Category.CLASS),
        Classification("30.400", "Manufacture of military fighting vehicles", Category.SUBCLASS),
        Classification("30.9", "Manufacture of transport equipment n.e.c.", Category.GROUP),
        Classification("30.91", "Manufacture of motorcycles", Category.CLASS),
        Classification("30.910", "Manufacture of motorcycles", Category.SUBCLASS),
        Classification("30.92", "Manufacture of bicycles and invalid carriages", Category.CLASS),
        Classification("30.920", "Manufacture of bicycles and invalid carriages", Category.SUBCLASS),
        Classification("30.99", "Manufacture of other transport equipment n.e.c.", Category.CLASS),
        Classification("30.990", "Manufacture of other transport equipment n.e.c.", Category.SUBCLASS),
        Classification("31", "Manufacture of furniture", Category.DIVISION),
        Classification("31.0", "Manufacture of furniture", Category.GROUP),
        Classification("31.01", "Manufacture of office and shop furniture", Category.CLASS),
        Classification("31.010", "Manufacture of office and shop furniture", Category.SUBCLASS),
        Classification("31.02", "Manufacture of kitchen furniture", Category.CLASS),
        Classification("31.020", "Manufacture of kitchen furniture", Category.SUBCLASS),
        Classification("31.03", "Manufacture of mattresses", Category.CLASS),
        Classification("31.030", "Manufacture of mattresses", Category.SUBCLASS),
        Classification("31.09", "Manufacture of other furniture", Category.CLASS),
        Classification("31.090", "Manufacture of other furniture", Category.SUBCLASS),
        Classification("32", "Other manufacturing", Category.DIVISION),
        Classification("32.1", "Manufacture of jewellery, bijouterie and related articles", Category.GROUP),
        Classification("32.11", "Striking of coins", Category.CLASS),
        Classification("32.110", "Striking of coins", Category.SUBCLASS),
        Classification("32.12", "Manufacture of jewellery and related articles", Category.CLASS),
        Classification("32.120", "Manufacture of jewellery and related articles", Category.SUBCLASS),
        Classification("32.13", "Manufacture of imitation jewellery and related articles", Category.CLASS),
        Classification("32.130", "Manufacture of imitation jewellery and related articles", Category.SUBCLASS),
        Classification("32.2", "Manufacture of musical instruments", Category.GROUP),
        Classification("32.20", "Manufacture of musical instruments", Category.CLASS),
        Classification("32.200", "Manufacture of musical instruments", Category.SUBCLASS),
        Classification("32.3", "Manufacture of sports goods", Category.GROUP),
        Classification("32.30", "Manufacture of sports goods", Category.CLASS),
        Classification("32.300", "Manufacture of sports goods", Category.SUBCLASS),
        Classification("32.4", "Manufacture of games and toys", Category.GROUP),
        Classification("32.40", "Manufacture of games and toys", Category.CLASS),
        Classification("32.400", "Manufacture of games and toys", Category.SUBCLASS),
        Classification("32.5", "Manufacture of medical and dental instruments and supplies", Category.GROUP),
        Classification("32.50", "Manufacture of medical and dental instruments and supplies", Category.CLASS),
        Classification("32.500", "Manufacture of medical and dental instruments and supplies", Category.SUBCLASS),
        Classification("32.9", "Manufacturing n.e.c.", Category.GROUP),
        Classification("32.91", "Manufacture of brooms and brushes", Category.CLASS),
        Classification("32.910", "Manufacture of brooms and brushes", Category.SUBCLASS),
        Classification("32.99", "Other manufacturing n.e.c.", Category.CLASS),
        Classification("32.990", "Other manufacturing n.e.c.", Category.SUBCLASS),
        Classification("33", "Repair and installation of machinery and equipment", Category.DIVISION),
        Classification("33.1", "Repair of fabricated metal products, machinery and equipment", Category.GROUP),
        Classification("33.11", "Repair of fabricated metal products", Category.CLASS),
        Classification("33.110", "Repair of fabricated metal products", Category.SUBCLASS),
        Classification("33.12", "Repair of machinery", Category.CLASS),
        Classification("33.120", "Repair of machinery", Category.SUBCLASS),
        Classification("33.13", "Repair of electronic and optical equipment", Category.CLASS),
        Classification("33.130", "Repair of electronic and optical equipment", Category.SUBCLASS),
        Classification("33.14", "Repair of electrical equipment", Category.CLASS),
        Classification("33.140", "Repair of electrical equipment", Category.SUBCLASS),
        Classification("33.15", "Repair and maintenance of ships and boats", Category.CLASS),
        Classification("33.150", "Repair and maintenance of ships and boats", Category.SUBCLASS),
        Classification("33.16", "Repair and maintenance of aircraft and spacecraft", Category.CLASS),
        Classification("33.160", "Repair and maintenance of aircraft and spacecraft", Category.SUBCLASS),
        Classification("33.17", "Repair and maintenance of other transport equipment", Category.CLASS),
        Classification("33.170", "Repair and maintenance of other transport equipment", Category.SUBCLASS),
        Classification("33.19", "Repair of other equipment", Category.CLASS),
        Classification("33.190", "Repair of other equipment", Category.SUBCLASS),
        Classification("33.2", "Installation of industrial machinery and equipment", Category.GROUP),
        Classification("33.20", "Installation of industrial machinery and equipment", Category.CLASS),
        Classification("33.200", "Installation of industrial machinery and equipment", Category.SUBCLASS),
        Classification("D", "ELECTRICITY,  GAS, STEAM AND AIR CONDITIONING SUPPLY", Category.SECTION),
        Classification("35", "Electricity, gas, steam and air conditioning supply", Category.DIVISION),
        Classification("35.1", "Electric power generation, transmission and distribution", Category.GROUP),
        Classification("35.11", "Production of electricity", Category.CLASS),
        Classification("35.111", "Production of electricity in HE generation facilities", Category.SUBCLASS),
        Classification("35.112", "Production of electricity in thermal power stations", Category.SUBCLASS),
        Classification("35.119", "Other production of electricity", Category.SUBCLASS),
        Classification("35.12", "Transmission of electricity", Category.CLASS),
        Classification("35.120", "Transmission of electricity", Category.SUBCLASS),
        Classification("35.13", "Distribution of electricity", Category.CLASS),
        Classification("35.130", "Distribution of electricity", Category.SUBCLASS),
        Classification("35.14", "Trade of electricity", Category.CLASS),
        Classification("35.140", "Trade of electricity", Category.SUBCLASS),
        Classification("35.2", "Manufacture of gas, distribution of gaseous fuels through mains", Category.GROUP),
        Classification("35.21", "Manufacture of gas", Category.CLASS),
        Classification("35.210", "Manufacture of gas", Category.SUBCLASS),
        Classification("35.22", "Distribution of gaseous fuels through mains", Category.CLASS),
        Classification("35.220", "Distribution of gaseous fuels through mains", Category.SUBCLASS),
        Classification("35.23", "Trade of gas through mains", Category.CLASS),
        Classification("35.230", "Trade of gas through mains", Category.SUBCLASS),
        Classification("35.3", "Steam and air conditioning supply", Category.GROUP),
        Classification("35.30", "Steam and air conditioning supply", Category.CLASS),
        Classification("35.300", "Steam and air conditioning supply", Category.SUBCLASS),
        Classification("E", "WATER SUPPLY, SEWERAGE, WASTE MANAGEMENT AND REMEDIATION ACTIVITIES", Category.SECTION),
        Classification("36", "Water collection, treatment and supply", Category.DIVISION),
        Classification("36.0", "Water collection, treatment and supply", Category.GROUP),
        Classification("36.00", "Water collection, treatment and supply", Category.CLASS),
        Classification("36.000", "Water collection, treatment and supply", Category.SUBCLASS),
        Classification("37", "Sewerage", Category.DIVISION),
        Classification("37.0", "Sewerage", Category.GROUP),
        Classification("37.00", "Sewerage", Category.CLASS),
        Classification("37.000", "Sewerage", Category.SUBCLASS),
        Classification(
            "38", "Waste collection, treatment and disposal activities, materials recovery", Category.DIVISION
        ),
        Classification("38.1", "Waste collection", Category.GROUP),
        Classification("38.11", "Collection of non-hazardous waste", Category.CLASS),
        Classification("38.110", "Collection of non-hazardous waste", Category.SUBCLASS),
        Classification("38.12", "Collection of hazardous waste", Category.CLASS),
        Classification("38.120", "Collection of hazardous waste", Category.SUBCLASS),
        Classification("38.2", "Waste treatment and disposal", Category.GROUP),
        Classification("38.21", "Treatment and disposal of non-hazardous waste", Category.CLASS),
        Classification("38.210", "Treatment and disposal of non-hazardous waste", Category.SUBCLASS),
        Classification("38.22", "Treatment and disposal of hazardous waste", Category.CLASS),
        Classification("38.220", "Treatment and disposal of hazardous waste", Category.SUBCLASS),
        Classification("38.3", "Materials recovery", Category.GROUP),
        Classification("38.31", "Dismantling of wrecks", Category.CLASS),
        Classification("38.310", "Dismantling of wrecks", Category.SUBCLASS),
        Classification("38.32", "Recovery of sorted materials", Category.CLASS),
        Classification("38.320", "Recovery of sorted materials", Category.SUBCLASS),
        Classification("39", "Remediation activities and other waste management services", Category.DIVISION),
        Classification("39.0", "Remediation activities and other waste management services", Category.GROUP),
        Classification("39.00", "Remediation activities and other waste management services", Category.CLASS),
        Classification("39.000", "Remediation activities and other waste management services", Category.SUBCLASS),
        Classification("F", "CONSTRUCTION", Category.SECTION),
        Classification("41", "Construction of buildings", Category.DIVISION),
        Classification("41.1", "Development of building projects", Category.GROUP),
        Classification("41.10", "Development of building projects", Category.CLASS),
        Classification("41.100", "Development of building projects", Category.SUBCLASS),
        Classification("41.2", "Construction of residential and non-residential buildings", Category.GROUP),
        Classification("41.20", "Construction of residential and non-residential buildings", Category.CLASS),
        Classification("41.200", "Construction of residential and non-residential buildings", Category.SUBCLASS),
        Classification("42", "Civil engineering", Category.DIVISION),
        Classification("42.1", "Construction of roads and railways", Category.GROUP),
        Classification("42.11", "Construction of roads and motorways", Category.CLASS),
        Classification("42.110", "Construction of roads and motorways", Category.SUBCLASS),
        Classification("42.12", "Construction of railways and underground railways", Category.CLASS),
        Classification("42.120", "Construction of railways and underground railways", Category.SUBCLASS),
        Classification("42.13", "Construction of bridges and tunnels", Category.CLASS),
        Classification("42.130", "Construction of bridges and tunnels", Category.SUBCLASS),
        Classification("42.2", "Construction of utility projects", Category.GROUP),
        Classification("42.21", "Construction of utility projects for fluids", Category.CLASS),
        Classification("42.210", "Construction of utility projects for fluids", Category.SUBCLASS),
        Classification(
            "42.22", "Construction of utility projects for electricity and telecommunications", Category.CLASS
        ),
        Classification(
            "42.220", "Construction of utility projects for electricity and telecommunications", Category.SUBCLASS
        ),
        Classification("42.9", "Construction of other civil engineering projects", Category.GROUP),
        Classification("42.91", "Construction of water projects", Category.CLASS),
        Classification("42.910", "Construction of water projects", Category.SUBCLASS),
        Classification("42.99", "Construction of other civil engineering projects n.e.c.", Category.CLASS),
        Classification("42.990", "Construction of other civil engineering projects n.e.c.", Category.SUBCLASS),
        Classification("43", "Specialised construction activities", Category.DIVISION),
        Classification("43.1", "Demolition and site preparation", Category.GROUP),
        Classification("43.11", "Demolition", Category.CLASS),
        Classification("43.110", "Demolition", Category.SUBCLASS),
        Classification("43.12", "Site preparation", Category.CLASS),
        Classification("43.120", "Site preparation", Category.SUBCLASS),
        Classification("43.13", "Test drilling and boring", Category.CLASS),
        Classification("43.130", "Test drilling and boring", Category.SUBCLASS),
        Classification("43.2", "Electrical, plumbing and other construction installation activities", Category.GROUP),
        Classification("43.21", "Electrical installation", Category.CLASS),
        Classification("43.210", "Electrical installation", Category.SUBCLASS),
        Classification("43.22", "Plumbing, heat and air-conditioning installation", Category.CLASS),
        Classification("43.220", "Plumbing, heat and air-conditioning installation", Category.SUBCLASS),
        Classification("43.29", "Other construction installation", Category.CLASS),
        Classification("43.290", "Other construction installation", Category.SUBCLASS),
        Classification("43.3", "Building completion and finishing", Category.GROUP),
        Classification("43.31", "Plastering", Category.CLASS),
        Classification("43.310", "Plastering", Category.SUBCLASS),
        Classification("43.32", "Joinery installation", Category.CLASS),
        Classification("43.320", "Joinery installation", Category.SUBCLASS),
        Classification("43.33", "Floor and wall covering", Category.CLASS),
        Classification("43.330", "Floor and wall covering", Category.SUBCLASS),
        Classification("43.34", "Painting and glazing", Category.CLASS),
        Classification("43.341", "Glazing", Category.SUBCLASS),
        Classification("43.342", "Painting", Category.SUBCLASS),
        Classification("43.39", "Other building completion and finishing", Category.CLASS),
        Classification("43.390", "Other building completion and finishing", Category.SUBCLASS),
        Classification("43.9", "Other specialised construction activities", Category.GROUP),
        Classification("43.91", "Roofing activities", Category.CLASS),
        Classification("43.910", "Roofing activities", Category.SUBCLASS),
        Classification("43.99", "Other specialised construction activities n.e.c.", Category.CLASS),
        Classification("43.990", "Other specialised construction activities n.e.c.", Category.SUBCLASS),
        Classification("G", "WHOLESALE AND RETAIL TRADE, REPAIR OF MOTOR VEHICLES AND MOTORCYCLES", Category.SECTION),
        Classification(
            "45", "Wholesale and retail trade and repair of motor vehicles and motorcycles", Category.DIVISION
        ),
        Classification("45.1", "Sale of motor vehicles", Category.GROUP),
        Classification("45.11", "Sale of cars and light motor vehicles", Category.CLASS),
        Classification("45.110", "Sale of cars and light motor vehicles", Category.SUBCLASS),
        Classification("45.19", "Sale of other motor vehicles", Category.CLASS),
        Classification("45.190", "Sale of other motor vehicles", Category.SUBCLASS),
        Classification("45.2", "Maintenance and repair of motor vehicles", Category.GROUP),
        Classification("45.20", "Maintenance and repair of motor vehicles", Category.CLASS),
        Classification("45.200", "Maintenance and repair of motor vehicles", Category.SUBCLASS),
        Classification("45.3", "Sale of motor vehicle parts and accessories", Category.GROUP),
        Classification("45.31", "Wholesale trade of motor vehicle parts and accessories", Category.CLASS),
        Classification("45.310", "Wholesale trade of motor vehicle parts and accessories", Category.SUBCLASS),
        Classification("45.32", "Retail trade of motor vehicle parts and accessories", Category.CLASS),
        Classification("45.320", "Retail trade of motor vehicle parts and accessories", Category.SUBCLASS),
        Classification(
            "45.4", "Sale, maintenance and repair of motorcycles and related parts and accessories", Category.GROUP
        ),
        Classification(
            "45.40", "Sale, maintenance and repair of motorcycles and related parts and accessories", Category.CLASS
        ),
        Classification(
            "45.400", "Sale, maintenance and repair of motorcycles and related parts and accessories", Category.SUBCLASS
        ),
        Classification("46", "Wholesale trade, except of motor vehicles and motorcycles", Category.DIVISION),
        Classification("46.1", "Wholesale on a fee or contract basis", Category.GROUP),
        Classification(
            "46.11",
            "Agents involved in the sale of agricultural raw materials, live animals, textile raw materials and semi-finished goods",
            Category.CLASS,
        ),
        Classification(
            "46.110",
            "Agents involved in the sale of agricultural raw materials, live animals, textile raw materials and semi-finished goods",
            Category.CLASS,
        ),
        Classification(
            "46.12", "Agents involved in the sale of fuels, ores, metals and industrial chemicals", Category.CLASS
        ),
        Classification(
            "46.120", "Agents involved in the sale of fuels, ores, metals and industrial chemicals", Category.SUBCLASS
        ),
        Classification("46.13", "Agents involved in the sale of timber and building materials", Category.CLASS),
        Classification("46.130", "Agents involved in the sale of timber and building materials", Category.SUBCLASS),
        Classification(
            "46.14",
            "Agents involved in the sale of machinery, industrial equipment, ships and aircraft",
            Category.CLASS,
        ),
        Classification(
            "46.140",
            "Agents involved in the sale of machinery, industrial equipment, ships and aircraft",
            Category.CLASS,
        ),
        Classification(
            "46.15",
            "Agents involved in the sale of furniture, household goods, hardware and ironmongery",
            Category.CLASS,
        ),
        Classification(
            "46.150",
            "Agents involved in the sale of furniture, household goods, hardware and ironmongery",
            Category.CLASS,
        ),
        Classification(
            "46.16",
            "Agents involved in the sale of textiles, clothing, fur, footwear and leather goods",
            Category.CLASS,
        ),
        Classification(
            "46.160",
            "Agents involved in the sale of textiles, clothing, fur, footwear and leather goods",
            Category.CLASS,
        ),
        Classification("46.17", "Agents involved in the sale of food, beverages and tobacco", Category.CLASS),
        Classification("46.170", "Agents involved in the sale of food, beverages and tobacco", Category.SUBCLASS),
        Classification("46.18", "Agents specialised in the sale of other particular products", Category.CLASS),
        Classification("46.180", "Agents specialised in the sale of other particular products", Category.SUBCLASS),
        Classification("46.19", "Agents involved in the sale of a variety of goods", Category.CLASS),
        Classification("46.190", "Agents involved in the sale of a variety of goods", Category.SUBCLASS),
        Classification("46.2", "Wholesale of agricultural raw materials and live animals", Category.GROUP),
        Classification("46.21", "Wholesale of grain, unmanufactured tobacco, seeds and animal feeds", Category.CLASS),
        Classification(
            "46.210", "Wholesale of grain, unmanufactured tobacco, seeds and animal feeds", Category.SUBCLASS
        ),
        Classification("46.22", "Wholesale of flowers and plants", Category.CLASS),
        Classification("46.220", "Wholesale of flowers and plants", Category.SUBCLASS),
        Classification("46.23", "Wholesale of live animals", Category.CLASS),
        Classification("46.230", "Wholesale of live animals", Category.SUBCLASS),
        Classification("46.24", "Wholesale of hides, skins and leather", Category.CLASS),
        Classification("46.240", "Wholesale of hides, skins and leather", Category.SUBCLASS),
        Classification("46.3", "Wholesale of food, beverages and tobacco", Category.GROUP),
        Classification("46.31", "Wholesale of fruit and vegetables", Category.CLASS),
        Classification("46.310", "Wholesale of fruit and vegetables", Category.SUBCLASS),
        Classification("46.32", "Wholesale of meat and meat products", Category.CLASS),
        Classification("46.320", "Wholesale of meat and meat products", Category.SUBCLASS),
        Classification("46.33", "Wholesale of dairy products, eggs and edible oils and fats", Category.CLASS),
        Classification("46.330", "Wholesale of dairy products, eggs and edible oils and fats", Category.SUBCLASS),
        Classification("46.34", "Wholesale of beverages", Category.CLASS),
        Classification("46.340", "Wholesale of beverages", Category.SUBCLASS),
        Classification("46.35", "Wholesale of tobacco products", Category.CLASS),
        Classification("46.350", "Wholesale of tobacco products", Category.SUBCLASS),
        Classification("46.36", "Wholesale of sugar and chocolate and sugar confectionery", Category.CLASS),
        Classification("46.360", "Wholesale of sugar and chocolate and sugar confectionery", Category.SUBCLASS),
        Classification("46.37", "Wholesale of coffee, tea, cocoa and spices", Category.CLASS),
        Classification("46.370", "Wholesale of coffee, tea, cocoa and spices", Category.SUBCLASS),
        Classification("46.38", "Wholesale of other food, including fish, crustaceans and molluscs", Category.CLASS),
        Classification(
            "46.380", "Wholesale of other food, including fish, crustaceans and molluscs", Category.SUBCLASS
        ),
        Classification("46.39", "Non-specialised wholesale of food, beverages and tobacco", Category.CLASS),
        Classification("46.390", "Non-specialised wholesale of food, beverages and tobacco", Category.SUBCLASS),
        Classification("46.4", "Wholesale of household goods", Category.GROUP),
        Classification("46.41", "Wholesale of textiles", Category.CLASS),
        Classification("46.410", "Wholesale of textiles", Category.SUBCLASS),
        Classification("46.42", "Wholesale of clothing and footwear", Category.CLASS),
        Classification("46.420", "Wholesale of clothing and footwear", Category.SUBCLASS),
        Classification("46.43", "Wholesale of electrical household appliances", Category.CLASS),
        Classification("46.430", "Wholesale of electrical household appliances", Category.SUBCLASS),
        Classification("46.44", "Wholesale of china and glassware and cleaning materials", Category.CLASS),
        Classification("46.440", "Wholesale of china and glassware and cleaning materials", Category.SUBCLASS),
        Classification("46.45", "Wholesale of perfume and cosmetics", Category.CLASS),
        Classification("46.450", "Wholesale of perfume and cosmetics", Category.SUBCLASS),
        Classification("46.46", "Wholesale of pharmaceutical goods", Category.CLASS),
        Classification("46.460", "Wholesale of pharmaceutical goods", Category.SUBCLASS),
        Classification("46.47", "Wholesale of furniture, carpets and lighting equipment", Category.CLASS),
        Classification("46.470", "Wholesale of furniture, carpets and lighting equipment", Category.SUBCLASS),
        Classification("46.48", "Wholesale of watches and jewellery", Category.CLASS),
        Classification("46.480", "Wholesale of watches and jewellery", Category.SUBCLASS),
        Classification("46.49", "Wholesale of other household goods", Category.CLASS),
        Classification("46.490", "Wholesale of other household goods", Category.SUBCLASS),
        Classification("46.5", "Wholesale of information and communication equipment", Category.GROUP),
        Classification("46.51", "Wholesale of computers, computer peripheral equipment and software", Category.CLASS),
        Classification(
            "46.510", "Wholesale of computers, computer peripheral equipment and software", Category.SUBCLASS
        ),
        Classification("46.52", "Wholesale of electronic and telecommunications equipment and parts", Category.CLASS),
        Classification(
            "46.520", "Wholesale of electronic and telecommunications equipment and parts", Category.SUBCLASS
        ),
        Classification("46.6", "Wholesale of other machinery, equipment and supplies", Category.GROUP),
        Classification("46.61", "Wholesale of agricultural machinery, equipment and supplies", Category.CLASS),
        Classification("46.610", "Wholesale of agricultural machinery, equipment and supplies", Category.SUBCLASS),
        Classification("46.62", "Wholesale of machine tools", Category.CLASS),
        Classification("46.620", "Wholesale of machine tools", Category.SUBCLASS),
        Classification("46.63", "Wholesale of mining, construction and civil engineering machinery", Category.CLASS),
        Classification(
            "46.630", "Wholesale of mining, construction and civil engineering machinery", Category.SUBCLASS
        ),
        Classification(
            "46.64",
            "Wholesale of machinery for the textile industry and of sewing and knitting machines",
            Category.CLASS,
        ),
        Classification(
            "46.640",
            "Wholesale of machinery for the textile industry and of sewing and knitting machines",
            Category.CLASS,
        ),
        Classification("46.65", "Wholesale of office furniture", Category.CLASS),
        Classification("46.650", "Wholesale of office furniture", Category.SUBCLASS),
        Classification("46.66", "Wholesale of other office machinery and equipment", Category.CLASS),
        Classification("46.660", "Wholesale of other office machinery and equipment", Category.SUBCLASS),
        Classification("46.69", "Wholesale of other machinery and equipment", Category.CLASS),
        Classification("46.690", "Wholesale of other machinery and equipment", Category.SUBCLASS),
        Classification("46.7", "Other specialised wholesale", Category.GROUP),
        Classification("46.71", "Wholesale of solid, liquid and gaseous fuels and related products", Category.CLASS),
        Classification(
            "46.710", "Wholesale of solid, liquid and gaseous fuels and related products", Category.SUBCLASS
        ),
        Classification("46.72", "Wholesale of metals and metal ores", Category.CLASS),
        Classification("46.720", "Wholesale of metals and metal ores", Category.SUBCLASS),
        Classification("46.73", "Wholesale of wood, construction materials and sanitary equipment", Category.CLASS),
        Classification("46.730", "Wholesale of wood, construction materials and sanitary equipment", Category.SUBCLASS),
        Classification("46.74", "Wholesale of hardware, plumbing and heating equipment and supplies", Category.CLASS),
        Classification(
            "46.740", "Wholesale of hardware, plumbing and heating equipment and supplies", Category.SUBCLASS
        ),
        Classification("46.75", "Wholesale of chemical products", Category.CLASS),
        Classification("46.750", "Wholesale of chemical products", Category.SUBCLASS),
        Classification("46.76", "Wholesale of other intermediate products", Category.CLASS),
        Classification("46.760", "Wholesale of other intermediate products", Category.SUBCLASS),
        Classification("46.77", "Wholesale of waste and scrap", Category.CLASS),
        Classification("46.770", "Wholesale of waste and scrap", Category.SUBCLASS),
        Classification("46.9", "Non-specialised wholesale trade", Category.GROUP),
        Classification("46.90", "Non-specialised wholesale trade", Category.CLASS),
        Classification("46.900", "Non-specialised wholesale trade", Category.SUBCLASS),
        Classification("47", "Retail trade, except of motor vehicles and motorcycles", Category.DIVISION),
        Classification("47.1", "Retail sale in non-specialised stores", Category.GROUP),
        Classification(
            "47.11",
            "Retail sale in non-specialised stores with food, beverages or tobacco predominating",
            Category.CLASS,
        ),
        Classification(
            "47.110",
            "Retail sale in non-specialised stores with food, beverages or tobacco predominating",
            Category.CLASS,
        ),
        Classification("47.19", "Other retail sale in non-specialised stores", Category.CLASS),
        Classification("47.190", "Other retail sale in non-specialised stores", Category.SUBCLASS),
        Classification("47.2", "Retail sale of food, beverages and tobacco in specialised stores", Category.GROUP),
        Classification("47.21", "Retail sale of fruit and vegetables in specialised stores", Category.CLASS),
        Classification("47.210", "Retail sale of fruit and vegetables in specialised stores", Category.SUBCLASS),
        Classification("47.22", "Retail sale of meat and meat products in specialised stores", Category.CLASS),
        Classification("47.220", "Retail sale of meat and meat products in specialised stores", Category.SUBCLASS),
        Classification("47.23", "Retail sale of fish, crustaceans and molluscs in specialised stores", Category.CLASS),
        Classification(
            "47.230", "Retail sale of fish, crustaceans and molluscs in specialised stores", Category.SUBCLASS
        ),
        Classification(
            "47.24",
            "Retail sale of bread, cakes, flour confectionery and sugar confectionery in specialised stores",
            Category.CLASS,
        ),
        Classification(
            "47.240",
            "Retail sale of bread, cakes, flour confectionery and sugar confectionery in specialised stores",
            Category.CLASS,
        ),
        Classification("47.25", "Retail sale of beverages in specialised stores", Category.CLASS),
        Classification("47.250", "Retail sale of beverages in specialised stores", Category.SUBCLASS),
        Classification("47.26", "Retail sale of tobacco products in specialised stores", Category.CLASS),
        Classification("47.260", "Retail sale of tobacco products in specialised stores", Category.SUBCLASS),
        Classification("47.29", "Other retail sale of food in specialised stores", Category.CLASS),
        Classification("47.290", "Other retail sale of food in specialised stores", Category.SUBCLASS),
        Classification("47.3", "Retail sale of automotive fuel in specialised stores", Category.GROUP),
        Classification("47.30", "Retail sale of automotive fuel in specialised stores", Category.CLASS),
        Classification("47.301", "Retail sale of own automotive fuel in specialised stores", Category.SUBCLASS),
        Classification(
            "47.302", "Agents involved in retail sale of automotive fuel in specialised stores", Category.SUBCLASS
        ),
        Classification(
            "47.4", "Retail sale of information and communication equipment in specialised stores", Category.GROUP
        ),
        Classification(
            "47.41", "Retail sale of computers, peripheral units and software in specialised stores", Category.CLASS
        ),
        Classification(
            "47.410", "Retail sale of computers, peripheral units and software in specialised stores", Category.SUBCLASS
        ),
        Classification("47.42", "Retail sale of telecommunications equipment in specialised stores", Category.CLASS),
        Classification(
            "47.420", "Retail sale of telecommunications equipment in specialised stores", Category.SUBCLASS
        ),
        Classification("47.43", "Retail sale of audio and video equipment in specialised stores", Category.CLASS),
        Classification("47.430", "Retail sale of audio and video equipment in specialised stores", Category.SUBCLASS),
        Classification("47.5", "Retail sale of other household equipment in specialised stores", Category.GROUP),
        Classification("47.51", "Retail sale of textiles in specialised stores", Category.CLASS),
        Classification("47.510", "Retail sale of textiles in specialised stores", Category.SUBCLASS),
        Classification("47.52", "Retail sale of hardware, paints and glass in specialised stores", Category.CLASS),
        Classification("47.520", "Retail sale of hardware, paints and glass in specialised stores", Category.SUBCLASS),
        Classification(
            "47.53", "Retail sale of carpets, rugs, wall and floor coverings in specialised stores", Category.CLASS
        ),
        Classification(
            "47.530", "Retail sale of carpets, rugs, wall and floor coverings in specialised stores", Category.SUBCLASS
        ),
        Classification("47.54", "Retail sale of electrical household appliances in specialised stores", Category.CLASS),
        Classification(
            "47.540", "Retail sale of electrical household appliances in specialised stores", Category.SUBCLASS
        ),
        Classification(
            "47.59",
            "Retail sale of furniture, lighting equipment and other household articles in specialised stores",
            Category.CLASS,
        ),
        Classification(
            "47.590",
            "Retail sale of furniture, lighting equipment and other household articles in specialised stores",
            Category.CLASS,
        ),
        Classification("47.6", "Retail sale of cultural and recreation goods in specialised stores", Category.GROUP),
        Classification("47.61", "Retail sale of books in specialised stores", Category.CLASS),
        Classification("47.610", "Retail sale of books in specialised stores", Category.SUBCLASS),
        Classification("47.62", "Retail sale of newspapers and stationery in specialised stores", Category.CLASS),
        Classification("47.621", "Retail sale of newspapers in specialised stores", Category.SUBCLASS),
        Classification("47.622", "Retail sale of stationery in specialised stores", Category.SUBCLASS),
        Classification("47.63", "Retail sale of music and video recordings in specialised stores", Category.CLASS),
        Classification("47.630", "Retail sale of music and video recordings in specialised stores", Category.SUBCLASS),
        Classification("47.64", "Retail sale of sporting equipment in specialised stores", Category.CLASS),
        Classification("47.640", "Retail sale of sporting equipment in specialised stores", Category.SUBCLASS),
        Classification("47.65", "Retail sale of games and toys in specialised stores", Category.CLASS),
        Classification("47.650", "Retail sale of games and toys in specialised stores", Category.SUBCLASS),
        Classification("47.7", "Retail sale of other goods in specialised stores", Category.GROUP),
        Classification("47.71", "Retail sale of clothing in specialised stores", Category.CLASS),
        Classification("47.710", "Retail sale of clothing in specialised stores", Category.SUBCLASS),
        Classification("47.72", "Retail sale of footwear and leather goods in specialised stores", Category.CLASS),
        Classification("47.720", "Retail sale of footwear and leather goods in specialised stores", Category.SUBCLASS),
        Classification("47.73", "Dispensing chemist in specialised stores", Category.CLASS),
        Classification("47.730", "Dispensing chemist in specialised stores", Category.SUBCLASS),
        Classification("47.74", "Retail sale of medical and orthopaedic goods in specialised stores", Category.CLASS),
        Classification(
            "47.740", "Retail sale of medical and orthopaedic goods in specialised stores", Category.SUBCLASS
        ),
        Classification("47.75", "Retail sale of cosmetic and toilet articles in specialised stores", Category.CLASS),
        Classification(
            "47.750", "Retail sale of cosmetic and toilet articles in specialised stores", Category.SUBCLASS
        ),
        Classification(
            "47.76",
            "Retail sale of flowers, plants, seeds, fertilizers, pet animals and pet food in specialised stores",
            Category.CLASS,
        ),
        Classification("47.761", "Retail sale in florist's shops", Category.SUBCLASS),
        Classification(
            "47.762",
            "Retail sale of gardening material, pet animals and pet food in specialised stores",
            Category.CLASS,
        ),
        Classification("47.77", "Retail sale of watches and jewellery in specialised stores", Category.CLASS),
        Classification("47.770", "Retail sale of watches and jewellery in specialised stores", Category.SUBCLASS),
        Classification("47.78", "Other retail sale of new goods in specialised stores", Category.CLASS),
        Classification("47.781", "Activities of opticians", Category.SUBCLASS),
        Classification("47.782", "Retail sale services of commercial art galleries", Category.SUBCLASS),
        Classification("47.789", "Other retail sale of new goods in specialised stores n.e.c.", Category.SUBCLASS),
        Classification("47.79", "Retail sale of second-hand goods in stores", Category.CLASS),
        Classification("47.790", "Retail sale of second-hand goods in stores", Category.SUBCLASS),
        Classification("47.8", "Retail sale via stalls and markets", Category.GROUP),
        Classification(
            "47.81", "Retail sale via stalls and markets of food, beverages and tobacco products", Category.CLASS
        ),
        Classification(
            "47.810", "Retail sale via stalls and markets of food, beverages and tobacco products", Category.SUBCLASS
        ),
        Classification(
            "47.82", "Retail sale via stalls and markets of textiles, clothing and footwear", Category.CLASS
        ),
        Classification(
            "47.820", "Retail sale via stalls and markets of textiles, clothing and footwear", Category.SUBCLASS
        ),
        Classification("47.89", "Retail sale via stalls and markets of other goods", Category.CLASS),
        Classification("47.890", "Retail sale via stalls and markets of other goods", Category.SUBCLASS),
        Classification("47.9", "Retail trade not in stores, stalls or markets", Category.GROUP),
        Classification("47.91", "Retail sale via mail order houses or via Internet", Category.CLASS),
        Classification("47.910", "Retail sale via mail order houses or via Internet", Category.SUBCLASS),
        Classification("47.99", "Other retail sale not in stores, stalls or markets", Category.CLASS),
        Classification("47.990", "Other retail sale not in stores, stalls or markets", Category.SUBCLASS),
        Classification("H", "TRANSPORTATION AND STORAGE", Category.SECTION),
        Classification("49", "Land transport and transport via pipelines", Category.DIVISION),
        Classification("49.1", "Passenger rail transport, interurban", Category.GROUP),
        Classification("49.10", "Passenger rail transport, interurban", Category.CLASS),
        Classification("49.100", "Passenger rail transport, interurban", Category.SUBCLASS),
        Classification("49.2", "Freight rail transport", Category.GROUP),
        Classification("49.20", "Freight rail transport", Category.CLASS),
        Classification("49.200", "Freight rail transport", Category.SUBCLASS),
        Classification("49.3", "Other passenger land transport", Category.GROUP),
        Classification("49.31", "Urban and suburban passenger land transport", Category.CLASS),
        Classification("49.310", "Urban and suburban passenger land transport", Category.SUBCLASS),
        Classification("49.32", "Taxi operation", Category.CLASS),
        Classification("49.320", "Taxi operation", Category.SUBCLASS),
        Classification("49.39", "Other passenger land transport n.e.c.", Category.CLASS),
        Classification("49.391", "Interurban and other passenger road transport", Category.SUBCLASS),
        Classification("49.392", "Operation of teleferics, funiculars, ski and cable lifts", Category.SUBCLASS),
        Classification("49.4", "Freight transport by road and removal services", Category.GROUP),
        Classification("49.41", "Freight transport by road", Category.CLASS),
        Classification("49.410", "Freight transport by road", Category.SUBCLASS),
        Classification("49.42", "Removal services", Category.CLASS),
        Classification("49.420", "Removal services", Category.SUBCLASS),
        Classification("49.5", "Transport via pipeline", Category.GROUP),
        Classification("49.50", "Transport via pipeline", Category.CLASS),
        Classification("49.500", "Transport via pipeline", Category.SUBCLASS),
        Classification("50", "Water transport", Category.DIVISION),
        Classification("50.1", "Sea and coastal passenger water transport", Category.GROUP),
        Classification("50.10", "Sea and coastal passenger water transport", Category.CLASS),
        Classification("50.100", "Sea and coastal passenger water transport", Category.SUBCLASS),
        Classification("50.2", "Sea and coastal freight water transport", Category.GROUP),
        Classification("50.20", "Sea and coastal freight water transport", Category.CLASS),
        Classification("50.200", "Sea and coastal freight water transport", Category.SUBCLASS),
        Classification("50.3", "Inland passenger water transport", Category.GROUP),
        Classification("50.30", "Inland passenger water transport", Category.CLASS),
        Classification("50.300", "Inland passenger water transport", Category.SUBCLASS),
        Classification("50.4", "Inland freight water transport", Category.GROUP),
        Classification("50.40", "Inland freight water transport", Category.CLASS),
        Classification("50.400", "Inland freight water transport", Category.SUBCLASS),
        Classification("51", "Air transport", Category.DIVISION),
        Classification("51.1", "Passenger air transport", Category.GROUP),
        Classification("51.10", "Passenger air transport", Category.CLASS),
        Classification("51.100", "Passenger air transport", Category.SUBCLASS),
        Classification("51.2", "Freight air transport and space transport", Category.GROUP),
        Classification("51.21", "Freight air transport", Category.CLASS),
        Classification("51.210", "Freight air transport", Category.SUBCLASS),
        Classification("51.22", "Space transport", Category.CLASS),
        Classification("51.220", "Space transport", Category.SUBCLASS),
        Classification("52", "Warehousing and support activities for transportation", Category.DIVISION),
        Classification("52.1", "Warehousing and storage", Category.GROUP),
        Classification("52.10", "Warehousing and storage", Category.CLASS),
        Classification("52.100", "Warehousing and storage", Category.SUBCLASS),
        Classification("52.2", "Support activities for transportation", Category.GROUP),
        Classification("52.21", "Service activities incidental to land transportation", Category.CLASS),
        Classification("52.210", "Service activities incidental to land transportation", Category.SUBCLASS),
        Classification("52.22", "Service activities incidental to water transportation", Category.CLASS),
        Classification("52.220", "Service activities incidental to water transportation", Category.SUBCLASS),
        Classification("52.23", "Service activities incidental to air transportation", Category.CLASS),
        Classification("52.230", "Service activities incidental to air transportation", Category.SUBCLASS),
        Classification("52.24", "Cargo handling", Category.CLASS),
        Classification("52.240", "Cargo handling", Category.SUBCLASS),
        Classification("52.29", "Other transportation support activities", Category.CLASS),
        Classification("52.290", "Other transportation support activities", Category.SUBCLASS),
        Classification("53", "Postal and courier activities", Category.DIVISION),
        Classification("53.1", "Postal activities under universal service obligation", Category.GROUP),
        Classification("53.10", "Postal activities under universal service obligation", Category.CLASS),
        Classification("53.100", "Postal activities under universal service obligation", Category.SUBCLASS),
        Classification("53.2", "Other postal and courier activities", Category.GROUP),
        Classification("53.20", "Other postal and courier activities", Category.CLASS),
        Classification("53.200", "Other postal and courier activities", Category.SUBCLASS),
        Classification("I", "ACCOMMODATION AND FOOD SERVICE ACTIVITIES", Category.SECTION),
        Classification("55", "Accommodation", Category.DIVISION),
        Classification("55.1", "Hotels and similar accommodation", Category.GROUP),
        Classification("55.10", "Hotels and similar accommodation", Category.CLASS),
        Classification("55.100", "Hotels and similar accommodation", Category.SUBCLASS),
        Classification("55.2", "Holiday and other short stay accommodation", Category.GROUP),
        Classification("55.20", "Holiday and other short stay accommodation", Category.CLASS),
        Classification("55.201", "Children and other holiday homes", Category.SUBCLASS),
        Classification("55.202", "Tourist farm houses with lodging", Category.SUBCLASS),
        Classification("55.203", "Letting of private tourist rooms", Category.SUBCLASS),
        Classification("55.204", "Mountain refuges and youth hostels", Category.SUBCLASS),
        Classification("55.209", "Other short-stay accommodation", Category.SUBCLASS),
        Classification("55.3", "Camping grounds, recreational vehicle parks and trailer parks", Category.GROUP),
        Classification("55.30", "Camping grounds, recreational vehicle parks and trailer parks", Category.CLASS),
        Classification("55.300", "Camping grounds, recreational vehicle parks and trailer parks", Category.SUBCLASS),
        Classification("55.9", "Other accommodation", Category.GROUP),
        Classification("55.90", "Other accommodation", Category.CLASS),
        Classification("55.900", "Other accommodation", Category.SUBCLASS),
        Classification("56", "Food and beverage service activities", Category.DIVISION),
        Classification("56.1", "Restaurants and mobile food service activities", Category.GROUP),
        Classification("56.10", "Restaurants and mobile food service activities", Category.CLASS),
        Classification("56.101", "Restaurants and inns", Category.SUBCLASS),
        Classification("56.102", "Snack bars and similar", Category.SUBCLASS),
        Classification("56.103", "Sweetshops and coffee-houses", Category.SUBCLASS),
        Classification("56.104", "Provisory food-serving stands", Category.SUBCLASS),
        Classification("56.105", "Tourist farm houses without lodging", Category.SUBCLASS),
        Classification("56.2", "Event catering and other food services", Category.GROUP),
        Classification("56.21", "Event catering activities", Category.CLASS),
        Classification("56.210", "Event catering activities", Category.SUBCLASS),
        Classification("56.29", "Other food service activities", Category.CLASS),
        Classification("56.290", "Other food service activities", Category.SUBCLASS),
        Classification("56.3", "Beverage serving activities", Category.GROUP),
        Classification("56.30", "Beverage serving activities", Category.CLASS),
        Classification("56.300", "Beverage serving activities", Category.SUBCLASS),
        Classification("J", "INFORMATION AND COMMUNICATION", Category.SECTION),
        Classification("58", "Publishing activities", Category.DIVISION),
        Classification("58.1", "Publishing of books, periodicals and other publishing activities", Category.GROUP),
        Classification("58.11", "Book publishing", Category.CLASS),
        Classification("58.110", "Book publishing", Category.SUBCLASS),
        Classification("58.12", "Publishing of directories and mailing lists", Category.CLASS),
        Classification("58.120", "Publishing of directories and mailing lists", Category.SUBCLASS),
        Classification("58.13", "Publishing of newspapers", Category.CLASS),
        Classification("58.130", "Publishing of newspapers", Category.SUBCLASS),
        Classification("58.14", "Publishing of journals and periodicals", Category.CLASS),
        Classification("58.140", "Publishing of journals and periodicals", Category.SUBCLASS),
        Classification("58.19", "Other publishing activities", Category.CLASS),
        Classification("58.190", "Other publishing activities", Category.SUBCLASS),
        Classification("58.2", "Software publishing", Category.GROUP),
        Classification("58.21", "Publishing of computer games", Category.CLASS),
        Classification("58.210", "Publishing of computer games", Category.SUBCLASS),
        Classification("58.29", "Other software publishing", Category.CLASS),
        Classification("58.290", "Other software publishing", Category.SUBCLASS),
        Classification(
            "59",
            "Motion picture, video and television programme production, sound recording and music publishing activities",
            Category.DIVISION,
        ),
        Classification("59.1", "Motion picture, video and television programme activities", Category.GROUP),
        Classification("59.11", "Motion picture, video and television programme production activities", Category.CLASS),
        Classification(
            "59.110", "Motion picture, video and television programme production activities", Category.SUBCLASS
        ),
        Classification(
            "59.12", "Motion picture, video and television programme post-production activities", Category.CLASS
        ),
        Classification(
            "59.120", "Motion picture, video and television programme post-production activities", Category.SUBCLASS
        ),
        Classification(
            "59.13", "Motion picture, video and television programme distribution activities", Category.CLASS
        ),
        Classification(
            "59.130", "Motion picture, video and television programme distribution activities", Category.SUBCLASS
        ),
        Classification("59.14", "Motion picture projection activities", Category.CLASS),
        Classification("59.140", "Motion picture projection activities", Category.SUBCLASS),
        Classification("59.2", "Sound recording and music publishing activities", Category.GROUP),
        Classification("59.20", "Sound recording and music publishing activities", Category.CLASS),
        Classification("59.200", "Sound recording and music publishing activities", Category.SUBCLASS),
        Classification("60", "Programming and broadcasting activities", Category.DIVISION),
        Classification("60.1", "Radio broadcasting", Category.GROUP),
        Classification("60.10", "Radio broadcasting", Category.CLASS),
        Classification("60.100", "Radio broadcasting", Category.SUBCLASS),
        Classification("60.2", "Television programming and broadcasting activities", Category.GROUP),
        Classification("60.20", "Television programming and broadcasting activities", Category.CLASS),
        Classification("60.200", "Television programming and broadcasting activities", Category.SUBCLASS),
        Classification("61", "Telecommunications", Category.DIVISION),
        Classification("61.1", "Wired telecommunications activities", Category.GROUP),
        Classification("61.10", "Wired telecommunications activities", Category.CLASS),
        Classification("61.100", "Wired telecommunications activities", Category.SUBCLASS),
        Classification("61.2", "Wireless telecommunications activities", Category.GROUP),
        Classification("61.20", "Wireless telecommunications activities", Category.CLASS),
        Classification("61.200", "Wireless telecommunications activities", Category.SUBCLASS),
        Classification("61.3", "Satellite telecommunications activities", Category.GROUP),
        Classification("61.30", "Satellite telecommunications activities", Category.CLASS),
        Classification("61.300", "Satellite telecommunications activities", Category.SUBCLASS),
        Classification("61.9", "Other telecommunications activities", Category.GROUP),
        Classification("61.90", "Other telecommunications activities", Category.CLASS),
        Classification("61.900", "Other telecommunications activities", Category.SUBCLASS),
        Classification("62", "Computer programming, consultancy and related activities", Category.DIVISION),
        Classification("62.0", "Computer programming, consultancy and related activities", Category.GROUP),
        Classification("62.01", "Computer programming activities", Category.CLASS),
        Classification("62.010", "Computer programming activities", Category.SUBCLASS),
        Classification("62.02", "Computer consultancy activities", Category.CLASS),
        Classification("62.020", "Computer consultancy activities", Category.SUBCLASS),
        Classification("62.03", "Computer facilities management activities", Category.CLASS),
        Classification("62.030", "Computer facilities management activities", Category.SUBCLASS),
        Classification("62.09", "Other information technology and computer service activities", Category.CLASS),
        Classification("62.090", "Other information technology and computer service activities", Category.SUBCLASS),
        Classification("63", "Information service activities", Category.DIVISION),
        Classification("63.1", "Data processing, hosting and related activities, web portals", Category.GROUP),
        Classification("63.11", "Data processing, hosting and related activities", Category.CLASS),
        Classification("63.110", "Data processing, hosting and related activities", Category.SUBCLASS),
        Classification("63.12", "Web portals", Category.CLASS),
        Classification("63.120", "Web portals", Category.SUBCLASS),
        Classification("63.9", "Other information service activities", Category.GROUP),
        Classification("63.91", "News agency activities", Category.CLASS),
        Classification("63.910", "News agency activities", Category.SUBCLASS),
        Classification("63.99", "Other information service activities n.e.c.", Category.CLASS),
        Classification("63.990", "Other information service activities n.e.c.", Category.SUBCLASS),
        Classification("K", "FINANCIAL AND INSURANCE ACTIVITIES", Category.SECTION),
        Classification("64", "Financial service activities, except insurance and pension funding", Category.DIVISION),
        Classification("64.1", "Monetary intermediation", Category.GROUP),
        Classification("64.11", "Central banking", Category.CLASS),
        Classification("64.110", "Central banking", Category.SUBCLASS),
        Classification("64.19", "Other monetary intermediation", Category.CLASS),
        Classification("64.190", "Other monetary intermediation", Category.SUBCLASS),
        Classification("64.2", "Activities of holding companies", Category.GROUP),
        Classification("64.20", "Activities of holding companies", Category.CLASS),
        Classification("64.200", "Activities of holding companies", Category.SUBCLASS),
        Classification("64.3", "Trusts, funds and similar financial entities", Category.GROUP),
        Classification("64.30", "Trusts, funds and similar financial entities", Category.CLASS),
        Classification("64.300", "Trusts, funds and similar financial entities", Category.SUBCLASS),
        Classification(
            "64.9", "Other financial service activities, except insurance and pension funding", Category.GROUP
        ),
        Classification("64.91", "Financial leasing", Category.CLASS),
        Classification("64.910", "Financial leasing", Category.SUBCLASS),
        Classification("64.92", "Other credit granting", Category.CLASS),
        Classification("64.920", "Other credit granting", Category.SUBCLASS),
        Classification(
            "64.99", "Other financial service activities, except insurance and pension funding n.e.c.", Category.CLASS
        ),
        Classification(
            "64.990",
            "Other financial service activities, except insurance and pension funding n.e.c.",
            Category.SUBCLASS,
        ),
        Classification(
            "65", "Insurance, reinsurance and pension funding, except compulsory social security", Category.DIVISION
        ),
        Classification("65.1", "Insurance", Category.GROUP),
        Classification("65.11", "Life insurance", Category.CLASS),
        Classification("65.110", "Life insurance", Category.SUBCLASS),
        Classification("65.12", "Non-life insurance", Category.CLASS),
        Classification("65.120", "Non-life insurance", Category.SUBCLASS),
        Classification("65.2", "Reinsurance", Category.GROUP),
        Classification("65.20", "Reinsurance", Category.CLASS),
        Classification("65.200", "Reinsurance", Category.SUBCLASS),
        Classification("65.3", "Pension funding", Category.GROUP),
        Classification("65.30", "Pension funding", Category.CLASS),
        Classification("65.300", "Pension funding", Category.SUBCLASS),
        Classification("66", "Activities auxiliary to financial services and insurance activities", Category.DIVISION),
        Classification(
            "66.1", "Activities auxiliary to financial services, except insurance and pension funding", Category.GROUP
        ),
        Classification("66.11", "Administration of financial markets", Category.CLASS),
        Classification("66.110", "Administration of financial markets", Category.SUBCLASS),
        Classification("66.12", "Security and commodity contracts brokerage", Category.CLASS),
        Classification("66.120", "Security and commodity contracts brokerage", Category.SUBCLASS),
        Classification(
            "66.19",
            "Other activities auxiliary to financial services, except insurance and pension funding",
            Category.CLASS,
        ),
        Classification(
            "66.190",
            "Other activities auxiliary to financial services, except insurance and pension funding",
            Category.CLASS,
        ),
        Classification("66.2", "Activities auxiliary to insurance and pension funding", Category.GROUP),
        Classification("66.21", "Risk and damage evaluation", Category.CLASS),
        Classification("66.210", "Risk and damage evaluation", Category.SUBCLASS),
        Classification("66.22", "Activities of insurance agents and brokers", Category.CLASS),
        Classification("66.220", "Activities of insurance agents and brokers", Category.SUBCLASS),
        Classification("66.29", "Other activities auxiliary to insurance and pension funding", Category.CLASS),
        Classification("66.290", "Other activities auxiliary to insurance and pension funding", Category.SUBCLASS),
        Classification("66.3", "Fund management activities", Category.GROUP),
        Classification("66.30", "Fund management activities", Category.CLASS),
        Classification("66.300", "Fund management activities", Category.SUBCLASS),
        Classification("L", "REAL ESTATE ACTIVITIES", Category.SECTION),
        Classification("68", "Real estate activities", Category.DIVISION),
        Classification("68.1", "Buying and selling of own real estate", Category.GROUP),
        Classification("68.10", "Buying and selling of own real estate", Category.CLASS),
        Classification("68.100", "Buying and selling of own real estate", Category.SUBCLASS),
        Classification("68.2", "Renting and operating of own or leased real estate", Category.GROUP),
        Classification("68.20", "Renting and operating of own or leased real estate", Category.CLASS),
        Classification("68.200", "Renting and operating of own or leased real estate", Category.SUBCLASS),
        Classification("68.3", "Real estate activities on a fee or contract basis", Category.GROUP),
        Classification("68.31", "Real estate agencies", Category.CLASS),
        Classification("68.310", "Real estate agencies", Category.SUBCLASS),
        Classification("68.32", "Management of real estate on a fee or contract basis", Category.CLASS),
        Classification("68.320", "Management of real estate on a fee or contract basis", Category.SUBCLASS),
        Classification("M", "PROFESSIONAL, SCIENTIFIC AND TECHNICAL ACTIVITIES", Category.SECTION),
        Classification("69", "Legal and accounting activities", Category.DIVISION),
        Classification("69.1", "Legal activities", Category.GROUP),
        Classification("69.10", "Legal activities", Category.CLASS),
        Classification("69.101", "Legal representation", Category.SUBCLASS),
        Classification("69.102", "Activities of notaries public", Category.SUBCLASS),
        Classification("69.103", "Other legal activities", Category.SUBCLASS),
        Classification("69.2", "Accounting, bookkeeping and auditing activities, tax consultancy", Category.GROUP),
        Classification("69.20", "Accounting, bookkeeping and auditing activities, tax consultancy", Category.CLASS),
        Classification("69.200", "Accounting, bookkeeping and auditing activities, tax consultancy", Category.SUBCLASS),
        Classification("70", "Activities of head offices, management consultancy activities", Category.DIVISION),
        Classification("70.1", "Activities of head offices", Category.GROUP),
        Classification("70.10", "Activities of head offices", Category.CLASS),
        Classification("70.100", "Activities of head offices", Category.SUBCLASS),
        Classification("70.2", "Management consultancy activities", Category.GROUP),
        Classification("70.21", "Public relation and communication activities", Category.CLASS),
        Classification("70.210", "Public relation and communication activities", Category.SUBCLASS),
        Classification("70.22", "Business and other management consultancy activities", Category.CLASS),
        Classification("70.220", "Business and other management consultancy activities", Category.SUBCLASS),
        Classification(
            "71", "Architectural and engineering activities, technical testing and analysis", Category.DIVISION
        ),
        Classification(
            "71.1", "Architectural and engineering activities and related technical consultancy", Category.GROUP
        ),
        Classification("71.11", "Architectural activities", Category.CLASS),
        Classification("71.111", "Architectural planning", Category.SUBCLASS),
        Classification("71.112", "Landscape architecture, urban and other planning", Category.SUBCLASS),
        Classification("71.12", "Engineering activities and related technical consultancy", Category.CLASS),
        Classification("71.121", "Geo-engineering and related activities", Category.SUBCLASS),
        Classification("71.129", "Other engineering activities and related techical consultancy", Category.SUBCLASS),
        Classification("71.2", "Technical testing and analysis", Category.GROUP),
        Classification("71.20", "Technical testing and analysis", Category.CLASS),
        Classification("71.200", "Technical testing and analysis", Category.SUBCLASS),
        Classification("72", "Scientific research and development", Category.DIVISION),
        Classification(
            "72.1", "Research and experimental development on natural sciences and engineering", Category.GROUP
        ),
        Classification("72.11", "Research and experimental development on biotechnology", Category.CLASS),
        Classification("72.110", "Research and experimental development on biotechnology", Category.SUBCLASS),
        Classification(
            "72.19", "Other research and experimental development on natural sciences and engineering", Category.CLASS
        ),
        Classification(
            "72.190",
            "Other research and experimental development on natural sciences and engineering",
            Category.SUBCLASS,
        ),
        Classification(
            "72.2", "Research and experimental development on social sciences and humanities", Category.GROUP
        ),
        Classification(
            "72.20", "Research and experimental development on social sciences and humanities", Category.CLASS
        ),
        Classification(
            "72.200", "Research and experimental development on social sciences and humanities", Category.SUBCLASS
        ),
        Classification("73", "Advertising and market research", Category.DIVISION),
        Classification("73.1", "Advertising", Category.GROUP),
        Classification("73.11", "Advertising agencies", Category.CLASS),
        Classification("73.110", "Advertising agencies", Category.SUBCLASS),
        Classification("73.12", "Media representation", Category.CLASS),
        Classification("73.120", "Media representation", Category.SUBCLASS),
        Classification("73.2", "Market research and public opinion polling", Category.GROUP),
        Classification("73.20", "Market research and public opinion polling", Category.CLASS),
        Classification("73.200", "Market research and public opinion polling", Category.SUBCLASS),
        Classification("74", "Other professional, scientific and technical activities", Category.DIVISION),
        Classification("74.1", "Specialised design activities", Category.GROUP),
        Classification("74.10", "Specialised design activities", Category.CLASS),
        Classification("74.100", "Specialised design activities", Category.SUBCLASS),
        Classification("74.2", "Photographic activities", Category.GROUP),
        Classification("74.20", "Photographic activities", Category.CLASS),
        Classification("74.200", "Photographic activities", Category.SUBCLASS),
        Classification("74.3", "Translation and interpretation activities", Category.GROUP),
        Classification("74.30", "Translation and interpretation activities", Category.CLASS),
        Classification("74.300", "Translation and interpretation activities", Category.SUBCLASS),
        Classification("74.9", "Other professional, scientific and technical activities n.e.c.", Category.GROUP),
        Classification("74.90", "Other professional, scientific and technical activities n.e.c.", Category.CLASS),
        Classification("74.900", "Other professional, scientific and technical activities n.e.c.", Category.SUBCLASS),
        Classification("75", "Veterinary activities", Category.DIVISION),
        Classification("75.0", "Veterinary activities", Category.GROUP),
        Classification("75.00", "Veterinary activities", Category.CLASS),
        Classification("75.000", "Veterinary activities", Category.SUBCLASS),
        Classification("N", "ADMINISTRATIVE AND SUPPORT SERVICE ACTIVITIES", Category.SECTION),
        Classification("77", "Rental and leasing activities", Category.DIVISION),
        Classification("77.1", "Renting and leasing of motor vehicles", Category.GROUP),
        Classification("77.11", "Renting and leasing of cars and light motor vehicles", Category.CLASS),
        Classification("77.110", "Renting and leasing of cars and light motor vehicles", Category.SUBCLASS),
        Classification("77.12", "Renting and leasing of trucks", Category.CLASS),
        Classification("77.120", "Renting and leasing of trucks", Category.SUBCLASS),
        Classification("77.2", "Renting and leasing of personal and household goods", Category.GROUP),
        Classification("77.21", "Renting and leasing of recreational and sports goods", Category.CLASS),
        Classification("77.210", "Renting and leasing of recreational and sports goods", Category.SUBCLASS),
        Classification("77.22", "Renting of video tapes and disks", Category.CLASS),
        Classification("77.220", "Renting of video tapes and disks", Category.SUBCLASS),
        Classification("77.29", "Renting and leasing of other personal and household goods", Category.CLASS),
        Classification("77.290", "Renting and leasing of other personal and household goods", Category.SUBCLASS),
        Classification("77.3", "Renting and leasing of other machinery, equipment and tangible goods", Category.GROUP),
        Classification("77.31", "Renting and leasing of agricultural machinery and equipment", Category.CLASS),
        Classification("77.310", "Renting and leasing of agricultural machinery and equipment", Category.SUBCLASS),
        Classification(
            "77.32", "Renting and leasing of construction and civil engineering machinery and equipment", Category.CLASS
        ),
        Classification(
            "77.320",
            "Renting and leasing of construction and civil engineering machinery and equipment",
            Category.CLASS,
        ),
        Classification(
            "77.33", "Renting and leasing of office machinery and equipment (including computers)", Category.CLASS
        ),
        Classification(
            "77.330", "Renting and leasing of office machinery and equipment (including computers)", Category.SUBCLASS
        ),
        Classification("77.34", "Renting and leasing of water transport equipment", Category.CLASS),
        Classification("77.340", "Renting and leasing of water transport equipment", Category.SUBCLASS),
        Classification("77.35", "Renting and leasing of air transport equipment", Category.CLASS),
        Classification("77.350", "Renting and leasing of air transport equipment", Category.SUBCLASS),
        Classification(
            "77.39", "Renting and leasing of other machinery, equipment and tangible goods n.e.c.", Category.CLASS
        ),
        Classification(
            "77.390", "Renting and leasing of other machinery, equipment and tangible goods n.e.c.", Category.SUBCLASS
        ),
        Classification(
            "77.4", "Leasing of intellectual property and similar products, except copyrighted works", Category.GROUP
        ),
        Classification(
            "77.40", "Leasing of intellectual property and similar products, except copyrighted works", Category.CLASS
        ),
        Classification(
            "77.400",
            "Leasing of intellectual property and similar products, except copyrighted works",
            Category.SUBCLASS,
        ),
        Classification("78", "Employment activities", Category.DIVISION),
        Classification("78.1", "Activities of employment placement agencies", Category.GROUP),
        Classification("78.10", "Activities of employment placement agencies", Category.CLASS),
        Classification("78.100", "Activities of employment placement agencies", Category.SUBCLASS),
        Classification("78.2", "Temporary employment agency activities", Category.GROUP),
        Classification("78.20", "Temporary employment agency activities", Category.CLASS),
        Classification("78.200", "Temporary employment agency activities", Category.SUBCLASS),
        Classification("78.3", "Other human resources provision", Category.GROUP),
        Classification("78.30", "Other human resources provision", Category.CLASS),
        Classification("78.300", "Other human resources provision", Category.SUBCLASS),
        Classification(
            "79", "Travel agency, tour operator and other reservation service and related activities", Category.DIVISION
        ),
        Classification("79.1", "Travel agency and tour operator activities", Category.GROUP),
        Classification("79.11", "Travel agency activities", Category.CLASS),
        Classification("79.110", "Travel agency activities", Category.SUBCLASS),
        Classification("79.12", "Tour operator activities", Category.CLASS),
        Classification("79.120", "Tour operator activities", Category.SUBCLASS),
        Classification("79.9", "Other reservation service and related activities", Category.GROUP),
        Classification("79.90", "Other reservation service and related activities", Category.CLASS),
        Classification("79.900", "Other reservation service and related activities", Category.SUBCLASS),
        Classification("80", "Security and investigation activities", Category.DIVISION),
        Classification("80.1", "Private security activities", Category.GROUP),
        Classification("80.10", "Private security activities", Category.CLASS),
        Classification("80.100", "Private security activities", Category.SUBCLASS),
        Classification("80.2", "Security systems service activities", Category.GROUP),
        Classification("80.20", "Security systems service activities", Category.CLASS),
        Classification("80.200", "Security systems service activities", Category.SUBCLASS),
        Classification("80.3", "Investigation activities", Category.GROUP),
        Classification("80.30", "Investigation activities", Category.CLASS),
        Classification("80.300", "Investigation activities", Category.SUBCLASS),
        Classification("81", "Services to buildings and landscape activities", Category.DIVISION),
        Classification("81.1", "Combined facilities support activities", Category.GROUP),
        Classification("81.10", "Combined facilities support activities", Category.CLASS),
        Classification("81.100", "Combined facilities support activities", Category.SUBCLASS),
        Classification("81.2", "Cleaning activities", Category.GROUP),
        Classification("81.21", "General cleaning of buildings", Category.CLASS),
        Classification("81.210", "General cleaning of buildings", Category.SUBCLASS),
        Classification("81.22", "Other building and industrial cleaning activities", Category.CLASS),
        Classification("81.220", "Other building and industrial cleaning activities", Category.SUBCLASS),
        Classification("81.29", "Other cleaning activities", Category.CLASS),
        Classification("81.290", "Other cleaning activities", Category.SUBCLASS),
        Classification("81.3", "Landscape service activities", Category.GROUP),
        Classification("81.30", "Landscape service activities", Category.CLASS),
        Classification("81.300", "Landscape service activities", Category.SUBCLASS),
        Classification(
            "82", "Office administrative, office support and other business support activities", Category.DIVISION
        ),
        Classification("82.1", "Office administrative and support activities", Category.GROUP),
        Classification("82.11", "Combined office administrative service activities", Category.CLASS),
        Classification("82.110", "Combined office administrative service activities", Category.SUBCLASS),
        Classification(
            "82.19",
            "Photocopying, document preparation and other specialised office support activities",
            Category.CLASS,
        ),
        Classification(
            "82.190",
            "Photocopying, document preparation and other specialised office support activities",
            Category.CLASS,
        ),
        Classification("82.2", "Activities of call centres", Category.GROUP),
        Classification("82.20", "Activities of call centres", Category.CLASS),
        Classification("82.200", "Activities of call centres", Category.SUBCLASS),
        Classification("82.3", "Organisation of conventions and trade shows", Category.GROUP),
        Classification("82.30", "Organisation of conventions and trade shows", Category.CLASS),
        Classification("82.300", "Organisation of conventions and trade shows", Category.SUBCLASS),
        Classification("82.9", "Business support service activities n.e.c.", Category.GROUP),
        Classification("82.91", "Activities of collection agencies and credit bureaus", Category.CLASS),
        Classification("82.910", "Activities of collection agencies and credit bureaus", Category.SUBCLASS),
        Classification("82.92", "Packaging activities", Category.CLASS),
        Classification("82.920", "Packaging activities", Category.SUBCLASS),
        Classification("82.99", "Other business support service activities n.e.c.", Category.CLASS),
        Classification("82.990", "Other business support service activities n.e.c.", Category.SUBCLASS),
        Classification("O", "PUBLIC ADMINISTRATION AND DEFENCE, COMPULSORY SOCIAL SECURITY", Category.SECTION),
        Classification("84", "Public administration and defence, compulsory social security", Category.DIVISION),
        Classification(
            "84.1", "Administration of the State and the economic and social policy of the community", Category.GROUP
        ),
        Classification("84.11", "General public administration activities", Category.CLASS),
        Classification("84.110", "General public administration activities", Category.SUBCLASS),
        Classification(
            "84.12",
            "Regulation of the activities of providing health care, education, cultural services and other social services, excluding social security",
            Category.CLASS,
        ),
        Classification(
            "84.120",
            "Regulation of the activities of providing health care, education, cultural services and other social services, excluding social security",
            Category.CLASS,
        ),
        Classification(
            "84.13", "Regulation of and contribution to more efficient operation of businesses", Category.CLASS
        ),
        Classification(
            "84.130", "Regulation of and contribution to more efficient operation of businesses", Category.SUBCLASS
        ),
        Classification("84.2", "Provision of services to the community as a whole", Category.GROUP),
        Classification("84.21", "Foreign affairs", Category.CLASS),
        Classification("84.210", "Foreign affairs", Category.SUBCLASS),
        Classification("84.22", "Defence activities", Category.CLASS),
        Classification("84.220", "Defence activities", Category.SUBCLASS),
        Classification("84.23", "Justice and judicial activities", Category.CLASS),
        Classification("84.230", "Justice and judicial activities", Category.SUBCLASS),
        Classification("84.24", "Public order and safety activities", Category.CLASS),
        Classification("84.240", "Public order and safety activities", Category.SUBCLASS),
        Classification("84.25", "Fire service activities", Category.CLASS),
        Classification("84.250", "Fire service activities", Category.SUBCLASS),
        Classification("84.3", "Compulsory social security activities", Category.GROUP),
        Classification("84.30", "Compulsory social security activities", Category.CLASS),
        Classification("84.300", "Compulsory social security activities", Category.SUBCLASS),
        Classification("P", "EDUCATION", Category.SECTION),
        Classification("85", "Education", Category.DIVISION),
        Classification("85.1", "Pre-primary education", Category.GROUP),
        Classification("85.10", "Pre-primary education", Category.CLASS),
        Classification("85.100", "Pre-primary education", Category.SUBCLASS),
        Classification("85.2", "Primary education", Category.GROUP),
        Classification("85.20", "Primary education", Category.CLASS),
        Classification("85.200", "Primary education", Category.SUBCLASS),
        Classification("85.3", "Secondary education", Category.GROUP),
        Classification("85.31", "General secondary education", Category.CLASS),
        Classification("85.310", "General secondary education", Category.SUBCLASS),
        Classification("85.32", "Technical and vocational secondary education", Category.CLASS),
        Classification("85.320", "Technical and vocational secondary education", Category.SUBCLASS),
        Classification("85.4", "Higher education", Category.GROUP),
        Classification("85.41", "Post-secondary non-tertiary education", Category.CLASS),
        Classification("85.410", "Post-secondary non-tertiary education", Category.SUBCLASS),
        Classification("85.42", "Tertiary education", Category.CLASS),
        Classification("85.421", "First and second stages of tertiary education", Category.SUBCLASS),
        Classification("85.422", "Third stage of tertiary education", Category.SUBCLASS),
        Classification("85.5", "Other education", Category.GROUP),
        Classification("85.51", "Sports and recreation education", Category.CLASS),
        Classification("85.510", "Sports and recreation education", Category.SUBCLASS),
        Classification("85.52", "Cultural education", Category.CLASS),
        Classification("85.520", "Cultural education", Category.SUBCLASS),
        Classification("85.53", "Driving school activities", Category.CLASS),
        Classification("85.530", "Driving school activities", Category.SUBCLASS),
        Classification("85.59", "Other education n.e.c.", Category.CLASS),
        Classification("85.590", "Other education n.e.c.", Category.SUBCLASS),
        Classification("85.6", "Educational support activities", Category.GROUP),
        Classification("85.60", "Educational support activities", Category.CLASS),
        Classification("85.600", "Educational support activities", Category.SUBCLASS),
        Classification("Q", "HUMAN HEALTH AND SOCIAL WORK ACTIVITIES", Category.SECTION),
        Classification("86", "Human health activities", Category.DIVISION),
        Classification("86.1", "Hospital activities", Category.GROUP),
        Classification("86.10", "Hospital activities", Category.CLASS),
        Classification("86.100", "Hospital activities", Category.SUBCLASS),
        Classification("86.2", "Medical and dental practice activities", Category.GROUP),
        Classification("86.21", "General medical practice activities", Category.CLASS),
        Classification("86.210", "General medical practice activities", Category.SUBCLASS),
        Classification("86.22", "Specialist medical practice activities", Category.CLASS),
        Classification("86.220", "Specialist medical practice activities", Category.SUBCLASS),
        Classification("86.23", "Dental practice activities", Category.CLASS),
        Classification("86.230", "Dental practice activities", Category.SUBCLASS),
        Classification("86.9", "Other human health activities", Category.GROUP),
        Classification("86.90", "Other human health activities", Category.CLASS),
        Classification("86.901", "Alternative forms of medical treatment", Category.SUBCLASS),
        Classification("86.909", "Other human health activities n.e.c.", Category.SUBCLASS),
        Classification("87", "Residential care activities", Category.DIVISION),
        Classification("87.1", "Residential nursing care activities", Category.GROUP),
        Classification("87.10", "Residential nursing care activities", Category.CLASS),
        Classification("87.100", "Residential nursing care activities", Category.SUBCLASS),
        Classification(
            "87.2",
            "Residential care activities for mental retardation, mental health and substance abuse",
            Category.GROUP,
        ),
        Classification(
            "87.20",
            "Residential care activities for mental retardation, mental health and substance abuse",
            Category.CLASS,
        ),
        Classification(
            "87.200",
            "Residential care activities for mental retardation, mental health and substance abuse",
            Category.CLASS,
        ),
        Classification("87.3", "Residential care activities for the elderly and disabled", Category.GROUP),
        Classification("87.30", "Residential care activities for the elderly and disabled", Category.CLASS),
        Classification("87.300", "Residential care activities for the elderly and disabled", Category.SUBCLASS),
        Classification("87.9", "Other residential care activities", Category.GROUP),
        Classification("87.90", "Other residential care activities", Category.CLASS),
        Classification("87.900", "Other residential care activities", Category.SUBCLASS),
        Classification("88", "Social work activities without accommodation", Category.DIVISION),
        Classification(
            "88.1", "Social work activities without accommodation for the elderly and disabled", Category.GROUP
        ),
        Classification(
            "88.10", "Social work activities without accommodation for the elderly and disabled", Category.CLASS
        ),
        Classification("88.101", "Activity of enterprises employing disabled persons", Category.SUBCLASS),
        Classification(
            "88.109",
            "Other social work activities without accommodation for the elderly and disabled",
            Category.SUBCLASS,
        ),
        Classification("88.9", "Other social work activities without accommodation", Category.GROUP),
        Classification("88.91", "Child day-care activities", Category.CLASS),
        Classification("88.910", "Child day-care activities", Category.SUBCLASS),
        Classification("88.99", "Other social work activities without accommodation n.e.c.", Category.CLASS),
        Classification("88.991", "Activity of humanitarian and charitable organisations", Category.SUBCLASS),
        Classification("88.999", "Other social work activities without accommodation n.e.c.", Category.SUBCLASS),
        Classification("R", "ARTS, ENTERTAINMENT AND RECREATION", Category.SECTION),
        Classification("90", "Creative, arts and entertainment activities", Category.DIVISION),
        Classification("90.0", "Creative, arts and entertainment activities", Category.GROUP),
        Classification("90.01", "Performing arts", Category.CLASS),
        Classification("90.010", "Performing arts", Category.SUBCLASS),
        Classification("90.02", "Support activities to performing arts", Category.CLASS),
        Classification("90.020", "Support activities to performing arts", Category.SUBCLASS),
        Classification("90.03", "Artistic creation", Category.CLASS),
        Classification("90.030", "Artistic creation", Category.SUBCLASS),
        Classification("90.04", "Operation of arts facilities", Category.CLASS),
        Classification("90.040", "Operation of arts facilities", Category.SUBCLASS),
        Classification("91", "Libraries, archives, museums and other cultural activities", Category.DIVISION),
        Classification("91.0", "Libraries, archives, museums and other cultural activities", Category.GROUP),
        Classification("91.01", "Library and archives activities", Category.CLASS),
        Classification("91.011", "Library activities", Category.SUBCLASS),
        Classification("91.012", "Archives activities", Category.SUBCLASS),
        Classification("91.02", "Museums activities", Category.CLASS),
        Classification("91.020", "Museums activities", Category.SUBCLASS),
        Classification(
            "91.03", "Operation of historical sites and buildings and similar visitor attractions", Category.CLASS
        ),
        Classification(
            "91.030", "Operation of historical sites and buildings and similar visitor attractions", Category.SUBCLASS
        ),
        Classification("91.04", "Botanical and zoological gardens and nature reserves activities", Category.CLASS),
        Classification("91.040", "Botanical and zoological gardens and nature reserves activities", Category.SUBCLASS),
        Classification("92", "Gambling and betting activities", Category.DIVISION),
        Classification("92.0", "Gambling and betting activities", Category.GROUP),
        Classification("92.00", "Gambling and betting activities", Category.CLASS),
        Classification("92.001", "Activities of casinos", Category.SUBCLASS),
        Classification("92.002", "Other gambling and betting activities", Category.SUBCLASS),
        Classification("93", "Sports activities and amusement and recreation activities", Category.DIVISION),
        Classification("93.1", "Sports activities", Category.GROUP),
        Classification("93.11", "Operation of sports facilities", Category.CLASS),
        Classification("93.110", "Operation of sports facilities", Category.SUBCLASS),
        Classification("93.12", "Activities of sport clubs", Category.CLASS),
        Classification("93.120", "Activities of sport clubs", Category.SUBCLASS),
        Classification("93.13", "Fitness facilities", Category.CLASS),
        Classification("93.130", "Fitness facilities", Category.SUBCLASS),
        Classification("93.19", "Other sports activities", Category.CLASS),
        Classification("93.190", "Other sports activities", Category.SUBCLASS),
        Classification("93.2", "Other amusement and recreation activities", Category.GROUP),
        Classification("93.21", "Activities of amusement parks and theme parks", Category.CLASS),
        Classification("93.210", "Activities of amusement parks and theme parks", Category.SUBCLASS),
        Classification("93.29", "Other amusement and recreation activities n.e.c.", Category.CLASS),
        Classification("93.291", "Operation of marinas", Category.SUBCLASS),
        Classification("93.292", "Operation of ski hills", Category.SUBCLASS),
        Classification("93.299", "Other amusement and recreation activities n.e.c.", Category.SUBCLASS),
        Classification("S", "OTHER SERVICE ACTIVITIES", Category.SECTION),
        Classification("94", "Activities of membership organisations", Category.DIVISION),
        Classification(
            "94.1", "Activities of business, employers and professional membership organisations", Category.GROUP
        ),
        Classification("94.11", "Activities of business and employers membership organisations", Category.CLASS),
        Classification("94.110", "Activities of business and employers membership organisations", Category.SUBCLASS),
        Classification("94.12", "Activities of professional membership organisations", Category.CLASS),
        Classification("94.120", "Activities of professional membership organisations", Category.SUBCLASS),
        Classification("94.2", "Activities of trade unions", Category.GROUP),
        Classification("94.20", "Activities of trade unions", Category.CLASS),
        Classification("94.200", "Activities of trade unions", Category.SUBCLASS),
        Classification("94.9", "Activities of other membership organisations", Category.GROUP),
        Classification("94.91", "Activities of religious organisations", Category.CLASS),
        Classification("94.910", "Activities of religious organisations", Category.SUBCLASS),
        Classification("94.92", "Activities of political organisations", Category.CLASS),
        Classification("94.920", "Activities of political organisations", Category.SUBCLASS),
        Classification("94.99", "Activities of other membership organisations n.e.c.", Category.CLASS),
        Classification("94.991", "Activity of membership organisations for disabled persons", Category.SUBCLASS),
        Classification("94.999", "Activities of other membership organisations n.e.c.", Category.SUBCLASS),
        Classification("95", "Repair of computers and personal and household goods", Category.DIVISION),
        Classification("95.1", "Repair of computers and communication equipment", Category.GROUP),
        Classification("95.11", "Repair of computers and peripheral equipment", Category.CLASS),
        Classification("95.110", "Repair of computers and peripheral equipment", Category.SUBCLASS),
        Classification("95.12", "Repair of communication equipment", Category.CLASS),
        Classification("95.120", "Repair of communication equipment", Category.SUBCLASS),
        Classification("95.2", "Repair of personal and household goods", Category.GROUP),
        Classification("95.21", "Repair of consumer electronics", Category.CLASS),
        Classification("95.210", "Repair of consumer electronics", Category.SUBCLASS),
        Classification("95.22", "Repair of household appliances and home and garden equipment", Category.CLASS),
        Classification("95.220", "Repair of household appliances and home and garden equipment", Category.SUBCLASS),
        Classification("95.23", "Repair of footwear and leather goods", Category.CLASS),
        Classification("95.230", "Repair of footwear and leather goods", Category.SUBCLASS),
        Classification("95.24", "Repair of furniture and home furnishings", Category.CLASS),
        Classification("95.240", "Repair of furniture and home furnishings", Category.SUBCLASS),
        Classification("95.25", "Repair of watches, clocks and jewellery", Category.CLASS),
        Classification("95.250", "Repair of watches, clocks and jewellery", Category.SUBCLASS),
        Classification("95.29", "Repair of other personal and household goods", Category.CLASS),
        Classification("95.290", "Repair of other personal and household goods", Category.SUBCLASS),
        Classification("96", "Other personal service activities", Category.DIVISION),
        Classification("96.0", "Other personal service activities", Category.GROUP),
        Classification("96.01", "Washing and (dry-)cleaning of textile and fur products", Category.CLASS),
        Classification("96.010", "Washing and (dry-)cleaning of textile and fur products", Category.SUBCLASS),
        Classification("96.02", "Hairdressing and other beauty treatment", Category.CLASS),
        Classification("96.021", "Hairdressing", Category.SUBCLASS),
        Classification("96.022", "Other beauty treatment", Category.SUBCLASS),
        Classification("96.03", "Funeral and related activities", Category.CLASS),
        Classification("96.030", "Funeral and related activities", Category.SUBCLASS),
        Classification("96.04", "Physical well-being activities", Category.CLASS),
        Classification("96.040", "Physical well-being activities", Category.SUBCLASS),
        Classification("96.09", "Other personal service activities n.e.c.", Category.CLASS),
        Classification("96.090", "Other personal service activities n.e.c.", Category.SUBCLASS),
        Classification(
            "T",
            "ACTIVITIES OF HOUSEHOLDS AS EMPLOYERS, UNDIFFERENTIATED GOODS- AND SERVICES-PRODUCING ACTIVITIES OF HOUSEHOLDS FOR OWN USE",
            Category.SECTION,
        ),
        Classification("97", "Activities of households as employers of domestic personnel", Category.DIVISION),
        Classification("97.0", "Activities of households as employers of domestic personnel", Category.GROUP),
        Classification("97.00", "Activities of households as employers of domestic personnel", Category.CLASS),
        Classification("97.000", "Activities of households as employers of domestic personnel", Category.SUBCLASS),
        Classification(
            "98",
            "Undifferentiated goods- and services-producing activities of private households for own use",
            Category.DIVISION,
        ),
        Classification(
            "98.1", "Undifferentiated goods-producing activities of private households for own use", Category.GROUP
        ),
        Classification(
            "98.10", "Undifferentiated goods-producing activities of private households for own use", Category.CLASS
        ),
        Classification(
            "98.100", "Undifferentiated goods-producing activities of private households for own use", Category.SUBCLASS
        ),
        Classification(
            "98.2", "Undifferentiated service-producing activities of private households for own use", Category.GROUP
        ),
        Classification(
            "98.20", "Undifferentiated service-producing activities of private households for own use", Category.CLASS
        ),
        Classification(
            "98.200",
            "Undifferentiated service-producing activities of private households for own use",
            Category.SUBCLASS,
        ),
        Classification("U", "ACTIVITIES OF EXTRATERRITORIAL ORGANISATIONS AND BODIES", Category.SECTION),
        Classification("99", "Activities of extraterritorial organisations and bodies", Category.DIVISION),
        Classification("99.0", "Activities of extraterritorial organisations and bodies", Category.GROUP),
        Classification("99.00", "Activities of extraterritorial organisations and bodies", Category.CLASS),
        Classification("99.000", "Activities of extraterritorial organisations and bodies", Category.SUBCLASS),
    ],
)
