"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.Cache = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const aws_cdk_lib_1 = require("aws-cdk-lib");
const aws_s3_1 = require("aws-cdk-lib/aws-s3");
const constructs_1 = require("constructs");
/**
 * A GitLab Runner cache consisting of an Amazon S3 bucket.
 *
 * The bucket is encrypted with a KMS managed master key, it has public access blocked and will be cleared and deleted on CFN stack deletion.
 *
 * @stability stable
 */
class Cache extends constructs_1.Construct {
    /**
     * @stability stable
     */
    constructor(scope, id, props = {}) {
        var _b;
        super(scope, id);
        const bucketName = props.bucketName || "runner-cache";
        const uniqueCacheBucketName = `${scope.stackName}-${bucketName}-${scope.account}-${scope.region}`
            .slice(-63)
            .toLocaleLowerCase();
        /* Enabled if not 0. If 0 - cache doesn't expire. If undefined - expiration sets to expire in 30 days */
        const expiration = (_b = props.expiration) !== null && _b !== void 0 ? _b : aws_cdk_lib_1.Duration.days(30);
        const lifeCycleRuleEnabled = expiration.toDays() !== 0;
        this.bucket = new aws_s3_1.Bucket(scope, "CacheBucket", {
            bucketName: uniqueCacheBucketName,
            lifecycleRules: [
                {
                    enabled: lifeCycleRuleEnabled,
                    expiration: expiration,
                },
            ],
            encryption: aws_s3_1.BucketEncryption.KMS_MANAGED,
            blockPublicAccess: aws_s3_1.BlockPublicAccess.BLOCK_ALL,
            autoDeleteObjects: true,
            removalPolicy: aws_cdk_lib_1.RemovalPolicy.DESTROY,
        });
    }
}
exports.Cache = Cache;
_a = JSII_RTTI_SYMBOL_1;
Cache[_a] = { fqn: "@pepperize/cdk-autoscaling-gitlab-runner.Cache", version: "0.0.155" };
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiY2FjaGUuanMiLCJzb3VyY2VSb290IjoiIiwic291cmNlcyI6WyIuLi8uLi9zcmMvcnVubmVyL2NhY2hlLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7Ozs7O0FBQUEsNkNBQTZEO0FBQzdELCtDQUEwRjtBQUMxRiwyQ0FBdUM7Ozs7Ozs7O0FBVXZDLE1BQWEsS0FBTSxTQUFRLHNCQUFTOzs7O0lBR2xDLFlBQVksS0FBWSxFQUFFLEVBQVUsRUFBRSxRQUFvQixFQUFFOztRQUMxRCxLQUFLLENBQUMsS0FBSyxFQUFFLEVBQUUsQ0FBQyxDQUFDO1FBRWpCLE1BQU0sVUFBVSxHQUFHLEtBQUssQ0FBQyxVQUFVLElBQUksY0FBYyxDQUFDO1FBQ3RELE1BQU0scUJBQXFCLEdBQUcsR0FBRyxLQUFLLENBQUMsU0FBUyxJQUFJLFVBQVUsSUFBSSxLQUFLLENBQUMsT0FBTyxJQUFJLEtBQUssQ0FBQyxNQUFNLEVBQUU7YUFDOUYsS0FBSyxDQUFDLENBQUMsRUFBRSxDQUFDO2FBQ1YsaUJBQWlCLEVBQUUsQ0FBQztRQUV2Qix3R0FBd0c7UUFDeEcsTUFBTSxVQUFVLFNBQUcsS0FBSyxDQUFDLFVBQVUsbUNBQUksc0JBQVEsQ0FBQyxJQUFJLENBQUMsRUFBRSxDQUFDLENBQUM7UUFDekQsTUFBTSxvQkFBb0IsR0FBRyxVQUFVLENBQUMsTUFBTSxFQUFFLEtBQUssQ0FBQyxDQUFDO1FBRXZELElBQUksQ0FBQyxNQUFNLEdBQUcsSUFBSSxlQUFNLENBQUMsS0FBSyxFQUFFLGFBQWEsRUFBRTtZQUM3QyxVQUFVLEVBQUUscUJBQXFCO1lBQ2pDLGNBQWMsRUFBRTtnQkFDZDtvQkFDRSxPQUFPLEVBQUUsb0JBQW9CO29CQUM3QixVQUFVLEVBQUUsVUFBVTtpQkFDdkI7YUFDRjtZQUNELFVBQVUsRUFBRSx5QkFBZ0IsQ0FBQyxXQUFXO1lBQ3hDLGlCQUFpQixFQUFFLDBCQUFpQixDQUFDLFNBQVM7WUFDOUMsaUJBQWlCLEVBQUUsSUFBSTtZQUN2QixhQUFhLEVBQUUsMkJBQWEsQ0FBQyxPQUFPO1NBQ3JDLENBQUMsQ0FBQztJQUNMLENBQUM7O0FBNUJILHNCQTZCQyIsInNvdXJjZXNDb250ZW50IjpbImltcG9ydCB7IER1cmF0aW9uLCBSZW1vdmFsUG9saWN5LCBTdGFjayB9IGZyb20gXCJhd3MtY2RrLWxpYlwiO1xuaW1wb3J0IHsgQmxvY2tQdWJsaWNBY2Nlc3MsIEJ1Y2tldCwgQnVja2V0RW5jcnlwdGlvbiwgSUJ1Y2tldCB9IGZyb20gXCJhd3MtY2RrLWxpYi9hd3MtczNcIjtcbmltcG9ydCB7IENvbnN0cnVjdCB9IGZyb20gXCJjb25zdHJ1Y3RzXCI7XG5cbmV4cG9ydCBpbnRlcmZhY2UgQ2FjaGVQcm9wcyB7XG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuICByZWFkb25seSBidWNrZXROYW1lPzogc3RyaW5nO1xuICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICBcbiAgcmVhZG9ubHkgZXhwaXJhdGlvbj86IER1cmF0aW9uO1xufVxuXG4gICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgICAgIFxuZXhwb3J0IGNsYXNzIENhY2hlIGV4dGVuZHMgQ29uc3RydWN0IHtcbiAgcmVhZG9ubHkgYnVja2V0OiBJQnVja2V0O1xuXG4gIGNvbnN0cnVjdG9yKHNjb3BlOiBTdGFjaywgaWQ6IHN0cmluZywgcHJvcHM6IENhY2hlUHJvcHMgPSB7fSkge1xuICAgIHN1cGVyKHNjb3BlLCBpZCk7XG5cbiAgICBjb25zdCBidWNrZXROYW1lID0gcHJvcHMuYnVja2V0TmFtZSB8fCBcInJ1bm5lci1jYWNoZVwiO1xuICAgIGNvbnN0IHVuaXF1ZUNhY2hlQnVja2V0TmFtZSA9IGAke3Njb3BlLnN0YWNrTmFtZX0tJHtidWNrZXROYW1lfS0ke3Njb3BlLmFjY291bnR9LSR7c2NvcGUucmVnaW9ufWBcbiAgICAgIC5zbGljZSgtNjMpXG4gICAgICAudG9Mb2NhbGVMb3dlckNhc2UoKTtcblxuICAgIC8qIEVuYWJsZWQgaWYgbm90IDAuIElmIDAgLSBjYWNoZSBkb2Vzbid0IGV4cGlyZS4gSWYgdW5kZWZpbmVkIC0gZXhwaXJhdGlvbiBzZXRzIHRvIGV4cGlyZSBpbiAzMCBkYXlzICovXG4gICAgY29uc3QgZXhwaXJhdGlvbiA9IHByb3BzLmV4cGlyYXRpb24gPz8gRHVyYXRpb24uZGF5cygzMCk7XG4gICAgY29uc3QgbGlmZUN5Y2xlUnVsZUVuYWJsZWQgPSBleHBpcmF0aW9uLnRvRGF5cygpICE9PSAwO1xuXG4gICAgdGhpcy5idWNrZXQgPSBuZXcgQnVja2V0KHNjb3BlLCBcIkNhY2hlQnVja2V0XCIsIHtcbiAgICAgIGJ1Y2tldE5hbWU6IHVuaXF1ZUNhY2hlQnVja2V0TmFtZSxcbiAgICAgIGxpZmVjeWNsZVJ1bGVzOiBbXG4gICAgICAgIHtcbiAgICAgICAgICBlbmFibGVkOiBsaWZlQ3ljbGVSdWxlRW5hYmxlZCxcbiAgICAgICAgICBleHBpcmF0aW9uOiBleHBpcmF0aW9uLFxuICAgICAgICB9LFxuICAgICAgXSxcbiAgICAgIGVuY3J5cHRpb246IEJ1Y2tldEVuY3J5cHRpb24uS01TX01BTkFHRUQsXG4gICAgICBibG9ja1B1YmxpY0FjY2VzczogQmxvY2tQdWJsaWNBY2Nlc3MuQkxPQ0tfQUxMLFxuICAgICAgYXV0b0RlbGV0ZU9iamVjdHM6IHRydWUsXG4gICAgICByZW1vdmFsUG9saWN5OiBSZW1vdmFsUG9saWN5LkRFU1RST1ksXG4gICAgfSk7XG4gIH1cbn1cbiJdfQ==