/*
 * Codepage definitions for libfsfat
 *
 * Copyright (C) 2021-2022, Joachim Metz <joachim.metz@gmail.com>
 *
 * Refer to AUTHORS for acknowledgements.
 *
 * This program is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <https://www.gnu.org/licenses/>.
 */

#if !defined( _LIBFSFAT_CODEPAGE_H )
#define _LIBFSFAT_CODEPAGE_H

#include <libfsfat/types.h>

#if defined( __cplusplus )
extern "C" {
#endif

/* The codepage definitions
 */
enum LIBFSFAT_CODEPAGES
{
	LIBFSFAT_CODEPAGE_ASCII				= 20127,

	LIBFSFAT_CODEPAGE_ISO_8859_1			= 28591,
	LIBFSFAT_CODEPAGE_ISO_8859_2			= 28592,
	LIBFSFAT_CODEPAGE_ISO_8859_3			= 28593,
	LIBFSFAT_CODEPAGE_ISO_8859_4			= 28594,
	LIBFSFAT_CODEPAGE_ISO_8859_5			= 28595,
	LIBFSFAT_CODEPAGE_ISO_8859_6			= 28596,
	LIBFSFAT_CODEPAGE_ISO_8859_7			= 28597,
	LIBFSFAT_CODEPAGE_ISO_8859_8			= 28598,
	LIBFSFAT_CODEPAGE_ISO_8859_9			= 28599,
	LIBFSFAT_CODEPAGE_ISO_8859_10			= 28600,
	LIBFSFAT_CODEPAGE_ISO_8859_11			= 28601,
	LIBFSFAT_CODEPAGE_ISO_8859_13			= 28603,
	LIBFSFAT_CODEPAGE_ISO_8859_14			= 28604,
	LIBFSFAT_CODEPAGE_ISO_8859_15			= 28605,
	LIBFSFAT_CODEPAGE_ISO_8859_16			= 28606,

	LIBFSFAT_CODEPAGE_KOI8_R			= 20866,
	LIBFSFAT_CODEPAGE_KOI8_U			= 21866,

	LIBFSFAT_CODEPAGE_WINDOWS_874			= 874,
	LIBFSFAT_CODEPAGE_WINDOWS_932			= 932,
	LIBFSFAT_CODEPAGE_WINDOWS_936			= 936,
	LIBFSFAT_CODEPAGE_WINDOWS_949			= 949,
	LIBFSFAT_CODEPAGE_WINDOWS_950			= 950,
	LIBFSFAT_CODEPAGE_WINDOWS_1250			= 1250,
	LIBFSFAT_CODEPAGE_WINDOWS_1251			= 1251,
	LIBFSFAT_CODEPAGE_WINDOWS_1252			= 1252,
	LIBFSFAT_CODEPAGE_WINDOWS_1253			= 1253,
	LIBFSFAT_CODEPAGE_WINDOWS_1254			= 1254,
	LIBFSFAT_CODEPAGE_WINDOWS_1255			= 1255,
	LIBFSFAT_CODEPAGE_WINDOWS_1256			= 1256,
	LIBFSFAT_CODEPAGE_WINDOWS_1257			= 1257,
	LIBFSFAT_CODEPAGE_WINDOWS_1258			= 1258
};

#define LIBFSFAT_CODEPAGE_US_ASCII			LIBFSFAT_CODEPAGE_ASCII

#define LIBFSFAT_CODEPAGE_ISO_WESTERN_EUROPEAN		LIBFSFAT_CODEPAGE_ISO_8859_1
#define LIBFSFAT_CODEPAGE_ISO_CENTRAL_EUROPEAN		LIBFSFAT_CODEPAGE_ISO_8859_2
#define LIBFSFAT_CODEPAGE_ISO_SOUTH_EUROPEAN		LIBFSFAT_CODEPAGE_ISO_8859_3
#define LIBFSFAT_CODEPAGE_ISO_NORTH_EUROPEAN		LIBFSFAT_CODEPAGE_ISO_8859_4
#define LIBFSFAT_CODEPAGE_ISO_CYRILLIC			LIBFSFAT_CODEPAGE_ISO_8859_5
#define LIBFSFAT_CODEPAGE_ISO_ARABIC			LIBFSFAT_CODEPAGE_ISO_8859_6
#define LIBFSFAT_CODEPAGE_ISO_GREEK			LIBFSFAT_CODEPAGE_ISO_8859_7
#define LIBFSFAT_CODEPAGE_ISO_HEBREW			LIBFSFAT_CODEPAGE_ISO_8859_8
#define LIBFSFAT_CODEPAGE_ISO_TURKISH			LIBFSFAT_CODEPAGE_ISO_8859_9
#define LIBFSFAT_CODEPAGE_ISO_NORDIC			LIBFSFAT_CODEPAGE_ISO_8859_10
#define LIBFSFAT_CODEPAGE_ISO_THAI			LIBFSFAT_CODEPAGE_ISO_8859_11
#define LIBFSFAT_CODEPAGE_ISO_BALTIC			LIBFSFAT_CODEPAGE_ISO_8859_13
#define LIBFSFAT_CODEPAGE_ISO_CELTIC			LIBFSFAT_CODEPAGE_ISO_8859_14

#define LIBFSFAT_CODEPAGE_ISO_LATIN_1			LIBFSFAT_CODEPAGE_ISO_8859_1
#define LIBFSFAT_CODEPAGE_ISO_LATIN_2			LIBFSFAT_CODEPAGE_ISO_8859_2
#define LIBFSFAT_CODEPAGE_ISO_LATIN_3			LIBFSFAT_CODEPAGE_ISO_8859_3
#define LIBFSFAT_CODEPAGE_ISO_LATIN_4			LIBFSFAT_CODEPAGE_ISO_8859_4
#define LIBFSFAT_CODEPAGE_ISO_LATIN_5			LIBFSFAT_CODEPAGE_ISO_8859_9
#define LIBFSFAT_CODEPAGE_ISO_LATIN_6			LIBFSFAT_CODEPAGE_ISO_8859_10
#define LIBFSFAT_CODEPAGE_ISO_LATIN_7			LIBFSFAT_CODEPAGE_ISO_8859_13
#define LIBFSFAT_CODEPAGE_ISO_LATIN_8			LIBFSFAT_CODEPAGE_ISO_8859_14
#define LIBFSFAT_CODEPAGE_ISO_LATIN_9			LIBFSFAT_CODEPAGE_ISO_8859_15
#define LIBFSFAT_CODEPAGE_ISO_LATIN_10			LIBFSFAT_CODEPAGE_ISO_8859_16

#define LIBFSFAT_CODEPAGE_KOI8_RUSSIAN			LIBFSFAT_CODEPAGE_KOI8_R
#define LIBFSFAT_CODEPAGE_KOI8_UKRAINIAN		LIBFSFAT_CODEPAGE_KOI8_U

#define LIBFSFAT_CODEPAGE_WINDOWS_THAI			LIBFSFAT_CODEPAGE_WINDOWS_874
#define LIBFSFAT_CODEPAGE_WINDOWS_JAPANESE		LIBFSFAT_CODEPAGE_WINDOWS_932
#define LIBFSFAT_CODEPAGE_WINDOWS_CHINESE_SIMPLIFIED	LIBFSFAT_CODEPAGE_WINDOWS_936
#define LIBFSFAT_CODEPAGE_WINDOWS_KOREAN		LIBFSFAT_CODEPAGE_WINDOWS_949
#define LIBFSFAT_CODEPAGE_WINDOWS_CHINESE_TRADITIONAL	LIBFSFAT_CODEPAGE_WINDOWS_950
#define LIBFSFAT_CODEPAGE_WINDOWS_CENTRAL_EUROPEAN	LIBFSFAT_CODEPAGE_WINDOWS_1250
#define LIBFSFAT_CODEPAGE_WINDOWS_CYRILLIC		LIBFSFAT_CODEPAGE_WINDOWS_1251
#define LIBFSFAT_CODEPAGE_WINDOWS_WESTERN_EUROPEAN	LIBFSFAT_CODEPAGE_WINDOWS_1252
#define LIBFSFAT_CODEPAGE_WINDOWS_GREEK			LIBFSFAT_CODEPAGE_WINDOWS_1253
#define LIBFSFAT_CODEPAGE_WINDOWS_TURKISH		LIBFSFAT_CODEPAGE_WINDOWS_1254
#define LIBFSFAT_CODEPAGE_WINDOWS_HEBREW		LIBFSFAT_CODEPAGE_WINDOWS_1255
#define LIBFSFAT_CODEPAGE_WINDOWS_ARABIC		LIBFSFAT_CODEPAGE_WINDOWS_1256
#define LIBFSFAT_CODEPAGE_WINDOWS_BALTIC		LIBFSFAT_CODEPAGE_WINDOWS_1257
#define LIBFSFAT_CODEPAGE_WINDOWS_VIETNAMESE		LIBFSFAT_CODEPAGE_WINDOWS_1258

#if defined( __cplusplus )
}
#endif

#endif /* !defined( _LIBFSFAT_CODEPAGE_H ) */

