"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const cdktf_1 = require("cdktf");
const _1 = require(".");
const app = new cdktf_1.App();
const stack = new cdktf_1.TerraformStack(app, 'cdktf-eks-demo');
const cluster = new _1.Cluster(stack, 'EcsCluster');
cluster.addAsgCapacity('DefaultCapacity', {
    maxCapacity: 10,
    minCapacity: 0,
    desiredCapacity: 2,
});
cluster.addAsgCapacity('BRCapacity', {
    maxCapacity: 10,
    minCapacity: 0,
    desiredCapacity: 2,
    machineImage: new _1.BottleRocketImage(stack),
});
app.synth();
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiaW50ZWcuZGVmYXVsdC5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uL3NyYy9pbnRlZy5kZWZhdWx0LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUEsaUNBQTRDO0FBQzVDLHdCQUErQztBQUUvQyxNQUFNLEdBQUcsR0FBRyxJQUFJLFdBQUcsRUFBRSxDQUFDO0FBRXRCLE1BQU0sS0FBSyxHQUFHLElBQUksc0JBQWMsQ0FBQyxHQUFHLEVBQUUsZ0JBQWdCLENBQUMsQ0FBQztBQUV4RCxNQUFNLE9BQU8sR0FBRyxJQUFJLFVBQU8sQ0FBQyxLQUFLLEVBQUUsWUFBWSxDQUFDLENBQUM7QUFFakQsT0FBTyxDQUFDLGNBQWMsQ0FBQyxpQkFBaUIsRUFBRTtJQUN4QyxXQUFXLEVBQUUsRUFBRTtJQUNmLFdBQVcsRUFBRSxDQUFDO0lBQ2QsZUFBZSxFQUFFLENBQUM7Q0FDbkIsQ0FBQyxDQUFDO0FBRUgsT0FBTyxDQUFDLGNBQWMsQ0FBQyxZQUFZLEVBQUU7SUFDbkMsV0FBVyxFQUFFLEVBQUU7SUFDZixXQUFXLEVBQUUsQ0FBQztJQUNkLGVBQWUsRUFBRSxDQUFDO0lBQ2xCLFlBQVksRUFBRSxJQUFJLG9CQUFpQixDQUFDLEtBQUssQ0FBQztDQUMzQyxDQUFDLENBQUM7QUFFSCxHQUFHLENBQUMsS0FBSyxFQUFFLENBQUMiLCJzb3VyY2VzQ29udGVudCI6WyJpbXBvcnQgeyBBcHAsIFRlcnJhZm9ybVN0YWNrIH0gZnJvbSAnY2RrdGYnO1xuaW1wb3J0IHsgQm90dGxlUm9ja2V0SW1hZ2UsIENsdXN0ZXIgfSBmcm9tICcuJztcblxuY29uc3QgYXBwID0gbmV3IEFwcCgpO1xuXG5jb25zdCBzdGFjayA9IG5ldyBUZXJyYWZvcm1TdGFjayhhcHAsICdjZGt0Zi1la3MtZGVtbycpO1xuXG5jb25zdCBjbHVzdGVyID0gbmV3IENsdXN0ZXIoc3RhY2ssICdFY3NDbHVzdGVyJyk7XG5cbmNsdXN0ZXIuYWRkQXNnQ2FwYWNpdHkoJ0RlZmF1bHRDYXBhY2l0eScsIHtcbiAgbWF4Q2FwYWNpdHk6IDEwLFxuICBtaW5DYXBhY2l0eTogMCxcbiAgZGVzaXJlZENhcGFjaXR5OiAyLFxufSk7XG5cbmNsdXN0ZXIuYWRkQXNnQ2FwYWNpdHkoJ0JSQ2FwYWNpdHknLCB7XG4gIG1heENhcGFjaXR5OiAxMCxcbiAgbWluQ2FwYWNpdHk6IDAsXG4gIGRlc2lyZWRDYXBhY2l0eTogMixcbiAgbWFjaGluZUltYWdlOiBuZXcgQm90dGxlUm9ja2V0SW1hZ2Uoc3RhY2spLFxufSk7XG5cbmFwcC5zeW50aCgpO1xuIl19