# Generated by Django 3.2.5 on 2021-07-20 05:35

import django.db.models.deletion
from django.db import migrations, models

import iacs.models


class Migration(migrations.Migration):
    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='Api',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='api id')),
                ('regex', models.CharField(default='', max_length=255, verbose_name='api regex')),
                ('protocol', models.IntegerField(choices=[(0, 'http | https'), (1, 'ws | wss')], default=0,
                                                 verbose_name='api protocol')),
                ('method',
                 models.IntegerField(choices=[(0, 'get'), (1, 'post'), (2, 'delete'), (3, 'put'), (4, 'patch')],
                                     default=0, null=True, verbose_name='api http request method')),
                ('rest_method',
                 models.IntegerField(choices=[(0, 'get'), (1, 'post'), (2, 'delete'), (3, 'put'), (4, 'patch')],
                                     default=0, null=True, verbose_name='rest method')),
                ('name', models.CharField(default='', max_length=255, verbose_name='api name')),
                ('base_name', models.CharField(default='', max_length=255, verbose_name='api base name')),
                ('position', models.CharField(default='', max_length=128, verbose_name='api position')),
                ('group', models.CharField(default='', max_length=128, verbose_name='api group')),
                ('user_default', models.BooleanField(default=0, verbose_name='is user default')),
                ('app_name', models.CharField(default='', max_length=64, verbose_name='app name')),
            ],
            options={
                'verbose_name': 'api',
            },
        ),
        migrations.CreateModel(
            name='Menu',
            fields=[
                ('id', models.CharField(max_length=128, primary_key=True, serialize=False, verbose_name='menu id')),
                ('name', models.CharField(default='', max_length=255, verbose_name='menu name')),
                ('expandable', models.BooleanField(default=0, verbose_name='expandable')),
                ('bold', models.BooleanField(default=0, verbose_name='bold')),
                ('css_icon', models.CharField(default='', max_length=255, verbose_name='css icon')),
                ('link', models.CharField(default='', max_length=255, verbose_name='link')),
                ('activate', models.BooleanField(default=True, verbose_name='activate')),
                ('sequence', models.IntegerField(default=0, verbose_name='sequence')),
                ('apis', models.ManyToManyField(to='iacs.Api')),
                ('father',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, related_name='father_set',
                                   to='iacs.menu', verbose_name='super menu id')),
                ('supers', models.ManyToManyField(to='iacs.Menu')),
            ],
            options={
                'verbose_name': 'menu',
            },
        ),
        migrations.CreateModel(
            name='OperationLog',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='auto id')),
                ('username', models.CharField(default='', max_length=255, verbose_name='user name')),
                ('ipv4', models.GenericIPAddressField(default='', null=True, protocol='IPv4',
                                                      verbose_name='user ipv4 address')),
                ('ipv6', models.GenericIPAddressField(default='', null=True, protocol='IPv6',
                                                      verbose_name='user ipv6 address')),
                ('desc', models.CharField(default='', max_length=255, verbose_name='operation desc')),
                ('before', models.TextField(default='', verbose_name='data before change')),
                ('after', models.TextField(default='', verbose_name='data after change')),
                ('request_data', models.TextField(default='', verbose_name='request data')),
                ('create_timestamp',
                 models.BigIntegerField(default=iacs.models.default_time, verbose_name='create time')),
            ],
            options={
                'verbose_name': 'operation log',
            },
        ),
        migrations.CreateModel(
            name='PermissionGroup',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('description', models.CharField(default='', max_length=128, null=True)),
                ('name', models.CharField(default='', max_length=50)),
                ('type', models.SmallIntegerField(choices=[(0, 'normal group'), (1, 'super group')], default=0)),
                ('auth_time', models.IntegerField(default=3600)),
                ('api', models.ManyToManyField(to='iacs.Api')),
            ],
            options={
                'verbose_name': 'permission group',
            },
        ),
        migrations.CreateModel(
            name='MenuPermission',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False)),
                ('read', models.SmallIntegerField(null=True, verbose_name='读取权限')),
                ('write', models.SmallIntegerField(null=True, verbose_name='写入权限')),
                ('delete', models.SmallIntegerField(null=True, verbose_name='删除权限')),
                ('menu', models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='iacs.menu')),
                ('permission_group',
                 models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE, to='iacs.permissiongroup')),
            ],
            options={
                'verbose_name': 'menu permission',
            },
        ),
        migrations.CreateModel(
            name='User',
            fields=[
                ('id', models.AutoField(primary_key=True, serialize=False, verbose_name='user id')),
                ('username', models.CharField(default='', max_length=50, verbose_name='user account')),
                ('password', models.CharField(default='', max_length=255, verbose_name='user pass code')),
                ('alias', models.CharField(default='', max_length=128, verbose_name='user alias')),
                ('cellphone_number', models.BigIntegerField(null=True, verbose_name='user cellphone number')),
                ('email', models.EmailField(default='', max_length=254, verbose_name='user email')),
                ('is_active', models.BooleanField(default=1, verbose_name='user is active or not')),
                ('create_timestamp',
                 models.BigIntegerField(default=iacs.models.default_time, verbose_name='create time')),
                ('creator', models.IntegerField(null=True, verbose_name='creator')),
                ('is_super', models.BooleanField(default=0)),
                ('expire_day', models.IntegerField(default=0)),
                ('expire_timestamp', models.BigIntegerField(null=True)),
                ('api', models.ManyToManyField(to='iacs.Api')),
                ('permission_group', models.ManyToManyField(to='iacs.PermissionGroup')),
            ],
            options={
                'verbose_name': 'user',
            },
        ),
    ]
