import * as ec2 from '@aws-cdk/aws-ec2';
import * as iam from '@aws-cdk/aws-iam';
import * as kms from '@aws-cdk/aws-kms';
import * as secretsmanager from '@aws-cdk/aws-secretsmanager';
import { Resource, Duration, RemovalPolicy, IResource } from '@aws-cdk/core';
import { Construct } from 'constructs';
import { IClusterEngine } from './cluster-engine';
import { Endpoint } from './endpoint';
import { IParameterGroup } from './parameter-group';
import { Credentials, RotationMultiUserOptions, RotationSingleUserOptions } from './props';
import { ISubnetGroup } from './subnet-group';
/**
 * (experimental) Interface representing a serverless database cluster.
 *
 * @experimental
 */
export interface IServerlessCluster extends IResource, ec2.IConnectable, secretsmanager.ISecretAttachmentTarget {
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) The ARN of the cluster.
     *
     * @experimental
     */
    readonly clusterArn: string;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     * @attribute EndpointAddress,EndpointPort
     */
    readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) Endpoint to use for load-balanced read-only operations.
     *
     * @experimental
     * @attribute ReadEndpointAddress
     */
    readonly clusterReadEndpoint: Endpoint;
    /**
     * (experimental) Grant the given identity to access to the Data API.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantDataApiAccess(grantee: iam.IGrantable): iam.Grant;
}
/**
 * (experimental) Properties to configure an Aurora Serverless Cluster.
 *
 * @experimental
 */
export interface ServerlessClusterProps {
    /**
     * (experimental) What kind of database to start.
     *
     * @experimental
     */
    readonly engine: IClusterEngine;
    /**
     * (experimental) Credentials for the administrative user.
     *
     * @default - A username of 'admin' and SecretsManager-generated password
     * @experimental
     */
    readonly credentials?: Credentials;
    /**
     * (experimental) An optional identifier for the cluster.
     *
     * @default - A name is automatically generated.
     * @experimental
     */
    readonly clusterIdentifier?: string;
    /**
     * (experimental) The number of days during which automatic DB snapshots are retained.
     *
     * Automatic backup retention cannot be disabled on serverless clusters.
     * Must be a value from 1 day to 35 days.
     *
     * @default Duration.days(1)
     * @experimental
     */
    readonly backupRetention?: Duration;
    /**
     * (experimental) Name of a database which is automatically created inside the cluster.
     *
     * @default - Database is not created in cluster.
     * @experimental
     */
    readonly defaultDatabaseName?: string;
    /**
     * (experimental) Indicates whether the DB cluster should have deletion protection enabled.
     *
     * @default - true if removalPolicy is RETAIN, false otherwise
     * @experimental
     */
    readonly deletionProtection?: boolean;
    /**
     * (experimental) Whether to enable the Data API.
     *
     * @default false
     * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/data-api.html
     * @experimental
     */
    readonly enableDataApi?: boolean;
    /**
     * (experimental) The VPC that this Aurora Serverless cluster has been created in.
     *
     * @experimental
     */
    readonly vpc: ec2.IVpc;
    /**
     * (experimental) Where to place the instances within the VPC.
     *
     * @default - the VPC default strategy if not specified.
     * @experimental
     */
    readonly vpcSubnets?: ec2.SubnetSelection;
    /**
     * (experimental) Scaling configuration of an Aurora Serverless database cluster.
     *
     * @default - Serverless cluster is automatically paused after 5 minutes of being idle.
     * minimum capacity: 2 ACU
     * maximum capacity: 16 ACU
     * @experimental
     */
    readonly scaling?: ServerlessScalingOptions;
    /**
     * (experimental) The removal policy to apply when the cluster and its instances are removed from the stack or replaced during an update.
     *
     * @default - RemovalPolicy.SNAPSHOT (remove the cluster and instances, but retain a snapshot of the data)
     * @experimental
     */
    readonly removalPolicy?: RemovalPolicy;
    /**
     * (experimental) Security group.
     *
     * @default - a new security group is created.
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) The KMS key for storage encryption.
     *
     * @default - the default master key will be used for storage encryption
     * @experimental
     */
    readonly storageEncryptionKey?: kms.IKey;
    /**
     * (experimental) Additional parameters to pass to the database engine.
     *
     * @default - no parameter group.
     * @experimental
     */
    readonly parameterGroup?: IParameterGroup;
    /**
     * (experimental) Existing subnet group for the cluster.
     *
     * @default - a new subnet group will be created.
     * @experimental
     */
    readonly subnetGroup?: ISubnetGroup;
}
/**
 * (experimental) Properties that describe an existing cluster instance.
 *
 * @experimental
 */
export interface ServerlessClusterAttributes {
    /**
     * (experimental) Identifier for the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) The database port.
     *
     * @default - none
     * @experimental
     */
    readonly port?: number;
    /**
     * (experimental) The security groups of the database cluster.
     *
     * @default - no security groups
     * @experimental
     */
    readonly securityGroups?: ec2.ISecurityGroup[];
    /**
     * (experimental) Cluster endpoint address.
     *
     * @default - no endpoint address
     * @experimental
     */
    readonly clusterEndpointAddress?: string;
    /**
     * (experimental) Reader endpoint address.
     *
     * @default - no reader address
     * @experimental
     */
    readonly readerEndpointAddress?: string;
    /**
     * (experimental) The secret attached to the database cluster.
     *
     * @default - no secret
     * @experimental
     */
    readonly secret?: secretsmanager.ISecret;
}
/**
 * (experimental) Aurora capacity units (ACUs).
 *
 * Each ACU is a combination of processing and memory capacity.
 *
 * @see https://docs.aws.amazon.com/AmazonRDS/latest/AuroraUserGuide/aurora-serverless.how-it-works.html#aurora-serverless.architecture
 * @experimental
 */
export declare enum AuroraCapacityUnit {
    /**
     * (experimental) 1 Aurora Capacity Unit.
     *
     * @experimental
     */
    ACU_1 = 1,
    /**
     * (experimental) 2 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_2 = 2,
    /**
     * (experimental) 4 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_4 = 4,
    /**
     * (experimental) 8 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_8 = 8,
    /**
     * (experimental) 16 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_16 = 16,
    /**
     * (experimental) 32 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_32 = 32,
    /**
     * (experimental) 64 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_64 = 64,
    /**
     * (experimental) 128 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_128 = 128,
    /**
     * (experimental) 192 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_192 = 192,
    /**
     * (experimental) 256 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_256 = 256,
    /**
     * (experimental) 384 Aurora Capacity Units.
     *
     * @experimental
     */
    ACU_384 = 384
}
/**
 * (experimental) Options for configuring scaling on an Aurora Serverless cluster.
 *
 * @experimental
 */
export interface ServerlessScalingOptions {
    /**
     * (experimental) The minimum capacity for an Aurora Serverless database cluster.
     *
     * @default - determined by Aurora based on database engine
     * @experimental
     */
    readonly minCapacity?: AuroraCapacityUnit;
    /**
     * (experimental) The maximum capacity for an Aurora Serverless database cluster.
     *
     * @default - determined by Aurora based on database engine
     * @experimental
     */
    readonly maxCapacity?: AuroraCapacityUnit;
    /**
     * (experimental) The time before an Aurora Serverless database cluster is paused.
     *
     * A database cluster can be paused only when it is idle (it has no connections).
     * Auto pause time must be between 5 minutes and 1 day.
     *
     * If a DB cluster is paused for more than seven days, the DB cluster might be
     * backed up with a snapshot. In this case, the DB cluster is restored when there
     * is a request to connect to it.
     *
     * Set to 0 to disable
     *
     * @default - automatic pause enabled after 5 minutes
     * @experimental
     */
    readonly autoPause?: Duration;
}
/**
 * New or imported Serverless Cluster
 */
declare abstract class ServerlessClusterBase extends Resource implements IServerlessCluster {
    /**
     * Identifier of the cluster
     */
    abstract readonly clusterIdentifier: string;
    /**
     * The endpoint to use for read/write operations
     */
    abstract readonly clusterEndpoint: Endpoint;
    /**
     * The endpoint to use for read/write operations
     */
    abstract readonly clusterReadEndpoint: Endpoint;
    /**
     * Access to the network connections
     */
    abstract readonly connections: ec2.Connections;
    /**
     * The secret attached to this cluster
     */
    abstract readonly secret?: secretsmanager.ISecret;
    protected abstract enableDataApi?: boolean;
    /**
     * (experimental) The ARN of the cluster.
     *
     * @experimental
     */
    get clusterArn(): string;
    /**
     * (experimental) Grant the given identity to access to the Data API, including read access to the secret attached to the cluster if present.
     *
     * @param grantee The principal to grant access to.
     * @experimental
     */
    grantDataApiAccess(grantee: iam.IGrantable): iam.Grant;
    /**
     * (experimental) Renders the secret attachment target specifications.
     *
     * @experimental
     */
    asSecretAttachmentTarget(): secretsmanager.SecretAttachmentTargetProps;
}
/**
 * (experimental) Create an Aurora Serverless Cluster.
 *
 * @experimental
 * @resource AWS::RDS::DBCluster
 */
export declare class ServerlessCluster extends ServerlessClusterBase {
    /**
     * (experimental) Import an existing DatabaseCluster from properties.
     *
     * @experimental
     */
    static fromServerlessClusterAttributes(scope: Construct, id: string, attrs: ServerlessClusterAttributes): IServerlessCluster;
    /**
     * (experimental) Identifier of the cluster.
     *
     * @experimental
     */
    readonly clusterIdentifier: string;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     */
    readonly clusterEndpoint: Endpoint;
    /**
     * (experimental) The endpoint to use for read/write operations.
     *
     * @experimental
     */
    readonly clusterReadEndpoint: Endpoint;
    /**
     * (experimental) Access to the network connections.
     *
     * @experimental
     */
    readonly connections: ec2.Connections;
    /**
     * (experimental) The secret attached to this cluster.
     *
     * @experimental
     */
    readonly secret?: secretsmanager.ISecret;
    /**
     * @experimental
     */
    protected enableDataApi?: boolean;
    private readonly subnetGroup;
    private readonly vpc;
    private readonly vpcSubnets?;
    private readonly singleUserRotationApplication;
    private readonly multiUserRotationApplication;
    /**
     * @experimental
     */
    constructor(scope: Construct, id: string, props: ServerlessClusterProps);
    /**
     * (experimental) Adds the single user rotation of the master password to this cluster.
     *
     * @experimental
     */
    addRotationSingleUser(options?: RotationSingleUserOptions): secretsmanager.SecretRotation;
    /**
     * (experimental) Adds the multi user rotation to this cluster.
     *
     * @experimental
     */
    addRotationMultiUser(id: string, options: RotationMultiUserOptions): secretsmanager.SecretRotation;
    private renderScalingConfiguration;
}
export {};
