<div align="center"><img src="https://raw.githubusercontent.com/PlasmaPy/PlasmaPy-logo/master/exports/with-text-dark.png" width="600"/></div>

# PlasmaPy

[![PyPI version](https://badge.fury.io/py/plasmapy.svg)](https://badge.fury.io/py/plasmapy)
[![License](https://img.shields.io/badge/License-BSD%203--Clause-blue.svg)](./LICENSE.md)
[![DOI](https://zenodo.org/badge/DOI/10.5281/zenodo.1436011.svg)](https://doi.org/10.5281/zenodo.1436011)

[![Build Status](https://travis-ci.org/PlasmaPy/PlasmaPy.svg?branch=master)](https://travis-ci.org/PlasmaPy/PlasmaPy)
[![Build Status](https://dev.azure.com/plasmapy/PlasmaPy/_apis/build/status/PlasmaPy.PlasmaPy?branchName=master)](https://dev.azure.com/plasmapy/PlasmaPy/_build/latest?definitionId=2&branchName=master)
[![Build status](https://ci.appveyor.com/api/projects/status/hbduy62sqrvy8rn7?svg=true)](https://ci.appveyor.com/project/namurphy/plasmapy)
[![codecov](https://codecov.io/gh/PlasmaPy/PlasmaPy/branch/master/graph/badge.svg)](https://codecov.io/gh/PlasmaPy/PlasmaPy)
[![Documentation Status](https://readthedocs.org/projects/plasmapy/badge/?version=latest)](http://plasmapy.readthedocs.io/en/latest/?badge=latest)
[![Binder](https://mybinder.org/badge_logo.svg)](https://mybinder.org/v2/gh/PlasmaPy/PlasmaPy/master?filepath=plasmapy%2Fexamples)
[![pre-commit](https://img.shields.io/badge/pre--commit-enabled-brightgreen?logo=pre-commit&logoColor=white)](https://github.com/pre-commit/pre-commit)

[![Matrix](https://matrix.to/img/matrix-badge.svg)](https://app.element.io/#/room/#plasmapy:openastronomy.org)
[![Gitter (bridged to Matrix)](https://badges.gitter.im/Join%20Chat.svg)](https://gitter.im/PlasmaPy/Lobby)
[![astropy](http://img.shields.io/badge/powered%20by-AstroPy-orange.svg?style=flat)](http://www.astropy.org/)
[![Open Source Helpers](https://www.codetriage.com/plasmapy/plasmapy/badges/users.svg)](https://www.codetriage.com/plasmapy/plasmapy)

PlasmaPy is an open source community developed Python 3.6+ package for
plasma physics in the early stages of development.  PlasmaPy intends to
be for plasmas what [Astropy](https://github.com/astropy/astropy) is for
astronomy — a collection of functionality commonly used and shared
between plasma physicists and researchers globally, running within and
leveraging the open source scientific Python ecosystem.  The goals of
this project are more thoroughly described in our [vision
statement](http://docs.plasmapy.org/en/stable/about/vision_statement.html)
and [this recent reference](https://doi.org/10.5281/zenodo.1238132).
We are in the process of writing [online
documentation](http://docs.plasmapy.org/en/latest/).

We created a guide on [contributing to PlasmaPy](http://docs.plasmapy.org/en/stable/CONTRIBUTING.html)
and have a [Code of Conduct](http://docs.plasmapy.org/en/stable/CODE_OF_CONDUCT.html).
New contributors are very welcome!

# Feedback and communication

## [Matrix chat](https://app.element.io/#/room/#plasmapy:openastronomy.org)

If you have any questions, the quickest way to get a response is to ask
on our
[Matrix](https://app.element.io/#/room/#plasmapy:openastronomy.org)/[Gitter](https://gitter.im/PlasmaPy/Lobby)
channel. Both of these are the same chat channel; Gitter uses a bridge to link the two.

## [Discourse room](https://plasmapy.discourse.group/)

We have recently created a [PlasmaPy Discourse
group](https://plasmapy.discourse.group/) in order to allow threaded
public discussions on a variety of topics.  This group is a great
place to suggest ideas, bring up discussion topics, and ask questions.

## [Mailing list](https://groups.google.com/forum/#!forum/plasmapy)

We also have a [mailing list](https://groups.google.com/forum/#!forum/plasmapy)
that serves as a less volatile discussion forum.

## [Suggestion box](https://docs.google.com/forms/d/e/1FAIpQLSdT3O5iHZrLJRuavFyzoR23PGy0Prfzx2SQOcwJGWtvHyT2lw/viewform?usp=sf_link)

We have
[a suggestion box](https://docs.google.com/forms/d/e/1FAIpQLSdT3O5iHZrLJRuavFyzoR23PGy0Prfzx2SQOcwJGWtvHyT2lw/viewform?usp=sf_link)
if you would like to (optionally anonymously) suggest
a feature/topic for consideration. These will be reposted on the mailing list
or directly in GitHub issues, as appropriate, for further discussion.

## [Weekly](https://calendar.google.com/calendar?cid=bzVsb3ZkcW0zaWxsam00ZTlrMDd2cmw5bWdAZ3JvdXAuY2FsZW5kYXIuZ29vZ2xlLmNvbQ) [community meetings](https://meet.jit.si/plasmapy)

We have weekly community meetings in the
[PlasmaPy room on Jitsi](https://meet.jit.si/plasmapy).
The schedule of our community meetings is on our [calendar](https://calendar.google.com/calendar?cid=bzVsb3ZkcW0zaWxsam00ZTlrMDd2cmw5bWdAZ3JvdXAuY2FsZW5kYXIuZ29vZ2xlLmNvbQ), and you may access the [minutes and
agendas](https://drive.google.com/drive/folders/0ByPG8nie6fTPV1FQUEkzMTgtRTg?usp=sharing).
Any last minute changes will be discussed on
[Matrix](https://app.element.io/app/#/room/#plasmapy:openastronomy.org).
As of April 2020, our meetings are on Tuesdays at
[19:00 UTC](http://time.unitarium.com/utc/6pm).
Come discuss plasma software with us!

# Installation

You can get PlasmaPy from pip via `pip install plasmapy`. To contribute
to the package, check out [our instructions on installing PlasmaPy from
source](http://docs.plasmapy.org/en/stable/install.html#building-and-installing-from-source-code).

You can also get PlasmaPy from `conda` via `conda install -c conda-forge plasmapy`.

Like most scientific Python packages, PlasmaPy probably runs better on the
[Anaconda distribution](https://www.anaconda.com/downloads).

PlasmaPy requires Python 3.6+ and is [not compatible with
Python 2](https://pythonclock.org/).

# License

PlasmaPy is licensed under a 3-clause BSD license with added protections
against software patents — see the [``LICENSE.md``](LICENSE.md) file in
the top-level directory.

# Citing PlasmaPy

If you use PlasmaPy in a research publication, we ask that you cite the
Zenodo record for the specific version of PlasmaPy that you used.
Please see the [``docs/about/citation.rst``](./docs/about/citation.rst)
file for more detailed instructions on how to cite PlasmaPy.

# Acknowledgements

Early development on PlasmaPy was supported in part by the U.S.
Department of Energy, the Smithsonian Institution, and Google Summer of
Code.  Ongoing PlasmaPy development is being supported through a
collaborative award from the U.S. National Science Foundation's
Cyberinfrastructure for Sustained Scientific Innovation program and a
NASA HDEE grant.
