# Copyright 2020 The Merlin Authors
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

# coding: utf-8

"""
    Merlin

    API Guide for accessing Merlin's model deployment functionalities  # noqa: E501

    OpenAPI spec version: 0.6.0
    
    Generated by: https://github.com/swagger-api/swagger-codegen.git
"""


import pprint
import re  # noqa: F401

import six


class PredictionJobConfigGcsSink(object):
    """NOTE: This class is auto generated by the swagger code generator program.

    Do not edit the class manually.
    """

    """
    Attributes:
      swagger_types (dict): The key is attribute name
                            and the value is attribute type.
      attribute_map (dict): The key is attribute name
                            and the value is json key in definition.
    """
    swagger_types = {
        'format': 'FileFormat',
        'uri': 'str',
        'result_column': 'str',
        'save_mode': 'SaveMode',
        'options': 'dict(str, str)'
    }

    attribute_map = {
        'format': 'format',
        'uri': 'uri',
        'result_column': 'result_column',
        'save_mode': 'save_mode',
        'options': 'options'
    }

    def __init__(self, format=None, uri=None, result_column=None, save_mode=None, options=None):  # noqa: E501
        """PredictionJobConfigGcsSink - a model defined in Swagger"""  # noqa: E501

        self._format = None
        self._uri = None
        self._result_column = None
        self._save_mode = None
        self._options = None
        self.discriminator = None

        if format is not None:
            self.format = format
        if uri is not None:
            self.uri = uri
        if result_column is not None:
            self.result_column = result_column
        if save_mode is not None:
            self.save_mode = save_mode
        if options is not None:
            self.options = options

    @property
    def format(self):
        """Gets the format of this PredictionJobConfigGcsSink.  # noqa: E501


        :return: The format of this PredictionJobConfigGcsSink.  # noqa: E501
        :rtype: FileFormat
        """
        return self._format

    @format.setter
    def format(self, format):
        """Sets the format of this PredictionJobConfigGcsSink.


        :param format: The format of this PredictionJobConfigGcsSink.  # noqa: E501
        :type: FileFormat
        """

        self._format = format

    @property
    def uri(self):
        """Gets the uri of this PredictionJobConfigGcsSink.  # noqa: E501


        :return: The uri of this PredictionJobConfigGcsSink.  # noqa: E501
        :rtype: str
        """
        return self._uri

    @uri.setter
    def uri(self, uri):
        """Sets the uri of this PredictionJobConfigGcsSink.


        :param uri: The uri of this PredictionJobConfigGcsSink.  # noqa: E501
        :type: str
        """

        self._uri = uri

    @property
    def result_column(self):
        """Gets the result_column of this PredictionJobConfigGcsSink.  # noqa: E501


        :return: The result_column of this PredictionJobConfigGcsSink.  # noqa: E501
        :rtype: str
        """
        return self._result_column

    @result_column.setter
    def result_column(self, result_column):
        """Sets the result_column of this PredictionJobConfigGcsSink.


        :param result_column: The result_column of this PredictionJobConfigGcsSink.  # noqa: E501
        :type: str
        """

        self._result_column = result_column

    @property
    def save_mode(self):
        """Gets the save_mode of this PredictionJobConfigGcsSink.  # noqa: E501


        :return: The save_mode of this PredictionJobConfigGcsSink.  # noqa: E501
        :rtype: SaveMode
        """
        return self._save_mode

    @save_mode.setter
    def save_mode(self, save_mode):
        """Sets the save_mode of this PredictionJobConfigGcsSink.


        :param save_mode: The save_mode of this PredictionJobConfigGcsSink.  # noqa: E501
        :type: SaveMode
        """

        self._save_mode = save_mode

    @property
    def options(self):
        """Gets the options of this PredictionJobConfigGcsSink.  # noqa: E501


        :return: The options of this PredictionJobConfigGcsSink.  # noqa: E501
        :rtype: dict(str, str)
        """
        return self._options

    @options.setter
    def options(self, options):
        """Sets the options of this PredictionJobConfigGcsSink.


        :param options: The options of this PredictionJobConfigGcsSink.  # noqa: E501
        :type: dict(str, str)
        """

        self._options = options

    def to_dict(self):
        """Returns the model properties as a dict"""
        result = {}

        for attr, _ in six.iteritems(self.swagger_types):
            value = getattr(self, attr)
            if isinstance(value, list):
                result[attr] = list(map(
                    lambda x: x.to_dict() if hasattr(x, "to_dict") else x,
                    value
                ))
            elif hasattr(value, "to_dict"):
                result[attr] = value.to_dict()
            elif isinstance(value, dict):
                result[attr] = dict(map(
                    lambda item: (item[0], item[1].to_dict())
                    if hasattr(item[1], "to_dict") else item,
                    value.items()
                ))
            else:
                result[attr] = value
        if issubclass(PredictionJobConfigGcsSink, dict):
            for key, value in self.items():
                result[key] = value

        return result

    def to_str(self):
        """Returns the string representation of the model"""
        return pprint.pformat(self.to_dict())

    def __repr__(self):
        """For `print` and `pprint`"""
        return self.to_str()

    def __eq__(self, other):
        """Returns true if both objects are equal"""
        if not isinstance(other, PredictionJobConfigGcsSink):
            return False

        return self.__dict__ == other.__dict__

    def __ne__(self, other):
        """Returns true if both objects are not equal"""
        return not self == other
