# -*- coding: utf-8 -*-
from setuptools import setup

package_dir = \
{'': 'src'}

packages = \
['ecscmdb']

package_data = \
{'': ['*']}

install_requires = \
['ecspylibs>=v1.1.21,<2.0.0']

entry_points = \
{'console_scripts': ['cmdb = ecscmdb.cmdb:main',
                     'cmdbdiff = ecscmdb.cmdbdiff:main']}

setup_kwargs = {
    'name': 'ecscmdb',
    'version': '1.6.33',
    'description': 'Dump the OpenManage database.',
    'long_description': '# ECScmdb\n\n# CLI Version\n    cmdb:     ecscmdb(1.6.29), ecspylibs(1.1.18)\n    cmdbdiff: ecscmdb(1.6.29), ecspylibs(1.1.18)\n\n# Summary of commands\n    cmdb:     Download the devices in the OpenManage database into a\n              spreadsheet, one work sheet for each device.\n\n    cmdbdiff: Compare two cmdb spreadsheets for differences.\n\n# Assumptions\nThe ecscmdb user needs to know:\n* how to run commands in a Linux environment.\n* how to install python packages in a virtualenv.\n* how to run python commands in a virtualenv.\n* how to configure yaml files.\n* some basic understanding of jinja2 variable used in the yaml file.\n\n# Installation\n    It is best to create a dedicated python virtualenv to install ecscmdb \n    into so as not to interfere with any other python packages installed \n    on your system.\n\n    # virtualenv .venv\n    # . .venv/bin/activate\n    # pip install ecscmdb\n\n# Setup\n\n## cmdb\n    Before cmdb can be used to gather OpenManage data, the files cmdb.yml \n    and cmdb.pw must be created.  They are both located in the directory \n    etc/ecscmdb, which is relative to the virtualenv directory ecscmdb was \n    installed in.\n\n### cmdb.yml\n    cmdb.yml is a yaml file. The yaml file can have multiple "config" \n    sections defined within it.  There must be at lease one config section.\n    Each config secion has the following fields:\n    \n    name:       The name of the config section (optional).\n    pw:         The location of the cmdb password file relative to \n                virtualenv base directory cmdb was installed in.\n    log_level:  The python log level cmdb will run at.  Must be one of \n                DEBUG, INFO, WARNING, ERROR, CRITICAL, or TRACE.\n    log_dir:    The location of the cmdb log directory relative to \n                virtualenv base directory cmdb was installed in. \n    OME_Login:  The User ID of the OpenManage server that will be used \n                to gather the data.\n    poolsize:   The number of python ProcessPoolExecutor pools that will\n                be used to gather the OpenManage data.\n    output:     The location of the cmdb output file that the cmdb \n                spreadsheet will be written to.  The name of the file can\n                include the jinja2 variable "{{ TOD }}" to include the \n                current date and time.\n\n    In addition to the config section(s), the yaml file also must include \n    the yaml variable "section:" which indicates which of the config sections\n    to process.\n\n### cmdb.yml example file\n```\nHere is an example cmdb.yml file with two config sections.  Because the\n"section:" variable is set to 2 in this example the second section, with \nname "Configuration file Testing", will be used.\n\n---\nsection: 2\nconfig:\n  - name: Configuration file Production.\n    pw: etc/ecscmdb/cmdb.pw\n    log_level: warning\n    log_dir: log\n    OME_Login: CMDB\n    poolsize: 12\n    output: output/OpenManage-cmdb.{{ TOD }}.xlsx\n  - name: Configuration file Testing.\n    pw: etc/ecscmdb/cmdb.pw\n    log_level: TRACE\n    log_dir: log\n    OME_Login: CMDB\n    poolsize: 24\n    output: output/OpenManage-test-cmdb.{{ TOD }}.xlsx\n...\n```\n\n### cmdb.pw\n    cmdb.pw is a python AES encripted password file.  It must contain the\n    following two entries: \n\n1. A key that matches the OME_Login variable from the cmdb.yml file. The value of the entry is the password for that user.\n2. A key named "OMEHost" (case-sensitive string).  The value of the entry is the URL for the OpenManage host.\n\n### Adding or updating an entry in the cmdb.pw file\n    Execute "cmdb --add=STRING", where STRING is the key to be created or\n    updated.  cmdb will then prompt for the value for the given key.  The \n    entries are encripted and stored in the cmdb.pw file.\n\n### Example \n    # cmdb --add=xyzzy\n    Enter password for user \'xyzzy\':\n    #\n\n### Deleting an entry from the cmdb.pw file\n    Execute "cmdb --delete=STRING", where STRING is the key to be deleted.\n    The entries will be deleted without prompting.\n\n### Example\n    # cmdb --delete=xyzzy\n    #\n\n### List the keys or keys/values stored n the cmdb.pw file\n    Execute "cmdb --list" to list all of the keys in the cmdb.pw file, or\n    "cmdb --list --verbose" to list both the keys and the values for each \n    key.\n\n### Examples\n    # cmdb --list\n    # cmdb --list --verbose\n\n## cmdbdiff\n    Before cmdbdiff can be used to compare two OpenManage spreadsheets, \n    created using the cmdb command, the file cmdbdiff.yml must be created. \n    This file is located in the directory etc/ecscmdb, which is relative \n    to the virtualenv directory ecscmdb was installed in.\n\n### cmdbdiff.yml\n    cmdbdiff.yml is a yaml file. The yaml file can have multiple "config" \n    sections defined within it.  There must be at least one config section \n    in it.  In addition to the config section(s), the yaml file also must \n    include the yaml variable "section:" which indicates which of the config \n    sections to process.st be at lease one config section.  Each config \n    secion has the following fields:\n\n    name:                       The name of the configuration section \n                                (optional).\n    admin:                      The Admin managing cmdbdiff.\n        name:                   The Admin name.\n        email:                  The Admin email address.\n        phone:                  The Admin phone number.\n    log_level:                  The python log level cmdb will run at.  \n                                Must be one of DEBUG, INFO, WARNING, ERROR, \n                                CRITICAL, or TRACE.\n    log_dir:                    The location of the cmdb log directory \n                                relative to virtualenv base directory cmdb \n                                was installed in.\n    report:                     The location of the cmdbdiff report file \n                                that cmdbdiff writes to.  The name of the \n                                file can include the jinja2 variable \n                                "{{ TOD }}" to include the current date and \n                                time.\n    email:                      The email section indicates who should \n                                receive a copy of the cmdbdiff report.\n        subject:                The subject line of the report email.\n        from:                   The name and email address of the user \n                                sending the report.\n            name:               The sending name.\n            email:              The sending email address.\n        to:                     A list of zero or more "to" email addresses.\n            name:               The outgoing name.\n            email:              The outgoing email address.\n        cc:                     A list of zero or more "cc" email addresses. \n            name:               The outgoing name.\n            email:              The outgoing email address.\n        text:                   The text of the email that is sent.\n            with_changes:       The text of the email being if there are \n                                changes between the spreadsheets being \n                                checked.\n            without_changes:    The text of the email being if there are no \n                                changes between the spreadsheets being \n                                checked. \n\n    In addition to the config section(s), the yaml file also must include \n    the yaml variable "section:" which indicates which of the config sections\n    to process.\n\n### jinja2 variables used in the cmdbdiff.yml file\n```\nThere are several jinja2 variables that can be used in the cmdbdiff.yml \nconfiguration file.  Here is a list with a description of their values:\n\nTOD:            The current Date and Time.\nDATE:           The currect Date.\nTIME:           The current Time.\nHOST:           The Host name the report was generated on.\nVERSION:        The Version of the cmdbdiff program.\nSPREADSHEET1:   The name of the first spreadsheet being checked.\nWORKSHEETS1:    The number of Worksheets in the spreadsheet 1.\nSPREADSHEET2:   The name of the second spreadsheet being checked.\nWORKSHEETS2:    The number of Worksheets in the spreadsheet 2.\nREPORT:         The name of the report file (from config.report).\nADMINNAME:      The name of the cmdbdiff Admin (from config.admin.name).\nADMINEMAIL:     The email address of the cmdbdiff Admin (from \n                config.admin.email).\nADMINPHONE:     The phone number of the cmdbdiff Admin (from \n                config.admin.phone).\n```\n\n### cmdbdiff.yml example file\n```\nHere is an example cmdb.yml file with one config sections.  The "section:" \nvariable is set to 1 in this example the second section, with name \n"Configuration file Production", will be used.\n\n---\nsection: 1\nconfig:\n  - name: Configuration file Production.\n    admin:\n      name: Bill Jones\n      email: BJ@example.com\n      phone: 999.555.1234\n    log_level: warning\n    log_dir: log\n    report: report/OpenManage-cmdbdiff-{{ TOD }}.xlsx\n    email:\n      subject: CMDB Diff Report generated on {{ DATE }} at {{ TIME }} on server {{ HOST }}.\n      from:\n        name: CMDB Diff Report\n        email: CMDB-Diff-Report@{{ HOST }}\n      to:\n        -\n          name: John Smith\n          email: JS@example.com\n        -\n          name: Steve Thomas\n          email: ST@example.com\n      cc:\n        -\n          name: Tim George\n          email: TG@example.com\n      text:\n        with_changes:\n\n          "\\nCMDB Diff report, Version {{ VERSION }}, generated on {{ DATE\n          }} at {{ TIME }} on server {{ HOST }}.\\n\n\n          There are three attached spreadsheets in this report:\\n\n\n          1) {{ SPREADSHEET1 }}, is the previous CMDB spreadsheet with\n          {{ WORKSHEETS1 }} worksheets.\\n\n\n          2) {{ SPREADSHEET2 }}, is an currect CMDB spreadsheet with {{\n          WORKSHEETS2 }} worksheets.\\n\n\n          3) {{ REPORT }}, lists the changes between {{ SPREADSHEET1 }}\n          and {{ SPREADSHEET2 }}.\\n\n\n          The first worksheet in {{ REPORT }} lists a summary of all\n          changes. The remaining worksheets in {{ REPORT }}, if any, are\n          copies of the worksheets in {{ SPREADSHEET2 }} that are\n          different from {{ SPREADSHEET1 }}.\\n\n\n          Contact {{ ADMINNAME }} at email address {{ ADMINEMAIL }} or\n          phone number {{ ADMINPHONE }} if you have questions or\n          concerns regarding any of the spreadsheets generated in this\n          report.\\n\n\n          Thanks!\\n"\n\n        without_changes:\n\n          "\\nCMDB Diff report, Version {{ VERSION }}, generated on {{ DATE\n          }} at {{ TIME }} on server {{ HOST }}.\\n\n\n          The CMDB Diff report found no changes between {{\n          SPREADSHEET1 }} and {{ SPREADSHEET1 }} on {{ DATE }}.\\n\n\n          There are three attached spreadsheets in this report:\\n\n\n          1) {{ SPREADSHEET1 }}, is the previous CMDB spreadsheet with\n          {{ WORKSHEETS1 }} worksheets.\\n\n\n          2) {{ SPREADSHEET2 }}, is an currect CMDB spreadsheet with {{\n          WORKSHEETS2 }} worksheets.\\n\n\n          3) {{ REPORT }}, lists the changes between {{ SPREADSHEET1 }}\n          and {{ SPREADSHEET2 }}.\\n\n\n          Contact {{ ADMINNAME }} at email address {{ ADMINEMAIL }} or\n          phone number {{ ADMINPHONE }} if you have questions or\n          concerns regarding any of the spreadsheets generated in this\n          report.\\n\n\n          Thanks!\\n"\n\n```\n\n# CLI Help text\n\n## # cmdb --help\n\n    Program to download the data from the OpenManage DB and build a spreadsheet.\n\n    Some default option values listed below can be overridden within the\n    configuration file.\n\n    Usage:\n      cmdb [-v] [-L LEVEL] [--LOG=DIR] [-F] [-c CONFIG] [-s SECTION] [-o OUTPUT] [-p PWFILE] [-D] [-P SIZE]\n      cmdb [-vl] [-L LEVEL] [--LOG=DIR] [-c CONFIG] [-s SECTION] [-a ID]... [-d ID]... [-p PWFILE] [-D]\n      cmdb (-h | --help | -V | --version)\n\n      There are no required options.\n\n    Options:\n      -h, --help                     Show this help message and exit.\n      -V, --version                  Show version information and exit.\n      -F, --full                     Show all data, no filtering.\n      -c CONFIG, --config=CONFIG     The configuration file.\n                                     Default: "/home/tom/Run/ECScmdb/Testing/etc/ecscmdb/cmdb.yml"\n      -s SECTION, --section=SECTION  The configuration file version (default\n                                     defined within the configuration file).\n      -o OUTPUT, --output=OUTPUT     Output file or directory.\n                                     Default: "/home/tom/Run/ECScmdb/Testing/output/OpenManage-cmdb.2023-02-08-18-14-30.xlsx"\n      -p PWFILE, --pw=PWFILE         The password file.  This file is used when a\n                                     login to a website or webpage is required.\n                                     Default: "/home/tom/Run/ECScmdb/Testing/etc/ecscmdb/cmdb.pw"\n      -l, --list                     List all of the IDs in the password file and\n                                     exit.  If both the --list and --verbose\n                                     options are included, list both IDs and\n                                     Passwords and exit.\n      -a ID, --add=ID                Add (or update) an ID and Password and exit.\n                                     Program will prompt for the Password to be\n                                     saved to the password file.\n      -d ID, --delete=ID             Delete an ID (if it exists) from the\n                                     password file and exit.\n      -v, --verbose                  Print verbose messages.\n      -L LEVEL, --log=LEVEL          Print log messages at log value LEVEL.\n                                     Valid levels are: TRACE, DEBUG, INFO, WARNING,\n                                     ERROR, and CRITICAL.\n                                     Default: WARNING\n      --LOG=DIR                      Log directory.\n                                     Default: "/home/tom/Run/ECScmdb/Testing/log/cmdb.log"\n      -D, --dryrun                   Only print out what would be done.\n      -P SIZE, --poolsize=SIZE       Call OpenManage using pools of size SIZE.\n                                     Default: set by the OS.\n\n## # cmdbdiff --help\n\n    Program to analyze two spreadsheets for differences.\n\n    Some default option values listed below can be overridden within the initialization file.\n\n    Usage:\n      cmdbdiff [-v] [-L LEVEL] [--LOG=DIR] [-c CONFIG] [-s SECTION] [-r REPORT] [-D] SPREADSHEET1 SPREADSHEET2\n      cmdbdiff (-h | --help | -V | --version)\n\n      Variables SPREADSHEET1 and SPREADSHEET2 are required, all other parameters are optional.\n\n    Options:\n      -h, --help                          Show this help message and exit.\n      -V, --version                       Show version information and exit.\n      -c CONFIG, --config=CONFIG          The configuration file.\n                                          Default: "/home/tom/Run/ECScmdb/Testing/etc/ecscmdb/cmdbdiff.yml"\n      -s SECTION, --section=SECTION       The configuration file version (default\n                                          defined within the configuration file).\n      -r REPORT, --report=REPORT          Report directory or file.\n      -v, --verbose                       Print verbose messages.\n      -L LEVEL, --log=LEVEL               Print log messages at log value LEVEL.\n                                          Valid levels are: TRACE, DEBUG, INFO, WARNING,\n                                          ERROR, and CRITICAL.\n                                          Default: "WARNING"\n      --LOG=DIR                           Log Directory,\n                                          Default: "/home/tom/Run/ECScmdb/Testing/log/cmdbdiff.log"\n      -D, --dryrun                        Only print out what would be done.\n \n# Git information\n[GIT Home][CMDB],\n[README File][README],\n[LICENSE File][LICENSE],\n[ChangeLog File][CHANGELOG],\n[pyproject.toml File][PYPROJECT].\n\n# About me\n[My contact information][About Me].\n\n[CMDB]: https://git.wayne.edu/ECS_Projects/ECScmdb\n[README]: https://git.wayne.edu/ECS_Projects/ECScmdb/-/blob/master/README.md\n[LICENSE]: https://git.wayne.edu/ECS_Projects/ECScmdb/-/blob/master/LICENSE.txt\n[CHANGELOG]: https://git.wayne.edu/ECS_Projects/ECScmdb/-/blob/master/ChangeLog\n[PYPROJECT]: https://git.wayne.edu/ECS_Projects/ECScmdb/-/blob/master/pyproject.toml\n[About Me]: https://About.Me/Thomas.R.Stevenson\n',
    'author': 'Thomas R. Stevenson',
    'author_email': 'aa0026@wayne.edu',
    'maintainer': 'Thomas R. Stevenson',
    'maintainer_email': 'aa0026@wayne.edu',
    'url': 'https://git.wayne.edu/ECS_Projects/ECScmdb.git',
    'package_dir': package_dir,
    'packages': packages,
    'package_data': package_data,
    'install_requires': install_requires,
    'entry_points': entry_points,
    'python_requires': '>=3.9,<4.0',
}


setup(**setup_kwargs)
