from os import path
from setuptools import setup, Extension
from setuptools.command.build_py import build_py

# svnrevision = '5781'

src_dir = 'src/'

version = '3.0.1'

class build_ext_first(build_py):
    def run(self):
        self.run_command('build_ext')
        return build_py.run(self)

THIS_FOLDER = path.split(path.abspath(__file__))[0]

setup(
    name="pycodcif",
    version=version,
    author="COD development team",
    description="COD CIF parser",
    long_description=open(path.join(THIS_FOLDER, 'README.rst')).read(),
    long_description_content_type='text/x-rst',
    author_email="grazulis@ibt.lt",
    maintainer="Andrius Merkys",
    maintainer_email="andrius.merkys@gmail.com",
    packages=['pycodcif'],
    package_dir={'pycodcif': '.'},
    url="http://wiki.crystallography.net/cod-tools/CIF-parser",
    project_urls={ 'Source': 'https://github.com/cod-developers/cod-tools' },
    license="LGPLv3",
    ext_modules=[
        Extension('pycodcif._pycodcif',
                  [src_dir + 'externals/cexceptions/cxprintf.c',
                   src_dir + 'externals/cexceptions/stringx.c',
                   src_dir + 'externals/cexceptions/allocx.c',
                   src_dir + 'externals/cexceptions/stdiox.c',
                   src_dir + 'externals/cexceptions/cexceptions.c',

                   src_dir + 'components/codcif/cif_options.c',
                   src_dir + 'components/codcif/common.c',
                   src_dir + 'components/codcif/ciftable.c',
                   src_dir + 'components/codcif/cif2_lexer.c',
                   src_dir + 'components/codcif/cifvalue.c',
                   src_dir + 'components/codcif/cifmessage.c',
                   src_dir + 'components/codcif/cif_grammar_flex.c',
                   src_dir + 'components/codcif/cif_lexer.c',
                   src_dir + 'components/codcif/cif.c',
                   src_dir + 'components/codcif/datablock.c',
                   src_dir + 'components/codcif/cif_compiler.c',
                   src_dir + 'components/codcif/cif_lex_buffer.c',
                   src_dir + 'components/codcif/ciflist.c',
                   src_dir + 'components/codcif/cif_grammar.tab.c',
                   src_dir + 'components/codcif/cif2_grammar.tab.c',

                   'pycodcif.i',
                   'pycodcif.c',
                  ],
                  define_macros=[
                    ('_YACC_',None),
                    ('YYDEBUG','1'),
                    # ('SVN_VERSION',svnrevision),
                  ],
                  include_dirs=[src_dir + 'externals/cexceptions',
                                src_dir + 'components/codcif']),
                ],
    cmdclass={'build_py':build_ext_first},
    # test_suite='nose.collector',
    # tests_require=['nose'],
)
