# This file was automatically generated by SWIG (http://www.swig.org).
# Version 3.0.12
#
# Do not make changes to this file unless you know what you are doing--modify
# the SWIG interface file instead.

from sys import version_info as _swig_python_version_info
if _swig_python_version_info >= (2, 7, 0):
    def swig_import_helper():
        import importlib
        pkg = __name__.rpartition('.')[0]
        mname = '.'.join((pkg, '_pycodcif')).lstrip('.')
        try:
            return importlib.import_module(mname)
        except ImportError:
            return importlib.import_module('_pycodcif')
    _pycodcif = swig_import_helper()
    del swig_import_helper
elif _swig_python_version_info >= (2, 6, 0):
    def swig_import_helper():
        from os.path import dirname
        import imp
        fp = None
        try:
            fp, pathname, description = imp.find_module('_pycodcif', [dirname(__file__)])
        except ImportError:
            import _pycodcif
            return _pycodcif
        try:
            _mod = imp.load_module('_pycodcif', fp, pathname, description)
        finally:
            if fp is not None:
                fp.close()
        return _mod
    _pycodcif = swig_import_helper()
    del swig_import_helper
else:
    import _pycodcif
del _swig_python_version_info

try:
    _swig_property = property
except NameError:
    pass  # Python < 2.2 doesn't have 'property'.

try:
    import builtins as __builtin__
except ImportError:
    import __builtin__

def _swig_setattr_nondynamic(self, class_type, name, value, static=1):
    if (name == "thisown"):
        return self.this.own(value)
    if (name == "this"):
        if type(value).__name__ == 'SwigPyObject':
            self.__dict__[name] = value
            return
    method = class_type.__swig_setmethods__.get(name, None)
    if method:
        return method(self, value)
    if (not static):
        if _newclass:
            object.__setattr__(self, name, value)
        else:
            self.__dict__[name] = value
    else:
        raise AttributeError("You cannot add attributes to %s" % self)


def _swig_setattr(self, class_type, name, value):
    return _swig_setattr_nondynamic(self, class_type, name, value, 0)


def _swig_getattr(self, class_type, name):
    if (name == "thisown"):
        return self.this.own()
    method = class_type.__swig_getmethods__.get(name, None)
    if method:
        return method(self)
    raise AttributeError("'%s' object has no attribute '%s'" % (class_type.__name__, name))


def _swig_repr(self):
    try:
        strthis = "proxy of " + self.this.__repr__()
    except __builtin__.Exception:
        strthis = ""
    return "<%s.%s; %s >" % (self.__class__.__module__, self.__class__.__name__, strthis,)

try:
    _object = object
    _newclass = 1
except __builtin__.Exception:
    class _object:
        pass
    _newclass = 0


import warnings
warnings.filterwarnings('ignore', category=UnicodeWarning)

def parse(filename,*args):
    import re

    try:
        if isinstance(filename,unicode):
            filename = filename.encode('utf-8')
    except NameError:
        pass

    prog = '-'
    try:
        import sys
        prog = sys.argv[0]
    except IndexError:
        pass

    options = {}
    if len(args) > 0:
        options = args[0]

    parse_results = parse_cif(filename,prog,options)
    data = parse_results['datablocks']
    messages = parse_results['messages']
    nerrors = parse_results['nerrors']

    for datablock in data:
        datablock['precisions'] = {}
        for tag in datablock['types'].keys():
            precisions, _ = extract_precision(datablock['values'][tag],
                                              datablock['types'][tag])
            if precisions is not None:
                datablock['precisions'][tag] = precisions
        for saveblock in datablock['save_blocks']:
            saveblock['precisions'] = {}
            for tag in saveblock['types'].keys():
                precisions, _ = extract_precision(saveblock['values'][tag],
                                                  saveblock['types'][tag])
                if precisions is not None:
                    saveblock['precisions'][tag] = precisions

    data = [ decode_utf8_frame( _ ) for _ in data ]

    errors = []
    warnings = []

    for message in messages:
        datablock = message['addpos']
        if datablock is not None:
            datablock = "data_{0}".format(datablock)
        explanation = message['explanation']
        if explanation is not None:
            explanation = explanation[0].lower() + explanation[1:]
        lineno = None
        if 'lineno' in message:
            lineno = message['lineno']
        columnno = None
        if 'columnno' in message:
            columnno = message['columnno']
        msg = sprint_message(message['program'],
                             message['filename'],
                             datablock,
                             message['status'],
                             message['message'],
                             explanation,
                             lineno,
                             columnno,
                             message['line'])

        if message['status'] == 'ERROR':
            errors.append(msg)
        else:
            warnings.append(msg)

    if 'no_print' not in options.keys() or options['no_print'] == 0:
        for warning in warnings:
            sys.stdout.write(warning)
        for error in errors:
            sys.stdout.write(error)
        if errors:
            raise CifParserException(errors.pop())

    return data, nerrors, [warnings + errors]

def extract_precision(values,types):
    import re
    if isinstance(types,list):
        precisions = []
        important = []
        for i in range(0,len(values)):
            precision, is_important = \
                extract_precision(values[i],types[i])
            precisions.append(precision)
            important.append(is_important)
        if any([x == 1 for x in important]):
            return precisions, 1
        else:
            return None, 0
    elif isinstance(types,dict):
        precisions = {}
        for i in values.keys():
            precision, is_important = \
                extract_precision(values[i],types[i])
            if is_important:
                precisions[i] = precision
        if precisions.keys():
            return precisions, 1
        else:
            return None, 0
    elif types == 'FLOAT':
        match = re.search('^(.*)(\(([0-9]+)\))$',values)
        if match is not None and match.group(1):
            return unpack_precision(match.group(1), \
                                    float(match.group(3))), 1
        else:
            return None, 1
    elif types == 'INT':
        match = re.search('^(.*)(\(([0-9]+)\))$',values)
        if match is not None and match.group(1):
            return match.group(3), 1
        else:
            return None, 1
    else:
        return None, 0

def decode_utf8_frame(frame):
    for _ in [ 'name', 'tags', 'loops' ]:
        if _ in frame.keys():
            frame[_] = decode_utf8_values(frame[_])

    for _ in [ 'precisions', 'inloop', 'values', 'types' ]:
        if _ in frame.keys():
            frame[_] = decode_utf8_hash_keys(frame[_])

    if 'values' in frame.keys() and 'types' in frame.keys():
        frame['values'] = decode_utf8_typed_values(frame['values'],
                                                   frame['types'])

    if 'save_blocks' in frame.keys():
        frame['save_blocks'] = [ decode_utf8_frame(_) for _ in
                                        frame['save_blocks'] ]

    return frame

def decode_utf8_hash_keys(values):
    if isinstance(values,list):
        for i in range(0,len(values)):
            values[i] = decode_utf8_hash_keys(values[i])
    elif isinstance(values,dict):
        for key in values.keys():
            values[key] = decode_utf8_hash_keys(values[key])
            new_key = decode_utf8_values(key)
            if new_key != key:
                values[new_key] = values[key]
                del values[key]

    return values

def decode_utf8_values(values):
    if isinstance(values,list):
        for i in range(0,len(values)):
            values[i] = decode_utf8_values(values[i])
    elif isinstance(values,dict):
        for key in values.keys():
            values[key] = decode_utf8_hash_keys(values[key])
    else:
        try:
            values = values.decode('utf-8','replace')
        except AttributeError:
            pass

    return values

def decode_utf8_typed_values(values,types):
    if isinstance(values,list):
        for i in range(0,len(values)):
            values[i] = decode_utf8_typed_values(values[i], types[i])
    elif isinstance(values,dict):
        for key in values.keys():
            values[key] = decode_utf8_typed_values(values[key], types[key])
    elif types not in [ 'INT', 'FLOAT' ]:
        values = decode_utf8_values(values)

    return values

program_escape = {
    '&': '&amp;',
    ':': '&colon;',
}
filename_escape = {
    '&': '&amp;',
    ':': '&colon;',
    ' ': '&nbsp;',
    '(': '&lpar;',
    ')': '&rpar;',
}
datablock_escape = {
    '&': '&amp;',
    ':': '&colon;',
    ' ': '&nbsp;',
}
message_escape = {
    '&': '&amp;',
    ':': '&colon;'
}

def sprint_message(program, filename, datablock, errlevel, message,
                   explanation, line, column, line_contents):
    """
    Adapted from:
    URL: svn://www.crystallography.net/cod-tools/trunk/src/lib/perl5/COD/UserMessage.pm
    Relative URL: ^/trunk/src/lib/perl5/COD/UserMessage.pm
    Repository Root: svn://www.crystallography.net/cod-tools
    Repository UUID: 04be6746-3802-0410-999d-98508da1e98c
    Revision: 3813
    """
    import re
    message = re.sub('\.?\n?$', '', message)
    if explanation is not None:
        explanation = re.sub('\.?\n?$', '', explanation)
    if line_contents is not None:
        line_contents = re.sub('\n+$', '', line_contents)

    if program == '-c':
        program = "python -c '...'"

    program     = escape_meta(program,     program_escape)
    filename    = escape_meta(filename,    filename_escape)
    datablock   = escape_meta(datablock,   datablock_escape)
    message     = escape_meta(message,     message_escape)
    explanation = escape_meta(explanation, message_escape)

    if line_contents is not None:
        line_contents = '\n'.join([ " {0}".format(x) for x in line_contents.split('\n') ])

    msg = "{0}: ".format(program)
    if filename is not None:
        msg = "{0}{1}".format(msg, filename)
        if line is not None:
            msg = "{0}({1}".format(msg, line)
            if column is not None:
                msg = "{0},{1}".format(msg, column)
            msg = "{0})".format(msg)
        if datablock is not None:
            msg = "{0} {1}".format(msg, datablock)
        msg = "{0}: ".format(msg)
    if errlevel is not None:
        msg = "{0}{1}, ".format(msg, errlevel)
    msg = "{0}{1}".format(msg, message)
    if explanation is not None:
        msg = "{0} -- {1}".format(msg, explanation)
    if line_contents is not None:
        msg = "{0}:\n{1}\n".format(msg, line_contents)
        if column is not None:
            msg = "{0} {1}^\n".format(msg, " "*(column-1))
    else:
        msg = "{0}.\n".format(msg)

    return msg

def escape_meta(text, escaped_symbols):
    """
    Adapted from:
    URL: svn://www.crystallography.net/cod-tools/trunk/src/lib/perl5/COD/UserMessage.pm
    Relative URL: ^/trunk/src/lib/perl5/COD/UserMessage.pm
    Repository Root: svn://www.crystallography.net/cod-tools
    Repository UUID: 04be6746-3802-0410-999d-98508da1e98c
    Revision: 3813
    """
    import re

    if text is None:
        return None

    symbols = "|".join(["\\{0}".format(x) for x in escaped_symbols.keys()])

    def escape_internal(matchobj):
        return escaped_symbols[matchobj.group(0)]

    return re.sub("({0})".format(symbols), escape_internal, text)

class CifParserException(Exception):
    pass

class CifUnknownValue(object):
    pass

class CifInapplicableValue(object):
    pass

class CifFile(object):
    def __init__(self, file = None, parser_options = {}):
        if file is None:
# Create an empty CifFile object
            self._cif = new_cif( None )
        else:
# Parse CIF file
            self._cif = new_cif_from_cif_file( file, parser_options, None )

    def __getitem__(self, key):
        datablock = cif_datablock_list( self._cif )
        if isinstance(key, int):
            for i in range(0,key):
                if datablock is None:
                    raise IndexError('list index out of range')
                datablock = datablock_next( datablock )
            if datablock is None:
                raise IndexError('list index out of range')
            return CifDatablock(datablock = datablock)
        else:
            while datablock_name( datablock ) != key:
                datablock = datablock_next( datablock )
                if datablock is None:
                    raise KeyError(key)
            return CifDatablock(datablock = datablock)

    def __str__(self):
        with capture() as output:
            cif_print( self._cif )
        return output[0]

    def keys(self):
        keys = list()
        datablock = cif_datablock_list( self._cif )
        while datablock is not None:
            keys.append( datablock_name( datablock ) )
            datablock = datablock_next( datablock )
        return keys

    def append(self, datablock):
# must be a datablock!
        cif_append_datablock( self._cif, datablock._datablock )

class CifDatablock(object):
    def __init__(self, name = None, datablock = None):
        if datablock is None:
            self._datablock = new_datablock( name, None, None )
        else:
            self._datablock = datablock

    def __getitem__(self, key):
        tag_index = datablock_tag_index( self._datablock, key )
        if tag_index == -1:
            raise KeyError(key)
        values = []
        for i in range(0, datablock_value_length( self._datablock,
                                                  tag_index )):
            values.append( extract_value( datablock_cifvalue( self._datablock,
                                                              tag_index, i ) ) )
        return values

    def __setitem__(self, key, value):
        if not isinstance(value, list):
            value = [ value ]
        tag_index = datablock_tag_index( self._datablock, key )
        if tag_index == -1:
            if len(value) == 1:
                datablock_insert_cifvalue( self._datablock, key, value[0], None )
            else:
                self.add_loop( [ key ], [ [x] for x in value ] )
        elif len(value) > 1:
            raise ValueError( "cannot overwrite data item with a loop" )
        elif datablock_tag_in_loop( self._datablock, tag_index ) != -1:
            raise ValueError( "cannot overwrite a loop" )
        else:
            datablock_overwrite_cifvalue( self._datablock, tag_index, 0, value[0], None )

    def keys(self):
        length = datablock_length( self._datablock )
        return [ datablock_tag( self._datablock, x) for x in range(0, length) ]

    def add_loop(self, keys, values):
        for key in keys:
            if key in self.keys():
                raise KeyError( "data item '{}' already exists".format(key) )
        datablock_start_loop( self._datablock )
        for i in range(0,len(values)):
            for j, key in enumerate(keys):
                if i == 0:
                    datablock_insert_cifvalue( self._datablock, key,
                                               values[i][j], None )
                else:
                    datablock_push_loop_cifvalue( self._datablock,
                                                  values[i][j], None )
        datablock_finish_loop( self._datablock, None )

import contextlib

@contextlib.contextmanager
def capture():
    import sys
    from io import StringIO
    oldout,olderr = sys.stdout, sys.stderr
    try:
        out=[StringIO(), StringIO()]
        sys.stdout,sys.stderr = out
        yield out
    finally:
        sys.stdout,sys.stderr = oldout, olderr
        out[0] = out[0].getvalue()
        out[1] = out[1].getvalue()



def parse_cif(fname, prog, options):
    return _pycodcif.parse_cif(fname, prog, options)
parse_cif = _pycodcif.parse_cif

def cif_option_default():
    return _pycodcif.cif_option_default()
cif_option_default = _pycodcif.cif_option_default

def new_value_from_scalar(s, type, ex):
    return _pycodcif.new_value_from_scalar(s, type, ex)
new_value_from_scalar = _pycodcif.new_value_from_scalar

def value_dump(value):
    return _pycodcif.value_dump(value)
value_dump = _pycodcif.value_dump

def new_datablock(name, next, ex):
    return _pycodcif.new_datablock(name, next, ex)
new_datablock = _pycodcif.new_datablock

def datablock_next(datablock):
    return _pycodcif.datablock_next(datablock)
datablock_next = _pycodcif.datablock_next

def datablock_length(datablock):
    return _pycodcif.datablock_length(datablock)
datablock_length = _pycodcif.datablock_length

def datablock_value_lengths(datablock):
    return _pycodcif.datablock_value_lengths(datablock)
datablock_value_lengths = _pycodcif.datablock_value_lengths

def datablock_cifvalue(datablock, tag_nr, val_nr):
    return _pycodcif.datablock_cifvalue(datablock, tag_nr, val_nr)
datablock_cifvalue = _pycodcif.datablock_cifvalue

def datablock_tag_index(datablock, tag):
    return _pycodcif.datablock_tag_index(datablock, tag)
datablock_tag_index = _pycodcif.datablock_tag_index

def datablock_overwrite_cifvalue(datablock, tag_nr, val_nr, value, ex):
    return _pycodcif.datablock_overwrite_cifvalue(datablock, tag_nr, val_nr, value, ex)
datablock_overwrite_cifvalue = _pycodcif.datablock_overwrite_cifvalue

def datablock_insert_cifvalue(datablock, tag, value, ex):
    return _pycodcif.datablock_insert_cifvalue(datablock, tag, value, ex)
datablock_insert_cifvalue = _pycodcif.datablock_insert_cifvalue

def datablock_start_loop(datablock):
    return _pycodcif.datablock_start_loop(datablock)
datablock_start_loop = _pycodcif.datablock_start_loop

def datablock_finish_loop(datablock, ex):
    return _pycodcif.datablock_finish_loop(datablock, ex)
datablock_finish_loop = _pycodcif.datablock_finish_loop

def datablock_push_loop_cifvalue(datablock, value, ex):
    return _pycodcif.datablock_push_loop_cifvalue(datablock, value, ex)
datablock_push_loop_cifvalue = _pycodcif.datablock_push_loop_cifvalue

def datablock_name(datablock):
    return _pycodcif.datablock_name(datablock)
datablock_name = _pycodcif.datablock_name

def new_cif(ex):
    return _pycodcif.new_cif(ex)
new_cif = _pycodcif.new_cif

def cif_start_datablock(cif, name, ex):
    return _pycodcif.cif_start_datablock(cif, name, ex)
cif_start_datablock = _pycodcif.cif_start_datablock

def cif_append_datablock(cif, datablock):
    return _pycodcif.cif_append_datablock(cif, datablock)
cif_append_datablock = _pycodcif.cif_append_datablock

def cif_print(cif):
    return _pycodcif.cif_print(cif)
cif_print = _pycodcif.cif_print

def cif_datablock_list(cif):
    return _pycodcif.cif_datablock_list(cif)
cif_datablock_list = _pycodcif.cif_datablock_list

def new_cif_from_cif_file(filename, co, ex):
    return _pycodcif.new_cif_from_cif_file(filename, co, ex)
new_cif_from_cif_file = _pycodcif.new_cif_from_cif_file

def unpack_precision(value, precision):
    return _pycodcif.unpack_precision(value, precision)
unpack_precision = _pycodcif.unpack_precision

def extract_value(cifvalue):
    return _pycodcif.extract_value(cifvalue)
extract_value = _pycodcif.extract_value

def extract_parser_options(options):
    return _pycodcif.extract_parser_options(options)
extract_parser_options = _pycodcif.extract_parser_options

def datablock_value_length(datablock, tag_index):
    return _pycodcif.datablock_value_length(datablock, tag_index)
datablock_value_length = _pycodcif.datablock_value_length

def datablock_tag(datablock, tag_index):
    return _pycodcif.datablock_tag(datablock, tag_index)
datablock_tag = _pycodcif.datablock_tag

def datablock_tag_in_loop(datablock, tag_index):
    return _pycodcif.datablock_tag_in_loop(datablock, tag_index)
datablock_tag_in_loop = _pycodcif.datablock_tag_in_loop
# This file is compatible with both classic and new-style classes.


