
class Label(object):
    def __init__(self, labeldict):
        pass

    
def _v1_applabel_to_piplabel(k=None):
    d = {"P002_P002C001_Closing": "person_closes_car_door",
         "P002_P002C001_Entering": "person_enters_car",
         "P002_P002C001_Exiting": "person_exits_car",
         "P002_P002C001_Opening": "person_opens_car_door",
         "P002_P002C002_Closing": "person_closes_car_trunk",
         "P002_P002C002_Loading": "person_loads_car",
         "P002_P002C002_Opening": "person_opens_car_trunk",
         "P002_P002C002_Unloading": "person_unloads_car",
         "P002_P002C003_Turning left": "car_turns_left",
         "P002_P002C003_Turning right": "car_turns_right",
         "P002_P002C003_U-turn": "car_makes_u_turn",
         "P002_P002C004_Picking up": "car_picks_up_person",
         "P002_P002C004_Starting": "car_starts",
         "P002_P002C004_Stopping": "car_stops",
         "P002_P002C005_Dropping off": "car_drops_off_person",
         "P002_P002C005_Starting": "car_starts",
         "P002_P002C005_Stopping": "car_stops",
         "P002_P002C006_Transferring": "person_transfers_object_to_car",
         "P002_P002C007_Reversing": "car_reverses",
         "P003_P003C001_Closing": "person_closes_motorcycle_door",  # remove me, meaningless
         "P003_P003C001_Entering": "person_enters_motorcycle",
         "P003_P003C001_Exiting": "person_exits_motorcycle",
         "P003_P003C001_Opening": "person_opens_motorcycle_door",  # remove me, meaningless
         "P003_P003C002_Closing": "person_closes_motorcycle_trunk",
         "P003_P003C002_Loading": "person_loads_motorcycle",
         "P003_P003C002_Opening": "person_opens_motorcycle_trunk",
         "P003_P003C002_Unloading": "person_unloads_motorcycle",
         "P003_P003C003_Turning left": "motorcycle_turns_left",
         "P003_P003C003_Turning right": "motorcycle_turns_right",
         "P003_P003C003_U-turn": "motorcycle_makes_u_turn",
         "P003_P003C004_Picking up": "motorcycle_picks_up_person",
         "P003_P003C004_Starting": "motorcycle_starts",
         "P003_P003C004_Stopping": "motorcycle_stops",
         "P003_P003C005_Dropping off": "motorcycle_drops_off_person",
         "P003_P003C005_Starting": "motorcycle_starts",
         "P003_P003C005_Stopping": "motorcycle_stops",
         "P003_P003C006_Transferring": "person_transfers_object_to_motorcycle",
         "P003_P003C007_Reversing": "motorcycle_reverses",
         "P004_P004C001_Closing": "person_closes_facility_door",
         "P004_P004C001_Entering": "person_enters_scene_through_structure",
         "P004_P004C001_Exiting": "person_exits_scene_through_structure",
         "P004_P004C001_Opening": "person_opens_facility_door",
         "P004_P004C002_Entering": "person_enters_scene_through_structure",
         "P004_P004C002_Exiting": "person_exits_scene_through_structure",
         "P004_P004C003_Reading": "person_reads_document",
         "P004_P004C003_Sitting": "person_sits_down",
         "P004_P004C003_Standing": "person_stands_up",
         "P004_P004C004_Dropping off": "person_puts_down_object",
         "P004_P004C004_Picking up": "person_picks_up_object",
         "P004_P004C005_Abandoning": "person_abandons_package",
         "P004_P004C005_Sets down": "person_puts_down_object",
         "P004_P004C006_Carrying": "person_carries_heavy_object",
         "P004_P004C007_Talking on": "person_talks_on_phone",
         "P004_P004C007_Texting on": "person_texts_on_phone",
         "P004_P004C008_Sitting": "person_sits_down",
         "P004_P004C008_Standing": "person_stands_up",
         "P004_P004C008_Using laptop": "person_interacts_with_laptop",
         "P004_P004C009_Purchasing": "person_purchases_from_machine",
         "P004_P004C010_Dropping off": "person_puts_down_object",
         "P004_P004C010_Picking up": "person_picks_up_object",
         "P004_P004C010_Riding": "person_rides_bicycle",
         "P005_P005C001_Talking to": "person_talks_to_person",
         "P005_P005C001_Touching hands": "hand_interacts_with_person_highfive",
         "P005_P005C002_Stealing": "person_steals_object",
         "P005_P005C003_Purchasing": "person_purchases_from_cashier",  # Remove me
         "P005_P005C004_Transferring": "person_transfers_object_to_person",
         "P005_P005C005_Hugging": "person_embraces_person",
         "P005_P005C005_Touching hands": "hand_interacts_with_person_holdhands",
         "P005_P005C006_Talking to": "person_talks_to_person",
         "P005_P005C006_Touching hands": "hand_interacts_with_person_shakehands",
    }
    return d[k] if k is not None else d


def piplabel_to_mevalabel():
    d = {v: v for (k, v) in _v1_applabel_to_piplabel().items()}

    d = {k: "hand_interacts_with_person" if "hand" in v else v for (k, v) in d.items()}
    d = {
        k: v.replace("car", "vehicle")
        if (("_car" in v or "car_" in v) and ("carries" not in v))
        else v
        for (k, v) in d.items()
    }
    d = {
        k: v.replace("motorcycle", "vehicle") if "motorcycle" in v else v
        for (k, v) in d.items()
    }
    d = {
        k: v.replace("vehicle_trunk", "trunk") if "vehicle_trunk" in v else v
        for (k, v) in d.items()
    }
    d["person_transfers_object_to_car"] = "person_transfers_object"
    d["person_transfers_object_to_motorcycle"] = "person_transfers_object"
    d["person_transfers_object_to_person"] = "person_transfers_object"
    d["person_purchases_from_machine"] = "person_purchases"
    d["person_purchases_from_cashier"] = "person_purchases"
    d = {
        k: v
        for (k, v) in d.items()
        if k
        not in set(["person_closes_motorcycle_door", "person_opens_motorcycle_door"])
    }
    return d


def mevalabel_to_index():

    return {
        "hand_interacts_with_person": 0,
        "person_abandons_package": 1,
        "person_carries_heavy_object": 2,
        "person_closes_facility_door": 3,
        "person_closes_trunk": 4,
        "person_closes_vehicle_door": 5,
        "person_embraces_person": 6,
        "person_enters_scene_through_structure": 7,
        "person_enters_vehicle": 8,
        "person_exits_scene_through_structure": 9,
        "person_exits_vehicle": 10,
        "person_interacts_with_laptop": 11,
        "person_loads_vehicle": 12,
        "person_opens_facility_door": 13,
        "person_opens_trunk": 14,
        "person_opens_vehicle_door": 15,
        "person_picks_up_object": 16,
        "person_purchases": 17,
        "person_puts_down_object": 18,
        "person_reads_document": 19,
        "person_rides_bicycle": 20,
        "person_sits_down": 21,
        "person_stands_up": 22,
        "person_steals_object": 23,
        "person_talks_on_phone": 24,
        "person_talks_to_person": 25,
        "person_texts_on_phone": 26,
        "person_transfers_object": 27,
        "person_unloads_vehicle": 28,
        "vehicle_drops_off_person": 29,
        "vehicle_makes_u_turn": 30,
        "vehicle_picks_up_person": 31,
        "vehicle_reverses": 32,
        "vehicle_starts": 33,
        "vehicle_stops": 34,
        "vehicle_turns_left": 35,
        "vehicle_turns_right": 36,
    }


def piplabel_to_index():
    return {
        "car_drops_off_person": 0,
        "car_makes_u_turn": 1,
        "car_picks_up_person": 2,
        "car_reverses": 3,
        "car_starts": 4,
        "car_stops": 5,
        "car_turns_left": 6,
        "car_turns_right": 7,
        "hand_interacts_with_person_highfive": 8,
        "hand_interacts_with_person_holdhands": 9,
        "hand_interacts_with_person_shakehands": 10,
        "motorcycle_drops_off_person": 11,
        "motorcycle_makes_u_turn": 12,
        "motorcycle_picks_up_person": 13,
        "motorcycle_reverses": 14,
        "motorcycle_starts": 15,
        "motorcycle_stops": 16,
        "motorcycle_turns_left": 17,
        "motorcycle_turns_right": 18,
        "person_abandons_package": 19,
        "person_carries_heavy_object": 20,
        "person_closes_car_door": 21,
        "person_closes_car_trunk": 22,
        "person_closes_facility_door": 23,
        "person_closes_motorcycle_trunk": 24,
        "person_embraces_person": 25,
        "person_enters_car": 26,
        "person_enters_scene_through_structure": 27,
        "person_exits_car": 28,
        "person_exits_scene_through_structure": 29,
        "person_interacts_with_laptop": 30,
        "person_loads_car": 31,
        "person_loads_motorcycle": 32,
        "person_opens_car_door": 33,
        "person_opens_car_trunk": 34,
        "person_opens_facility_door": 35,
        "person_opens_motorcycle_trunk": 36,
        "person_picks_up_object": 37,
        "person_purchases_from_machine": 38,
        "person_puts_down_object": 39,
        "person_reads_document": 40,
        "person_rides_bicycle": 41,
        "person_sits_down": 42,
        "person_stands_up": 43,
        "person_steals_object": 44,
        "person_talks_on_phone": 45,
        "person_talks_to_person": 46,
        "person_texts_on_phone": 47,
        "person_transfers_object_to_car": 48,
        "person_transfers_object_to_motorcycle": 49,
        "person_transfers_object_to_person": 50,
        "person_unloads_car": 51,
        "person_unloads_motorcycle": 52,
    }



def pip_250k_powerset():
    return {('car_drops_off_person',): 0,
            ('car_drops_off_person', 'car_starts'): 1,
            ('car_drops_off_person', 'car_starts', 'car_stops'): 2,
            ('car_drops_off_person', 'car_stops'): 3,
            ('car_makes_u_turn',): 4,
            ('car_makes_u_turn', 'car_turns_left'): 5,
            ('car_makes_u_turn', 'car_turns_left', 'car_turns_right'): 6,
            ('car_makes_u_turn', 'car_turns_right'): 7,
            ('car_picks_up_person',): 8,
            ('car_picks_up_person', 'car_starts'): 9,
            ('car_picks_up_person', 'car_starts', 'car_stops'): 10,
            ('car_picks_up_person', 'car_stops'): 11,
            ('car_reverses',): 12,
            ('car_reverses', 'car_turns_left'): 13,
            ('car_reverses', 'car_turns_right'): 14,
            ('car_starts',): 15,
            ('car_starts', 'car_stops'): 16,
            ('car_starts', 'car_turns_left'): 17,
            ('car_starts', 'car_turns_right'): 18,
            ('car_stops',): 19,
            ('car_stops', 'car_turns_left'): 20,
            ('car_stops', 'car_turns_right'): 21,
            ('car_turns_left',): 22,
            ('car_turns_left', 'car_turns_right'): 23,
            ('car_turns_right',): 24,
            ('hand_interacts_with_person_highfive',): 25,
            ('hand_interacts_with_person_highfive', 'person_talks_to_person'): 26,
            ('motorcycle_drops_off_person',): 27,
            ('motorcycle_drops_off_person', 'motorcycle_starts'): 28,
            ('motorcycle_drops_off_person', 'motorcycle_starts', 'motorcycle_stops'): 29,
            ('motorcycle_drops_off_person', 'motorcycle_stops'): 30,
            ('motorcycle_makes_u_turn',): 31,
            ('motorcycle_makes_u_turn', 'motorcycle_turns_left'): 32,
            ('motorcycle_makes_u_turn',
             'motorcycle_turns_left',
             'motorcycle_turns_right'): 33,
            ('motorcycle_makes_u_turn', 'motorcycle_turns_right'): 34,
            ('motorcycle_picks_up_person',): 35,
            ('motorcycle_picks_up_person', 'motorcycle_starts'): 36,
            ('motorcycle_picks_up_person', 'motorcycle_starts', 'motorcycle_stops'): 37,
            ('motorcycle_picks_up_person', 'motorcycle_stops'): 38,
            ('motorcycle_reverses',): 39,
            ('motorcycle_starts',): 40,
            ('motorcycle_starts', 'motorcycle_stops'): 41,
            ('motorcycle_stops',): 42,
            ('motorcycle_turns_left',): 43,
            ('motorcycle_turns_left', 'motorcycle_turns_right'): 44,
            ('motorcycle_turns_right',): 45,
            ('person',): 46,
            ('person_abandons_object',): 47,
            ('person_abandons_object', 'person_puts_down_object_on_floor'): 48,
            ('person_carries_heavy_object',): 49,
            ('person_closes_car_door',): 50,
            ('person_closes_car_door', 'person_enters_car'): 51,
            ('person_closes_car_door',
             'person_enters_car',
             'person_exits_car',
             'person_opens_car_door'): 52,
            ('person_closes_car_door', 'person_enters_car', 'person_opens_car_door'): 53,
            ('person_closes_car_door', 'person_exits_car'): 54,
            ('person_closes_car_door', 'person_exits_car', 'person_opens_car_door'): 55,
            ('person_closes_car_door', 'person_loads_car'): 56,
            ('person_closes_car_door', 'person_opens_car_door'): 57,
            ('person_closes_car_door', 'person_unloads_car'): 58,
            ('person_closes_car_trunk',): 59,
            ('person_closes_car_trunk', 'person_loads_car'): 60,
            ('person_closes_car_trunk', 'person_loads_car', 'person_opens_car_trunk'): 61,
            ('person_closes_car_trunk', 'person_opens_car_trunk'): 62,
            ('person_closes_car_trunk',
             'person_opens_car_trunk',
             'person_unloads_car'): 63,
            ('person_closes_car_trunk', 'person_unloads_car'): 64,
            ('person_closes_facility_door',): 65,
            ('person_closes_facility_door', 'person_enters_scene_through_structure'): 66,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_exits_scene_through_structure',
             'person_opens_facility_door'): 67,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_opens_facility_door'): 68,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_opens_facility_door',
             'person_talks_on_phone'): 69,
            ('person_closes_facility_door',
             'person_enters_scene_through_structure',
             'person_talks_on_phone'): 70,
            ('person_closes_facility_door', 'person_exits_scene_through_structure'): 71,
            ('person_closes_facility_door',
             'person_exits_scene_through_structure',
             'person_opens_facility_door'): 72,
            ('person_closes_facility_door',
             'person_exits_scene_through_structure',
             'person_opens_facility_door',
             'person_talks_on_phone'): 73,
            ('person_closes_facility_door',
             'person_exits_scene_through_structure',
             'person_talks_on_phone'): 74,
            ('person_closes_facility_door', 'person_opens_facility_door'): 75,
            ('person_closes_facility_door',
             'person_opens_facility_door',
             'person_talks_on_phone'): 76,
            ('person_closes_facility_door', 'person_talks_on_phone'): 77,
            ('person_closes_motorcycle_trunk',): 78,
            ('person_closes_motorcycle_trunk', 'person_loads_motorcycle'): 79,
            ('person_closes_motorcycle_trunk',
             'person_loads_motorcycle',
             'person_opens_motorcycle_trunk'): 80,
            ('person_closes_motorcycle_trunk', 'person_opens_motorcycle_trunk'): 81,
            ('person_closes_motorcycle_trunk',
             'person_opens_motorcycle_trunk',
             'person_unloads_motorcycle'): 82,
            ('person_closes_motorcycle_trunk', 'person_unloads_motorcycle'): 83,
            ('person_embraces_person',): 84,
            ('person_embraces_person', 'person_holds_hand'): 85,
            ('person_embraces_person', 'person_talks_to_person'): 86,
            ('person_enters_car',): 87,
            ('person_enters_car', 'person_opens_car_door'): 88,
            ('person_enters_scene_through_structure',): 89,
            ('person_enters_scene_through_structure',
             'person_exits_scene_through_structure'): 90,
            ('person_enters_scene_through_structure',
             'person_exits_scene_through_structure',
             'person_opens_facility_door'): 91,
            ('person_enters_scene_through_structure', 'person_opens_facility_door'): 92,
            ('person_enters_scene_through_structure', 'person_talks_on_phone'): 93,
            ('person_exits_car',): 94,
            ('person_exits_car', 'person_opens_car_door'): 95,
            ('person_exits_scene_through_structure',): 96,
            ('person_exits_scene_through_structure', 'person_opens_facility_door'): 97,
            ('person_exits_scene_through_structure', 'person_talks_on_phone'): 98,
            ('person_holds_hand',): 99,
            ('person_holds_hand', 'person_talks_to_person'): 100,
            ('person_interacts_with_laptop',): 101,
            ('person_interacts_with_laptop', 'person_sits_down'): 102,
            ('person_interacts_with_laptop', 'person_stands_up'): 103,
            ('person_loads_car',): 104,
            ('person_loads_car', 'person_opens_car_trunk'): 105,
            ('person_loads_motorcycle',): 106,
            ('person_loads_motorcycle', 'person_opens_motorcycle_trunk'): 107,
            ('person_opens_car_door',): 108,
            ('person_opens_car_trunk',): 109,
            ('person_opens_facility_door',): 110,
            ('person_opens_facility_door', 'person_talks_on_phone'): 111,
            ('person_opens_motorcycle_trunk',): 112,
            ('person_opens_motorcycle_trunk', 'person_unloads_motorcycle'): 113,
            ('person_picks_up_object_from_floor',): 114,
            ('person_picks_up_object_from_shelf',): 115,
            ('person_picks_up_object_from_table',): 116,
            ('person_picks_up_object_from_table',
             'person_puts_down_object_on_table',
             'person_reads_document'): 117,
            ('person_picks_up_object_from_table', 'person_reads_document'): 118,
            ('person_purchases_from_cashier',): 119,
            ('person_purchases_from_machine',): 120,
            ('person_puts_down_object_on_floor',): 121,
            ('person_puts_down_object_on_shelf',): 122,
            ('person_puts_down_object_on_table',): 123,
            ('person_puts_down_object_on_table', 'person_reads_document'): 124,
            ('person_reads_document',): 125,
            ('person_reads_document', 'person_sits_down'): 126,
            ('person_reads_document', 'person_sits_down', 'person_stands_up'): 127,
            ('person_reads_document', 'person_stands_up'): 128,
            ('person_rides_bicycle',): 129,
            ('person_shakes_hand',): 130,
            ('person_shakes_hand', 'person_talks_to_person'): 131,
            ('person_sits_down',): 132,
            ('person_stands_up',): 133,
            ('person_steals_object_from_person',): 134,
            ('person_talks_on_phone',): 135,
            ('person_talks_to_person',): 136,
            ('person_texts_on_phone',): 137,
            ('person_transfers_object_to_car',): 138,
            ('person_transfers_object_to_motorcycle',): 139,
            ('person_transfers_object_to_person',): 140,
            ('person_unloads_car',): 141,
            ('person_unloads_motorcycle',): 142}




pip_to_meva = {'person_enters_motorcycle': 'person_enters_vehicle',
               'person_exits_motorcycle': 'person_exits_vehicle',
               'person_closes_motorcycle_trunk': 'person_closes_trunk',
               'person_loads_motorcycle': 'person_loads_vehicle',
               'person_opens_motorcycle_trunk': 'person_opens_trunk',
               'person_unloads_motorcycle': 'person_unloads_vehicle',
               'motorcycle_turns_left': 'vehicle_turns_left',
               'motorcycle_turns_right': 'vehicle_turns_right',
               'motorcycle_makes_u_turn': 'vehicle_makes_u_turn',
               'motorcycle_picks_up_person': 'vehicle_picks_up_person',
               'motorcycle_starts': 'vehicle_starts',
               'motorcycle_stops': 'vehicle_stops',
               'motorcycle_drops_off_person': 'vehicle_drops_off_person',
               'person_transfers_object_to_motorcycle': 'person_transfers_object',
               'motorcycle_reverses': 'vehicle_reverses',
               'person_closes_car_door': 'person_closes_vehicle_door',
               'person_enters_car': 'person_enters_vehicle',
               'person_exits_car': 'person_exits_vehicle',
               'person_opens_car_door': 'person_opens_vehicle_door',
               'person_closes_car_trunk': 'person_closes_trunk',
               'person_loads_car': 'person_loads_vehicle',
               'person_opens_car_trunk': 'person_opens_trunk',
               'person_unloads_car': 'person_unloads_vehicle',
               'car_turns_left': 'vehicle_turns_left',
               'car_turns_right': 'vehicle_turns_right',
               'car_makes_u_turn': 'vehicle_makes_u_turn',
               'car_picks_up_person': 'vehicle_picks_up_person',
               'car_starts': 'vehicle_starts',
               'car_stops': 'vehicle_stops',
               'car_drops_off_person': 'vehicle_drops_off_person',
               'person_transfers_object_to_car': 'person_transfers_object',
               'car_reverses': 'vehicle_reverses',
               'person_closes_facility_door': 'person_closes_facility_door',
               'person_enters_scene_through_structure': 'person_enters_scene_through_structure',
               'person_comes_into_scene_through_structure': 'person_enters_scene_through_structure',
               'person_exits_scene_through_structure': 'person_exits_scene_through_structure',
               'person_leaves_scene_through_structure': 'person_exits_scene_through_structure',
               'person_opens_facility_door': 'person_opens_facility_door',
               'person_reads_document': 'person_reads_document',
               'person_sits_down': 'person_sits_down',
               'person_stands_up': 'person_stands_up',
               'person_picks_up_object_from_table': 'person_picks_up_object',
               'person_picks_up_object_from_floor': 'person_picks_up_object',
               'person_picks_up_object_from_shelf': 'person_picks_up_object',
               'person_puts_down_object_on_table': 'person_puts_down_object',
               'person_puts_down_object_on_floor': 'person_puts_down_object',
               'person_puts_down_object_on_shelf': 'person_puts_down_object',
               'person_puts_down_object': 'person_puts_down_object',
               'person_picks_up_object': 'person_picks_up_object',               
               'person_abandons_object': 'person_abandons_package',
               'person_abandons_bag': 'person_abandons_package',               
               'person_abandons_package': 'person_abandons_package',
               'person_carries_heavy_object': 'person_carries_heavy_object',
               'person_talks_on_phone': 'person_talks_on_phone',
               'person_texts_on_phone': 'person_texts_on_phone',
               'person_interacts_with_laptop': 'person_interacts_with_laptop',
               'person_purchases_from_machine': 'person_purchases',
               'person_purchases_from_cashier': 'person_purchases',               
               'person_rides_bicycle': 'person_rides_bicycle',
               'person_talks_to_person': 'person_talks_to_person',
               'hand_interacts_with_person_highfive': 'hand_interacts_with_person',
               'person_steals_object': 'person_steals_object',
               'person_steals_object_from_person': 'person_steals_object',
               'person_transfers_object_to_person': 'person_transfers_object',
               'person_embraces_person': 'person_embraces_person',
               'hand_interacts_with_person_holdhands': 'hand_interacts_with_person',
               'hand_interacts_with_person_shakehands': 'hand_interacts_with_person',
               'person_shakes_hand': 'hand_interacts_with_person',
               'person_holds_hand': 'hand_interacts_with_person'}
    

pip_to_shortlabel = {'car_drops_off_person': 'drops-off person',
                     'car_makes_u_turn': 'u-turn',
                     'car_picks_up_person': 'picks-up person',
                     'car_reverses': 'reverses',
                     'car_starts': 'starts',
                     'car_stops': 'stops',
                     'car_turns_left': 'turns left',
                     'car_turns_right': 'turns right',
                     'hand_interacts_with_person_highfive': 'high five',
                     'hand_interacts_with_person_holdhands': 'hold hands',
                     'hand_interacts_with_person_shakehands': 'shake hands',
                     'motorcycle_drops_off_person': 'drops-off person',
                     'motorcycle_makes_u_turn': 'u-turn',
                     'motorcycle_picks_up_person': 'picks-up person',
                     'motorcycle_reverses': 'reverses',
                     'motorcycle_starts': 'starts',
                     'motorcycle_stops': 'stops',
                     'motorcycle_turns_left': 'turns left',
                     'motorcycle_turns_right': 'turns right',
                     'person_abandons_object': 'abandons',                     
                     'person_abandons_bag': 'abandons',
                     'person_abandons_package': 'abandons',
                     'person_carries_heavy_object': 'carries',
                     'person_closes_car_door': 'closes car door',
                     'person_closes_car_trunk': 'closes trunk',
                     'person_closes_facility_door': 'closes door',
                     'person_closes_motorcycle_trunk': 'closes trunk',
                     'person_comes_into_scene_through_structure': 'enters scene',
                     'person_embraces_person': 'hugs',
                     'person_enters_car': 'enters car',
                     'person_enters_motorcycle': 'enters motorcycle',
                     'person_enters_scene_through_structure': 'enters scene',
                     'person_exits_car': 'exits car',
                     'person_exits_motorcycle': 'exits motorcycle',
                     'person_exits_scene_through_structure': 'exits scene',
                     'person_holds_hand': 'hold hands',
                     'person_interacts_with_laptop': 'uses laptop',
                     'person_leaves_scene_through_structure': 'exits scene',
                     'person_loads_car': 'loads',
                     'person_loads_motorcycle': 'loads',
                     'person_opens_car_door': 'opens car door',
                     'person_opens_car_trunk': 'opens trunk',
                     'person_opens_facility_door': 'opens door',
                     'person_opens_motorcycle_trunk': 'opens trunk',
                     'person_picks_up_object': 'picks up',
                     'person_picks_up_object_from_floor': 'picks up',
                     'person_picks_up_object_from_shelf': 'picks up',
                     'person_picks_up_object_from_table': 'picks up',
                     'person_purchases_from_cashier': 'purchases (cashier)',
                     'person_purchases_from_machine': 'purchases (machine)',
                     'person_puts_down_object': 'puts down',
                     'person_puts_down_object_on_floor': 'puts down',
                     'person_puts_down_object_on_shelf': 'puts down',
                     'person_puts_down_object_on_table': 'puts down',
                     'person_reads_document': 'reads',
                     'person_rides_bicycle': 'rides',
                     'person_shakes_hand': 'shake hands',
                     'person_sits_down': 'sits',
                     'person_stands_up': 'stands',
                     'person_steals_object': 'steals',
                     'person_steals_object_from_person': 'steals',
                     'person_talks_on_phone': 'talks on phone',
                     'person_talks_to_person': 'talks to',
                     'person_texts_on_phone': 'texts',
                     'person_transfers_object_to_car': 'transfers',
                     'person_transfers_object_to_motorcycle': 'transfers',
                     'person_transfers_object_to_person': 'transfers',
                     'person_unloads_car': 'unloads',
                     'person_unloads_motorcycle': 'unloads',
                     'person_walks': 'walks',
                     'person':'person',
                     'vehicle':'vehicle',
                     'car_moves':'moves'}


pip_plus_meva_to_meva = {k:v for (k,v) in list(pip_to_meva.items()) + [(k,k) for k in set(list(pip_to_meva.values()))]}




cap_to_index = {'car_drops_off_person': 0, 'car_moves': 1, 'car_picks_up_person': 2, 'car_reverses': 3, 'car_starts': 4, 'car_stops': 5, 'car_turns_left': 6, 'car_turns_right': 7, 'hand_interacts_with_person': 8, 'person_abandons_package': 9, 'person_adjusts_thermostat': 10, 'person_applies_deodorant': 11, 'person_applies_eye_makeup': 12, 'person_applies_facial_moisturizer': 13, 'person_applies_foundation_makeup': 14, 'person_applies_lip_makeup': 15, 'person_applies_shaving_cream': 16, 'person_applies_sunscreen': 17, 'person_arranges_flowers_in_vase': 18, 'person_attaches_leash_to_dog': 19, 'person_blows_into_hands': 20, 'person_blows_nose': 21, 'person_bounces_ball_on_floor': 22, 'person_bows': 23, 'person_braids_hair_of_person': 24, 'person_brushes_hair': 25, 'person_brushes_hair_of_person': 26, 'person_brushes_teeth': 27, 'person_bumps_into_person': 28, 'person_bumps_into_table': 29, 'person_bumps_into_wall': 30, 'person_burns_hand': 31, 'person_buttons_shirt': 32, 'person_carries_bicycle': 33, 'person_carries_furniture': 34, 'person_carries_groceries': 35, 'person_carries_heavy_object': 36, 'person_carries_laundry_basket': 37, 'person_carries_person_on_back': 38, 'person_carries_person_on_shoulders': 39, 'person_carries_person_over_shoulder': 40, 'person_catches_dropped_object': 41, 'person_catches_object_from_person': 42, 'person_claps_hands': 43, 'person_cleans_dryer_lint_trap': 44, 'person_cleans_eyeglasses': 45, 'person_cleans_table_with_rag': 46, 'person_climbs_down_ladder': 47, 'person_climbs_down_stairs': 48, 'person_climbs_off_chair': 49, 'person_climbs_off_couch': 50, 'person_climbs_off_table': 51, 'person_climbs_on_chair': 52, 'person_climbs_on_couch': 53, 'person_climbs_on_table': 54, 'person_climbs_up_ladder': 55, 'person_climbs_up_stairs': 56, 'person_clips_fingernails': 57, 'person_closes_box': 58, 'person_closes_cabinet': 59, 'person_closes_car_door': 60, 'person_closes_car_hood': 61, 'person_closes_car_trunk': 62, 'person_closes_closet_door': 63, 'person_closes_clothes_washer': 64, 'person_closes_curtains': 65, 'person_closes_dishwasher': 66, 'person_closes_door_with_foot': 67, 'person_closes_door_with_hip': 68, 'person_closes_dresser_drawer': 69, 'person_closes_facility_door': 70, 'person_closes_gate': 71, 'person_closes_home_window': 72, 'person_closes_jar': 73, 'person_closes_jewelry_box': 74, 'person_closes_kitchen_drawer': 75, 'person_closes_laptop': 76, 'person_closes_mailbox': 77, 'person_closes_microwave': 78, 'person_closes_oven_door': 79, 'person_closes_refrigerator': 80, 'person_closes_sliding_door': 81, 'person_closes_suitcase': 82, 'person_covers_face_with_hands': 83, 'person_covers_friend_with_blanket': 84, 'person_covers_with_bedsheets': 85, 'person_covers_with_blanket': 86, 'person_cracks_knuckles': 87, 'person_crates_dog': 88, 'person_crawls': 89, 'person_crawls_out_from_under_vehicle': 90, 'person_crosses_arms': 91, 'person_crosses_legs': 92, 'person_crumples_paper': 93, 'person_dances_in_place': 94, 'person_discards_trash': 95, 'person_dries_dish': 96, 'person_dries_face_with_towel': 97, 'person_dries_hair_with_hairdryer': 98, 'person_dries_hair_with_towel': 99, 'person_dries_hands_with_towel': 100, 'person_drinks_from_beverage_can': 101, 'person_drinks_from_bottle': 102, 'person_drinks_from_cup': 103, 'person_drinks_from_mug': 104, 'person_drinks_from_shotglass': 105, 'person_drinks_from_straw': 106, 'person_drops_object': 107, 'person_drums_on_chest': 108, 'person_dusts_furniture': 109, 'person_eats_apple': 110, 'person_eats_banana': 111, 'person_eats_snack_from_bag': 112, 'person_eats_with_hands': 113, 'person_eats_with_utensil': 114, 'person_embraces_person': 115, 'person_embraces_sitting_person': 116, 'person_enters_car': 117, 'person_enters_scene_through_structure': 118, 'person_exercises_with_jumping_jacks': 119, 'person_exercises_with_lunges': 120, 'person_exercises_with_plank': 121, 'person_exercises_with_pushup': 122, 'person_exercises_with_situp': 123, 'person_exits_car': 124, 'person_exits_pool': 125, 'person_exits_scene_through_structure': 126, 'person_extinguishes_candle': 127, 'person_falls_from_bed': 128, 'person_falls_from_chair': 129, 'person_falls_into_pool': 130, 'person_falls_while_standing': 131, 'person_feeds_cat': 132, 'person_feeds_dog': 133, 'person_files_fingernails': 134, 'person_flips_down_car_wipers': 135, 'person_flips_up_car_wipers': 136, 'person_flosses': 137, 'person_folds_blanket': 138, 'person_folds_pants': 139, 'person_folds_shirt': 140, 'person_folds_socks': 141, 'person_folds_tablecloth': 142, 'person_folds_towel': 143, 'person_gestures_arms_x': 144, 'person_gestures_be_quiet': 145, 'person_gestures_behind_me': 146, 'person_gestures_blow_kiss': 147, 'person_gestures_call_me': 148, 'person_gestures_come_here': 149, 'person_gestures_cut': 150, 'person_gestures_hang_loose': 151, 'person_gestures_heart': 152, 'person_gestures_listen_closely': 153, 'person_gestures_lower_hand': 154, 'person_gestures_number_five': 155, 'person_gestures_number_four': 156, 'person_gestures_number_one': 157, 'person_gestures_number_three': 158, 'person_gestures_peace': 159, 'person_gestures_raise_hand': 160, 'person_gestures_stop': 161, 'person_gestures_swipe_down': 162, 'person_gestures_swipe_left': 163, 'person_gestures_swipe_right': 164, 'person_gestures_swipe_up': 165, 'person_gestures_thumbs_down': 166, 'person_gestures_thumbs_up': 167, 'person_gestures_watch_closely': 168, 'person_gestures_zoom_in': 169, 'person_gestures_zoom_out': 170, 'person_grabs_person_by_bicep': 171, 'person_grabs_person_by_forearm': 172, 'person_grabs_person_by_hair': 173, 'person_grabs_person_by_shoulder': 174, 'person_handstand': 175, 'person_hikes_up_pants': 176, 'person_hits_person_with_pillow': 177, 'person_holds_hand': 178, 'person_holds_object_above_head': 179, 'person_hugs_cat': 180, 'person_hugs_dog': 181, 'person_hugs_person_from_behind': 182, 'person_hugs_stuffed_animal': 183, 'person_inserts_trashbag_into_trashcan': 184, 'person_interacts_with_handheld_game': 185, 'person_interacts_with_laptop': 186, 'person_interacts_with_tablet': 187, 'person_irons_clothes': 188, 'person_jumps': 189, 'person_jumps_into_pool': 190, 'person_jumps_on_bed': 191, 'person_jumps_on_couch': 192, 'person_karate_chop': 193, 'person_karate_kicks': 194, 'person_kicks_car_tires': 195, 'person_kicks_object_to_person': 196, 'person_kisses_cheek_of_person': 197, 'person_kneels': 198, 'person_knocks_over_furniture': 199, 'person_knocks_over_glass': 200, 'person_laughs_with_person': 201, 'person_leaves_scene_through_structure': 126, 'person_licks_fingers': 203, 'person_lies_down_on_bed': 204, 'person_lies_down_on_couch': 205, 'person_lies_down_on_floor': 206, 'person_lifts_dummbells': 207, 'person_lights_candle': 208, 'person_loads_car': 209, 'person_loads_clothes_into_suitcase': 210, 'person_loads_clotheswasher': 211, 'person_loads_dishwasher': 212, 'person_loads_dryer': 213, 'person_loads_groceries_into_cabinet': 214, 'person_loads_groceries_into_refrigerator': 215, 'person_locks_door_with_keys': 216, 'person_looks_at_hands_in_lap': 217, 'person_looks_at_wristwatch': 218, 'person_looks_over_shoulder': 219, 'person_makes_bed': 220, 'person_mops': 221, 'person_nods_head': 222, 'person_nudges_person_with_elbow': 223, 'person_opens_beverage_can': 224, 'person_opens_box': 225, 'person_opens_cabinet': 226, 'person_opens_can_with_can_opener': 227, 'person_opens_car_door': 228, 'person_opens_car_hood': 229, 'person_opens_car_trunk': 230, 'person_opens_closet_door': 231, 'person_opens_clothes_washer': 232, 'person_opens_curtains': 233, 'person_opens_dishwasher': 234, 'person_opens_dresser_drawer': 235, 'person_opens_facility_door': 236, 'person_opens_gate': 237, 'person_opens_home_window': 238, 'person_opens_jar': 239, 'person_opens_jewelry_box': 240, 'person_opens_kitchen_drawer': 241, 'person_opens_laptop': 242, 'person_opens_mailbox': 243, 'person_opens_microwave': 244, 'person_opens_oven_door': 245, 'person_opens_refrigerator': 246, 'person_opens_sliding_door': 247, 'person_opens_suitcase': 248, 'person_paints_fingernails': 249, 'person_pats_head': 250, 'person_pets_cat': 251, 'person_pets_dog': 252, 'person_picks_up_object': 253, 'person_picks_up_object_from_bed': 254, 'person_picks_up_object_from_cabinet': 255, 'person_picks_up_object_from_couch': 256, 'person_picks_up_object_from_countertop': 257, 'person_picks_up_object_from_floor': 258, 'person_picks_up_object_from_shelf': 259, 'person_picks_up_object_from_table': 260, 'person_picks_up_person': 261, 'person_plugs_into_electrical_socket': 262, 'person_points_at_person': 263, 'person_points_to_dog': 264, 'person_polishes_car_with_rag': 265, 'person_pounds_shoulders_of_person': 266, 'person_pours_coffee_into_mug': 267, 'person_pours_into_bowl': 268, 'person_pours_liquid_into_cup': 269, 'person_prays': 270, 'person_pulls_out_chair': 271, 'person_pulls_wheeled_cart': 272, 'person_pulls_wheeled_trashcan': 273, 'person_punches': 274, 'person_purchases_from_cashier': 275, 'person_purchases_from_machine': 276, 'person_pushes_in_chair': 277, 'person_pushes_wheeled_cart': 278, 'person_pushes_wheeled_trashcan': 279, 'person_puts_clothes_into_closet': 280, 'person_puts_clothes_into_dresser': 281, 'person_puts_down_object': 282, 'person_puts_down_object_into_cabinet': 283, 'person_puts_down_object_on_bed': 284, 'person_puts_down_object_on_couch': 285, 'person_puts_down_object_on_countertop': 286, 'person_puts_down_object_on_floor': 287, 'person_puts_down_object_on_shelf': 288, 'person_puts_down_object_on_table': 289, 'person_puts_down_person': 290, 'person_puts_feet_up': 291, 'person_puts_fingers_in_ear': 292, 'person_puts_hair_in_ponytail': 293, 'person_puts_hands_in_back_pockets': 294, 'person_puts_object_in_cabinet': 295, 'person_puts_object_into_backpack': 296, 'person_puts_object_into_bag': 297, 'person_puts_object_into_basket': 298, 'person_puts_object_into_box': 299, 'person_puts_object_into_kitchen_drawer': 300, 'person_puts_object_into_microwave': 301, 'person_puts_object_into_oven': 302, 'person_puts_object_into_purse': 303, 'person_puts_object_into_refrigerator': 304, 'person_puts_object_into_toaster': 305, 'person_puts_on_apron': 306, 'person_puts_on_backpack': 307, 'person_puts_on_belt': 308, 'person_puts_on_boots': 309, 'person_puts_on_earrings': 310, 'person_puts_on_facemask': 311, 'person_puts_on_glasses': 312, 'person_puts_on_gloves': 313, 'person_puts_on_hat': 314, 'person_puts_on_headphones': 315, 'person_puts_on_hoodie': 316, 'person_puts_on_jacket': 317, 'person_puts_on_necklace': 318, 'person_puts_on_necktie': 319, 'person_puts_on_pants': 320, 'person_puts_on_ring': 321, 'person_puts_on_scarf': 322, 'person_puts_on_shirt': 323, 'person_puts_on_shoes': 324, 'person_puts_on_socks': 325, 'person_puts_on_sunglasses': 326, 'person_puts_on_wristwatch': 327, 'person_puts_phone_into_pocket': 328, 'person_puts_up_picture_frame': 329, 'person_puts_up_smoke_detector': 330, 'person_reads_book': 331, 'person_reads_document': 332, 'person_reads_magazine': 333, 'person_reads_newspaper': 334, 'person_removes_trashbag_from_trashcan': 335, 'person_rides_bicycle': 336, 'person_rubs_eyes': 337, 'person_rubs_foot': 338, 'person_rubs_neck': 339, 'person_salutes': 340, 'person_scratches_face': 341, 'person_screws_lid_to_bottle': 342, 'person_searches_in_backback': 343, 'person_searches_in_bag': 344, 'person_searches_in_box': 345, 'person_searches_in_cabinet': 346, 'person_searches_in_couch': 347, 'person_searches_in_kitchen_drawer': 348, 'person_searches_in_purse': 349, 'person_searches_jewelry_box': 350, 'person_searches_under_bed': 351, 'person_searches_under_couch': 352, 'person_sets_table': 353, 'person_sets_upright_furniture': 354, 'person_sets_upright_glass': 355, 'person_shades_eyes': 356, 'person_shakes_hand': 357, 'person_shakes_head': 358, 'person_shaves_face': 359, 'person_shoves_person': 360, 'person_shrugs': 361, 'person_sits_crisscross': 362, 'person_sits_down': 363, 'person_slaps_hands_on_thighs': 364, 'person_snaps_fingers': 365, 'person_sneezees into arm': 366, 'person_sneezes_into_hand': 367, 'person_somersaults': 368, 'person_spills_on_floor': 369, 'person_spills_on_table': 370, 'person_spins_person_around': 371, 'person_sprays_from_bottle': 372, 'person_spreads_tablecloth': 373, 'person_squats': 374, 'person_squeezes_object': 375, 'person_stands_up': 376, 'person_stands_up_from_floor': 377, 'person_steals_object': 378, 'person_sticks_out_tongue': 379, 'person_stirs_mug': 380, 'person_stretches_arms_over_head': 381, 'person_stretches_arms_to_side': 382, 'person_stretches_back': 383, 'person_strokes_chin': 384, 'person_strokes_hair': 385, 'person_stubs_toe': 386, 'person_swats_bug': 387, 'person_sweeps_floor': 388, 'person_takes_clothes_from_closet': 389, 'person_takes_clothes_from_dresser': 390, 'person_takes_down_picture_frame': 391, 'person_takes_down_smoke_detector': 392, 'person_takes_medicine_pills': 393, 'person_takes_object_from_backpack': 394, 'person_takes_object_from_bag': 395, 'person_takes_object_from_basket': 396, 'person_takes_object_from_box': 397, 'person_takes_object_from_cabinet': 398, 'person_takes_object_from_kitchen_drawer': 399, 'person_takes_object_from_microwave': 400, 'person_takes_object_from_oven': 401, 'person_takes_object_from_purse': 402, 'person_takes_object_from_refrigerator': 403, 'person_takes_object_from_toaster': 404, 'person_takes_off_apron': 405, 'person_takes_off_backpack': 406, 'person_takes_off_belt': 407, 'person_takes_off_boots': 408, 'person_takes_off_earrings': 409, 'person_takes_off_facemask': 410, 'person_takes_off_glasses': 411, 'person_takes_off_gloves': 412, 'person_takes_off_hairtie': 413, 'person_takes_off_hat': 414, 'person_takes_off_headphones': 415, 'person_takes_off_hoodie': 416, 'person_takes_off_jacket': 417, 'person_takes_off_necklace': 418, 'person_takes_off_necktie': 419, 'person_takes_off_pants': 420, 'person_takes_off_ring': 421, 'person_takes_off_scarf': 422, 'person_takes_off_shirt': 423, 'person_takes_off_shoes': 424, 'person_takes_off_socks': 425, 'person_takes_off_sunglasses': 426, 'person_takes_off_wristwatch': 427, 'person_takes_phone_from_pocket': 428, 'person_takes_selfie': 429, 'person_takes_selfie_with_person': 430, 'person_talks_on_phone': 431, 'person_talks_to_person': 432, 'person_taps_object_with_finger': 433, 'person_tears_paper': 434, 'person_texts_on_phone': 435, 'person_texts_on_phone_while_sitting': 436, 'person_throws_object_into_air': 437, 'person_throws_object_on_bed': 438, 'person_throws_object_on_table': 439, 'person_throws_object_to_dog': 440, 'person_throws_object_to_ground': 441, 'person_throws_object_to_person': 442, 'person_tickles_person': 443, 'person_ties_jacket_around_waist': 444, 'person_touches_back_of_person': 445, 'person_touches_earlobe': 446, 'person_touches_face_of_person': 447, 'person_transfers_object_to_car': 448, 'person_transfers_object_to_person': 449, 'person_trips_on_object_on_floor': 450, 'person_trips_on_stair': 451, 'person_tucks_in_shirt': 452, 'person_turns_off_fan': 453, 'person_turns_off_faucet': 454, 'person_turns_off_lamp': 455, 'person_turns_off_stovetop': 456, 'person_turns_on_fan': 457, 'person_turns_on_faucet': 458, 'person_turns_on_lamp': 459, 'person_turns_on_stovetop': 460, 'person_twirls': 461, 'person_unattaches_leash_from_dog': 462, 'person_unbuttons_shirt': 463, 'person_uncovers_friend_with_blanket': 464, 'person_uncovers_with_bedsheets': 465, 'person_uncovers_with_blanket': 466, 'person_uncrates_dog': 467, 'person_unfolds_blanket': 468, 'person_unloads_box_onto_floor': 469, 'person_unloads_box_onto_table': 470, 'person_unloads_car': 471, 'person_unloads_clothes_from_suitcase': 472, 'person_unloads_clotheswasher': 473, 'person_unloads_dishwasher': 474, 'person_unloads_dryer': 475, 'person_unlocks_door_with_keys': 476, 'person_unplugs_from_electrical_socket': 477, 'person_unscrews_lid_from_bottle': 478, 'person_unties_jacket_around_waist': 479, 'person_untucks_shirt': 480, 'person_unzips_jacket': 481, 'person_uses_bodyweight_scale': 482, 'person_uses_television_remote': 483, 'person_vacuums_carpet': 484, 'person_vapes': 485, 'person_walks': 486, 'person_walks_around_car': 487, 'person_walks_tiptoe': 488, 'person_washes_dish': 489, 'person_washes_face': 490, 'person_washes_hands': 491, 'person_washes_window': 492, 'person_waters_houseplant': 493, 'person_waves_at_person': 494, 'person_waves_hand_over_object': 495, 'person_wiggles_hips': 496, 'person_wipes_mouth_with_napkin': 497, 'person_wraps_box': 498, 'person_yawns': 499, 'person_zips_up_jacket': 500}


cap_pip_meva_to_meva = {k:v for (k,v) in (list(pip_plus_meva_to_meva.items()) +
                                          list([(k,None if k not in pip_plus_meva_to_meva else pip_plus_meva_to_meva[k]) for k in cap_to_index.keys()]) +
                                          list([('person_abandons_backpack', 'person_abandons_package'),
                                                ('person_abandons_luggage', 'person_abandons_package'),
                                                ('person_abandons_box', 'person_abandons_package'),
                                                ('person_abandons_stroller', 'person_abandons_package'),
                                                ('person_carries_bicycle', 'person_carries_heavy_object'),
                                                ('person_carries_groceries', 'person_carries_heavy_object'),
                                                ('person_carries_furniture', 'person_carries_heavy_object'),
                                                ('person_carries_laundry_basket', 'person_carries_heavy_object'),
                                                ('person_closes_sliding_door', 'person_closes_facility_door'),
                                                ('person_hugs_person_from_side', 'person_embraces_person'),
                                                ('person_embraces_sitting_person', 'person_embraces_person'),
                                                ('person_picks_up_object_from_floor', 'person_picks_up_object'),
                                                ('person_picks_up_object_from_shelf', 'person_picks_up_object'),
                                                ('person_picks_up_object_from_table', 'person_picks_up_object'),
                                                ('person_picks_up_object_from_countertop','person_picks_up_object'),
                                                ('person_picks_up_object_from_cabinet','person_picks_up_object'),
                                                ('person_picks_up_object_from_couch', 'person_picks_up_object'),
                                                ('person_picks_up_object_from_bed', 'person_picks_up_object'),
                                                ('person_puts_down_object_on_floor', 'person_puts_down_object'),
                                                ('person_puts_down_object_on_shelf', 'person_puts_down_object'),
                                                ('person_puts_down_object_on_table', 'person_puts_down_object'),
                                                ('person_puts_down_object_on_countertop', 'person_puts_down_object'),
                                                ('person_puts_down_object_into_cabinet', 'person_puts_down_object'),
                                                ('person_puts_down_object_on_couch', 'person_puts_down_object'),
                                                ('person_puts_down_object_on_bed', 'person_puts_down_object'),
                                                ('person_reads_newspaper', 'person_reads_document'),
                                                ('person_reads_magazine', 'person_reads_document'),
                                                ('person_reads_book', 'person_reads_document'),
                                                ('person_texts_on_phone_while_sitting', 'person_texts_on_phone'),
                                                ('person_texts_on_phone_while_walking', 'person_texts_on_phone'),
                                                ('person_texts_on_phone_while_standing', 'person_texts_on_phone'),
                                                ('person_opens_laptop', 'person_interacts_with_laptop'),
                                                ('person_closes_laptop', 'person_interacts_with_laptop')]))}
                                                

                                                
                                                
