# CrawlersTools
![](https://img.shields.io/badge/python-3.7.3-brightgreen)

CrawlersTools is a comprehensive tools for crawlers base on Python3.

---

Install CrawlersTools using pip:

```shell
pip install CrawlersTools
```

CrawlersTools requires Python 3.7+.


## Modules Introduction


### Extraction of Policy HTML
With this module,you can extract policy html automatically.
#### Extraction of List HTML
Usage example:
```shell
from CrawlersTools import ListExtractor

list_extract = ListExtractor()
extract_result = list_extract.extract(html)
print(extract_result)
```
Outputs:
```shell
[{
    'title': '关于对迎泽区2023年乡村振兴项目储备库的公示',
    'url': '/p222/ncjbmxxgk/20221111/30003142.html'
}, {
    'title': '迎泽区2022年第四批实际种粮农民一次性补贴发放明细公示',
    'url': '/p222/ncjbmxxgk/20221027/1249082.html'
}, {
    'title': '迎泽区2022年第三批实际种粮农民一次性补贴发放明细公示',
    'url': '/p222/ncjbmxxgk/20221027/1249081.html'
}, {
    'title': '迎泽区2022年第二批实际种粮农民一次性补贴发放明细公示',
    'url': '/p222/ncjbmxxgk/20221027/1249078.html'
}, {
    'title': '迎泽区2022年第一批实际种粮农民一次性补贴发放明细公示',
    'url': '/p222/ncjbmxxgk/20221027/1249077.html'
}, ***]
```

#### Extraction of Detail HTML
Usage example:
```shell
from CrawlersTools import PolicyExtractor

detail_extract = PolicyExtractor()
detail_result = detail_extract.extract(html)
print(detail_result)
```
Outputs:
```shell
{
  'title': '玉溪市2018年工业经济运行工作指导意见', 
  'publish_time': '2018-03-15', 
  'content': '2017年，在作为全市工业主要支柱产业的烟草制品业增加值增速持续负增长，虽然全市非烟产业平稳高速增长，但占比小、支撑作用不明显，全市工业稳增长面临严峻困难和挑战的形势下，市委、市政府早谋划、早部署，及时出台稳增长促转型系列政策措施，工业经济运行缓中趋稳，稳中有升，结构调整和转型升级取得积极进展。全年全部工业完成增加值\n662.5\n亿元，增长\n7.1%\n，拉动\nGDP\n增长\n3.6\n个百分点，对经济增长的贡献率为\n38.1%\n，其中：规模以上工业完成增加值\n623.7\n亿元，增长\n7.2%\n。\n2018\n年是贯彻党的十九大精神的开局之年，是改革开放\n40\n周年，也是决胜全面建成小康社会、实施\n“\n十三五\n”\n规划承上启下的关键一年。当前，我国经济正处在转变发展方式、优化经济结构、转换增长动力的攻关期。十九大报告作出这样的判断：我国经济已由高速增长阶段转向高质量发展阶段。\n“\n十三五\n”\n行至一半，\n2018\n年成为承上启下的关键一年，全市工业经济运行调节要全面贯彻党的十九大精神，以习近平新时代中国特色社会主义思想为指导，牢固树立\n“\n四个意识\n”\n和\n“\n四个自信\n”\n，坚持稳中求进工作总基调，坚持新发展理念，紧扣我国社会主要矛盾变化，着眼建设现代化经济体系，立足制造强国、网络强国建设全局，以供给侧结构性改革为主线，以提高制造业供给体系质量为主攻方向，深入实施\n“\n中国制造\n2025”\n，强化创新驱动、改革推动、融合带动，推动质量变革、效率变革、动力变革，加快培育壮大新动能、改造提升传统动能，实现工业及信息化业持续健康发展。\n一、2018年工业经济运行形势研判\n（一）有利条件\n当前，玉溪工业发展正处于工业化中期的前半阶段，资本、技术等要素边际贡献率较高，工业发展空间仍然较大，支撑工业平稳较快增长的有利条件和因素不断增多。\n一是宏观经济运行企稳。\n全球经济\n“\n低增长、低通胀、低利率\n”\n态势将会有所回暖，传统产业负增长的情况会有所改变。同时，随着滇中城市经济圈和\n“\n五大基础设施网络\n”\n等一系列项目实施，国家、省、市出台的稳增长、供给侧结构性改革等系列政策效应逐步释放，经济增长的内生动力不断增强，国内经济稳中向好，全市经济稳中有进，为工业稳增长调结构提供了良好的宏观环境。\n二是面临良好发展机遇和政策环境。\n玉溪地处滇中区域，位于泛亚铁路中线和东线的交汇点，是昆曼高速的重要节点，有助于在更高、更广的平台上深化对内和对外两个开放，辐射带动滇中城市经济圈发展，开创面向南亚、东南亚开放合作的新局面。且玉溪处于多个重大国家战略的交汇点，\n“\n一带一路\n”“\n长江经济带\n”\n创造新战略空间，有望加快面向南亚东南亚辐射中心建设和沿边地区开发开放，同时在基建、能源、金融、贸易合作等方面将获得更为广阔的发展空间。市委市政府高位推进\n“\n五网\n”\n建设，加快培育七大重点产业，实施工业经济攻坚战，将助力补齐工业经济发展短板，打造工业增长新引擎。\n三是工业企业生产经营环境有所改善。\n全市大宗工业品价格稳步回升，工业通缩局面得到缓解。工业企业经营环境逐步改善，将在一定程度上改善企业市场预期，增强库存回补动力和投资意愿。创新驱动发展战略深入实施，大众创业、万众创新成为经济提质增效的新引擎。\n“\n互联网\n+”\n加快跨界融合，将极大提升实体经济的创新力和生产力，企业生产经营环境不断得到创新及改善。\n（二）不利条件\n在内外需求偏弱，周期性和结构性矛盾叠加的背景下，\n2018\n年玉溪工业经济平稳健康运行仍然面临诸多制约因素，主要表现为：\n一是结构性矛盾制约。\n全市工业结构中，\n2017\n年烟草制品业占比达\n62.68%\n，从\n2017\n年运行趋势看，烟草行业仍将面临三个不变，即国家控烟的力度不会改变、对烟草行业的政策调控不会改变、烟草行业运行环境难有较大改变，烟草行业保增长的压力仍较为突出。传统行业中，钢铁行业虽呈现恢复性增长，但受工业增加值率和价格指数影响，对全市工业增长拉动较小。新兴产业中，装备制造、生物医药和电子信息制造产业虽然增速较快，但在全市规上工业增加值中的占比仅分别为\n4.2%\n、\n1.5%\n、\n0.5%\n，占比小，拉动增长较弱，全市工业经济结构性矛盾依然突出。\n二是要素成本制约。\n近年来，资金、用工、土地等要素刚性成本和环保、物流等隐性成本不断上升，给企业生产经营造成较大压力。企业成本上升明显，工业企业融资难、融资贵矛盾仍未有效缓解，金融资本一定程度上\n“\n脱实向虚\n”\n。企业难贷款和银行贷款难\n“\n两难矛盾\n”\n以及慎贷、限贷、抽贷现象仍然不同程度存在。\n三是新增增量制约。\n由于工业企业生产经营困难、效益下滑影响，导致对未来市场的预期和信心不足。民营企业由于缺乏担保，实际资金支付率和到付率偏低，加之投资回报率下降、用地成本高、落地困难等多种因素影响，民间投资意愿下降，新增投资大幅下滑。\n四是新投产项目匮乏。\n全市新建成投产且能纳入规上统计的项目较少，尤其是缺乏大项目形成新的增量。招商优质项目不多，带动性不强，投资额度大的项目不多，跨越发展缺少大项目支撑，工业经济缺乏增量支撑。\n综上所述，\n2018\n年全市工业经济处于新旧动能转换，并将加速向纵深推进期，工业经济将在合理区间稳定运行，工业发展质量将稳步提升。但仍需要密切关注影响工业经济平衡充分发展的一些突出问题：供给体系质量与消费升级需求不匹配、新技术对传统产业的渗透融合不深入、工业领域民间投资意愿不强烈等，经济继续下行的压力和风险较大，延续低速低效运行趋势的可能性较大，完成全年工业经济发展目标任务十分艰巨，全市工信系统的广大干部职工务必高度重视，振奋精神，迎难而上，恪尽职守，竭尽全力，全面完成市委市政府下达各县区的工业经济发展目标。\n二、2018年工业经济运行总体思路和主要指标\n（一）总体思路\n全面贯彻落实十九大、中央经济工作会议、省委十届四次全会、市委五届五次全会，以及\n2018\n年全省工业和信息化工作会议精神，牢固树立\n“\n创新、协调、绿色、开放、共享\n”\n的发展新理念，坚持稳中求进工作总基调，适应新常态，谋划新思路，把稳增长作为首要任务，坚持全局视野、问题导向、创新意识、聚焦目标任务的运行调节原则，强化重点监测、准确定位、分类指导、精准施策，实现将短期需求管理与中长期供给管理相结合、从侧重需求侧向供需两侧并重逐步转变，实施重点行业挖潜、重大项目驱动、产融合作推进、达规企业培育\n“\n四大工程\n”\n，增强工业持续增长动力，促进工业经济平稳增长。\n（二）主要目标\n2018\n年非烟规上工业增加值增长\n21%\n。\n三、主要措施\n（一）压实各县区、工业园区主体责任。\n督促各县区、工业园区要扛起责任使命，压紧压实工业经济发展主体责任，扎实推进工业经济发展工作，着力营造良好的发展环境。实现责任全厘清，层层建立主体责任清单，主要领导带头，以上率下，重视工业、研究工业、推动工业发展。\n（二）提前谋划，实现高开稳走。\n提前谋划部署，科学有序部署，减少工业经济大幅波动，促进全年工业经济平稳发展。抓好节后企业复产复工，确保实现一季度工业经济\n“\n开门红\n”\n。及早部署和安排\n2018\n年工业投资重点项目，促进项目早启动、早投产、早落地，支撑全市工业经济平稳发展。\n（三）抓好成本费用调查工作。\n市工信委和市统计局联合组织对全市\n94\n户成本费用调查工业企业开展业务培训。各级工信、统计部门要深入填报企业开展业务指导，进一步提高全市规模以上工业企业成本费用调查数据质量，客观真实反映工业各行业增加值率情况。\n（四）抓好在库企业生产经营监测工作。\n一是\n组建\n10\n个帮扶督导组，对\n9\n个县区和高新区全覆盖，每月一调研一督导，继续抓好扩销促产、电力市场化交易等措施落实，强化稳增长政策落到实处，激励在库工业企业做好生产经营工作。\n二是\n加强分析预测，认真研究提出工业经济平稳发展的支撑点，以更加有力的措施确保工业经济增长态势。\n三是\n抓好重点企业稳增长工作。对全市工业经济贡献较大，占比较高的重点企业，实行面对面帮、点对点扶，保障重点企业生产经营中的各种生产要素，确保企业满负荷生产，支撑全市工业经济稳定增长。\n（五）抓好负增长企业扭负为正工作。\n以企业帮扶为手段，进一步优化发展环境。创新帮扶工作机制，切实帮助企业解决具体问题，重点排查帮扶企业存在的突出矛盾和问题，采取\n“\n一企一策\n”\n的办法，分类指导，重点帮扶，加大惠企政策落实力度，努力实现负增长企业达产增效。\n（六）创新工业企业纳规培育工作机制。\n依托全市工业企业纳规工作联席会议制度，比对筛选全市符合纳规条件工业企业，做好政策宣传，企业帮扶工作，推动全市工业企业纳规工作。'
}
```


### Font Decryption
Font encryption is one of the common scenarios for crawlers.With this module,you can only
provide font file and encrypted strings to get decrypted strings.

FreeTypeFont isn`t compatible with bytes, so you must change the source code in advance.
```shell
def load_from_bytes(f):
    if isinstance(f, bytes):    # 直接传入bytes
        self.font_bytes = f
    else:
        self.font_bytes = f.read()
    self.font = core.getfont(
        "", size, index, encoding, self.font_bytes, layout_engine
    )

if isinstance(font, bytes): # 直接传入bytes
    load_from_bytes(font)
elif isPath(font):
    ***
```

Usage example:
```shell
from CrawlersTools.js_crawler import FontDecrypt

str_base64_ = 'd09GRgABAAAAAE34AAoAAAAATbAAATMzAAAAAAAAAAAAAAAAAAAAAAAAAABPUy8yAAAA9AAAAGAAAABgZ5ijY2NtYXAAAAFUAAAGogAABqJE+hJPZ2x5ZgAAB/gAAEEUAABBFJTJlvxoZWFkAABJDAAAADYAAAA2ByuHNWhoZWEAAElEAAAAJAAAACQEJgKgaG10eAAASWgAAAD0AAAA9CckDMBsb2NhAABKXAAAAOAAAADgLkc+mG1heHAAAEs8AAAAIAAAACAAeQBhbmFtZQAAS1wAAAJ8AAACfKf0GLVwb3N0AABN2AAAACAAAAAg/58ArwAEA8cBkAAFAAQB9AH0AAAAAAH0AfQAAAH0AEAAyAgBAgsEAAAAAAAAAKAAAv8QAAAAAAAAFgAAAABBUFBMAEAAMZfnA1z/dAGQBCQBVAAEAAEAAAAAAlgDXAAAACAAAwAAAAQAAAADAAAAJAABAAAAAAB8AAMAAQAAACQAAwAKAAABggAEAFgAAAASABAAAwACADEAMgAzADQANQA2ADgAOf//AAAAMQAyADMANAA1ADYANwA5////1P/V/9H/z//N/8v/0f/NAAEAAAAAAAAAAAAAAAAAAAAAAAAAAAEGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAABQcEAwIBCAkGAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAAwAAAAABSAAAAAAAAAAbAAAADEAAAAxAAAABQAAADIAAAAyAAAABwAAADMAAAAzAAAABAAAADQAAAA0AAAAAwAAADUAAAA1AAAAAgAAADYAAAA2AAAAAQAAADcAAAA4AAAACAAAADkAAAA5AAAABgACLk8AAi5PAAAACgACLlcAAi5XAAAAEgACLm8AAi5vAAAALQACLnMAAi5zAAAALwACLnUAAi51AAAAMgACLn4AAi5+AAAANwACLoMAAi6DAAAAOwACLpEAAi6RAAAARAACLpQAAi6UAAAARwACLpgAAi6YAAAASAACLrIAAi6zAAAAUgACLrsAAi67AAAAVgACLtIAAi7SAAAAYwACLvUAAi71AAAAagACLwsAAi8LAAAAbgACTV0AAk1dAAAACwACTWIAAk1iAAAADAACTWkAAk1pAAAADQACTWsAAk1rAAAADgACTXwAAk18AAAADwACTYoAAk2KAAAAEAACTd0AAk3dAAAAEQACTmkAAk5pAAAAEwACTpwAAk6cAAAAFAACTqIAAk6iAAAAFQACTqsAAk6rAAAAFgACTzAAAk8wAAAAFwACTz0AAk89AAAAGAACUJgAAlCYAAAAGQACUMUAAlDFAAAAGgACUVUAAlFVAAAAGwACUXgAAlF4AAAAHAACUYUAAlGFAAAAHQACUfcAAlH3AAAAHgACUmUAAlJlAAAAHwACUp0AAlKdAAAAIAACUqYAAlKmAAAAIQACUqkAAlKpAAAAIgACUxkAAlMZAAAAIwACUyAAAlMgAAAAJAACU0YAAlNGAAAAJQACU1cAAlNXAAAAJgACU2AAAlNgAAAAJwACU6cAAlOnAAAAKAACU9sAAlPbAAAAKQACVkwAAlZMAAAAKgACVncAAlZ3AAAAKwACV0kAAldJAAAALAACWGkAAlhpAAAALgACWKUAAlilAAAAMAACWSMAAlkjAAAAMQACWrUAAlq1AAAAMwACWu0AAlrtAAAANAACWwUAAlsFAAAANQACW0sAAltLAAAANgACXVEAAl1RAAAAOAACXVcAAl1XAAAAOQACXcMAAl3DAAAAOgACXeMAAl3jAAAAPAACX3YAAl92AAAAPQACYV8AAmFfAAAAPgACYc8AAmHPAAAAPwACYlAAAmJQAAAAQAACYtcAAmLXAAAAQQACZIgAAmSIAAAAQgACZKgAAmSoAAAAQwACZOgAAmToAAAARQACZP8AAmT/AAAARgACZm4AAmZuAAAASQACZn4AAmZ+AAAASgACZokAAmaJAAAASwACZp8AAmafAAAATAACZ14AAmdeAAAATQACbCQAAmwkAAAATgACcIUAAnCFAAAATwACcbgAAnG4AAAAUAACc1UAAnNVAAAAUQACdIQAAnSEAAAAVAACddMAAnXTAAAAVQACdlAAAnZQAAAAVwACd2MAAndjAAAAWAACeRwAAnkcAAAAWQACeSAAAnkgAAAAWgACeVoAAnlaAAAAWwACecUAAnnFAAAAXAACepgAAnqYAAAAXQACfEoAAnxKAAAAXgACfh4AAn4eAAAAXwACfi4AAn4uAAAAYAACgAEAAoABAAAAYQACgEwAAoBMAAAAYgACgwYAAoMGAAAAZAACh7cAAoe3AAAAZQACivAAAorwAAAAZgACiwkAAosJAAAAZwACi00AAotNAAAAaAACkRwAApEcAAAAaQAClbEAApWxAAAAawACl8gAApfIAAAAbAACl+cAApfnAAAAbQAAAAAAAAAAAAAAAAAAAAEAbwAAAWkCygAKAAABESMRBgc1Njc2NwFpUkJmLzUxJQLK/TYCZkQeUg0fHioAAAEAPgAAAhoC2AAhAAAAFxYVFAcGBwYHIRUhNDc2NzY3NjU0JyYjIgcGByM0NzYzAZlAQEYpa4gUAXf+JEcubVUbNycnRksmKwFSQ0JtAtg5Ol1cTCtIW0lJY040Sz0cPERBJCQyMV53SEgAAAEAM//yAiYC2AAyAAAAFxYVFAcWFxYVFAcGIyInJiczFhcWMzI3NjU0JyYrATUzMjc2NTQnJiMiBwYHIzY3NjMBmz4+dUAgJERFb2RCTAlTAzUuQkwvKyopSzo3RyYmJSZHSScpCFEJQz5nAtg0NVl5JxQpKj9hPj80P3hULCUsKz5AJCNAICE8OyIjJiZJZzs6AAACABgAAAJBAsoACgAOAAABETMVIxUjNSE1AQcBIREBzXR0Tv6ZAWgE/uEBIgLK/htDoqJOAdpr/oYBegABADP/8gIlAsoAJwAAARUhBzM2NzYzMhcWFRQHBiMiJyYnMxYXFjMyNzY1NCcmIyIHBgcjEwII/qQYBB4vKDNmP0BNSWlfQkoIUQYwK0JLMTEuK08zKCsVTiYCyknvJBIRQENybEVBMzliRCQgMDFKVDAvFhUrAYoAAAAAAgAz//ICJgLYACAAMAAAABcjJiMiBwYdARQXMzY3NjMyFxYVFAcGIyInJjU0NzYzAgcGFRQXFjMyNzY1NCcmIwH8HlEYfFUvLwEEHDEvQGY/PkRGZ4FDPkNGekkvLiwtSkcuLSwsSgLYv3pTTHwKCAg5HR9CQ2dpRkZhWqWsanD+tzAvS0wvMzEzTEsuLwAAAQBCAAACFwLKAAYAABMhFQEjASFCAdX++VcBCv5/AspD/XkCfwAAAAMAKv/yAi4C2AAhADEAQQAAABcWFRQHBgcVFhcWFRQHBiMiJyY1NDc2NzUmJyY1NDc2MwYHBhUUFxYzMjc2NTQnJiMCBwYVFBcWMzI3NjU0JyYjAZ0+OhsfNjgnKkJGenxEQiooNzgdGzo+cU0qJSEoU1EqISUrTFcuLCwuV1YwKysvVwLYOjVOOScrEwIOMDNFXzk7OzlfRTMxDQITKyc5TzQ6QychNTchKCghNzQiJ/7DKyZCQSYpKig+QCgrAAIAM//yAiYC2AAgADAAAAAXFhUUBwYjIiczFjMyNzY9ASY1IwYHBiMiJyY1NDc2MwYHBhUUFxYzMjc2NTQnJiMBpUI/Q0l3xx1RF31SMi8BBBsyMj1nPz1EQ2pHLSwsLEpFMC4sLUoC2GBapqhucL96U1B4CgkHNiAfREBoa0RGRTEwT00sLzAxSUoxMwAAAAEAMgFLA7UBkwADAAATIRUhMgOD/H0Bk0gAAAACADr/pgN4AzUAFQAZAAABByEQBwYjIi8BFjMyNzYRIRMXByEVASEVIQE7EQIsLi2VP0cTdBaBGxv9yy5JDQI1/MICb/2RAmye/lxFPwNCBz0/ASoBqwZ9Rv56RgAAAAABADP/kQO1AzgAKwAAEyE2NyM1ITY3Fw8BBgchFSEGByEVIQYPAiEVBgcWFwcmJzcWFzY3ITY3ITMBHg0S+QEICRBKBgUHBQGv/kIOEAIX/dYJDAsLAdxKmFNaKN7yJmR0iVH+Eicd/vYCADFLQylQBh4dIhZDPj5GHyUhHz5ybR4rP25BOBsoWmRpXgAAAAADADn/xgOvAycACwARABcAAAEzETMRMxEhFSE1IQECByc2EwQTByYnNwFjSY5JASz8igEqAjE8W0FYQP2KPUI2UT0DJ/zlAxv85UZGAlP++sMXsgESzP79EfDeFAAAAAADADD/ngO2AzsAIQAnAC0AABMzNjcXBgchFSEGByE1MxUhFSERFCsBJxYzMjURISc2NyMBBgcnNjcEFwcmJzdO9xwbRxUbAf794khVAQ5JATv+xV9oDzcnL/6mEV1O1gEEY5Euj2ECN181TpIwArg9RhA1PkaNapSUQ/7CXEcFLAEsP2SX/kuIZzxhfnJ5NG6ELgAAAwBp/5UDgAM1AA8AEwAXAAABMxUhESM1IREjESEVIxEhASERIQEhESEBz0oBZ0j+4Ur+4kgBZv7iAR7+4gFoAR/+4QM1tP4qP/6rAVU/Adb+rwEL/vUBCwAAAAABADn/vgOwAzMAGgAAASE1ISYnNxYXByEVIRUhFSERIRUhNSERITUhAdD+jAF6GSVGJBYnAZz+jAFE/rwBl/yJAZf+vAFEAkBHTUwTU0oPR+xD/vRHRwEMQwAAAAEAOv+nA64DCgAWAAATIRUhESEVIREUKwEnFjMyNREhNSERIXkC7/65AY3+c2WcD2YsNf5iAZ7+oQMKRv7wSP6dYkUEMwFRSAEQAAABACP/ogPDAy8ADgAAARQHEgUHJAMCBSckEzY1AhgHVAFeL/7Nalr+siwBnA4CAy9xbf5o1z/JAVP+utdA/QGxiBcAAAMAIf+dA8QDMQAKAA4AJgAAARYXByYnBgUnJDcDIRUhByEVIQYHNjcmJzcWFwcmJwYFJzY3NjcjAg6/9yf2s6L+9SYBCbDaAev+FZ0DJP4pSGb71zw0OIpIPBsc6/6bFBoMYz77AzHVe0WB1MaQRYfK/s1EhUaNaQ4dTjokmm8qKigmFT8HDHJ3AAAABAAk/5oDvwM3AAoAFAAeACQAAAEGBxEjEQYHJzY3FyEmJzcWFyEVIQMhNhMXAgczFSESFwcmJzcBUCc6SDM5F6BJPgENFB1MGBUBBf2mEQFYTDlFNEzj/XvGL0MoQEIDGHZm/V4CNEQ8TbXnp0pIDUVaRf3HxgEyEv7x10cBc/oS4NkUAAAAAAIAJ/+bA8ADNQAKACoAABMGByc2NxcGBxEjEyE1MxUhFSMWFwcmAyMRMxUjFSM1IzUzESMCByc2EyOhLTgVnEVBKDlHlwEJRwER00ezL7hHCpubR5mZC0y5JatLygG3QUBIwPcegGz9cALrrKxG+r873wEV/m9Fzs5FAZH+yMY9rgETAAIAI/+bA7MDNwAWACEAAAEGByc2NxcGByEVIRUhFSEVIRUhFSMRBQYHJzY3FwYHESMB5ERbM4VUSBoWAbD+sAEk/twBKv7WSf6KMDkYo0lEKD1KAl2QbT2e/BBKOUelRqlF6QLCkD85TLHiIHNo/WIAAAAABgAg/5oDwAM6AAoAFQAZAB0AJQApAAATBgcnNjcXBgcRIxMhJic3FhcHIRUhFyEVIRUhFSEFESM1IRUjERchNSGaMDMXkkRDJDRHmwE0Fh5FHhMmATv9dVwB2f4nAdn+JwHrRv6ORkYBcv6OAcxGOU207B91ZP1YAxM8OBNAOQ5EUUFMQlL+pTY2AVvhngAABwAk/5UDuwM0ABcAHgApAC0ANwA9AEcAAAEGByEVBgcWFwcmJwYHJzY3JicGByc2NxYXNjcjDwEnBgcRIxEGByc2NxczESMBBgcGByc2NzY3FwYHJzY3ATY3NjcXBgcGBwKJDBQBHjFlWHIckWJpkRt4XEAkHCcpey0bT1kz+wUF+CUzRTA2FZVDQUFBAcQ4Oz9mI1ZDOTWPd+kd3XD+iqpra0szQ4aLjAMrJCc+Y0gnG0MkNjkkQRwrMTkbHTZXfuYzOUoGB4N0YP1bAjNFO0i06LH9ygEfLyAhITkWHh0ob5VCPTqF/pYtPz5jJmhOTSYAAAMAKv+fA7oDMAAlACsAMQAAATMRIRUhERQ7ATI3NjcXBgcGKwEiNREjFQYHBgcnNjc2NzUhNSEBBgcnNjcEFwcmJzcBz0oBkP7hKnkhDxIGRQofGzycXKkETUqrKaVBPQP+8AGPAY8zU0FRM/3+QkM/TUQDMP6NR/6xLRUbgBaeIh5iAV4Hu3JoO0A5XGKZB0cBI3t0IXZ4cX0he2sgAAAGADT/nwO1AzUAEwAXABsAHwAlACsAABMzNTMVITUzFTMVIxEzFSE1MxEjEyE1ITUhNSE1ITUhEwYHJzY3BBcHJic3RqlJAXhJqam8/H+7qfIBeP6IAXj+iAF4/ohnerUtsncBsogolJokAtlcXFxcRP42Q0MByv42cj5vPm39rVxHOkNUQFQ9YTc2AAMALP+cA7sDKQAJACQAKgAAAQYHBgcnNjc2NwM1IQYHBgcGByMnFjMyNzY3IQYHBgcnNjc2NyQXByYnNwGoRkdJfydpUEs7rwJfBBAPIyNNuhNaUFMbGQn+9SQ/SZUshkM9HwFg3DDlWj4C+YFPU1k/Pl1Vcf5CRbZ6dSssBEUDRkbtpmBpVDlLV1WT5oU5lesiAAADACT/nAOKAy4AHgAiAC0AABMzNQYHJzY3FwYHFTMVIxUWFwcmJxEjEQYHJzY3NSMlMxEjFycWMzI1ETMRFCM6x19PFvaiI1RaublgYCtVQElHdiCaQ8cCHEhIRA9gKixJXQIjiBEFQxRBPSEVl0UuU2VAbEL+NgHCkHlTiK0B9f2WxEYEMQMW/NhhAAMAI/+bA5YDLgAsADAAOwAAEwYHJzY3FwYHMzUzFTMVIxUzFSMVMxEUKwEnFzI9ASMRIxEjESMRMzUjNTM1JTMRIxcnFjMyNREzERQjnBskOksVRAgLdEi7u9jYw1o1EjErfkh/RsXy8gFbRkYkEFA6LkdcAm88JypRjgszJXx8Q4FDaf74WUQDJ7b+nAFk/tsBaGlDgWX9lsVFBTADGfzVXgAAAwAz/5gDowMuAAMAGwA3AAATIRUhByEVIwYHNjcmJzcWFwcmJwYHJzY3NhMjATMVMxAHBiMiLwEWMzI3NhMjFQIHJzYTNSM1M1oBav6WJwG35zsudXcpJD1JPj4NEZ68EQkHLUuLAkxJ2w4PeRpCEEwXQAsKA5QDzzm/A3x8AutFyUbiZBgsVj8egpYgIyY5IUQDAz4BEAGXtv4XeXADQARNUAGxEv5FzjK6AZ0SRQACACf/mgOvAzYACgAoAAABBgcRIxEGByc2NwEiNREGByc2NxEzETY3FwYHERQ7ATI3NjcXBgcGIwGcM1FIQFIX0mABEms6RyBeQ0iceDKLuzSgJxMQBkMLGRtIAxZ7a/1qAj5GREu06fx2agExISJELCcBkf6baIc5lXb+ri8ZF5YWrSQkAAAAAwA2/5sDrgMzAAsAKQA0AAA3ITUzFSEVIRUjNSElIj0BBgcnNjc1MxU2NxcGBxUUOwEyNzY3FwYHBiMlBgcnNjcXBgcRI0QBikoBjv5ySv52AiZaNl0oYFtFl2UxgqsqligQFgdEDCIeQP2sPUQXvFY9L0JG3WJiRvz8t1dOFyE8HyjlxUpcMm5SXyMPFmEWfhwY5DUtSnueHFlI/rUAAAIAN/+dA7EDNwAcADgAABMhNxcGByEVIQYHIREUKwEnFzI1ESERIxEhNjchBBczNjcXBgczFSMVMxUjFSM1IzUzNSM1MyYnNzcBngxJAwgBkv5kCQwBfFliE10q/YBHAUkOBv5sAW0baSIaQhofcsjm5kbl5cVuFx9AAtNkCiI4RDYv/dhfRgIrAdT9twKNRCH/Rz9DGDkxP2lAtbVAaT83LhgACAA4/50DsAM2AAMABwALAA8ALQBAAEwAUgAAARUzNTMVMz0CIxUjNSMdAiMRMzUhNSE1MxUzJic3FhczFSEVMxEjNSMVIzUFITUzFTMVIxUUKwEnFjMyPQEhATM1MxUzFSMRIxEjABcHJic3AcWfQ6CgQ59D4v7/AQFDeQ8ZPhYPUP7840OgQ/7lAaxGdXVRZw81KSP+VP7vaUdlZUdpAe48LTZdKwGzQUFBQTNCQkJCp10BfkI+UVEjKQotKT5C/oJdVFSLOTk+jExDBR97AcX09Eb9qAJY/j49LjxCKgACACz/lgOxAwUAGwAlAAABIzUhFQYHMxUGBxYXByYnBgcnNjcmJwIHJzYTADcjNjchFQcWFwEprAJUGx3KLJF1li+jcYHFKrt6jEMyzzf5BAHCLdkhIv7xATbCAr5HL3tmKs2NVkFASlxnQ0M/W4Wj/rKuMc0Bxf61nWOncxjrpwAAAAADACn/mQOvAzgAIwAoAC4AABsBFwczNjcXBgchFSEGByEVBgcWFwcmJwYHJzY3JicGByc2ExcWFzY3EhcHJic3dE9HOa8eEkkSHQHU/hkVEQGZKXp5ryXAfnm4JqdxdDJtrCXaaTEzeG8qKUozPXMwAf4BFgzFdn8JdnZFRys+gmhIPENHUlVIQz1KWWrsjEK/AU+0ZldXZgGWVTNNXC8AAwAy/6MDtQMNAAMABwAdAAATIREhJTUhFQc1IRUhByEGBwYjIi8BFjMyNzY3ITfPAkr9tgIA/krnA4P9qyIB6QklJGZKOxhQPVETEgn+Ci8DDf7yQYyM3EVFde8wLQZCBiEhh7YAAAAEAB//nQPGAzIACgASABYAGgAAARYXByYnBgUnJDcBESM1IRUjERMhNSEDIRUhAg6/+Sf6saL+8yYBCrEBVkb+FEZGAez+FA4CCP34AzLdfkWH2MqXRYzR/f7+bTw8AZP+7s4BCEUAAAMAbP+eA4QDNgADAAcAGwAAASERISU1IxUTBgchERQrAScXMjURIREjESE2NwE9AXH+jwEr5XwSIgG5W5YUkiv9eEgBEyQSAc3+okTW1gJ5TUD9ZWJJAywCRv1EAwFHUAAAAAAFAET/lAOaAw0ABwALAA8AGQAfAAABESMRIREjERMhFSElNSEVEwYHBgUnNjc2NwAXByYnNwM4Sf4QSTQCFP3sAcz+e/EVSE7+6Rz0T0YMAR+iJqyxJgHH/pQBKv7GAXwBRvdBdHT+5txOXhlBD1JOt/7gUzxdMjkAAAAAAwAt/6MDjgMnAAcACwAqAAABESM1IxUjERMzESMFMzUGByc2NxcGBxUzFSMVFhcHJicRIxEGByc2NzUjA45G80VF8/P98q9LThffliJTTqurV1gqUzJGQGsejTyvAu38109ZAzP9agJTjJAMBkASOTweEZ5DMkxjPnE5/j0BvY90ToSoBAAAAAQAWf+eA48DAwATABsAHwAlAAATIRUjFTMVIxUzFSE1MzUjNTM1IyURIzUhFSMREyERIQAXByYnN/wB79Kzs+/92e6zs9MCk0n9XElJAqT9XAITGzgeJDkCZEGQQJ9CQp9AkOD8mysrA2X9CgKy/ks6GkQxEwAAAAIAI/+ZA7EDOAAPACQAAAEzNTMVMxUjESEVITUhESMnBgcnNjchNSE2NxcGByEVIQYHESMBZ+VJ7+8BHP2NAQ7loTw6Lbtp/v8BIyETSxgXAff96TpSRwFfurpG/uxHRwEUGj4wO5rIR0tECVA2R3Zn/hQABQA1/74DtQMyAB8AIwAnACsAOwAAEzM1MxUhNTMVMxUjETMVIxYXByYnIQYHJzY3IzUzESMTITUhNSE1ITUhNSETMxUzFSMVIRUhNSE1IzUzULFGAVlGsbHA0EiXHbpO/sZOriWUSNDAsfcBWf6nAVn+pwFZ/qeKRsvLAVf9BQFezc0C5kxMTEw9/rVAWjM+Tn19UT05WEABS/61SDlHOUr+UlBAakNDakAAAAEAN//QA7EDMQAPAAATIREzESEVIREhFSE1IREhNwGZSgGX/mkBcfzUAXH+ZwHuAUP+vUX+bUZGAZMAAAIAYP+sA5cDNAAWAC0AAAEGByEVAgUnNjcmJzcWFzY3IQYHJyQ3Ehc2NyEGByckNxcGByEVAgUnNjcmJzcCMBseAR+i/kkfiGovMz85LZxV/tx1oCoBDIMXMKVh/tiGsysBRp0+KSQBEtX9ux3sqDY0QAMSHhs5/uAjQQkfOS8eNjg/fEUkQjOP/VA/R4ZAH0AhpiIpGzn+ng1FAjhHMx4AAAAAAQAp/5kDvgMwABYAABMhNjc1MxUUByEVIRIFByQDAgUnJBMhPQGFCwJKDQGf/nZpATQt/tJwXf7ALQE/Tv6HAipTYlFBYGVG/q23OroBUv6UpzydAXIAAAQALf+dA7gDMAAUAB4AJAA7AAATITY3MxQHIRUhFgUHJCcGBSckNyEBMxEjNQYHJzY3JhcHJic3JQYHMxUGBSc2NyYnNxYXNjcjBgcnNjdFAYsFAUYFAYz+hWMBLR3+tVdc/q4eAUFN/ooBC0pKb4sdoXZ6SCdSVScCShIR8kv+riNzVTUnMi8vVibcN1EsjTMBAyQwKStGoTlDSLOwTkNEmQJv/jOPOy1CMD+cPzxJKDklKxs9410/Hi01HiUnMD9RPDE6UXMAAwA5/5sDqwMqAB4AOgBDAAABFSM1IwYFJzY3ITUhNQYjJyAlFwYHFSEVIRYXByYnASE/ATY3FwchFSMGBxYXByYnBgUnMjcmJzY3IyEGDwIWFzY3AhdIDF7+/SnoWf7lAXCdhRYBiAEDI4KsAXb+32nWIP1r/iUBHQ8PEgpGLQHptTdGcZwsh5qg/vco45eDfjIq6wFADxQQEGh1TTECLbOzfl1BRVVDUQdAMD0bDFZDXThEU4b+8hYWGhAVQUNlQCQ9OzozZQY/RykcPTcTGRUTFyI5VAAAAQA//6MDqQMFABkAABMhNTY3ITUhFQYHFSEVIREUKwEnFjMyNREhPwGlf3f9zgKUeJcBfP6EW6wTS1cv/lsBg45JZ0REcmNpRv7DXUYDMQEmAAAABABH/6ADogM7AA0AKQAvADUAAAEVIzUhFSM1ITY3FwYHBSEVBgcVIRUhFRQrAScWMxYzMj0BITUhNTY3IRIXByYnNwQXByYnNwOaR/1BRgI9QTFJNDn+DgIbZncBff6DVn4RIhYhHSb+awGVfkH+TDAsPjQ2QQEmK0AtM0ECZuCbm+BfchtrS5pAQTozRKlRQgEBKpBEUzckAU1OH1lDIDtXIF1IIAAABAA//5YDpgM7AA0AEwAZADQAAAEVIzUhFSM1ISYnNxYXAhcHJic3NhcHJic3BTMVBgchFSEGBxYXByYnBgUnJD8CITUhNjcDjEn9YkkBfBUWTBIU1VolZGgkpV8kZWIjAS9JBSYBRv6bDBTOsii/xHn+/icBFWwMC/5TAdIsBQLJyIWKzTsrDCtH/tA9OUgmNXA/OUglMwtvg2NDFhtKbD55SXZGPUp4EBBDYoQAAAACAEn/nQOxAzgAOgBIAAAABxYXFAcGKwEnMzY3NjUmJwYFJyQ3JicGByc2NyYnDwEGByc2NzY3ITUhFSMGBxYXNjcXBgcWFwcmJwIXIRUjNSEVIzUhJic3Am4aGQEgJYEiGDBZFhsCAqf+8CQBLKEOD43zJP+GDhoLC2epJZFzQyT+9wJX5TMfNR+MfTFSWkagM6VIgRIBeEf9QkcBjBATSQEYB0tRdi40PwIZIV0gEoNTPliFLB9vRT5DZxcdBQYwMDsgMR4UQ0MjEjY/J1IxNiO8cTuGzQHyO65ra64tJQ0AAAAEADH/mQO2AwoAEgAmACoAMAAAEyE1MxUzFSMVFCsBJxYzMj0BIQEVIRUUMyE2NzY3FwYHBgchIjURFyE1IRIXByYnNzECYUjc3FuAEEYxLP2fAu79wysCFx0MCgZEBw0VP/26WUgB9f4LlUk2OmwzAQc/P0bUVEcFJMICSe5GKwETEzwWQSAsA1QBTqxr/Y9SNkpYMQAAAAEAQv/LA6UC7QALAAABITUhFSERIRUhNSEB0/6kAwP+owGI/J0BkQKnRkb9akZGAAEAOf+eA68DOwAfAAATISYnNxYXIRUhFSERFCsBJxcyNREjESMRIxEjESE1ITkBmRcfThcaAZT+agFFW2QSXyr9SvFHATj+agK+PDUMMUxFg/6VW0UEKgEW/e0CE/54Ac2DAAADAEv/nAO7AywAGQAdACUAAAEhFSMVMxEUKwEnFzI1ESMRIxEjESMRMzUjBTMRIxMzEQIHJzYTAYoCMfXOTEQTQB6JRolFzvb+zUZGsEYEyDa5AwMIRnv+FlNGBCABmP2cAmT9/wJEexn98gKR/iT+1oovegELAAACAC7/mQOsAzoAHAAgAAATBgcnNjcXBgchFSEVIRUhFSEVIRUjNSE1MxEhNQMzNSP8P18wmDRLDhgCbf7GARf+6QFa/qZJ/jKlASnh4eECe2tHPHLDDjI5RqBF2Ebf30YBHaD+Q9gAAAEAKv+UA7EDQAAPAAAAFyEVIRUCByc2ExEhJic3AikcAWz9GwZhO1UDAXQXIE8DDEVF4P63xTWtASwBJTc0DgAEACr/nAOxAzkACQAPABUAJQAANyE2ExcCBzMVIRIXByYnNxYXByYnNzYXIRUhFQIHJzYTESEmJzffAaFdRUdBWtP9PqgxRCo9P/MrRSE2Px4YAW79GwZhO1UDAXMYHk8N1gE5E/7c2EYBh9IRw6kUXNgQw7QU1zhG3/61xTWtAS4BJTAqDgAAAwAm/6ADvAMuAAUALAAwAAATBgcnNjcEFzY3FwYHMzUzFTMVIxUzFSMVMxUhNSE1IzUzNSMGByc2NwcmJzcnMxEjgwMfOyAEARsaNAdBAwmPStray8v0/aQBHuXlnBs0NhENMhciNY9JSQJskowRgZAyYoSTCT85u7tG8Uf0Rkb0R/FuXDAhHg1dUxGp/HIAAQAt/5wDwwM0AEYAAAAXBzMVIRYXFhc2NxcGBxYXFjM2NxcGIyInJicGByc2NyYnJichFTMGBwYHIi8BFjM2NzY3IxUCByc2NxEhJjUzFBczJic3Ay80Lnr+zAocBw1KL0E9XxYXMh4cFkEkQz9IHBZojiiXZxcPIAz+qfUDFBNLFUAWOyghCQgDrQZwN18FAZ0DSgO7LUwuAv85LkW3bx0pdqMcyIYxIkgCmiTIWiUueUA8RII8PHnBpvxLQAMEQQMBKy2rHv70ozGJ9QFNS1BTSDY6LAAAAwAj/5kDxwMwAB4APABBAAAXJxYzMj0BBgcnNjc1IzUzNTMVMxUjFTY3FQYHERQjEzM1MxUzFSMVMxUGBxYXByYnBgcnNjcmJyM1MzUjFxYXNjdKDysgKUE5EkFLeXlGampDKTA8V+XwRvHxyjR6YpAmlmd1qCKgbX0qNd3wiyZuaDFZRAUt7xoTRxAc7EW3t0XPIRdGGxz+4VoC+Y6ORaNApXVMOzxCVV08PDVVeptEo+eCaWWGAAQAJP+kA7oDMQAeAC4AQQBHAAAXJxYzMj0BBgcnNjc1IzUzNTMVMxUjFTY3FQYHERQjATMVMxUjFTMVITUzNSM1MwMhNTMVMxUjERQrAScWMzI9ASEWFwcmJzdLDzYYJ0wvEkhFenpKZ2cwPDY2WAHQSsbG8P3d6cTE8AFmSImJWIcQWCYp/pqwMzkvVzhbRgQp8hoOSBEW4ka9vUbGFB5JGRf+4FkDjGtBeEREeEH+jEtLRf7xWkUEK/2ARilIWyMAAAAHACz/ngPCAzAAGwAgACQAKgAwADYAVgAAARUjFQYHFhcHJicGByc2NyYnIzUjNSE2NxcGBwUWFzY3JSE1ITYXByYnNwYXByYnNyUGIScgNwEnFjMyPQEGByc2NzUjNTM1MxUzFSMVNj8BFQYHERQjA6Y6M3Npkyqma3e2JqhuZiwpMAGFNihDKyz+0C1eYzX+gwG8/kT5GDwaKj6EFjwbKD4B3Nb+oxUBS9v8zA8rIho4LRE3P29vR11dExosKTBIAf++KnhZPipAMkpJMUMoPVd0Lr5XaRlkQ+xcSEddQmWwPBZERhBNOBZEQhFCKUEk/HtFBRn8Fg5HDhfwRbe3RdIJDRhJFhf+1UgAAwA5/5oDxwMyAAYAHwAwAAABBgcWFzY3MwIHFhcHJicGByc2NyYnBgcnNhMXBgchFQE2NxcGByc2NREzNSE1IREjAlQLDTBPVgNFBm5fgymFXmKkLatgTDEfISxtJ0YKEgE//QqEfwukuxUg4P7uAVjgAlggI62Dm9j+/bCESzxLhH9NO0uDe587KziYAQgMPktF/d4sPkJOPT4MJwF07UX+jAADACX/nQPGAzIAGAAfAF8AACQnBgcnNjcmJwYHJzYTFwYHIRUjBgcWFwcBDwEWFzY3JTM1MxUzFSMVMzY3FwYHMxUjBgczFQYHFTY3FQYHFRQrAScWMzI9AQYHJzY3NTY3IwYHJzY3IzUzNjcjNTM1IwMrR1ePKJZRQCIcJytqJkcLEgEBPgdZTHAs/vkKCiQ+QAb9QINFa2s6Tjs4NztKfSsnqjNFXVVOZFVkEj8bK29tCm15ODGbT0wtLC4XajEt+LKDCXSFWUFXinqONzI2mQEDDEZIReyrgV8/ArYcG5p8krt/WVlAZmN2HWhUQzMnNDw8MQ4XQxUOdFdBBS5XDQpFBQ5JKjRBKjMZH0ApMUNmAAACAC3/mAO+AzgAGAAdAAATISYnNxYXIRUjBgcWFwcmJwYHJzY3JicjMxYXNjdAAZ4pO0g2MgF+nEqTnvEn+KKr/yb9oa1EmuFAnIU/AohRRRpEbEjun4ZZPF2LnUo/RJKq6MqWkc8AAAYAJ/+fA8QDLQAFAAsAIgAuADQAOgAAEhcHJic3JQYHJzY3ATMRMxEzFSMVFhcHJicRIxEGByc2NyMBMxE3FwcRIxEFJyUCFwcmJzcSFwcmJzecFjgaITwBTQkmNyAJ/quzSZWVRlErQStJQ2EegTqsAs1Hbgx6R/7fCgEraUUxPGkwSkExPGYwAnxtEHFbEwV5YhJWe/7nAVv+pUYaP1k/Yjb+bAGXkmpLfokBoP3JEUgS/vMBAixILQGxSTFHTy7+yEoySlIuAAAAAAUAIv+YA8QDPQATAB0AQABGAEwAAAEGBxUhFSMRIxEjFQIHJzY3ETY3BTMmJzcWFzMVIQczJic3FhczNjcXBgczFSMVMxUjERQrAScWMzI1ESM1MzUjFwYHJzY3BBcHJic3A6KHngFHbEeUCGszWQezlPy/wRkbShgYvP49CnMWH0AeF24cGEEaGnHBsLBXNg8bEie6usqYJkc8RiEBTxY8Hig8Auc0CbZF/eoCFnf+/Zg2geQBrANATTIlDC02QqE7Nhc6Tj5MFkUvQXBC/ulVQwUoAQZCcPaVcyZrhWFKF2NWEAAAAAABAEH/mQOvAzUAJgAAEyEmJzcWFyEVIQcVIQIHBgciLwEWMzY3NjchBgcGByc2NzY3NjchQQGvIClEKSUBdv3xCQGfAxQedhtYFk40TBIIA/6iEzdJhDSgNDIIBQH+6QKdRzgZPlpFsgL+2VaABARBAwNpN9h3ZYFqMohycpBfMgAAAAADAIv/mQMtAwkAAwAHABkAAAEVIT0CIRUDBgcnNjcRIREUKwEnFjMyPQEBOQGr/lUEEmE3YgMCPVWBFFwiIwHStLRDr6/+xsN/MobQAej88lZHBCzHAAAACAAu/5kDkQMuABMAFwAbAB8AOQA/AEQASAAAEzMVMzUzFTMVIxEzFSE1MxEjNTMTMzUjEyMVMwczNSMSFzY3ESERFCsBJxYzMj0BIwYHJzY3ByYnNwcGByc2NwEVBzM9AiMVfUbDRjw8Qf4nST4+RsPDw8PDw8PD9ShiAwFMWGoUSh0nwhVjNwICNSdEOIk6SjlNNgHbAb69Ay5wbm5D/llERAGnQ/4WYgFFZKJj/kdGitQB1Pz2XEcEM8fFhDMCBCZMWyMbbU8pS2QBX6YMskKvrwACACr/ngO6AzMAFwAdAAATITUzFSEVIRYXByQDIxEjESMCBSc2EyEkFwcmJzdMAYRIAYX+w2P3MP75ZwRIBG/+9Cf0av7EAscwOTVUOAJE7+9F+sI94QEY/Z8CYf7Ix0CuARHVRSlQWCMAAAACACf/mAPCAzAAFgA4AAATMzUzFTMVIxUWFwcmJxEjEQYHJzY3IwA3NjURIREUOwEyNzY3NjUXFAcGBwYrASI1ESMRFAcGByc6lUh8fEhFKjkqSDNWH3QxkgFrGRQBQxciEgoMAwdCBwYYGS8pYLIbGUc7Am3Dw0UzS1U+Xzr98QH8kn5Ok7r+BGpemAF7/Q0cBgkUI4oVYUM1FRFZArb+yaVvc201AAACACb/oAOvAzEAFwAuAAABNSE1MxUzFSMRFCsBJxYzMjURAgcnNhMlMzUzFTMVIxUWFwcmJxEjEQYHJzY3IwHVAR9Ic3NbahBEHSxp3yboZv1moUiFhU9NKkIwSDVfIXw2ngImRcbGRf3lY0YEMwHP/um6QbIBGEfDw0U7Slk+XTn9/gIMoIVSk7wAAAUAIf+gA7oDMAAFAA8AJgAqAC4AAAAXByYnNwUGBzMVITUhNjcBIxEGByc2NyM1MzUzFTMVIxUWFwcmJxMhFSETIRUhAj4uQCw2PwFqLDOI/hEBHDkq/edJNVUfdTCOkkl4eElLKzcycAI3/clKAbD+UALTXiBdUx8NiF5GRnWK/HACBJh7TpC5RcPDRThKXz9WQv54RgFbRgAAAAQANP+ZA7gDMQAjACkALwA1AAABMxUhFSEVIRUhBgc2NyYnNxYXByYnBgUnPwE2EyM1ITUjNTMkFwcmJzcSFwcmJzcTBgcnNjcCRkoBAf7/ARz+uGBIv7IlM0VaREQVFdz+8REIB0dy7QEd7e3+mkUzOmwzQz40NmIztUFPSFo9AzGhRrtG5GAUJk5VF5erHjYwLBo/BAM+AQxGu0ZITDRGUzH+yEwzR1Ux/tC/pR+xrgAAAAkAJ/+WA8IDNAAFACAAJgAsADIAOABAAEcAWAAAABcHJic3JzMVBgczFSMWFwcmJwYHBgcnNjc2NyM1MzY3AQYHJzY3BBcHJic3FhcHJic3BBcHJic3AAcWFzY3Jic2NyMGBxYXNxUCBSc2NyYnBgcnNjcXDwEDcyQ4JD81pkcBBdbCLbUnqjwRF0GSJ4s3GQ2BiwUB/mgkOUc7KQEAD0cLFEP1HUgZJkUBCj1APEc8/Z4iU0EhG01JyhSeEBFLSHVZ/rMieFhCTxsVLKc7RgkJAt05Jz5JIQpzMy1GuWs+brM8LndBPkFqOUFGLzH90o5qGWKPhW4ReW4OYoQRimkPXoAhh28dAWUpIigqLSoXLUolHxgkwDv+kZw/MlYsIRwTOZTXCR0dAAAAAAIAJf+cA5kDMgAmAEUAAAEGByEQBwYjIi8BFjMyNzYTIwYHBgcnNjc2NyMCByc2EyMGByc2NwEGByc2NxcGBzM1MxUzFSMVNjcVBgcRIxEGByc2NxECOhEUAYQPEJIVNhFAElwNCgNEITpGhyx8QDodTjyoL5o5RSgzNWAq/pYSFj84CD8DCUZGVFQpJxo2RlVIEVpUAyBTPf4LdYQDQQRgUAG4/JCeezlwjIvl/rqVNoMBIl8/LXjh/uhRQRKdsQVDQNDQRvATFUQOGv62ASwhF0YVIQEOAAYAJv+6A7oDCgATABcAGwAfACMAOgAAASERIxUzFSMVMxUhNTM1IzUzNSMlNSMVIzUjFTUzNSMzFTM1ATM1IzUhFSMVMxUjFTY3FQYHJzY3NSMBqQHhzNzc/P3A/N7ezQGch0iIiIjQh/z8a3kBO3htbTw8ia0SP0drAwr+MXpDf0VFf0N6QIiIiIjGiYmJ/vXsRETsRuAVG0U8LEUNE/gAAAAAAQAq/74DswMpAB4AABMGByc2NxcGBzM1MxUhFSEVIRUhFSEVITUhNSE1ITXxPF0ujjFJEBfWSQFJ/rcBNf7LAYn8jwGf/toBJgIxiF07lPoNTUSyskbnRv5ISP5G5wAABQAq/6UDdgMJAAMAGQAdACEAJQAAExUzNQUGByc2NxEhERQrAScWMzI9ASERIxElNSEVJTUhFScjFTPV/v7+EV83YAMC6WlzE1AfN/7wSgFa/vABEP7wSv7+AdSvr/HBfTGGzQHg/RNpRwQ/rv7bASVCr6/yrKysrAAAAAUAgf+rA74DLwADAB8AIwAnACsAABMVMzUVIxUjESE1MxUhESEVFDsBMjc2NxcGBwYjISI1NzM1Izc1IxUnIxUzyfb2SAE+SQFE/rxC5CQTDwZECRocRf7/ekn9/f39Sfb2AY2WltlVAkeJif4Oe0oREmUXgRoag8mWQpOTk5MABQBS/6gDmQMzAA0AEQAVABsAMgAAAREjNSMVIxEzNjcXBgcDMzUjNTM1IwAXByYnNyUQBwYjIi8BFjMyNzYTIQYHJzY3FwYHAZRGtkZdHQ5IExxbtra2tgISPDk9aDoBVw8PfQZgET8uRgwJA/7tKzkraCdHFBgChP1WOVYCx1JcCl9F/dLbQc7+5WMoY3sk5/4NdXMEQgNNVAGxYEs5kdcJYUYAAAAABACX/50DUQL6AAcACwAPABMAAAERIzUhFSMREyE1ITUhNSE1ITUhA1FJ/dhJSQIo/dgCKP3YAij92AL6/KNBQQNd/SqtRK9ErAAAAAYAMf+dA7kDMwADABoAHgAiACYALAAAATMRIwcGByckNyYnNxYXByYnBgchESM1IRUjNyE1ITUhNSE1ITUhEwYHJzY3AcRHR+RZOB4BzvQ6OTCabzImO5TfAY5G/itGRgHV/isB1f4rAdX+KzJahCqAVQMz/wC4EwpBS6cuKS5rbzMrMmlJ/estL29WOlA6UQFWb1Q2UWkABAAi/5sDwAL/AAMAGQArAC8AAAEjETMVIwIHJzYTIzUzESM1IRUjETMVIxEjATUhFSMGBzMRIxUjEQYHJzY3EzMRIwMEnJydDKc1mQltblgB21x3d0X9QAFanhUpuaxCHyYmdCYTaWkCu/7rRf7LkTCBARVFARVERP7rRf49AxdGRndr/jtPAaI5Mz6n2/2YAUYAAAQAIf+YA5sDLQAPABMAFwA1AAABMxUzESM1IxEjESMVIxEzAzMRIxMzESMlNjcXBgcVMxUjFRYXByYnESMRBgcnNjcjNTM1BgcCi0nHRoFJfUXCfX19xoGB/WO8ihlEPoGBSE8oQC9GN1gedDKTmjdSAy2w/jsz/rEBTzMBxf6xAQv+9QELrRIyQxUOpUUyRFs8YDz+LwHMlHNLhqxFlwkKAAAABAAj/58DwQMtAAsAEQAXADUAACUHESMRBSclETMRNwAXByYnNxIXByYnNyUzNQYHJzY3FwYHFTMVIxUWFwcmJxEjEQYHJzY3IwPBZUn+yAoBQkla/uZJMUN0M1RHM0F4M/4tpEpLDsCaGTxMiopXVSlTMEg9ZB9+OpzNEP7iARIzRjQCNf3XDwGaTjJLUDH+xk0zSlkxEJQLB0QPLkQRDqBFMUZSPWEv/jcB05V2UICnAAAABAAj/6ADuQMiAAMABwAbADkAAAEhESElNSEVByEVIxUzFSMVMxUhNTM1IzUzNSMlMzUGByc2NxcGBxUzFSMVFhcHJicRIxEGByc2NyMB1wGf/mEBWf7ubgHx2ru78v3P9ba2zf6Kkk02DryQGT1SgYFHSCg4L0U0Vh9yMIsDDP7fQaCgnkKAQYdERIdBgNORCwZEEi1EEhCdRTVFVjxXPv49AcOSd1CGqgAAAAQAO/+eA68DNQAFAAsAGQA+AAAAFwcmJzcHBgcnNjc2FyEVIzUhFSM1ISYnNwMzFQchERQ7ATI3NjUXBgcGKwEiNREjBgcGByc2NzY3IzUhNjcC9YAniZQknXy5H7N2fhIBckj9WkgBeBMXT21JAwECHkolCQZCCQgQVVVaxRc4Vb8nuksoEvsBBgICAhNuPHhJNi52TEFDcKY4yYaFyDAnDP6MSTf+xBwnPEMTgBg/VAEEbkprPD47XjtNRBMkAAQAM/+cA64DPgAiACgAOQBKAAATITUzFSEVIRUhFSMVMxUjFRQrAScWMzI9ASE1ITUhNSE1IRIXByYnNwMGByc2NxcGBzMVIxYXByYnJQYHJzY3FwYHIRUjFhcHJieoAShIAST+3AGWv5SUWZEPUDcq/c0CM/2SAZf+2MMtODBWOk4mLz5bKUUOC/+vKRpBJSgBdxwkPEogRAwMASK1KRg+JSoCBz4+QF4/YUGZU0QFJYhBYT9e/lQ8J0BQJAJASDonbX8PKxo9NC0YRjMCODAlYnEOJCE9NC4YQzcAAAAAAwA6/58DqgMlADQAOgBAAAAFJxYzMj0BBgcnNjc2NwYHJzY3NjcGIycgJRcGBwYHNjc2NxcGBzY3Jic3FhcHJicGBxEUIyQXByYnNwUGByc2NwFfEDwrJa2MFB4he5lpsA8XGkxlf5AVAa8BHSOg0Ftiaok6UUL9vf2mMB42fEE6GShajlUBdWYzXJ4w/rZlly2TY2FHBSX1CwZAAwo2cggLQAMKJm4GPz89JRBqQAUMLkkh32MOFD4jIZFpKSw7Cgz+9FW3bzNqdy40elw6V3IAAAAEAC//vgO9AzIACwAbACEAPgAAJSM1IRUjFTMVITUzAgcnJDchNSEVBgcWFwcmJwEGByc2NwMGBzY/AjY3FwYHNjcVBgcnNjc2NwYHJzY3NjcCc8QB08Xz/dLxJ6ctARht/qoBrCdFgVU1ToL+wIyzCruOWkxLR0QODxIMQoheZ2qYkRMSDj1SakASEQ1PO+FGRt1GRgGXQTtpwUU5WUpSTTVPV/48Ry5FK0kCncJwBgwbHCEYGfpvFiZCNRRCBw0+jA8IQggThrAAAAAFADL/ngO+AzoABQAgAD4ASABaAAAlBgcnNjcDBgc/ATY3FwYHNjcVBgcnNjc2NwYHJzY3NjcTPwE2NyM1MyYnNxYXMxUhBgc2NyYnNxYXByYnBgcXBgcGByc2NzY3ASI1ETMRFBczNjc2NRcUBwYHAX6Oqgm5iFtLTkJCGxxBhFdraJmVFBEQPFBoPBMRD089sggGMlGr/xQZSRcV4f7OQTSTgyMkN2k1OBQatOGXBygsZS5ZJSQGAR5aRRdBIQYHPhQUQTtHKUgpRAKXwHIKDDM4GflsGy5DQBlCCA4/jBMJQgcVhbT+iQMCJZxFNzAMNT5FgT0NFTMuIoZfJyYnHREpvFpdQjk5TE6p/ltXAVf+tR8DAyExURaNIh8DAAAFADT/nAO2AzQAFgAeACIAJgA0AAATISYnNxYXIRUjFhcHJicGBSc2NzY3KQEGByQ3Jic3ARUhPQIhHQIjESERFCsBJxcyPQE0AZ8TF1MSFgGS64hKPCMo5P5eEBIRRFb+9wFjWEgBFNMnJzL+UAHH/jlIAlhgZhNhLwLYKiUNIzlEbFMqKiYTED8DBypJUiwJESUfIP47T08+VVXLpgIE/ltdRgMpOAAGADH/mgOxAzEAAwAHABUALQBFAFkAADcVMz0CIx0CIxEhERQrAScXMj0BEyI1ETMVNjcXBgcVFDsBMjc2NxcGBwYjAxQ7ATI3NjcXBgcGKwEiNREzFTY3FwYHAhcHJicGByc2NzY3FwYHNjcmJzex6+tFAXZUUxJNJv1dR6JsF4ShKoMeDA4GQwocGTS5J4MeDA8GQgocGTWkWkeXdReCoZEvOxAUm+QUEg9fO0RGUoWGIiI4811dPGBg1r8CNP4rWEQDJlEBJmQBToUZHD8hF3gyDxNcFXccF/6RJA8TXhV5HBdWAVV7DyRAJg8B01UqISEZDDwFDmJ2FYdLCBE0MCMAAAQApP+dA0QDNAANABEAFQAZAAABESM1IRUjETM2NxcGBwMhNSE1ITUhNSE1IQNESf3ySdYjDkkRHtgCDv3yAg798gIO/fICuvzjPj4DHUA6Cjw0/WajQplClQAABAAw/50DtgM2ABMAOgBPAFUAABMzNTMVITUzFTMVIxUjNSEVIzUjBQYHFhUUBwYjIi8BFjMyNzY3NCcGByc2NyYnBgcnNjcmJzcWFzY3FzM2NTMUBzMVIxYXByYnBgcnNjcjJBcHJic3POpKAQhK6upK/vhK6gFVODNKJxw4LzAUNC4lEBECBk9yJ4lREBZDWSZaQi4/NUArMCZMzgNIAubgPbswrTk8pzDDG8oBxio2LEc2AuRSUlJSQUlJSUmGSC19tYQzHgJCBRkfYzAqUDs7P1s3JzAsPCU0NyQtKDUvMq9sOyeARPWDNoPLy4c0pNq6OCY/RCEAAAAAAQAo/54DsQMvADYAABMhNTMVIRUhFSEVIRUhFSEWFzY3FwYHFhcHJAMjBgcVNjcXBgcnNj0BBgcnNjchNSE1ITUhNSFoAWdKAWf+mQEt/tMBiv6UKTpVTTJOXmOMJv7ofiM0U2Z5Dp2fGCBTYybvb/6/AYr+0wEt/pkC2lVVQl9CX0FgSydSME4paTU/cQFFSz/VHjFDPyc+DBidMyc+VIJBX0JfAAAAAwAt/5oDwAMyAAsAEQAeAAABIREzESEVIREjESECFwcmJzcDMxE2NxcGByc2NREjAWYBD0oBAf7/Sv7xXUQxPm4yddhGMBJabhwXkwIFAS3+00j93QIjAR1NMklSMf7Y/kM7LUpXSUESGAGPAAAAAAQAK/+tA8oDMQAKACIAKAA1AAABFhcHJicGByc2NwMiNREzFTY3FwYHFRQ7ATI3NjcXBgcGIwAXByYnNwMzETY3FwYHJzY1ESMCo1bRJ8NdcKsnumcqZUiUiSmumDO2LxMbCUMMJyFI/fNEMT5uMnLTM0ASWW4cGI0DMb2MPYO/1nU9gtD8fG4BsbI4ZTpyOKk5FhuBFqAiHgMtTTJJUjH+2P5EKj9IWU1AFBgBkAAABwAq/58DxgMmABsAHwAjACcAKwAxAD4AAAEhESMVIRUjFhcHJicjESMRIwYHJzY3IzUhNSMlNSMVIzUjFTUzNSMzFTM1JBcHJic3AzMRNjcXBgcnNjURIwGOAe3WAQjGQ5wupkQJQwlJqiWaRsUBBtQBq5RDkpKS1ZT9yUcxPGwzedEnNBNQXRwViwMK/oJdQ4NpOYSh/rMBTbN0PV2NQ109Y2NjY55kZGQTTzFHUDH+2f5UIzRKUENAEhgBgwAABQA6/7YDrgMqACYAKgAuADIANgAAEyE1ITUhNQYHJyQlFwYHFSEVIRUhESEVIRUhFSEVITUhNSE1ITUhJTUjFSM1IxU1MzUjIRUzNZoBNf55AYeYpAwBhwEqFoO0AYn+dwE2/soBZv6aAZf8jAGV/p0BY/7LAm3wSPDw8AE48AILQD5ICQY7DCE8DgtMPkD+tEU6Sz8/SzpFOlFRUVGJT09PAAACAC7/tgO5AykAKQAuAAATBgcnJDczFgUHJicVIxUhFSERMzY3FwYHMxUhNTMmJzcWFzMRITUhNSMlJicGB+5MSioBBqQ6jwEYKUtJ4wFk/pxvMydCJi3P/KnPHjJBLShz/psBZeMB/ZJkcooCEy4iPHW1snU8Hys3kEP+9WJwF2lSRUVcVxhRegELQ5BBVnV2VQAABABO/5sDwgM2AA0AEQAzAEwAAAEVIzUhFSM1MyYnNxYXByEVIQchFSMRFDsBMjc2NxcGBwYHIyInJjURIwYHBgcnNjc2NyMBIRUGBxYXBgcGBycWMzY3NjU0JzY3IxEjA6NF/npG4xETShMQ4gF+/oJKAhymHSoSChAFQgkWFTBPJhQVXQwoM3UtZy0mCYv+vAEhKDhVBgIcKGUYIAgxExFcPSOURgLXy4eHyy8kDC0yvkFxRP7xKAoNdhaEHBYCGRolASCgSlo/OzdHQ4cB5jiGlYZoRB4jAkkEAw4PImR/moH81QAAAAQALP+VA8cDBgAOACAAJgAyAAATIzUhFSMRNjcVBgcnNjcTIRUjBgczESMRIREjETM2NyMAFwcmJzcDMxUGBwYHJzY3NjeudwE1dEkyhK4VTDbkAirvCQzURv6/RbAOCPQB41I0S4EwekgGUFCzJ69FQAQCiUZG/jwZFUg3L0cTDwJYRjY1/ioBlP5sAdYvPP1hWDRXYy4BVqyjYFkzPi9OUoIABwAi/5sDwAMKACAAJAAoACwAPgBEAFAAAAQ3ByMgJyYnBgcnNjcXBgcWFzUjNSEVIxUzFSMVFhcWIQEhESElNSMVNTM1IyUhFSMGBzMRIxEjESMRMzY3IwAXByYnNwMzFQYHBgcnNjc2NwNcZAzF/plaTj8bMDRQCEADBycvxgGooomJCQZXATP9jgFV/qsBD8nJyQFDAbC0BQilQ/JAjwgFuwF9PzM6XzBpQgM0MnQnaywoAxAESCchWGBRLoirCDYpPSPzQkJqQG0DAxsDGv6jPFVVjVg7Qiwk/mwBVv6qAZQiLv3RSDJITC4BKo2NV04uPidESG8AAAAABgA6/5wDrQM3AAkAFwAbAB8AIwAnAAAAFyEVITUhJic3EycXMjURIREjESERFCMBIRUhJTUhFRchFSElNSEVAhMOAYz8jQGaDBZPuBFQPv18RQMObv3QAi/90QHp/l0NAYn+dwFJ/vgDCi1CQiIqDvxoQQMwARD+fwHA/qJfArvCOFJS88g2XFwAAAABAAAAATMzEUvW918PPPUAAwPoAAAAANGAbcIAAAAA0rGijgAY/5EDygNAAAAABAACAAAAAAAAAAEAAAQk/qwAAAPoAAAAAAAAAAEAAAAAAAAAAAAAAAAAAAALA+gAAAJYAG8CWAA+AlgAMwJYABgCWAAzAlgAMwJYAEICWAAqAlgAMwPoADIAOgAzADkAMABpADkAOgAjACEAJAAnACMAIAAkACoANAAsACQAIwAzACcANgA3ADgALAApADIAHwBsAEQALQBZACMANQA3AGAAKQAtADkAPwBHAD8ASQAxAEIAOQBLAC4AKgAqACYALQAjACQALAA5ACUALQAnACIAQQCLAC4AKgAnACYAIQA0ACcAJQAmACoAKgCBAFIAlwAxACIAIQAjACMAOwAzADoALwAyADQAMQCkADAAKAAtACsAKgA6AC4ATgAsACIAOgAAAAYAHgBUAJ4AvAD6AUIBVgG2Af4CDAI8AoQCtAL+AywDWgOAA6ID6AQsBG4EqATwBWoFugYABkoGkAbiBzoHfgfOCCAIkAjSCSIJVgmKCbwJ+go+CnoKtAsKCygLegumDAoMdgygDPQNTA2+DgoOIg5UDpAOxA7kDygPcA/cEDgQmhEgEXIR/BIwEpYTChNME3gT4hQYFGwUshUAFVoV8BZcFq4W3hccF1wXsBfWGCIYbBi+GRgZbhnOGj4aqBsOG54b8hx0HKIdIB10HaweBB5kHrYfAB90H8YgRCCKAAEAAABvAGAACQAAAAAAAQAAAAAAAAAAAAAAAAAAAAAAAAAQAMYAAQAAAAAAAAAhAAAAAQAAAAAAAQAMACEAAQAAAAAAAgAHAC0AAQAAAAAAAwAcADQAAQAAAAAABAAPAFAAAQAAAAAABQAcAF8AAQAAAAAABgAKAHsAAQAAAAAABwANAIUAAwABBAkAAABCAJIAAwABBAkAAQAYANQAAwABBAkAAgAOAOwAAwABBAkAAwA4APoAAwABBAkABAAeATIAAwABBAkABQA4AVAAAwABBAkABgAUAYgAAwABBAkABwAaAZxDb3B5cmlnaHQoYykgUVpEIENvcnBvcmF0aW9uLjIwMjFRWkQtUElOR0ZBTkdSZWd1bGFyUVpEIFBpbmdGYW5nIFNDOlZlcnNpb24gMS4yMFFaRCBQaW5nRmFuZyBTQ1ZlcnNpb24gMS4yMCBKYW51YXJ5IDUsIDIwMTZQaW5nRmFuZ1NDQnkgUVpEIENYWSBGRQBDAG8AcAB5AHIAaQBnAGgAdAAoAGMAKQAgAFEAWgBEACAAQwBvAHIAcABvAHIAYQB0AGkAbwBuAC4AMgAwADIAMQBRAFoARAAtAFAASQBOAEcARgBBAE4ARwBSAGUAZwB1AGwAYQByAFEAWgBEACAAUABpAG4AZwBGAGEAbgBnACAAUwBDADoAVgBlAHIAcwBpAG8AbgAgADEALgAyADAAUQBaAEQAIABQAGkAbgBnAEYAYQBuAGcAIABTAEMAVgBlAHIAcwBpAG8AbgAgADEALgAyADAAIABKAGEAbgB1AGEAcgB5ACAANQAsACAAMgAwADEANgBQAGkAbgBnAEYAYQBuAGcAUwBDAEIAeQAgAFEAWgBEACAAQwBYAFkAIABGAEUAAwAAAAAAAP+cAEAAAAAAAAAAAAAAAAAAAAAAAAAAbw== '
font = FontDecrypt(str_base64=str_base64_)
font.decrypt('𤵼𥙌腐进𤵝防护𥪵𤹩腐蚀𧒄𥉥𥪵𥌙测试𢺔𦰤𤵢𤵩𥤣𥎧𤹩𥤣𥎧')
```
Outputs:
```shell
2022-01-20 17:01:47.932 | SUCCESS  | __main__:decrypt:89 - Out Decrypted Strings：中国腐进与防护学会腐蚀电化学及测试方法专业委员会委员
```


### Database Pipelines
With this module,insert data into database is more conveniently.
#### MySQL Pipeline
There is no need to care the order of items when insert data.

Usage example:
```shell
from CrawlersTools import MysqlPipeline

mysql_client = MysqlPipeline(host='127.0.0.1', username='root', password='', db='project', drop_column=["id"])
item = {"name": "MuggleK", "age": "18"}
mysql_client.insert_one(item, table_name='test_table')
```
Outputs:
```shell
2022-11-25 11:25:18.291 | SUCCESS  | pipelines.mysql_pipeline:insert:160 - Success: Insert {"name": "MuggleK", "age": "18"} -> test_table
```


### Http Request Base on Httpx
Usage example:
```shell
from CrawlersTools import base_requests

response = base_requests('https://example.org')
print(response)
```
Outputs:
```shell
<Response [200 OK]>
```


### Dynamic Thread
This concurrent mode will create a child thread for every task below max threads and when children thread less than max threads,the main thread will create child thread for new task.

Usage example:
```shell
from CrawlersTools import AutoThread

a_thread = AutoThread(thread_num=20, fun, arg_list)
a_thread.main_thread()
```


## Reference

### Paper

* [面向不规则列表的网页数据抽取技术的研究](http://www.cnki.com.cn/Article/CJFDTotal-JSYJ201509023.htm)
* [基于文本及符号密度的网页正文提取方法](https://kns.cnki.net/KCMS/detail/detail.aspx?dbcode=CJFQ&dbname=CJFDLAST2019&filename=GWDZ201908029&v=MDY4MTRxVHJXTTFGckNVUkxPZmJ1Wm5GQ2poVXJyQklqclBkTEc0SDlqTXA0OUhiWVI4ZVgxTHV4WVM3RGgxVDM=)
* [基于块密度加权标签路径特征的Web新闻在线抽取](https://kns.cnki.net/kcms/detail/detail.aspx?filename=PZKX201708010&dbcode=CJFQ&dbname=CJFD2017&v=)
* [基于DOM树和视觉特征的网页信息自动抽取](http://www.cnki.com.cn/Article/CJFDTOTAL-JSJC201310069.htm)
* [基于行块分布函数的通用网页正文抽取算法](https://code.google.com/archive/p/cx-extractor/)
### Project

* [GeneralNewsExtractor](https://github.com/kingname/GeneralNewsExtractor)
* [GerapyAutoExtractor](https://github.com/Gerapy/GerapyAutoExtractor)
* [artical-spider](https://github.com/govzhz/artical-spider)
* [html-extractor](https://github.com/cnyangkui/html-extractor)
* [vthread](https://github.com/cilame/vthread)


## Contribute

If you want to contribute with CrawlersTools check out the [GitHub](https://github.com/MuggleK/CrawlersTools).
