"""`KSIC10 Standard <http://kssc.kostat.go.kr/ksscNew_web/ekssc/main/main.do>`_."""
from ...types import Category, Classification, Standard, Standards

KSIC10 = Standard(
    standard=Standards.KSIC10,
    classes=[
        Classification("A", "Agriculture, forestry and fishing", Category.SECTION),
        Classification("01", "Agriculture", Category.DIVISION),
        Classification("011", "Growing of crops", Category.GROUP),
        Classification("0111", "Growing of cereal crops and other crops for food", Category.CLASS),
        Classification("01110", "Growing of cereal crops and other crops for food", Category.SUBCLASS),
        Classification("0112", "Growing of vegetable crops, horticultural and nursery products", Category.CLASS),
        Classification("01121", "Growing of vegetable crops", Category.SUBCLASS),
        Classification("01122", "Growing of horticultural products", Category.SUBCLASS),
        Classification("01123", "Growing of seed crops and nursery products", Category.SUBCLASS),
        Classification("0113", "Growing of fruit, beverage and spice crops", Category.CLASS),
        Classification("01131", "Growing of fruit", Category.SUBCLASS),
        Classification("01132", "Growing of beverage and spice crops", Category.SUBCLASS),
        Classification("0114", "Growing of other crops", Category.CLASS),
        Classification("01140", "Growing of other crops", Category.SUBCLASS),
        Classification("0115", "Growing of crops under cover", Category.CLASS),
        Classification("01151", "Growing of bean sprouts", Category.SUBCLASS),
        Classification(
            "01152", "Growing of vegetable, fruit crops and horticultural products under cover", Category.SUBCLASS
        ),
        Classification("01159", "Growing of other crops under cover", Category.SUBCLASS),
        Classification("012", "Animal production", Category.GROUP),
        Classification("0121", "Raising of cattle", Category.CLASS),
        Classification("01211", "Raising of dairy cattle", Category.SUBCLASS),
        Classification("01212", "Raising of beef cattle", Category.SUBCLASS),
        Classification("0122", "Raising of pigs", Category.CLASS),
        Classification("01220", "Raising of pigs", Category.SUBCLASS),
        Classification("0123", "Raising of poultry and other birds", Category.CLASS),
        Classification("01231", "Raising of chickens", Category.SUBCLASS),
        Classification("01239", "Raising of other poultry and birds", Category.SUBCLASS),
        Classification("0129", "Raising of other animals", Category.CLASS),
        Classification("01291", "Raising of horses, sheep and goats", Category.SUBCLASS),
        Classification("01299", "Raising of other animals n.e.c.", Category.SUBCLASS),
        Classification("013", "Growing of crops combined with rasinging of animals : mixed farming", Category.GROUP),
        Classification("0130", "Growing of crops combined with rasinging of animals : mixed farming", Category.CLASS),
        Classification(
            "01300", "Growing of crops combined with rasinging of animals : mixed farming", Category.SUBCLASS
        ),
        Classification("014", "Services incidental to growing of crops and raising of animals", Category.GROUP),
        Classification("0141", "Services incidental to growing of crops", Category.CLASS),
        Classification("01411", "Support activities for crop production", Category.SUBCLASS),
        Classification(
            "01412",
            "Drying, sorting, grading of agricultural products and other post-harvest crop activities",
            Category.SUBCLASS,
        ),
        Classification("0142", "Support activities for animal production", Category.CLASS),
        Classification("01420", "Support activities for animal production", Category.SUBCLASS),
        Classification("015", "Hunting, trapping and related service activities", Category.GROUP),
        Classification("0150", "Hunting, trapping and related service activities", Category.CLASS),
        Classification("01500", "Hunting, trapping and related service activities", Category.SUBCLASS),
        Classification("02", "Forestry", Category.DIVISION),
        Classification("020", "Forestry", Category.GROUP),
        Classification("0201", "Silviculture activities", Category.CLASS),
        Classification("02011", "Operation of forest tree nurseries", Category.SUBCLASS),
        Classification("02012", "Afforestation", Category.SUBCLASS),
        Classification("0202", "Logging", Category.CLASS),
        Classification("02020", "Logging", Category.SUBCLASS),
        Classification("0203", "Gathering of non-wood forest products", Category.CLASS),
        Classification("02030", "Gathering of non-wood forest products", Category.SUBCLASS),
        Classification("0204", "Support services to forestry", Category.CLASS),
        Classification("02040", "Support services to forestry", Category.SUBCLASS),
        Classification("03", "Fishing and aquaculture", Category.DIVISION),
        Classification("031", "Fishing", Category.GROUP),
        Classification("0311", "Marine fishing", Category.CLASS),
        Classification("03111", "Deep see fishing", Category.SUBCLASS),
        Classification("03112", "Littoral fishing", Category.SUBCLASS),
        Classification("0312", "Freshwater fishing", Category.CLASS),
        Classification("03120", "Freshwater fishing", Category.SUBCLASS),
        Classification("032", "Aquaculture and services incidental to fishing and aquaculture", Category.GROUP),
        Classification("0321", "Aquaculture", Category.CLASS),
        Classification("03211", "Marine aquaculture", Category.SUBCLASS),
        Classification("03212", "Inland aquaculture", Category.SUBCLASS),
        Classification("03213", "Hatching and seeding of aquatic animals and seaweeds", Category.SUBCLASS),
        Classification("0322", "Services incidental to fishing and aquaculture", Category.CLASS),
        Classification("03220", "Services incidental to fishing and aquaculture", Category.SUBCLASS),
        Classification("B", "Mining and quarrying", Category.SECTION),
        Classification("05", "Mining of coal, crude petroleum and natural gas", Category.DIVISION),
        Classification("051", "Mining of coal and lignite", Category.GROUP),
        Classification("0510", "Mining of coal and lignite", Category.CLASS),
        Classification("05100", "Mining of coal and lignite", Category.SUBCLASS),
        Classification("052", "Extraction of crude petroleum and natural gas", Category.GROUP),
        Classification("0520", "Extraction of crude petroleum and natural gas", Category.CLASS),
        Classification("05200", "Extraction of crude petroleum and natural gas", Category.SUBCLASS),
        Classification("06", "Mining of metal ores", Category.DIVISION),
        Classification("061", "Mining of iron ores", Category.GROUP),
        Classification("0610", "Mining of iron ores", Category.CLASS),
        Classification("06100", "Mining of iron ores", Category.SUBCLASS),
        Classification("062", "Mining of non-ferrous metal ores", Category.GROUP),
        Classification("0620", "Mining of non-ferrous metal ores", Category.CLASS),
        Classification("06200", "Mining of non-ferrous metal ores", Category.SUBCLASS),
        Classification("07", "Mining of non-metallic minerals, except fuel", Category.DIVISION),
        Classification("071", "Quarrying of stone, sand and clay", Category.GROUP),
        Classification("0711", "Quarrying of limestone, gypsum and clays", Category.CLASS),
        Classification("07110", "Quarrying of limestone, gypsum and clays", Category.SUBCLASS),
        Classification("0712", "Quarrying of stone, broken stone, sand and gravel", Category.CLASS),
        Classification("07121", "Quarrying, cruhsing and breaking of stone for construction", Category.SUBCLASS),
        Classification("07122", "Quarrying of sand and gravel", Category.SUBCLASS),
        Classification("072", "Mining of other non-metal ores", Category.GROUP),
        Classification("0721", "Mining of chemical and fertilizer minerals", Category.CLASS),
        Classification("07210", "Mining of chemical and fertilizer minerals", Category.SUBCLASS),
        Classification("0722", "Extraction of salt", Category.CLASS),
        Classification("07220", "Extraction of salt", Category.SUBCLASS),
        Classification("0729", "Mining of other non-metal ores n.e.c.", Category.CLASS),
        Classification("07290", "Mining of other non-metal ores n.e.c.", Category.SUBCLASS),
        Classification("08", "Mining support service activities", Category.DIVISION),
        Classification("080", "Mining support service activities", Category.GROUP),
        Classification("0800", "Mining support service activities", Category.CLASS),
        Classification("08000", "Mining support service activities", Category.SUBCLASS),
        Classification("C", "Manufacturing", Category.SECTION),
        Classification("10", "Manufacture of food products", Category.DIVISION),
        Classification(
            "101", "Slaughtering of livestock, processing and preserving of meat and meat products", Category.GROUP
        ),
        Classification("1011", "Slaughtering of livestock", Category.CLASS),
        Classification("10111", "Slaughtering of livestock(except poultry)", Category.SUBCLASS),
        Classification("10112", "Slaughtering of poultry", Category.SUBCLASS),
        Classification("1012", "Processing, preserving of meat and meat products", Category.CLASS),
        Classification("10121", "Processing, preserving of poultry products", Category.SUBCLASS),
        Classification(
            "10122", "Cutting in individuals, freezing and packaging of meat(except poultry)", Category.SUBCLASS
        ),
        Classification(
            "10129", "Processing and preserving of other meat and meat products(except poultry)", Category.SUBCLASS
        ),
        Classification("102", "Processing and preserving of fish, crustaceans, molluscs and seaweeds", Category.GROUP),
        Classification("1021", "Processing and preserving of aquatic animals", Category.CLASS),
        Classification(
            "10211", "Manufacture of smoked, seasoned and similar prepared aquatic animal products", Category.SUBCLASS
        ),
        Classification("10212", "Manufacture of dried, salted aquatic animal products", Category.SUBCLASS),
        Classification("10213", "Manufacture of frozen aquatic animal products", Category.SUBCLASS),
        Classification("10219", "Processing and preserving of other aquatic animals", Category.SUBCLASS),
        Classification("1022", "Processing and preserving of edible seaweeds", Category.CLASS),
        Classification("10220", "Processing and preserving of edible seaweeds", Category.SUBCLASS),
        Classification("103", "Processing and preserving of fruit and vegetables", Category.GROUP),
        Classification("1030", "Processing and preserving of fruit and vegetables", Category.CLASS),
        Classification("10301", "Manufacture of kimchi, korean picked vegetables", Category.SUBCLASS),
        Classification("10302", "Manufacture of pickled fruit and other vegetables", Category.SUBCLASS),
        Classification("10309", "Processing and preserving of other fruits and vegetables", Category.SUBCLASS),
        Classification("104", "Manufacture of vegetable and animal oils and fats", Category.GROUP),
        Classification("1040", "Manufacture of vegetable and animal oils and fats", Category.CLASS),
        Classification("10401", "Manufacture of animal oils and fats", Category.SUBCLASS),
        Classification("10402", "Manufacture of vegetable oils and fats", Category.SUBCLASS),
        Classification("10403", "Manufacture of edible refined oils and processed oils", Category.SUBCLASS),
        Classification("105", "Manufacture of dairy products and edible ice cakes", Category.GROUP),
        Classification("1050", "Manufacture of dairy products and edible ice cakes", Category.CLASS),
        Classification("10501", "Manufacture of liquid milk and other dairy products", Category.SUBCLASS),
        Classification("10502", "Manufacture of ice-cream and other edible ice cakes", Category.SUBCLASS),
        Classification("106", "Manufacture of grain mill products, starches and starch products", Category.GROUP),
        Classification("1061", "Manufacture of grain mill products", Category.CLASS),
        Classification("10611", "Polishing of cereals", Category.SUBCLASS),
        Classification("10612", "Milling of cereals", Category.SUBCLASS),
        Classification("10613", "Manufacture of cereal mixes and doughs", Category.SUBCLASS),
        Classification("10619", "Manufacture of other grain mill products", Category.SUBCLASS),
        Classification("1062", "Manufacture of starches and starch products", Category.CLASS),
        Classification("10620", "Manufacture of starches and starch products", Category.SUBCLASS),
        Classification("107", "Manufacture of other food products", Category.GROUP),
        Classification("1071", "Manufacture of rice cakes, bakery products and sugar confectioneries", Category.CLASS),
        Classification("10711", "Manufacture of rice cakes", Category.SUBCLASS),
        Classification("10712", "Manufacture of bakery products", Category.SUBCLASS),
        Classification("10713", "Manufacture of sugar confectioneries and cocoa products", Category.SUBCLASS),
        Classification("1072", "Manufacture of sugar", Category.CLASS),
        Classification("10720", "Manufacture of sugar", Category.SUBCLASS),
        Classification("1073", "Manufacture of noodles, macaroni and similar farinaceous products", Category.CLASS),
        Classification("10730", "Manufacture of noodles, macaroni and similar farinaceous products", Category.SUBCLASS),
        Classification("1074", "Manufacture of condiments and food additive products", Category.CLASS),
        Classification("10741", "Manufacture of vinegar,fermentation and chemical seasionings", Category.SUBCLASS),
        Classification("10742", "Manufacture of natural processed spices and mixed condiments", Category.SUBCLASS),
        Classification("10743", "Manufacture of soy sauce and soy bean paste", Category.SUBCLASS),
        Classification("10749", "Manufacture of other food additive products", Category.SUBCLASS),
        Classification("1075", "Manufacture of box lunches and prepared meals and dishes", Category.CLASS),
        Classification("10751", "Manufacture of box lunches", Category.SUBCLASS),
        Classification("10759", "Manufacture of other prepared meals and dishes", Category.SUBCLASS),
        Classification("1079", "Manufacture of other food products", Category.CLASS),
        Classification("10791", "Processing of coffee", Category.SUBCLASS),
        Classification("10792", "Processing of tea", Category.SUBCLASS),
        Classification("10793", "Manufacture of soups and food containing homogenized ingredients", Category.SUBCLASS),
        Classification("10794", "Manufacture of bean curd and similar products", Category.SUBCLASS),
        Classification("10795", "Manufacture of ginseng products", Category.SUBCLASS),
        Classification("10796", "Manufacture of liquidized health additive foods", Category.SUBCLASS),
        Classification("10797", "Manufacture of health functional foods", Category.SUBCLASS),
        Classification("10799", "Manufacture of other food products n.e.c.", Category.SUBCLASS),
        Classification("108", "Manufacture of prepared animal feeds and feed additives", Category.GROUP),
        Classification("1080", "Manufacture of livestock feeds and prepared animal feeds", Category.CLASS),
        Classification("10801", "Manufacture of formula feeds", Category.SUBCLASS),
        Classification("10802", "Manufacture of single ingredients and other prepared animal feeds", Category.SUBCLASS),
        Classification("11", "Manufacture of beverages", Category.DIVISION),
        Classification("111", "Manufacture of alcoholic beverages", Category.GROUP),
        Classification("1111", "Manufacture of other fermented alcoholic beverages", Category.CLASS),
        Classification("11111", "Manufacture of raw rice wines and refined rice wines", Category.SUBCLASS),
        Classification("11112", "Manufacture of malt and malt liquors", Category.SUBCLASS),
        Classification("11119", "Manufacture of other fermented alcoholic beverages", Category.SUBCLASS),
        Classification("1112", "Manufacture of distilled and compound liquors", Category.CLASS),
        Classification("11121", "Manufacture of ethyl alcohol and neutral spirits", Category.SUBCLASS),
        Classification("11122", "Manufacture of blended and distilled soju", Category.SUBCLASS),
        Classification("11129", "Manufacture of other distilled and compound liquors", Category.SUBCLASS),
        Classification(
            "112", "Manufacture of ice and non-alcoholic beverages; production of mineral waters", Category.GROUP
        ),
        Classification(
            "1120", "Manufacture of ice and non-alcoholic beverages; production of mineral waters", Category.CLASS
        ),
        Classification("11201", "Manufacture of ice, except dry ice", Category.SUBCLASS),
        Classification("11202", "Production of natural mineral waters and other bottled waters", Category.SUBCLASS),
        Classification("11209", "Manufacture of other non-alcoholic beverages", Category.SUBCLASS),
        Classification("12", "Manufacture of tobacco products", Category.DIVISION),
        Classification("120", "Manufacture of tobacco products", Category.GROUP),
        Classification("1200", "Manufacture of tobacco products", Category.CLASS),
        Classification("12000", "Manufacture of tobacco products", Category.SUBCLASS),
        Classification("13", "Manufacture of textiles, except apparel", Category.DIVISION),
        Classification("131", "Spinning of textiles and processing of threads and yarns", Category.GROUP),
        Classification("1310", "Spinning of textiles and processing of threads and yarns", Category.CLASS),
        Classification("13101", "Spinning of cotton", Category.SUBCLASS),
        Classification("13102", "Spinning of wool", Category.SUBCLASS),
        Classification("13103", "Spinning of man-made fibers", Category.SUBCLASS),
        Classification(
            "13104", "Manufacture of twisted threads and processing of threads and yarns", Category.SUBCLASS
        ),
        Classification("13109", "Spinning of other textile fibers", Category.SUBCLASS),
        Classification("132", "Weaving of textiles and manufacture of textile products", Category.GROUP),
        Classification("1321", "Weaving of textiles", Category.CLASS),
        Classification("13211", "Weaving of cotton fabrics", Category.SUBCLASS),
        Classification("13212", "Weaving of woolen fabrics", Category.SUBCLASS),
        Classification("13213", "Weaving of man-made fiber fabrics", Category.SUBCLASS),
        Classification("13219", "Weaving of special textiles and other fabrics", Category.SUBCLASS),
        Classification("1322", "Manufacture of textile products", Category.CLASS),
        Classification("13221", "Manufacture of bedding and related products", Category.SUBCLASS),
        Classification("13222", "Manufacture of embroidery products and related materials", Category.SUBCLASS),
        Classification("13223", "Manufacture of curtains and similar goods", Category.SUBCLASS),
        Classification("13224", "Manufacture of tarpaulin products, tents and similar goods", Category.SUBCLASS),
        Classification("13225", "Manufacture of textile bags", Category.SUBCLASS),
        Classification("13229", "Manufacture of other household made-up textile articles", Category.SUBCLASS),
        Classification("133", "Manufacture of knitted and crocheted fabrics", Category.GROUP),
        Classification("1330", "Manufacture of knitted and crocheted fabrics", Category.CLASS),
        Classification("13300", "Manufacture of knitted and crocheted fabrics", Category.SUBCLASS),
        Classification("134", "Dyeing and finishing of textiles and wearing apparel", Category.GROUP),
        Classification("1340", "Dyeing and finishing of textiles and wearing apparel", Category.CLASS),
        Classification("13401", "Dyeing and finishing of cotton wools and yarns", Category.SUBCLASS),
        Classification(
            "13402", "Dyeing and finishing of woven and knitted fabrics, including wearing apparel", Category.SUBCLASS
        ),
        Classification("13403", "Printing of textiles", Category.SUBCLASS),
        Classification("13409", "Other finishing of textiles and wearing apparel", Category.SUBCLASS),
        Classification("139", "Manufacture of other made-up textile articles, except apparel", Category.GROUP),
        Classification("1391", "Manufacture of carpets, rugs and similar products", Category.CLASS),
        Classification("13910", "Manufacture of carpets, rugs and similar products", Category.SUBCLASS),
        Classification("1392", "Manufacture of cordage, rope, twine and netting", Category.CLASS),
        Classification("13921", "Manufacture of cordage and rope", Category.SUBCLASS),
        Classification("13922", "Manufacture of fishing nets and other products of rope or netting", Category.SUBCLASS),
        Classification("1399", "Manufacture of other textiles n.e.c.", Category.CLASS),
        Classification("13991", "Manufacture of narrow woven fabrics", Category.SUBCLASS),
        Classification("13992", "Manufacture of other non-woven and felt fabrics", Category.SUBCLASS),
        Classification("13993", "Manufacture of special yarns and tire cord fabrics", Category.SUBCLASS),
        Classification("13994", "Manufacture of impregnated, coated, covered or laminated fabrics", Category.SUBCLASS),
        Classification("13999", "Manufacture of other textiles n.e.c.", Category.SUBCLASS),
        Classification(
            "14", "Manufacture of wearing apparel, clothing accessories and fur articles", Category.DIVISION
        ),
        Classification("141", "Manufacture of sewn wearing apparel, except fur apparel", Category.GROUP),
        Classification("1411", "Manufacture of outerwear", Category.CLASS),
        Classification("14111", "Manufacture of outerwear for men", Category.SUBCLASS),
        Classification("14112", "Manufacture of outerwear for women", Category.SUBCLASS),
        Classification("1412", "Manufacture of underwear and nightwear", Category.CLASS),
        Classification("14120", "Manufacture of underwear and nightwear", Category.SUBCLASS),
        Classification("1413", "Manufacture of hanbok, korean traditional clothes", Category.CLASS),
        Classification("14130", "Manufacture of hanbok, korean traditional clothes", Category.SUBCLASS),
        Classification("1419", "Manufacture of other sewn wearing apparel", Category.CLASS),
        Classification("14191", "Manufacture of shirts and blouses", Category.SUBCLASS),
        Classification("14192", "Manufacture of work wear and similar garments", Category.SUBCLASS),
        Classification("14193", "Manufacture of leather garments", Category.SUBCLASS),
        Classification("14194", "Manufacture of babies' garments", Category.SUBCLASS),
        Classification("14199", "Manufacture of other sewn wearing apparel n.e.c.", Category.SUBCLASS),
        Classification("142", "Manufacture of articles of fur", Category.GROUP),
        Classification("1420", "Manufacture of articles of fur", Category.CLASS),
        Classification("14200", "Manufacture of articles of fur", Category.SUBCLASS),
        Classification("143", "Manufacture of knitted and crocheted apparel", Category.GROUP),
        Classification("1430", "Manufacture of knitted and crocheted apparel", Category.CLASS),
        Classification("144", "Manufacture of apparel accessories", Category.GROUP),
        Classification("1441", "Manufacture of knitted and crocheted apparel accessories", Category.CLASS),
        Classification("14411", "Manufacture of stockings and other hosiery", Category.SUBCLASS),
        Classification("14419", "Manufacture of other knitted and crocheted apparel accessories", Category.SUBCLASS),
        Classification("1449", "Manufacture of other clothing accessories", Category.CLASS),
        Classification("14491", "Manufacture of hats and caps", Category.SUBCLASS),
        Classification("14499", "Manufacture of other clothing accessories n.e.c.", Category.SUBCLASS),
        Classification("15", "Manufacture of leather, luggage and footwear", Category.DIVISION),
        Classification("151", "Manufacture of leather, luggage and similar products", Category.GROUP),
        Classification("1511", "Manufacture of furs and leathers", Category.CLASS),
        Classification("15110", "Manufacture of furs and leathers", Category.SUBCLASS),
        Classification("1512", "Manufacture of handbags, luggage and other protective cases", Category.CLASS),
        Classification("15121", "Manufacture of handbags and purses", Category.SUBCLASS),
        Classification("15129", "Manufacture of luggage and other protective cases", Category.SUBCLASS),
        Classification("1519", "Manufacture of other leather articles", Category.CLASS),
        Classification("15190", "Manufacture of other leather articles", Category.SUBCLASS),
        Classification("152", "Manufacture of footwear and parts of footwear", Category.GROUP),
        Classification("1521", "Manufacture of footwear", Category.CLASS),
        Classification("15211", "Manufacture of shoes", Category.SUBCLASS),
        Classification("15219", "Manufacture of other footwear", Category.SUBCLASS),
        Classification("1522", "Manufacture of parts of footwear", Category.CLASS),
        Classification("15220", "Manufacture of parts of footwear", Category.SUBCLASS),
        Classification(
            "16", "Manufacture of wood and of products of wood and cork; except furniture", Category.DIVISION
        ),
        Classification("161", "Sawmilling and planing of wood", Category.GROUP),
        Classification("1610", "Sawmilling and planing of wood", Category.CLASS),
        Classification("16101", "Sawmilling of wood", Category.SUBCLASS),
        Classification(
            "16102", "Manufacture of surface processing wood and woods for special purpose", Category.SUBCLASS
        ),
        Classification("16103", "Preservation, antisepsis, painting and similar processing of wood", Category.SUBCLASS),
        Classification("162", "Manufacture of wood products", Category.GROUP),
        Classification("1621", "Manufacture of veneer sheets, plywood and densified wood", Category.CLASS),
        Classification(
            "16211", "Manufacture of veneer sheets, plywood and similar laminated wood boards", Category.SUBCLASS
        ),
        Classification("16212", "Manufacture of densified and reconstituted wood", Category.SUBCLASS),
        Classification("1622", "Manufacture of wooden goods for construction industry", Category.CLASS),
        Classification("16221", "Manufacture of wooden doors and related products", Category.SUBCLASS),
        Classification("16229", "Manufacture of other wooden goods for construction industry", Category.SUBCLASS),
        Classification("1623", "Manufacture of wooden containers, drums and load boards", Category.CLASS),
        Classification("16231", "Manufacture of wooden pallets and other load boards", Category.SUBCLASS),
        Classification("16232", "Manufacture of wooden packing boxes, drums and similar containers", Category.SUBCLASS),
        Classification("1629", "Manufacture of other wood products", Category.CLASS),
        Classification(
            "16291", "Manufacture of wooden tools, appliances and household kitchendware", Category.SUBCLASS
        ),
        Classification("16292", "Manufacture of wooden statuettes and ornaments", Category.SUBCLASS),
        Classification("16299", "Manufacture of other wood products n.e.c.", Category.SUBCLASS),
        Classification("163", "Manufacture of articles of cork, straw and plaiting materials", Category.GROUP),
        Classification("1630", "Manufacture of articles of cork, straw and plaiting materials", Category.CLASS),
        Classification("16300", "Manufacture of articles of cork, straw and plaiting materials", Category.SUBCLASS),
        Classification("17", "Manufacture of pulp, paper and paper products", Category.DIVISION),
        Classification("171", "Manufacture of pulp, paper and paperboard", Category.GROUP),
        Classification("1711", "Manufacture of pulp", Category.CLASS),
        Classification("17110", "Manufacture of pulp", Category.SUBCLASS),
        Classification("1712", "Manufacture of paper and paperboard", Category.CLASS),
        Classification("17121", "Manufacture of newsprint", Category.SUBCLASS),
        Classification("17122", "Manufacture of printing and writing paper", Category.SUBCLASS),
        Classification("17123", "Manufacture of kraft paper and paperboard", Category.SUBCLASS),
        Classification(
            "17124", "Manufacture of lamination, composition and specific surface processing paper", Category.SUBCLASS
        ),
        Classification("17125", "Manufacture of paper for sanitary purpose", Category.SUBCLASS),
        Classification("17129", "Manufacture of other paper and paperboard", Category.SUBCLASS),
        Classification("172", "Manufacture of corrugated paper, paper boxes and paper containers", Category.GROUP),
        Classification("1721", "Manufacture of corrugated paper and related products", Category.CLASS),
        Classification("17211", "Manufacture of corrugated paper", Category.SUBCLASS),
        Classification("17212", "Manufacture of corrugated boxes and related products", Category.SUBCLASS),
        Classification("1722", "Manufacture of paper sacks, paperboard boxes and containers", Category.CLASS),
        Classification("17221", "Manufacture of paper sacks and paper bags", Category.SUBCLASS),
        Classification("17222", "Manufacture of paperboard boxes and containers", Category.SUBCLASS),
        Classification("17223", "Manufacture of sanitary paper boxes and containers for food", Category.SUBCLASS),
        Classification("17229", "Manufacture of other paper boxes and containers", Category.SUBCLASS),
        Classification("179", "Manufacture of other paper and paperboard products", Category.GROUP),
        Classification("1790", "Manufacture of other paper and paperboard products", Category.CLASS),
        Classification("17901", "Manufacture of stationery paper", Category.SUBCLASS),
        Classification("17902", "Manufacture of sanitary paper products", Category.SUBCLASS),
        Classification("17903", "Manufacture of wallpaper and oilpaper", Category.SUBCLASS),
        Classification("17909", "Manufacture of other articles of paper and paperboard n.e.c.", Category.SUBCLASS),
        Classification("18", "Printing and reproduction of recorded media", Category.DIVISION),
        Classification("181", "Printing and service activities related to printing", Category.GROUP),
        Classification("1811", "Printing", Category.CLASS),
        Classification("18111", "Master printing by stencil plate and similar plates", Category.SUBCLASS),
        Classification("18112", "Screen printing", Category.SUBCLASS),
        Classification("18113", "Offset printing", Category.SUBCLASS),
        Classification("18119", "Other printing", Category.SUBCLASS),
        Classification("1812", "Service activities related to printing", Category.CLASS),
        Classification("18121", "Plate-making and typesetting services", Category.SUBCLASS),
        Classification("18122", "Bookbinding services", Category.SUBCLASS),
        Classification("18129", "Other service activities related to printing", Category.SUBCLASS),
        Classification("182", "Reproduction of recorded media", Category.GROUP),
        Classification("1820", "Reproduction of recorded media", Category.CLASS),
        Classification("18200", "Reproduction of recorded media", Category.SUBCLASS),
        Classification("19", "Manufacture of coke, briquettes and refined petroleum products", Category.DIVISION),
        Classification("191", "Manufacture of coke and briquettes", Category.GROUP),
        Classification("1910", "Manufacture of coke and briquettes", Category.CLASS),
        Classification("19101", "Manufacture of coke and related products", Category.SUBCLASS),
        Classification("19102", "Manufacture of briquettes and other coal products", Category.SUBCLASS),
        Classification("192", "Manufacture of refined petroleum products", Category.GROUP),
        Classification("1921", "Petroleum refineries", Category.CLASS),
        Classification("19210", "Petroleum refineries", Category.SUBCLASS),
        Classification("1922", "Reprocessing of fractionation in petroleum refinery", Category.CLASS),
        Classification("19221", "Manufacture of lubricating oils and greases", Category.SUBCLASS),
        Classification("19229", "Reprocessing of other fractionation in petroleum refinery", Category.SUBCLASS),
        Classification(
            "20",
            "Manufacture of chemicals and chemical products; except pharmaceuticals and medicinal chemicals",
            Category.DIVISION,
        ),
        Classification("201", "Manufacture of basic chemicals", Category.GROUP),
        Classification("2011", "Manufacture of basic organic chemicals", Category.CLASS),
        Classification("20111", "Manufacture of basic organic petrochemicals", Category.SUBCLASS),
        Classification("20112", "Manufacture of natural gum and silvichemicals", Category.SUBCLASS),
        Classification("20119", "Manufacture of coal and other basic organic chemicals", Category.SUBCLASS),
        Classification("2012", "Manufacture of basic inorganic chemicals", Category.CLASS),
        Classification("20121", "Manufacture of industrial gases", Category.SUBCLASS),
        Classification("20129", "Manufacture of other basic inorganic chemicals", Category.SUBCLASS),
        Classification(
            "2013",
            "Manufacture of inorganic dyes, pigments, tanning materials and other coloring agents",
            Category.CLASS,
        ),
        Classification(
            "20131", "Manufacture of metal oxides for inorganic pigments and related products", Category.SUBCLASS
        ),
        Classification(
            "20132",
            "Manufacture of dyes, synthetic inorganic pigments, tanning materials and other coloring agents",
            Category.SUBCLASS,
        ),
        Classification("202", "Manufacture of plastics and synthetic rubber in primary forms", Category.GROUP),
        Classification("2020", "Manufacture of plastics and synthetic rubber in primary forms", Category.CLASS),
        Classification("20201", "Manufacture of synthetic rubber", Category.SUBCLASS),
        Classification("20202", "Manufacture of synthetic resin and other plastic materials", Category.SUBCLASS),
        Classification("20203", "Manufacture of mixed, blended and recycled plastic materials", Category.SUBCLASS),
        Classification("203", "Manufacture of fertilizers, pesticides, germicides and insecticides", Category.GROUP),
        Classification("2031", "Manufacture of fertilizers and nitrogen compounds", Category.CLASS),
        Classification(
            "20311",
            "Manufacture of nitrogen compounds and nitrogenous, phosphatic and potassic fertilizers",
            Category.SUBCLASS,
        ),
        Classification("20312", "Manufacture of composite and other chemical fertilizers", Category.SUBCLASS),
        Classification("20313", "Manufacture of organic fertilizers and bed soils", Category.SUBCLASS),
        Classification("2032", "Manufacture of germicides, insecticides and pesticides", Category.CLASS),
        Classification(
            "20321", "Manufacture of chemical germicides, insecticides and agrochemical products", Category.SUBCLASS
        ),
        Classification(
            "20322", "Manufacture of biotic germicides, insecticides and plant protectors", Category.SUBCLASS
        ),
        Classification("204", "Manufacture of other chemical products", Category.GROUP),
        Classification("2041", "Manufacture of ink, paint, coating and similar products", Category.CLASS),
        Classification("20411", "Manufacture of general paints and similar products", Category.SUBCLASS),
        Classification(
            "20412", "Manufacture of enames, glazes, engobes and similar preparations for ceramic", Category.SUBCLASS
        ),
        Classification("20413", "Manufacture of printing ink and paints for pictures", Category.SUBCLASS),
        Classification("2042", "Manufacture of detergents, cosmetics and polishing preparations", Category.CLASS),
        Classification("20421", "Manufacture of surface-active agents", Category.SUBCLASS),
        Classification("20422", "Manufacture of toothpastes, soaps and other detergents", Category.SUBCLASS),
        Classification("20423", "Manufacture of perfumes and cosmetics", Category.SUBCLASS),
        Classification(
            "20424", "Manufacture of wax, polish and preparations for perfuming or deodorizing room", Category.SUBCLASS
        ),
        Classification("2049", "Manufacture of other chemical products n.e.c.", Category.CLASS),
        Classification(
            "20491", "Manufacture of sensitized materials and related chemical preparations", Category.SUBCLASS
        ),
        Classification("20492", "Manufacture of processed and refined salt", Category.SUBCLASS),
        Classification("20493", "Manufacture of adhesives and gelatine", Category.SUBCLASS),
        Classification("20494", "Manufacture of explosives and pyrotechnic products", Category.SUBCLASS),
        Classification("20495", "Manufacture of biofuels and related mixture", Category.SUBCLASS),
        Classification("20499", "Manufacture of other chemical products n.e.c.", Category.SUBCLASS),
        Classification("205", "Manufacture of man-made fibers", Category.GROUP),
        Classification("2050", "Manufacture of man-made fibers", Category.CLASS),
        Classification("20501", "Manufacture of synthetic fibers", Category.SUBCLASS),
        Classification("20502", "Manufacture of regenerated fibers", Category.SUBCLASS),
        Classification(
            "21", "Manufacture of pharmaceuticals, medicinal chemical and botanical products", Category.DIVISION
        ),
        Classification(
            "211", "Manufacture of medicinal chemicals, antibiotics and biological products", Category.GROUP
        ),
        Classification(
            "2110", "Manufacture of medicinal chemicals, antibiotics and biological products", Category.CLASS
        ),
        Classification("21101", "Manufacture of medicinal chemicals and antibiotics", Category.SUBCLASS),
        Classification("21102", "Manufacture of biological products", Category.SUBCLASS),
        Classification("212", "Manufacture of medicaments", Category.GROUP),
        Classification("2121", "Manufacture of finished medicaments", Category.CLASS),
        Classification("21210", "Manufacture of finished medicaments", Category.SUBCLASS),
        Classification("2122", "Manufacture of herb medicaments", Category.CLASS),
        Classification("21220", "Manufacture of herb medicaments", Category.SUBCLASS),
        Classification("2123", "Manufacture of animal medicaments", Category.CLASS),
        Classification("21230", "Manufacture of animal medicaments", Category.SUBCLASS),
        Classification("213", "Manufacture of medical supplies and related other medicaments", Category.GROUP),
        Classification("2130", "Manufacture of medical supplies and related other medicaments", Category.CLASS),
        Classification("21300", "Manufacture of medical supplies and related other medicaments", Category.SUBCLASS),
        Classification("22", "Manufacture of rubber and plastics products", Category.DIVISION),
        Classification("221", "Manufacture of rubber products", Category.GROUP),
        Classification("2211", "Production of rubber tires and tubes; retreading of rubber tires", Category.CLASS),
        Classification("22111", "Manufacture of rubber tires and tubes", Category.SUBCLASS),
        Classification("22112", "Retreading of rubber tires", Category.SUBCLASS),
        Classification("2219", "Manufacture of other rubber products", Category.CLASS),
        Classification("22191", "Manufacture of rubber packing", Category.SUBCLASS),
        Classification("22192", "Manufacture of other industrial un-vulcanized rubber products", Category.SUBCLASS),
        Classification("22193", "Manufacture of apparel and other hygienic articles of rubber", Category.SUBCLASS),
        Classification("22199", "Manufacture of other rubber products n.e.c.", Category.SUBCLASS),
        Classification("222", "Manufacture of plastics products", Category.GROUP),
        Classification("2221", "Manufacture of basic plastics products", Category.CLASS),
        Classification("22211", "Manufacture of plastic wires, bars, pipes, tubes and hoses", Category.SUBCLASS),
        Classification("22212", "Manufacture of plastic films", Category.SUBCLASS),
        Classification("22213", "Manufacture of plastic sheets and plates", Category.SUBCLASS),
        Classification("22214", "Manufacture of plastic synthetic leather", Category.SUBCLASS),
        Classification("2222", "Manufacture of builders’ ware of plastic", Category.CLASS),
        Classification("22221", "Manufacture of plastic wall and floor coverings", Category.SUBCLASS),
        Classification("22222", "Manufacture of plastic products for installation and sanitation", Category.SUBCLASS),
        Classification("22223", "Manufacture of plastic windows and doors", Category.SUBCLASS),
        Classification("22229", "Manufacture of other fabricated structural plastic products", Category.SUBCLASS),
        Classification("2223", "Manufacture of plastic articles for the packing of goods", Category.CLASS),
        Classification("22231", "Manufacture of plastic sacks, bags and similar products", Category.SUBCLASS),
        Classification("22232", "Manufacture of plastic cases, boxes and containers", Category.SUBCLASS),
        Classification("2224", "Manufacture of plastic products for fabricating of machine", Category.CLASS),
        Classification(
            "22241", "Manufacture of plastic products for fabricating of transportation fixture", Category.SUBCLASS
        ),
        Classification("22249", "Manufacture of other plastic products for fabricating of machine", Category.SUBCLASS),
        Classification("2225", "Manufacture of foamed plastic products", Category.CLASS),
        Classification("22251", "Manufacture of polystyrene foam products", Category.SUBCLASS),
        Classification("22259", "Manufacture of other foamed plastic products", Category.SUBCLASS),
        Classification("2229", "Manufacture of other plastic products", Category.CLASS),
        Classification("22291", "Manufacture of self-adhesive plastic products", Category.SUBCLASS),
        Classification(
            "22292",
            "Manufacture of plastic laminating, coating and other surface processing products",
            Category.SUBCLASS,
        ),
        Classification("22299", "Manufacture of other plastic products n.e.c.", Category.SUBCLASS),
        Classification("23", "Manufacture of other non-metallic mineral products", Category.DIVISION),
        Classification("231", "Manufacture of glass and glass products", Category.GROUP),
        Classification("2311", "Manufacture of flat glass and related products", Category.CLASS),
        Classification("23111", "Manufacture of flat glass", Category.SUBCLASS),
        Classification("23112", "Manufacture of safety glass", Category.SUBCLASS),
        Classification("23119", "Manufacture of other products made of flat glass", Category.SUBCLASS),
        Classification("2312", "Manufacture of industrial glass", Category.CLASS),
        Classification(
            "23121", "Manufacture of basic glass products, glass fibers and optical glass", Category.SUBCLASS
        ),
        Classification("23122", "Manufacture of glass products for displays", Category.SUBCLASS),
        Classification("23129", "Manufacture of other industrial glass products", Category.SUBCLASS),
        Classification("2319", "Manufacture of other glass products", Category.CLASS),
        Classification("23191", "Manufacture of household glassware", Category.SUBCLASS),
        Classification("23192", "Manufacture of bottles and other containers made of glass", Category.SUBCLASS),
        Classification("23199", "Manufacture of other glass products n.e.c.", Category.SUBCLASS),
        Classification("232", "Manufacture of refractory and non-refractory ceramic products", Category.GROUP),
        Classification("2321", "Manufacture of refractory ceramic products", Category.CLASS),
        Classification("23211", "Manufacture of shaped refractory ceramic products", Category.SUBCLASS),
        Classification("23212", "Manufacture of unshaped refractory ceramic products", Category.SUBCLASS),
        Classification("2322", "Manufacture of non-refractory porcelain and ceramic products", Category.CLASS),
        Classification("23221", "Manufacture of household or ornamental pottery and ceramic ware", Category.SUBCLASS),
        Classification("23222", "Manufacture of sanitary and industrial ceramic ware", Category.SUBCLASS),
        Classification(
            "23229", "Manufacture of other non-refractory porcelain and ceramic products", Category.SUBCLASS
        ),
        Classification("2323", "Manufacture of structural non-refractory clay and ceramic products", Category.CLASS),
        Classification(
            "23231", "Manufacture of non-refractory clay bricks, blocks and similar products", Category.SUBCLASS
        ),
        Classification("23232", "Manufacture of non-refractory ceramic tiles and similar products", Category.SUBCLASS),
        Classification(
            "23239", "Manufacture of other structural non-refractory clay and ceramic products", Category.SUBCLASS
        ),
        Classification("233", "Manufacture of cement, lime, plaster and its products", Category.GROUP),
        Classification("2331", "Manufacture of cement, lime and plaster", Category.CLASS),
        Classification("23311", "Manufacture of cement", Category.SUBCLASS),
        Classification("23312", "Manufacture of lime and plaster", Category.SUBCLASS),
        Classification(
            "2332",
            "Manufacture of articles of concrete, ready-mixed concrete and other cement and plaster products",
            Category.CLASS,
        ),
        Classification("23321", "Manufacture of non-refractory mortar", Category.SUBCLASS),
        Classification("23322", "Manufacture of ready-mixed concrete", Category.SUBCLASS),
        Classification("23323", "Manufacture of plaster products and related products", Category.SUBCLASS),
        Classification("23324", "Manufacture of concrete tiles, roofing tiles, bricks and blocks", Category.SUBCLASS),
        Classification(
            "23325", "Manufacture of concrete pipes and other structral concrete products", Category.SUBCLASS
        ),
        Classification("23329", "Manufacture of other concrete and similar products n.e.c.", Category.SUBCLASS),
        Classification("239", "Manufacture of other non-metallic mineral products", Category.GROUP),
        Classification("2391", "Cutting, shaping and finishing of stone", Category.CLASS),
        Classification("23911", "Manufacture of stone products for construction", Category.SUBCLASS),
        Classification("23919", "Manufacture of other stone products", Category.SUBCLASS),
        Classification("2399", "Manufacture of other non-metallic mineral products n.e.c.", Category.CLASS),
        Classification("23991", "Manufacture of asphalt concrete and related products", Category.SUBCLASS),
        Classification("23992", "Manufacture of abrasive articles", Category.SUBCLASS),
        Classification("23993", "Manufacture of non-metallic crushed mineral products", Category.SUBCLASS),
        Classification("23994", "Manufacture of mineral wools and other similar products", Category.SUBCLASS),
        Classification("23995", "Manufacture of carbon fibers", Category.SUBCLASS),
        Classification("23999", "Manufacture of other non-metallic minerals n.e.c.", Category.SUBCLASS),
        Classification("24", "Manufacture of basic metals", Category.DIVISION),
        Classification("241", "Manufacture of basic iron and steel", Category.GROUP),
        Classification("2411", "Manufacture of basic iron, steel and ferro-alloys", Category.CLASS),
        Classification("24111", "Manufacture of basic iron", Category.SUBCLASS),
        Classification("24112", "Manufacture of basic steel", Category.SUBCLASS),
        Classification("24113", "Manufacture of ferro-alloys", Category.SUBCLASS),
        Classification("24119", "Manufacture of other basic iron and steel", Category.SUBCLASS),
        Classification("2412", "Manufacture of steel products by rolling, extrusion and drawing", Category.CLASS),
        Classification(
            "24121", "Manufacture of steel products by hot rolling, hot extrusion and hot drawing", Category.SUBCLASS
        ),
        Classification(
            "24122", "Manufacture of steel products by cold rolling, cold extrusion and cold drawing", Category.SUBCLASS
        ),
        Classification("24123", "Manufacture of steel wire", Category.SUBCLASS),
        Classification("2413", "Manufacture of pipes, tubes and hollow profiles, of iron or steel", Category.CLASS),
        Classification("24131", "Manufacture of tubes and pipes, of cast iron", Category.SUBCLASS),
        Classification("24132", "Manufacture of pipes and tubes, of steel", Category.SUBCLASS),
        Classification(
            "24133", "Manufacture of pipe and tube fittings and related products, of steel", Category.SUBCLASS
        ),
        Classification("2419", "Manufacture of other basic iron and steel", Category.CLASS),
        Classification(
            "24191", "Manufacture of coated, plated, coloured and other processed steel products", Category.SUBCLASS
        ),
        Classification("24199", "Manufacture of other basic iron and steel n.e.c.", Category.SUBCLASS),
        Classification("242", "Manufacture of basic precious and non-ferrous metals", Category.GROUP),
        Classification("2421", "Manufacture of smelting, refining and alloys of non-ferrous metals", Category.CLASS),
        Classification("24211", "Manufacture of smelting, refining and alloys of copper", Category.SUBCLASS),
        Classification("24212", "Manufacture of smelting, refining and alloys of aluminum", Category.SUBCLASS),
        Classification("24213", "Manufacture of smelting, refining and alloys of lead and zinc", Category.SUBCLASS),
        Classification(
            "24219", "Manufacture of smelting, refining and alloys of other non-ferrous metals", Category.SUBCLASS
        ),
        Classification(
            "2422", "Manufacture of non-ferrous metal products by rolling, extrusion and drawing", Category.CLASS
        ),
        Classification("24221", "Manufacture of copper products by rolling, extrusion and drawing", Category.SUBCLASS),
        Classification(
            "24222", "Manufacture of aluminum products by rolling, extrusion and drawing", Category.SUBCLASS
        ),
        Classification(
            "24229",
            "Manufacture of other non-ferrous metal products by rolling, extrusion and drawing",
            Category.SUBCLASS,
        ),
        Classification("2429", "Manufacture of other basic precious and non-ferrous metals", Category.CLASS),
        Classification("24290", "Manufacture of other basic precious and non-ferrous metals", Category.SUBCLASS),
        Classification("243", "Casting of metals", Category.GROUP),
        Classification("2431", "Casting of iron and steel", Category.CLASS),
        Classification("24311", "Casting of pig iron", Category.SUBCLASS),
        Classification("24312", "Casting of steel", Category.SUBCLASS),
        Classification("2432", "Casting of non-ferrous metals", Category.CLASS),
        Classification("24321", "Casting of aluminum", Category.SUBCLASS),
        Classification("24322", "Casting of copper", Category.SUBCLASS),
        Classification("24329", "Casting of other non-ferrous metals", Category.SUBCLASS),
        Classification(
            "25", "Manufacture of fabricated metal products, except machinery and furniture", Category.DIVISION
        ),
        Classification(
            "251", "Manufacture of structural metal products, tanks, reservoirs and steam generators", Category.GROUP
        ),
        Classification("2511", "Manufacture of structural metal products", Category.CLASS),
        Classification(
            "25111", "Manufacture of metal doors, windows, shutters and related products", Category.SUBCLASS
        ),
        Classification(
            "25112",
            "Manufacture of structural metal sheet products and metal works used on building",
            Category.SUBCLASS,
        ),
        Classification(
            "25113",
            "Manufacture of metal frameworks or skeletons for land structure and parts thereof",
            Category.SUBCLASS,
        ),
        Classification(
            "25114",
            "Manufacture of metal frameworks or skeletons for marine structure and parts thereof",
            Category.SUBCLASS,
        ),
        Classification("25119", "Manufacture of other structural metal products", Category.SUBCLASS),
        Classification(
            "2512",
            "Manufacture of industrial heating boilers, tanks, reservoirs and containers of metals",
            Category.CLASS,
        ),
        Classification("25121", "Manufacture of industrial heating boilers and radiators", Category.SUBCLASS),
        Classification("25122", "Manufacture of tanks and reservoirs", Category.SUBCLASS),
        Classification(
            "25123", "Manufacture of of metal containers for compressed or liquefied gas", Category.SUBCLASS
        ),
        Classification("2513", "Manufacture of nuclear reactors and steam generators", Category.CLASS),
        Classification("25130", "Manufacture of nuclear reactors and steam generators", Category.SUBCLASS),
        Classification("252", "Manufacture of weapons and ammunition", Category.GROUP),
        Classification("2520", "Manufacture of weapons and ammunition", Category.CLASS),
        Classification("25200", "Manufacture of weapons and ammunition", Category.SUBCLASS),
        Classification(
            "259", "Manufacture of other fabricated metal products; metalworking service activities", Category.GROUP
        ),
        Classification(
            "2591", "Forging, pressing, stamping and roll-forming of metal; powder metallurgy", Category.CLASS
        ),
        Classification("25911", "Manufacture of powder metallurgic products", Category.SUBCLASS),
        Classification("25912", "Manufacture of forging products", Category.SUBCLASS),
        Classification("25913", "Manufacture of pressing products for motor vehicles", Category.SUBCLASS),
        Classification("25914", "Manufacture of other pressing products", Category.SUBCLASS),
        Classification("2592", "Treatment and coating of metals; machining", Category.CLASS),
        Classification("25921", "Heat treatment of metals", Category.SUBCLASS),
        Classification("25922", "Plating of metals", Category.SUBCLASS),
        Classification("25923", "Coating and similar treatment of metals", Category.SUBCLASS),
        Classification("25924", "Engraving, cutting and similar processing of metals", Category.SUBCLASS),
        Classification("25929", "Other metalworking n.e.c.", Category.SUBCLASS),
        Classification("2593", "Manufacture of cutlery, hand tools and general hardware", Category.CLASS),
        Classification("25931", "Manufacture of cutlery", Category.SUBCLASS),
        Classification("25932", "Manufacture of general hardware", Category.SUBCLASS),
        Classification("25933", "Manufacture of non-power-driven hand tools", Category.SUBCLASS),
        Classification("25934", "Manufacture of saws, saw blades and interchangeable tools", Category.SUBCLASS),
        Classification(
            "2594", "Manufacture of metal fasteners, springs and articles made of metal wires", Category.CLASS
        ),
        Classification("25941", "Manufacture of bolts and screws", Category.SUBCLASS),
        Classification("25942", "Manufacture of other metal fasteners and screw products", Category.SUBCLASS),
        Classification("25943", "Manufacture of metal springs", Category.SUBCLASS),
        Classification("25944", "Manufacture of articles made of metal wires", Category.SUBCLASS),
        Classification("2599", "Manufacture of other febricated metal products", Category.CLASS),
        Classification("25991", "Manufacture of metal cans and other containers", Category.SUBCLASS),
        Classification("25992", "Manufacture of hand-operated kitchen appliances and metal ware", Category.SUBCLASS),
        Classification("25993", "Manufacture of metal sanitary ware", Category.SUBCLASS),
        Classification("25994", "Manufacture of metal sign boards including road signs", Category.SUBCLASS),
        Classification(
            "25995",
            "Manufacture of coated rods and cored wire, of base metal for soldering or welding",
            Category.SUBCLASS,
        ),
        Classification(
            "25999", "Manufacture of other febricated and processed metal products n.e.c", Category.SUBCLASS
        ),
        Classification(
            "26",
            "Manufacture of electronic components, computer; visual, sounding and communication equipment",
            Category.DIVISION,
        ),
        Classification("261", "Manufacture of semiconductor", Category.GROUP),
        Classification("2611", "Manufacture of electronic integrated circuits", Category.CLASS),
        Classification("26111", "Manufacture of memory electronic integrated circuits", Category.SUBCLASS),
        Classification("26112", "Manufacture of non-memory electronic integrated circuits", Category.SUBCLASS),
        Classification("2612", "Manufacture of diodes, transistors and similar semi-conductor devices", Category.CLASS),
        Classification("26121", "Manufacture of light emitting diodes", Category.SUBCLASS),
        Classification(
            "26129", "Manufacture of other diodes, transistors and similar semi-conductor devices", Category.SUBCLASS
        ),
        Classification("262", "Manufacture of electronic components", Category.GROUP),
        Classification("2621", "Manufacture of flat display components", Category.CLASS),
        Classification("26211", "Manufacture of liquid crystal display components", Category.SUBCLASS),
        Classification("26212", "Manufacture of organic light emitting diodes display components", Category.SUBCLASS),
        Classification("26219", "Manufacture of other display component", Category.SUBCLASS),
        Classification(
            "2622",
            "Manufacture of bare printed circuit boards and loading of electronic components onto pcb",
            Category.CLASS,
        ),
        Classification("26221", "Manufacture of laminated plates for printed circuit boards", Category.SUBCLASS),
        Classification("26222", "Manufacture of rigid printed circuit boards", Category.SUBCLASS),
        Classification("26223", "Manufacture of flexible and other printed circuit boards", Category.SUBCLASS),
        Classification("26224", "Manufacture of loading of electronic components onto PCB", Category.SUBCLASS),
        Classification(
            "2629",
            "Manufacture of other electronic components, except semiconductor and electronic integrated circuits",
            Category.CLASS,
        ),
        Classification("26291", "Manufacture of electronic capacitors", Category.SUBCLASS),
        Classification("26292", "Manufacture of electronic resistors", Category.SUBCLASS),
        Classification("26293", "Manufacture of smart cards with magnetic stripe or chip", Category.SUBCLASS),
        Classification("26294", "Manufacture of electronic coils, transformers and other inductors", Category.SUBCLASS),
        Classification("26295", "Manufacture of electronic perception sensors", Category.SUBCLASS),
        Classification(
            "26299",
            "Manufacture of electronic tubes, interface cards and other electronic components n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("263", "Manufacture of computers and peripheral equipment", Category.GROUP),
        Classification("2631", "Manufacture of computer", Category.CLASS),
        Classification("26310", "Manufacture of computer", Category.SUBCLASS),
        Classification("2632", "Manufacture of storage devices and peripheral equipment", Category.CLASS),
        Classification("26321", "Manufacture of storage devices", Category.SUBCLASS),
        Classification("26322", "Manufacture of computer monitor", Category.SUBCLASS),
        Classification("26323", "Manufacture of computer printer", Category.SUBCLASS),
        Classification("26329", "Manufacture of other peripheral apparatuses", Category.SUBCLASS),
        Classification("264", "Manufacture of communication and broadcasting apparatuses", Category.GROUP),
        Classification("2641", "Manufacture of wire communication apparatuses", Category.CLASS),
        Classification("26410", "Manufacture of wire telecommunication apparatuses", Category.SUBCLASS),
        Classification("2642", "Manufacture of broadcasting and wireless communication apparatuses", Category.CLASS),
        Classification("26421", "Manufacture of broadcasting apparatuses", Category.SUBCLASS),
        Classification("26422", "Manufacture of mobile phone", Category.SUBCLASS),
        Classification("26429", "Manufacture of other wireless communication apparatuses", Category.SUBCLASS),
        Classification("265", "Manufacture of electronic video and audio equipment", Category.GROUP),
        Classification("2651", "Manufacture of television, video and other visual equipment", Category.CLASS),
        Classification("26511", "Manufacture of television", Category.SUBCLASS),
        Classification("26519", "Manufacture of video and other visual equipment", Category.SUBCLASS),
        Classification("2652", "Manufacture of audio, speaker and other sounding equipment", Category.CLASS),
        Classification("26521", "Manufacture of radio, recorder and reproducing apparatuses", Category.SUBCLASS),
        Classification("26529", "Manufacture of other sounding equipment", Category.SUBCLASS),
        Classification("266", "Manufacture of magnetic and optical medium", Category.GROUP),
        Classification("2660", "Manufacture of magnetic and optical medium", Category.CLASS),
        Classification("26600", "Manufacture of magnetic and optical medium", Category.SUBCLASS),
        Classification(
            "27", "Manufacture of medical, precision and optical instruments, watches and clocks", Category.DIVISION
        ),
        Classification("271", "Manufacture of medical and dental instruments and supplies", Category.GROUP),
        Classification("2711", "Manufacture of irradiation and electro-diagnostic apparatuses", Category.CLASS),
        Classification("27111", "Manufacture of irradiation apparatuses", Category.SUBCLASS),
        Classification(
            "27112", "Manufacture of electro-diagnostic and electro-therapeutic apparatuses", Category.SUBCLASS
        ),
        Classification(
            "2719", "Manufacture of other medical and surgical equipment and orthopedic appliances", Category.CLASS
        ),
        Classification("27191", "Manufacture of dental instruments and appliances", Category.SUBCLASS),
        Classification(
            "27192",
            "Manufacture of orthopedic, orthodontic, prosthetic appliances and supplies for disability",
            Category.SUBCLASS,
        ),
        Classification("27193", "Manufacture of eyeglasses and optical lenses", Category.SUBCLASS),
        Classification("27194", "Manufacture of medical, surgical, dental or veterinary furniture", Category.SUBCLASS),
        Classification(
            "27199",
            "Manufacture of other medical and surgical equipment and orthopedic appliances n.e.c.",
            Category.SUBCLASS,
        ),
        Classification(
            "272",
            "Manufacture of measuring, testing, navigating and control equipment; except optical instruments",
            Category.GROUP,
        ),
        Classification(
            "2721",
            "Manufacture of measuring, testing, navigating, control and other precision instrumensts",
            Category.CLASS,
        ),
        Classification(
            "27211",
            "Manufacture of radar, navigation, aeronautical, nautical equipment; measuring and recording equipment",
            Category.SUBCLASS,
        ),
        Classification(
            "27212",
            "Manufacture of instruments for measuring and testing electricity and electrical signals",
            Category.SUBCLASS,
        ),
        Classification(
            "27213", "Manufacture of physical properties testing, measuring and inspection equipment", Category.SUBCLASS
        ),
        Classification("27214", "Manufacture of speedometers and integrating meters", Category.SUBCLASS),
        Classification(
            "27215", "Manufacture of environmental controls and automatic controls for appliances", Category.SUBCLASS
        ),
        Classification("27216", "Manufacture of industrial process control equipment", Category.SUBCLASS),
        Classification(
            "27219",
            "Manufacture of other measuring, testing, navigating, control instrumensts n.e.c.",
            Category.SUBCLASS,
        ),
        Classification("273", "Manufacture of photographic equipment and optical instruments", Category.GROUP),
        Classification("2730", "Manufacture of photographic equipment and optical instruments", Category.CLASS),
        Classification("27301", "Manufacture of optical lens and elements", Category.SUBCLASS),
        Classification("27302", "Manufacture of cameras, projectors and related equipment", Category.SUBCLASS),
        Classification(
            "27309", "Manufacture of other optical instruments and photographic equipment", Category.SUBCLASS
        ),
        Classification("274", "Manufacture of watches, clocks and its parts", Category.GROUP),
        Classification("2740", "Manufacture of watches, clocks and its parts", Category.CLASS),
        Classification("27400", "Manufacture of watches, clocks and its parts", Category.SUBCLASS),
        Classification("28", "Manufacture of electrical equipment", Category.DIVISION),
        Classification(
            "281",
            "Manufacture of electric motors, generators, transformers and electricity distribution and control apparatus",
            Category.GROUP,
        ),
        Classification("2811", "Manufacture of electric motors, generators and transformers", Category.CLASS),
        Classification("28111", "Manufacture of electric motors and generators", Category.SUBCLASS),
        Classification("28112", "Manufacture of transformers", Category.SUBCLASS),
        Classification("28113", "Manufacture of ballasts for lamps", Category.SUBCLASS),
        Classification("28114", "Manufacture of energy storage system", Category.SUBCLASS),
        Classification("28119", "Manufacture of other electric motors, generators and transformers", Category.SUBCLASS),
        Classification("2812", "Manufacture of electricity distribution and control apparatuses", Category.CLASS),
        Classification(
            "28121",
            "Manufacture of apparatuses for switching, protecting electrical circuits used in power distribution systems",
            Category.SUBCLASS,
        ),
        Classification(
            "28122",
            "Manufacture of apparatuses for connecting electrical circuits used in power distribution systems",
            Category.SUBCLASS,
        ),
        Classification("28123", "Manufacture of boards for electric control or distribution", Category.SUBCLASS),
        Classification("282", "Manufacture of batteries and accumulators", Category.GROUP),
        Classification("2820", "Manufacture of batteries and accumulators", Category.CLASS),
        Classification("28201", "Manufacture of batteries", Category.SUBCLASS),
        Classification("28202", "Manufacture of accumulators", Category.SUBCLASS),
        Classification("283", "Manufacture of insulated wires and cables", Category.GROUP),
        Classification("2830", "Manufacture of insulated wires and cables", Category.CLASS),
        Classification("28301", "Manufacture of optical fiber cables", Category.SUBCLASS),
        Classification("28302", "Manufacture of other insulated wires and cables", Category.SUBCLASS),
        Classification(
            "28303", "Manufacture of insulated codes sets and other conductors for electricity", Category.SUBCLASS
        ),
        Classification("284", "Manufacture of electric tubes and bulbs and lighting equipment", Category.GROUP),
        Classification("2841", "Manufacture of electric lamps and bulbs", Category.CLASS),
        Classification("28410", "Manufacture of electric lamps and bulbs", Category.SUBCLASS),
        Classification("2842", "Manufacture of lighting fixtures", Category.CLASS),
        Classification(
            "28421", "Manufacture of electric lighting fixtures for transportation equipment", Category.SUBCLASS
        ),
        Classification("28422", "Manufacture of general electric lighting fixtures", Category.SUBCLASS),
        Classification(
            "28423", "Manufacture of electric lighting fixtures for exhibition and advertisement", Category.SUBCLASS
        ),
        Classification("28429", "Manufacture of other lighting fixtures", Category.SUBCLASS),
        Classification("285", "Manufacture of domestic appliances", Category.GROUP),
        Classification("2851", "Manufacture of domestic electric appliances", Category.CLASS),
        Classification("28511", "Manufacture of electric appliances for kitchen", Category.SUBCLASS),
        Classification("28512", "Manufacture of of domestic electrothermic appliances", Category.SUBCLASS),
        Classification("28519", "Manufacture of other domestic electric appliances", Category.SUBCLASS),
        Classification("2852", "Manufacture of domestic non-electric cooking and heating appliances", Category.CLASS),
        Classification(
            "28520", "Manufacture of domestic non-electric cooking and heating appliances", Category.SUBCLASS
        ),
        Classification("289", "Manufacture of other electrical equipment", Category.GROUP),
        Classification("2890", "Manufacture of other electrical equipment", Category.CLASS),
        Classification("28901", "Manufacture of electric alarm and signalling equipment", Category.SUBCLASS),
        Classification("28902", "Manufacture of electrical carbon products and insulators", Category.SUBCLASS),
        Classification("28903", "Manufacture of traffic signalling equipment", Category.SUBCLASS),
        Classification("28909", "Manufacture of other electrical equipment n.e.c.", Category.SUBCLASS),
        Classification("29", "Manufacture of other machinery and equipment", Category.DIVISION),
        Classification("291", "Manufacture of general purpose machinery", Category.GROUP),
        Classification(
            "2911",
            "Manufacture of internal combustion piston engines and turbines, except aircraft, vehicle and cycle propulsion engines",
            Category.CLASS,
        ),
        Classification("29111", "Manufacture of internal combustion piston engines", Category.SUBCLASS),
        Classification("29119", "Manufacture of other engines and turbines", Category.SUBCLASS),
        Classification("2912", "Manufacture of fluid power equipment", Category.CLASS),
        Classification("29120", "Manufacture of fluid power equipment", Category.SUBCLASS),
        Classification(
            "2913", "Manufacture of pumps and compressors including taps, valves and similar products", Category.CLASS
        ),
        Classification("29131", "Manufacture of pumps for liquids", Category.SUBCLASS),
        Classification("29132", "Manufacture of air or vacuum pumps and compressors", Category.SUBCLASS),
        Classification("29133", "Manufacture of taps, valves and similar products", Category.SUBCLASS),
        Classification("2914", "Manufacture of bearings, gears and driving elements", Category.CLASS),
        Classification("29141", "Manufacture of ball and roller bearings", Category.SUBCLASS),
        Classification("29142", "Manufacture of gears and driving elements", Category.SUBCLASS),
        Classification("2915", "Manufacture of industrial ovens, furnaces and furnace burners", Category.CLASS),
        Classification("29150", "Manufacture of industrial ovens, furnaces and furnace burners", Category.SUBCLASS),
        Classification("2916", "Manufacture of work trucks, lifting and handling equipment", Category.CLASS),
        Classification("29161", "Manufacture of work trucks and loading or unloading machinery", Category.SUBCLASS),
        Classification("29162", "Manufacture of lifting equipment", Category.SUBCLASS),
        Classification("29163", "Manufacture of conveyors", Category.SUBCLASS),
        Classification("29169", "Manufacture of other lifting and handling equipment", Category.SUBCLASS),
        Classification(
            "2917",
            "Manufacture of refrigerating, air conditioning, filtering, distilling equipment and gas generators",
            Category.CLASS,
        ),
        Classification("29171", "Manufacture of refrigerating or freezing industrial equipment", Category.SUBCLASS),
        Classification("29172", "Manufacture of air conditioning and control machines", Category.SUBCLASS),
        Classification("29173", "Manufacture of non-domestic fans and ventilators", Category.SUBCLASS),
        Classification("29174", "Manufacture of filtering or purifying machinery for air or gases", Category.SUBCLASS),
        Classification(
            "29175", "Manufacture of filtering or purifying machinery for liquids or oils", Category.SUBCLASS
        ),
        Classification(
            "29176", "Manufacture of distilling machinery, heat exchangers and gas generators", Category.SUBCLASS
        ),
        Classification("2918", "Manufacture of office machinery and equipment", Category.CLASS),
        Classification("29180", "Manufacture of office machinery and equipment", Category.SUBCLASS),
        Classification("2919", "Manufacture of other general-purpose machinery", Category.CLASS),
        Classification("29191", "Manufacture of general weighing machinery", Category.SUBCLASS),
        Classification("29192", "Manufacture of machinery for cleaning, packing and charging", Category.SUBCLASS),
        Classification(
            "29193",
            "Manufacture of equipment for projecting, dispersing or spraying liquids or powders",
            Category.SUBCLASS,
        ),
        Classification("29194", "Manufacture of power-driven hand tools", Category.SUBCLASS),
        Classification("29199", "Manufacture of other general-purpose machinery n.e.c.", Category.SUBCLASS),
        Classification("292", "Manufacture of special-purpose machinery", Category.GROUP),
        Classification("2921", "Manufacture of agricultural and forestry machinery", Category.CLASS),
        Classification("29210", "Manufacture of agricultural and forestry machinery", Category.SUBCLASS),
        Classification("2922", "Manufacture of metal forming machinery and machine tools", Category.CLASS),
        Classification(
            "29221", "Manufacture of cutting machinery using a laser beam, ultrasonic waves", Category.SUBCLASS
        ),
        Classification(
            "29222", "Manufacture of forming machiney for digital additive manufacturing", Category.SUBCLASS
        ),
        Classification("29223", "Manufacture of metal cutting machinery", Category.SUBCLASS),
        Classification("29224", "Manufacture of metal shaping machinery", Category.SUBCLASS),
        Classification("29229", "Manufacture of other forming machinery and machine tools", Category.SUBCLASS),
        Classification("2923", "Manufacture of machinery for metal casting and other metallurgy", Category.CLASS),
        Classification("29230", "Manufacture of machinery for metal casting and other metallurgy", Category.SUBCLASS),
        Classification("2924", "Manufacture of machinery for mining, quarrying and construction", Category.CLASS),
        Classification("29241", "Manufacture of machinery for mining, quarrying and construction", Category.SUBCLASS),
        Classification("29242", "Manufacture of machinery for treating minerals", Category.SUBCLASS),
        Classification("2925", "Manufacture of machinery for food, beverage and tobacco processing", Category.CLASS),
        Classification(
            "29250", "Manufacture of machinery for food, beverage and tobacco processing", Category.SUBCLASS
        ),
        Classification("2926", "Manufacture of machinery for textile, apparel and leather production", Category.CLASS),
        Classification(
            "29261",
            "Manufacture of industrial machinery for washing, dyeing, finishing and processing of textile",
            Category.SUBCLASS,
        ),
        Classification(
            "29269", "Manufacture of other machinery for textiles, apparel and leather processing", Category.SUBCLASS
        ),
        Classification(
            "2927", "Manufacture of semi-conductor and display component manufacturing machinery", Category.CLASS
        ),
        Classification("29271", "Manufacture of semi-conductor manufacturing machinery", Category.SUBCLASS),
        Classification("29272", "Manufacture of display component manufacturing machinery", Category.SUBCLASS),
        Classification("2928", "Manufacture of industrial robots", Category.CLASS),
        Classification("29280", "Manufacture of industrial robots", Category.SUBCLASS),
        Classification("2929", "Manufacture of other special purpose machinery", Category.CLASS),
        Classification("29291", "Manufacture of machinery for pulp and paper processing", Category.SUBCLASS),
        Classification(
            "29292", "Manufacture of machinery for rubber, man-made fiber and plastics processing", Category.SUBCLASS
        ),
        Classification("29293", "Manufacture of machinery for printing and bookbinding", Category.SUBCLASS),
        Classification("29294", "Manufacture of mould and metallic patterns", Category.SUBCLASS),
        Classification("29299", "Manufacture of other special purpose machinery, n.e.c.", Category.SUBCLASS),
        Classification("30", "Manufacture of motor vehicles, trailers and semitrailers", Category.DIVISION),
        Classification("301", "Manufacture of motor vehicles and engines for motor vehicles", Category.GROUP),
        Classification("3011", "Manufacture of engines for motor vehicles", Category.CLASS),
        Classification("30110", "Manufacture of engines for motor vehicles", Category.SUBCLASS),
        Classification("3012", "Manufacture of motor vehicles", Category.CLASS),
        Classification("30121", "Manufacture of passenger motor vehicles", Category.SUBCLASS),
        Classification(
            "30122",
            "Manufacture of truck and motor vehicles for transportation of goods and special purpose",
            Category.SUBCLASS,
        ),
        Classification(
            "302", "Manufacture of bodies for motor vehicles; manufacture of trailers and semi-trailers", Category.GROUP
        ),
        Classification(
            "3020",
            "Manufacture of bodies for motor vehicles; manufacture of trailers and semi-trailers",
            Category.CLASS,
        ),
        Classification(
            "30201",
            "Manufacture of motor vehicle bodies and motor vehicles assembled on purchased chassis",
            Category.SUBCLASS,
        ),
        Classification("30202", "Modification of structure and devices of a motor vehicles", Category.SUBCLASS),
        Classification("30203", "Manufacture of trailers and semi-trailers", Category.SUBCLASS),
        Classification("303", "Manufacture of parts and accessories for motor vehicles(new products)", Category.GROUP),
        Classification("3031", "Manufacture of parts and accessories for motor engines(new products)", Category.CLASS),
        Classification(
            "30310", "Manufacture of parts and accessories for motor engines(new products)", Category.SUBCLASS
        ),
        Classification(
            "3032", "Manufacture of parts and accessories for motor vehicle body(new products)", Category.CLASS
        ),
        Classification(
            "30320", "Manufacture of parts and accessories for motor vehicle body(new products)", Category.SUBCLASS
        ),
        Classification(
            "3033",
            "Manufacture of power transmission devices and electrical and electronic equipment for motor vehicles(new products)",
            Category.CLASS,
        ),
        Classification(
            "30331", "Manufacture of power transmission devices for motor vehicles(new products)", Category.SUBCLASS
        ),
        Classification(
            "30332", "Manufacture of electronic equipment for motor vehicles(new products)", Category.SUBCLASS
        ),
        Classification(
            "3039", "Manufacture of other parts and accessories for motor vehicles(new products)", Category.CLASS
        ),
        Classification(
            "30391",
            "Manufacture of steering and suspension devices for motor vehicles(new products)",
            Category.SUBCLASS,
        ),
        Classification("30392", "Manufacture of damping devices for motor vehicles(new products)", Category.SUBCLASS),
        Classification("30393", "Manufacture of seats for motor vehicles(new products)", Category.SUBCLASS),
        Classification(
            "30399", "Manufacture of other new parts and accessories for motor vehicles n.e.c.", Category.SUBCLASS
        ),
        Classification(
            "304", "Manufacture of parts and accessories for motor vehicles(remanufacturing products)", Category.GROUP
        ),
        Classification(
            "3040", "Manufacture of parts and accessories for motor vehicles(remanufacturing products)", Category.CLASS
        ),
        Classification(
            "30400",
            "Manufacture of parts and accessories for motor vehicles(remanufacturing products)",
            Category.SUBCLASS,
        ),
        Classification("31", "Manufacture of other transport equipment", Category.DIVISION),
        Classification("311", "Building of ships and boats", Category.GROUP),
        Classification("3111", "Building of ships and floating structures", Category.CLASS),
        Classification("31111", "Building of steel ships", Category.SUBCLASS),
        Classification("31112", "Building of synthetic resin ships", Category.SUBCLASS),
        Classification("31113", "Building of non-ferrous metal ships and other ships", Category.SUBCLASS),
        Classification("31114", "Manufacture of sections for ships", Category.SUBCLASS),
        Classification("3112", "Building of pleasure and sporting boats", Category.CLASS),
        Classification("31120", "Building of pleasure and sporting boats", Category.SUBCLASS),
        Classification("312", "Manufacture of railway locomotives and rolling stock", Category.GROUP),
        Classification("3120", "Manufacture of railway locomotives and rolling stock", Category.CLASS),
        Classification("31201", "Manufacture of rail locomotives and rolling stock", Category.SUBCLASS),
        Classification(
            "31202",
            "Manufacture of specialized parts of railway or tramway locomotives or of rolling stock",
            Category.SUBCLASS,
        ),
        Classification("313", "Manufacture of aircraft, spacecraft and its parts", Category.GROUP),
        Classification("3131", "Manufacture of aircraft, spacecraft and its assistant equipment", Category.CLASS),
        Classification(
            "31311", "Manufacture of manned aircraft, spacecraft and its assistant equipment", Category.SUBCLASS
        ),
        Classification("31312", "Manufacture of unmanned aircraft and its assistant equipment", Category.SUBCLASS),
        Classification("3132", "Manufacture of engines and parts for aircraft", Category.CLASS),
        Classification("31321", "Manufacture of engines for aircraft", Category.SUBCLASS),
        Classification("31322", "Manufacture of aircraft parts and accessories", Category.SUBCLASS),
        Classification("319", "Manufacture of other transport equipment", Category.GROUP),
        Classification("3191", "Manufacture of military fighting vehicles", Category.CLASS),
        Classification("31910", "Manufacture of military fighting vehicles", Category.SUBCLASS),
        Classification("3192", "Manufacture of motorcycles", Category.CLASS),
        Classification("31920", "Manufacture of motorcycles", Category.SUBCLASS),
        Classification("3199", "Manufacture of other transport equipment n.e.c.", Category.CLASS),
        Classification("31991", "Manufacture of bicycles and invalid carriages", Category.SUBCLASS),
        Classification("31999", "Manufacture of other transport equipment n.e.c.", Category.SUBCLASS),
        Classification("32", "Manufacture of furniture", Category.DIVISION),
        Classification("320", "Manufacture of furniture", Category.GROUP),
        Classification("3201", "Manufacture of beds and upholstered furniture", Category.CLASS),
        Classification("32011", "Manufacture of mattresses and beds", Category.SUBCLASS),
        Classification("32019", "Manufacture of sofas and other upholstered furniture", Category.SUBCLASS),
        Classification("3202", "Manufacture of wood furniture", Category.CLASS),
        Classification("32021", "Manufacture of wood furniture for kitchen and restaurant", Category.SUBCLASS),
        Classification("32029", "Manufacture of other wood furniture", Category.SUBCLASS),
        Classification("3209", "Manufacture of other furniture", Category.CLASS),
        Classification("32091", "Manufacture of metal furniture", Category.SUBCLASS),
        Classification("32099", "Manufacture of other furniture n.e.c.", Category.SUBCLASS),
        Classification("33", "Other manufacturing", Category.DIVISION),
        Classification("331", "Manufacture of jewellery, bijouterie and related articles", Category.GROUP),
        Classification("3311", "Manufacture of jewellery and related articles", Category.CLASS),
        Classification("33110", "Manufacture of jewellery and related articles", Category.SUBCLASS),
        Classification("3312", "Manufacture of imitation jewellery and costume jewellery", Category.CLASS),
        Classification("33120", "Manufacture of imitation jewellery and costume jewellery", Category.SUBCLASS),
        Classification("332", "Manufacture of musical instruments", Category.GROUP),
        Classification("3320", "Manufacture of musical instruments", Category.CLASS),
        Classification("33201", "Manufacture of keyboard instruments", Category.SUBCLASS),
        Classification("33202", "Manufacture of electronic instruments", Category.SUBCLASS),
        Classification("33209", "Manufacture of other musical instruments", Category.SUBCLASS),
        Classification("333", "Manufacture of sports and athletic goods", Category.GROUP),
        Classification("3330", "Manufacture of sports and athletic goods", Category.CLASS),
        Classification("33301", "Manufacture of athletics, gymnastics, fitness equipment", Category.SUBCLASS),
        Classification("33302", "Manufacture of playground equipment", Category.SUBCLASS),
        Classification("33303", "Manufacture of fishing and hunting equipment", Category.SUBCLASS),
        Classification("33309", "Manufacture of other sports and athletic goods", Category.SUBCLASS),
        Classification("334", "Manufacture of dolls, toys and amusement goods", Category.GROUP),
        Classification("3340", "Manufacture of dolls, toys and amusement goods", Category.CLASS),
        Classification("33401", "Manufacture of dolls and toys", Category.SUBCLASS),
        Classification("33402", "Manufacture of video game machines", Category.SUBCLASS),
        Classification("33409", "Manufacture of other amusement goods", Category.SUBCLASS),
        Classification("339", "Other manufacturing n.e.c.", Category.GROUP),
        Classification("3391", "Manufacture of signs and advertisements", Category.CLASS),
        Classification("33910", "Manufacture of signs and advertisements", Category.SUBCLASS),
        Classification("3392", "Manufacture of stationery and artists' goods", Category.CLASS),
        Classification("33920", "Manufacture of stationery and artists' goods", Category.SUBCLASS),
        Classification("3393", "Manufacture of wigs, ornaments and mockups", Category.CLASS),
        Classification("33931", "Manufacture of wigs and similar articles", Category.SUBCLASS),
        Classification("33932", "Manufacture of exhibiting models", Category.SUBCLASS),
        Classification("33933", "Mounting pictures and other arts", Category.SUBCLASS),
        Classification("3399", "Other manufacturing n.e.c.", Category.CLASS),
        Classification("33991", "Manufacture of buttons and snaps, slides and similar fasteners", Category.SUBCLASS),
        Classification(
            "33992", "Manufacture of lighters, combustible materials and smoking supplies", Category.SUBCLASS
        ),
        Classification("33993", "Manufacture of brushes and brooms", Category.SUBCLASS),
        Classification("33999", "Other manufacturing n.e.c.", Category.SUBCLASS),
        Classification(
            "34", "Maintenance and repair services of industrial machinery and equipment", Category.DIVISION
        ),
        Classification("340", "Maintenance and repair services of industrial machinery and equipment", Category.GROUP),
        Classification("3401", "Maintenance and repair services of general machinery and equipment", Category.CLASS),
        Classification(
            "34011",
            "Maintenance and repair services of machinery and equipment for mining and construction",
            Category.SUBCLASS,
        ),
        Classification("34019", "Maintenance and repair services of other general machinery", Category.SUBCLASS),
        Classification(
            "3402", "Maintenance and repair services of electrical, electronic and precision equipment", Category.CLASS
        ),
        Classification(
            "34020",
            "Maintenance and repair services of electrical, electronic and precision equipment",
            Category.SUBCLASS,
        ),
        Classification("D", "Electricity, gas, steam and air conditioning supply", Category.SECTION),
        Classification("35", "Electricity, gas, steam and air conditioning supply", Category.DIVISION),
        Classification("351", "Electric power generation, transmission and distribution", Category.GROUP),
        Classification("3511", "Electric power generation", Category.CLASS),
        Classification("35111", "Nuclear power generation", Category.SUBCLASS),
        Classification("35112", "Hydroelectric power generation", Category.SUBCLASS),
        Classification("35113", "Thermal power generation", Category.SUBCLASS),
        Classification("35114", "Solar and sunlight power generation", Category.SUBCLASS),
        Classification("35119", "Other power generation", Category.SUBCLASS),
        Classification("3512", "Electric power transmission and distribution", Category.CLASS),
        Classification("35120", "Electric power transmission and distribution", Category.SUBCLASS),
        Classification("3513", "Trade of electricity", Category.CLASS),
        Classification("35130", "Trade of electricity", Category.SUBCLASS),
        Classification("352", "Manufacture of gas; distribution of gaseous fuel through mains", Category.GROUP),
        Classification("3520", "Manufacture of gas; distribution of gaseous fuel through mains", Category.CLASS),
        Classification("35200", "Manufacture of gas; distribution of gaseous fuel through mains", Category.SUBCLASS),
        Classification("353", "Steam, chilled or hot water and air conditioning supply", Category.GROUP),
        Classification("3530", "Steam, chilled or hot water and air conditioning supply", Category.CLASS),
        Classification("35300", "Steam, chilled or hot water and air conditioning supply", Category.SUBCLASS),
        Classification("E", "Water supply; sewage, waste management, materials recovery", Category.SECTION),
        Classification("36", "Water supply", Category.DIVISION),
        Classification("360", "Water supply", Category.GROUP),
        Classification(
            "3601", "Water collection, treatment and distribution activities for domestic needs", Category.CLASS
        ),
        Classification(
            "36010", "Water collection, treatment and distribution activities for domestic needs", Category.SUBCLASS
        ),
        Classification(
            "3602", "Water collection, treatment and distribution activities for industrial needs", Category.CLASS
        ),
        Classification(
            "36020", "Water collection, treatment and distribution activities for industrial needs", Category.SUBCLASS
        ),
        Classification("37", "Sewage, wastewater, human and animal waste treatment services", Category.DIVISION),
        Classification("370", "Sewage, wastewater, human and animal waste treatment services", Category.GROUP),
        Classification("3701", "Sewage, wastewater treatment services", Category.CLASS),
        Classification("37011", "Sewage treatment services", Category.SUBCLASS),
        Classification("37012", "Wastewater treatment services", Category.SUBCLASS),
        Classification("3702", "Human and animal waste treatment services", Category.CLASS),
        Classification("37021", "Human waste treatment services", Category.SUBCLASS),
        Classification("37022", "Animal waste treatment services", Category.SUBCLASS),
        Classification(
            "38", "Waste collection, treatment and disposal activities; materials recovery", Category.DIVISION
        ),
        Classification("381", "Waste collection", Category.GROUP),
        Classification("3811", "Non-hazardous waste collection", Category.CLASS),
        Classification("38110", "Non-hazardous waste collection", Category.SUBCLASS),
        Classification("3812", "Hazardous waste collection", Category.CLASS),
        Classification("38120", "Hazardous waste collection", Category.SUBCLASS),
        Classification("3813", "Construction and demolition waste collection", Category.CLASS),
        Classification("38130", "Construction and demolition waste collection", Category.SUBCLASS),
        Classification("382", "Waste treatment and disposal services", Category.GROUP),
        Classification("3821", "Treatment and disposal of non-hazardous waste", Category.CLASS),
        Classification("38210", "Treatment and disposal of non-hazardous waste", Category.SUBCLASS),
        Classification("3822", "Treatment and disposal of hazardous waste", Category.CLASS),
        Classification("38220", "Treatment and disposal of hazardous waste", Category.SUBCLASS),
        Classification("3823", "Treatment and disposal of construction and demolition waste", Category.CLASS),
        Classification("38230", "Treatment and disposal of construction and demolition waste", Category.SUBCLASS),
        Classification("3824", "Collection, treatment and disposal of radioactive nuclear waste", Category.CLASS),
        Classification("38240", "Collection, treatment and disposal of radioactive nuclear waste", Category.SUBCLASS),
        Classification("383", "Dismantling and sorting recoverable materials; materials recovery", Category.GROUP),
        Classification("3831", "Dismantling, sorting and recovering metal waste", Category.CLASS),
        Classification("38311", "Dismantling and sorting metal waste", Category.SUBCLASS),
        Classification("38312", "Recovery of metal waste", Category.SUBCLASS),
        Classification("3832", "Dismantling, sorting and recovering non-metal waste", Category.CLASS),
        Classification("38321", "Dismantling and sorting non-metal waste", Category.SUBCLASS),
        Classification("38322", "Recovery of non-metal waste", Category.SUBCLASS),
        Classification("39", "Remediation activities and other waste management services", Category.DIVISION),
        Classification("390", "Remediation activities and other waste management services", Category.GROUP),
        Classification("3900", "Remediation activities and other waste management services", Category.CLASS),
        Classification("39001", "Decontamination of soils and groundwater", Category.SUBCLASS),
        Classification("39009", "Other remediation activities and waste management services", Category.SUBCLASS),
        Classification("F", "Construction", Category.SECTION),
        Classification("41", "General construction", Category.DIVISION),
        Classification("411", "Building construction", Category.GROUP),
        Classification("4111", "Residential building construction", Category.CLASS),
        Classification("41111", "Detached dwelling house and multi-dwelling house construction", Category.SUBCLASS),
        Classification("41112", "Apartment building construction", Category.SUBCLASS),
        Classification(
            "41119", "Other multi-unit house construction including apartment unit in a house", Category.SUBCLASS
        ),
        Classification("4112", "Non-residential building construction", Category.CLASS),
        Classification("41121", "Office, commercial and institutional building construction", Category.SUBCLASS),
        Classification("41122", "Factory and similar industrial building construction", Category.SUBCLASS),
        Classification("41129", "Other non-residential building construction", Category.SUBCLASS),
        Classification("412", "Heavy and civil engineering construction", Category.GROUP),
        Classification("4121", "Land subdivision with land improvement", Category.CLASS),
        Classification("41210", "Land subdivision with land improvement", Category.SUBCLASS),
        Classification("4122", "Construction of civil engineering projects", Category.CLASS),
        Classification("41221", "Construction of highways, streets and roads", Category.SUBCLASS),
        Classification("41222", "Construction of bridges, tunnels and railways", Category.SUBCLASS),
        Classification(
            "41223", "Construction of harbor and river works, waterways, dams and other water works", Category.SUBCLASS
        ),
        Classification("41224", "Construction of environmental facilities", Category.SUBCLASS),
        Classification("41225", "Construction of industrial plants", Category.SUBCLASS),
        Classification("41226", "Construction of landscaping works", Category.SUBCLASS),
        Classification("41229", "Other construction of civil engineering projects", Category.SUBCLASS),
        Classification("42", "Specialized construction activities", Category.DIVISION),
        Classification("421", "Site preparation and construction of foundation works and structures", Category.GROUP),
        Classification("4211", "Wrecking and demolition of buildings and other structures", Category.CLASS),
        Classification("42110", "Wrecking and demolition of buildings and other structures", Category.SUBCLASS),
        Classification("4212", "Site preparation and related construction", Category.CLASS),
        Classification("42121", "Earth works", Category.SUBCLASS),
        Classification("42122", "Boring, grouting and water well drilling works", Category.SUBCLASS),
        Classification("42123", "Pile driving and related construction of foundation works", Category.SUBCLASS),
        Classification("42129", "Other site preparation and related construction", Category.SUBCLASS),
        Classification("4213", "Erecting, assembling and framing structural parts and masonry works", Category.CLASS),
        Classification("42131", "Steel frame works", Category.SUBCLASS),
        Classification("42132", "Concrete and reinforcement works", Category.SUBCLASS),
        Classification("42133", "Brick laying and stone setting works", Category.SUBCLASS),
        Classification("42134", "Pavement works", Category.SUBCLASS),
        Classification("42135", "Special railway laying works", Category.SUBCLASS),
        Classification("42136", "Underwater works", Category.SUBCLASS),
        Classification("42137", "Scaffolding and form works", Category.SUBCLASS),
        Classification("42138", "Roofing and siding works", Category.SUBCLASS),
        Classification("42139", "Installing other outdoor facility works", Category.SUBCLASS),
        Classification("422", "Construction of installing building equipment", Category.GROUP),
        Classification("4220", "Construction of installing building equipment", Category.CLASS),
        Classification("42201", "Plumbing, heating, air conditioning works", Category.SUBCLASS),
        Classification("42202", "Installation of machinery equipment for building", Category.SUBCLASS),
        Classification("42203", "Soundproofing, isolating vibration and fireproofing works", Category.SUBCLASS),
        Classification("42204", "Fire fighting installation", Category.SUBCLASS),
        Classification("42209", "Construction of installing other building equipment", Category.SUBCLASS),
        Classification("423", "Electrical and communication works", Category.GROUP),
        Classification("4231", "Electrical works", Category.CLASS),
        Classification("42311", "Electrical works for heavy and civil engineering structures", Category.SUBCLASS),
        Classification("42312", "Electrical works for buildings", Category.SUBCLASS),
        Classification("4232", "Communication works", Category.CLASS),
        Classification("42321", "Communication works for heavy and civil engineering structures", Category.SUBCLASS),
        Classification("42322", "Communication works for buildings", Category.SUBCLASS),
        Classification("424", "Building completion and finishing", Category.GROUP),
        Classification("4241", "Painting, papering and finishing carpentry works", Category.CLASS),
        Classification("42411", "Painting works", Category.SUBCLASS),
        Classification("42412", "Papering, decorating and finishing carpentry works", Category.SUBCLASS),
        Classification("4242", "Glazing works and joinery installation", Category.CLASS),
        Classification("42420", "Glazing works and joinery installation", Category.SUBCLASS),
        Classification("4249", "Other building completion and finishing", Category.CLASS),
        Classification("42491", "Plastering, installing tile and waterproofing works", Category.SUBCLASS),
        Classification("42492", "Installation of metal works used on building", Category.SUBCLASS),
        Classification("42499", "Building completion and finishing n.e.c.", Category.SUBCLASS),
        Classification(
            "425", "Repair and maintenance works for construction works and supplementary facilities", Category.GROUP
        ),
        Classification(
            "4250", "Repair and maintenance works for construction works and supplementary facilities", Category.CLASS
        ),
        Classification(
            "42500",
            "Repair and maintenance works for construction works and supplementary facilities",
            Category.SUBCLASS,
        ),
        Classification("426", "Renting of construction machinery and equipment with operator", Category.GROUP),
        Classification("4260", "Renting of construction machinery and equipment with operator", Category.CLASS),
        Classification("42600", "Renting of construction machinery and equipment with operator", Category.SUBCLASS),
        Classification("G", "Wholesale and retail trade", Category.SECTION),
        Classification("45", "Sale of motor vehicles and parts", Category.DIVISION),
        Classification("451", "Sale of motor vehicles", Category.GROUP),
        Classification("4511", "Sale of new motor vehicles", Category.CLASS),
        Classification("45110", "Sale of new motor vehicles", Category.SUBCLASS),
        Classification("4512", "Sale of used motor vehicles", Category.CLASS),
        Classification("45120", "Sale of used motor vehicles", Category.SUBCLASS),
        Classification("452", "Sale of motor vehicle parts and accessories", Category.GROUP),
        Classification("4521", "Sale of motor vehicle new parts and accessories", Category.CLASS),
        Classification("45211", "Sale of motor vehicle new tires and tubes", Category.SUBCLASS),
        Classification("45212", "Sale of new parts and accessories specialized for motor vehicles", Category.SUBCLASS),
        Classification(
            "45213", "Sale of new electrical, electronic and precision equipment for motor vehicles", Category.SUBCLASS
        ),
        Classification("45219", "Sale of other new parts and accessories for motor vehicle", Category.SUBCLASS),
        Classification("4522", "Sale of motor vehicle used parts and accessories", Category.CLASS),
        Classification("45220", "Sale of motor vehicle used parts and accessories", Category.SUBCLASS),
        Classification("453", "Sale of motorcycles and related parts and accessories", Category.GROUP),
        Classification("4530", "Sale of motorcycles and related parts and accessories", Category.CLASS),
        Classification("45301", "Wholesale of motorcycles and related parts and accessories", Category.SUBCLASS),
        Classification("45302", "Retail sale of motorcycles and related parts and accessories", Category.SUBCLASS),
        Classification("46", "Wholesale trade on own account or on a fee or contract basis", Category.DIVISION),
        Classification("461", "Wholesale on a fee or contract basis", Category.GROUP),
        Classification("4610", "Wholesale on a fee or contract basis", Category.CLASS),
        Classification(
            "46101",
            "Agents involved in the sale of industrial agricultural raw materials, textile raw materials, live animals",
            Category.SUBCLASS,
        ),
        Classification("46102", "Agents involved in the sale of food, beverages and tobacco", Category.SUBCLASS),
        Classification(
            "46103", "Agents involved in the sale of textiles, clothing, footwear and leather goods", Category.SUBCLASS
        ),
        Classification("46104", "Agents involved in the sale of timber and building materials", Category.SUBCLASS),
        Classification(
            "46105",
            "Agents involved in the sale of fuels, ores, metals and industrial chemicals including fertilisers",
            Category.SUBCLASS,
        ),
        Classification("46106", "Agents involved in the sale of machinery and equipment", Category.SUBCLASS),
        Classification("46107", "Agents specialized in the sale of other particular products", Category.SUBCLASS),
        Classification("46109", "Agents involved in the sale of a variety of goods", Category.SUBCLASS),
        Classification("462", "Wholesale of agricultural raw materials and live animals and plants", Category.GROUP),
        Classification("4620", "Wholesale of agricultural raw materials and live animals and plants", Category.CLASS),
        Classification("46201", "Wholesale of grains and oilseed crops", Category.SUBCLASS),
        Classification("46202", "Wholesale of seeds and seedlings", Category.SUBCLASS),
        Classification("46203", "Wholesale of animal feeds", Category.SUBCLASS),
        Classification("46204", "Wholesale of flowers and plants", Category.SUBCLASS),
        Classification("46205", "Wholesale of live animals and pet animals", Category.SUBCLASS),
        Classification(
            "46209", "Wholesale of other agricultural raw materials and live animals and plants", Category.SUBCLASS
        ),
        Classification("463", "Wholesale of food, beverages and tobaccos", Category.GROUP),
        Classification("4631", "Wholesale of fresh food and dried, salted and frozen food", Category.CLASS),
        Classification("46311", "Wholesale of fruit", Category.SUBCLASS),
        Classification("46312", "Wholesale of vegetables, root and tube crops and spice crops", Category.SUBCLASS),
        Classification("46313", "Wholesale of meat", Category.SUBCLASS),
        Classification("46314", "Wholesale of dried and salted fishery products", Category.SUBCLASS),
        Classification("46315", "Wholesale of fresh, frozen and other fishery products", Category.SUBCLASS),
        Classification("46319", "Wholesale of other fresh food and dried, salted and frozen food", Category.SUBCLASS),
        Classification("4632", "Wholesale of processed food", Category.CLASS),
        Classification("46321", "Wholesale of meat processed food", Category.SUBCLASS),
        Classification("46322", "Wholesale of fishery processed food", Category.SUBCLASS),
        Classification(
            "46323", "Wholesale of bakery, flour confectionery, sugar and chocolate products", Category.SUBCLASS
        ),
        Classification("46324", "Wholesale of dairy products and edible oils and fats", Category.SUBCLASS),
        Classification("46325", "Wholesale of coffee and tea", Category.SUBCLASS),
        Classification("46326", "Wholesale of condiments and food additive products", Category.SUBCLASS),
        Classification("46329", "Wholesale of other processed food", Category.SUBCLASS),
        Classification("4633", "Wholesale of beverages and tobaccos", Category.CLASS),
        Classification("46331", "Wholesale of alcoholic beverages", Category.SUBCLASS),
        Classification("46332", "Wholesale of non-alcoholic beverages", Category.SUBCLASS),
        Classification("46333", "Wholesale of tobaccos", Category.SUBCLASS),
        Classification("464", "Wholesale of household goods", Category.GROUP),
        Classification(
            "4641", "Wholesale of household textiles, apparels, accessories and fur products", Category.CLASS
        ),
        Classification("46411", "Wholesale of textiles and threads", Category.SUBCLASS),
        Classification("46412", "Wholesale of curtains and bedding", Category.SUBCLASS),
        Classification("46413", "Wholesale of outerwear and shirts", Category.SUBCLASS),
        Classification("46414", "Wholesale of babies' garments", Category.SUBCLASS),
        Classification("46415", "Wholesale of underwear and nightwear", Category.SUBCLASS),
        Classification("46416", "Wholesale of leather and fur products", Category.SUBCLASS),
        Classification("46417", "Wholesale of wear accessaries and costume jewellery", Category.SUBCLASS),
        Classification("46419", "Wholesale of other household textiles and textile goods", Category.SUBCLASS),
        Classification("4642", "Wholesale of footwear", Category.CLASS),
        Classification("46420", "Wholesale of footwear", Category.SUBCLASS),
        Classification(
            "4643", "Wholesale of household furniture, lighting equipment and non-electric appliances", Category.CLASS
        ),
        Classification("46431", "Wholesale of household furniture", Category.SUBCLASS),
        Classification("46432", "Wholesale of electric lamps and bulbs and lighting equipment", Category.SUBCLASS),
        Classification(
            "46433", "Wholesale of cutlery and housewares made of glass, ceramic, wood, metal", Category.SUBCLASS
        ),
        Classification("46439", "Wholesale of other household non-electric appliances", Category.SUBCLASS),
        Classification("4644", "Wholesale of pharmaceutical and medical goods and cosmetics", Category.CLASS),
        Classification("46441", "Wholesale of pharmaceuticals", Category.SUBCLASS),
        Classification("46442", "Wholesale of medical goods", Category.SUBCLASS),
        Classification("46443", "Wholesale of cosmetics and related products", Category.SUBCLASS),
        Classification("46444", "Wholesale of soaps and detergents", Category.SUBCLASS),
        Classification(
            "4645",
            "Wholesale of household wrapping, hygienic goods, stationery and printed publications",
            Category.CLASS,
        ),
        Classification(
            "46451", "Wholesale of household wrapping, hygienic goods, bags and similar goods", Category.SUBCLASS
        ),
        Classification("46452", "Wholesale of stationery, artists' goods and office supplies", Category.SUBCLASS),
        Classification("46453", "Wholesale of books, magazines and other printed publications", Category.SUBCLASS),
        Classification(
            "4646",
            "Wholesale of music and video recordings, musical instruments, amusement and athletic goods",
            Category.CLASS,
        ),
        Classification("46461", "Wholesale of music and video recordings", Category.SUBCLASS),
        Classification("46462", "Wholesale of musical instruments", Category.SUBCLASS),
        Classification("46463", "Wholesale of toys, hobby supplies and game and playthings", Category.SUBCLASS),
        Classification("46464", "Wholesale of sports and athletic goods", Category.SUBCLASS),
        Classification("46465", "Wholesale of bicycles and other transportation equipment", Category.SUBCLASS),
        Classification("4649", "Wholesale of luggage, watches, eyeglasses and other household goods", Category.CLASS),
        Classification("46491", "Wholesale of luggage and protective cases", Category.SUBCLASS),
        Classification("46492", "Wholesale of watches and jewellery", Category.SUBCLASS),
        Classification(
            "46493", "Wholesale of eyeglasses, photographic equipments and optical goods", Category.SUBCLASS
        ),
        Classification("46499", "Wholesale of other household goods n.e.c.", Category.SUBCLASS),
        Classification("465", "Wholesale of machinery, equipment and supplies", Category.GROUP),
        Classification("4651", "Wholesale of computers, computer peripheral equipment and software", Category.CLASS),
        Classification(
            "46510", "Wholesale of computers, computer peripheral equipment and software", Category.SUBCLASS
        ),
        Classification("4652", "Wholesale of electronic and communications equipment and parts", Category.CLASS),
        Classification("46521", "Wholesale of electronic equipment and parts", Category.SUBCLASS),
        Classification("46522", "Wholesale of communication and broadcasting apparatuses and parts", Category.SUBCLASS),
        Classification("4653", "Wholesale of industrial machinery and equipment", Category.CLASS),
        Classification("46531", "Wholesale of agricultural and forestry machinery and equipment", Category.SUBCLASS),
        Classification("46532", "Wholesale of construction and mining machinery and equipment", Category.SUBCLASS),
        Classification("46533", "Wholesale of machine tools and related equipment", Category.SUBCLASS),
        Classification("46539", "Wholesale of other industrial machinery and equipment", Category.SUBCLASS),
        Classification("4659", "Wholesale of other machinery and equipment", Category.CLASS),
        Classification("46591", "Wholesale of office furniture and appliances", Category.SUBCLASS),
        Classification("46592", "Wholesale of medical appliances", Category.SUBCLASS),
        Classification("46593", "Wholesale of precision and scientific instruments and equipment", Category.SUBCLASS),
        Classification("46594", "Wholesale of transport equipment", Category.SUBCLASS),
        Classification("46595", "Wholesale of electrical machinery and related materials", Category.SUBCLASS),
        Classification("46596", "Wholesale of batteries and cables", Category.SUBCLASS),
        Classification("46599", "Wholesale of other machinery and equipment n.e.c.", Category.SUBCLASS),
        Classification(
            "466",
            "Wholesale of construction materials, hardware and heating and air conditioning equipment",
            Category.GROUP,
        ),
        Classification("4661", "Wholesale of construction materials", Category.CLASS),
        Classification("46611", "Wholesale of wood and wooden goods for construction industry", Category.SUBCLASS),
        Classification("46612", "Wholesale of gravel, bricks and cement", Category.SUBCLASS),
        Classification("46613", "Wholesale of glass, windows and doors", Category.SUBCLASS),
        Classification(
            "4662", "Wholesale of hardware, handtools and heating and air conditioning equipment", Category.CLASS
        ),
        Classification("46621", "Wholesale of plumbing and heating and air conditioning equipment", Category.SUBCLASS),
        Classification("46622", "Wholesale of hardware, metal fastener and handtools", Category.SUBCLASS),
        Classification("4669", "Wholesale of other construction materials", Category.CLASS),
        Classification("46691", "Wholesale of paint", Category.SUBCLASS),
        Classification("46692", "Wholesale of wallpaper and floor coverings", Category.SUBCLASS),
        Classification("46699", "Wholesale of other construction materials n.e.c.", Category.SUBCLASS),
        Classification("467", "Other specialized wholesale", Category.GROUP),
        Classification("4671", "Wholesale of solid, liquid and gaseous fuels and related products", Category.CLASS),
        Classification("46711", "Wholesale of solid fuels and related products", Category.SUBCLASS),
        Classification("46712", "Wholesale of liquid fuels and related products", Category.SUBCLASS),
        Classification("46713", "Wholesale of gaseous fuels and related products", Category.SUBCLASS),
        Classification("4672", "Wholesale of basic metals and metal ores", Category.CLASS),
        Classification("46721", "Wholesale of basic metals", Category.SUBCLASS),
        Classification("46722", "Wholesale of metal ores", Category.SUBCLASS),
        Classification("4673", "Wholesale of chemical materials and products", Category.CLASS),
        Classification("46731", "Wholesale of dyes, pigments and related products", Category.SUBCLASS),
        Classification("46732", "Wholesale of fertilizers and agricultural chemicals", Category.SUBCLASS),
        Classification("46733", "Wholesale of plastics and synthetic rubber in primary forms", Category.SUBCLASS),
        Classification("46739", "Wholesale of other chemical materials and products", Category.SUBCLASS),
        Classification("4674", "Wholesale of fibers, yarns and textiles", Category.CLASS),
        Classification("46741", "Wholesale of fibers and yarns for spinning and weaving", Category.SUBCLASS),
        Classification("46742", "Wholesale of textiles", Category.SUBCLASS),
        Classification("4675", "Wholesale of paper, paperboard and paper box", Category.CLASS),
        Classification("46750", "Wholesale of paper, paperboard and paper box", Category.SUBCLASS),
        Classification("4679", "Wholesale of materials for recycling and other specialized goods", Category.CLASS),
        Classification("46791", "Wholesale of materials for recycling", Category.SUBCLASS),
        Classification("46799", "Wholesale of other specialized goods n.e.c.", Category.SUBCLASS),
        Classification("468", "Non-specialized wholesale trade", Category.GROUP),
        Classification("4680", "Non-specialized wholesale trade", Category.CLASS),
        Classification("46800", "Non-specialized wholesale trade", Category.SUBCLASS),
        Classification("47", "Retail trade, except motor vehicles and motorcycles", Category.DIVISION),
        Classification("471", "Retail sale in non-specialized stores", Category.GROUP),
        Classification(
            "4711",
            "Retail sale in non-specialized superstores with sales space of at least three thousand square meters",
            Category.CLASS,
        ),
        Classification("47111", "Department stores", Category.SUBCLASS),
        Classification("47112", "Discount department stores", Category.SUBCLASS),
        Classification(
            "47119", "Other superstores with sales space of at least three thousand square meters", Category.SUBCLASS
        ),
        Classification(
            "4712", "Retail sale in non-specialized stores with food, beverages predominating", Category.CLASS
        ),
        Classification("47121", "Supermarkets", Category.SUBCLASS),
        Classification("47122", "Convenience stores", Category.SUBCLASS),
        Classification(
            "47129", "Retail sale in other non-specialized stores with food, beverages predominating", Category.SUBCLASS
        ),
        Classification("4713", "Duty-free shops", Category.CLASS),
        Classification("47130", "Duty-free shops", Category.SUBCLASS),
        Classification("4719", "Other retail sale in non-specialized stores", Category.CLASS),
        Classification("47190", "Other retail sale in non-specialized stores", Category.SUBCLASS),
        Classification("472", "Retail sale of foods, beverages and tobacco in specialized stores", Category.GROUP),
        Classification("4721", "Retail sale of foods", Category.CLASS),
        Classification("47211", "Retail sale of grains, grain flour and animal feeds", Category.SUBCLASS),
        Classification("47212", "Retail sale of meat", Category.SUBCLASS),
        Classification("47213", "Retail sale of dried and salted fishery products", Category.SUBCLASS),
        Classification("47214", "Retail sale of fresh, frozen and other fishery products", Category.SUBCLASS),
        Classification("47215", "Retail sale of vegetables, fruit and root crops", Category.SUBCLASS),
        Classification("47216", "Retail sale of bakery, flour confectionery and sugar products", Category.SUBCLASS),
        Classification("47217", "Retail sale of health additive foods", Category.SUBCLASS),
        Classification("47218", "Retail sale of side dishes", Category.SUBCLASS),
        Classification("47219", "Retail sale of other foods", Category.SUBCLASS),
        Classification("4722", "Retail sale of beverages and tobacco products", Category.CLASS),
        Classification("47221", "Retail sale of beverages", Category.SUBCLASS),
        Classification("47222", "Retail sale of tobacco products", Category.SUBCLASS),
        Classification(
            "473",
            "Retail sale of household electrical appliances and information and communication equipment",
            Category.GROUP,
        ),
        Classification(
            "4731",
            "Retail sale of computers, computer peripheral equipment, software and communication equipment",
            Category.CLASS,
        ),
        Classification(
            "47311", "Retail sale of computers, computer peripheral equipment and software", Category.SUBCLASS
        ),
        Classification("47312", "Retail sale of communication equipment", Category.SUBCLASS),
        Classification("4732", "Retail sale of household electrical appliances", Category.CLASS),
        Classification("47320", "Retail sale of household electrical appliances", Category.SUBCLASS),
        Classification("474", "Retail sale of textiles, clothing, footwear and leather goods", Category.GROUP),
        Classification("4741", "Retail sale of clothing", Category.CLASS),
        Classification("47411", "Retail sale of outerwear for men", Category.SUBCLASS),
        Classification("47412", "Retail sale of outerwear for women", Category.SUBCLASS),
        Classification("47413", "Retail sale of underwear and nightwear", Category.SUBCLASS),
        Classification("47414", "Retail sale of shirts and blouse", Category.SUBCLASS),
        Classification("47415", "Retail sale of hanbok, korean traditional clothes", Category.SUBCLASS),
        Classification("47416", "Retail sale of leather and fur garments", Category.SUBCLASS),
        Classification("47417", "Retail sale of babies' garments", Category.SUBCLASS),
        Classification("47419", "Retail sale of other clothing", Category.SUBCLASS),
        Classification("4742", "Retail sale of textiles, textile goods and clothing accessories", Category.CLASS),
        Classification("47421", "Retail sale of household textile articles", Category.SUBCLASS),
        Classification("47422", "Retail sale of wear accessaries and costume jewellery", Category.SUBCLASS),
        Classification("47429", "Retail sale of fabrics, threads and other textile goods", Category.SUBCLASS),
        Classification("4743", "Retail sale of footwear", Category.CLASS),
        Classification("47430", "Retail sale of footwear", Category.SUBCLASS),
        Classification("4744", "Retail sale of luggage and other leather products", Category.CLASS),
        Classification("47440", "Retail sale of luggage and other leather products", Category.SUBCLASS),
        Classification("475", "Retail sale of other household equipment", Category.GROUP),
        Classification(
            "4751", "Retail sale of hardware, tools, windows and doors and construction materials", Category.CLASS
        ),
        Classification("47511", "Retail sale of hardware and heating equipment", Category.SUBCLASS),
        Classification("47512", "Retail sale of tools", Category.SUBCLASS),
        Classification("47513", "Retail sale of wallpaper and floor coverings", Category.SUBCLASS),
        Classification(
            "47519", "Retail sale of paints, windows and doors and other construction materials", Category.SUBCLASS
        ),
        Classification("4752", "Retail sale of furniture", Category.CLASS),
        Classification("47520", "Retail sale of furniture", Category.SUBCLASS),
        Classification("4759", "Retail sale of other household equipment n.e.c.", Category.CLASS),
        Classification("47591", "Retail sale of electrical appliances, lighting equipment", Category.SUBCLASS),
        Classification(
            "47592", "Retail sale of kitchenware, glass and ceramics household equipment", Category.SUBCLASS
        ),
        Classification("47593", "Retail sale of musical instruments", Category.SUBCLASS),
        Classification("47599", "Retail sale of other household appliances n.e.c.", Category.SUBCLASS),
        Classification("476", "Retail sale of cultural, amusement and recreation goods", Category.GROUP),
        Classification("4761", "Retail sale of books and stationery", Category.CLASS),
        Classification("47611", "Retail sale of books, newspapers and magazines", Category.SUBCLASS),
        Classification("47612", "Retail sale of stationery and artists' goods", Category.SUBCLASS),
        Classification("4762", "Retail sale of music and video recordings", Category.CLASS),
        Classification("47620", "Retail sale of music and video recordings", Category.SUBCLASS),
        Classification("4763", "Retail sale of sporting equipment and bicycles", Category.CLASS),
        Classification("47631", "Retail sale of sports and athletic goods", Category.SUBCLASS),
        Classification("47632", "Retail sale of bicycles and other transportation equipment", Category.SUBCLASS),
        Classification("4764", "Retail sale of amusement goods, dolls and toys", Category.CLASS),
        Classification("47640", "Retail sale of amusement goods, dolls and toys", Category.SUBCLASS),
        Classification("477", "Retail sale of fuels", Category.GROUP),
        Classification("4771", "Retail sale of fuels for transportation equipment", Category.CLASS),
        Classification("47711", "Oil stations for transportation equipment", Category.SUBCLASS),
        Classification("47712", "Gas stations for transportation equipment", Category.SUBCLASS),
        Classification("4772", "Retail sale of fuels for household", Category.CLASS),
        Classification("47721", "Retail sale of solid fuels for household", Category.SUBCLASS),
        Classification("47722", "Retail sale of liquid fuels for household", Category.SUBCLASS),
        Classification("47723", "Retail sale of gaseous fuels for household", Category.SUBCLASS),
        Classification("478", "Retail sale in other goods in specialized stores", Category.GROUP),
        Classification(
            "4781", "Retail sale of pharmaceuticals, medical equipment, cosmetics and perfumery", Category.CLASS
        ),
        Classification("47811", "Retail sale of pharmaceutical and medical goods", Category.SUBCLASS),
        Classification("47812", "Retail sale of medical and orthopaedic equipment", Category.SUBCLASS),
        Classification("47813", "Retail sale of cosmetics, soaps and perfumery", Category.SUBCLASS),
        Classification(
            "4782", "Retail sale of office appliances, eyeglasses, photographic and precision equipment", Category.CLASS
        ),
        Classification("47821", "Retail sale of office appliances", Category.SUBCLASS),
        Classification("47822", "Retail sale of eyeglasses and lens", Category.SUBCLASS),
        Classification("47823", "Retail sale of photographic equipment and related goods", Category.SUBCLASS),
        Classification("47829", "Retail sale of other optical and precision equipment", Category.SUBCLASS),
        Classification("4783", "Retail sale of watches and jewellery", Category.CLASS),
        Classification("47830", "Retail sale of watches and jewellery", Category.SUBCLASS),
        Classification("4784", "Retail sale of works of arts, souvenirs and ornaments", Category.CLASS),
        Classification("47841", "Retail sale of works of arts and antiques", Category.SUBCLASS),
        Classification("47842", "Retail sale of souvenirs, folk art articles and ornaments", Category.SUBCLASS),
        Classification("4785", "Retail sale in other goods in specialized stores n.e.c.", Category.CLASS),
        Classification("47851", "Retail sale of flowers and plants", Category.SUBCLASS),
        Classification("47852", "Retail sale of pet animals and pet supplies", Category.SUBCLASS),
        Classification("47859", "Retail sale of other goods n.e.c.", Category.SUBCLASS),
        Classification("4786", "Retail sale of second-hand goods", Category.CLASS),
        Classification("47861", "Retail sale of second-hand furniture", Category.SUBCLASS),
        Classification("47862", "Retail sale of electronic and communication equipment", Category.SUBCLASS),
        Classification("47869", "Retail sale of other second-hand goods", Category.SUBCLASS),
        Classification("479", "Retail sale not in stores", Category.GROUP),
        Classification("4791", "Retail sale via mail order houses or via internet", Category.CLASS),
        Classification("47911", "Electronic commerce on a fee or contract basis via internet", Category.SUBCLASS),
        Classification("47912", "Electronic commerce via internet", Category.SUBCLASS),
        Classification("47919", "Retail sale via mail order houses", Category.SUBCLASS),
        Classification("4792", "Sale via stalls and markets of other goods", Category.CLASS),
        Classification("47920", "Sale via stalls and markets of other goods", Category.SUBCLASS),
        Classification("4799", "Other retail sale not in stores, stalls or markets", Category.CLASS),
        Classification("47991", "Retail sale through vending machine", Category.SUBCLASS),
        Classification(
            "47992", "Direct selling of goods delivered directly to the customers premises", Category.SUBCLASS
        ),
        Classification("47993", "Retail sale through door-to-door sales", Category.SUBCLASS),
        Classification("47999", "Other retail sale not in stores, stalls or markets n.e.c.", Category.SUBCLASS),
        Classification("H", "Transportation and storage", Category.SECTION),
        Classification("49", "Land transport and transport via pipelines", Category.DIVISION),
        Classification("491", "Transport via railways", Category.GROUP),
        Classification("4910", "Transport via railways", Category.CLASS),
        Classification("49101", "Passenger rail transport, interurban", Category.SUBCLASS),
        Classification("49102", "Freight rail transport", Category.SUBCLASS),
        Classification("492", "Passenger land transport, except transport via railways", Category.GROUP),
        Classification("4921", "Urban and suburban passenger land transport", Category.CLASS),
        Classification("49211", "Urban railway transport", Category.SUBCLASS),
        Classification("49212", "Intra-city bus transport", Category.SUBCLASS),
        Classification("49219", "Other urban and suburban passenger land transport", Category.SUBCLASS),
        Classification("4922", "Intercity bus transport", Category.CLASS),
        Classification("49220", "Intercity bus transport", Category.SUBCLASS),
        Classification("4923", "Non-scheduled passenger land transport", Category.CLASS),
        Classification("49231", "Taxi transport", Category.SUBCLASS),
        Classification("49232", "Chartered bus transport", Category.SUBCLASS),
        Classification("49233", "Hearse transport", Category.SUBCLASS),
        Classification("49239", "Other non-scheduled passenger land transport", Category.SUBCLASS),
        Classification("493", "Freight transport by road", Category.GROUP),
        Classification("4930", "Freight transport by road", Category.CLASS),
        Classification("49301", "General freight trucking by heavy truck", Category.SUBCLASS),
        Classification("49302", "Freight trucking by light or small truck", Category.SUBCLASS),
        Classification("49303", "Freight trucking by medium truck", Category.SUBCLASS),
        Classification("49309", "Other freight transport by road", Category.SUBCLASS),
        Classification("494", "Couriers and messengers activities", Category.GROUP),
        Classification("4940", "Couriers and messengers activities", Category.CLASS),
        Classification("49401", "Courier activities", Category.SUBCLASS),
        Classification("49402", "Local delivery and messenger services", Category.SUBCLASS),
        Classification("495", "Transport via pipeline", Category.GROUP),
        Classification("4950", "Transport via pipeline", Category.CLASS),
        Classification("49500", "Transport via pipeline", Category.SUBCLASS),
        Classification("50", "Water transport", Category.DIVISION),
        Classification("501", "Sea and coastal water transport", Category.GROUP),
        Classification("5011", "Sea water transport", Category.CLASS),
        Classification("50111", "Sea passenger water transport", Category.SUBCLASS),
        Classification("50112", "Sea freight water transport", Category.SUBCLASS),
        Classification("5012", "Coastal water transport", Category.CLASS),
        Classification("50121", "Coastal passenger water transport", Category.SUBCLASS),
        Classification("50122", "Coastal freight water transport", Category.SUBCLASS),
        Classification("5013", "Other sea and coastal water transport", Category.CLASS),
        Classification("50130", "Other sea and coastal water transport", Category.SUBCLASS),
        Classification("502", "Inland water transport", Category.GROUP),
        Classification("5020", "Inland water transport", Category.CLASS),
        Classification("50201", "Inland passenger and freight water transport", Category.SUBCLASS),
        Classification("50202", "Harbour passenger transport", Category.SUBCLASS),
        Classification("50209", "Other inland water transport", Category.SUBCLASS),
        Classification("51", "Air transport", Category.DIVISION),
        Classification("511", "Passenger air transport", Category.GROUP),
        Classification("5110", "Passenger air transport", Category.CLASS),
        Classification("51100", "Passenger air transport", Category.SUBCLASS),
        Classification("512", "Freight air transport", Category.GROUP),
        Classification("5120", "Freight air transport", Category.CLASS),
        Classification("51200", "Freight air transport", Category.SUBCLASS),
        Classification("52", "Warehousing and support activities for transportation", Category.DIVISION),
        Classification("521", "Warehousing and storage", Category.GROUP),
        Classification("5210", "Warehousing and storage", Category.CLASS),
        Classification("52101", "General warehousing", Category.SUBCLASS),
        Classification("52102", "Refrigerated and frozen warehousing", Category.SUBCLASS),
        Classification("52103", "Farm products warehousing", Category.SUBCLASS),
        Classification("52104", "Dangerous goods warehousing", Category.SUBCLASS),
        Classification("52109", "Other warehousing and storage", Category.SUBCLASS),
        Classification("529", "Support activities for transportation", Category.GROUP),
        Classification("5291", "Service activities incidental to land transportation", Category.CLASS),
        Classification("52911", "Service activities incidental to rail transportation", Category.SUBCLASS),
        Classification("52912", "Operation of passenger bus terminal facilities", Category.SUBCLASS),
        Classification("52913", "Operation of logistics terminal facilities", Category.SUBCLASS),
        Classification("52914", "Operation of roads and related facilities", Category.SUBCLASS),
        Classification("52915", "Operation of car park or garage facilities", Category.SUBCLASS),
        Classification("52919", "Other service activities incidental to land transportation", Category.SUBCLASS),
        Classification("5292", "Service activities incidental to water transportation", Category.CLASS),
        Classification("52921", "Operation of harbour and marine terminal facilities", Category.SUBCLASS),
        Classification("52929", "Other service activities incidental to water transportation", Category.SUBCLASS),
        Classification("5293", "Service activities incidental to air transportation", Category.CLASS),
        Classification("52931", "Operation of airport", Category.SUBCLASS),
        Classification("52939", "Other service activities incidental to air transportation", Category.SUBCLASS),
        Classification("5294", "Cargo handling", Category.CLASS),
        Classification("52941", "Air and land cargo handling", Category.SUBCLASS),
        Classification("52942", "Marine cargo handling", Category.SUBCLASS),
        Classification("5299", "Other support activities for transportation n.e.c.", Category.CLASS),
        Classification("52991", "Activities of customs agents and related services", Category.SUBCLASS),
        Classification(
            "52992", "Activities of freight forwarders and cargo agents and related services", Category.SUBCLASS
        ),
        Classification("52993", "Activities of cargo packing, checking and weighing services", Category.SUBCLASS),
        Classification("52999", "Other supporting transport services n.e.c.", Category.SUBCLASS),
        Classification("I", "Accommodation and food service activities", Category.SECTION),
        Classification("55", "Accommodation", Category.DIVISION),
        Classification("551", "General accommodation and accommodation with cooking facilities", Category.GROUP),
        Classification("5510", "General accommodation and accommodation with cooking facilities", Category.CLASS),
        Classification("55101", "Hotels", Category.SUBCLASS),
        Classification("55102", "Inns", Category.SUBCLASS),
        Classification("55103", "Resort condominium", Category.SUBCLASS),
        Classification("55104", "Tourist home", Category.SUBCLASS),
        Classification(
            "55109",
            "Other general accommodation and provision of accommodation with cooking facilities",
            Category.SUBCLASS,
        ),
        Classification("559", "Other accommodation", Category.GROUP),
        Classification("5590", "Other accommodation", Category.CLASS),
        Classification("55901", "Dormitory and accommodation for examinee", Category.SUBCLASS),
        Classification("55909", "Other accommodation n.e.c.", Category.SUBCLASS),
        Classification("56", "Food and beverage service activities", Category.DIVISION),
        Classification("561", "Restaurants and mobile food service activities", Category.GROUP),
        Classification("5611", "Korean food restaurants", Category.CLASS),
        Classification("56111", "General korean food restaurants", Category.SUBCLASS),
        Classification("56112", "Korean food restaurants specializing in noodle dishes", Category.SUBCLASS),
        Classification("56113", "Korean food restaurants specializing in meat dishes", Category.SUBCLASS),
        Classification("56114", "Korean food restaurants specializing in seafood dishes", Category.SUBCLASS),
        Classification("5612", "Foreign food restaurants", Category.CLASS),
        Classification("56121", "Chinese food restaurants", Category.SUBCLASS),
        Classification("56122", "Japanese food restaurants", Category.SUBCLASS),
        Classification("56123", "Western food restaurants", Category.SUBCLASS),
        Classification("56129", "Other foreign food restaurants", Category.SUBCLASS),
        Classification("5613", "Industrial restaurants", Category.CLASS),
        Classification("56130", "Industrial restaurants", Category.SUBCLASS),
        Classification("5614", "Event catering and mobile food service activities", Category.CLASS),
        Classification("56141", "Event catering", Category.SUBCLASS),
        Classification("56142", "Mobile food services activities", Category.SUBCLASS),
        Classification("5619", "Other light food restaurants", Category.CLASS),
        Classification("56191", "Bakeries", Category.SUBCLASS),
        Classification(
            "56192",
            "Pizza, hamburger and sandwich eating places and similar food services activities",
            Category.SUBCLASS,
        ),
        Classification("56193", "Chicken restaurants", Category.SUBCLASS),
        Classification("56194", "Dried seaweed rolls and other light food restaurants", Category.SUBCLASS),
        Classification("56199", "Take-out light food restaurants", Category.SUBCLASS),
        Classification("562", "Drinking places and non-alcoholic beverages places", Category.GROUP),
        Classification("5621", "Drinking places", Category.CLASS),
        Classification("56211", "General amusement and drinking places", Category.SUBCLASS),
        Classification("56212", "Dancing and drinking halls", Category.SUBCLASS),
        Classification("56213", "Taphouses", Category.SUBCLASS),
        Classification("56219", "Other drinking places", Category.SUBCLASS),
        Classification("5622", "Non-alcoholic beverages places", Category.CLASS),
        Classification("56221", "Coffee shops", Category.SUBCLASS),
        Classification("56229", "Other non-alcoholic beverages places", Category.SUBCLASS),
        Classification("J", "Information and communication", Category.SECTION),
        Classification("58", "Publishing activities", Category.DIVISION),
        Classification("581", "Publishing of books, magazines and other publishing activities", Category.GROUP),
        Classification("5811", "Book publishing", Category.CLASS),
        Classification("58111", "Textbook and study book publishing", Category.SUBCLASS),
        Classification("58112", "Comic book publishing", Category.SUBCLASS),
        Classification("58113", "Other book publishing", Category.SUBCLASS),
        Classification("5812", "Publishing of newspapers, magazines and periodicals", Category.CLASS),
        Classification("58121", "Publishing of newspapers", Category.SUBCLASS),
        Classification("58122", "Publishing of magazines and periodicals", Category.SUBCLASS),
        Classification("58123", "Publishing of advertising periodicals", Category.SUBCLASS),
        Classification("5819", "Other publishing activities", Category.CLASS),
        Classification("58190", "Other publishing activities", Category.SUBCLASS),
        Classification("582", "Software publishing", Category.GROUP),
        Classification("5821", "Game software publishing", Category.CLASS),
        Classification("58211", "Online game software publishing", Category.SUBCLASS),
        Classification("58211-1", "null"),
        Classification("58212", "Mobile game software publishing", Category.SUBCLASS),
        Classification("58212-1", "null"),
        Classification("58219", "Other game software publishing", Category.SUBCLASS),
        Classification("5822", "System and application software publishing", Category.CLASS),
        Classification("58221", "System software publishing", Category.SUBCLASS),
        Classification("58221-1", "null"),
        Classification("58222", "Application software publishing", Category.SUBCLASS),
        Classification("58222-1", "null"),
        Classification(
            "59",
            "Motion picture, video and television programme production, sound recording and music publishing activities",
            Category.DIVISION,
        ),
        Classification("591", "Motion picture, video and broadcast programme activities", Category.GROUP),
        Classification("5911", "Motion picture, video, broadcast programme production activities", Category.CLASS),
        Classification("59111", "General motion picture and video production activities", Category.SUBCLASS),
        Classification("59112", "Animated cartoon and video production", Category.SUBCLASS),
        Classification("59113", "Advertising motion picture and video production", Category.SUBCLASS),
        Classification("59114", "Broadcasting programme production", Category.SUBCLASS),
        Classification(
            "5912", "Motion picture, video and broadcasting programme post-production activities", Category.CLASS
        ),
        Classification(
            "59120", "Motion picture, video and broadcasting programme post-production activities", Category.SUBCLASS
        ),
        Classification(
            "5913", "Motion picture, video and broadcasting programme distribution activities", Category.CLASS
        ),
        Classification(
            "59130", "Motion picture, video and broadcasting programme distribution activities", Category.SUBCLASS
        ),
        Classification("5914", "Motion picture and video projection activities", Category.CLASS),
        Classification("59141", "Motion picture theaters", Category.SUBCLASS),
        Classification("59142", "Video projection activities", Category.SUBCLASS),
        Classification("592", "Sound recording and music publishing activities", Category.GROUP),
        Classification("5920", "Sound recording and music publishing activities", Category.CLASS),
        Classification("59201", "Music and sound recordings publishing", Category.SUBCLASS),
        Classification("59202", "Sound recording service activities", Category.SUBCLASS),
        Classification("60", "Broadcasting activities", Category.DIVISION),
        Classification("601", "Radio broadcasting", Category.GROUP),
        Classification("6010", "Radio broadcasting", Category.CLASS),
        Classification("60100", "Radio broadcasting", Category.SUBCLASS),
        Classification("602", "Television broadcasting", Category.GROUP),
        Classification("6021", "Terrestrial broadcasting", Category.CLASS),
        Classification("60210", "Terrestrial broadcasting", Category.SUBCLASS),
        Classification("6022", "Cable, satellite and other broadcasting", Category.CLASS),
        Classification("60221", "Broadcasting programme provider", Category.SUBCLASS),
        Classification("60222", "Cable broadcasting", Category.SUBCLASS),
        Classification("60229", "Satellite and other broadcasting", Category.SUBCLASS),
        Classification("61", "Postal activities and telecommunications", Category.DIVISION),
        Classification("611", "Postal activities", Category.GROUP),
        Classification("6110", "Postal activities", Category.CLASS),
        Classification("61100", "Postal activities", Category.SUBCLASS),
        Classification("612", "Telecommunications", Category.GROUP),
        Classification("6121", "Wired telecommunications", Category.CLASS),
        Classification("61210", "Wired telecommunications", Category.SUBCLASS),
        Classification("6122", "Wireless and satellite telecommunications", Category.CLASS),
        Classification("61220", "Wireless and satellite telecommunications", Category.SUBCLASS),
        Classification("6129", "Other telecommunications", Category.CLASS),
        Classification("61291", "Telecommunications resellers", Category.SUBCLASS),
        Classification("61299", "Other telecommunications n.e.c.", Category.SUBCLASS),
        Classification("62", "Computer programming, consultancy and related activities", Category.DIVISION),
        Classification("620", "Computer programming, consultancy and related activities", Category.GROUP),
        Classification("6201", "Computer programming services", Category.CLASS),
        Classification("62010", "Computer programming services", Category.SUBCLASS),
        Classification("62010-1", "null"),
        Classification(
            "6202", "Computer system consultancy and computer facilities management activities", Category.CLASS
        ),
        Classification("62021", "Computer system consultancy activities", Category.SUBCLASS),
        Classification("62021-1", "null"),
        Classification("62022", "Computer facilities management services", Category.SUBCLASS),
        Classification("6209", "Other information technology and computer service activities", Category.CLASS),
        Classification("62090", "Other information technology and computer service activities", Category.SUBCLASS),
        Classification("62090-1", "null"),
        Classification("63", "Information service activities", Category.DIVISION),
        Classification("631", "Data processing, hosting and related activities; web portals", Category.GROUP),
        Classification("6311", "Data processing, hosting and related activities", Category.CLASS),
        Classification("63111", "Data processing", Category.SUBCLASS),
        Classification("63112", "Hosting and related service activities", Category.SUBCLASS),
        Classification("63112-1", "null"),
        Classification("6312", "Portals and other internet information media service activities", Category.CLASS),
        Classification("63120", "Portals and other internet information media service activities", Category.SUBCLASS),
        Classification("639", "Other information service activities", Category.GROUP),
        Classification("6391", "News agency activities", Category.CLASS),
        Classification("63910", "News agency activities", Category.SUBCLASS),
        Classification("6399", "Other information service activities n.e.c.", Category.CLASS),
        Classification("63991", "Data base activities and on-line information provision services", Category.SUBCLASS),
        Classification("63999", "Other information service activities n.e.c.", Category.SUBCLASS),
        Classification("63999-1", "null"),
        Classification("63999-2", "null"),
        Classification("K", "Financial and insurance activities", Category.SECTION),
        Classification("64", "Financial service activities, except insurance and pension funding", Category.DIVISION),
        Classification("641", "Banking and savings institutions", Category.GROUP),
        Classification("6411", "Central bank", Category.CLASS),
        Classification("64110", "Central bank", Category.SUBCLASS),
        Classification("6412", "Commercial banks", Category.CLASS),
        Classification("64121", "Domestic commercial banks", Category.SUBCLASS),
        Classification("64122", "Foreign banks", Category.SUBCLASS),
        Classification("6413", "Credit unions and savings institutions", Category.CLASS),
        Classification("64131", "Credit unions", Category.SUBCLASS),
        Classification("64132", "Mutual savings bank and other savings institutions", Category.SUBCLASS),
        Classification("642", "Trust and collective investment businesses", Category.GROUP),
        Classification("6420", "Trust and collective investment businesses", Category.CLASS),
        Classification("64201", "Trust and collective investment businesses", Category.SUBCLASS),
        Classification("64209", "Other financial investment businesses", Category.SUBCLASS),
        Classification("649", "Other financial service activities", Category.GROUP),
        Classification("6491", "Credit granting", Category.CLASS),
        Classification("6499", "Other financial service activities n.e.c.", Category.CLASS),
        Classification("64991", "Public fund management business", Category.SUBCLASS),
        Classification("64992", "Activities of holding companies", Category.SUBCLASS),
        Classification("64999", "Other financial service activities n.e.c.", Category.SUBCLASS),
        Classification("65", "Insurance and pension funding", Category.DIVISION),
        Classification("651", "Insurance", Category.GROUP),
        Classification("6511", "Life insurance", Category.CLASS),
        Classification("65110", "Life insurance", Category.SUBCLASS),
        Classification("6512", "Non-life and guarantee insurance", Category.CLASS),
        Classification("65121", "Non-life insurance", Category.SUBCLASS),
        Classification("65122", "Guarantee insurance", Category.SUBCLASS),
        Classification("6513", "Social security insurance", Category.CLASS),
        Classification("65131", "Health insurance", Category.SUBCLASS),
        Classification(
            "65139", "Industrial accident compensation insurance and other social security insurance", Category.SUBCLASS
        ),
        Classification("652", "Reinsurance", Category.GROUP),
        Classification("6520", "Reinsurance", Category.CLASS),
        Classification("65200", "Reinsurance", Category.SUBCLASS),
        Classification("653", "Pension fund and mutual aid organizations", Category.GROUP),
        Classification("6530", "Pension fund and mutual aid organizations", Category.CLASS),
        Classification("65301", "Individual mutual aid organizations", Category.SUBCLASS),
        Classification("65302", "Business mutual aid organizations", Category.SUBCLASS),
        Classification("65303", "Pension funding", Category.SUBCLASS),
        Classification("66", "Activities auxiliary to financial service and insurance activities", Category.DIVISION),
        Classification("661", "Activities auxiliary to financial service activities", Category.GROUP),
        Classification("6611", "Administration of financial markets", Category.CLASS),
        Classification("66110", "Administration of financial markets", Category.SUBCLASS),
        Classification("6612", "Securities and commodity contracts brokerage", Category.CLASS),
        Classification("66121", "Securities brokerage", Category.SUBCLASS),
        Classification("66122", "Futures mediation", Category.SUBCLASS),
        Classification("6619", "Other activities auxiliary to financial service activities", Category.CLASS),
        Classification("66191", "Securities issuance, management, deposit and settlement services", Category.SUBCLASS),
        Classification(
            "66192", "Investment advisory businesses and discretionary investment businesses", Category.SUBCLASS
        ),
        Classification("66199", "Other activities auxiliary to financial service activities n.e.c.", Category.SUBCLASS),
        Classification("662", "Activities auxiliary to insurance and pension funding", Category.GROUP),
        Classification("6620", "Activities auxiliary to insurance and pension funding", Category.CLASS),
        Classification("66201", "Risk and damage evaluation", Category.SUBCLASS),
        Classification("66202", "Insurance agents and brokers", Category.SUBCLASS),
        Classification("66209", "Other activities auxiliary to insurance and pension funding", Category.SUBCLASS),
        Classification("L", "Real estate activities", Category.SECTION),
        Classification("68", "Real estate activities", Category.DIVISION),
        Classification("681", "Real estate activities with own or leased property", Category.GROUP),
        Classification("6811", "Renting of real estate", Category.CLASS),
        Classification("68111", "Renting of residential buildings", Category.SUBCLASS),
        Classification("68112", "Renting of non-residential buildings", Category.SUBCLASS),
        Classification("68119", "Renting of other real estate", Category.SUBCLASS),
        Classification("6812", "Development and subdividing of real estate", Category.CLASS),
        Classification("68121", "Development and subdividing of residential buildings", Category.SUBCLASS),
        Classification("68122", "Development and subdividing of non-residential buildings", Category.SUBCLASS),
        Classification("68129", "Development and subdividing of other real estate", Category.SUBCLASS),
        Classification("682", "Real estate activities on a fee or contract basis", Category.GROUP),
        Classification("6821", "Management of real estate", Category.CLASS),
        Classification("68211", "Management of residential real estate", Category.SUBCLASS),
        Classification("68212", "Management of nonresidential real estate", Category.SUBCLASS),
        Classification("6822", "Real estate brokerage, consultancy and appraisal", Category.CLASS),
        Classification("68221", "Real estate agents and brokers", Category.SUBCLASS),
        Classification("68222", "Real estate investment consultancy", Category.SUBCLASS),
        Classification("68223", "Real estate appraisal", Category.SUBCLASS),
        Classification("M", "Professional, scientific and technical activities", Category.SECTION),
        Classification("70", "Research and development", Category.DIVISION),
        Classification(
            "701", "Research and experimental development on natural sciences and engineering", Category.GROUP
        ),
        Classification("7011", "Research and experimental development on natural sciences", Category.CLASS),
        Classification(
            "70111", "Research and experimental development on physics, chemistry and biology", Category.SUBCLASS
        ),
        Classification(
            "70112",
            "Research and experimental development on agriculture, forestry, fishery and veterinary science",
            Category.SUBCLASS,
        ),
        Classification(
            "70113", "Research and experimental development on medical sciences and pharmacy", Category.SUBCLASS
        ),
        Classification("70119", "Research and experimental development on other natural sciences", Category.SUBCLASS),
        Classification("7012", "Research and experimental development on engineering", Category.CLASS),
        Classification(
            "70121", "Research and experimental development on electrical and electronic engineering", Category.SUBCLASS
        ),
        Classification("70129", "Research and experimental development on other engineering", Category.SUBCLASS),
        Classification(
            "7013",
            "Interdisciplinary convergence research and experimental development on natural sciences and engineering",
            Category.CLASS,
        ),
        Classification(
            "70130",
            "Interdisciplinary convergence research and experimental development on natural sciences and engineering",
            Category.SUBCLASS,
        ),
        Classification(
            "702", "Research and experimental development on social sciences and humanities", Category.GROUP
        ),
        Classification(
            "7020", "Research and experimental development on social sciences and humanities", Category.CLASS
        ),
        Classification(
            "70201", "Research and experimental development on economics and business administration", Category.SUBCLASS
        ),
        Classification(
            "70209", "Research and experimental development on other social sciences and humanities", Category.SUBCLASS
        ),
        Classification("71", "Professional services", Category.DIVISION),
        Classification("711", "Legal services", Category.GROUP),
        Classification("7110", "Legal services", Category.CLASS),
        Classification("71101", "Offices of lawyers", Category.SUBCLASS),
        Classification("71102", "Offices of patent attorney", Category.SUBCLASS),
        Classification("71103", "Offices of judicial scrvener", Category.SUBCLASS),
        Classification("71109", "Other legal services", Category.SUBCLASS),
        Classification("712", "Accounting, bookkeeping and auditing activities; tax consultancy", Category.GROUP),
        Classification("7120", "Accounting, bookkeeping and auditing activities; tax consultancy", Category.CLASS),
        Classification("71201", "Offices of accountants", Category.SUBCLASS),
        Classification("71202", "Offices of tax accountants", Category.SUBCLASS),
        Classification("71209", "Other accounting, bookkeeping and auditing activities", Category.SUBCLASS),
        Classification("713", "Advertising", Category.GROUP),
        Classification("7131", "Advertising agencies", Category.CLASS),
        Classification("71310", "Advertising agencies", Category.SUBCLASS),
        Classification("7139", "Other advertising", Category.CLASS),
        Classification("71391", "Outdoor and exhibition advertising", Category.SUBCLASS),
        Classification("71392", "Media representatives and media buying agencies", Category.SUBCLASS),
        Classification("71393", "Advertising preparation", Category.SUBCLASS),
        Classification("71399", "Other advertising related services n.e.c.", Category.SUBCLASS),
        Classification("714", "Market research and public opinion polling", Category.GROUP),
        Classification("7140", "Market research and public opinion polling", Category.CLASS),
        Classification("71400", "Market research and public opinion polling", Category.SUBCLASS),
        Classification("715", "Activities of head offices, management consultancy activities", Category.GROUP),
        Classification("7151", "Activities of head offices", Category.CLASS),
        Classification("71511", "Activities of head offices for manufacturing", Category.SUBCLASS),
        Classification("71519", "Activities of head offices for other industries", Category.SUBCLASS),
        Classification("7153", "Activities of management consultancy and public relation services", Category.CLASS),
        Classification("71531", "Activities of management consultancy", Category.SUBCLASS),
        Classification("71532", "Public relation services", Category.SUBCLASS),
        Classification("716", "Other professional services", Category.GROUP),
        Classification("7160", "Other professional services", Category.CLASS),
        Classification("71600", "Other professional services", Category.SUBCLASS),
        Classification("72", "Architectural, engineering and other scientific technical services", Category.DIVISION),
        Classification("721", "Architectural, engineering and related technical services", Category.GROUP),
        Classification("7211", "Architectural and landscape architectural services", Category.CLASS),
        Classification("72111", "Architectural services", Category.SUBCLASS),
        Classification("72112", "Urban planning landscape architectural services", Category.SUBCLASS),
        Classification("7212", "Engineering services", Category.CLASS),
        Classification(
            "72121", "Building and civil engineering projects related engineering services", Category.SUBCLASS
        ),
        Classification("72122", "Environmental consulting and related engineering services", Category.SUBCLASS),
        Classification("72129", "Other engineering services", Category.SUBCLASS),
        Classification("729", "Other scientific and technical services", Category.GROUP),
        Classification("7291", "Technical testing and analysis", Category.CLASS),
        Classification(
            "72911", "Testing and analysis services of composition and purity of materials", Category.SUBCLASS
        ),
        Classification("72919", "Other technical testing and analysis", Category.SUBCLASS),
        Classification("7292", "Surface and geological surveying, cartographic activities", Category.CLASS),
        Classification("72921", "Surface surveying", Category.SUBCLASS),
        Classification("72922", "Drafting services", Category.SUBCLASS),
        Classification("72923", "Geological surveying and prospecting services", Category.SUBCLASS),
        Classification("72924", "Cartography activities", Category.SUBCLASS),
        Classification("73", "Other professional, scientific and technical services", Category.DIVISION),
        Classification("731", "Veterinary activities", Category.GROUP),
        Classification("7310", "Veterinary activities", Category.CLASS),
        Classification("73100", "Veterinary activities", Category.SUBCLASS),
        Classification("732", "Specialized design activities", Category.GROUP),
        Classification("7320", "Specialized design activities", Category.CLASS),
        Classification("73201", "Interior design services", Category.SUBCLASS),
        Classification("73202", "Products design services", Category.SUBCLASS),
        Classification("73203", "Graphic design services", Category.SUBCLASS),
        Classification("73209", "Other specialized design services", Category.SUBCLASS),
        Classification("733", "Photographic activities", Category.GROUP),
        Classification("7330", "Photographic activities", Category.CLASS),
        Classification("73301", "Portrait photography and videotaping of events services", Category.SUBCLASS),
        Classification("73302", "Commercial photography services", Category.SUBCLASS),
        Classification("73303", "Photograph processing", Category.SUBCLASS),
        Classification("739", "Other professional, scientific and technical services n.e.c.", Category.GROUP),
        Classification("7390", "Other professional, scientific and technical services n.e.c.", Category.CLASS),
        Classification("73901", "Managers", Category.SUBCLASS),
        Classification("73902", "Translation and interpretation services", Category.SUBCLASS),
        Classification("73903", "Business and intangible rights brokerages", Category.SUBCLASS),
        Classification("73904", "Appraisal, weighing and sampling services of goods", Category.SUBCLASS),
        Classification("73909", "Other professional, scientific and technical services n.e.c.", Category.SUBCLASS),
        Classification(
            "N",
            "Business facilities management and business support services; rental and leasing activities",
            Category.SECTION,
        ),
        Classification("74", "Business facilities management and landscape services", Category.DIVISION),
        Classification("741", "Combined facilities support activities", Category.GROUP),
        Classification("7410", "Combined facilities support activities", Category.CLASS),
        Classification("74100", "Combined facilities support activities", Category.SUBCLASS),
        Classification(
            "742", "Cleaning and pest control services of building and industrial facilities", Category.GROUP
        ),
        Classification("7421", "Cleaning of building and industrial facilities", Category.CLASS),
        Classification("74211", "General cleaning of buildings", Category.SUBCLASS),
        Classification(
            "74212", "Cleaning of industrial facilities, transportation equipments and public places", Category.SUBCLASS
        ),
        Classification("7422", "Disinfecting, exterminating and pest control services", Category.CLASS),
        Classification("74220", "Disinfecting, exterminating and pest control services", Category.SUBCLASS),
        Classification("743", "Landscape care and maintenance sevice activities", Category.GROUP),
        Classification("7430", "Landscape care and maintenance sevice activities", Category.CLASS),
        Classification("74300", "Landscape care and maintenance sevice activities", Category.SUBCLASS),
        Classification("75", "Business support services", Category.DIVISION),
        Classification(
            "751", "Activities of employment placement agencies and provision of human resources", Category.GROUP
        ),
        Classification("7511", "Activities of employment placement agencies", Category.CLASS),
        Classification("75110", "Activities of employment placement agencies", Category.SUBCLASS),
        Classification("7512", "Provision of human resources", Category.CLASS),
        Classification("75121", "Provision of temporary workers and day laborers", Category.SUBCLASS),
        Classification("75122", "Provision of regular workers and human resources funtions", Category.SUBCLASS),
        Classification(
            "752", "Activities of travel agencies and tour operators and tourist assistance activities", Category.GROUP
        ),
        Classification("7521", "Travel agency activities", Category.CLASS),
        Classification("75210", "Travel agency activities", Category.SUBCLASS),
        Classification("7529", "Other tourist assistance and reservation services", Category.CLASS),
        Classification("75290", "Other tourist assistance and reservation services", Category.SUBCLASS),
        Classification("753", "Security, guard and detective services", Category.GROUP),
        Classification("7531", "Security and guard services", Category.CLASS),
        Classification("75310", "Security and guard services", Category.SUBCLASS),
        Classification("7532", "Security systems srevice activities", Category.CLASS),
        Classification("75320", "Security systems srevice activities", Category.SUBCLASS),
        Classification("7533", "Detective and investigation services", Category.CLASS),
        Classification("75330", "Detective and investigation services", Category.SUBCLASS),
        Classification("759", "Other business support services", Category.GROUP),
        Classification("7591", "Office support services", Category.CLASS),
        Classification("75911", "Document preparation services", Category.SUBCLASS),
        Classification("75912", "Duplicating services", Category.SUBCLASS),
        Classification("75919", "Other office support service activities", Category.SUBCLASS),
        Classification("7599", "Other business support service activities n.e.c.", Category.CLASS),
        Classification("75991", "Activities of call centers and telemarketing services", Category.SUBCLASS),
        Classification("75992", "Exhibition, convention and trade fair organization agencies", Category.SUBCLASS),
        Classification("75993", "Activities of collection agencies and credit bureaus", Category.SUBCLASS),
        Classification("75994", "Packaging and filling activities", Category.SUBCLASS),
        Classification("75999", "All other business support services n.e.c.", Category.SUBCLASS),
        Classification("76", "Rental and leasing activities; except real estate", Category.DIVISION),
        Classification("761", "Renting of transport equipment", Category.GROUP),
        Classification("7611", "Renting of motor vehicles", Category.CLASS),
        Classification("76110", "Renting of motor vehicles", Category.SUBCLASS),
        Classification("7619", "Renting of other transport equipment", Category.CLASS),
        Classification("76190", "Renting of other transport equipment", Category.SUBCLASS),
        Classification("762", "Renting of personal and household goods", Category.GROUP),
        Classification("7621", "Renting of sports and recreational goods", Category.CLASS),
        Classification("76210", "Renting of sports and recreational goods", Category.SUBCLASS),
        Classification("7622", "Renting of discs and video tapes", Category.CLASS),
        Classification("76220", "Renting of discs and video tapes", Category.SUBCLASS),
        Classification("7629", "Renting of other personal and household goods", Category.CLASS),
        Classification("76291", "Renting of books", Category.SUBCLASS),
        Classification("76292", "Renting of wearing apparel", Category.SUBCLASS),
        Classification("76299", "Renting of other personal and household goods n.e.c.", Category.SUBCLASS),
        Classification("763", "Renting of industrial machinery and equipment", Category.GROUP),
        Classification(
            "7631",
            "Renting of construction(including civil engineering and construction) machinery and equipment",
            Category.CLASS,
        ),
        Classification(
            "76310",
            "Renting of construction(including civil engineering and construction) machinery and equipment",
            Category.SUBCLASS,
        ),
        Classification("7632", "Renting of computers and office equipment", Category.CLASS),
        Classification("76320", "Renting of computers and office equipment", Category.SUBCLASS),
        Classification("7639", "Renting of other industries machinery and equipment", Category.CLASS),
        Classification("76390", "Renting of other industries machinery and equipment", Category.SUBCLASS),
        Classification("764", "Leasing of intangible property", Category.GROUP),
        Classification("7640", "Leasing of intangible property", Category.CLASS),
        Classification("76400", "Leasing of intangible property", Category.SUBCLASS),
        Classification("O", "Public administration and defence; compulsory social security", Category.SECTION),
        Classification("84", "Public administration and defence; compulsory social security", Category.DIVISION),
        Classification("841", "Executive, legislative and general government support", Category.GROUP),
        Classification("8411", "General public administration activities", Category.CLASS),
        Classification("84111", "Legislative administration", Category.SUBCLASS),
        Classification("84112", "Executive administration of central bodies", Category.SUBCLASS),
        Classification("84113", "Executive administration of reginal and local bodies", Category.SUBCLASS),
        Classification("84114", "Administration of financial and economic policy", Category.SUBCLASS),
        Classification("84119", "Other general public administration activities", Category.SUBCLASS),
        Classification("8412", "Ancillary service activities for government", Category.CLASS),
        Classification("84120", "Ancillary service activities for government", Category.SUBCLASS),
        Classification("842", "Administration of industrial and social policy of community", Category.GROUP),
        Classification(
            "8421",
            "Regulation of the activities of providing health care, education, cultural services and other social services, excluding social security",
            Category.CLASS,
        ),
        Classification("84211", "Regulation of the activities of education affairs", Category.SUBCLASS),
        Classification("84212", "Regulation of the activities of cultural and tourism affairs", Category.SUBCLASS),
        Classification("84213", "Regulation of the activities of environment affairs", Category.SUBCLASS),
        Classification("84214", "Regulation of the activities of health care and welfare affairs", Category.SUBCLASS),
        Classification(
            "84219",
            "Other regulation of the activities of providing health care, education, cultural services and other social services, excluding social security",
            Category.SUBCLASS,
        ),
        Classification(
            "8422", "Regulation of and contribution to more efficient operation of businesses", Category.CLASS
        ),
        Classification("84221", "Administration of general labor affairs", Category.SUBCLASS),
        Classification("84222", "Administration of agricultural, forestry, fishing affairs", Category.SUBCLASS),
        Classification("84223", "Administration of construction and transportation programs", Category.SUBCLASS),
        Classification("84224", "Administration of communications", Category.SUBCLASS),
        Classification(
            "84229", "Other regulation and contribution to more efficient operation of businesses", Category.SUBCLASS
        ),
        Classification("843", "Foreign affairs and defence activities", Category.GROUP),
        Classification("8431", "Foreign affairs", Category.CLASS),
        Classification("84310", "Foreign affairs", Category.SUBCLASS),
        Classification("8432", "Defence activities", Category.CLASS),
        Classification("84320", "Defence activities", Category.SUBCLASS),
        Classification("844", "Public order and safety activities", Category.GROUP),
        Classification("8440", "Public order and safety activities", Category.CLASS),
        Classification("84401", "Courts", Category.SUBCLASS),
        Classification("84402", "Prosecutor's offices", Category.SUBCLASS),
        Classification("84403", "Correctional institutions", Category.SUBCLASS),
        Classification("84404", "Police protection", Category.SUBCLASS),
        Classification("84405", "Fire protection", Category.SUBCLASS),
        Classification("84409", "Other public order and safety activities", Category.SUBCLASS),
        Classification("845", "Compulsory social security activities", Category.GROUP),
        Classification("8450", "Compulsory social security activities", Category.CLASS),
        Classification("84500", "Compulsory social security activities", Category.SUBCLASS),
        Classification("P", "Education", Category.SECTION),
        Classification("85", "Education", Category.DIVISION),
        Classification("851", "Pre-primary and primary education", Category.GROUP),
        Classification("8511", "Pre-primary education", Category.CLASS),
        Classification("85110", "Pre-primary education", Category.SUBCLASS),
        Classification("8512", "Elementary schools", Category.CLASS),
        Classification("85120", "Elementary schools", Category.SUBCLASS),
        Classification("852", "Secondary education", Category.GROUP),
        Classification("8521", "General secondary education", Category.CLASS),
        Classification("85211", "Middle schools", Category.SUBCLASS),
        Classification("85212", "Academic high schools", Category.SUBCLASS),
        Classification("8522", "Technical and vocational secondary education", Category.CLASS),
        Classification("85221", "Commercial and information industry high schools", Category.SUBCLASS),
        Classification("85222", "Technical high schools", Category.SUBCLASS),
        Classification("85229", "Other technical and vocational secondary education", Category.SUBCLASS),
        Classification("853", "Higher education", Category.GROUP),
        Classification("8530", "Higher education", Category.CLASS),
        Classification("85301", "Junior technical and vocational colleges", Category.SUBCLASS),
        Classification("85302", "Universities", Category.SUBCLASS),
        Classification("85303", "Graduate schools", Category.SUBCLASS),
        Classification("854", "Special schools, foreign schools, alternative schools", Category.GROUP),
        Classification("8541", "Schools for the handicapped", Category.CLASS),
        Classification("85410", "Schools for the handicapped", Category.SUBCLASS),
        Classification("8542", "Schools for the foreigners", Category.CLASS),
        Classification("85420", "Schools for the foreigners", Category.SUBCLASS),
        Classification("8543", "Alternative schools", Category.CLASS),
        Classification("85430", "Alternative schools", Category.SUBCLASS),
        Classification("855", "General educational institutes", Category.GROUP),
        Classification("8550", "General educational institutes", Category.CLASS),
        Classification("85501", "General subject educational institutes", Category.SUBCLASS),
        Classification("85502", "Home visiting educational institutes", Category.SUBCLASS),
        Classification("85503", "On-line educational institutes", Category.SUBCLASS),
        Classification("856", "Other educational institutes", Category.GROUP),
        Classification("8561", "Sports and recreation education", Category.CLASS),
        Classification("85611", "Taekwondo and martial arts education", Category.SUBCLASS),
        Classification("85612", "Other sports education", Category.SUBCLASS),
        Classification("85613", "Recreation education", Category.SUBCLASS),
        Classification("85614", "Teenagers training facilities", Category.SUBCLASS),
        Classification("8562", "Cultural education", Category.CLASS),
        Classification("85621", "Music edecation", Category.SUBCLASS),
        Classification("85622", "Fine arts education", Category.SUBCLASS),
        Classification("85629", "Other cultural education", Category.SUBCLASS),
        Classification("8563", "Foreign language institutes and other educational institutes", Category.CLASS),
        Classification("85631", "Foreign language institutes", Category.SUBCLASS),
        Classification("85632", "Other educational institutes", Category.SUBCLASS),
        Classification("8564", "Facilities for social education", Category.CLASS),
        Classification("85640", "Facilities for social education", Category.SUBCLASS),
        Classification("8565", "Employee training institutes", Category.CLASS),
        Classification("85650", "Employee training institutes", Category.SUBCLASS),
        Classification("8566", "Technical and trade schools", Category.CLASS),
        Classification("85661", "Driving schools", Category.SUBCLASS),
        Classification("85669", "Other technical and trade schools", Category.SUBCLASS),
        Classification("8569", "Other training institutes", Category.CLASS),
        Classification("85691", "Computer training institutes", Category.SUBCLASS),
        Classification("85699", "Other training institutes n.e.c.", Category.SUBCLASS),
        Classification("857", "Educational support activities", Category.GROUP),
        Classification("8570", "Educational support activities", Category.CLASS),
        Classification("85701", "Educational consulting and evaluation activities", Category.SUBCLASS),
        Classification("85709", "Other educational support activities", Category.SUBCLASS),
        Classification("Q", "Human health and social work activities", Category.SECTION),
        Classification("86", "Human health activities", Category.DIVISION),
        Classification("861", "Hospital activities", Category.GROUP),
        Classification("8610", "Hospital activities", Category.CLASS),
        Classification("86101", "General hospitals", Category.SUBCLASS),
        Classification("86102", "Specialized hospitals", Category.SUBCLASS),
        Classification("86103", "Dental hospitals", Category.SUBCLASS),
        Classification("86104", "Oriental medical hospitals", Category.SUBCLASS),
        Classification("86105", "Intermediate care hospital", Category.SUBCLASS),
        Classification("862", "Medical and dental practice activities", Category.GROUP),
        Classification("8620", "Medical and dental practice activities", Category.CLASS),
        Classification("86201", "General clinics", Category.SUBCLASS),
        Classification("86202", "Dental clinics", Category.SUBCLASS),
        Classification("86203", "Oriental medical clinics", Category.SUBCLASS),
        Classification("86204", "Medical and diagnostic clinics", Category.SUBCLASS),
        Classification("863", "Public health centers", Category.GROUP),
        Classification("8630", "Public health centers", Category.CLASS),
        Classification("86300", "Public health centers", Category.SUBCLASS),
        Classification("869", "Other human health activities", Category.GROUP),
        Classification("8690", "Other human health activities", Category.CLASS),
        Classification("86901", "Ambulance services", Category.SUBCLASS),
        Classification("86902", "Quasi-medical services", Category.SUBCLASS),
        Classification("86909", "Other human health activities n.e.c.", Category.SUBCLASS),
        Classification("87", "Social work activities", Category.DIVISION),
        Classification("871", "Residential welfare facilities", Category.GROUP),
        Classification("8711", "Residential welfare facilities for the elderly", Category.CLASS),
        Classification("87111", "Sanatorium for the elderly with nursing care", Category.SUBCLASS),
        Classification("87112", "Nursing homes for the elderly", Category.SUBCLASS),
        Classification(
            "8712", "Residential welfare facilities for the mental retardation and the disabled", Category.CLASS
        ),
        Classification("87121", "Residential welfare facilities for the disabled", Category.SUBCLASS),
        Classification(
            "87122",
            "Residential welfare facilities for the mental disorder, mental retardation and substance abuse",
            Category.SUBCLASS,
        ),
        Classification("8713", "Other residential welfare facilities", Category.CLASS),
        Classification("87131", "Residential welfare facilities for the young and women", Category.SUBCLASS),
        Classification("87139", "Other residential welfare facilities n.e.c.", Category.SUBCLASS),
        Classification("872", "Non-residential welfare facilities", Category.GROUP),
        Classification("8721", "Child day-care activities", Category.CLASS),
        Classification("87210", "Child day-care activities", Category.SUBCLASS),
        Classification("8729", "Other non-residential welfare facilities", Category.CLASS),
        Classification("87291", "Vocational rehabilitation facilities", Category.SUBCLASS),
        Classification("87292", "Welfare service center", Category.SUBCLASS),
        Classification("87293", "Domiciliary care activities", Category.SUBCLASS),
        Classification("87294", "Welfare counseling service activities", Category.SUBCLASS),
        Classification("87299", "Other non-residential welfare facilities n.e.c.", Category.SUBCLASS),
        Classification("R", "Arts, sports and recreation related services", Category.SECTION),
        Classification("90", "Creative, arts and recreation related services", Category.DIVISION),
        Classification("901", "Creative and arts related services", Category.GROUP),
        Classification("9011", "Operation of public performance facilities", Category.CLASS),
        Classification("90110", "Operation of public performance facilities", Category.SUBCLASS),
        Classification("9012", "Operation of public performance companies", Category.CLASS),
        Classification("90121", "Operation of dramatic companies", Category.SUBCLASS),
        Classification("90122", "Musical groups and dance companies", Category.SUBCLASS),
        Classification("90123", "Other performing arts companies", Category.SUBCLASS),
        Classification("9013", "Independent artists", Category.CLASS),
        Classification("90131", "Independent performing artists", Category.SUBCLASS),
        Classification("90132", "Independent non-performing artists", Category.SUBCLASS),
        Classification("9019", "Other creative and arts related services", Category.CLASS),
        Classification("90191", "Performing arts event promotion and organization", Category.SUBCLASS),
        Classification("90192", "Public performance and production agencies", Category.SUBCLASS),
        Classification("90199", "Other creative and arts related services n.e.c.", Category.SUBCLASS),
        Classification(
            "902", "Library, historical sites and buildings and similar recreation related services", Category.GROUP
        ),
        Classification("9021", "Operation of library, archives and reading room", Category.CLASS),
        Classification("90211", "Library and archives activities", Category.SUBCLASS),
        Classification("90212", "Reading room operation", Category.SUBCLASS),
        Classification("9022", "Museums activities and operation of historical sites and buildings", Category.CLASS),
        Classification("90221", "Museum activities", Category.SUBCLASS),
        Classification("90222", "Operation of historical sites and buildings", Category.SUBCLASS),
        Classification("9023", "Botanical and zoological gardens and nature reserves activities", Category.CLASS),
        Classification("90231", "Operation of botanical and zoological gardens", Category.SUBCLASS),
        Classification("90232", "Operation of nature reserves", Category.SUBCLASS),
        Classification("9029", "Other recreation activities n.e.c.", Category.CLASS),
        Classification("90290", "Other recreation activities n.e.c.", Category.SUBCLASS),
        Classification("91", "Sports activities and amusement activities", Category.DIVISION),
        Classification("911", "Sports services", Category.GROUP),
        Classification("9111", "Arena and stadium operation", Category.CLASS),
        Classification("91111", "Indoor arena and stadium operation", Category.SUBCLASS),
        Classification("91112", "Outdoor arena and stadium operation", Category.SUBCLASS),
        Classification("91113", "Racetrack operation", Category.SUBCLASS),
        Classification("9112", "Golf course and skiing facility operation", Category.CLASS),
        Classification("91121", "Golf course operation", Category.SUBCLASS),
        Classification("91122", "Skiing facility operation", Category.SUBCLASS),
        Classification("9113", "Other sports facility operation", Category.CLASS),
        Classification("91131", "Other complex sports facility operation", Category.SUBCLASS),
        Classification("91132", "Physical fitness facility operation", Category.SUBCLASS),
        Classification("91133", "Swimming pool operation", Category.SUBCLASS),
        Classification("91134", "Bowling alley operation", Category.SUBCLASS),
        Classification("91135", "Billiard room operation", Category.SUBCLASS),
        Classification("91136", "Golf practice range operation", Category.SUBCLASS),
        Classification("91139", "Other sports facility operation n.e.c.", Category.SUBCLASS),
        Classification("9119", "Other sports services", Category.CLASS),
        Classification("91191", "Sports club operation", Category.SUBCLASS),
        Classification("91199", "Other sports services n.e.c.", Category.SUBCLASS),
        Classification("912", "Amusement parks and other recreation activities", Category.GROUP),
        Classification("9121", "Amusement and theme park operation", Category.CLASS),
        Classification("91210", "Amusement and theme park operation", Category.SUBCLASS),
        Classification("9122", "Entertainment facility operation", Category.CLASS),
        Classification("91221", "Amusement arcade operation", Category.SUBCLASS),
        Classification("91222", "Computer game room operation", Category.SUBCLASS),
        Classification("91223", "Singing room operation", Category.SUBCLASS),
        Classification("91229", "Other entertainment facility operation", Category.SUBCLASS),
        Classification("9123", "Water recreation services", Category.CLASS),
        Classification("91231", "Operation of indoor and outdoor fishing place", Category.SUBCLASS),
        Classification("91239", "Other water recreation services", Category.SUBCLASS),
        Classification("9124", "Gambling and betting activities", Category.CLASS),
        Classification("91241", "Publication and sale of lottery", Category.SUBCLASS),
        Classification("91249", "Other gambling and betting activities", Category.SUBCLASS),
        Classification("9129", "Other amusement and recreation activities", Category.CLASS),
        Classification("91291", "Ballroom operation", Category.SUBCLASS),
        Classification(
            "91292", "Operation of recreational and sports park including similar activities", Category.SUBCLASS
        ),
        Classification("91293", "Badug room operation", Category.SUBCLASS),
        Classification("91299", "Other amusement and recreation activities n.e.c.", Category.SUBCLASS),
        Classification("S", "Membership organizations, repair and other personal services", Category.SECTION),
        Classification("94", "Membership organizations", Category.DIVISION),
        Classification("941", "Business, employers and professional membership organizations", Category.GROUP),
        Classification("9411", "Business and employers membership organizations", Category.CLASS),
        Classification("94110", "Business and employers membership organizations", Category.SUBCLASS),
        Classification("9412", "Professional membership organizations", Category.CLASS),
        Classification("94120", "Professional membership organizations", Category.SUBCLASS),
        Classification("942", "Trade unions", Category.GROUP),
        Classification("9420", "Trade unions", Category.CLASS),
        Classification("94200", "Trade unions", Category.SUBCLASS),
        Classification("949", "Other membership organizations", Category.GROUP),
        Classification("9491", "Religious organizations", Category.CLASS),
        Classification("94911", "Buddhism organizations", Category.SUBCLASS),
        Classification("94912", "Christianity organizations", Category.SUBCLASS),
        Classification("94913", "Catholicism organizations", Category.SUBCLASS),
        Classification("94914", "Korean religious organizations", Category.SUBCLASS),
        Classification("94919", "Other religious organizations", Category.SUBCLASS),
        Classification("9492", "Political organizations", Category.CLASS),
        Classification("94920", "Political organizations", Category.SUBCLASS),
        Classification("9493", "Social advocacy organizations", Category.CLASS),
        Classification("94931", "Environmental advocacy organizations", Category.SUBCLASS),
        Classification("94939", "Other social advocacy organizations", Category.SUBCLASS),
        Classification("9499", "Other membership organizations", Category.CLASS),
        Classification("94990", "Other membership organizations n.e.c.", Category.SUBCLASS),
        Classification("95", "Maintenance and repair services of personal and household goods", Category.DIVISION),
        Classification(
            "951", "Maintenance and repair services of computers and communication equipment", Category.GROUP
        ),
        Classification("9511", "Maintenance and repair services of computers and peripheral equipment", Category.CLASS),
        Classification(
            "95110", "Maintenance and repair services of computers and peripheral equipment", Category.SUBCLASS
        ),
        Classification("9512", "Maintenance and repair services of communication equipment", Category.CLASS),
        Classification("95120", "Maintenance and repair services of communication equipment", Category.SUBCLASS),
        Classification("952", "Maintenance and repair services of motor vehicles and motorcycles", Category.GROUP),
        Classification("9521", "Maintenance, repair and washing services of motor vehicles", Category.CLASS),
        Classification("95211", "General repair services of motor vehicles", Category.SUBCLASS),
        Classification("95212", "Repair services of motor vehicles specializing in parts", Category.SUBCLASS),
        Classification("95213", "Motor vehicle washing services", Category.SUBCLASS),
        Classification("9522", "Maintenance and repair services of motorcycles", Category.CLASS),
        Classification("95220", "Repair services of motorcycles", Category.SUBCLASS),
        Classification("953", "Repair services of personal and household goods", Category.GROUP),
        Classification("9531", "Repair services of electrical household machinery and appliances", Category.CLASS),
        Classification("95310", "Repair services of electrical household machinery and appliances", Category.SUBCLASS),
        Classification("9539", "Repair services of other personal and household goods", Category.CLASS),
        Classification("95391", "Repair services of clothing and other household textile goods", Category.SUBCLASS),
        Classification("95392", "Repair services of leather goods, luggage, footwear", Category.SUBCLASS),
        Classification("95393", "Repair services of watches, jewellery and musical instruments", Category.SUBCLASS),
        Classification("95399", "Repair services of other personal and household goods n.e.c.", Category.SUBCLASS),
        Classification("96", "Other personal services activities", Category.DIVISION),
        Classification("961", "Personal care services", Category.GROUP),
        Classification("9611", "Hairs, nails and skin cares", Category.CLASS),
        Classification("96111", "Barber shops", Category.SUBCLASS),
        Classification("96112", "Hair beauty shops", Category.SUBCLASS),
        Classification("96113", "Skin beauty shops", Category.SUBCLASS),
        Classification("96119", "Other beauty shops", Category.SUBCLASS),
        Classification("9612", "Saunas, massages and other physical well-being services", Category.CLASS),
        Classification("96121", "Turkish baths, sauna and steam baths, solariums", Category.SUBCLASS),
        Classification("96122", "Massage salons", Category.SUBCLASS),
        Classification("96129", "Other physical well-being services", Category.SUBCLASS),
        Classification("969", "Other personnal service activities n.e.c.", Category.GROUP),
        Classification("9691", "Washing and dry cleaning services", Category.CLASS),
        Classification("96911", "Industrial laundry services", Category.SUBCLASS),
        Classification("96912", "Household laundry services", Category.SUBCLASS),
        Classification("96913", "Laundry supplies", Category.SUBCLASS),
        Classification("9692", "Funeral homes and related services", Category.CLASS),
        Classification("96921", "Funeral homes and funeral related services", Category.SUBCLASS),
        Classification("96922", "Cremation, graveyard subdivision and management", Category.SUBCLASS),
        Classification("9699", "All other personnal service activities n.e.c.", Category.CLASS),
        Classification("96991", "Wedding chapel services", Category.SUBCLASS),
        Classification("96992", "Fortune-telling and the similar services", Category.SUBCLASS),
        Classification("96993", "Private nursing and similar services", Category.SUBCLASS),
        Classification("96994", "Marriage consulting and planning service", Category.SUBCLASS),
        Classification("96995", "Pet funeral and care services", Category.SUBCLASS),
        Classification("96999", "All other personal service activities n.e.c.", Category.SUBCLASS),
        Classification(
            "T",
            "Activities of households as employers; undifferentiated goods-and services-producing activities of households for own use",
            Category.SECTION,
        ),
        Classification("97", "Activities of households as employers of domestic personnel", Category.DIVISION),
        Classification("970", "Activities of households as employers of domestic personnel", Category.GROUP),
        Classification("9700", "Activities of households as employers of domestic personnel", Category.CLASS),
        Classification("97000", "Activities of households as employers of domestic personnel", Category.SUBCLASS),
        Classification(
            "98",
            "Undiferentiated goods-and services-producing activities of private households for own use",
            Category.DIVISION,
        ),
        Classification(
            "981", "Undiferentiated goods-producing activities of private households for own use", Category.GROUP
        ),
        Classification(
            "9810", "Undiferentiated goods-producing activities of private households for own use", Category.CLASS
        ),
        Classification(
            "98100", "Undiferentiated goods-producing activities of private households for own use", Category.SUBCLASS
        ),
        Classification(
            "982", "Undiferentiated service-producing activities of private households for own use", Category.GROUP
        ),
        Classification(
            "9820", "Undiferentiated service-producing activities of private households for own use", Category.CLASS
        ),
        Classification(
            "98200", "Undiferentiated service-producing activities of private households for own use", Category.SUBCLASS
        ),
        Classification("U", "Activities of extraterritorial organizations and bodies", Category.SECTION),
        Classification("99", "Activities of extraterritorial organizations and bodies", Category.DIVISION),
        Classification("990", "Activities of extraterritorial organizations and bodies", Category.GROUP),
        Classification("9900", "Activities of extraterritorial organizations and bodies", Category.CLASS),
        Classification("99001", "Foreign officail residence", Category.SUBCLASS),
        Classification("99009", "Other extraterritorial organizations and bodies n.e.c.", Category.SUBCLASS),
    ],
)
