# -*- coding: utf-8 -*-
"""`Concordance between ISIC31 and ISIC4 <https://unstats.un.org/unsd/classifications/Econ/tables/ISIC/ISIC31_ISIC4/ISIC31_ISIC4.txt>`_.
"""
from ...types import Concordance, Standards
from ..isic4 import ISIC4
from . import ISIC31

ISIC31_to_ISIC4 = Concordance(
    src=ISIC31,
    dst=ISIC4,
    concordances=[
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0111")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0112")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0113")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0114")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0115")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0116")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0119")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0126")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0128")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0129")),
        ((Standards.ISIC31, "0111"), (Standards.ISIC4, "0163")),
        ((Standards.ISIC31, "0112"), (Standards.ISIC4, "0113")),
        ((Standards.ISIC31, "0112"), (Standards.ISIC4, "0119")),
        ((Standards.ISIC31, "0112"), (Standards.ISIC4, "0125")),
        ((Standards.ISIC31, "0112"), (Standards.ISIC4, "0128")),
        ((Standards.ISIC31, "0112"), (Standards.ISIC4, "0129")),
        ((Standards.ISIC31, "0112"), (Standards.ISIC4, "0130")),
        ((Standards.ISIC31, "0112"), (Standards.ISIC4, "0230")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0121")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0122")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0123")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0124")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0125")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0126")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0127")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0128")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "0230")),
        ((Standards.ISIC31, "0113"), (Standards.ISIC4, "1102")),
        ((Standards.ISIC31, "0121"), (Standards.ISIC4, "0141")),
        ((Standards.ISIC31, "0121"), (Standards.ISIC4, "0142")),
        ((Standards.ISIC31, "0121"), (Standards.ISIC4, "0144")),
        ((Standards.ISIC31, "0122"), (Standards.ISIC4, "0143")),
        ((Standards.ISIC31, "0122"), (Standards.ISIC4, "0145")),
        ((Standards.ISIC31, "0122"), (Standards.ISIC4, "0146")),
        ((Standards.ISIC31, "0122"), (Standards.ISIC4, "0149")),
        ((Standards.ISIC31, "0122"), (Standards.ISIC4, "0321")),
        ((Standards.ISIC31, "0122"), (Standards.ISIC4, "0322")),
        ((Standards.ISIC31, "0130"), (Standards.ISIC4, "0150")),
        ((Standards.ISIC31, "0140"), (Standards.ISIC4, "0161")),
        ((Standards.ISIC31, "0140"), (Standards.ISIC4, "0162")),
        ((Standards.ISIC31, "0140"), (Standards.ISIC4, "0163")),
        ((Standards.ISIC31, "0140"), (Standards.ISIC4, "0164")),
        ((Standards.ISIC31, "0140"), (Standards.ISIC4, "8130")),
        ((Standards.ISIC31, "0150"), (Standards.ISIC4, "0170")),
        ((Standards.ISIC31, "0150"), (Standards.ISIC4, "9499")),
        ((Standards.ISIC31, "0200"), (Standards.ISIC4, "0129")),
        ((Standards.ISIC31, "0200"), (Standards.ISIC4, "0130")),
        ((Standards.ISIC31, "0200"), (Standards.ISIC4, "0210")),
        ((Standards.ISIC31, "0200"), (Standards.ISIC4, "0220")),
        ((Standards.ISIC31, "0200"), (Standards.ISIC4, "0230")),
        ((Standards.ISIC31, "0200"), (Standards.ISIC4, "0240")),
        ((Standards.ISIC31, "0501"), (Standards.ISIC4, "0311")),
        ((Standards.ISIC31, "0501"), (Standards.ISIC4, "0312")),
        ((Standards.ISIC31, "0502"), (Standards.ISIC4, "0321")),
        ((Standards.ISIC31, "0502"), (Standards.ISIC4, "0322")),
        ((Standards.ISIC31, "1010"), (Standards.ISIC4, "0510")),
        ((Standards.ISIC31, "1010"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1010"), (Standards.ISIC4, "1920")),
        ((Standards.ISIC31, "1020"), (Standards.ISIC4, "0520")),
        ((Standards.ISIC31, "1020"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1020"), (Standards.ISIC4, "1920")),
        ((Standards.ISIC31, "1030"), (Standards.ISIC4, "0892")),
        ((Standards.ISIC31, "1030"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1110"), (Standards.ISIC4, "0610")),
        ((Standards.ISIC31, "1110"), (Standards.ISIC4, "0620")),
        ((Standards.ISIC31, "1110"), (Standards.ISIC4, "0910")),
        ((Standards.ISIC31, "1120"), (Standards.ISIC4, "0910")),
        ((Standards.ISIC31, "1200"), (Standards.ISIC4, "0721")),
        ((Standards.ISIC31, "1200"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1310"), (Standards.ISIC4, "0710")),
        ((Standards.ISIC31, "1310"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1320"), (Standards.ISIC4, "0729")),
        ((Standards.ISIC31, "1320"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1410"), (Standards.ISIC4, "0810")),
        ((Standards.ISIC31, "1410"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1421"), (Standards.ISIC4, "0891")),
        ((Standards.ISIC31, "1421"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1422"), (Standards.ISIC4, "0893")),
        ((Standards.ISIC31, "1422"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1429"), (Standards.ISIC4, "0810")),
        ((Standards.ISIC31, "1429"), (Standards.ISIC4, "0899")),
        ((Standards.ISIC31, "1429"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "1511"), (Standards.ISIC4, "1010")),
        ((Standards.ISIC31, "1512"), (Standards.ISIC4, "1020")),
        ((Standards.ISIC31, "1512"), (Standards.ISIC4, "1075")),
        ((Standards.ISIC31, "1513"), (Standards.ISIC4, "1030")),
        ((Standards.ISIC31, "1513"), (Standards.ISIC4, "1075")),
        ((Standards.ISIC31, "1514"), (Standards.ISIC4, "1040")),
        ((Standards.ISIC31, "1520"), (Standards.ISIC4, "1050")),
        ((Standards.ISIC31, "1531"), (Standards.ISIC4, "1061")),
        ((Standards.ISIC31, "1532"), (Standards.ISIC4, "1062")),
        ((Standards.ISIC31, "1533"), (Standards.ISIC4, "1080")),
        ((Standards.ISIC31, "1541"), (Standards.ISIC4, "1071")),
        ((Standards.ISIC31, "1542"), (Standards.ISIC4, "1072")),
        ((Standards.ISIC31, "1543"), (Standards.ISIC4, "1073")),
        ((Standards.ISIC31, "1544"), (Standards.ISIC4, "1074")),
        ((Standards.ISIC31, "1544"), (Standards.ISIC4, "1075")),
        ((Standards.ISIC31, "1549"), (Standards.ISIC4, "1030")),
        ((Standards.ISIC31, "1549"), (Standards.ISIC4, "1071")),
        ((Standards.ISIC31, "1549"), (Standards.ISIC4, "1075")),
        ((Standards.ISIC31, "1549"), (Standards.ISIC4, "1079")),
        ((Standards.ISIC31, "1549"), (Standards.ISIC4, "3530")),
        ((Standards.ISIC31, "1551"), (Standards.ISIC4, "1101")),
        ((Standards.ISIC31, "1551"), (Standards.ISIC4, "2011")),
        ((Standards.ISIC31, "1552"), (Standards.ISIC4, "1102")),
        ((Standards.ISIC31, "1553"), (Standards.ISIC4, "1103")),
        ((Standards.ISIC31, "1554"), (Standards.ISIC4, "1104")),
        ((Standards.ISIC31, "1600"), (Standards.ISIC4, "1200")),
        ((Standards.ISIC31, "1711"), (Standards.ISIC4, "1311")),
        ((Standards.ISIC31, "1711"), (Standards.ISIC4, "1312")),
        ((Standards.ISIC31, "1712"), (Standards.ISIC4, "1313")),
        ((Standards.ISIC31, "1721"), (Standards.ISIC4, "1392")),
        ((Standards.ISIC31, "1721"), (Standards.ISIC4, "3250")),
        ((Standards.ISIC31, "1721"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "1722"), (Standards.ISIC4, "1393")),
        ((Standards.ISIC31, "1723"), (Standards.ISIC4, "1394")),
        ((Standards.ISIC31, "1723"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "1729"), (Standards.ISIC4, "1313")),
        ((Standards.ISIC31, "1729"), (Standards.ISIC4, "1399")),
        ((Standards.ISIC31, "1729"), (Standards.ISIC4, "1709")),
        ((Standards.ISIC31, "1730"), (Standards.ISIC4, "1391")),
        ((Standards.ISIC31, "1730"), (Standards.ISIC4, "1430")),
        ((Standards.ISIC31, "1810"), (Standards.ISIC4, "1313")),
        ((Standards.ISIC31, "1810"), (Standards.ISIC4, "1410")),
        ((Standards.ISIC31, "1810"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "1820"), (Standards.ISIC4, "1420")),
        ((Standards.ISIC31, "1820"), (Standards.ISIC4, "1511")),
        ((Standards.ISIC31, "1911"), (Standards.ISIC4, "1511")),
        ((Standards.ISIC31, "1912"), (Standards.ISIC4, "1512")),
        ((Standards.ISIC31, "1912"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "1920"), (Standards.ISIC4, "1512")),
        ((Standards.ISIC31, "1920"), (Standards.ISIC4, "1520")),
        ((Standards.ISIC31, "1920"), (Standards.ISIC4, "1629")),
        ((Standards.ISIC31, "1920"), (Standards.ISIC4, "2219")),
        ((Standards.ISIC31, "1920"), (Standards.ISIC4, "2220")),
        ((Standards.ISIC31, "1920"), (Standards.ISIC4, "3230")),
        ((Standards.ISIC31, "2010"), (Standards.ISIC4, "1610")),
        ((Standards.ISIC31, "2021"), (Standards.ISIC4, "1621")),
        ((Standards.ISIC31, "2022"), (Standards.ISIC4, "1622")),
        ((Standards.ISIC31, "2023"), (Standards.ISIC4, "1623")),
        ((Standards.ISIC31, "2023"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "2029"), (Standards.ISIC4, "1629")),
        ((Standards.ISIC31, "2029"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "2029"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "2101"), (Standards.ISIC4, "1701")),
        ((Standards.ISIC31, "2102"), (Standards.ISIC4, "1702")),
        ((Standards.ISIC31, "2109"), (Standards.ISIC4, "1709")),
        ((Standards.ISIC31, "2109"), (Standards.ISIC4, "1811")),
        ((Standards.ISIC31, "2109"), (Standards.ISIC4, "2220")),
        ((Standards.ISIC31, "2211"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "2211"), (Standards.ISIC4, "5811")),
        ((Standards.ISIC31, "2211"), (Standards.ISIC4, "5812")),
        ((Standards.ISIC31, "2212"), (Standards.ISIC4, "5813")),
        ((Standards.ISIC31, "2213"), (Standards.ISIC4, "5920")),
        ((Standards.ISIC31, "2219"), (Standards.ISIC4, "5813")),
        ((Standards.ISIC31, "2219"), (Standards.ISIC4, "5819")),
        ((Standards.ISIC31, "2221"), (Standards.ISIC4, "1709")),
        ((Standards.ISIC31, "2221"), (Standards.ISIC4, "1811")),
        ((Standards.ISIC31, "2222"), (Standards.ISIC4, "1812")),
        ((Standards.ISIC31, "2230"), (Standards.ISIC4, "1820")),
        ((Standards.ISIC31, "2310"), (Standards.ISIC4, "1910")),
        ((Standards.ISIC31, "2320"), (Standards.ISIC4, "1920")),
        ((Standards.ISIC31, "2330"), (Standards.ISIC4, "2011")),
        ((Standards.ISIC31, "2330"), (Standards.ISIC4, "2100")),
        ((Standards.ISIC31, "2330"), (Standards.ISIC4, "2420")),
        ((Standards.ISIC31, "2330"), (Standards.ISIC4, "3812")),
        ((Standards.ISIC31, "2330"), (Standards.ISIC4, "3822")),
        ((Standards.ISIC31, "2411"), (Standards.ISIC4, "1910")),
        ((Standards.ISIC31, "2411"), (Standards.ISIC4, "2011")),
        ((Standards.ISIC31, "2412"), (Standards.ISIC4, "2012")),
        ((Standards.ISIC31, "2412"), (Standards.ISIC4, "3821")),
        ((Standards.ISIC31, "2413"), (Standards.ISIC4, "2013")),
        ((Standards.ISIC31, "2421"), (Standards.ISIC4, "2021")),
        ((Standards.ISIC31, "2422"), (Standards.ISIC4, "2022")),
        ((Standards.ISIC31, "2423"), (Standards.ISIC4, "2100")),
        ((Standards.ISIC31, "2423"), (Standards.ISIC4, "3250")),
        ((Standards.ISIC31, "2424"), (Standards.ISIC4, "2023")),
        ((Standards.ISIC31, "2429"), (Standards.ISIC4, "1079")),
        ((Standards.ISIC31, "2429"), (Standards.ISIC4, "2011")),
        ((Standards.ISIC31, "2429"), (Standards.ISIC4, "2029")),
        ((Standards.ISIC31, "2429"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "2429"), (Standards.ISIC4, "2680")),
        ((Standards.ISIC31, "2429"), (Standards.ISIC4, "2817")),
        ((Standards.ISIC31, "2430"), (Standards.ISIC4, "2030")),
        ((Standards.ISIC31, "2511"), (Standards.ISIC4, "2211")),
        ((Standards.ISIC31, "2519"), (Standards.ISIC4, "2219")),
        ((Standards.ISIC31, "2519"), (Standards.ISIC4, "2220")),
        ((Standards.ISIC31, "2519"), (Standards.ISIC4, "2812")),
        ((Standards.ISIC31, "2519"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "2519"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "2520"), (Standards.ISIC4, "2220")),
        ((Standards.ISIC31, "2520"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "2520"), (Standards.ISIC4, "2733")),
        ((Standards.ISIC31, "2520"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "2520"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "2520"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "2610"), (Standards.ISIC4, "2310")),
        ((Standards.ISIC31, "2610"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "2691"), (Standards.ISIC4, "2392")),
        ((Standards.ISIC31, "2691"), (Standards.ISIC4, "2393")),
        ((Standards.ISIC31, "2692"), (Standards.ISIC4, "2391")),
        ((Standards.ISIC31, "2693"), (Standards.ISIC4, "2392")),
        ((Standards.ISIC31, "2694"), (Standards.ISIC4, "2394")),
        ((Standards.ISIC31, "2695"), (Standards.ISIC4, "2395")),
        ((Standards.ISIC31, "2696"), (Standards.ISIC4, "2396")),
        ((Standards.ISIC31, "2699"), (Standards.ISIC4, "1312")),
        ((Standards.ISIC31, "2699"), (Standards.ISIC4, "2399")),
        ((Standards.ISIC31, "2699"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "2699"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "2710"), (Standards.ISIC4, "2410")),
        ((Standards.ISIC31, "2710"), (Standards.ISIC4, "2431")),
        ((Standards.ISIC31, "2720"), (Standards.ISIC4, "2420")),
        ((Standards.ISIC31, "2731"), (Standards.ISIC4, "2431")),
        ((Standards.ISIC31, "2732"), (Standards.ISIC4, "2432")),
        ((Standards.ISIC31, "2811"), (Standards.ISIC4, "2511")),
        ((Standards.ISIC31, "2811"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2812"), (Standards.ISIC4, "2512")),
        ((Standards.ISIC31, "2812"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2813"), (Standards.ISIC4, "2513")),
        ((Standards.ISIC31, "2813"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2813"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2891"), (Standards.ISIC4, "2591")),
        ((Standards.ISIC31, "2892"), (Standards.ISIC4, "0162")),
        ((Standards.ISIC31, "2892"), (Standards.ISIC4, "1811")),
        ((Standards.ISIC31, "2892"), (Standards.ISIC4, "2592")),
        ((Standards.ISIC31, "2892"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2893"), (Standards.ISIC4, "2593")),
        ((Standards.ISIC31, "2893"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2899"), (Standards.ISIC4, "2599")),
        ((Standards.ISIC31, "2899"), (Standards.ISIC4, "2817")),
        ((Standards.ISIC31, "2899"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "2899"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2911"), (Standards.ISIC4, "2811")),
        ((Standards.ISIC31, "2911"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2911"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2912"), (Standards.ISIC4, "2811")),
        ((Standards.ISIC31, "2912"), (Standards.ISIC4, "2812")),
        ((Standards.ISIC31, "2912"), (Standards.ISIC4, "2813")),
        ((Standards.ISIC31, "2912"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2912"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2913"), (Standards.ISIC4, "2812")),
        ((Standards.ISIC31, "2913"), (Standards.ISIC4, "2814")),
        ((Standards.ISIC31, "2913"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2914"), (Standards.ISIC4, "2815")),
        ((Standards.ISIC31, "2914"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2914"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2915"), (Standards.ISIC4, "2816")),
        ((Standards.ISIC31, "2915"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2915"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2919"), (Standards.ISIC4, "2819")),
        ((Standards.ISIC31, "2919"), (Standards.ISIC4, "3250")),
        ((Standards.ISIC31, "2919"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2919"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2921"), (Standards.ISIC4, "2821")),
        ((Standards.ISIC31, "2921"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2921"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2922"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "2922"), (Standards.ISIC4, "2818")),
        ((Standards.ISIC31, "2922"), (Standards.ISIC4, "2819")),
        ((Standards.ISIC31, "2922"), (Standards.ISIC4, "2822")),
        ((Standards.ISIC31, "2922"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2922"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "2922"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2923"), (Standards.ISIC4, "2823")),
        ((Standards.ISIC31, "2923"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2923"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2924"), (Standards.ISIC4, "2824")),
        ((Standards.ISIC31, "2924"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2924"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2925"), (Standards.ISIC4, "2825")),
        ((Standards.ISIC31, "2925"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2925"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2926"), (Standards.ISIC4, "2826")),
        ((Standards.ISIC31, "2926"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2926"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2927"), (Standards.ISIC4, "2520")),
        ((Standards.ISIC31, "2927"), (Standards.ISIC4, "3030")),
        ((Standards.ISIC31, "2927"), (Standards.ISIC4, "3040")),
        ((Standards.ISIC31, "2927"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "2593")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "2826")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "2829")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "2929"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "2930"), (Standards.ISIC4, "2750")),
        ((Standards.ISIC31, "2930"), (Standards.ISIC4, "2815")),
        ((Standards.ISIC31, "2930"), (Standards.ISIC4, "2819")),
        ((Standards.ISIC31, "3000"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "3000"), (Standards.ISIC4, "2620")),
        ((Standards.ISIC31, "3000"), (Standards.ISIC4, "2817")),
        ((Standards.ISIC31, "3000"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "3110"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "3110"), (Standards.ISIC4, "2710")),
        ((Standards.ISIC31, "3110"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "3110"), (Standards.ISIC4, "2811")),
        ((Standards.ISIC31, "3110"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "3110"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "3110"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "3120"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "3120"), (Standards.ISIC4, "2710")),
        ((Standards.ISIC31, "3120"), (Standards.ISIC4, "2733")),
        ((Standards.ISIC31, "3120"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "3120"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "3130"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "3130"), (Standards.ISIC4, "2731")),
        ((Standards.ISIC31, "3130"), (Standards.ISIC4, "2732")),
        ((Standards.ISIC31, "3130"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "3130"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "3140"), (Standards.ISIC4, "2720")),
        ((Standards.ISIC31, "3140"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "3150"), (Standards.ISIC4, "2740")),
        ((Standards.ISIC31, "3150"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "3150"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2599")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2630")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2651")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2733")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2740")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2822")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "2930")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "3020")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "3190"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "3210"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "3210"), (Standards.ISIC4, "2790")),
        ((Standards.ISIC31, "3210"), (Standards.ISIC4, "3314")),
        ((Standards.ISIC31, "3220"), (Standards.ISIC4, "2630")),
        ((Standards.ISIC31, "3220"), (Standards.ISIC4, "2651")),
        ((Standards.ISIC31, "3220"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "3220"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "3220"), (Standards.ISIC4, "9512")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "2610")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "2630")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "2640")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "2670")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "2817")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "3230"), (Standards.ISIC4, "9521")),
        ((Standards.ISIC31, "3311"), (Standards.ISIC4, "2660")),
        ((Standards.ISIC31, "3311"), (Standards.ISIC4, "3250")),
        ((Standards.ISIC31, "3311"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "3311"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "3311"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "3311"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "3312"), (Standards.ISIC4, "2651")),
        ((Standards.ISIC31, "3312"), (Standards.ISIC4, "2670")),
        ((Standards.ISIC31, "3312"), (Standards.ISIC4, "2819")),
        ((Standards.ISIC31, "3312"), (Standards.ISIC4, "2829")),
        ((Standards.ISIC31, "3312"), (Standards.ISIC4, "3250")),
        ((Standards.ISIC31, "3312"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "3312"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "3313"), (Standards.ISIC4, "2651")),
        ((Standards.ISIC31, "3313"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "3313"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "3320"), (Standards.ISIC4, "2670")),
        ((Standards.ISIC31, "3320"), (Standards.ISIC4, "2731")),
        ((Standards.ISIC31, "3320"), (Standards.ISIC4, "2829")),
        ((Standards.ISIC31, "3320"), (Standards.ISIC4, "3250")),
        ((Standards.ISIC31, "3320"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "3330"), (Standards.ISIC4, "2652")),
        ((Standards.ISIC31, "3330"), (Standards.ISIC4, "3211")),
        ((Standards.ISIC31, "3330"), (Standards.ISIC4, "3212")),
        ((Standards.ISIC31, "3330"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "3410"), (Standards.ISIC4, "2910")),
        ((Standards.ISIC31, "3420"), (Standards.ISIC4, "2920")),
        ((Standards.ISIC31, "3420"), (Standards.ISIC4, "3311")),
        ((Standards.ISIC31, "3430"), (Standards.ISIC4, "1392")),
        ((Standards.ISIC31, "3430"), (Standards.ISIC4, "2811")),
        ((Standards.ISIC31, "3430"), (Standards.ISIC4, "2930")),
        ((Standards.ISIC31, "3511"), (Standards.ISIC4, "3011")),
        ((Standards.ISIC31, "3511"), (Standards.ISIC4, "3315")),
        ((Standards.ISIC31, "3512"), (Standards.ISIC4, "3012")),
        ((Standards.ISIC31, "3512"), (Standards.ISIC4, "3315")),
        ((Standards.ISIC31, "3520"), (Standards.ISIC4, "3020")),
        ((Standards.ISIC31, "3520"), (Standards.ISIC4, "3315")),
        ((Standards.ISIC31, "3530"), (Standards.ISIC4, "2811")),
        ((Standards.ISIC31, "3530"), (Standards.ISIC4, "2829")),
        ((Standards.ISIC31, "3530"), (Standards.ISIC4, "3030")),
        ((Standards.ISIC31, "3530"), (Standards.ISIC4, "3315")),
        ((Standards.ISIC31, "3591"), (Standards.ISIC4, "2811")),
        ((Standards.ISIC31, "3591"), (Standards.ISIC4, "3091")),
        ((Standards.ISIC31, "3592"), (Standards.ISIC4, "3092")),
        ((Standards.ISIC31, "3599"), (Standards.ISIC4, "2816")),
        ((Standards.ISIC31, "3599"), (Standards.ISIC4, "3099")),
        ((Standards.ISIC31, "3599"), (Standards.ISIC4, "3100")),
        ((Standards.ISIC31, "3599"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "3599"), (Standards.ISIC4, "3315")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "2219")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "2220")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "2817")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "2930")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "3011")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "3020")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "3030")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "3100")),
        ((Standards.ISIC31, "3610"), (Standards.ISIC4, "9524")),
        ((Standards.ISIC31, "3691"), (Standards.ISIC4, "3211")),
        ((Standards.ISIC31, "3692"), (Standards.ISIC4, "3220")),
        ((Standards.ISIC31, "3692"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "3693"), (Standards.ISIC4, "3230")),
        ((Standards.ISIC31, "3693"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "3694"), (Standards.ISIC4, "2640")),
        ((Standards.ISIC31, "3694"), (Standards.ISIC4, "2829")),
        ((Standards.ISIC31, "3694"), (Standards.ISIC4, "3240")),
        ((Standards.ISIC31, "3694"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "3694"), (Standards.ISIC4, "3319")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "1399")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "1512")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "1629")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "1709")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "2029")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "2219")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "2220")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "2599")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "2829")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "3092")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "3212")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "3290")),
        ((Standards.ISIC31, "3699"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "3710"), (Standards.ISIC4, "3830")),
        ((Standards.ISIC31, "3720"), (Standards.ISIC4, "3830")),
        ((Standards.ISIC31, "4010"), (Standards.ISIC4, "3510")),
        ((Standards.ISIC31, "4020"), (Standards.ISIC4, "3520")),
        ((Standards.ISIC31, "4030"), (Standards.ISIC4, "3530")),
        ((Standards.ISIC31, "4100"), (Standards.ISIC4, "3600")),
        ((Standards.ISIC31, "4510"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "4510"), (Standards.ISIC4, "3900")),
        ((Standards.ISIC31, "4510"), (Standards.ISIC4, "4311")),
        ((Standards.ISIC31, "4510"), (Standards.ISIC4, "4312")),
        ((Standards.ISIC31, "4520"), (Standards.ISIC4, "4100")),
        ((Standards.ISIC31, "4520"), (Standards.ISIC4, "4210")),
        ((Standards.ISIC31, "4520"), (Standards.ISIC4, "4220")),
        ((Standards.ISIC31, "4520"), (Standards.ISIC4, "4290")),
        ((Standards.ISIC31, "4520"), (Standards.ISIC4, "4390")),
        ((Standards.ISIC31, "4530"), (Standards.ISIC4, "4321")),
        ((Standards.ISIC31, "4530"), (Standards.ISIC4, "4322")),
        ((Standards.ISIC31, "4530"), (Standards.ISIC4, "4329")),
        ((Standards.ISIC31, "4530"), (Standards.ISIC4, "4330")),
        ((Standards.ISIC31, "4530"), (Standards.ISIC4, "4390")),
        ((Standards.ISIC31, "4540"), (Standards.ISIC4, "3320")),
        ((Standards.ISIC31, "4540"), (Standards.ISIC4, "4329")),
        ((Standards.ISIC31, "4540"), (Standards.ISIC4, "4330")),
        ((Standards.ISIC31, "4540"), (Standards.ISIC4, "4390")),
        ((Standards.ISIC31, "4550"), (Standards.ISIC4, "4312")),
        ((Standards.ISIC31, "4550"), (Standards.ISIC4, "4390")),
        ((Standards.ISIC31, "5010"), (Standards.ISIC4, "4510")),
        ((Standards.ISIC31, "5020"), (Standards.ISIC4, "4520")),
        ((Standards.ISIC31, "5020"), (Standards.ISIC4, "5221")),
        ((Standards.ISIC31, "5030"), (Standards.ISIC4, "4530")),
        ((Standards.ISIC31, "5040"), (Standards.ISIC4, "4540")),
        ((Standards.ISIC31, "5050"), (Standards.ISIC4, "4730")),
        ((Standards.ISIC31, "5110"), (Standards.ISIC4, "4610")),
        ((Standards.ISIC31, "5121"), (Standards.ISIC4, "4620")),
        ((Standards.ISIC31, "5122"), (Standards.ISIC4, "4630")),
        ((Standards.ISIC31, "5131"), (Standards.ISIC4, "4641")),
        ((Standards.ISIC31, "5139"), (Standards.ISIC4, "4649")),
        ((Standards.ISIC31, "5139"), (Standards.ISIC4, "4663")),
        ((Standards.ISIC31, "5141"), (Standards.ISIC4, "4661")),
        ((Standards.ISIC31, "5142"), (Standards.ISIC4, "4662")),
        ((Standards.ISIC31, "5143"), (Standards.ISIC4, "4663")),
        ((Standards.ISIC31, "5149"), (Standards.ISIC4, "4669")),
        ((Standards.ISIC31, "5151"), (Standards.ISIC4, "4651")),
        ((Standards.ISIC31, "5152"), (Standards.ISIC4, "4652")),
        ((Standards.ISIC31, "5159"), (Standards.ISIC4, "4653")),
        ((Standards.ISIC31, "5159"), (Standards.ISIC4, "4659")),
        ((Standards.ISIC31, "5190"), (Standards.ISIC4, "4690")),
        ((Standards.ISIC31, "5211"), (Standards.ISIC4, "4711")),
        ((Standards.ISIC31, "5219"), (Standards.ISIC4, "4719")),
        ((Standards.ISIC31, "5220"), (Standards.ISIC4, "4721")),
        ((Standards.ISIC31, "5220"), (Standards.ISIC4, "4722")),
        ((Standards.ISIC31, "5220"), (Standards.ISIC4, "4723")),
        ((Standards.ISIC31, "5231"), (Standards.ISIC4, "4772")),
        ((Standards.ISIC31, "5232"), (Standards.ISIC4, "4751")),
        ((Standards.ISIC31, "5232"), (Standards.ISIC4, "4771")),
        ((Standards.ISIC31, "5233"), (Standards.ISIC4, "4742")),
        ((Standards.ISIC31, "5233"), (Standards.ISIC4, "4753")),
        ((Standards.ISIC31, "5233"), (Standards.ISIC4, "4759")),
        ((Standards.ISIC31, "5233"), (Standards.ISIC4, "4762")),
        ((Standards.ISIC31, "5234"), (Standards.ISIC4, "4752")),
        ((Standards.ISIC31, "5239"), (Standards.ISIC4, "4741")),
        ((Standards.ISIC31, "5239"), (Standards.ISIC4, "4753")),
        ((Standards.ISIC31, "5239"), (Standards.ISIC4, "4761")),
        ((Standards.ISIC31, "5239"), (Standards.ISIC4, "4763")),
        ((Standards.ISIC31, "5239"), (Standards.ISIC4, "4764")),
        ((Standards.ISIC31, "5239"), (Standards.ISIC4, "4773")),
        ((Standards.ISIC31, "5240"), (Standards.ISIC4, "4774")),
        ((Standards.ISIC31, "5251"), (Standards.ISIC4, "4791")),
        ((Standards.ISIC31, "5252"), (Standards.ISIC4, "4781")),
        ((Standards.ISIC31, "5252"), (Standards.ISIC4, "4782")),
        ((Standards.ISIC31, "5252"), (Standards.ISIC4, "4789")),
        ((Standards.ISIC31, "5259"), (Standards.ISIC4, "4791")),
        ((Standards.ISIC31, "5259"), (Standards.ISIC4, "4799")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "3313")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "8020")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "9512")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "9521")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "9522")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "9523")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "9524")),
        ((Standards.ISIC31, "5260"), (Standards.ISIC4, "9529")),
        ((Standards.ISIC31, "5510"), (Standards.ISIC4, "5510")),
        ((Standards.ISIC31, "5510"), (Standards.ISIC4, "5520")),
        ((Standards.ISIC31, "5510"), (Standards.ISIC4, "5590")),
        ((Standards.ISIC31, "5520"), (Standards.ISIC4, "5610")),
        ((Standards.ISIC31, "5520"), (Standards.ISIC4, "5621")),
        ((Standards.ISIC31, "5520"), (Standards.ISIC4, "5629")),
        ((Standards.ISIC31, "5520"), (Standards.ISIC4, "5630")),
        ((Standards.ISIC31, "6010"), (Standards.ISIC4, "4911")),
        ((Standards.ISIC31, "6010"), (Standards.ISIC4, "4912")),
        ((Standards.ISIC31, "6010"), (Standards.ISIC4, "5221")),
        ((Standards.ISIC31, "6021"), (Standards.ISIC4, "4921")),
        ((Standards.ISIC31, "6021"), (Standards.ISIC4, "4922")),
        ((Standards.ISIC31, "6022"), (Standards.ISIC4, "4922")),
        ((Standards.ISIC31, "6023"), (Standards.ISIC4, "4923")),
        ((Standards.ISIC31, "6030"), (Standards.ISIC4, "4930")),
        ((Standards.ISIC31, "6110"), (Standards.ISIC4, "5011")),
        ((Standards.ISIC31, "6110"), (Standards.ISIC4, "5012")),
        ((Standards.ISIC31, "6120"), (Standards.ISIC4, "5021")),
        ((Standards.ISIC31, "6120"), (Standards.ISIC4, "5022")),
        ((Standards.ISIC31, "6210"), (Standards.ISIC4, "5110")),
        ((Standards.ISIC31, "6210"), (Standards.ISIC4, "5120")),
        ((Standards.ISIC31, "6220"), (Standards.ISIC4, "5110")),
        ((Standards.ISIC31, "6220"), (Standards.ISIC4, "5120")),
        ((Standards.ISIC31, "6301"), (Standards.ISIC4, "5224")),
        ((Standards.ISIC31, "6302"), (Standards.ISIC4, "5210")),
        ((Standards.ISIC31, "6303"), (Standards.ISIC4, "3315")),
        ((Standards.ISIC31, "6303"), (Standards.ISIC4, "5221")),
        ((Standards.ISIC31, "6303"), (Standards.ISIC4, "5222")),
        ((Standards.ISIC31, "6303"), (Standards.ISIC4, "5223")),
        ((Standards.ISIC31, "6304"), (Standards.ISIC4, "7911")),
        ((Standards.ISIC31, "6304"), (Standards.ISIC4, "7912")),
        ((Standards.ISIC31, "6304"), (Standards.ISIC4, "7990")),
        ((Standards.ISIC31, "6309"), (Standards.ISIC4, "5229")),
        ((Standards.ISIC31, "6309"), (Standards.ISIC4, "7490")),
        ((Standards.ISIC31, "6411"), (Standards.ISIC4, "5310")),
        ((Standards.ISIC31, "6411"), (Standards.ISIC4, "8219")),
        ((Standards.ISIC31, "6412"), (Standards.ISIC4, "5320")),
        ((Standards.ISIC31, "6420"), (Standards.ISIC4, "6110")),
        ((Standards.ISIC31, "6420"), (Standards.ISIC4, "6120")),
        ((Standards.ISIC31, "6420"), (Standards.ISIC4, "6130")),
        ((Standards.ISIC31, "6420"), (Standards.ISIC4, "6190")),
        ((Standards.ISIC31, "6511"), (Standards.ISIC4, "6411")),
        ((Standards.ISIC31, "6519"), (Standards.ISIC4, "6419")),
        ((Standards.ISIC31, "6591"), (Standards.ISIC4, "6491")),
        ((Standards.ISIC31, "6592"), (Standards.ISIC4, "6492")),
        ((Standards.ISIC31, "6592"), (Standards.ISIC4, "6499")),
        ((Standards.ISIC31, "6599"), (Standards.ISIC4, "6420")),
        ((Standards.ISIC31, "6599"), (Standards.ISIC4, "6430")),
        ((Standards.ISIC31, "6599"), (Standards.ISIC4, "6499")),
        ((Standards.ISIC31, "6599"), (Standards.ISIC4, "6619")),
        ((Standards.ISIC31, "6599"), (Standards.ISIC4, "7740")),
        ((Standards.ISIC31, "6599"), (Standards.ISIC4, "9499")),
        ((Standards.ISIC31, "6601"), (Standards.ISIC4, "6511")),
        ((Standards.ISIC31, "6601"), (Standards.ISIC4, "6520")),
        ((Standards.ISIC31, "6602"), (Standards.ISIC4, "6530")),
        ((Standards.ISIC31, "6602"), (Standards.ISIC4, "6630")),
        ((Standards.ISIC31, "6603"), (Standards.ISIC4, "6511")),
        ((Standards.ISIC31, "6603"), (Standards.ISIC4, "6512")),
        ((Standards.ISIC31, "6603"), (Standards.ISIC4, "6520")),
        ((Standards.ISIC31, "6711"), (Standards.ISIC4, "6611")),
        ((Standards.ISIC31, "6712"), (Standards.ISIC4, "6612")),
        ((Standards.ISIC31, "6712"), (Standards.ISIC4, "6630")),
        ((Standards.ISIC31, "6719"), (Standards.ISIC4, "6419")),
        ((Standards.ISIC31, "6719"), (Standards.ISIC4, "6612")),
        ((Standards.ISIC31, "6719"), (Standards.ISIC4, "6619")),
        ((Standards.ISIC31, "6720"), (Standards.ISIC4, "6621")),
        ((Standards.ISIC31, "6720"), (Standards.ISIC4, "6622")),
        ((Standards.ISIC31, "6720"), (Standards.ISIC4, "6629")),
        ((Standards.ISIC31, "7010"), (Standards.ISIC4, "4290")),
        ((Standards.ISIC31, "7010"), (Standards.ISIC4, "6810")),
        ((Standards.ISIC31, "7020"), (Standards.ISIC4, "6820")),
        ((Standards.ISIC31, "7020"), (Standards.ISIC4, "8110")),
        ((Standards.ISIC31, "7111"), (Standards.ISIC4, "7710")),
        ((Standards.ISIC31, "7111"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7112"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7113"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7121"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7122"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7123"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7129"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7130"), (Standards.ISIC4, "7721")),
        ((Standards.ISIC31, "7130"), (Standards.ISIC4, "7722")),
        ((Standards.ISIC31, "7130"), (Standards.ISIC4, "7729")),
        ((Standards.ISIC31, "7130"), (Standards.ISIC4, "7730")),
        ((Standards.ISIC31, "7210"), (Standards.ISIC4, "6202")),
        ((Standards.ISIC31, "7221"), (Standards.ISIC4, "5820")),
        ((Standards.ISIC31, "7229"), (Standards.ISIC4, "6201")),
        ((Standards.ISIC31, "7229"), (Standards.ISIC4, "6202")),
        ((Standards.ISIC31, "7230"), (Standards.ISIC4, "6202")),
        ((Standards.ISIC31, "7230"), (Standards.ISIC4, "6311")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "5811")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "5812")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "5813")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "5819")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "5820")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "5920")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "6010")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "6020")),
        ((Standards.ISIC31, "7240"), (Standards.ISIC4, "6312")),
        ((Standards.ISIC31, "7250"), (Standards.ISIC4, "3312")),
        ((Standards.ISIC31, "7250"), (Standards.ISIC4, "9511")),
        ((Standards.ISIC31, "7290"), (Standards.ISIC4, "6209")),
        ((Standards.ISIC31, "7310"), (Standards.ISIC4, "7210")),
        ((Standards.ISIC31, "7310"), (Standards.ISIC4, "7220")),
        ((Standards.ISIC31, "7320"), (Standards.ISIC4, "7220")),
        ((Standards.ISIC31, "7411"), (Standards.ISIC4, "6910")),
        ((Standards.ISIC31, "7412"), (Standards.ISIC4, "6920")),
        ((Standards.ISIC31, "7413"), (Standards.ISIC4, "7320")),
        ((Standards.ISIC31, "7414"), (Standards.ISIC4, "7010")),
        ((Standards.ISIC31, "7414"), (Standards.ISIC4, "7020")),
        ((Standards.ISIC31, "7414"), (Standards.ISIC4, "7490")),
        ((Standards.ISIC31, "7414"), (Standards.ISIC4, "8550")),
        ((Standards.ISIC31, "7421"), (Standards.ISIC4, "0910")),
        ((Standards.ISIC31, "7421"), (Standards.ISIC4, "0990")),
        ((Standards.ISIC31, "7421"), (Standards.ISIC4, "7110")),
        ((Standards.ISIC31, "7421"), (Standards.ISIC4, "7410")),
        ((Standards.ISIC31, "7421"), (Standards.ISIC4, "7490")),
        ((Standards.ISIC31, "7422"), (Standards.ISIC4, "7120")),
        ((Standards.ISIC31, "7430"), (Standards.ISIC4, "7310")),
        ((Standards.ISIC31, "7491"), (Standards.ISIC4, "7810")),
        ((Standards.ISIC31, "7491"), (Standards.ISIC4, "7820")),
        ((Standards.ISIC31, "7491"), (Standards.ISIC4, "7830")),
        ((Standards.ISIC31, "7492"), (Standards.ISIC4, "7490")),
        ((Standards.ISIC31, "7492"), (Standards.ISIC4, "8010")),
        ((Standards.ISIC31, "7492"), (Standards.ISIC4, "8020")),
        ((Standards.ISIC31, "7492"), (Standards.ISIC4, "8030")),
        ((Standards.ISIC31, "7493"), (Standards.ISIC4, "8121")),
        ((Standards.ISIC31, "7493"), (Standards.ISIC4, "8129")),
        ((Standards.ISIC31, "7494"), (Standards.ISIC4, "7420")),
        ((Standards.ISIC31, "7495"), (Standards.ISIC4, "8292")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "6399")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "7310")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "7410")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "7490")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "8211")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "8219")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "8220")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "8230")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "8291")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "8299")),
        ((Standards.ISIC31, "7499"), (Standards.ISIC4, "8550")),
        ((Standards.ISIC31, "7511"), (Standards.ISIC4, "8411")),
        ((Standards.ISIC31, "7512"), (Standards.ISIC4, "8412")),
        ((Standards.ISIC31, "7513"), (Standards.ISIC4, "7990")),
        ((Standards.ISIC31, "7513"), (Standards.ISIC4, "8413")),
        ((Standards.ISIC31, "7514"), (Standards.ISIC4, "6810")),
        ((Standards.ISIC31, "7514"), (Standards.ISIC4, "6820")),
        ((Standards.ISIC31, "7514"), (Standards.ISIC4, "8411")),
        ((Standards.ISIC31, "7514"), (Standards.ISIC4, "9101")),
        ((Standards.ISIC31, "7521"), (Standards.ISIC4, "8421")),
        ((Standards.ISIC31, "7521"), (Standards.ISIC4, "8890")),
        ((Standards.ISIC31, "7522"), (Standards.ISIC4, "8422")),
        ((Standards.ISIC31, "7523"), (Standards.ISIC4, "7120")),
        ((Standards.ISIC31, "7523"), (Standards.ISIC4, "8423")),
        ((Standards.ISIC31, "7530"), (Standards.ISIC4, "8430")),
        ((Standards.ISIC31, "8010"), (Standards.ISIC4, "8510")),
        ((Standards.ISIC31, "8021"), (Standards.ISIC4, "8521")),
        ((Standards.ISIC31, "8022"), (Standards.ISIC4, "8522")),
        ((Standards.ISIC31, "8030"), (Standards.ISIC4, "8530")),
        ((Standards.ISIC31, "8090"), (Standards.ISIC4, "8522")),
        ((Standards.ISIC31, "8090"), (Standards.ISIC4, "8542")),
        ((Standards.ISIC31, "8090"), (Standards.ISIC4, "8549")),
        ((Standards.ISIC31, "8511"), (Standards.ISIC4, "8610")),
        ((Standards.ISIC31, "8512"), (Standards.ISIC4, "8620")),
        ((Standards.ISIC31, "8519"), (Standards.ISIC4, "8690")),
        ((Standards.ISIC31, "8519"), (Standards.ISIC4, "8710")),
        ((Standards.ISIC31, "8519"), (Standards.ISIC4, "8720")),
        ((Standards.ISIC31, "8519"), (Standards.ISIC4, "8730")),
        ((Standards.ISIC31, "8520"), (Standards.ISIC4, "7500")),
        ((Standards.ISIC31, "8531"), (Standards.ISIC4, "8720")),
        ((Standards.ISIC31, "8531"), (Standards.ISIC4, "8730")),
        ((Standards.ISIC31, "8531"), (Standards.ISIC4, "8790")),
        ((Standards.ISIC31, "8532"), (Standards.ISIC4, "8550")),
        ((Standards.ISIC31, "8532"), (Standards.ISIC4, "8810")),
        ((Standards.ISIC31, "8532"), (Standards.ISIC4, "8890")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "3700")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "3811")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "3812")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "3821")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "3822")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "3900")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "8129")),
        ((Standards.ISIC31, "9000"), (Standards.ISIC4, "8130")),
        ((Standards.ISIC31, "9111"), (Standards.ISIC4, "9411")),
        ((Standards.ISIC31, "9112"), (Standards.ISIC4, "9412")),
        ((Standards.ISIC31, "9120"), (Standards.ISIC4, "9420")),
        ((Standards.ISIC31, "9191"), (Standards.ISIC4, "9491")),
        ((Standards.ISIC31, "9192"), (Standards.ISIC4, "9492")),
        ((Standards.ISIC31, "9199"), (Standards.ISIC4, "9499")),
        ((Standards.ISIC31, "9211"), (Standards.ISIC4, "5911")),
        ((Standards.ISIC31, "9211"), (Standards.ISIC4, "5912")),
        ((Standards.ISIC31, "9211"), (Standards.ISIC4, "5913")),
        ((Standards.ISIC31, "9211"), (Standards.ISIC4, "5920")),
        ((Standards.ISIC31, "9212"), (Standards.ISIC4, "5914")),
        ((Standards.ISIC31, "9213"), (Standards.ISIC4, "5911")),
        ((Standards.ISIC31, "9213"), (Standards.ISIC4, "5920")),
        ((Standards.ISIC31, "9213"), (Standards.ISIC4, "6010")),
        ((Standards.ISIC31, "9213"), (Standards.ISIC4, "6020")),
        ((Standards.ISIC31, "9214"), (Standards.ISIC4, "7990")),
        ((Standards.ISIC31, "9214"), (Standards.ISIC4, "9000")),
        ((Standards.ISIC31, "9219"), (Standards.ISIC4, "7990")),
        ((Standards.ISIC31, "9219"), (Standards.ISIC4, "8542")),
        ((Standards.ISIC31, "9219"), (Standards.ISIC4, "9000")),
        ((Standards.ISIC31, "9219"), (Standards.ISIC4, "9321")),
        ((Standards.ISIC31, "9219"), (Standards.ISIC4, "9329")),
        ((Standards.ISIC31, "9220"), (Standards.ISIC4, "6391")),
        ((Standards.ISIC31, "9220"), (Standards.ISIC4, "7420")),
        ((Standards.ISIC31, "9220"), (Standards.ISIC4, "9000")),
        ((Standards.ISIC31, "9231"), (Standards.ISIC4, "5912")),
        ((Standards.ISIC31, "9231"), (Standards.ISIC4, "9101")),
        ((Standards.ISIC31, "9232"), (Standards.ISIC4, "9102")),
        ((Standards.ISIC31, "9233"), (Standards.ISIC4, "9103")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "4922")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "7990")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "8541")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "8549")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "9311")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "9312")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "9319")),
        ((Standards.ISIC31, "9241"), (Standards.ISIC4, "9329")),
        ((Standards.ISIC31, "9249"), (Standards.ISIC4, "7810")),
        ((Standards.ISIC31, "9249"), (Standards.ISIC4, "9200")),
        ((Standards.ISIC31, "9249"), (Standards.ISIC4, "9329")),
        ((Standards.ISIC31, "9301"), (Standards.ISIC4, "9601")),
        ((Standards.ISIC31, "9302"), (Standards.ISIC4, "9602")),
        ((Standards.ISIC31, "9303"), (Standards.ISIC4, "9603")),
        ((Standards.ISIC31, "9309"), (Standards.ISIC4, "8541")),
        ((Standards.ISIC31, "9309"), (Standards.ISIC4, "9609")),
        ((Standards.ISIC31, "9500"), (Standards.ISIC4, "9700")),
        ((Standards.ISIC31, "9600"), (Standards.ISIC4, "9810")),
        ((Standards.ISIC31, "9700"), (Standards.ISIC4, "9820")),
        ((Standards.ISIC31, "9900"), (Standards.ISIC4, "9900")),
    ],
)
