define(["@jupyter-widgets/base","lodash","esri-loader","@lumino/widgets","@jupyterlab/apputils"],(function(e,t,o,i,n){return function(e){var t={};function o(i){if(t[i])return t[i].exports;var n=t[i]={i:i,l:!1,exports:{}};return e[i].call(n.exports,n,n.exports,o),n.l=!0,n.exports}return o.m=e,o.c=t,o.d=function(e,t,i){o.o(e,t)||Object.defineProperty(e,t,{enumerable:!0,get:i})},o.r=function(e){"undefined"!=typeof Symbol&&Symbol.toStringTag&&Object.defineProperty(e,Symbol.toStringTag,{value:"Module"}),Object.defineProperty(e,"__esModule",{value:!0})},o.t=function(e,t){if(1&t&&(e=o(e)),8&t)return e;if(4&t&&"object"==typeof e&&e&&e.__esModule)return e;var i=Object.create(null);if(o.r(i),Object.defineProperty(i,"default",{enumerable:!0,value:e}),2&t&&"string"!=typeof e)for(var n in e)o.d(i,n,function(t){return e[t]}.bind(null,n));return i},o.n=function(e){var t=e&&e.__esModule?function(){return e.default}:function(){return e};return o.d(t,"a",t),t},o.o=function(e,t){return Object.prototype.hasOwnProperty.call(e,t)},o.p="",o(o.s=9)}([function(e,t,o){var i=o(14),n=o(7);i.JSOutputContext="default",i.JupyterTarget="lab",n(i,i.CdnUrl),e.exports=i},function(e,t,o){var i=o(17),n=o(18);e.exports=function(e){if(e.JupyterTarget){if("lab"===e.JupyterTarget)return i;if("notebook"===e.JupyterTarget)return n;throw"Misconfigured config file! Failing"}throw"config does not specify 'JupyterTarget'! Failing"}},function(t,o){t.exports=e},function(e,t){e.exports={sceneToMapEncoded:" data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcHFAkxI5xEXwAAAuxJREFUWMPt10toXVUUBuAvpjSiYJKBxdMWiohIIahsEBKwgwwKFUrxBba2A/GBgsjGKkSpYBEHKjjYWIqiIChoW3wg1gbEF2RgrtUNSilIdSLChZY2TSFKNaFOduVyuDe5iQkqdM3OZp+1/v3/6/xrHy7Fvxw97RZDCKvxEHZhALM4g4N4I+f8x3IBuKxN8fX4DL04iQfxAe7DtdgfQli7XAB6a8X7cAQRvyDgcvyMVWXbPrxcVdXhZrM5t9wMPIw5jOFuvJRzfhGHMIqBnPMpfFiY+cexqva8q5zwo5zzdMv6IXyFmRDCID7Bp9gfYzzQJu9ISmnDUgBcgVvwJaaLLLfjhgJgLQ7gSWyAlNL2etIOoLoC0ItnsQdPhBA24m1cl3M+2dIrt2JwJSQ4V1joDSFswjU4hZnavptxfCU+w3ewG09hO97DOL4IIYyHEAbKvtHCTCvtT8cYN9XWBmKMryyGgVcxWTSezDlfwKOF9rcwG0IYKvq/Xnv3BTweY7xYfLDI+UzXPtBsNueqqhrHc+irqup4s9k8A1VV3V8ccQw7cs5Tre82Gg2NRuPr4eHhbdhaGnZvSuncUqy4D49gZ7HiafyG9/Fazvn8fEljjPfgcEpp5v85jGqnuRJbU0oHO7B1HicWSLMOU4XF63POfZ2asF78qtJIt8UYr04p7Wuz7UTOeahTjhDCA0XKO3LO0yGEY/NOw5bi/aUZn8cP+D7GuDvG2NMtvcXI7sTmmrUvDKAU3ptSmiqWO4GjxSO6jVG8m3Oe69YH/o6U0mNt1iYw0eXp1xcPuXFRF5LliBBCL7bg4/lOv2ATLrJoD3bgG3yHXzGy2GHUKUbajdjaKF5X7PhoATKJP0MIW3BXcdCzSwLQ5eViM9bg25zzkcLKGLbhxzI9V6N/RSTIOb8ZQui/mLNIcm/O+aaaTD+tZBM2sbNc6/fg8xrIC/h9JQGcLf8PsziNjeVzXPos6KL7jy1BrqFL/4T/mfgLBbP14SVdyAQAAAAASUVORK5CYII=",mapToSceneEncoded:" data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcHFAg1PeqxBwAAAuBJREFUWMPt10+IlWUUBvDfNMMYBc7MproZuCgJQTIOCHcgwRaGiyirgTLdZRRY9JGBRVKWLSxQ3kVEURAklAoRorkIimBaXMzeVURhbSS4kDTOFBaag23e4HKZP99cZ6jAs3v/fed5zznv85yPq/YvW1/nICIu4PQ8Z1bgHP7AqpzzsisBMNA1Pp1zXjPb5oh4DFvxQM55KiK+vdIIDNTdGBGr8SA25pynFysF1yxg7934aDGd145ARNyCHbhjsYtwoIbzfmzCsdluX1XVoRmmR1NKK3sCEBF92IKT+AY/Y3S2j6SUHqkJqnYEVmAfvi5AWvgrIjbhIezC5FKmYCNuwKmc84kSlV24Dz/gOwxiaEkA5Jzfj4ihf9ZLSh7NOa/tStOPXWF/AV+llMY75oaxN6X09EKfYRtbI2IQL+LzLpCX8WfXmX1YV1XV+uJ8BHuwuxcemMQELuFXrC7P0RzFeDmldABry5PdjZdSSlN1tWDB1DobdVdV9TCOp5TO/3/UcDarqup63JtSOjwPaQ3icWzDcEnfBA7jvZzzxe4z/TWcL8cr2N5sNvtardbJOej6KL7HjYUrLpYivAdjjUbjVLvd/r02gKqqhvAq9mIdjjWbzbFms9lqtVqdzpfhBJ7BGQSuxU8dT/1N7G80Gsfb7fZ0XTV8DXtSSudKlY8Xdny+a98TmC63HsMbOefXcaSo6HDO+Sw+wfbaYjQTeRQQ413T28oNj+acO5/cEXyJ8xExgk/xGd7qpR+Yy64rKVrekZbNuL0Mb8YhrMLKnjqieawfLxfG3Fm6p4O4Nef8SweouzDSK4DRmSS2SPFvJQr9EbEeN+EsuknoziJkCwcwT3PxIZ4txbkfT2EDvoiICWzJOU+Wgjy4FCl4u/QMz6FVhGpHCfsHuBQRa0r+3+21KZ1LDy7g/tKsbIiI2zqWR8raAWzuZsO+xeT1QkhPln+HYUyVH5iP8U4BetX+W/Y3rHL2yx0HDBIAAAAASUVORK5CYII=",toNewWindowEncoded:"  data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcUAAIIxu7mQQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABI0lEQVRYw+1Wy3GDMBTch3JLBanA+TQR0gDz4JB0Y1xISkBAA4EqHOeYU6qAzYVkPAyWYSLii/Ymzb63q89qBAQEXBgyNamquYhs5zSw1v72SNOUp3gkd2VZ5uP5K1dzkrslqxnzRWQD4MVV4zQw5XguP8uyDckGwBeAm1M10Rrnqqq3fd+3JEVEYhc3WkMcQDMM46IoPv7NQJIkdyLS/oiXZXk4VxP5FDfGNEvEz17Cuciy7J7kGwB0XRfXdX0Yp+NoZ/waGMQbABzE35ekKfIkDhF5mhJf7Q6o6sOReFwUxd7BzdM0ffR5BALglaQAiK21eydZZEsSAFpfBkjy2Rhz7Vr5qimoqurTR4JWeYqDgWDAWwpUNb+ogbn/woCAgL/gG9knfWwKBGcvAAAAAElFTkSuQmC",toOriginalWindowEncoded:"data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcUAAYsnoHHlAAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABG0lEQVRYw+2WMVLDMBBF/9q+BBUlAS5hn8BeqQk1B8HcBgpLowtgnyJwGWtTkFAEOzIgkmHQLzXjeW9nV2sBKSn/PTR1yMwtET3EBInIo7W2PTwvQh9FqfJIMUcFpoy/E6XUrEB27hlIAkngxwJa65umaS7PIsDMt977gYie55ZaKMXM4hhEJFi5iLy87yu5ByDRBIwxA4AhAO93spUxZnOyFtR1fb2rHERUdV23iT6ESqmSmdspeJ7nfSz4rICIlIc/EGZe7eHjOEaBL24BM68AfMCdc6+x9kDxFbiIlM65t5MtIq311R4OoLLWRoUHBUSkJyLJsqz8DfiSFlwAePLe3zHz5ENl6rZEnQEAa6JPW7Zd8txKSfkT2QKASXQbvOVu9AAAAABJRU5ErkJggg==",screenshotErrorEncoded:"data:image/png;base64,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"}},function(e,t){e.exports=require("lodash")},function(e){e.exports=JSON.parse('{"name":"arcgis-map-ipywidget","version":"1.8.5","description":"The map widget for the ArcGIS API for Python","homepage":"https://github.com/Esri/arcgis-python-api","author":"esri","license":"SEE LICENSE IN license.txt","main":"dist/index.js","scripts":{"clean":"rimraf dist/","prepublish":"webpack --config webpack.jupyter.lab.js --mode=development","build:notebook":"webpack --config webpack.jupyter.notebook.js --mode=development","build:lab":"webpack --config webpack.jupyter.lab.js --mode=development","build:prod":"webpack --config webpack.jupyter.notebook.js && webpack --config webpack.jupyter.lab.js","test":"echo \\"Error: no test specified\\" && exit 1","prepublishOnly":"webpack --config webpack.jupyter.notebook.js && webpack --config webpack.jupyter.lab.js"},"devDependencies":{"css-loader":"^1.0.0","file-loader":"^6.0.0","rimraf":"^2.6.1","style-loader":"^0.21.0","to-string-loader":"^1.1.5","ts-loader":"^4.3.0","typescript":"^3.9.7","webpack":"^4.41.0","webpack-cli":"^3.3.11","webpack-merge":"^4.2.2","webpack-node-externals":"^2.5.0"},"dependencies":{"@jupyter-widgets/base":"^3","@jupyterlab/application":"^2","@lumino/widgets":"^1.13.2","esri-loader":"^2.3.0","lodash":"^4.17.4"},"jupyterlab":{"extension":"dist/arcgis-map-ipywidget-jupyterlab"},"keywords":["jupyter","jupyterlab","jupyterlab-extension"]}')},function(e,t){var o=0,i=[],n=document.createElement("div");n.id="loadingTextDiv",n.style.textAlign="center",n.style.verticalAlign="text-top";var r=function(){o++%4==0?n.textContent=" Loading ":n.textContent="🗺️"+n.textContent+"🗺️"};e.exports={start:function(){n.textContent=" Loading ",0===i.length&&i.push(setInterval(r,700))},stop:function(){for(;null!=(id=i.pop());)clearInterval(id);n.textContent=""},element:n}},function(e,t){e.exports=function(e,t){if(e.CdnUrl=t,e.EsriLoaderOptions.url=e.CdnUrl,"notebook"===e.JupyterTarget)e.BaseRequireJSConfig.packages=[{name:"esri",location:e.CdnUrl+"esri"},{name:"dojo",location:e.CdnUrl+"dojo"},{name:"dojox",location:e.CdnUrl+"dojox"},{name:"dijit",location:e.CdnUrl+"dijit"},{name:"dstore",location:e.CdnUrl+"dstore"},{name:"moment",location:e.CdnUrl+"moment"},{name:"@dojo",location:e.CdnUrl+"@dojo"},{name:"cldrjs",location:e.CdnUrl+"cldrjs",main:"dist/cldr"},{name:"globalize",location:e.CdnUrl+"globalize",main:"dist/globalize"},{name:"maquette",location:e.CdnUrl+"maquette",main:"dist/maquette.umd"},{name:"maquette-css-transitions",location:e.CdnUrl+"maquette-css-transitions",main:"dist/maquette-css-transitions.umd"},{name:"maquette-jsx",location:e.CdnUrl+"maquette-jsx",main:"dist/maquette-jsx.umd"},{name:"tslib",location:e.CdnUrl+"tslib",main:"tslib"}],window.require&&(window.customRequire=window.require.config(e.BaseRequireJSConfig));else if("lab"===e.JupyterTarget){var o=document.querySelector("script[data-esri-loader]");null!=o&&o.parentNode.removeChild(o)}}},function(e,t){var o=function(e){return/.*class.*size.*/i.test(e)},i=function(e){return/.*class.*color.*/i.test(e)};e.exports={isSmartMapRenderer:function(e){return o(e)||i(e)},isHeatMapRenderer:function(e){return/.*heat.*/i.test(e)},isClassedColorRenderer:i,isClassBreaksRenderer:function(e){return/.*class.*break.*/i.test(e)},isClassedSizeRenderer:o,isSimpleRenderer:function(e){return/.*simple.*/i.test(e)},isUniqueRenderer:function(e){return/.*unique.*/i.test(e)},isDotDensityRenderer:function(e){return/.*dot.*density.*/i.test(e)},userSpecifiedAutocastRenderer:function(e){return/.*auto.*cast.*/i.test(e)}}},function(e,t,o){"use strict";var i,n=this&&this.__extends||(i=function(e,t){return(i=Object.setPrototypeOf||{__proto__:[]}instanceof Array&&function(e,t){e.__proto__=t}||function(e,t){for(var o in t)t.hasOwnProperty(o)&&(e[o]=t[o])})(e,t)},function(e,t){function o(){this.constructor=e}i(e,t),e.prototype=null===t?Object.create(t):(o.prototype=t.prototype,new o)});t.__esModule=!0;var r=o(2),a=o(10),s=o(5),l=o(25),d=o(3),c=o(26),h=function(e){function t(t,o){var i=e.call(this)||this;return i.ipywidgetElement=t,i.originalParentElement=t.parentElement,i.originalParentElement.removeChild(t),i.node.appendChild(t),i.id="ipywidget-external-window-container-"+Math.random().toString(36).substring(7),i.title.label=o,i.title.closable=!0,i.addClass("IPythonExtensionWidgetContainer"),i}return n(t,e),t.prototype.restoreToOriginalParentElement=function(e){var t=this;for(this.originalParentElement.appendChild(this.ipywidgetElement);this.node.hasChildNodes();)this.node.removeChild(this.node.lastChild);this.mapForAllChildrenOfIPyWidgetElement((function(e){e.id&&/.*new.*window/i.test(e.id)&&(e.src=d.toNewWindowEncoded,t.ipywidgetElement.style.height=t.ipywidgetElement.prevElementHeight)}))},t.prototype.mapForAllChildrenOfIPyWidgetElement=function(e){var t=function(o){for(var i=0;i<o.childElementCount;i++){var n=o.childNodes[i];t(n),e(n)}};t(this.ipywidgetElement)},t}(l.Widget),g={id:"arcgis-map-ipywidget",autoStart:!0,requires:[c.ICommandPalette,r.IJupyterWidgetRegistry],activate:function(e,t,o){var i=e.commands,n=e.shell;o.registerWidget({name:"arcgis-map-ipywidget",version:s.version,exports:{ArcGISMapIPyWidgetModel:a.ArcGISMapIPyWidgetModel,ArcGISMapIPyWidgetView:a.ArcGISMapIPyWidgetView}});i.addCommand("arcgis-map-ipywidget:new-window",{label:"Move Existing ArcGIS Map IPyWidget to Seperate Window",caption:"",execute:function(t){if("element"in t){console.log("Attempting to create new window with these args:"),console.log(t);var o=new h(t.element,t.title);n.activateById(o.id),"auto"===t.tab_mode?r(e,o):n.add(o,"main",{mode:t.tab_mode})}else alert("Do not call this command from the command window UI, it is called indirectly on the Python ipywidget instance.")}}),t.addItem({command:"arcgis-map-ipywidget:new-window",category:"ArcGIS Map IPywidget"}),window.newJLabWindow=function(t){e.commands.execute("arcgis-map-ipywidget:new-window",t)};i.addCommand("arcgis-map-ipywidget:close-window",{label:"Close Existing ArcGIS Map IPyWidget to Original Location",caption:"",execute:function(e){if("element"in e){console.log("Attempting to close window with these args:"),console.log(e);var t=l();for(var o in t){var i=t[o];if(null!=i.node)for(var n in i.node.children){if(i.node.children[n].id==e.element.id){i.restoreToOriginalParentElement(),i.close();break}}}}else alert("Do not call this command from the command window UI, it is called indirectly on the Python ipywidget instance.")}}),t.addItem({command:"arcgis-map-ipywidget:close-window",category:"ArcGIS Map IPywidget"}),window.closeJLabWindow=function(t){e.commands.execute("arcgis-map-ipywidget:close-window",t)};var r=function(e,t){try{for(var o=0,i=e.shell.widgets("main");i.next();)o++;var n=o-e.shell._currentTabBar().titles.length+1;console.log("Attempting to autoplace widget among "+n+" other active widgets."),n<=1?e.shell.add(t,"main",{mode:"split-right"}):e.shell.add(t,"main",{mode:"tab-after"})}catch(o){console.log("Unhandled error while 'auto' mode of placing tabs. Just adding this widget in 'tab-after' mode"),console.log(o),e.shell.add(t,"main",{mode:"tab-after"})}},l=function(){var t=[],o=["main","left","right","top","bottom"];for(var i in o){var n=o[i];try{for(var r,a=e.shell.widgets(n);r=a.next();)t.push(r)}catch(e){}}return t}}};t.default=g},function(e,t,o){ArcGISMapIPyWidgetModel=o(11),ArcGISMapIPyWidgetView=o(12),e.exports={ArcGISMapIPyWidgetModel:ArcGISMapIPyWidgetModel,ArcGISMapIPyWidgetView:ArcGISMapIPyWidgetView}},function(e,t,o){const i=o(2),n=o(4),r=o(5).version;var a=i.DOMWidgetModel.extend({defaults:n.extend(i.DOMWidgetModel.prototype.defaults(),{_model_name:"ArcGISMapIPyWidgetModel",_view_name:"ArcGISMapIPyWidgetView",_model_module:"arcgis-map-ipywidget",_view_module:"arcgis-map-ipywidget",_model_module_version:r,_view_module_version:r,value:"From Scene Model",_basemap:"topo",_gallery_basemaps:{},mode:"2D",_zoom:-1,_readonly_zoom:-1,_scale:-1,_snap_to_zoom:!0,_readonly_scale:-1,_rotation:0,_readonly_rotation:0,_link_writeonly_rotation:0,_heading:0,_readonly_heading:0,_link_writeonly_heading:0,_tilt:0,_readonly_tilt:0,_link_writeonly_tilt:0,_extent:{},_readonly_extent:{},_link_writeonly_extent:{},_center:{},_readonly_center:{},_center_long_lat:[],_func_chains:[],_add_this_notype_layer:{},_readonly_notype_layers:{},_draw_these_notype_layers_on_widget_load:{},_layers_to_remove:[],_add_this_graphic:{},_draw_these_graphics_on_widget_load:{},_webmap:{},_webscene:{},_trigger_webscene_save_to_this_portal_id:"",_readonly_webmap_from_js:{},_preview_screenshot_callback_resp:"",_cell_output_screenshot_callback_resp:"",_file_output_screenshot_callback_resp:"",_trigger_screenshot_with_args:{},_overlay_this_image:{},_overlay_these_images_on_widget_load:{},_image_overlays_to_remove:[],time_slider:!1,time_mode:"time-window",_time_info:{},_writeonly_start_time:"",_readonly_start_time:"",_writeonly_end_time:"",_readonly_end_time:"",_portal_token:"",_auth_mode:"",_portal_url:"",_portal_sharing_rest_url:"",_username:"",_custom_msg:"",hide_mode_switch:!1,_trigger_interactive_draw_mode_for:"",_trigger_new_jlab_window_with_args:{},jupyter_target:"",ready:!1,tab_mode:"auto",_js_cdn_override:"",legend:!1,_uuid:"",_trigger_print_js_debug_info:""})});e.exports=a},function(e,t,o){const i=o(2);o(4);var n=o(13),r=o(15),a=o(6),s=o(16),l=o(21),d=o(3),c=o(22).toString(),h=o(7),g=o(0),m=o(1)(g),p=g.EsriLoaderOptions;console.log("Using this config:"),console.log(g);var _,u;_=c,(u=document.createElement("style")).innerHTML=_,document.head.appendChild(u);!function(e){var t=document.createElement("link");t.rel="stylesheet",t.href=e,document.head.appendChild(t)}(g.CdnMainCssUrl);var w={},y=i.DOMWidgetView.extend({render:function(){this._override_right_click_menu(),this._setup_js_cdn(),this._setup_elements(),this.model.set("jupyter_target",g.JupyterTarget),a.start(),m.loadModules(["esri/Map","esri/views/MapView","esri/WebMap","esri/WebScene","esri/views/SceneView","esri/core/watchUtils","esri/widgets/Compass","esri/widgets/Legend","esri/widgets/TimeSlider"],p).then(([e,t,o,i,n,r,s,l,d])=>{a.stop(),this._setup_custom_buttons(),this._instantiate_esri_components(e,o,i,t,n,s,l,d),this._miscellanous_setup(),this.model.on("change:mode",this.mode_changed,this),this.model.on("change:_basemap",this.basemap_changed,this),this.model.on("change:_zoom",this.zoom_changed,this),this.model.on("change:_scale",this.scale_changed,this),this.model.on("change:_snap_to_zoom",this.snap_to_zoom_changed,this),this.model.on("change:_rotation",this.rotation_changed,this),this.model.on("change:_link_writeonly_rotation",this.link_rotation_changed,this),this.model.on("change:_heading",this.heading_changed,this),this.model.on("change:_link_writeonly_heading",this.link_heading_changed,this),this.model.on("change:_tilt",this.tilt_changed,this),this.model.on("change:_link_writeonly_tilt",this.link_tilt_changed,this),this.model.on("change:_extent",this.extent_changed,this),this.model.on("change:_link_writeonly_extent",this.link_extent_changed,this),this.model.on("change:_center",this.center_changed,this),this.model.on("change:_center_long_lat",this.center_long_lat_changed,this),this.model.on("change:_func_chains",this.func_chains_changed,this),this.model.on("change:_add_this_notype_layer",this.add_this_notype_layer_changed,this),this.model.on("change:_layers_to_remove",this.layers_to_remove_changed,this),this.model.on("change:_add_this_graphic",this.graphics_changed,this),this.model.on("change:_webmap",this.webmap_changed,this),this.model.on("change:_webscene",this.webscene_changed,this),this.model.on("change:_trigger_webscene_save_to_this_portal_id",this.save_webscene,this),this.model.on("change:_trigger_screenshot_with_args",this._trigger_screenshot_with_args_changed,this),this.model.on("change:_overlay_this_image",this.overlay_image_changed,this),this.model.on("change:_image_overlays_to_remove",this.image_overlays_to_remove_changed,this),this.model.on("change:time_slider",this.time_slider_prop_changed,this),this.model.on("change:time_mode",this.time_mode_changed,this),this.model.on("change:_time_info",this.time_info_changed,this),this.model.on("change:_writeonly_start_time",this.start_time_changed,this),this.model.on("change:_writeonly_end_time",this.end_time_changed,this),this.model.on("change:_portal_token",this.portal_token_changed,this),this.model.on("change:_custom_msg",this.custom_msg_changed,this),this.model.on("change:hide_mode_switch",this.hide_mode_switch_changed,this),this.model.on("change:_trigger_interactive_draw_mode_for",this.interactive_draw_shape,this),this.model.on("change:_trigger_new_jlab_window_with_args",this.trigger_jlab_window_changed,this),this.model.on("change:_js_cdn_override",this.js_cdn_changed,this),this.model.on("change:legend",this.legend_prop_changed,this),this.model.on("change:_trigger_print_js_debug_info",this.trigger_print_js_debug_info_changed,this),this.update_widget_from_model().then(()=>{this._postLoadSetup(r)})}).catch(e=>{this._displayErrorBox(),console.warn("Error on render: "),console.warn(e)})},update_widget_from_model:function(){return new Promise((e,t)=>{this.mode_changed(),this.basemap_changed(),this.zoom_changed(),this.scale_changed(),this.snap_to_zoom_changed(),this.rotation_changed(),this.heading_changed(),this.tilt_changed(),this.center_long_lat_changed(),this.center_changed(),this.extent_changed(),this.hide_mode_switch_changed(),this.portal_token_changed(),this.authenticate_to_portal().then(t=>{this.draw_these_notype_layers_on_widget_load(),this.draw_these_graphics_on_widget_load(),this.overlay_these_images_on_widget_load(),this.webmap_changed(),this.webscene_changed(),this.legend_prop_changed(),this.time_slider_prop_changed(),this.time_mode_changed(),this.time_info_changed(),e()}).catch(e=>{this._displayErrorBox("Error while authenticating to portal on first load."),console.warn("Error during portal auth"),console.warn(e),t(e)})})},_displayErrorBox:function(e,t=!0){if(e?t&&(e+=" See the browser console for more info."):e="Unhandled Error! See the browser console for more info.",a.stop(),document.getElementById(this.elements.errorTextBox.id)||this.el.appendChild(this.elements.errorTextBox),this.elements.errorTextBox.textContent){var o="Multiple messages attempted to display. See browser console to view all messages";this.elements.errorTextBox.textContent!==o&&console.warn("*****MESSAGE_BOX: "+this.elements.errorTextBox.textContent),console.warn("*****MESSAGE_BOX: "+e),r(o,this.elements)}else r(e,this.elements)},_setup_elements:function(){this.uuid=this.model.get("_uuid"),this.elements=n(this.uuid),this.el.className="arcgisMapIPyWidgetDiv",this.el.style.height="100%",this.el.style.width="100%",this.el.appendChild(this.elements.viewdivElement)},_setup_custom_buttons:function(){this.elements.infodivElement.appendChild(this.elements.switchButton),this.elements.switchButton.onclick=()=>{"3D"===this.model.get("mode")?(this.model.set("mode","2D"),this.touch()):(this.model.set("mode","3D"),this.touch())},"lab"===g.JupyterTarget&&(this.elements.infodivElement.appendChild(this.elements.newWindowButton),this.elements.newWindowButton.onclick=()=>{this.move_to_new_jlab_window({title:"ArcGIS Map"})})},_setup_2d_stationary_callback:function(e){this._MapView._pointerMoveHandler=this._MapView.on(["pointer-move","key-down"],t=>{console.log("Started interacting with the 2D map, setting up stationary callback..."),e.when(this._MapView,"stationary",this._2dStationaryCallback),this._MapView._pointerMoveHandler.remove()})},_setup_3d_stationary_callback:function(e){this._SceneView._pointerMoveHandler=this._SceneView.on(["pointer-move","key-down"],t=>{console.log("Started interacting with the 3D map, setting up stationary callback..."),e.when(this._SceneView,"stationary",this._3dStationaryCallback),this._SceneView._pointerMoveHandler.remove()})},_2dStationaryCallback:function(){var e=this._parentIPyWidget,t=this.rotation;if(t>=0){e.model.set("_readonly_rotation",t);var o=360-t;e.model.set("_readonly_heading",o),e.apply_heading_to_view(o)}e._commonStationaryCallback(e)},_3dStationaryCallback:function(){var e=this._parentIPyWidget,t=this.camera;if(t){e.model.set("_readonly_heading",t.heading);var o=360-t.heading;e.model.set("_readonly_rotation",o),e.apply_rotation_to_view(o),e.model.set("_readonly_tilt",t.tilt)}e._commonStationaryCallback(e)},_commonStationaryCallback:function(e){var t=e.activeView.zoom;t>=0&&e.model.set("_readonly_zoom",t);var o=e.activeView.scale;o>=1&&e.model.set("_readonly_scale",o);var i=e.activeView.center;i&&e.model.set("_readonly_center",JSON.parse(JSON.stringify(i)));var n=e.activeView.extent;n&&e.model.set("_readonly_extent",JSON.parse(JSON.stringify(n))),e.model.save_changes()},_miscellanous_setup:function(){this.map.allLayers.on("change",e=>{this.update_readonly_webmap()})},_postLoadSetup:function(e){console.log("Running post load setup for "+g.JSOutputContext),this._MapView.when(()=>{console.log("2D map ready"),this.model.set("ready",!0),this.model.set("_readonly_extent",this._MapView.extent),this.model.set("_readonly_center",this._MapView.center),this.model.save_changes(),this.zoom_changed(),this._setup_2d_stationary_callback(e)}),this._SceneView.when(()=>{console.log("3D map ready"),this.model.set("ready",!0),this.model.set("_readonly_extent",this._SceneView.extent),this.model.set("_readonly_center",this._SceneView.center),this.model.save_changes(),this.zoom_changed(),this.tilt_changed(),this._setup_3d_stationary_callback(e)}),this._MapView.on(["click"],e=>{this.send({event:"mouseclick",message:e.mapPoint})}),this._SceneView.on(["click"],e=>{this.send({event:"mouseclick",message:e.mapPoint})}),"default"===g.JSOutputContext&&this._hidePreviewEls(),this._set_screenshot_keyboard_shortcut()},_hidePreviewEls:function(){console.log("Hiding preview elements for "+this.uuid);var e=document.createElement("style");e.type="text/css",e.innerHTML="div.map-static-img-preview-"+this.uuid+" { display: none }\ndiv.map-html-embed-preview-"+this.uuid+" { display: none }",document.head.appendChild(e)},_setup_js_cdn:function(){this.model.on("change:_js_cdn_override",this.js_cdn_changed,this),this.js_cdn_changed()},_instantiate_esri_components:function(e,t,o,i,n,r,a,s){this.container=this.elements.mapElement;var l=this.model.get("mode").toLowerCase();"2d"===l?(this.map=new t({ground:"world-elevation"}),this._MapView=new i({map:this.map,container:this.container}),this.activeView=this._MapView,this._SceneView=new n({map:this.map})):"3d"===l&&(this.map=new o({ground:"world-elevation"}),this._SceneView=new n({map:this.map,container:this.container}),this.activeView=this._SceneView,this._MapView=new i({map:this.map})),this._MapView._parentIPyWidget=this,this._SceneView._parentIPyWidget=this,this._MapView.zoom=2,this._SceneView.zoom=2,this._MapView.ui.add(new r({view:this._MapView}),"top-left"),this._time_slider=new s({view:this.activeView,container:document.createElement("div"),mode:"time-window"}),this._time_slider.watch("values",e=>{this.time_slider_values_changed(e)}),this._legend=new a({view:this.activeView,layerInfos:[]})},_override_right_click_menu:function(){this.el.addEventListener("contextmenu",(function(e){return e.preventDefault(),e.stopPropagation(),!1}),!1)},_set_screenshot_keyboard_shortcut:function(){this.el.addEventListener("keydown",e=>{e.shiftKey&&"P"===e.key&&(this.model.set("_trigger_screenshot_with_args",{_:this._get_uuidv4(),set_as_preview:!0,output_in_cell:!1,file_path:!1}),this.model.save_changes())})},_get_uuidv4:function(){return"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(e){var t=16*Math.random()|0;return("x"==e?t:3&t|8).toString(16)}))},custom_msg_changed:function(){var e=this.model.get("_custom_msg");e&&this._displayErrorBox(e,browser_console_message=!1)},basemap_changed:function(){m.loadModules(["esri/Basemap"],p).then(([e])=>{console.log("updating basemap...");var t=this.model.get("_basemap"),o=this.model.get("_gallery_basemaps");if(t in o){var i=o[t],n=e.fromJSON(i);this.map.basemap=n}else this.map.basemap=t}).catch(e=>{this._displayErrorBox("Error while changing basemap."),console.warn("Error on basemap_change: "),console.warn(e)})},trigger_print_js_debug_info_changed:function(){console.log("Widget = "),console.log(this),console.log("Global token lookup = "),console.log(w)},mode_changed:function(){m.loadModules(["esri/WebMap","esri/WebScene"],p).then(([e,t])=>{console.log("updating mode..."),"3d"===this.model.get("mode").toLowerCase()?(this.elements.switchButton.src=d.sceneToMapEncoded,this.activeView.viewpoint&&(this._SceneView.viewpoint=this.activeView.viewpoint.clone(),this.activeView.container=null),this._SceneView.container=this.container,this.activeView=this._SceneView,this.map=new t({ground:this.map.ground,basemap:this.map.basemap,layers:this.map.layers}),this._SceneView.map=this.map,this._MapView.map=null):(this.elements.switchButton.src=d.mapToSceneEncoded,this.activeView.viewpoint&&(this._MapView.viewpoint=this.activeView.viewpoint.clone(),this.activeView.container=null),this._MapView.container=this.container,this.activeView=this._MapView,this.map=new e({ground:this.map.ground,basemap:this.map.basemap,layers:this.map.layers}),this._MapView.map=this.map,this._SceneView.map=null,this.model.set("tilt",0),this.model.save_changes()),this.legend_prop_changed(),this.time_slider_prop_changed(),this.map.allLayers.on("change",e=>{this.update_readonly_webmap()})}).catch(e=>{this._displayErrorBox(),console.warn("Error on mode_changed"),console.warn(e)})},zoom_changed:function(){try{var e=this.model.get("_zoom");this.model.set("_readonly_zoom",e),e>=0&&(this.activeView.zoom=e),this.model.save_changes()}catch(e){this._displayErrorBox("Error while modifying zoom."),console.warn("Error on zoom"),console.warn(e)}},scale_changed:function(){try{var e=this.model.get("_scale");this.model.set("_readonly_scale",e),this.model.save_changes(),e>=1&&(this.activeView.scale=e)}catch(e){this._displayErrorBox("Error while modifying scale"),console.warn("Error on scale"),console.warn(e)}},snap_to_zoom_changed:function(){try{var e=this.model.get("mode"),t=this.model.get("_snap_to_zoom");"2D"===e&&(this.activeView.constraints.snapToZoom=t)}catch(e){this._displayErrorBox("Error while modifying snap to zoom"),console.warn("Error on snap to zoom"),console.warn(e)}},rotation_changed:function(){try{var e=this.model.get("_rotation");this.model.set("_readonly_rotation",e),this.model.save_changes(),this.apply_rotation_to_view(e)}catch(e){this._displayErrorBox("Error while modifying rotation"),console.warn("Error on rotation"),console.warn(e)}},link_rotation_changed:function(){var e=this.model.get("_link_writeonly_rotation");this.apply_rotation_to_view(e)},apply_rotation_to_view:function(e){this._MapView.rotation=e},heading_changed:function(){var e=this.model.get("_heading");this.model.set("_readonly_heading",e),this.model.save_changes(),this.apply_heading_to_view(e)},link_heading_changed:function(){var e=this.model.get("_link_writeonly_heading");this.apply_heading_to_view(e)},apply_heading_to_view:function(e){var t=()=>{this._SceneView.goTo({center:this._SceneView.center,heading:e},{animate:!1})};m.loadModules(["esri/core/watchUtils"],p).then(([e])=>{this._SceneView.camera?t():e.once(this._SceneView,"camera",()=>{t()})}).catch(e=>{this._displayErrorBox("Error while modifying heading"),console.warn("Error on heading"),console.warn(e)})},tilt_changed:function(){var e=this.model.get("_tilt");this.model.set("_readonly_tilt",e),this.model.save_changes(),this.apply_tilt_to_view(e)},link_tilt_changed:function(){var e=this.model.get("_link_writeonly_tilt");this.apply_tilt_to_view(e)},apply_tilt_to_view:function(e){var t=()=>{this._SceneView.goTo({center:this._SceneView.center,tilt:e},{animate:!1})};m.loadModules(["esri/core/watchUtils"],p).then(([e])=>{this._SceneView.camera?t():e.once(this._SceneView,"camera",()=>{t()})}).catch(e=>{console.warn("Error on tilt"),console.warn(e)})},extent_changed:function(){var e=this.model.get("_extent");this.apply_extent_to_view(e)},link_extent_changed:function(){var e=this.model.get("_link_writeonly_extent");this.apply_extent_to_view(e)},apply_extent_to_view:function(e){m.loadModules(["esri/geometry/Extent","esri/geometry/SpatialReference","esri/geometry/projection"],p).then(([t,o,i])=>{e.xmin&&(this.activeView.extent=new t(e),i.load().then(()=>{this.activeView.extent=i.project(new t(e),o.WebMercator)}))}).catch(e=>{this._displayErrorBox("Error while modifying extent."),console.warn("Error on extent"),console.warn(e)})},center_long_lat_changed:function(){m.loadModules(["esri/core/watchUtils"],p).then(([e])=>{var t=this.model.get("_center_long_lat");2===t.length&&(console.log("Converting [long, lat] center to standard center..."),e.once(this.activeView,"center",()=>{console.log("Center is converted");var e=JSON.parse(JSON.stringify(this.activeView.center));this.model.set("_center",e),this.model.set("_center_long_lat",[]),this.model.save_changes()}),this.activeView.center=t)}).catch(e=>{this._displayErrorBox("Error while modifying center_long_lat."),console.warn("Error on center_long_lat"),console.warn(e)})},center_changed:function(){try{var e=this.model.get("_center");"x"in e&&"y"in e&&(this.activeView.center=e)}catch(e){this._displayErrorBox("Error while modifying center"),console.warn("Error on center"),console.warn(e)}},webmap_changed:function(){m.loadModules(["esri/WebMap"]).then(([e])=>{console.log("Updating webmap...");var t=this.model.get("_webmap");0!==Object.keys(t).length&&(this.map=e.fromJSON(t),this._MapView.map=this.map)}).catch(e=>{this._displayErrorBox("Error on loading webmap from portal"),console.warn("Error on loading webmap"),console.warn(e)})},update_readonly_webmap:function(){try{var e;e=this._MapView.map?this._MapView.map:this._SceneView.map;var t=[];for(var o in e.layers.toArray()){var i=e.layers.toArray()[o],n={id:i.id,normalization:i.normalization,refreshInterval:i.refreshInterval,url:i.url};if(i.graphics)for(var o in n.graphics=[],i.graphics.toArray()){var r=i.graphics.toArray()[o],a=r.toJSON();a.shape=r.shape,n.graphics.push(a)}i.renderer&&(n.renderer=i.renderer.toJSON(),n.rendererType=i.renderer.declaredClass),t.push(n)}var s={layers:t,ground:e.ground?e.ground.toJSON():{},basemap:e.basemap?e.basemap.toJSON():{}};this.model.set("_readonly_webmap_from_js",s),this.model.save_changes()}catch(e){this._displayErrorBox("Error updating readonly webmap json."),console.warn("Error updating readonly webmap"),console.warn(e)}},webscene_changed:function(){m.loadModules(["esri/WebScene","esri/Viewpoint","esri/webscene/InitialViewProperties"]).then(([e,t,o])=>{console.log("Updating webscene..."),console.log(this.model.get("_webscene"));var i=this.model.get("_webscene");0!==Object.keys(i).length&&this.authenticate_to_portal().then(t=>{i.portalItem.portal=t,new e(i).load().then(e=>{this._SceneView.map=e,this.map=e}).catch(e=>{this._displayErrorBox("Error on loading webscene item"),console.warn("Error on loading webscene"),console.warn(e)})}).catch(e=>{this._displayErrorBox("Error on loading portal for webscene"),console.warn("Error loading portal"),console.warn(e)})}).catch(e=>{this._displayErrorBox("Error on loading webscene from portal"),console.warn("Error on loading webscene"),console.warn(e)})},save_webscene:function(){m.loadModules(["esri/WebScene","esri/Ground","esri/Basemap"]).then(([e,t,o])=>{this.authenticate_to_portal().then(i=>{var n;n="WebScene"==this._SceneView.map.declaredClass?new e(this._SceneView.map.toJSON()):new e({layers:this._SceneView.map.layers,ground:t.fromJSON(this._SceneView.map.ground.toJSON()),basemap:o.fromJSON(this._SceneView.map.basemap.toJSON())});var r=this.model.get("_trigger_webscene_save_to_this_portal_id");console.log("Starting to save webscene to portal item "+r),n.portalItem={id:r,portal:i},n.load().then(()=>{n.ground=t.fromJSON(this._SceneView.map.ground.toJSON()),n.basemap=o.fromJSON(this._SceneView.map.basemap.toJSON()),n.updateFrom(this._SceneView),n.save({ignoreUnsupported:!0}).then(e=>{console.log("The following item was saved:"),console.log(e.toJSON())}).catch(e=>{this._displayErrorBox("Error saving webscene"),console.warn("Error saving webscene"),console.warn(e)}),this.reload_all_layers(),this._SceneView.map=n,this.map=n}).catch(e=>{this._displayErrorBox("During load, error on loading webscene save"),console.warn("Error loading web scene"),console.warn(e)})}).catch(e=>{this._displayErrorBox("During portal auth, error on webscene save"),console.warn("Error portal auth on webscene save"),console.warn(e)})}).catch(e=>{this._displayErrorBox("Error on saving the web scene"),console.warn("Error saving web scene"),console.warn(e)})},reload_all_layers:function(){console.log("TODO: CHECK IF I'M BROKEN"),this.draw_these_notype_layers_on_widget_load()},func_chains_changed:function(){console.log("Updating func_chains..."),console.log(this.model.get("_func_chains"))},draw_these_notype_layers_on_widget_load:function(){var e=this.model.get("_draw_these_notype_layers_on_widget_load");for(var t in console.log("Drawing these layers on load... "),console.log(e),e){var o=e[t];this.add_notype_layer(o)}},add_this_notype_layer_changed:function(){var e=this.model.get("_add_this_notype_layer");0!==Object.keys(e).length&&this.add_notype_layer(e)},add_notype_layer:function(e){var t=[];if(e.layers)for(var o=0;o<e.layers.length;o++){var i=e.layers[o];i.options=e.options,t.push(i)}else t.push(e);for(o=0;o<t.length;o++){var n=t[o];s(n,this).then(t=>{console.log("Adding Layer "+e._hashFromPython+" to map."),this.map.add(t)}).catch(e=>{this._displayErrorBox("Could not update layer. "+e),console.warn("Could not update layer"),console.warn(e)})}},layers_to_remove_changed:function(){try{console.log("Called layer to remove changed...");var e=this.model.get("_layers_to_remove");for(var t in e){var o=e[t];do{var i=this.map.findLayerById(o),n=Boolean(i);n&&(console.log("Attempting to remove layer"+i.id),this.map.remove(i))}while(n)}}catch(e){this._displayErrorBox("Error removing layer"),console.warn("Error removing layer"),console.warn(e)}},hide_mode_switch_changed:function(){this.model.get("hide_mode_switch")&&(console.log("Removing the mode switch..."),this.elements.switchButton.remove())},getGraphicsLayer:function(e){var t=this.map.findLayerById("graphicsLayerId31195");return void 0===t&&(t=new e({id:"graphicsLayerId31195"}),this.map.add(t)),t},draw_these_graphics_on_widget_load:function(){var e=this.model.get("_draw_these_graphics_on_widget_load");for(var t in console.log("Drawing these layers on load... "),console.log(e),e){var o=e[t];this.add_graphic(o)}},graphics_changed:function(){var e=this.model.get("_add_this_graphic");0!==Object.keys(e).length&&this.add_graphic(e)},add_graphic:function(e){m.loadModules(["esri/layers/GraphicsLayer","esri/Graphic","esri/geometry/Geometry","esri/symbols/support/jsonUtils"],p).then(([t,o,i,n])=>{var r=new o(e);if(null==r.symbol&&(console.log(r.geometry),/polyline/i.test(r.geometry.type)?r.symbol={type:"simple-line"}:/polygon/i.test(r.geometry.type)?r.symbol={type:"simple-fill"}:(/point/i.test(r.geometry.type)||/multipoint/i.test(r.geometry.type))&&(r.symbol={type:"simple-marker"})),"symbol"in e){var a=n.fromJSON(e.symbol);null!=a&&(r.symbol=a)}this.getGraphicsLayer(t).add(r)}).catch(e=>{this._displayErrorBox("Error on updating graphics."),console.warn("Error on updating graphics"),console.warn(e)})},interactive_draw_shape:function(){m.loadModules(["esri/widgets/Sketch/SketchViewModel","esri/layers/GraphicsLayer","esri/Graphic"],p).then(([e,t,o])=>{console.log("Entering interactive draw shape mode.");var i=this.model.get("_trigger_interactive_draw_mode_for");if(i){var n=this.activeView,r=new e({layer:this.getGraphicsLayer(t),view:n});r.create(i),r.on("create",e=>{"complete"==e.state&&this.send({event:"draw-end",message:e.graphic.geometry.toJSON()})})}}).catch(e=>{this._displayErrorBox("Error on drawing interactive shape"),console.warn("Error on interactive shape"),console.warn(e)})},trigger_jlab_window_changed:function(){var e=this.model.get("_trigger_new_jlab_window_with_args");console.log("new_jlab_window triggered with:"),console.log(e),0!==Object.keys(e).length&&this.move_to_new_jlab_window(e)},move_to_new_jlab_window:function(e){if("lab"!==g.JupyterTarget)return this._displayErrorBox("Can only move to new window in a JupyterLab env"),void console.warn("Can't move to new window: JupyterTarget = "+g.JupyterTarget);console.log("Attempting to move map to new jlab window...");var t=this.el.childNodes[0];if(console.log(t),null!=t){var o,i=e.title;o="tab_mode"in e?e.tab_mode:this.model.get("tab_mode"),window.newJLabWindow({title:i,element:t,tab_mode:o}),this.elements.newWindowButton.src=d.toOriginalWindowEncoded,this.prevElementHeight=this.el.style.height,this.el.style.height="0px"}else{var n=document.getElementById(this.elements.viewdivElement.id);window.closeJLabWindow({element:n}),this.elements.newWindowButton.src=d.toNewWindowEncoded,this.el.style.height=this.prevElementHeight}},portal_token_changed:function(){try{var e=this.model.get("_portal_token");e&&(console.log("updating _portal_token..."),this._portalToken=e,w[this.uuid]=e,this.model.set("_portal_token",""),this.model.save_changes())}catch(e){this._displayErrorBox("Error storing token."),console.warn("Error storing token."),console.warn(e)}},get_portal_token:function(){return this._portalToken?this._portalToken:this.uuid in w?w[this.uuid]:this.model.get("_portal_token")},authenticate_to_portal:function(){return new Promise((e,t)=>{m.loadModules(["esri/config","esri/identity/ServerInfo","esri/identity/IdentityManager","esri/portal/Portal"],p).then(([o,i,n,r])=>{var a=this.model.get("_auth_mode");if("_portal"in this&&this._portal.loaded)e(this._portal);else if("anonymous"===a.toLowerCase()){""!==(s=this.model.get("_portal_url"))&&(o.portalUrl=s),this._portal=new r({authMode:"anonymous"}),this._portal.load().then(()=>{e(this._portal)}).catch(e=>{t(e)})}else if("tokenbased"===a.toLowerCase()){var s=this.model.get("_portal_url"),l=this.model.get("_portal_sharing_rest_url"),d=this.get_portal_token();if(s&&l&&d){var c=new i;c.server=l,c.tokenServiceUrl=l+"generateToken",n.registerServers([c]),n.registerToken({server:l,userId:this.model.get("_username"),token:d}),o.request.trustedServers.push(s),console.log("esriConfig.request.trustedServers = "),console.log(o.request.trustedServers),this._portal=new r({url:s}),this._portal.load().then(()=>{e(this._portal)}).catch(e=>{t(e)})}else{var h="_portal_url, _portal_sharing_rest_url, and _portal_token must be specified to authenticate in 'tokenBased' auth mode. _portal_url = "+s+", _portal_sharing_rest_url = "+l+", _portal_token = "+this._portalToken;t(h)}}else if("prompt"===a.toLowerCase()){""!==(s=this.model.get("_portal_url"))&&(o.portalUrl=s),this._portal=new r({authMode:"immediate",allSSL:!1,canSignInArcGIS:!0,canSignInIDP:!0,authorizedCrossOriginDomains:[o.portalUrl]}),this._portal.load().then(()=>{e(this._portal)}).catch(e=>{t(e)})}else t("You must specify the '_auth_mode' model variable to either 'anonymous', 'tokenbased', or 'prompt'")}).catch(e=>{t(e)})})},js_cdn_changed:function(){var e=this.model.get("_js_cdn_override");""!==e&&(h(g,e),console.log("CDN changed: new config = "),console.log(g),p=g.EsriLoaderOptions,this._check_js_api_version_loaded(e),css_url=e+"esri/css/main.css","notebook"===g.JupyterTarget?(m.setRequireJSConfig(g.BaseRequireJSConfig),$("head").append($('<link rel="stylesheet" type="text/css" />').attr("href",css_url))):"lab"===g.JupyterTarget&&m.loadCss(css_url),m.loadModules(["esri/config"],p).then(([t])=>{t.request.corsEnabledServers.push(e)}).catch(e=>{console.log("Error while setting fallback cdn"),console.log(e)}))},legend_prop_changed:function(){try{console.log("legend changed");this.model.get("legend")?(this.activeView.ui.empty("bottom-right"),this._legend.view=this.activeView,this.activeView.ui.add(this._legend,"bottom-right")):this.activeView.ui.empty("bottom-right")}catch(e){console.log("Error while trying to show legend."),console.log(e)}},time_slider_prop_changed:function(){try{console.log("time slider changed");this.model.get("time_slider")?(this.activeView.ui.empty("bottom-left"),this._time_slider.view=this.activeView,this.activeView.ui.add(this._time_slider,"bottom-left")):this.activeView.ui.empty("bottom-left")}catch(e){this._displayErrorBox("Error while updating time slider"),console.warn("Error while trying to show time slider"),console.warn(e)}},time_mode_changed:function(){try{if(this.model.get("time_slider")){console.log("time mode changed");var e=this.model.get("time_mode"),t=this._time_slider.values;this._time_slider.mode=e,t.length>0&&("instant"===e&&(this._time_slider.values=[t[0]]),"time-window"===e&&1==t.length&&(this._time_slider.values=[t[0],t[0]]),"cumulative-from-start"===e&&(this._time_slider.values=[t[0]]),"cumulative-from-end"===e&&(this._time_slider.value=[t[0]]))}}catch(e){this._displayErrorBox("Error while updating time mode"),console.warn("Error while trying updating time mode"),console.warn(e)}},time_slider_values_changed:function(e){2==e.length&&(this.model.set("_readonly_start_time",e[0].toISOString()),this.model.set("_readonly_end_time",e[1].toISOString())),1==e.length&&this.model.set("_readonly_start_time",e[0].toISOString()),this.model.save_changes()},time_info_changed:function(){m.loadModules(["esri/TimeExtent","esri/TimeInterval"],p).then(([e,t])=>{var o=this.model.get("_time_info");if(console.log("Time Info changed"),console.log(o),"time_extent"in o){var i=new Date(o.time_extent[0]),n=new Date(o.time_extent[1]);this._time_slider.fullTimeExtent=new e({start:i,end:n})}var r=1,a="milliseconds";"interval"in o&&(r=o.interval),"unit"in o&&(a=o.unit),this._time_slider.stops={interval:new t({value:r,unit:a})}}).catch(e=>{this._displayErrorBox("Error while changing the time info"),console.warn("Error while trying to change the time info"),console.warn(e)})},start_time_changed:function(){try{console.log("start time changed");var e=this.model.get("_writeonly_start_time"),t=new Date(e);if(1==this._time_slider.values.length&&(this._time_slider.values=[t]),2==this._time_slider.values.length){var o=this._time_slider.values[1];this._time_slider.values=[t,o]}}catch(e){this._displayErrorBox("Error while changing `start_time`"),console.warn("Error while changing start_time"),console.warn(e)}},end_time_changed:function(){try{console.log("end time changed");var e=this.model.get("_writeonly_end_time"),t=new Date(e),o=this._time_slider.values[0];this._time_slider.values=[o,t]}catch(e){this._displayErrorBox("Error while changing `end_time`"),console.warn("Error while changing `end_time`"),console.warn(e)}},_trigger_screenshot_with_args_changed:function(){var e=this.model.get("_trigger_screenshot_with_args");console.log("Triggering Screenshot with args "),console.log(e),modelStrsToSendTo=[],e.set_as_preview&&modelStrsToSendTo.push("_preview_screenshot_callback_resp"),e.output_in_cell&&modelStrsToSendTo.push("_cell_output_screenshot_callback_resp"),e.file_path&&modelStrsToSendTo.push("_file_output_screenshot_callback_resp"),this._capture_screenshot_send_to(modelStrsToSendTo)},_capture_screenshot_send_to:function(e){var t=this.model.get("mode"),o="";"3D"===t?o=this._get_3d_screenshot:"2D"===t&&(o=this._get_2d_screenshot),o(this).then(t=>{for(var o in e){var i=e[o];this.model.set(i,t)}this.touch()}).catch(t=>{for(var o in console.log("Could not take screenshot"),console.log(t),this._displayErrorBox("Could not take screenshot."),e){console.log("sending "+i+" to ");var i=e[o];this.model.set(i,d.screenshotErrorEncoded)}this.touch()})},_get_2d_screenshot:function(e){return new Promise((t,o)=>{e._MapView.takeScreenshot({format:"png"}).then(e=>{t(e.dataUrl)}).catch(e=>{o(e)})})},_get_3d_screenshot:function(e){return new Promise((t,o)=>{e._SceneView.takeScreenshot({format:"png"}).then(e=>{t(e.dataUrl)}).catch(e=>{o(e)})})},overlay_these_images_on_widget_load:function(){for(var e=this.model.get("_overlay_these_images_on_widget_load"),t=0;t<e.length;t++){var o=e[t];this.overlay_this_image(o)}},overlay_image_changed:function(){var e=this.model.get("_overlay_this_image");this.overlay_this_image(e)},getActiveImageOverlayLayer:function(e){var t=this.map.findLayerById("imageOverlayLayerId551883");return void 0===t&&(t=new e({id:"imageOverlayLayerId551883"}),this.map.add(t)),t},overlay_this_image:function(e){if(0!==Object.keys(e).length){if("lab"===g.JupyterTarget){var t=this.model.widget_manager.context.session.path,o=this.model.widget_manager.context.session.name,i=t.substring(0,t.lastIndexOf(o));e.src="/tree/"+i+e.src}l().then(t=>{this.getActiveImageOverlayLayer(t).tryOverlayImage(e).catch(e=>{e.message.includes("NetworkError")?this._displayErrorBox("Error overlaying image (uhandled NetworkError). You probably specified an image URL that violate browser security rules (CORs, etc)."):e.name.includes("BadHTTPStatusError")?this._displayErrorBox("Error overlaying image (URL return status "+e.status+"). "):this._displayErrorBox("Error on overlaying image."),console.warn("Error on overlaying image"),console.warn(e)})}).catch(e=>{this._displayErrorBox("Error getting ImageOverlayLayer type:"),console.log("Error getting ImageOverlayLayer type"),console.log(e)})}},image_overlays_to_remove_changed:function(){var e=this.model.get("_image_overlays_to_remove");l().then(t=>{this.getActiveImageOverlayLayer(t).tryRemoveImageOverlays(e)}).catch(e=>{this._displayErrorBox("Error getting ImageOverlayLayer type:"),console.log("Error getting ImageOverlayLayer type:"),console.log(e)})},_check_js_api_version_loaded:function(e){this._httpGetAsync(e).then(t=>{for(var o=t.split("\n"),i=null,n=0;n<o.length;n++){var r=o[n];if(-1!==r.indexOf("js.arcgis.com")&&-1!==r.indexOf("copyright.txt")){i=r;break}}if(null!==i){console.log("Copyright line = '"+i+"'");var a=i.split("js.arcgis.com/")[1].split("/esri")[0];a<g.minJSAPIVersion&&(console.warn("JS API "+a+" < "+g.minJSAPIVersion),this._displayErrorBox("Warning: the ArcGIS API for JavaScript being loaded at "+e+" does not appear to be >="+g.minJSAPIVersion+". Widget may not function properly.",browser_console_message=!1))}else console.warn("Could not infer javascript version"),this._displayErrorBox("Warning: Could not infer version of any loaded ArcGIS API for JavaScript. Widget may not function properly.",browser_console_message=!1)}).catch(e=>{console.log("Could not reach the fallback cdn..."),console.log(e)})},_httpGetAsync:function(e){return new Promise((t,o)=>{fetch(e,{mode:"cors"}).then(i=>{i.status>=200&&i.status<300?i.text().then(e=>{t(e)}).catch(e=>{o(e)}):o("HTTP request on "+e+" returned code "+status)})})}});e.exports=y},function(e,t,o){var i=o(6),n=o(0),r=o(3);e.exports=function(e){var t=document.createElement("div");t.className="viewDiv",t.id=t.className+e,t.style.padding="0",t.style.margin="0",t.style.height="100%",t.style.width="100%",t.style.position="relative";var o=document.createElement("div");o.className="infoDiv",o.id=o.className+e,o.style.position="absolute",o.style.top="15px",o.style.left="60px";var a=document.createElement("input");if(a.classList.add("switchButtonId"),a.id="switchButton"+e,a.type="image",a.classList.add("esri-component"),a.classList.add("esri-widget--button"),a.classList.add("esri-widget"),a.classList.add("esri-interactive"),a.style.boxShadow="rgba(0, 0, 0, 0.3) 0px 1px 2px",a.style.border="none",a.style.float="left",a.style.marginRight="13px","lab"===n.JupyterTarget){var s=document.createElement("input");s.classList.add("newWindowButton"),s.id="newWindowButtonId"+e,s.type="image",s.src=r.toNewWindowEncoded,s.classList.add("esri-component"),s.classList.add("esri-widget--button"),s.classList.add("esri-widget"),s.classList.add("esri-interactive"),s.style.boxShadow="rgba(0, 0, 0, 0.3) 0px 1px 2px",s.style.fontFamily="CalciteWebCoreIcons",s.style.border="none",s.style.float="right",s.style.marginRight="13px",s.style.width="32px",s.style.height="32px",s.style.textAlign="center",s.style.margin="0 10px 10px 0",s.style.fontSize="125%"}var l=i.element;l.className="loadingText",l.id=l.className+e;var d=document.createElement("div");d.className="errorTextDiv",d.id=d.className+e,d.style.position="absolute",d.style.right="5px",d.style.top="5px",d.style.width="25%",d.style.color="#6f6f6f",d.style.backgroundColor="#ffffff",d.style.boxShadow="rgba(0, 0, 0, 0.3) 0px 1px 2px",d.style.fontFamily="sans-serif",d.style.fontWeight="400",d.style.wordWrap="break-word";var c=document.createElement("div");c.className="errorCloseButton",c.id=c.className+e,c.style.position="absolute",c.style.top="3px",c.style.right="9px",c.style.color="#ababab",c.style.fontFamily="sans-serif",c.style.fontWeight="400",d.appendChild(c);var h=function(){d.textContent="",c.textContent="",d.style.padding="0px"};d.onclick=h,c.onclick=h;var g=document.createElement("div");return g.className="mapElement",g.id=g.className+e,g.style.height="100%",g.style.width="100%",t.appendChild(l),t.appendChild(g),t.appendChild(o),t.appendChild(d),t.appendChild(c),{viewdivElement:t,infodivElement:o,mapElement:g,switchButton:a,errorTextBox:d,errorCloseButton:c,loadingText:l,newWindowButton:s}}},function(e,t){var o="https://js.arcgis.com/4.15/",i={CdnUrl:o,CdnMainCssUrl:"https://js.arcgis.com/4.15/esri/css/main.css",EsriLoaderOptions:{url:o,dojoConfig:{has:{"esri-featurelayer-webgl":1}}},minJSAPIVersion:"4.15"};e.exports=i},function(e,t,o){o(0);e.exports=function(e,t){t.errorTextBox.textContent=e,t.errorCloseButton.textContent="✕",t.errorTextBox.style.padding="10px"}},function(e,t,o){var i=o(1),n=o(19),r=o(8),a=o(20),s=o(0),l=i(s),d=s.EsriLoaderOptions;e.exports=function(e,t){return new Promise((function(o,i){l.loadModules(["esri/layers/ImageryLayer","esri/layers/KMLLayer","esri/layers/TileLayer","esri/layers/MapImageLayer","esri/layers/VectorTileLayer","esri/layers/SceneLayer","esri/layers/FeatureLayer","esri/tasks/support/FeatureSet","esri/layers/WMSLayer","esri/layers/WMTSLayer","esri/layers/GeoRSSLayer","esri/layers/GeoJSONLayer","esri/layers/CSVLayer","esri/layers/support/RasterFunction","esri/layers/support/MosaicRule","esri/layers/PointCloudLayer","esri/layers/IntegratedMeshLayer","esri/layers/BuildingSceneLayer"],d).then(([s,l,d,c,h,g,m,p,_,u,w,y,f,v,A,x,b,S])=>{if("ImageryLayer"===e.type){if((j=new s(e.url)).id=e._hashFromPython,"options"in e&&"imageServiceParameters"in e.options){if("renderingRule"in e.options.imageServiceParameters){console.log("Applying rendering rule to imagery layer..");var E=e.options.imageServiceParameters.renderingRule,I=v.fromJSON(E);j.renderingRule=I}if("mosaicRule"in e.options.imageServiceParameters){console.log("Applying mosaic rule to imagery layer..");var C=e.options.imageServiceParameters.mosaicRule,M=A.fromJSON(C);j.mosaicRule=M}if("raster"in e.options.imageServiceParameters){var B,V=e.options.imageServiceParameters.raster;B="string"==typeof V?V:btoa(JSON.stringify(V)),j.raster=B}}o(j)}else if("KMLLayer"==e.type||"KML"==e.type){(j=new l(e.url)).id=e._hashFromPython,o(j)}else if("ArcGISTiledMapServiceLayer"==e.type||"TileLayer"==e.type){(j=new d(e.url)).id=e._hashFromPython,o(j)}else if("ArcGISDynamicMapServiceLayer"==e.type||"MapImageLayer"==e.type){(j=new c(e.url)).id=e._hashFromPython,o(j)}else if("VectorTileLayer"==e.type){(j=new h(e.url)).id=e._hashFromPython,o(j)}else if("WMS"==e.type){e.subLayers=[e.sublayers[0]],delete e.type,(j=new _(e)).id=e._hashFromPython,o(j)}else if("WebTiledLayer"==e.type){(j=new u({url:e.url})).id=e._hashFromPython,o(j)}else if("GeoRSS"==e.type){(j=new w({url:e.url})).id=e._hashFromPython,o(j)}else if("GeoJSON"==e.type){if(0!==Object.keys(e.data).length){var L=new Blob([JSON.stringify(e.data)],{type:"application/json"});url=URL.createObjectURL(L)}else url=e.url;(j=new y({url:url})).id=e._hashFromPython,"renderer"in e?(console.log("Using custom renderer for GeoJSON layer "+j.id),n(e.renderer.type,e.renderer).then(e=>{j.renderer=e,o(j)}).catch(e=>{console.warn("Could not infer renderer for "+j.id),console.warn(e),o(j)})):o(j)}else if("CSV"==e.type)n(e.layerDefinition.drawingInfo.renderer.type,e.layerDefinition.drawingInfo.renderer).then(t=>{var i=new f({url:e.url,renderer:t});i.id=e._hashFromPython,o(i)}).catch(t=>{var i=new f({url:e.url});i.id=e._hashFromPython,o(i)});else if("SceneLayer"==e.type){(j=new g({url:e.url})).id=e._hashFromPython,o(j)}else if("PointCloudLayer"==e.type){(j=new x({url:e.url})).id=e._hashFromPython,o(j)}else if("IntegratedMeshLayer"==e.type){(j=new b({url:e.url})).id=e._hashFromPython,o(j)}else if("BuildingSceneLayer"==e.type){(j=new S({url:e.url})).id=e._hashFromPython,o(j)}else if("FeatureLayer"==e.type||"Feature Layer"==e.type){var k=new m(e.url,{outFields:["*"]});k.id=e._hashFromPython,k.load().then(s=>{s.popupTemplate=a(s);var l={};if(null!=(l=null==e.options?e:e.options).opacity&&(console.log("FeatureLayerOpacity:"+l.opacity),s.opacity=l.opacity),null!=e.opacity&&(s.opacity=e.opacity),null!=l.definition_expression&&(console.log("FeatureLayerDefinitionExpression:"),console.log(l.definition_expression),s.definitionExpression=l.definition_expression),null!=e.definition_expression&&(console.log("FeatureLayerDefinitionExpression:"),console.log(e.definition_expression),s.definitionExpression=e.definition_expression),l.renderer){console.log("Specifying the FeatureLayer's custom renderer...");var d="",c={};c=r.isSmartMapRenderer(l.renderer)?{layer:s,fieldName:l.field_name,basemap:t.model.get("basemap"),otherLayerOptions:l}:l,"string"!=typeof l.renderer&&"type"in l.renderer?(d=l.renderer.type,c=l.renderer):d=l.renderer,n(d,c,t).then(e=>{s.renderer=e,o(s)}).catch(e=>{console.warn("Error on inferring renderer."),i(e)})}else o(s)}).catch(e=>{console.warn("Error when laoding Feature Layer"),i(e)})}else if("featureSet"in e){console.log("Creating from FeatureCollection...");var O=e.layerDefinition,T=e.featureSet;T.spatialReference=O.spatialReference,T.fields=O.fields;var j,P=p.fromJSON(T);(j=new m({title:"xxxxxxxx-xxxx-4xxx-yxxx-xxxxxxxxxxxx".replace(/[xy]/g,(function(e){var t=16*Math.random()|0;return("x"==e?t:3&t|8).toString(16)})),fields:P.fields,objectIdField:O.objectIdField,geometryType:P.geometryType,spatialReference:P.spatialReference,source:P.features})).popupTemplate=a(j),j.id=e._hashFromPython,"renderer"in e.options?renderer=e.options.renderer:"autocast"===O.drawingInfo.renderer.renderer?renderer="autocast":renderer=O.drawingInfo.renderer.type,r.isSmartMapRenderer(renderer)?rendererOptions={layer:j,fieldName:e.options.field_name,basemap:t.model.get("basemap"),otherLayerOptions:e.options}:rendererOptions=O.drawingInfo.renderer,n(renderer,rendererOptions,t).then(e=>{j.renderer=e,o(j)}).catch(e=>{console.warn("Error on inferring renderer."),i(e)})}else console.warn("This layer type is not supported:"),console.warn(e),i("This layer type is not supported.")}).catch(e=>{i(e)})}))}},function(e,t){e.exports=require("esri-loader")},function(e,t,o){"use strict";t.__esModule=!0,t.setRequireJSConfig=t.loadModules=t.loadScript=t.isLoaded=t.getScript=t.utils=t.loadCss=void 0;function i(e){var t=function(e){return document.querySelector('link[href*="'+e+'"]')}(e);return t||(t=function(e){var t=document.createElement("link");return t.rel="stylesheet",t.href=e,t}(e),document.head.appendChild(t)),t}t.loadCss=i;var n="undefined"!=typeof window;function r(e,t,o){var i;o&&(i=function(e,t){var o=function(i){t(i.error||new Error("There was an error attempting to load "+e.src)),e.removeEventListener("error",o,!1)};return e.addEventListener("error",o,!1),o}(e,o));var n=function(){t(e),e.removeEventListener("load",n,!1),i&&e.removeEventListener("error",i,!1)};e.addEventListener("load",n,!1)}function a(){return document.querySelector("script[data-esri-loader]")}function s(){return window.require&&window.requirejs}function l(e){return void 0===e&&(e={}),e.url||(e.url="https://js.arcgis.com/4.7/"),new t.utils.Promise((function(t,o){var n=a();if(n){var l=n.getAttribute("src");l!==e.url?o(new Error("The ArcGIS API for JavaScript is already loaded ("+l+").")):s()?t(n):r(n,t,o)}else s()?o(new Error("The ArcGIS API for JavaScript is already loaded.")):(e.css&&i(e.css),e.requirejsConfig&&window.require.config(e.requirejsConfig),n=function(e){var t=document.createElement("script");return t.type="text/javascript",t.src=e,t.setAttribute("data-esri-loader","loading"),t}(e.url),e.url,r(n,(function(){n.setAttribute("data-esri-loader","loaded"),t(n)}),o),document.body.appendChild(n))}))}function d(e,o){return void 0===o&&(o={}),function(e){return new t.utils.Promise((function(t,o){null==window.activeRequireFunction?o("esriLoader.setRequireJSConfig() has not been called: You MUST call this function before using esriLoader"):window.activeRequireFunction(["require"],(function(i){i(e,(function(){for(var e=[],o=0;o<arguments.length;o++)e[o]=arguments[o];t(e)}),o)}))}))}(e)}function c(e){console.log("Setting requirejs-esri-loader's config:"),console.log(e),window.activeRequireFunction=window.require.config(e)}t.utils={Promise:n?window.Promise:void 0},t.getScript=a,t.isLoaded=s,t.loadScript=l,t.loadModules=d,t.setRequireJSConfig=c,t.default={setRequireJSConfig:c,getScript:a,isLoaded:s,loadModules:d,loadScript:l,loadCss:i,utils:t.utils}},function(e,t,o){var i=o(1),n=o(0),r=i(n),a=n.EsriLoaderOptions,s=o(8),l=function(e){return Object.assign({layer:e.layer,field:e.fieldName,basemap:e.basemap,classificationMethod:"quantile"},e.otherLyrOptions)};e.exports=function(e,t,o){return new Promise((function(o,i){r.loadModules(["esri/renderers/smartMapping/creators/size","esri/renderers/smartMapping/creators/color","esri/renderers/smartMapping/creators/location","esri/renderers/SimpleRenderer","esri/renderers/UniqueValueRenderer","esri/renderers/ClassBreaksRenderer","esri/renderers/HeatmapRenderer","esri/renderers/DotDensityRenderer"],a).then(([n,r,a,d,c,h,g,m])=>{if(s.isClassedSizeRenderer(e)){console.log("Using classedSizeRenderer...");var p=l(t);console.log(p),n.createClassBreaksRenderer(p).then(e=>{o(e.renderer)}).catch(e=>{console.warn("Error on creating Class Breaks Renderer"),i(e)})}else if(s.isClassedColorRenderer(e)){console.log("Using classedColorRenderer...");p=l(t);r.createClassBreaksRenderer(p).then(e=>{o(e.renderer)}).catch(e=>{console.warn("Error on creating Color Renderer"),i(e)})}else s.isHeatMapRenderer(e)?(console.log("Using heatmap renderer..."),o(g.fromJSON(t))):s.isSimpleRenderer(e)?(console.log("Using simpleRenderer..."),o(d.fromJSON(t))):s.isUniqueRenderer(e)?(console.log("Using uniqueValueRenderer"),o(c.fromJSON(t))):s.isClassBreaksRenderer(e)?(console.log("Using classBreaksRenderer"),o(h.fromJSON(t))):s.isDotDensityRenderer(e)?(console.log("Using Dot Density Renderer"),o(m.fromJSON(t))):s.userSpecifiedAutocastRenderer(e)?(console.log("Autocasting the renderer"),o(t)):(console.warn("Could not infer renderer type"),i("Renderer of type '"+e+"' is not supported. "))}).catch(e=>{console.warn("Error on inferring Renderer"),i(e)})}))}},function(e,t){e.exports=function(e){var t=[];for(var o in e.fields){var i=e.fields[o];t.push({fieldName:i.name,label:i.alias,visible:!0})}return{title:e.title,content:[{type:"fields",fieldInfos:t}]}}},function(e,t,o){var i=o(1),n=o(0),r=i(n),a=n.EsriLoaderOptions;e.exports=function(){return new Promise((function(e,t){r.loadModules(["esri/layers/GraphicsLayer","esri/views/2d/layers/BaseLayerView2D","esri/geometry/Extent","esri/geometry/SpatialReference","esri/geometry/projection","esri/core/watchUtils","esri/core/Collection"],a).then(([t,o,i,n,r,a,s])=>{var l=o.createSubclass({constructor:function(){var e=()=>{this.requestRender()};this.watcher=a.on(this,"layer._imagesToOverlay","change",e,e,e)},render:function(e){var t,o=e.state,i=o.pixelRatio,n=o.size[0],r=o.size[1],a=e.context;for(0!==o.rotation&&(a.translate(n*i*.5,r*i*.5),a.rotate(o.rotation*Math.PI/180),a.translate(-n*i*.5,-r*i*.5)),t=0;t<this.layer._imagesToOverlay.length;t++){var s=this.layer._imagesToOverlay.getItemAt(t),l=[0,0];l=o.toScreenNoRotation(l,s.extent.xmin,s.extent.ymax);var d=[0,0];d=o.toScreenNoRotation(d,s.extent.xmax,s.extent.ymin);a.save(),a.globalAlpha=s.opacity,a.drawImage(s.imgEl,l[0],l[1],d[0]-l[0],d[1]-l[1]),a.restore()}}}),d=t.createSubclass({constructor:function(){this._imagesToOverlay=new s},createLayerView:function(e){if("2d"===e.type)return new l({view:e,layer:this})},tryRemoveImageOverlays:function(e){var t;for(t=0;t<this._imagesToOverlay.length;t++){var o=this._imagesToOverlay.getItemAt(t);e.includes(o.id)&&this._imagesToOverlay.removeAt(t)}},tryOverlayImage:function(e){return new Promise((t,o)=>{r.load().then(()=>{var t="?"+Math.random().toString(36).substring(2),a=e.src+t;fetch(a).then(t=>{if(!t.ok){class e extends Error{constructor(e){super(e),this.name="BadHTTPStatusError",this.status=t.status}}o(new e("Web request to '"+t.url+"' returned status "+t.status+" with message '"+t.statusText+"'."))}var s=new Image;s.onload=()=>{n.fromJSON(e.extent.spatialReference);var t=i.fromJSON(e.extent);t=r.project(t,n.WebMercator);var o=e.opacity,a=e.id;this._imagesToOverlay.add({id:a,imgEl:s,extent:t,opacity:o})},s.src=a}).catch(e=>{o(e)})}).catch(e=>{o(e)})})}});e(d)}).catch(e=>{t(e)})}))}},function(e,t,o){var i=o(23);e.exports="string"==typeof i?i:i.toString()},function(e,t,o){(e.exports=o(24)(!1)).push([e.i,"html, body {\n    height: 100%;\n    width: 100%;\n    margin: 0px;\n    padding: 0px;\n}\n\ndiv.widget-subarea {\n    height: 100%;\n    width:  100%;\n}\n\ndiv.output_area svg {\n    /* This override fixes the issue where certain types of layers (Polygon\n     * layers, load layers, etc.) would not draw in Chrome, or partially draw\n     * in Safari. */\n     max-width: inherit;\n}\n",""])},function(e,t){e.exports=function(e){var t=[];return t.toString=function(){return this.map((function(t){var o=function(e,t){var o=e[1]||"",i=e[3];if(!i)return o;if(t&&"function"==typeof btoa){var n=(a=i,"/*# sourceMappingURL=data:application/json;charset=utf-8;base64,"+btoa(unescape(encodeURIComponent(JSON.stringify(a))))+" */"),r=i.sources.map((function(e){return"/*# sourceURL="+i.sourceRoot+e+" */"}));return[o].concat(r).concat([n]).join("\n")}var a;return[o].join("\n")}(t,e);return t[2]?"@media "+t[2]+"{"+o+"}":o})).join("")},t.i=function(e,o){"string"==typeof e&&(e=[[null,e,""]]);for(var i={},n=0;n<this.length;n++){var r=this[n][0];"number"==typeof r&&(i[r]=!0)}for(n=0;n<e.length;n++){var a=e[n];"number"==typeof a[0]&&i[a[0]]||(o&&!a[2]?a[2]=o:o&&(a[2]="("+a[2]+") and ("+o+")"),t.push(a))}},t}},function(e,t){e.exports=require("@lumino/widgets")},function(e,t){e.exports=require("@jupyterlab/apputils")}])}));
//# sourceMappingURL=arcgis-map-ipywidget-jupyterlab.js.map