module.exports = { 
    sceneToMapEncoded: " data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcHFAkxI5xEXwAAAuxJREFUWMPt10toXVUUBuAvpjSiYJKBxdMWiohIIahsEBKwgwwKFUrxBba2A/GBgsjGKkSpYBEHKjjYWIqiIChoW3wg1gbEF2RgrtUNSilIdSLChZY2TSFKNaFOduVyuDe5iQkqdM3OZp+1/v3/6/xrHy7Fvxw97RZDCKvxEHZhALM4g4N4I+f8x3IBuKxN8fX4DL04iQfxAe7DtdgfQli7XAB6a8X7cAQRvyDgcvyMVWXbPrxcVdXhZrM5t9wMPIw5jOFuvJRzfhGHMIqBnPMpfFiY+cexqva8q5zwo5zzdMv6IXyFmRDCID7Bp9gfYzzQJu9ISmnDUgBcgVvwJaaLLLfjhgJgLQ7gSWyAlNL2etIOoLoC0ItnsQdPhBA24m1cl3M+2dIrt2JwJSQ4V1joDSFswjU4hZnavptxfCU+w3ewG09hO97DOL4IIYyHEAbKvtHCTCvtT8cYN9XWBmKMryyGgVcxWTSezDlfwKOF9rcwG0IYKvq/Xnv3BTweY7xYfLDI+UzXPtBsNueqqhrHc+irqup4s9k8A1VV3V8ccQw7cs5Tre82Gg2NRuPr4eHhbdhaGnZvSuncUqy4D49gZ7HiafyG9/Fazvn8fEljjPfgcEpp5v85jGqnuRJbU0oHO7B1HicWSLMOU4XF63POfZ2asF78qtJIt8UYr04p7Wuz7UTOeahTjhDCA0XKO3LO0yGEY/NOw5bi/aUZn8cP+D7GuDvG2NMtvcXI7sTmmrUvDKAU3ptSmiqWO4GjxSO6jVG8m3Oe69YH/o6U0mNt1iYw0eXp1xcPuXFRF5LliBBCL7bg4/lOv2ATLrJoD3bgG3yHXzGy2GHUKUbajdjaKF5X7PhoATKJP0MIW3BXcdCzSwLQ5eViM9bg25zzkcLKGLbhxzI9V6N/RSTIOb8ZQui/mLNIcm/O+aaaTD+tZBM2sbNc6/fg8xrIC/h9JQGcLf8PsziNjeVzXPos6KL7jy1BrqFL/4T/mfgLBbP14SVdyAQAAAAASUVORK5CYII=",
    mapToSceneEncoded: " data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcHFAg1PeqxBwAAAuBJREFUWMPt10+IlWUUBvDfNMMYBc7MproZuCgJQTIOCHcgwRaGiyirgTLdZRRY9JGBRVKWLSxQ3kVEURAklAoRorkIimBaXMzeVURhbSS4kDTOFBaag23e4HKZP99cZ6jAs3v/fed5zznv85yPq/YvW1/nICIu4PQ8Z1bgHP7AqpzzsisBMNA1Pp1zXjPb5oh4DFvxQM55KiK+vdIIDNTdGBGr8SA25pynFysF1yxg7934aDGd145ARNyCHbhjsYtwoIbzfmzCsdluX1XVoRmmR1NKK3sCEBF92IKT+AY/Y3S2j6SUHqkJqnYEVmAfvi5AWvgrIjbhIezC5FKmYCNuwKmc84kSlV24Dz/gOwxiaEkA5Jzfj4ihf9ZLSh7NOa/tStOPXWF/AV+llMY75oaxN6X09EKfYRtbI2IQL+LzLpCX8WfXmX1YV1XV+uJ8BHuwuxcemMQELuFXrC7P0RzFeDmldABry5PdjZdSSlN1tWDB1DobdVdV9TCOp5TO/3/UcDarqup63JtSOjwPaQ3icWzDcEnfBA7jvZzzxe4z/TWcL8cr2N5sNvtardbJOej6KL7HjYUrLpYivAdjjUbjVLvd/r02gKqqhvAq9mIdjjWbzbFms9lqtVqdzpfhBJ7BGQSuxU8dT/1N7G80Gsfb7fZ0XTV8DXtSSudKlY8Xdny+a98TmC63HsMbOefXcaSo6HDO+Sw+wfbaYjQTeRQQ413T28oNj+acO5/cEXyJ8xExgk/xGd7qpR+Yy64rKVrekZbNuL0Mb8YhrMLKnjqieawfLxfG3Fm6p4O4Nef8SweouzDSK4DRmSS2SPFvJQr9EbEeN+EsuknoziJkCwcwT3PxIZ4txbkfT2EDvoiICWzJOU+Wgjy4FCl4u/QMz6FVhGpHCfsHuBQRa0r+3+21KZ1LDy7g/tKsbIiI2zqWR8raAWzuZsO+xeT1QkhPln+HYUyVH5iP8U4BetX+W/Y3rHL2yx0HDBIAAAAASUVORK5CYII=",
    toNewWindowEncoded: "  data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcUAAIIxu7mQQAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABI0lEQVRYw+1Wy3GDMBTch3JLBanA+TQR0gDz4JB0Y1xISkBAA4EqHOeYU6qAzYVkPAyWYSLii/Ymzb63q89qBAQEXBgyNamquYhs5zSw1v72SNOUp3gkd2VZ5uP5K1dzkrslqxnzRWQD4MVV4zQw5XguP8uyDckGwBeAm1M10Rrnqqq3fd+3JEVEYhc3WkMcQDMM46IoPv7NQJIkdyLS/oiXZXk4VxP5FDfGNEvEz17Cuciy7J7kGwB0XRfXdX0Yp+NoZ/waGMQbABzE35ekKfIkDhF5mhJf7Q6o6sOReFwUxd7BzdM0ffR5BALglaQAiK21eydZZEsSAFpfBkjy2Rhz7Vr5qimoqurTR4JWeYqDgWDAWwpUNb+ogbn/woCAgL/gG9knfWwKBGcvAAAAAElFTkSuQmC",
    toOriginalWindowEncoded:  "data:image/png;base64,iVBORw0KGgoAAAANSUhEUgAAACAAAAAgCAYAAABzenr0AAAABmJLR0QA/wD/AP+gvaeTAAAACXBIWXMAAAsTAAALEwEAmpwYAAAAB3RJTUUH4gcUAAYsnoHHlAAAAB1pVFh0Q29tbWVudAAAAAAAQ3JlYXRlZCB3aXRoIEdJTVBkLmUHAAABG0lEQVRYw+2WMVLDMBBF/9q+BBUlAS5hn8BeqQk1B8HcBgpLowtgnyJwGWtTkFAEOzIgkmHQLzXjeW9nV2sBKSn/PTR1yMwtET3EBInIo7W2PTwvQh9FqfJIMUcFpoy/E6XUrEB27hlIAkngxwJa65umaS7PIsDMt977gYie55ZaKMXM4hhEJFi5iLy87yu5ByDRBIwxA4AhAO93spUxZnOyFtR1fb2rHERUdV23iT6ESqmSmdspeJ7nfSz4rICIlIc/EGZe7eHjOEaBL24BM68AfMCdc6+x9kDxFbiIlM65t5MtIq311R4OoLLWRoUHBUSkJyLJsqz8DfiSFlwAePLe3zHz5ENl6rZEnQEAa6JPW7Zd8txKSfkT2QKASXQbvOVu9AAAAABJRU5ErkJggg==",
    screenshotErrorEncoded: "data:image/png;base64,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"}
