"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancing_1 = require("monocdk/aws-elasticloadbalancing");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
const nag_pack_1 = require("../../../nag-pack");
/**
 * ELBs have access logs enabled - (Control IDs: 10.1, 10.3.1, 10.3.2, 10.3.3, 10.3.4, 10.3.5, 10.3.6, 10.5.4)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancing_1.CfnLoadBalancer) {
        if (node.accessLoggingPolicy == undefined) {
            return false;
        }
        const accessLoggingPolicy = monocdk_1.Stack.of(node).resolve(node.accessLoggingPolicy);
        const enabled = nag_pack_1.resolveIfPrimitive(node, accessLoggingPolicy.enabled);
        if (enabled == false) {
            return false;
        }
    }
    else if (node instanceof aws_elasticloadbalancingv2_1.CfnLoadBalancer) {
        const attributes = monocdk_1.Stack.of(node).resolve(node.loadBalancerAttributes);
        const reg = /"access_logs\.s3\.enabled","value":"true"/gm;
        if (JSON.stringify(attributes).search(reg) == -1) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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