"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticloadbalancingv2_1 = require("monocdk/aws-elasticloadbalancingv2");
const nag_pack_1 = require("../../../nag-pack");
/**
 * ALB HTTP listeners are configured to redirect to HTTPS - (Control IDs: 2.3, 4.1, 8.2.1)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticloadbalancingv2_1.CfnListener) {
        let found = false;
        const protocol = nag_pack_1.resolveIfPrimitive(node, node.protocol);
        const actions = monocdk_1.Stack.of(node).resolve(node.defaultActions);
        if (protocol == 'HTTP') {
            for (const action of actions) {
                if (action.type == 'redirect' &&
                    action.redirectConfig.protocol == 'HTTPS') {
                    found = true;
                }
            }
            if (!found)
                return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoicGNpRHNzMzIxQUxCSHR0cFRvSHR0cHNSZWRpcmVjdGlvbi5qcyIsInNvdXJjZVJvb3QiOiIiLCJzb3VyY2VzIjpbIi4uLy4uLy4uLy4uL3NyYy9QQ0ktRFNTLTMuMi4xL3J1bGVzL2VsYi9wY2lEc3MzMjFBTEJIdHRwVG9IdHRwc1JlZGlyZWN0aW9uLnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7QUFBQTs7O0VBR0U7O0FBRUYscUNBQTZDO0FBQzdDLG1GQUFpRTtBQUNqRSxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLHdDQUFXLEVBQUU7UUFDL0IsSUFBSSxLQUFLLEdBQUcsS0FBSyxDQUFDO1FBQ2xCLE1BQU0sUUFBUSxHQUFHLDZCQUFrQixDQUFDLElBQUksRUFBRSxJQUFJLENBQUMsUUFBUSxDQUFDLENBQUM7UUFDekQsTUFBTSxPQUFPLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGNBQWMsQ0FBQyxDQUFDO1FBRTVELElBQUksUUFBUSxJQUFJLE1BQU0sRUFBRTtZQUN0QixLQUFLLE1BQU0sTUFBTSxJQUFJLE9BQU8sRUFBRTtnQkFDNUIsSUFDRSxNQUFNLENBQUMsSUFBSSxJQUFJLFVBQVU7b0JBQ3pCLE1BQU0sQ0FBQyxjQUFjLENBQUMsUUFBUSxJQUFJLE9BQU8sRUFDekM7b0JBQ0EsS0FBSyxHQUFHLElBQUksQ0FBQztpQkFDZDthQUNGO1lBQ0QsSUFBSSxDQUFDLEtBQUs7Z0JBQUUsT0FBTyxLQUFLLENBQUM7U0FDMUI7S0FDRjtJQUVELE9BQU8sSUFBSSxDQUFDO0FBQ2QsQ0FBQztBQXBCRCw0QkFvQkMiLCJzb3VyY2VzQ29udGVudCI6WyIvKlxuQ29weXJpZ2h0IEFtYXpvbi5jb20sIEluYy4gb3IgaXRzIGFmZmlsaWF0ZXMuIEFsbCBSaWdodHMgUmVzZXJ2ZWQuXG5TUERYLUxpY2Vuc2UtSWRlbnRpZmllcjogQXBhY2hlLTIuMFxuKi9cblxuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5MaXN0ZW5lciB9IGZyb20gJ21vbm9jZGsvYXdzLWVsYXN0aWNsb2FkYmFsYW5jaW5ndjInO1xuaW1wb3J0IHsgcmVzb2x2ZUlmUHJpbWl0aXZlIH0gZnJvbSAnLi4vLi4vLi4vbmFnLXBhY2snO1xuXG4vKipcbiAqIEFMQiBIVFRQIGxpc3RlbmVycyBhcmUgY29uZmlndXJlZCB0byByZWRpcmVjdCB0byBIVFRQUyAtIChDb250cm9sIElEczogMi4zLCA0LjEsIDguMi4xKVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmbkxpc3RlbmVyKSB7XG4gICAgbGV0IGZvdW5kID0gZmFsc2U7XG4gICAgY29uc3QgcHJvdG9jb2wgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbm9kZS5wcm90b2NvbCk7XG4gICAgY29uc3QgYWN0aW9ucyA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5kZWZhdWx0QWN0aW9ucyk7XG5cbiAgICBpZiAocHJvdG9jb2wgPT0gJ0hUVFAnKSB7XG4gICAgICBmb3IgKGNvbnN0IGFjdGlvbiBvZiBhY3Rpb25zKSB7XG4gICAgICAgIGlmIChcbiAgICAgICAgICBhY3Rpb24udHlwZSA9PSAncmVkaXJlY3QnICYmXG4gICAgICAgICAgYWN0aW9uLnJlZGlyZWN0Q29uZmlnLnByb3RvY29sID09ICdIVFRQUydcbiAgICAgICAgKSB7XG4gICAgICAgICAgZm91bmQgPSB0cnVlO1xuICAgICAgICB9XG4gICAgICB9XG4gICAgICBpZiAoIWZvdW5kKSByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG5cbiAgcmV0dXJuIHRydWU7XG59XG4iXX0=