"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_elasticsearch_1 = require("monocdk/aws-elasticsearch");
const aws_opensearchservice_1 = require("monocdk/aws-opensearchservice");
const nag_pack_1 = require("../../../nag-pack");
/**
 * OpenSearch Service domains have encryption at rest enabled - (Control IDs: AU-9(3), CP-9d, SC-8(3), SC-8(4), SC-13a, SC-28(1), SI-19(4))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticsearch_1.CfnDomain || node instanceof aws_opensearchservice_1.CfnDomain) {
        const encryptionAtRestOptions = monocdk_1.Stack.of(node).resolve(node.encryptionAtRestOptions);
        if (encryptionAtRestOptions != undefined) {
            const enabled = nag_pack_1.resolveIfPrimitive(node, encryptionAtRestOptions.enabled);
            if (enabled !== true) {
                return false;
            }
        }
        else {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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