"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_dynamodb_1 = require("monocdk/aws-dynamodb");
const nag_pack_1 = require("../../../nag-pack");
/**
 * DynamoDB tables have Point-in-time Recovery enabled - (Control IDs: CP-9(b), CP-10, SI-12)
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_dynamodb_1.CfnTable) {
        if (node.pointInTimeRecoverySpecification == undefined) {
            return false;
        }
        const pitr = monocdk_1.Stack.of(node).resolve(node.pointInTimeRecoverySpecification);
        const enabled = nag_pack_1.resolveIfPrimitive(node, pitr.pointInTimeRecoveryEnabled);
        if (!enabled) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoibmlzdDgwMDUzcjREeW5hbW9EQlBJVFJFbmFibGVkLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL05JU1QtODAwLTUzLVI0L3J1bGVzL2R5bmFtb2RiL25pc3Q4MDA1M3I0RHluYW1vREJQSVRSRW5hYmxlZC50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE2QztBQUM3Qyx1REFBZ0Q7QUFDaEQsZ0RBQXVEO0FBRXZEOzs7R0FHRztBQUVILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSx1QkFBUSxFQUFFO1FBQzVCLElBQUksSUFBSSxDQUFDLGdDQUFnQyxJQUFJLFNBQVMsRUFBRTtZQUN0RCxPQUFPLEtBQUssQ0FBQztTQUNkO1FBQ0QsTUFBTSxJQUFJLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLGdDQUFnQyxDQUFDLENBQUM7UUFDM0UsTUFBTSxPQUFPLEdBQUcsNkJBQWtCLENBQUMsSUFBSSxFQUFFLElBQUksQ0FBQywwQkFBMEIsQ0FBQyxDQUFDO1FBQzFFLElBQUksQ0FBQyxPQUFPLEVBQUU7WUFDWixPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFaRCw0QkFZQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5UYWJsZSB9IGZyb20gJ21vbm9jZGsvYXdzLWR5bmFtb2RiJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBEeW5hbW9EQiB0YWJsZXMgaGF2ZSBQb2ludC1pbi10aW1lIFJlY292ZXJ5IGVuYWJsZWQgLSAoQ29udHJvbCBJRHM6IENQLTkoYiksIENQLTEwLCBTSS0xMilcbiAqIEBwYXJhbSBub2RlIHRoZSBDZm5SZXNvdXJjZSB0byBjaGVja1xuICovXG5cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblRhYmxlKSB7XG4gICAgaWYgKG5vZGUucG9pbnRJblRpbWVSZWNvdmVyeVNwZWNpZmljYXRpb24gPT0gdW5kZWZpbmVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICAgIGNvbnN0IHBpdHIgPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKG5vZGUucG9pbnRJblRpbWVSZWNvdmVyeVNwZWNpZmljYXRpb24pO1xuICAgIGNvbnN0IGVuYWJsZWQgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgcGl0ci5wb2ludEluVGltZVJlY292ZXJ5RW5hYmxlZCk7XG4gICAgaWYgKCFlbmFibGVkKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19