"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_codebuild_1 = require("monocdk/aws-codebuild");
const nag_pack_1 = require("../../../nag-pack");
/**
 * CodeBuild projects DO NOT store AWS credentials as plaintext environment variables - (Control IDs: AC-6, IA-5(7), SA-3(a))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        //Check for the presence of OAUTH
        const environment = monocdk_1.Stack.of(node).resolve(node.environment);
        const environmentVars = monocdk_1.Stack.of(node).resolve(environment.environmentVariables);
        if (environmentVars != undefined) {
            //For each envvar, check if its a sensitive credential being stored
            for (const envVar of environmentVars) {
                const resolvedEnvVar = monocdk_1.Stack.of(node).resolve(envVar);
                const name = nag_pack_1.resolveIfPrimitive(node, resolvedEnvVar.name);
                const type = nag_pack_1.resolveIfPrimitive(node, resolvedEnvVar.type);
                if (name == 'AWS_ACCESS_KEY_ID' || name == 'AWS_SECRET_ACCESS_KEY') {
                    //is this credential being stored as plaintext?
                    if (type == undefined || type == 'PLAINTEXT') {
                        return false;
                    }
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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