"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_elasticache_1 = require("monocdk/aws-elasticache");
const nag_pack_1 = require("../../../nag-pack");
/**
 * ElastiCache Redis clusters retain automatic backups for at least 15 days - (Control IDs: 164.308(a)(7)(i), 164.308(a)(7)(ii)(A), 164.308(a)(7)(ii)(B))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_elasticache_1.CfnCacheCluster) {
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine.toLowerCase());
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (engine == 'redis' && (retention == undefined || retention < 15)) {
            return false;
        }
    }
    else if (node instanceof aws_elasticache_1.CfnReplicationGroup) {
        const retention = nag_pack_1.resolveIfPrimitive(node, node.snapshotRetentionLimit);
        if (retention == undefined || retention < 15) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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