"use strict";
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
Object.defineProperty(exports, "__esModule", { value: true });
const monocdk_1 = require("monocdk");
const aws_ec2_1 = require("monocdk/aws-ec2");
const nag_pack_1 = require("../../../nag-pack");
/**
 * EC2 instances do not have public IPs - (Control IDs: 164.308(a)(3)(i), 164.308(a)(4)(ii)(A), 164.308(a)(4)(ii)(C), 164.312(a)(1), 164.312(e)(1))
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_ec2_1.CfnInstance) {
        const networkInterfaces = monocdk_1.Stack.of(node).resolve(node.networkInterfaces);
        if (networkInterfaces != undefined) {
            //Iterate through network interfaces, checking if public IPs are enabled
            for (const networkInterface of networkInterfaces) {
                const resolvedInterface = monocdk_1.Stack.of(node).resolve(networkInterface);
                const associatePublicIpAddress = nag_pack_1.resolveIfPrimitive(node, resolvedInterface.associatePublicIpAddress);
                if (associatePublicIpAddress === true) {
                    return false;
                }
            }
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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