"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_stepfunctions_1 = require("monocdk/aws-stepfunctions");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Step Function log "ALL" events to CloudWatch Logs
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_stepfunctions_1.CfnStateMachine) {
        const loggingConfiguration = monocdk_1.Stack.of(node).resolve(node.loggingConfiguration);
        if (loggingConfiguration == undefined) {
            return false;
        }
        const level = nag_pack_1.resolveIfPrimitive(node, loggingConfiguration.level);
        if (level == undefined || level != aws_stepfunctions_1.LogLevel.ALL) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiU0YxLmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9zZXJ2ZXJsZXNzL1NGMS50cyJdLCJuYW1lcyI6W10sIm1hcHBpbmdzIjoiOztBQUFBOzs7RUFHRTtBQUNGLHFDQUE2QztBQUM3QyxpRUFBc0U7QUFDdEUsZ0RBQXVEO0FBRXZEOzs7R0FHRztBQUNILG1CQUF5QixJQUFpQjtJQUN4QyxJQUFJLElBQUksWUFBWSxtQ0FBZSxFQUFFO1FBQ25DLE1BQU0sb0JBQW9CLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQ2pELElBQUksQ0FBQyxvQkFBb0IsQ0FDMUIsQ0FBQztRQUNGLElBQUksb0JBQW9CLElBQUksU0FBUyxFQUFFO1lBQ3JDLE9BQU8sS0FBSyxDQUFDO1NBQ2Q7UUFDRCxNQUFNLEtBQUssR0FBRyw2QkFBa0IsQ0FBQyxJQUFJLEVBQUUsb0JBQW9CLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDbkUsSUFBSSxLQUFLLElBQUksU0FBUyxJQUFJLEtBQUssSUFBSSw0QkFBUSxDQUFDLEdBQUcsRUFBRTtZQUMvQyxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFkRCw0QkFjQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5TdGF0ZU1hY2hpbmUsIExvZ0xldmVsIH0gZnJvbSAnbW9ub2Nkay9hd3Mtc3RlcGZ1bmN0aW9ucyc7XG5pbXBvcnQgeyByZXNvbHZlSWZQcmltaXRpdmUgfSBmcm9tICcuLi8uLi8uLi9uYWctcGFjayc7XG5cbi8qKlxuICogU3RlcCBGdW5jdGlvbiBsb2cgXCJBTExcIiBldmVudHMgdG8gQ2xvdWRXYXRjaCBMb2dzXG4gKiBAcGFyYW0gbm9kZSB0aGUgQ2ZuUmVzb3VyY2UgdG8gY2hlY2tcbiAqL1xuZXhwb3J0IGRlZmF1bHQgZnVuY3Rpb24gKG5vZGU6IENmblJlc291cmNlKTogYm9vbGVhbiB7XG4gIGlmIChub2RlIGluc3RhbmNlb2YgQ2ZuU3RhdGVNYWNoaW5lKSB7XG4gICAgY29uc3QgbG9nZ2luZ0NvbmZpZ3VyYXRpb24gPSBTdGFjay5vZihub2RlKS5yZXNvbHZlKFxuICAgICAgbm9kZS5sb2dnaW5nQ29uZmlndXJhdGlvbixcbiAgICApO1xuICAgIGlmIChsb2dnaW5nQ29uZmlndXJhdGlvbiA9PSB1bmRlZmluZWQpIHtcbiAgICAgIHJldHVybiBmYWxzZTtcbiAgICB9XG4gICAgY29uc3QgbGV2ZWwgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgbG9nZ2luZ0NvbmZpZ3VyYXRpb24ubGV2ZWwpO1xuICAgIGlmIChsZXZlbCA9PSB1bmRlZmluZWQgfHwgbGV2ZWwgIT0gTG9nTGV2ZWwuQUxMKSB7XG4gICAgICByZXR1cm4gZmFsc2U7XG4gICAgfVxuICB9XG4gIHJldHVybiB0cnVlO1xufVxuIl19