"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
/*
Copyright Amazon.com, Inc. or its affiliates. All Rights Reserved.
SPDX-License-Identifier: Apache-2.0
*/
const monocdk_1 = require("monocdk");
const aws_codebuild_1 = require("monocdk/aws-codebuild");
const nag_pack_1 = require("../../../nag-pack");
/**
 * Codebuild projects use images provided by the CodeBuild service or have a cdk_nag suppression rule explaining the need for a custom image
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_codebuild_1.CfnProject) {
        const environment = monocdk_1.Stack.of(node).resolve(node.environment);
        const image = nag_pack_1.resolveIfPrimitive(node, environment.image);
        if (!image.startsWith('aws/codebuild/')) {
            return false;
        }
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,eyJ2ZXJzaW9uIjozLCJmaWxlIjoiQ0I1LmpzIiwic291cmNlUm9vdCI6IiIsInNvdXJjZXMiOlsiLi4vLi4vLi4vLi4vc3JjL0F3c1NvbHV0aW9ucy9ydWxlcy9kZXZlbG9wZXJfdG9vbHMvQ0I1LnRzIl0sIm5hbWVzIjpbXSwibWFwcGluZ3MiOiI7O0FBQUE7OztFQUdFO0FBQ0YscUNBQTZDO0FBQzdDLHlEQUFtRDtBQUNuRCxnREFBdUQ7QUFFdkQ7OztHQUdHO0FBQ0gsbUJBQXlCLElBQWlCO0lBQ3hDLElBQUksSUFBSSxZQUFZLDBCQUFVLEVBQUU7UUFDOUIsTUFBTSxXQUFXLEdBQUcsZUFBSyxDQUFDLEVBQUUsQ0FBQyxJQUFJLENBQUMsQ0FBQyxPQUFPLENBQUMsSUFBSSxDQUFDLFdBQVcsQ0FBQyxDQUFDO1FBQzdELE1BQU0sS0FBSyxHQUFHLDZCQUFrQixDQUFDLElBQUksRUFBRSxXQUFXLENBQUMsS0FBSyxDQUFDLENBQUM7UUFDMUQsSUFBSSxDQUFDLEtBQUssQ0FBQyxVQUFVLENBQUMsZ0JBQWdCLENBQUMsRUFBRTtZQUN2QyxPQUFPLEtBQUssQ0FBQztTQUNkO0tBQ0Y7SUFDRCxPQUFPLElBQUksQ0FBQztBQUNkLENBQUM7QUFURCw0QkFTQyIsInNvdXJjZXNDb250ZW50IjpbIi8qXG5Db3B5cmlnaHQgQW1hem9uLmNvbSwgSW5jLiBvciBpdHMgYWZmaWxpYXRlcy4gQWxsIFJpZ2h0cyBSZXNlcnZlZC5cblNQRFgtTGljZW5zZS1JZGVudGlmaWVyOiBBcGFjaGUtMi4wXG4qL1xuaW1wb3J0IHsgQ2ZuUmVzb3VyY2UsIFN0YWNrIH0gZnJvbSAnbW9ub2Nkayc7XG5pbXBvcnQgeyBDZm5Qcm9qZWN0IH0gZnJvbSAnbW9ub2Nkay9hd3MtY29kZWJ1aWxkJztcbmltcG9ydCB7IHJlc29sdmVJZlByaW1pdGl2ZSB9IGZyb20gJy4uLy4uLy4uL25hZy1wYWNrJztcblxuLyoqXG4gKiBDb2RlYnVpbGQgcHJvamVjdHMgdXNlIGltYWdlcyBwcm92aWRlZCBieSB0aGUgQ29kZUJ1aWxkIHNlcnZpY2Ugb3IgaGF2ZSBhIGNka19uYWcgc3VwcHJlc3Npb24gcnVsZSBleHBsYWluaW5nIHRoZSBuZWVkIGZvciBhIGN1c3RvbSBpbWFnZVxuICogQHBhcmFtIG5vZGUgdGhlIENmblJlc291cmNlIHRvIGNoZWNrXG4gKi9cbmV4cG9ydCBkZWZhdWx0IGZ1bmN0aW9uIChub2RlOiBDZm5SZXNvdXJjZSk6IGJvb2xlYW4ge1xuICBpZiAobm9kZSBpbnN0YW5jZW9mIENmblByb2plY3QpIHtcbiAgICBjb25zdCBlbnZpcm9ubWVudCA9IFN0YWNrLm9mKG5vZGUpLnJlc29sdmUobm9kZS5lbnZpcm9ubWVudCk7XG4gICAgY29uc3QgaW1hZ2UgPSByZXNvbHZlSWZQcmltaXRpdmUobm9kZSwgZW52aXJvbm1lbnQuaW1hZ2UpO1xuICAgIGlmICghaW1hZ2Uuc3RhcnRzV2l0aCgnYXdzL2NvZGVidWlsZC8nKSkge1xuICAgICAgcmV0dXJuIGZhbHNlO1xuICAgIH1cbiAgfVxuICByZXR1cm4gdHJ1ZTtcbn1cbiJdfQ==