"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
const aws_rds_1 = require("monocdk/aws-rds");
const nag_pack_1 = require("../../../nag-pack");
/**
 *  RDS DB instances and Aurora DB clusters do not use the default endpoint ports
 * @param node the CfnResource to check
 */
function default_1(node) {
    if (node instanceof aws_rds_1.CfnDBCluster) {
        if (node.port == undefined) {
            return false;
        }
        const port = nag_pack_1.resolveIfPrimitive(node, node.port);
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine).toLowerCase();
        const engineMode = nag_pack_1.resolveIfPrimitive(node, node.engineMode);
        if (engineMode == undefined || engineMode.toLowerCase() == 'provisioned') {
            if (engine.includes('aurora') && port == 3306) {
                return false;
            }
        }
        else if ((engine == 'aurora' || engine == 'aurora-mysql') &&
            port == 3306) {
            return false;
        }
        else if (engine == 'aurora-postgresql' && port == 5432) {
            return false;
        }
        return true;
    }
    else if (node instanceof aws_rds_1.CfnDBInstance) {
        if (node.engine == undefined) {
            return false;
        }
        const port = nag_pack_1.resolveIfPrimitive(node, node.port);
        const engine = nag_pack_1.resolveIfPrimitive(node, node.engine).toLowerCase();
        if (port == undefined) {
            if (!engine.includes('aurora')) {
                return false;
            }
        }
        else {
            if ((engine == 'mariadb' || engine == 'mysql') && port == 3306) {
                return false;
            }
            else if (engine == 'postgres' && port == 5432) {
                return false;
            }
            else if (engine.includes('oracle') && port == 1521) {
                return false;
            }
            else if (engine.includes('sqlserver') && port == 1433) {
                return false;
            }
        }
        return true;
    }
    return true;
}
exports.default = default_1;
//# sourceMappingURL=data:application/json;base64,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