"""
merge_meshes
============
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class merge_meshes(Operator):
    """Take a set of mesh and assemble them in a unique one

    Parameters
    ----------
    meshes1 : MeshedRegion or MeshesContainer
        Either a meshes container, a vector of meshed
        region to merge or meshed region from
        pin 0 to ...
    meshes2 : MeshedRegion or MeshesContainer
        Either a meshes container, a vector of meshed
        region to merge or meshed region from
        pin 0 to ...


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.merge_meshes()

    >>> # Make input connections
    >>> my_meshes1 = dpf.MeshedRegion()
    >>> op.inputs.meshes1.connect(my_meshes1)
    >>> my_meshes2 = dpf.MeshedRegion()
    >>> op.inputs.meshes2.connect(my_meshes2)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.merge_meshes(
    ...     meshes1=my_meshes1,
    ...     meshes2=my_meshes2,
    ... )

    >>> # Get output data
    >>> result_merges_mesh = op.outputs.merges_mesh()
    """

    def __init__(self, meshes1=None, meshes2=None, config=None, server=None):
        super().__init__(name="merge::mesh", config=config, server=server)
        self._inputs = InputsMergeMeshes(self)
        self._outputs = OutputsMergeMeshes(self)
        if meshes1 is not None:
            self.inputs.meshes1.connect(meshes1)
        if meshes2 is not None:
            self.inputs.meshes2.connect(meshes2)

    @staticmethod
    def _spec():
        description = """Take a set of mesh and assemble them in a unique one"""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="meshes",
                    type_names=["abstract_meshed_region", "meshes_container"],
                    optional=False,
                    document="""Either a meshes container, a vector of meshed
        region to merge or meshed region from
        pin 0 to ...""",
                ),
                1: PinSpecification(
                    name="meshes",
                    type_names=["abstract_meshed_region", "meshes_container"],
                    optional=False,
                    document="""Either a meshes container, a vector of meshed
        region to merge or meshed region from
        pin 0 to ...""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="merges_mesh",
                    type_names=["abstract_meshed_region"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="merge::mesh", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsMergeMeshes
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsMergeMeshes
        """
        return super().outputs


class InputsMergeMeshes(_Inputs):
    """Intermediate class used to connect user inputs to
    merge_meshes operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.merge_meshes()
    >>> my_meshes1 = dpf.MeshedRegion()
    >>> op.inputs.meshes1.connect(my_meshes1)
    >>> my_meshes2 = dpf.MeshedRegion()
    >>> op.inputs.meshes2.connect(my_meshes2)
    """

    def __init__(self, op: Operator):
        super().__init__(merge_meshes._spec().inputs, op)
        self._meshes1 = Input(merge_meshes._spec().input_pin(0), 0, op, 0)
        self._inputs.append(self._meshes1)
        self._meshes2 = Input(merge_meshes._spec().input_pin(1), 1, op, 1)
        self._inputs.append(self._meshes2)

    @property
    def meshes1(self):
        """Allows to connect meshes1 input to the operator.

        Either a meshes container, a vector of meshed
        region to merge or meshed region from
        pin 0 to ...

        Parameters
        ----------
        my_meshes1 : MeshedRegion or MeshesContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.merge_meshes()
        >>> op.inputs.meshes1.connect(my_meshes1)
        >>> # or
        >>> op.inputs.meshes1(my_meshes1)
        """
        return self._meshes1

    @property
    def meshes2(self):
        """Allows to connect meshes2 input to the operator.

        Either a meshes container, a vector of meshed
        region to merge or meshed region from
        pin 0 to ...

        Parameters
        ----------
        my_meshes2 : MeshedRegion or MeshesContainer

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.merge_meshes()
        >>> op.inputs.meshes2.connect(my_meshes2)
        >>> # or
        >>> op.inputs.meshes2(my_meshes2)
        """
        return self._meshes2


class OutputsMergeMeshes(_Outputs):
    """Intermediate class used to get outputs from
    merge_meshes operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.merge_meshes()
    >>> # Connect inputs : op.inputs. ...
    >>> result_merges_mesh = op.outputs.merges_mesh()
    """

    def __init__(self, op: Operator):
        super().__init__(merge_meshes._spec().outputs, op)
        self._merges_mesh = Output(merge_meshes._spec().output_pin(0), 0, op)
        self._outputs.append(self._merges_mesh)

    @property
    def merges_mesh(self):
        """Allows to get merges_mesh output of the operator

        Returns
        ----------
        my_merges_mesh : MeshedRegion

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.merge_meshes()
        >>> # Connect inputs : op.inputs. ...
        >>> result_merges_mesh = op.outputs.merges_mesh()
        """  # noqa: E501
        return self._merges_mesh
