"""
assemble_scalars_to_vectors
===========================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class assemble_scalars_to_vectors(Operator):
    """Take three scalar fields and assemble them as a 3d vector field.

    Parameters
    ----------
    x : Field, optional
    y : Field, optional
    z : Field, optional


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors()

    >>> # Make input connections
    >>> my_x = dpf.Field()
    >>> op.inputs.x.connect(my_x)
    >>> my_y = dpf.Field()
    >>> op.inputs.y.connect(my_y)
    >>> my_z = dpf.Field()
    >>> op.inputs.z.connect(my_z)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors(
    ...     x=my_x,
    ...     y=my_y,
    ...     z=my_z,
    ... )

    >>> # Get output data
    >>> result_field = op.outputs.field()
    """

    def __init__(self, x=None, y=None, z=None, config=None, server=None):
        super().__init__(
            name="assemble_scalars_to_vectors", config=config, server=server
        )
        self._inputs = InputsAssembleScalarsToVectors(self)
        self._outputs = OutputsAssembleScalarsToVectors(self)
        if x is not None:
            self.inputs.x.connect(x)
        if y is not None:
            self.inputs.y.connect(y)
        if z is not None:
            self.inputs.z.connect(z)

    @staticmethod
    def _spec():
        description = (
            """Take three scalar fields and assemble them as a 3d vector field."""
        )
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="x",
                    type_names=["field"],
                    optional=True,
                    document="""""",
                ),
                1: PinSpecification(
                    name="y",
                    type_names=["field"],
                    optional=True,
                    document="""""",
                ),
                2: PinSpecification(
                    name="z",
                    type_names=["field"],
                    optional=True,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="field",
                    type_names=["field"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(
            name="assemble_scalars_to_vectors", server=server
        )

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsAssembleScalarsToVectors
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsAssembleScalarsToVectors
        """
        return super().outputs


class InputsAssembleScalarsToVectors(_Inputs):
    """Intermediate class used to connect user inputs to
    assemble_scalars_to_vectors operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors()
    >>> my_x = dpf.Field()
    >>> op.inputs.x.connect(my_x)
    >>> my_y = dpf.Field()
    >>> op.inputs.y.connect(my_y)
    >>> my_z = dpf.Field()
    >>> op.inputs.z.connect(my_z)
    """

    def __init__(self, op: Operator):
        super().__init__(assemble_scalars_to_vectors._spec().inputs, op)
        self._x = Input(assemble_scalars_to_vectors._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._x)
        self._y = Input(assemble_scalars_to_vectors._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._y)
        self._z = Input(assemble_scalars_to_vectors._spec().input_pin(2), 2, op, -1)
        self._inputs.append(self._z)

    @property
    def x(self):
        """Allows to connect x input to the operator.

        Parameters
        ----------
        my_x : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors()
        >>> op.inputs.x.connect(my_x)
        >>> # or
        >>> op.inputs.x(my_x)
        """
        return self._x

    @property
    def y(self):
        """Allows to connect y input to the operator.

        Parameters
        ----------
        my_y : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors()
        >>> op.inputs.y.connect(my_y)
        >>> # or
        >>> op.inputs.y(my_y)
        """
        return self._y

    @property
    def z(self):
        """Allows to connect z input to the operator.

        Parameters
        ----------
        my_z : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors()
        >>> op.inputs.z.connect(my_z)
        >>> # or
        >>> op.inputs.z(my_z)
        """
        return self._z


class OutputsAssembleScalarsToVectors(_Outputs):
    """Intermediate class used to get outputs from
    assemble_scalars_to_vectors operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.utility.assemble_scalars_to_vectors()
    >>> # Connect inputs : op.inputs. ...
    >>> result_field = op.outputs.field()
    """

    def __init__(self, op: Operator):
        super().__init__(assemble_scalars_to_vectors._spec().outputs, op)
        self._field = Output(assemble_scalars_to_vectors._spec().output_pin(0), 0, op)
        self._outputs.append(self._field)

    @property
    def field(self):
        """Allows to get field output of the operator

        Returns
        ----------
        my_field : Field

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.utility.assemble_scalars_to_vectors()
        >>> # Connect inputs : op.inputs. ...
        >>> result_field = op.outputs.field()
        """  # noqa: E501
        return self._field
