"""
data_tree_to_txt
================
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.outputs import _modify_output_spec_with_one_type
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class data_tree_to_txt(Operator):
    """Writes a txt file or string from a DataTree

    Parameters
    ----------
    data_tree : DataTree
    path : str, optional


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.serialization.data_tree_to_txt()

    >>> # Make input connections
    >>> my_data_tree = dpf.DataTree()
    >>> op.inputs.data_tree.connect(my_data_tree)
    >>> my_path = str()
    >>> op.inputs.path.connect(my_path)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.serialization.data_tree_to_txt(
    ...     data_tree=my_data_tree,
    ...     path=my_path,
    ... )

    >>> # Get output data
    >>> result_data_sources = op.outputs.data_sources()
    """

    def __init__(self, data_tree=None, path=None, config=None, server=None):
        super().__init__(name="data_tree_to_txt", config=config, server=server)
        self._inputs = InputsDataTreeToTxt(self)
        self._outputs = OutputsDataTreeToTxt(self)
        if data_tree is not None:
            self.inputs.data_tree.connect(data_tree)
        if path is not None:
            self.inputs.path.connect(path)

    @staticmethod
    def _spec():
        description = """Writes a txt file or string from a DataTree"""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                0: PinSpecification(
                    name="data_tree",
                    type_names=["abstract_data_tree"],
                    optional=False,
                    document="""""",
                ),
                1: PinSpecification(
                    name="path",
                    type_names=["string"],
                    optional=True,
                    document="""""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources", "string"],
                    optional=False,
                    document="""""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="data_tree_to_txt", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsDataTreeToTxt
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsDataTreeToTxt
        """
        return super().outputs


class InputsDataTreeToTxt(_Inputs):
    """Intermediate class used to connect user inputs to
    data_tree_to_txt operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.serialization.data_tree_to_txt()
    >>> my_data_tree = dpf.DataTree()
    >>> op.inputs.data_tree.connect(my_data_tree)
    >>> my_path = str()
    >>> op.inputs.path.connect(my_path)
    """

    def __init__(self, op: Operator):
        super().__init__(data_tree_to_txt._spec().inputs, op)
        self._data_tree = Input(data_tree_to_txt._spec().input_pin(0), 0, op, -1)
        self._inputs.append(self._data_tree)
        self._path = Input(data_tree_to_txt._spec().input_pin(1), 1, op, -1)
        self._inputs.append(self._path)

    @property
    def data_tree(self):
        """Allows to connect data_tree input to the operator.

        Parameters
        ----------
        my_data_tree : DataTree

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.serialization.data_tree_to_txt()
        >>> op.inputs.data_tree.connect(my_data_tree)
        >>> # or
        >>> op.inputs.data_tree(my_data_tree)
        """
        return self._data_tree

    @property
    def path(self):
        """Allows to connect path input to the operator.

        Parameters
        ----------
        my_path : str

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.serialization.data_tree_to_txt()
        >>> op.inputs.path.connect(my_path)
        >>> # or
        >>> op.inputs.path(my_path)
        """
        return self._path


class OutputsDataTreeToTxt(_Outputs):
    """Intermediate class used to get outputs from
    data_tree_to_txt operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.serialization.data_tree_to_txt()
    >>> # Connect inputs : op.inputs. ...
    >>> result_data_sources = op.outputs.data_sources()
    """

    def __init__(self, op: Operator):
        super().__init__(data_tree_to_txt._spec().outputs, op)
        self.data_sources_as_data_sources = Output(
            _modify_output_spec_with_one_type(
                data_tree_to_txt._spec().output_pin(0), "data_sources"
            ),
            0,
            op,
        )
        self._outputs.append(self.data_sources_as_data_sources)
        self.data_sources_as_string = Output(
            _modify_output_spec_with_one_type(
                data_tree_to_txt._spec().output_pin(0), "string"
            ),
            0,
            op,
        )
        self._outputs.append(self.data_sources_as_string)
