"""
total_mass
==========
Autogenerated DPF operator classes.
"""
from warnings import warn
from ansys.dpf.core.dpf_operator import Operator
from ansys.dpf.core.inputs import Input, _Inputs
from ansys.dpf.core.outputs import Output, _Outputs
from ansys.dpf.core.operators.specification import PinSpecification, Specification


class total_mass(Operator):
    """Reads total mass from mode file.

    Parameters
    ----------
    data_sources : DataSources
        Data sources (must contain at least one mode
        file).


    Examples
    --------
    >>> from ansys.dpf import core as dpf

    >>> # Instantiate operator
    >>> op = dpf.operators.result.total_mass()

    >>> # Make input connections
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)

    >>> # Instantiate operator and connect inputs in one line
    >>> op = dpf.operators.result.total_mass(
    ...     data_sources=my_data_sources,
    ... )

    >>> # Get output data
    >>> result_mass = op.outputs.mass()
    """

    def __init__(self, data_sources=None, config=None, server=None):
        super().__init__(name="mapdl::mode::total_mass", config=config, server=server)
        self._inputs = InputsTotalMass(self)
        self._outputs = OutputsTotalMass(self)
        if data_sources is not None:
            self.inputs.data_sources.connect(data_sources)

    @staticmethod
    def _spec():
        description = """Reads total mass from mode file."""
        spec = Specification(
            description=description,
            map_input_pin_spec={
                4: PinSpecification(
                    name="data_sources",
                    type_names=["data_sources"],
                    optional=False,
                    document="""Data sources (must contain at least one mode
        file).""",
                ),
            },
            map_output_pin_spec={
                0: PinSpecification(
                    name="mass",
                    type_names=["double"],
                    optional=False,
                    document="""The unit should be grabbed from the rst file""",
                ),
            },
        )
        return spec

    @staticmethod
    def default_config(server=None):
        """Returns the default config of the operator.

        This config can then be changed to the user needs and be used to
        instantiate the operator. The Configuration allows to customize
        how the operation will be processed by the operator.

        Parameters
        ----------
        server : server.DPFServer, optional
            Server with channel connected to the remote or local instance. When
            ``None``, attempts to use the global server.
        """
        return Operator.default_config(name="mapdl::mode::total_mass", server=server)

    @property
    def inputs(self):
        """Enables to connect inputs to the operator

        Returns
        --------
        inputs : InputsTotalMass
        """
        return super().inputs

    @property
    def outputs(self):
        """Enables to get outputs of the operator by evaluationg it

        Returns
        --------
        outputs : OutputsTotalMass
        """
        return super().outputs


class InputsTotalMass(_Inputs):
    """Intermediate class used to connect user inputs to
    total_mass operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.total_mass()
    >>> my_data_sources = dpf.DataSources()
    >>> op.inputs.data_sources.connect(my_data_sources)
    """

    def __init__(self, op: Operator):
        super().__init__(total_mass._spec().inputs, op)
        self._data_sources = Input(total_mass._spec().input_pin(4), 4, op, -1)
        self._inputs.append(self._data_sources)

    @property
    def data_sources(self):
        """Allows to connect data_sources input to the operator.

        Data sources (must contain at least one mode
        file).

        Parameters
        ----------
        my_data_sources : DataSources

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.total_mass()
        >>> op.inputs.data_sources.connect(my_data_sources)
        >>> # or
        >>> op.inputs.data_sources(my_data_sources)
        """
        return self._data_sources


class OutputsTotalMass(_Outputs):
    """Intermediate class used to get outputs from
    total_mass operator.

    Examples
    --------
    >>> from ansys.dpf import core as dpf
    >>> op = dpf.operators.result.total_mass()
    >>> # Connect inputs : op.inputs. ...
    >>> result_mass = op.outputs.mass()
    """

    def __init__(self, op: Operator):
        super().__init__(total_mass._spec().outputs, op)
        self._mass = Output(total_mass._spec().output_pin(0), 0, op)
        self._outputs.append(self._mass)

    @property
    def mass(self):
        """Allows to get mass output of the operator

        Returns
        ----------
        my_mass : float

        Examples
        --------
        >>> from ansys.dpf import core as dpf
        >>> op = dpf.operators.result.total_mass()
        >>> # Connect inputs : op.inputs. ...
        >>> result_mass = op.outputs.mass()
        """  # noqa: E501
        return self._mass
