"""Define various activity type constants."""
from activate import units

MARATHON = 42195
# The distances shown in the Curve page
SPECIAL_DISTANCES = {
    "Run": {
        60: "60 m",
        100: "100 m",
        200: "200 m",
        400: "400 m",
        500: "500 m",
        800: "800 m",
        1000: "1000 m",
        1500: "1500 m",
        units.MILE.decode(1): "1 mile",
        2000: "2 km",
        3000: "3 km",
        units.MILE.decode(2): "2 mile",
        5000: "5 km",
        units.MILE.decode(5): "5 mile",
        10000: "10 km",
        15000: "15 km",
        units.MILE.decode(10): "10 mile",
        20000: "20 km",
        MARATHON / 2: "half marathon",
        MARATHON: "marathon",
        50000: "50 km",
        100000: "100 km",
    },
    "Ride": {
        100: "100 m",
        200: "200 m",
        500: "500 m",
        1000: "1 km",
        2000: "2 km",
        3000: "3 km",
        4000: "4 km",
        5000: "5 km",
        10000: "10 km",
        15000: "15 km",
        20000: "20 km",
        25000: "25 km",
        30000: "30 km",
        40000: "40 km",
        50000: "50 km",
        75000: "75 km",
        100000: "100 km",
        150000: "150 km",
        200000: "200 km",
        250000: "250 km",
        300000: "300 km",
        400000: "400 km",
        500000: "500 km",
        1000000: "1000 km",
    },
    "Swim": {
        25: "25 m",
        50: "50 m",
        75: "75 m",
        100: "100 m",
        150: "150 m",
        200: "200 m",
        300: "300 m",
        400: "400 m",
        500: "500 m",
        800: "800 m",
        1000: "1000 m",
        1500: "1500 m",
        units.MILE.decode(1): "1 mile",
        2000: "2 km",
        3000: "3 km",
        units.MILE.decode(2): "2 mile",
        5000: "5 km",
        10000: "10 km",
    },
    "Walk": {
        50: "50 m",
        100: "100 m",
        200: "200 m",
        500: "500 m",
        1000: "1000 m",
        units.MILE.decode(1): "1 mile",
        2000: "2 km",
        units.MILE.decode(2): "2 mile",
        5000: "5 km",
        units.MILE.decode(5): "5 mile",
        10000: "10 km",
        15000: "15 km",
        units.MILE.decode(10): "10 mile",
        20000: "20 km",
        units.MILE.decode(20): "20 mile",
        50000: "50 km",
        units.MILE.decode(50): "50 mile",
        100000: "100 km",
        150000: "150 km",
        units.MILE.decode(100): "100 mile",
        200000: "200 km",
    },
    None: {
        10: "10 m",
        20: "20 m",
        50: "50 m",
        100: "100 m",
        200: "200 m",
        500: "500 m",
        1000: "1 km",
        2000: "2 km",
        5000: "5 km",
        10000: "10 km",
        20000: "20 km",
        50000: "50 km",
        100000: "100 km",
        200000: "200 km",
        500000: "500 km",
        1000000: "1000 km",
    },
}

# The boundaries of the zones
ZONES = {
    "Run": list(range(20)) + [float("inf")],
    "Ride": list(range(0, 60, 2)) + [float("inf")],
    "Swim": [x / 2 for x in range(12)] + [float("inf")],
    "Walk": [x / 2 for x in range(20)] + [float("inf")],
    None: list(range(20)) + [float("inf")],
}

TYPES = ("Run", "Ride", "Swim", "Walk", "Ski", "Row", "Other")
FLAGS = {
    "Run": ("Race", "Long Run", "Workout", "Treadmill"),
    "Ride": ("Race", "Workout"),
}
