# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs

__all__ = [
    'GetBackupResult',
    'AwaitableGetBackupResult',
    'get_backup',
    'get_backup_output',
]

@pulumi.output_type
class GetBackupResult:
    def __init__(__self__, create_time=None, database=None, encryption_info=None, expire_time=None, name=None, referencing_databases=None, size_bytes=None, state=None, version_time=None):
        if create_time and not isinstance(create_time, str):
            raise TypeError("Expected argument 'create_time' to be a str")
        pulumi.set(__self__, "create_time", create_time)
        if database and not isinstance(database, str):
            raise TypeError("Expected argument 'database' to be a str")
        pulumi.set(__self__, "database", database)
        if encryption_info and not isinstance(encryption_info, dict):
            raise TypeError("Expected argument 'encryption_info' to be a dict")
        pulumi.set(__self__, "encryption_info", encryption_info)
        if expire_time and not isinstance(expire_time, str):
            raise TypeError("Expected argument 'expire_time' to be a str")
        pulumi.set(__self__, "expire_time", expire_time)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if referencing_databases and not isinstance(referencing_databases, list):
            raise TypeError("Expected argument 'referencing_databases' to be a list")
        pulumi.set(__self__, "referencing_databases", referencing_databases)
        if size_bytes and not isinstance(size_bytes, str):
            raise TypeError("Expected argument 'size_bytes' to be a str")
        pulumi.set(__self__, "size_bytes", size_bytes)
        if state and not isinstance(state, str):
            raise TypeError("Expected argument 'state' to be a str")
        pulumi.set(__self__, "state", state)
        if version_time and not isinstance(version_time, str):
            raise TypeError("Expected argument 'version_time' to be a str")
        pulumi.set(__self__, "version_time", version_time)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> str:
        """
        The time the CreateBackup request is received. If the request does not specify `version_time`, the `version_time` of the backup will be equivalent to the `create_time`.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def database(self) -> str:
        """
        Required for the CreateBackup operation. Name of the database from which this backup was created. This needs to be in the same instance as the backup. Values are of the form `projects//instances//databases/`.
        """
        return pulumi.get(self, "database")

    @property
    @pulumi.getter(name="encryptionInfo")
    def encryption_info(self) -> 'outputs.EncryptionInfoResponse':
        """
        The encryption information for the backup.
        """
        return pulumi.get(self, "encryption_info")

    @property
    @pulumi.getter(name="expireTime")
    def expire_time(self) -> str:
        """
        Required for the CreateBackup operation. The expiration time of the backup, with microseconds granularity that must be at least 6 hours and at most 366 days from the time the CreateBackup request is processed. Once the `expire_time` has passed, the backup is eligible to be automatically deleted by Cloud Spanner to free the resources used by the backup.
        """
        return pulumi.get(self, "expire_time")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Output only for the CreateBackup operation. Required for the UpdateBackup operation. A globally unique identifier for the backup which cannot be changed. Values are of the form `projects//instances//backups/a-z*[a-z0-9]` The final segment of the name must be between 2 and 60 characters in length. The backup is stored in the location(s) specified in the instance configuration of the instance containing the backup, identified by the prefix of the backup name of the form `projects//instances/`.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter(name="referencingDatabases")
    def referencing_databases(self) -> Sequence[str]:
        """
        The names of the restored databases that reference the backup. The database names are of the form `projects//instances//databases/`. Referencing databases may exist in different instances. The existence of any referencing database prevents the backup from being deleted. When a restored database from the backup enters the `READY` state, the reference to the backup is removed.
        """
        return pulumi.get(self, "referencing_databases")

    @property
    @pulumi.getter(name="sizeBytes")
    def size_bytes(self) -> str:
        """
        Size of the backup in bytes.
        """
        return pulumi.get(self, "size_bytes")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The current state of the backup.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="versionTime")
    def version_time(self) -> str:
        """
        The backup will contain an externally consistent copy of the database at the timestamp specified by `version_time`. If `version_time` is not specified, the system will set `version_time` to the `create_time` of the backup.
        """
        return pulumi.get(self, "version_time")


class AwaitableGetBackupResult(GetBackupResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetBackupResult(
            create_time=self.create_time,
            database=self.database,
            encryption_info=self.encryption_info,
            expire_time=self.expire_time,
            name=self.name,
            referencing_databases=self.referencing_databases,
            size_bytes=self.size_bytes,
            state=self.state,
            version_time=self.version_time)


def get_backup(backup_id: Optional[str] = None,
               instance_id: Optional[str] = None,
               project: Optional[str] = None,
               opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetBackupResult:
    """
    Gets metadata on a pending or completed Backup.
    """
    __args__ = dict()
    __args__['backupId'] = backup_id
    __args__['instanceId'] = instance_id
    __args__['project'] = project
    if opts is None:
        opts = pulumi.InvokeOptions()
    if opts.version is None:
        opts.version = _utilities.get_version()
    __ret__ = pulumi.runtime.invoke('google-native:spanner/v1:getBackup', __args__, opts=opts, typ=GetBackupResult).value

    return AwaitableGetBackupResult(
        create_time=__ret__.create_time,
        database=__ret__.database,
        encryption_info=__ret__.encryption_info,
        expire_time=__ret__.expire_time,
        name=__ret__.name,
        referencing_databases=__ret__.referencing_databases,
        size_bytes=__ret__.size_bytes,
        state=__ret__.state,
        version_time=__ret__.version_time)


@_utilities.lift_output_func(get_backup)
def get_backup_output(backup_id: Optional[pulumi.Input[str]] = None,
                      instance_id: Optional[pulumi.Input[str]] = None,
                      project: Optional[pulumi.Input[Optional[str]]] = None,
                      opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetBackupResult]:
    """
    Gets metadata on a pending or completed Backup.
    """
    ...
