# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AuditConfigResponse',
    'AuditLogConfigResponse',
    'BindingResponse',
    'ContactResponse',
    'ContactSettingsResponse',
    'CustomDnsResponse',
    'DnsSettingsResponse',
    'DsRecordResponse',
    'ExprResponse',
    'GlueRecordResponse',
    'GoogleDomainsDnsResponse',
    'ManagementSettingsResponse',
    'PostalAddressResponse',
]

@pulumi.output_type
class AuditConfigResponse(dict):
    """
    Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "auditLogConfigs":
            suggest = "audit_log_configs"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 audit_log_configs: Sequence['outputs.AuditLogConfigResponse'],
                 service: str):
        """
        Specifies the audit configuration for a service. The configuration determines which permission types are logged, and what identities, if any, are exempted from logging. An AuditConfig must have one or more AuditLogConfigs. If there are AuditConfigs for both `allServices` and a specific service, the union of the two AuditConfigs is used for that service: the log_types specified in each AuditConfig are enabled, and the exempted_members in each AuditLogConfig are exempted. Example Policy with multiple AuditConfigs: { "audit_configs": [ { "service": "allServices", "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" }, { "log_type": "ADMIN_READ" } ] }, { "service": "sampleservice.googleapis.com", "audit_log_configs": [ { "log_type": "DATA_READ" }, { "log_type": "DATA_WRITE", "exempted_members": [ "user:aliya@example.com" ] } ] } ] } For sampleservice, this policy enables DATA_READ, DATA_WRITE and ADMIN_READ logging. It also exempts jose@example.com from DATA_READ logging, and aliya@example.com from DATA_WRITE logging.
        :param Sequence['AuditLogConfigResponse'] audit_log_configs: The configuration for logging of each type of permission.
        :param str service: Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        pulumi.set(__self__, "audit_log_configs", audit_log_configs)
        pulumi.set(__self__, "service", service)

    @property
    @pulumi.getter(name="auditLogConfigs")
    def audit_log_configs(self) -> Sequence['outputs.AuditLogConfigResponse']:
        """
        The configuration for logging of each type of permission.
        """
        return pulumi.get(self, "audit_log_configs")

    @property
    @pulumi.getter
    def service(self) -> str:
        """
        Specifies a service that will be enabled for audit logging. For example, `storage.googleapis.com`, `cloudsql.googleapis.com`. `allServices` is a special value that covers all services.
        """
        return pulumi.get(self, "service")


@pulumi.output_type
class AuditLogConfigResponse(dict):
    """
    Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "exemptedMembers":
            suggest = "exempted_members"
        elif key == "logType":
            suggest = "log_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AuditLogConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AuditLogConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 exempted_members: Sequence[str],
                 log_type: str):
        """
        Provides the configuration for logging a type of permissions. Example: { "audit_log_configs": [ { "log_type": "DATA_READ", "exempted_members": [ "user:jose@example.com" ] }, { "log_type": "DATA_WRITE" } ] } This enables 'DATA_READ' and 'DATA_WRITE' logging, while exempting jose@example.com from DATA_READ logging.
        :param Sequence[str] exempted_members: Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        :param str log_type: The log type that this config enables.
        """
        pulumi.set(__self__, "exempted_members", exempted_members)
        pulumi.set(__self__, "log_type", log_type)

    @property
    @pulumi.getter(name="exemptedMembers")
    def exempted_members(self) -> Sequence[str]:
        """
        Specifies the identities that do not cause logging for this type of permission. Follows the same format of Binding.members.
        """
        return pulumi.get(self, "exempted_members")

    @property
    @pulumi.getter(name="logType")
    def log_type(self) -> str:
        """
        The log type that this config enables.
        """
        return pulumi.get(self, "log_type")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates `members`, or principals, with a `role`.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates `members`, or principals, with a `role`.
        :param 'ExprResponse' condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param str role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ContactResponse(dict):
    """
    Details required for a contact associated with a `Registration`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "faxNumber":
            suggest = "fax_number"
        elif key == "phoneNumber":
            suggest = "phone_number"
        elif key == "postalAddress":
            suggest = "postal_address"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 email: str,
                 fax_number: str,
                 phone_number: str,
                 postal_address: 'outputs.PostalAddressResponse'):
        """
        Details required for a contact associated with a `Registration`.
        :param str email: Email address of the contact.
        :param str fax_number: Fax number of the contact in international format. For example, `"+1-800-555-0123"`.
        :param str phone_number: Phone number of the contact in international format. For example, `"+1-800-555-0123"`.
        :param 'PostalAddressResponse' postal_address: Postal address of the contact.
        """
        pulumi.set(__self__, "email", email)
        pulumi.set(__self__, "fax_number", fax_number)
        pulumi.set(__self__, "phone_number", phone_number)
        pulumi.set(__self__, "postal_address", postal_address)

    @property
    @pulumi.getter
    def email(self) -> str:
        """
        Email address of the contact.
        """
        return pulumi.get(self, "email")

    @property
    @pulumi.getter(name="faxNumber")
    def fax_number(self) -> str:
        """
        Fax number of the contact in international format. For example, `"+1-800-555-0123"`.
        """
        return pulumi.get(self, "fax_number")

    @property
    @pulumi.getter(name="phoneNumber")
    def phone_number(self) -> str:
        """
        Phone number of the contact in international format. For example, `"+1-800-555-0123"`.
        """
        return pulumi.get(self, "phone_number")

    @property
    @pulumi.getter(name="postalAddress")
    def postal_address(self) -> 'outputs.PostalAddressResponse':
        """
        Postal address of the contact.
        """
        return pulumi.get(self, "postal_address")


@pulumi.output_type
class ContactSettingsResponse(dict):
    """
    Defines the contact information associated with a `Registration`. [ICANN](https://icann.org/) requires all domain names to have associated contact information. The `registrant_contact` is considered the domain's legal owner, and often the other contacts are identical.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "adminContact":
            suggest = "admin_contact"
        elif key == "registrantContact":
            suggest = "registrant_contact"
        elif key == "technicalContact":
            suggest = "technical_contact"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ContactSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ContactSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ContactSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 admin_contact: 'outputs.ContactResponse',
                 privacy: str,
                 registrant_contact: 'outputs.ContactResponse',
                 technical_contact: 'outputs.ContactResponse'):
        """
        Defines the contact information associated with a `Registration`. [ICANN](https://icann.org/) requires all domain names to have associated contact information. The `registrant_contact` is considered the domain's legal owner, and often the other contacts are identical.
        :param 'ContactResponse' admin_contact: The administrative contact for the `Registration`.
        :param str privacy: Privacy setting for the contacts associated with the `Registration`.
        :param 'ContactResponse' registrant_contact: The registrant contact for the `Registration`. *Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.* *Warning: For new `Registration`s, the registrant receives an email confirmation that they must complete within 15 days to avoid domain suspension.*
        :param 'ContactResponse' technical_contact: The technical contact for the `Registration`.
        """
        pulumi.set(__self__, "admin_contact", admin_contact)
        pulumi.set(__self__, "privacy", privacy)
        pulumi.set(__self__, "registrant_contact", registrant_contact)
        pulumi.set(__self__, "technical_contact", technical_contact)

    @property
    @pulumi.getter(name="adminContact")
    def admin_contact(self) -> 'outputs.ContactResponse':
        """
        The administrative contact for the `Registration`.
        """
        return pulumi.get(self, "admin_contact")

    @property
    @pulumi.getter
    def privacy(self) -> str:
        """
        Privacy setting for the contacts associated with the `Registration`.
        """
        return pulumi.get(self, "privacy")

    @property
    @pulumi.getter(name="registrantContact")
    def registrant_contact(self) -> 'outputs.ContactResponse':
        """
        The registrant contact for the `Registration`. *Caution: Anyone with access to this email address, phone number, and/or postal address can take control of the domain.* *Warning: For new `Registration`s, the registrant receives an email confirmation that they must complete within 15 days to avoid domain suspension.*
        """
        return pulumi.get(self, "registrant_contact")

    @property
    @pulumi.getter(name="technicalContact")
    def technical_contact(self) -> 'outputs.ContactResponse':
        """
        The technical contact for the `Registration`.
        """
        return pulumi.get(self, "technical_contact")


@pulumi.output_type
class CustomDnsResponse(dict):
    """
    Configuration for an arbitrary DNS provider.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dsRecords":
            suggest = "ds_records"
        elif key == "nameServers":
            suggest = "name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in CustomDnsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        CustomDnsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        CustomDnsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ds_records: Sequence['outputs.DsRecordResponse'],
                 name_servers: Sequence[str]):
        """
        Configuration for an arbitrary DNS provider.
        :param Sequence['DsRecordResponse'] ds_records: The list of DS records for this domain, which are used to enable DNSSEC. The domain's DNS provider can provide the values to set here. If this field is empty, DNSSEC is disabled.
        :param Sequence[str] name_servers: A list of name servers that store the DNS zone for this domain. Each name server is a domain name, with Unicode domain names expressed in Punycode format.
        """
        pulumi.set(__self__, "ds_records", ds_records)
        pulumi.set(__self__, "name_servers", name_servers)

    @property
    @pulumi.getter(name="dsRecords")
    def ds_records(self) -> Sequence['outputs.DsRecordResponse']:
        """
        The list of DS records for this domain, which are used to enable DNSSEC. The domain's DNS provider can provide the values to set here. If this field is empty, DNSSEC is disabled.
        """
        return pulumi.get(self, "ds_records")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Sequence[str]:
        """
        A list of name servers that store the DNS zone for this domain. Each name server is a domain name, with Unicode domain names expressed in Punycode format.
        """
        return pulumi.get(self, "name_servers")


@pulumi.output_type
class DnsSettingsResponse(dict):
    """
    Defines the DNS configuration of a `Registration`, including name servers, DNSSEC, and glue records.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "customDns":
            suggest = "custom_dns"
        elif key == "glueRecords":
            suggest = "glue_records"
        elif key == "googleDomainsDns":
            suggest = "google_domains_dns"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DnsSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DnsSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DnsSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 custom_dns: 'outputs.CustomDnsResponse',
                 glue_records: Sequence['outputs.GlueRecordResponse'],
                 google_domains_dns: 'outputs.GoogleDomainsDnsResponse'):
        """
        Defines the DNS configuration of a `Registration`, including name servers, DNSSEC, and glue records.
        :param 'CustomDnsResponse' custom_dns: An arbitrary DNS provider identified by its name servers.
        :param Sequence['GlueRecordResponse'] glue_records: The list of glue records for this `Registration`. Commonly empty.
        :param 'GoogleDomainsDnsResponse' google_domains_dns: The free DNS zone provided by [Google Domains](https://domains.google/).
        """
        pulumi.set(__self__, "custom_dns", custom_dns)
        pulumi.set(__self__, "glue_records", glue_records)
        pulumi.set(__self__, "google_domains_dns", google_domains_dns)

    @property
    @pulumi.getter(name="customDns")
    def custom_dns(self) -> 'outputs.CustomDnsResponse':
        """
        An arbitrary DNS provider identified by its name servers.
        """
        return pulumi.get(self, "custom_dns")

    @property
    @pulumi.getter(name="glueRecords")
    def glue_records(self) -> Sequence['outputs.GlueRecordResponse']:
        """
        The list of glue records for this `Registration`. Commonly empty.
        """
        return pulumi.get(self, "glue_records")

    @property
    @pulumi.getter(name="googleDomainsDns")
    def google_domains_dns(self) -> 'outputs.GoogleDomainsDnsResponse':
        """
        The free DNS zone provided by [Google Domains](https://domains.google/).
        """
        return pulumi.get(self, "google_domains_dns")


@pulumi.output_type
class DsRecordResponse(dict):
    """
    Defines a Delegation Signer (DS) record, which is needed to enable DNSSEC for a domain. It contains a digest (hash) of a DNSKEY record that must be present in the domain's DNS zone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "digestType":
            suggest = "digest_type"
        elif key == "keyTag":
            suggest = "key_tag"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DsRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DsRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DsRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 algorithm: str,
                 digest: str,
                 digest_type: str,
                 key_tag: int):
        """
        Defines a Delegation Signer (DS) record, which is needed to enable DNSSEC for a domain. It contains a digest (hash) of a DNSKEY record that must be present in the domain's DNS zone.
        :param str algorithm: The algorithm used to generate the referenced DNSKEY.
        :param str digest: The digest generated from the referenced DNSKEY.
        :param str digest_type: The hash function used to generate the digest of the referenced DNSKEY.
        :param int key_tag: The key tag of the record. Must be set in range 0 -- 65535.
        """
        pulumi.set(__self__, "algorithm", algorithm)
        pulumi.set(__self__, "digest", digest)
        pulumi.set(__self__, "digest_type", digest_type)
        pulumi.set(__self__, "key_tag", key_tag)

    @property
    @pulumi.getter
    def algorithm(self) -> str:
        """
        The algorithm used to generate the referenced DNSKEY.
        """
        return pulumi.get(self, "algorithm")

    @property
    @pulumi.getter
    def digest(self) -> str:
        """
        The digest generated from the referenced DNSKEY.
        """
        return pulumi.get(self, "digest")

    @property
    @pulumi.getter(name="digestType")
    def digest_type(self) -> str:
        """
        The hash function used to generate the digest of the referenced DNSKEY.
        """
        return pulumi.get(self, "digest_type")

    @property
    @pulumi.getter(name="keyTag")
    def key_tag(self) -> int:
        """
        The key tag of the record. Must be set in range 0 -- 65535.
        """
        return pulumi.get(self, "key_tag")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GlueRecordResponse(dict):
    """
    Defines a host on your domain that is a DNS name server for your domain and/or other domains. Glue records are a way of making the IP address of a name server known, even when it serves DNS queries for its parent domain. For example, when `ns.example.com` is a name server for `example.com`, the host `ns.example.com` must have a glue record to break the circular DNS reference.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hostName":
            suggest = "host_name"
        elif key == "ipv4Addresses":
            suggest = "ipv4_addresses"
        elif key == "ipv6Addresses":
            suggest = "ipv6_addresses"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GlueRecordResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GlueRecordResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GlueRecordResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 host_name: str,
                 ipv4_addresses: Sequence[str],
                 ipv6_addresses: Sequence[str]):
        """
        Defines a host on your domain that is a DNS name server for your domain and/or other domains. Glue records are a way of making the IP address of a name server known, even when it serves DNS queries for its parent domain. For example, when `ns.example.com` is a name server for `example.com`, the host `ns.example.com` must have a glue record to break the circular DNS reference.
        :param str host_name: Domain name of the host in Punycode format.
        :param Sequence[str] ipv4_addresses: List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. `198.51.100.1`). At least one of `ipv4_address` and `ipv6_address` must be set.
        :param Sequence[str] ipv6_addresses: List of IPv6 addresses corresponding to this host in the standard hexadecimal format (e.g. `2001:db8::`). At least one of `ipv4_address` and `ipv6_address` must be set.
        """
        pulumi.set(__self__, "host_name", host_name)
        pulumi.set(__self__, "ipv4_addresses", ipv4_addresses)
        pulumi.set(__self__, "ipv6_addresses", ipv6_addresses)

    @property
    @pulumi.getter(name="hostName")
    def host_name(self) -> str:
        """
        Domain name of the host in Punycode format.
        """
        return pulumi.get(self, "host_name")

    @property
    @pulumi.getter(name="ipv4Addresses")
    def ipv4_addresses(self) -> Sequence[str]:
        """
        List of IPv4 addresses corresponding to this host in the standard decimal format (e.g. `198.51.100.1`). At least one of `ipv4_address` and `ipv6_address` must be set.
        """
        return pulumi.get(self, "ipv4_addresses")

    @property
    @pulumi.getter(name="ipv6Addresses")
    def ipv6_addresses(self) -> Sequence[str]:
        """
        List of IPv6 addresses corresponding to this host in the standard hexadecimal format (e.g. `2001:db8::`). At least one of `ipv4_address` and `ipv6_address` must be set.
        """
        return pulumi.get(self, "ipv6_addresses")


@pulumi.output_type
class GoogleDomainsDnsResponse(dict):
    """
    Configuration for using the free DNS zone provided by Google Domains as a `Registration`'s `dns_provider`. You cannot configure the DNS zone itself using the API. To configure the DNS zone, go to [Google Domains](https://domains.google/).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dsRecords":
            suggest = "ds_records"
        elif key == "dsState":
            suggest = "ds_state"
        elif key == "nameServers":
            suggest = "name_servers"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GoogleDomainsDnsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GoogleDomainsDnsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GoogleDomainsDnsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 ds_records: Sequence['outputs.DsRecordResponse'],
                 ds_state: str,
                 name_servers: Sequence[str]):
        """
        Configuration for using the free DNS zone provided by Google Domains as a `Registration`'s `dns_provider`. You cannot configure the DNS zone itself using the API. To configure the DNS zone, go to [Google Domains](https://domains.google/).
        :param Sequence['DsRecordResponse'] ds_records: The list of DS records published for this domain. The list is automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`, otherwise it remains empty.
        :param str ds_state: The state of DS records for this domain. Used to enable or disable automatic DNSSEC.
        :param Sequence[str] name_servers: A list of name servers that store the DNS zone for this domain. Each name server is a domain name, with Unicode domain names expressed in Punycode format. This field is automatically populated with the name servers assigned to the Google Domains DNS zone.
        """
        pulumi.set(__self__, "ds_records", ds_records)
        pulumi.set(__self__, "ds_state", ds_state)
        pulumi.set(__self__, "name_servers", name_servers)

    @property
    @pulumi.getter(name="dsRecords")
    def ds_records(self) -> Sequence['outputs.DsRecordResponse']:
        """
        The list of DS records published for this domain. The list is automatically populated when `ds_state` is `DS_RECORDS_PUBLISHED`, otherwise it remains empty.
        """
        return pulumi.get(self, "ds_records")

    @property
    @pulumi.getter(name="dsState")
    def ds_state(self) -> str:
        """
        The state of DS records for this domain. Used to enable or disable automatic DNSSEC.
        """
        return pulumi.get(self, "ds_state")

    @property
    @pulumi.getter(name="nameServers")
    def name_servers(self) -> Sequence[str]:
        """
        A list of name servers that store the DNS zone for this domain. Each name server is a domain name, with Unicode domain names expressed in Punycode format. This field is automatically populated with the name servers assigned to the Google Domains DNS zone.
        """
        return pulumi.get(self, "name_servers")


@pulumi.output_type
class ManagementSettingsResponse(dict):
    """
    Defines renewal, billing, and transfer settings for a `Registration`.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "renewalMethod":
            suggest = "renewal_method"
        elif key == "transferLockState":
            suggest = "transfer_lock_state"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagementSettingsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagementSettingsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagementSettingsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 renewal_method: str,
                 transfer_lock_state: str):
        """
        Defines renewal, billing, and transfer settings for a `Registration`.
        :param str renewal_method: The renewal method for this `Registration`.
        :param str transfer_lock_state: Controls whether the domain can be transferred to another registrar.
        """
        pulumi.set(__self__, "renewal_method", renewal_method)
        pulumi.set(__self__, "transfer_lock_state", transfer_lock_state)

    @property
    @pulumi.getter(name="renewalMethod")
    def renewal_method(self) -> str:
        """
        The renewal method for this `Registration`.
        """
        return pulumi.get(self, "renewal_method")

    @property
    @pulumi.getter(name="transferLockState")
    def transfer_lock_state(self) -> str:
        """
        Controls whether the domain can be transferred to another registrar.
        """
        return pulumi.get(self, "transfer_lock_state")


@pulumi.output_type
class PostalAddressResponse(dict):
    """
    Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations (roads, towns, mountains). In typical usage an address would be created via user input or from importing existing data, depending on the type of process. Advice on address input / editing: - Use an i18n-ready address widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, please see: https://support.google.com/business/answer/6397478
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "addressLines":
            suggest = "address_lines"
        elif key == "administrativeArea":
            suggest = "administrative_area"
        elif key == "languageCode":
            suggest = "language_code"
        elif key == "postalCode":
            suggest = "postal_code"
        elif key == "regionCode":
            suggest = "region_code"
        elif key == "sortingCode":
            suggest = "sorting_code"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PostalAddressResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PostalAddressResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PostalAddressResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 address_lines: Sequence[str],
                 administrative_area: str,
                 language_code: str,
                 locality: str,
                 organization: str,
                 postal_code: str,
                 recipients: Sequence[str],
                 region_code: str,
                 revision: int,
                 sorting_code: str,
                 sublocality: str):
        """
        Represents a postal address, e.g. for postal delivery or payments addresses. Given a postal address, a postal service can deliver items to a premise, P.O. Box or similar. It is not intended to model geographical locations (roads, towns, mountains). In typical usage an address would be created via user input or from importing existing data, depending on the type of process. Advice on address input / editing: - Use an i18n-ready address widget such as https://github.com/google/libaddressinput) - Users should not be presented with UI elements for input or editing of fields outside countries where that field is used. For more guidance on how to use this schema, please see: https://support.google.com/business/answer/6397478
        :param Sequence[str] address_lines: Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        :param str administrative_area: Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        :param str language_code: Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        :param str locality: Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        :param str organization: Optional. The name of the organization at the address.
        :param str postal_code: Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        :param Sequence[str] recipients: Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        :param str region_code: CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See http://cldr.unicode.org/ and http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        :param int revision: The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        :param str sorting_code: Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        :param str sublocality: Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        pulumi.set(__self__, "address_lines", address_lines)
        pulumi.set(__self__, "administrative_area", administrative_area)
        pulumi.set(__self__, "language_code", language_code)
        pulumi.set(__self__, "locality", locality)
        pulumi.set(__self__, "organization", organization)
        pulumi.set(__self__, "postal_code", postal_code)
        pulumi.set(__self__, "recipients", recipients)
        pulumi.set(__self__, "region_code", region_code)
        pulumi.set(__self__, "revision", revision)
        pulumi.set(__self__, "sorting_code", sorting_code)
        pulumi.set(__self__, "sublocality", sublocality)

    @property
    @pulumi.getter(name="addressLines")
    def address_lines(self) -> Sequence[str]:
        """
        Unstructured address lines describing the lower levels of an address. Because values in address_lines do not have type information and may sometimes contain multiple values in a single field (e.g. "Austin, TX"), it is important that the line order is clear. The order of address lines should be "envelope order" for the country/region of the address. In places where this can vary (e.g. Japan), address_language is used to make it explicit (e.g. "ja" for large-to-small ordering and "ja-Latn" or "en" for small-to-large). This way, the most specific line of an address can be selected based on the language. The minimum permitted structural representation of an address consists of a region_code with all remaining information placed in the address_lines. It would be possible to format such an address very approximately without geocoding, but no semantic reasoning could be made about any of the address components until it was at least partially resolved. Creating an address only containing a region_code and address_lines, and then geocoding is the recommended way to handle completely unstructured addresses (as opposed to guessing which parts of the address should be localities or administrative areas).
        """
        return pulumi.get(self, "address_lines")

    @property
    @pulumi.getter(name="administrativeArea")
    def administrative_area(self) -> str:
        """
        Optional. Highest administrative subdivision which is used for postal addresses of a country or region. For example, this can be a state, a province, an oblast, or a prefecture. Specifically, for Spain this is the province and not the autonomous community (e.g. "Barcelona" and not "Catalonia"). Many countries don't use an administrative area in postal addresses. E.g. in Switzerland this should be left unpopulated.
        """
        return pulumi.get(self, "administrative_area")

    @property
    @pulumi.getter(name="languageCode")
    def language_code(self) -> str:
        """
        Optional. BCP-47 language code of the contents of this address (if known). This is often the UI language of the input form or is expected to match one of the languages used in the address' country/region, or their transliterated equivalents. This can affect formatting in certain countries, but is not critical to the correctness of the data and will never affect any validation or other non-formatting related operations. If this value is not known, it should be omitted (rather than specifying a possibly incorrect default). Examples: "zh-Hant", "ja", "ja-Latn", "en".
        """
        return pulumi.get(self, "language_code")

    @property
    @pulumi.getter
    def locality(self) -> str:
        """
        Optional. Generally refers to the city/town portion of the address. Examples: US city, IT comune, UK post town. In regions of the world where localities are not well defined or do not fit into this structure well, leave locality empty and use address_lines.
        """
        return pulumi.get(self, "locality")

    @property
    @pulumi.getter
    def organization(self) -> str:
        """
        Optional. The name of the organization at the address.
        """
        return pulumi.get(self, "organization")

    @property
    @pulumi.getter(name="postalCode")
    def postal_code(self) -> str:
        """
        Optional. Postal code of the address. Not all countries use or require postal codes to be present, but where they are used, they may trigger additional validation with other parts of the address (e.g. state/zip validation in the U.S.A.).
        """
        return pulumi.get(self, "postal_code")

    @property
    @pulumi.getter
    def recipients(self) -> Sequence[str]:
        """
        Optional. The recipient at the address. This field may, under certain circumstances, contain multiline information. For example, it might contain "care of" information.
        """
        return pulumi.get(self, "recipients")

    @property
    @pulumi.getter(name="regionCode")
    def region_code(self) -> str:
        """
        CLDR region code of the country/region of the address. This is never inferred and it is up to the user to ensure the value is correct. See http://cldr.unicode.org/ and http://www.unicode.org/cldr/charts/30/supplemental/territory_information.html for details. Example: "CH" for Switzerland.
        """
        return pulumi.get(self, "region_code")

    @property
    @pulumi.getter
    def revision(self) -> int:
        """
        The schema revision of the `PostalAddress`. This must be set to 0, which is the latest revision. All new revisions **must** be backward compatible with old revisions.
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter(name="sortingCode")
    def sorting_code(self) -> str:
        """
        Optional. Additional, country-specific, sorting code. This is not used in most regions. Where it is used, the value is either a string like "CEDEX", optionally followed by a number (e.g. "CEDEX 7"), or just a number alone, representing the "sector code" (Jamaica), "delivery area indicator" (Malawi) or "post office indicator" (e.g. Côte d'Ivoire).
        """
        return pulumi.get(self, "sorting_code")

    @property
    @pulumi.getter
    def sublocality(self) -> str:
        """
        Optional. Sublocality of the address. For example, this can be neighborhoods, boroughs, districts.
        """
        return pulumi.get(self, "sublocality")


