# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._enums import *

__all__ = [
    'AcceleratorConfigResponse',
    'AutoscalingConfigResponse',
    'BasicAutoscalingAlgorithmResponse',
    'BasicYarnAutoscalingConfigResponse',
    'BindingResponse',
    'ClusterConfigResponse',
    'ClusterMetricsResponse',
    'ClusterSelectorResponse',
    'ClusterStatusResponse',
    'ConfidentialInstanceConfigResponse',
    'DiskConfigResponse',
    'EncryptionConfigResponse',
    'EndpointConfigResponse',
    'EnvironmentConfigResponse',
    'ExecutionConfigResponse',
    'ExprResponse',
    'GceClusterConfigResponse',
    'GkeClusterConfigResponse',
    'HadoopJobResponse',
    'HiveJobResponse',
    'IdentityConfigResponse',
    'InstanceGroupAutoscalingPolicyConfigResponse',
    'InstanceGroupConfigResponse',
    'InstanceReferenceResponse',
    'JobPlacementResponse',
    'JobReferenceResponse',
    'JobSchedulingResponse',
    'JobStatusResponse',
    'KerberosConfigResponse',
    'LifecycleConfigResponse',
    'LoggingConfigResponse',
    'ManagedClusterResponse',
    'ManagedGroupConfigResponse',
    'MetastoreConfigResponse',
    'NamespacedGkeDeploymentTargetResponse',
    'NodeGroupAffinityResponse',
    'NodeInitializationActionResponse',
    'OrderedJobResponse',
    'ParameterValidationResponse',
    'PeripheralsConfigResponse',
    'PigJobResponse',
    'PrestoJobResponse',
    'PySparkBatchResponse',
    'PySparkJobResponse',
    'QueryListResponse',
    'RegexValidationResponse',
    'ReservationAffinityResponse',
    'RuntimeConfigResponse',
    'RuntimeInfoResponse',
    'SecurityConfigResponse',
    'ShieldedInstanceConfigResponse',
    'SoftwareConfigResponse',
    'SparkBatchResponse',
    'SparkHistoryServerConfigResponse',
    'SparkJobResponse',
    'SparkRBatchResponse',
    'SparkRJobResponse',
    'SparkSqlBatchResponse',
    'SparkSqlJobResponse',
    'SparkStandaloneAutoscalingConfigResponse',
    'StateHistoryResponse',
    'TemplateParameterResponse',
    'ValueValidationResponse',
    'WorkflowTemplatePlacementResponse',
    'YarnApplicationResponse',
]

@pulumi.output_type
class AcceleratorConfigResponse(dict):
    """
    Specifies the type and number of accelerator cards attached to the instances of an instance. See GPUs on Compute Engine (https://cloud.google.com/compute/docs/gpus/).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "acceleratorCount":
            suggest = "accelerator_count"
        elif key == "acceleratorTypeUri":
            suggest = "accelerator_type_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AcceleratorConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AcceleratorConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerator_count: int,
                 accelerator_type_uri: str):
        """
        Specifies the type and number of accelerator cards attached to the instances of an instance. See GPUs on Compute Engine (https://cloud.google.com/compute/docs/gpus/).
        :param int accelerator_count: The number of the accelerator cards of this type exposed to this instance.
        :param str accelerator_type_uri: Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See Compute Engine AcceleratorTypes (https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).Examples: https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 nvidia-tesla-k80Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, nvidia-tesla-k80.
        """
        pulumi.set(__self__, "accelerator_count", accelerator_count)
        pulumi.set(__self__, "accelerator_type_uri", accelerator_type_uri)

    @property
    @pulumi.getter(name="acceleratorCount")
    def accelerator_count(self) -> int:
        """
        The number of the accelerator cards of this type exposed to this instance.
        """
        return pulumi.get(self, "accelerator_count")

    @property
    @pulumi.getter(name="acceleratorTypeUri")
    def accelerator_type_uri(self) -> str:
        """
        Full URL, partial URI, or short name of the accelerator type resource to expose to this instance. See Compute Engine AcceleratorTypes (https://cloud.google.com/compute/docs/reference/beta/acceleratorTypes).Examples: https://www.googleapis.com/compute/beta/projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 projects/[project_id]/zones/us-east1-a/acceleratorTypes/nvidia-tesla-k80 nvidia-tesla-k80Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the accelerator type resource, for example, nvidia-tesla-k80.
        """
        return pulumi.get(self, "accelerator_type_uri")


@pulumi.output_type
class AutoscalingConfigResponse(dict):
    """
    Autoscaling Policy config associated with the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "policyUri":
            suggest = "policy_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in AutoscalingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        AutoscalingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        AutoscalingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 policy_uri: str):
        """
        Autoscaling Policy config associated with the cluster.
        :param str policy_uri: Optional. The autoscaling policy used by the cluster.Only resource names including projectid and location (region) are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id] projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]Note that the policy must be in the same project and Dataproc region.
        """
        pulumi.set(__self__, "policy_uri", policy_uri)

    @property
    @pulumi.getter(name="policyUri")
    def policy_uri(self) -> str:
        """
        Optional. The autoscaling policy used by the cluster.Only resource names including projectid and location (region) are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id] projects/[project_id]/locations/[dataproc_region]/autoscalingPolicies/[policy_id]Note that the policy must be in the same project and Dataproc region.
        """
        return pulumi.get(self, "policy_uri")


@pulumi.output_type
class BasicAutoscalingAlgorithmResponse(dict):
    """
    Basic algorithm for autoscaling.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "cooldownPeriod":
            suggest = "cooldown_period"
        elif key == "sparkStandaloneConfig":
            suggest = "spark_standalone_config"
        elif key == "yarnConfig":
            suggest = "yarn_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasicAutoscalingAlgorithmResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasicAutoscalingAlgorithmResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasicAutoscalingAlgorithmResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cooldown_period: str,
                 spark_standalone_config: 'outputs.SparkStandaloneAutoscalingConfigResponse',
                 yarn_config: 'outputs.BasicYarnAutoscalingConfigResponse'):
        """
        Basic algorithm for autoscaling.
        :param str cooldown_period: Optional. Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.Bounds: 2m, 1d. Default: 2m.
        :param 'SparkStandaloneAutoscalingConfigResponse' spark_standalone_config: Optional. Spark Standalone autoscaling configuration
        :param 'BasicYarnAutoscalingConfigResponse' yarn_config: Optional. YARN autoscaling configuration.
        """
        pulumi.set(__self__, "cooldown_period", cooldown_period)
        pulumi.set(__self__, "spark_standalone_config", spark_standalone_config)
        pulumi.set(__self__, "yarn_config", yarn_config)

    @property
    @pulumi.getter(name="cooldownPeriod")
    def cooldown_period(self) -> str:
        """
        Optional. Duration between scaling events. A scaling period starts after the update operation from the previous event has completed.Bounds: 2m, 1d. Default: 2m.
        """
        return pulumi.get(self, "cooldown_period")

    @property
    @pulumi.getter(name="sparkStandaloneConfig")
    def spark_standalone_config(self) -> 'outputs.SparkStandaloneAutoscalingConfigResponse':
        """
        Optional. Spark Standalone autoscaling configuration
        """
        return pulumi.get(self, "spark_standalone_config")

    @property
    @pulumi.getter(name="yarnConfig")
    def yarn_config(self) -> 'outputs.BasicYarnAutoscalingConfigResponse':
        """
        Optional. YARN autoscaling configuration.
        """
        return pulumi.get(self, "yarn_config")


@pulumi.output_type
class BasicYarnAutoscalingConfigResponse(dict):
    """
    Basic autoscaling configurations for YARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracefulDecommissionTimeout":
            suggest = "graceful_decommission_timeout"
        elif key == "scaleDownFactor":
            suggest = "scale_down_factor"
        elif key == "scaleDownMinWorkerFraction":
            suggest = "scale_down_min_worker_fraction"
        elif key == "scaleUpFactor":
            suggest = "scale_up_factor"
        elif key == "scaleUpMinWorkerFraction":
            suggest = "scale_up_min_worker_fraction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in BasicYarnAutoscalingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        BasicYarnAutoscalingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        BasicYarnAutoscalingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 graceful_decommission_timeout: str,
                 scale_down_factor: float,
                 scale_down_min_worker_fraction: float,
                 scale_up_factor: float,
                 scale_up_min_worker_fraction: float):
        """
        Basic autoscaling configurations for YARN.
        :param str graceful_decommission_timeout: Timeout for YARN graceful decommissioning of Node Managers. Specifies the duration to wait for jobs to complete before forcefully removing workers (and potentially interrupting jobs). Only applicable to downscaling operations.Bounds: 0s, 1d.
        :param float scale_down_factor: Fraction of average YARN pending memory in the last cooldown period for which to remove workers. A scale-down factor of 1 will result in scaling down so that there is no available memory remaining after the update (more aggressive scaling). A scale-down factor of 0 disables removing workers, which can be beneficial for autoscaling a single job. See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        :param float scale_down_min_worker_fraction: Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        :param float scale_up_factor: Fraction of average YARN pending memory in the last cooldown period for which to add workers. A scale-up factor of 1.0 will result in scaling up so that there is no pending memory remaining after the update (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling). See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        :param float scale_up_min_worker_fraction: Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> str:
        """
        Timeout for YARN graceful decommissioning of Node Managers. Specifies the duration to wait for jobs to complete before forcefully removing workers (and potentially interrupting jobs). Only applicable to downscaling operations.Bounds: 0s, 1d.
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> float:
        """
        Fraction of average YARN pending memory in the last cooldown period for which to remove workers. A scale-down factor of 1 will result in scaling down so that there is no available memory remaining after the update (more aggressive scaling). A scale-down factor of 0 disables removing workers, which can be beneficial for autoscaling a single job. See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_down_factor")

    @property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> float:
        """
        Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> float:
        """
        Fraction of average YARN pending memory in the last cooldown period for which to add workers. A scale-up factor of 1.0 will result in scaling up so that there is no pending memory remaining after the update (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling). See How autoscaling works (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/autoscaling#how_autoscaling_works) for more information.Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_up_factor")

    @property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> float:
        """
        Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")


@pulumi.output_type
class BindingResponse(dict):
    """
    Associates members, or principals, with a role.
    """
    def __init__(__self__, *,
                 condition: 'outputs.ExprResponse',
                 members: Sequence[str],
                 role: str):
        """
        Associates members, or principals, with a role.
        :param 'ExprResponse' condition: The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        :param Sequence[str] members: Specifies the principals requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        :param str role: Role that is assigned to the list of members, or principals. For example, roles/viewer, roles/editor, or roles/owner.
        """
        pulumi.set(__self__, "condition", condition)
        pulumi.set(__self__, "members", members)
        pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> 'outputs.ExprResponse':
        """
        The condition that is associated with this binding.If the condition evaluates to true, then this binding applies to the current request.If the condition evaluates to false, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding.To learn which resources support conditions in their IAM policies, see the IAM documentation (https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @property
    @pulumi.getter
    def members(self) -> Sequence[str]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. members can have the following values: allUsers: A special identifier that represents anyone who is on the internet; with or without a Google account. allAuthenticatedUsers: A special identifier that represents anyone who is authenticated with a Google account or a service account. user:{emailid}: An email address that represents a specific Google account. For example, alice@example.com . serviceAccount:{emailid}: An email address that represents a service account. For example, my-other-app@appspot.gserviceaccount.com. group:{emailid}: An email address that represents a Google group. For example, admins@example.com. deleted:user:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a user that has been recently deleted. For example, alice@example.com?uid=123456789012345678901. If the user is recovered, this value reverts to user:{emailid} and the recovered user retains the role in the binding. deleted:serviceAccount:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901. If the service account is undeleted, this value reverts to serviceAccount:{emailid} and the undeleted service account retains the role in the binding. deleted:group:{emailid}?uid={uniqueid}: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, admins@example.com?uid=123456789012345678901. If the group is recovered, this value reverts to group:{emailid} and the recovered group retains the role in the binding. domain:{domain}: The G Suite domain (primary) that represents all the users of that domain. For example, google.com or example.com.
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def role(self) -> str:
        """
        Role that is assigned to the list of members, or principals. For example, roles/viewer, roles/editor, or roles/owner.
        """
        return pulumi.get(self, "role")


@pulumi.output_type
class ClusterConfigResponse(dict):
    """
    The cluster config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoscalingConfig":
            suggest = "autoscaling_config"
        elif key == "configBucket":
            suggest = "config_bucket"
        elif key == "encryptionConfig":
            suggest = "encryption_config"
        elif key == "endpointConfig":
            suggest = "endpoint_config"
        elif key == "gceClusterConfig":
            suggest = "gce_cluster_config"
        elif key == "gkeClusterConfig":
            suggest = "gke_cluster_config"
        elif key == "initializationActions":
            suggest = "initialization_actions"
        elif key == "lifecycleConfig":
            suggest = "lifecycle_config"
        elif key == "masterConfig":
            suggest = "master_config"
        elif key == "metastoreConfig":
            suggest = "metastore_config"
        elif key == "secondaryWorkerConfig":
            suggest = "secondary_worker_config"
        elif key == "securityConfig":
            suggest = "security_config"
        elif key == "softwareConfig":
            suggest = "software_config"
        elif key == "tempBucket":
            suggest = "temp_bucket"
        elif key == "workerConfig":
            suggest = "worker_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 autoscaling_config: 'outputs.AutoscalingConfigResponse',
                 config_bucket: str,
                 encryption_config: 'outputs.EncryptionConfigResponse',
                 endpoint_config: 'outputs.EndpointConfigResponse',
                 gce_cluster_config: 'outputs.GceClusterConfigResponse',
                 gke_cluster_config: 'outputs.GkeClusterConfigResponse',
                 initialization_actions: Sequence['outputs.NodeInitializationActionResponse'],
                 lifecycle_config: 'outputs.LifecycleConfigResponse',
                 master_config: 'outputs.InstanceGroupConfigResponse',
                 metastore_config: 'outputs.MetastoreConfigResponse',
                 secondary_worker_config: 'outputs.InstanceGroupConfigResponse',
                 security_config: 'outputs.SecurityConfigResponse',
                 software_config: 'outputs.SoftwareConfigResponse',
                 temp_bucket: str,
                 worker_config: 'outputs.InstanceGroupConfigResponse'):
        """
        The cluster config.
        :param 'AutoscalingConfigResponse' autoscaling_config: Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        :param str config_bucket: Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see Dataproc staging and temp buckets (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        :param 'EncryptionConfigResponse' encryption_config: Optional. Encryption settings for the cluster.
        :param 'EndpointConfigResponse' endpoint_config: Optional. Port/endpoint configuration for this cluster
        :param 'GceClusterConfigResponse' gce_cluster_config: Optional. The shared Compute Engine config settings for all instances in a cluster.
        :param 'GkeClusterConfigResponse' gke_cluster_config: Optional. BETA. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as gce_cluster_config, master_config, worker_config, secondary_worker_config, and autoscaling_config.
        :param Sequence['NodeInitializationActionResponse'] initialization_actions: Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's role metadata to run an executable on a master or worker node, as shown below using curl (you can also use wget): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if [[ "${ROLE}" == 'Master' ]]; then ... master specific actions ... else ... worker specific actions ... fi 
        :param 'LifecycleConfigResponse' lifecycle_config: Optional. Lifecycle setting for the cluster.
        :param 'InstanceGroupConfigResponse' master_config: Optional. The Compute Engine config settings for the cluster's master instance.
        :param 'MetastoreConfigResponse' metastore_config: Optional. Metastore configuration.
        :param 'InstanceGroupConfigResponse' secondary_worker_config: Optional. The Compute Engine config settings for a cluster's secondary worker instances
        :param 'SecurityConfigResponse' security_config: Optional. Security settings for the cluster.
        :param 'SoftwareConfigResponse' software_config: Optional. The config settings for cluster software.
        :param str temp_bucket: Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket (see Dataproc staging and temp buckets (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        :param 'InstanceGroupConfigResponse' worker_config: Optional. The Compute Engine config settings for the cluster's worker instances.
        """
        pulumi.set(__self__, "autoscaling_config", autoscaling_config)
        pulumi.set(__self__, "config_bucket", config_bucket)
        pulumi.set(__self__, "encryption_config", encryption_config)
        pulumi.set(__self__, "endpoint_config", endpoint_config)
        pulumi.set(__self__, "gce_cluster_config", gce_cluster_config)
        pulumi.set(__self__, "gke_cluster_config", gke_cluster_config)
        pulumi.set(__self__, "initialization_actions", initialization_actions)
        pulumi.set(__self__, "lifecycle_config", lifecycle_config)
        pulumi.set(__self__, "master_config", master_config)
        pulumi.set(__self__, "metastore_config", metastore_config)
        pulumi.set(__self__, "secondary_worker_config", secondary_worker_config)
        pulumi.set(__self__, "security_config", security_config)
        pulumi.set(__self__, "software_config", software_config)
        pulumi.set(__self__, "temp_bucket", temp_bucket)
        pulumi.set(__self__, "worker_config", worker_config)

    @property
    @pulumi.getter(name="autoscalingConfig")
    def autoscaling_config(self) -> 'outputs.AutoscalingConfigResponse':
        """
        Optional. Autoscaling config for the policy associated with the cluster. Cluster does not autoscale if this field is unset.
        """
        return pulumi.get(self, "autoscaling_config")

    @property
    @pulumi.getter(name="configBucket")
    def config_bucket(self) -> str:
        """
        Optional. A Cloud Storage bucket used to stage job dependencies, config files, and job driver console output. If you do not specify a staging bucket, Cloud Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's staging bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket (see Dataproc staging and temp buckets (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "config_bucket")

    @property
    @pulumi.getter(name="encryptionConfig")
    def encryption_config(self) -> 'outputs.EncryptionConfigResponse':
        """
        Optional. Encryption settings for the cluster.
        """
        return pulumi.get(self, "encryption_config")

    @property
    @pulumi.getter(name="endpointConfig")
    def endpoint_config(self) -> 'outputs.EndpointConfigResponse':
        """
        Optional. Port/endpoint configuration for this cluster
        """
        return pulumi.get(self, "endpoint_config")

    @property
    @pulumi.getter(name="gceClusterConfig")
    def gce_cluster_config(self) -> 'outputs.GceClusterConfigResponse':
        """
        Optional. The shared Compute Engine config settings for all instances in a cluster.
        """
        return pulumi.get(self, "gce_cluster_config")

    @property
    @pulumi.getter(name="gkeClusterConfig")
    def gke_cluster_config(self) -> 'outputs.GkeClusterConfigResponse':
        """
        Optional. BETA. The Kubernetes Engine config for Dataproc clusters deployed to Kubernetes. Setting this is considered mutually exclusive with Compute Engine-based options such as gce_cluster_config, master_config, worker_config, secondary_worker_config, and autoscaling_config.
        """
        return pulumi.get(self, "gke_cluster_config")

    @property
    @pulumi.getter(name="initializationActions")
    def initialization_actions(self) -> Sequence['outputs.NodeInitializationActionResponse']:
        """
        Optional. Commands to execute on each node after config is completed. By default, executables are run on master and all worker nodes. You can test a node's role metadata to run an executable on a master or worker node, as shown below using curl (you can also use wget): ROLE=$(curl -H Metadata-Flavor:Google http://metadata/computeMetadata/v1/instance/attributes/dataproc-role) if [[ "${ROLE}" == 'Master' ]]; then ... master specific actions ... else ... worker specific actions ... fi 
        """
        return pulumi.get(self, "initialization_actions")

    @property
    @pulumi.getter(name="lifecycleConfig")
    def lifecycle_config(self) -> 'outputs.LifecycleConfigResponse':
        """
        Optional. Lifecycle setting for the cluster.
        """
        return pulumi.get(self, "lifecycle_config")

    @property
    @pulumi.getter(name="masterConfig")
    def master_config(self) -> 'outputs.InstanceGroupConfigResponse':
        """
        Optional. The Compute Engine config settings for the cluster's master instance.
        """
        return pulumi.get(self, "master_config")

    @property
    @pulumi.getter(name="metastoreConfig")
    def metastore_config(self) -> 'outputs.MetastoreConfigResponse':
        """
        Optional. Metastore configuration.
        """
        return pulumi.get(self, "metastore_config")

    @property
    @pulumi.getter(name="secondaryWorkerConfig")
    def secondary_worker_config(self) -> 'outputs.InstanceGroupConfigResponse':
        """
        Optional. The Compute Engine config settings for a cluster's secondary worker instances
        """
        return pulumi.get(self, "secondary_worker_config")

    @property
    @pulumi.getter(name="securityConfig")
    def security_config(self) -> 'outputs.SecurityConfigResponse':
        """
        Optional. Security settings for the cluster.
        """
        return pulumi.get(self, "security_config")

    @property
    @pulumi.getter(name="softwareConfig")
    def software_config(self) -> 'outputs.SoftwareConfigResponse':
        """
        Optional. The config settings for cluster software.
        """
        return pulumi.get(self, "software_config")

    @property
    @pulumi.getter(name="tempBucket")
    def temp_bucket(self) -> str:
        """
        Optional. A Cloud Storage bucket used to store ephemeral cluster and jobs data, such as Spark and MapReduce history files. If you do not specify a temp bucket, Dataproc will determine a Cloud Storage location (US, ASIA, or EU) for your cluster's temp bucket according to the Compute Engine zone where your cluster is deployed, and then create and manage this project-level, per-location bucket. The default bucket has a TTL of 90 days, but you can use any TTL (or none) if you specify a bucket (see Dataproc staging and temp buckets (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/staging-bucket)). This field requires a Cloud Storage bucket name, not a gs://... URI to a Cloud Storage bucket.
        """
        return pulumi.get(self, "temp_bucket")

    @property
    @pulumi.getter(name="workerConfig")
    def worker_config(self) -> 'outputs.InstanceGroupConfigResponse':
        """
        Optional. The Compute Engine config settings for the cluster's worker instances.
        """
        return pulumi.get(self, "worker_config")


@pulumi.output_type
class ClusterMetricsResponse(dict):
    """
    Contains cluster daemon metrics, such as HDFS and YARN stats.Beta Feature: This report is available for testing purposes only. It may be changed before final release.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hdfsMetrics":
            suggest = "hdfs_metrics"
        elif key == "yarnMetrics":
            suggest = "yarn_metrics"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterMetricsResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterMetricsResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterMetricsResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hdfs_metrics: Mapping[str, str],
                 yarn_metrics: Mapping[str, str]):
        """
        Contains cluster daemon metrics, such as HDFS and YARN stats.Beta Feature: This report is available for testing purposes only. It may be changed before final release.
        :param Mapping[str, str] hdfs_metrics: The HDFS metrics.
        :param Mapping[str, str] yarn_metrics: The YARN metrics.
        """
        pulumi.set(__self__, "hdfs_metrics", hdfs_metrics)
        pulumi.set(__self__, "yarn_metrics", yarn_metrics)

    @property
    @pulumi.getter(name="hdfsMetrics")
    def hdfs_metrics(self) -> Mapping[str, str]:
        """
        The HDFS metrics.
        """
        return pulumi.get(self, "hdfs_metrics")

    @property
    @pulumi.getter(name="yarnMetrics")
    def yarn_metrics(self) -> Mapping[str, str]:
        """
        The YARN metrics.
        """
        return pulumi.get(self, "yarn_metrics")


@pulumi.output_type
class ClusterSelectorResponse(dict):
    """
    A selector that chooses target cluster for jobs based on metadata.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterLabels":
            suggest = "cluster_labels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterSelectorResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterSelectorResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterSelectorResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_labels: Mapping[str, str],
                 zone: str):
        """
        A selector that chooses target cluster for jobs based on metadata.
        :param Mapping[str, str] cluster_labels: The cluster labels. Cluster must have all labels to match.
        :param str zone: Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster.If unspecified, the zone of the first cluster matching the selector is used.
        """
        pulumi.set(__self__, "cluster_labels", cluster_labels)
        pulumi.set(__self__, "zone", zone)

    @property
    @pulumi.getter(name="clusterLabels")
    def cluster_labels(self) -> Mapping[str, str]:
        """
        The cluster labels. Cluster must have all labels to match.
        """
        return pulumi.get(self, "cluster_labels")

    @property
    @pulumi.getter
    def zone(self) -> str:
        """
        Optional. The zone where workflow process executes. This parameter does not affect the selection of the cluster.If unspecified, the zone of the first cluster matching the selector is used.
        """
        return pulumi.get(self, "zone")


@pulumi.output_type
class ClusterStatusResponse(dict):
    """
    The status of a cluster and its instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateStartTime":
            suggest = "state_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ClusterStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ClusterStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ClusterStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 detail: str,
                 state: str,
                 state_start_time: str,
                 substate: str):
        """
        The status of a cluster and its instances.
        :param str detail: Optional. Output only. Details of cluster's state.
        :param str state: The cluster's state.
        :param str state_start_time: Time when this state was entered (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str substate: Additional state information that includes status reported by the agent.
        """
        pulumi.set(__self__, "detail", detail)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_start_time", state_start_time)
        pulumi.set(__self__, "substate", substate)

    @property
    @pulumi.getter
    def detail(self) -> str:
        """
        Optional. Output only. Details of cluster's state.
        """
        return pulumi.get(self, "detail")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The cluster's state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> str:
        """
        Time when this state was entered (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "state_start_time")

    @property
    @pulumi.getter
    def substate(self) -> str:
        """
        Additional state information that includes status reported by the agent.
        """
        return pulumi.get(self, "substate")


@pulumi.output_type
class ConfidentialInstanceConfigResponse(dict):
    """
    Confidential Instance Config for clusters using Confidential VMs (https://cloud.google.com/compute/confidential-vm/docs)
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableConfidentialCompute":
            suggest = "enable_confidential_compute"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ConfidentialInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ConfidentialInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ConfidentialInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_confidential_compute: bool):
        """
        Confidential Instance Config for clusters using Confidential VMs (https://cloud.google.com/compute/confidential-vm/docs)
        :param bool enable_confidential_compute: Optional. Defines whether the instance should have confidential compute enabled.
        """
        pulumi.set(__self__, "enable_confidential_compute", enable_confidential_compute)

    @property
    @pulumi.getter(name="enableConfidentialCompute")
    def enable_confidential_compute(self) -> bool:
        """
        Optional. Defines whether the instance should have confidential compute enabled.
        """
        return pulumi.get(self, "enable_confidential_compute")


@pulumi.output_type
class DiskConfigResponse(dict):
    """
    Specifies the config of disk options for a group of VM instances.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "bootDiskSizeGb":
            suggest = "boot_disk_size_gb"
        elif key == "bootDiskType":
            suggest = "boot_disk_type"
        elif key == "localSsdInterface":
            suggest = "local_ssd_interface"
        elif key == "numLocalSsds":
            suggest = "num_local_ssds"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in DiskConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        DiskConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        DiskConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 boot_disk_size_gb: int,
                 boot_disk_type: str,
                 local_ssd_interface: str,
                 num_local_ssds: int):
        """
        Specifies the config of disk options for a group of VM instances.
        :param int boot_disk_size_gb: Optional. Size in GB of the boot disk (default is 500GB).
        :param str boot_disk_type: Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See Disk types (https://cloud.google.com/compute/docs/disks#disk-types).
        :param str local_ssd_interface: Optional. Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express). See SSD Interface types (https://cloud.google.com/compute/docs/disks/local-ssd#performance).
        :param int num_local_ssds: Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and HDFS (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        pulumi.set(__self__, "boot_disk_size_gb", boot_disk_size_gb)
        pulumi.set(__self__, "boot_disk_type", boot_disk_type)
        pulumi.set(__self__, "local_ssd_interface", local_ssd_interface)
        pulumi.set(__self__, "num_local_ssds", num_local_ssds)

    @property
    @pulumi.getter(name="bootDiskSizeGb")
    def boot_disk_size_gb(self) -> int:
        """
        Optional. Size in GB of the boot disk (default is 500GB).
        """
        return pulumi.get(self, "boot_disk_size_gb")

    @property
    @pulumi.getter(name="bootDiskType")
    def boot_disk_type(self) -> str:
        """
        Optional. Type of the boot disk (default is "pd-standard"). Valid values: "pd-balanced" (Persistent Disk Balanced Solid State Drive), "pd-ssd" (Persistent Disk Solid State Drive), or "pd-standard" (Persistent Disk Hard Disk Drive). See Disk types (https://cloud.google.com/compute/docs/disks#disk-types).
        """
        return pulumi.get(self, "boot_disk_type")

    @property
    @pulumi.getter(name="localSsdInterface")
    def local_ssd_interface(self) -> str:
        """
        Optional. Interface type of local SSDs (default is "scsi"). Valid values: "scsi" (Small Computer System Interface), "nvme" (Non-Volatile Memory Express). See SSD Interface types (https://cloud.google.com/compute/docs/disks/local-ssd#performance).
        """
        return pulumi.get(self, "local_ssd_interface")

    @property
    @pulumi.getter(name="numLocalSsds")
    def num_local_ssds(self) -> int:
        """
        Optional. Number of attached SSDs, from 0 to 4 (default is 0). If SSDs are not attached, the boot disk is used to store runtime logs and HDFS (https://hadoop.apache.org/docs/r1.2.1/hdfs_user_guide.html) data. If one or more SSDs are attached, this runtime bulk data is spread across them, and the boot disk contains only basic config and installed binaries.
        """
        return pulumi.get(self, "num_local_ssds")


@pulumi.output_type
class EncryptionConfigResponse(dict):
    """
    Encryption settings for the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gcePdKmsKeyName":
            suggest = "gce_pd_kms_key_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EncryptionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EncryptionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EncryptionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 gce_pd_kms_key_name: str):
        """
        Encryption settings for the cluster.
        :param str gce_pd_kms_key_name: Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        pulumi.set(__self__, "gce_pd_kms_key_name", gce_pd_kms_key_name)

    @property
    @pulumi.getter(name="gcePdKmsKeyName")
    def gce_pd_kms_key_name(self) -> str:
        """
        Optional. The Cloud KMS key name to use for PD disk encryption for all instances in the cluster.
        """
        return pulumi.get(self, "gce_pd_kms_key_name")


@pulumi.output_type
class EndpointConfigResponse(dict):
    """
    Endpoint config for this cluster
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableHttpPortAccess":
            suggest = "enable_http_port_access"
        elif key == "httpPorts":
            suggest = "http_ports"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EndpointConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EndpointConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EndpointConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_http_port_access: bool,
                 http_ports: Mapping[str, str]):
        """
        Endpoint config for this cluster
        :param bool enable_http_port_access: Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        :param Mapping[str, str] http_ports: The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        pulumi.set(__self__, "enable_http_port_access", enable_http_port_access)
        pulumi.set(__self__, "http_ports", http_ports)

    @property
    @pulumi.getter(name="enableHttpPortAccess")
    def enable_http_port_access(self) -> bool:
        """
        Optional. If true, enable http access to specific ports on the cluster from external sources. Defaults to false.
        """
        return pulumi.get(self, "enable_http_port_access")

    @property
    @pulumi.getter(name="httpPorts")
    def http_ports(self) -> Mapping[str, str]:
        """
        The map of port descriptions to URLs. Will only be populated if enable_http_port_access is true.
        """
        return pulumi.get(self, "http_ports")


@pulumi.output_type
class EnvironmentConfigResponse(dict):
    """
    Environment configuration for a workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executionConfig":
            suggest = "execution_config"
        elif key == "peripheralsConfig":
            suggest = "peripherals_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in EnvironmentConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        EnvironmentConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        EnvironmentConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 execution_config: 'outputs.ExecutionConfigResponse',
                 peripherals_config: 'outputs.PeripheralsConfigResponse'):
        """
        Environment configuration for a workload.
        :param 'ExecutionConfigResponse' execution_config: Optional. Execution configuration for a workload.
        :param 'PeripheralsConfigResponse' peripherals_config: Optional. Peripherals configuration that workload has access to.
        """
        pulumi.set(__self__, "execution_config", execution_config)
        pulumi.set(__self__, "peripherals_config", peripherals_config)

    @property
    @pulumi.getter(name="executionConfig")
    def execution_config(self) -> 'outputs.ExecutionConfigResponse':
        """
        Optional. Execution configuration for a workload.
        """
        return pulumi.get(self, "execution_config")

    @property
    @pulumi.getter(name="peripheralsConfig")
    def peripherals_config(self) -> 'outputs.PeripheralsConfigResponse':
        """
        Optional. Peripherals configuration that workload has access to.
        """
        return pulumi.get(self, "peripherals_config")


@pulumi.output_type
class ExecutionConfigResponse(dict):
    """
    Execution configuration for a workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "kmsKey":
            suggest = "kms_key"
        elif key == "networkTags":
            suggest = "network_tags"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "subnetworkUri":
            suggest = "subnetwork_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ExecutionConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ExecutionConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ExecutionConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 kms_key: str,
                 network_tags: Sequence[str],
                 network_uri: str,
                 service_account: str,
                 subnetwork_uri: str):
        """
        Execution configuration for a workload.
        :param str kms_key: Optional. The Cloud KMS key to use for encryption.
        :param Sequence[str] network_tags: Optional. Tags used for network traffic control.
        :param str network_uri: Optional. Network URI to connect workload to.
        :param str service_account: Optional. Service account that used to execute workload.
        :param str subnetwork_uri: Optional. Subnetwork URI to connect workload to.
        """
        pulumi.set(__self__, "kms_key", kms_key)
        pulumi.set(__self__, "network_tags", network_tags)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "subnetwork_uri", subnetwork_uri)

    @property
    @pulumi.getter(name="kmsKey")
    def kms_key(self) -> str:
        """
        Optional. The Cloud KMS key to use for encryption.
        """
        return pulumi.get(self, "kms_key")

    @property
    @pulumi.getter(name="networkTags")
    def network_tags(self) -> Sequence[str]:
        """
        Optional. Tags used for network traffic control.
        """
        return pulumi.get(self, "network_tags")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        Optional. Network URI to connect workload to.
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. Service account that used to execute workload.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="subnetworkUri")
    def subnetwork_uri(self) -> str:
        """
        Optional. Subnetwork URI to connect workload to.
        """
        return pulumi.get(self, "subnetwork_uri")


@pulumi.output_type
class ExprResponse(dict):
    """
    Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
    """
    def __init__(__self__, *,
                 description: str,
                 expression: str,
                 location: str,
                 title: str):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec.Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param str description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param str expression: Textual representation of an expression in Common Expression Language syntax.
        :param str location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param str title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "expression", expression)
        pulumi.set(__self__, "location", location)
        pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def expression(self) -> str:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @property
    @pulumi.getter
    def location(self) -> str:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @property
    @pulumi.getter
    def title(self) -> str:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")


@pulumi.output_type
class GceClusterConfigResponse(dict):
    """
    Common config settings for resources of Compute Engine cluster instances, applicable to all instances in the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "confidentialInstanceConfig":
            suggest = "confidential_instance_config"
        elif key == "internalIpOnly":
            suggest = "internal_ip_only"
        elif key == "networkUri":
            suggest = "network_uri"
        elif key == "nodeGroupAffinity":
            suggest = "node_group_affinity"
        elif key == "privateIpv6GoogleAccess":
            suggest = "private_ipv6_google_access"
        elif key == "reservationAffinity":
            suggest = "reservation_affinity"
        elif key == "serviceAccount":
            suggest = "service_account"
        elif key == "serviceAccountScopes":
            suggest = "service_account_scopes"
        elif key == "shieldedInstanceConfig":
            suggest = "shielded_instance_config"
        elif key == "subnetworkUri":
            suggest = "subnetwork_uri"
        elif key == "zoneUri":
            suggest = "zone_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GceClusterConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GceClusterConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GceClusterConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 confidential_instance_config: 'outputs.ConfidentialInstanceConfigResponse',
                 internal_ip_only: bool,
                 metadata: Mapping[str, str],
                 network_uri: str,
                 node_group_affinity: 'outputs.NodeGroupAffinityResponse',
                 private_ipv6_google_access: str,
                 reservation_affinity: 'outputs.ReservationAffinityResponse',
                 service_account: str,
                 service_account_scopes: Sequence[str],
                 shielded_instance_config: 'outputs.ShieldedInstanceConfigResponse',
                 subnetwork_uri: str,
                 tags: Sequence[str],
                 zone_uri: str):
        """
        Common config settings for resources of Compute Engine cluster instances, applicable to all instances in the cluster.
        :param 'ConfidentialInstanceConfigResponse' confidential_instance_config: Optional. Confidential Instance Config for clusters using Confidential VMs (https://cloud.google.com/compute/confidential-vm/docs).
        :param bool internal_ip_only: Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This internal_ip_only restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        :param Mapping[str, str] metadata: The Compute Engine metadata entries to add to all instances (see Project and instance metadata (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        :param str network_uri: Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither network_uri nor subnetwork_uri is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see Using Subnetworks (https://cloud.google.com/compute/docs/subnetworks) for more information).A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default projects/[project_id]/regions/global/default default
        :param 'NodeGroupAffinityResponse' node_group_affinity: Optional. Node Group Affinity for sole-tenant clusters.
        :param str private_ipv6_google_access: Optional. The type of IPv6 access for a cluster.
        :param 'ReservationAffinityResponse' reservation_affinity: Optional. Reservation Affinity for consuming Zonal reservation.
        :param str service_account: Optional. The Dataproc service account (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see VM Data Plane identity (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services.If not specified, the Compute Engine default service account (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        :param Sequence[str] service_account_scopes: Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: https://www.googleapis.com/auth/cloud.useraccounts.readonly https://www.googleapis.com/auth/devstorage.read_write https://www.googleapis.com/auth/logging.writeIf no scopes are specified, the following defaults are also provided: https://www.googleapis.com/auth/bigquery https://www.googleapis.com/auth/bigtable.admin.table https://www.googleapis.com/auth/bigtable.data https://www.googleapis.com/auth/devstorage.full_control
        :param 'ShieldedInstanceConfigResponse' shielded_instance_config: Optional. Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        :param str subnetwork_uri: Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0 projects/[project_id]/regions/us-east1/subnetworks/sub0 sub0
        :param Sequence[str] tags: The Compute Engine tags to add to all instances (see Tagging instances (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        :param str zone_uri: Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone] projects/[project_id]/zones/[zone] us-central1-f
        """
        pulumi.set(__self__, "confidential_instance_config", confidential_instance_config)
        pulumi.set(__self__, "internal_ip_only", internal_ip_only)
        pulumi.set(__self__, "metadata", metadata)
        pulumi.set(__self__, "network_uri", network_uri)
        pulumi.set(__self__, "node_group_affinity", node_group_affinity)
        pulumi.set(__self__, "private_ipv6_google_access", private_ipv6_google_access)
        pulumi.set(__self__, "reservation_affinity", reservation_affinity)
        pulumi.set(__self__, "service_account", service_account)
        pulumi.set(__self__, "service_account_scopes", service_account_scopes)
        pulumi.set(__self__, "shielded_instance_config", shielded_instance_config)
        pulumi.set(__self__, "subnetwork_uri", subnetwork_uri)
        pulumi.set(__self__, "tags", tags)
        pulumi.set(__self__, "zone_uri", zone_uri)

    @property
    @pulumi.getter(name="confidentialInstanceConfig")
    def confidential_instance_config(self) -> 'outputs.ConfidentialInstanceConfigResponse':
        """
        Optional. Confidential Instance Config for clusters using Confidential VMs (https://cloud.google.com/compute/confidential-vm/docs).
        """
        return pulumi.get(self, "confidential_instance_config")

    @property
    @pulumi.getter(name="internalIpOnly")
    def internal_ip_only(self) -> bool:
        """
        Optional. If true, all instances in the cluster will only have internal IP addresses. By default, clusters are not restricted to internal IP addresses, and will have ephemeral external IP addresses assigned to each instance. This internal_ip_only restriction can only be enabled for subnetwork enabled networks, and all off-cluster dependencies must be configured to be accessible without external IP addresses.
        """
        return pulumi.get(self, "internal_ip_only")

    @property
    @pulumi.getter
    def metadata(self) -> Mapping[str, str]:
        """
        The Compute Engine metadata entries to add to all instances (see Project and instance metadata (https://cloud.google.com/compute/docs/storing-retrieving-metadata#project_and_instance_metadata)).
        """
        return pulumi.get(self, "metadata")

    @property
    @pulumi.getter(name="networkUri")
    def network_uri(self) -> str:
        """
        Optional. The Compute Engine network to be used for machine communications. Cannot be specified with subnetwork_uri. If neither network_uri nor subnetwork_uri is specified, the "default" network of the project is used, if it exists. Cannot be a "Custom Subnet Network" (see Using Subnetworks (https://cloud.google.com/compute/docs/subnetworks) for more information).A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/global/default projects/[project_id]/regions/global/default default
        """
        return pulumi.get(self, "network_uri")

    @property
    @pulumi.getter(name="nodeGroupAffinity")
    def node_group_affinity(self) -> 'outputs.NodeGroupAffinityResponse':
        """
        Optional. Node Group Affinity for sole-tenant clusters.
        """
        return pulumi.get(self, "node_group_affinity")

    @property
    @pulumi.getter(name="privateIpv6GoogleAccess")
    def private_ipv6_google_access(self) -> str:
        """
        Optional. The type of IPv6 access for a cluster.
        """
        return pulumi.get(self, "private_ipv6_google_access")

    @property
    @pulumi.getter(name="reservationAffinity")
    def reservation_affinity(self) -> 'outputs.ReservationAffinityResponse':
        """
        Optional. Reservation Affinity for consuming Zonal reservation.
        """
        return pulumi.get(self, "reservation_affinity")

    @property
    @pulumi.getter(name="serviceAccount")
    def service_account(self) -> str:
        """
        Optional. The Dataproc service account (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/service-accounts#service_accounts_in_dataproc) (also see VM Data Plane identity (https://cloud.google.com/dataproc/docs/concepts/iam/dataproc-principals#vm_service_account_data_plane_identity)) used by Dataproc cluster VM instances to access Google Cloud Platform services.If not specified, the Compute Engine default service account (https://cloud.google.com/compute/docs/access/service-accounts#default_service_account) is used.
        """
        return pulumi.get(self, "service_account")

    @property
    @pulumi.getter(name="serviceAccountScopes")
    def service_account_scopes(self) -> Sequence[str]:
        """
        Optional. The URIs of service account scopes to be included in Compute Engine instances. The following base set of scopes is always included: https://www.googleapis.com/auth/cloud.useraccounts.readonly https://www.googleapis.com/auth/devstorage.read_write https://www.googleapis.com/auth/logging.writeIf no scopes are specified, the following defaults are also provided: https://www.googleapis.com/auth/bigquery https://www.googleapis.com/auth/bigtable.admin.table https://www.googleapis.com/auth/bigtable.data https://www.googleapis.com/auth/devstorage.full_control
        """
        return pulumi.get(self, "service_account_scopes")

    @property
    @pulumi.getter(name="shieldedInstanceConfig")
    def shielded_instance_config(self) -> 'outputs.ShieldedInstanceConfigResponse':
        """
        Optional. Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        """
        return pulumi.get(self, "shielded_instance_config")

    @property
    @pulumi.getter(name="subnetworkUri")
    def subnetwork_uri(self) -> str:
        """
        Optional. The Compute Engine subnetwork to be used for machine communications. Cannot be specified with network_uri.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/regions/us-east1/subnetworks/sub0 projects/[project_id]/regions/us-east1/subnetworks/sub0 sub0
        """
        return pulumi.get(self, "subnetwork_uri")

    @property
    @pulumi.getter
    def tags(self) -> Sequence[str]:
        """
        The Compute Engine tags to add to all instances (see Tagging instances (https://cloud.google.com/compute/docs/label-or-tag-resources#tags)).
        """
        return pulumi.get(self, "tags")

    @property
    @pulumi.getter(name="zoneUri")
    def zone_uri(self) -> str:
        """
        Optional. The zone where the Compute Engine cluster will be located. On a create request, it is required in the "global" region. If omitted in a non-global Dataproc region, the service will pick a zone in the corresponding Compute Engine region. On a get request, zone will always be present.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/[zone] projects/[project_id]/zones/[zone] us-central1-f
        """
        return pulumi.get(self, "zone_uri")


@pulumi.output_type
class GkeClusterConfigResponse(dict):
    """
    The cluster's GKE config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "namespacedGkeDeploymentTarget":
            suggest = "namespaced_gke_deployment_target"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in GkeClusterConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        GkeClusterConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        GkeClusterConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 namespaced_gke_deployment_target: 'outputs.NamespacedGkeDeploymentTargetResponse'):
        """
        The cluster's GKE config.
        :param 'NamespacedGkeDeploymentTargetResponse' namespaced_gke_deployment_target: Optional. A target for the deployment.
        """
        pulumi.set(__self__, "namespaced_gke_deployment_target", namespaced_gke_deployment_target)

    @property
    @pulumi.getter(name="namespacedGkeDeploymentTarget")
    def namespaced_gke_deployment_target(self) -> 'outputs.NamespacedGkeDeploymentTargetResponse':
        """
        Optional. A target for the deployment.
        """
        return pulumi.get(self, "namespaced_gke_deployment_target")


@pulumi.output_type
class HadoopJobResponse(dict):
    """
    A Dataproc job for running Apache Hadoop MapReduce (https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html) jobs on Apache Hadoop YARN (https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HadoopJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HadoopJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HadoopJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_class: str,
                 main_jar_file_uri: str,
                 properties: Mapping[str, str]):
        """
        A Dataproc job for running Apache Hadoop MapReduce (https://hadoop.apache.org/docs/current/hadoop-mapreduce-client/hadoop-mapreduce-client-core/MapReduceTutorial.html) jobs on Apache Hadoop YARN (https://hadoop.apache.org/docs/r2.7.1/hadoop-yarn/hadoop-yarn-site/YARN.html).
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        :param Sequence[str] jar_file_uris: Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        :param 'LoggingConfigResponse' logging_config: Optional. The runtime log config for job execution.
        :param str main_class: The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in jar_file_uris.
        :param str main_jar_file_uri: The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_class", main_class)
        pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted in the working directory of Hadoop drivers and tasks. Supported file types: .jar, .tar, .tar.gz, .tgz, or .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as -libjars or -Dfoo=bar, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS (Hadoop Compatible Filesystem) URIs of files to be copied to the working directory of Hadoop drivers and distributed tasks. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. Jar file URIs to add to the CLASSPATHs of the Hadoop driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> str:
        """
        The name of the driver's main class. The jar file containing the class must be in the default CLASSPATH or specified in jar_file_uris.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> str:
        """
        The HCFS URI of the jar file containing the main class. Examples: 'gs://foo-bucket/analytics-binaries/extract-useful-metrics-mr.jar' 'hdfs:/tmp/test-samples/custom-wordcount.jar' 'file:///home/usr/lib/hadoop-mapreduce/hadoop-mapreduce-examples.jar'
        """
        return pulumi.get(self, "main_jar_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Hadoop. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site and classes in user code.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class HiveJobResponse(dict):
    """
    A Dataproc job for running Apache Hive (https://hive.apache.org/) queries on YARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in HiveJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        HiveJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        HiveJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_on_failure: bool,
                 jar_file_uris: Sequence[str],
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse',
                 script_variables: Mapping[str, str]):
        """
        A Dataproc job for running Apache Hive (https://hive.apache.org/) queries on YARN.
        :param bool continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        :param Mapping[str, str] properties: Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        :param str query_file_uri: The HCFS URI of the script that contains Hive queries.
        :param 'QueryListResponse' query_list: A list of queries.
        :param Mapping[str, str] script_variables: Optional. Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
        """
        pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)
        pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> bool:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATH of the Hive server and Hadoop MapReduce (MR) tasks. Can contain Hive SerDes and UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names and values, used to configure Hive. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/hive/conf/hive-site.xml, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains Hive queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Mapping[str, str]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Hive command: SET name="value";).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class IdentityConfigResponse(dict):
    """
    Identity related configuration, including service account based secure multi-tenancy user mappings.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "userServiceAccountMapping":
            suggest = "user_service_account_mapping"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in IdentityConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        IdentityConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        IdentityConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 user_service_account_mapping: Mapping[str, str]):
        """
        Identity related configuration, including service account based secure multi-tenancy user mappings.
        :param Mapping[str, str] user_service_account_mapping: Map of user to service account.
        """
        pulumi.set(__self__, "user_service_account_mapping", user_service_account_mapping)

    @property
    @pulumi.getter(name="userServiceAccountMapping")
    def user_service_account_mapping(self) -> Mapping[str, str]:
        """
        Map of user to service account.
        """
        return pulumi.get(self, "user_service_account_mapping")


@pulumi.output_type
class InstanceGroupAutoscalingPolicyConfigResponse(dict):
    """
    Configuration for the size bounds of an instance group, including its proportional size to other groups.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxInstances":
            suggest = "max_instances"
        elif key == "minInstances":
            suggest = "min_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupAutoscalingPolicyConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupAutoscalingPolicyConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupAutoscalingPolicyConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_instances: int,
                 min_instances: int,
                 weight: int):
        """
        Configuration for the size bounds of an instance group, including its proportional size to other groups.
        :param int max_instances: Maximum number of instances for this group. Required for primary workers. Note that by default, clusters will not use secondary workers. Required for secondary workers if the minimum secondary instances is set.Primary workers - Bounds: [min_instances, ). Secondary workers - Bounds: [min_instances, ). Default: 0.
        :param int min_instances: Optional. Minimum number of instances for this group.Primary workers - Bounds: 2, max_instances. Default: 2. Secondary workers - Bounds: 0, max_instances. Default: 0.
        :param int weight: Optional. Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group. For example, if primary workers have weight 2, and secondary workers have weight 1, the cluster will have approximately 2 primary workers for each secondary worker.The cluster may not reach the specified balance if constrained by min/max bounds or other autoscaling settings. For example, if max_instances for secondary workers is 0, then only primary workers will be added. The cluster can also be out of balance when created.If weight is not set on any instance group, the cluster will default to equal weight for all groups: the cluster will attempt to maintain an equal number of workers in each group within the configured size bounds for each group. If weight is set for one group only, the cluster will default to zero weight on the unset group. For example if weight is set only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        pulumi.set(__self__, "max_instances", max_instances)
        pulumi.set(__self__, "min_instances", min_instances)
        pulumi.set(__self__, "weight", weight)

    @property
    @pulumi.getter(name="maxInstances")
    def max_instances(self) -> int:
        """
        Maximum number of instances for this group. Required for primary workers. Note that by default, clusters will not use secondary workers. Required for secondary workers if the minimum secondary instances is set.Primary workers - Bounds: [min_instances, ). Secondary workers - Bounds: [min_instances, ). Default: 0.
        """
        return pulumi.get(self, "max_instances")

    @property
    @pulumi.getter(name="minInstances")
    def min_instances(self) -> int:
        """
        Optional. Minimum number of instances for this group.Primary workers - Bounds: 2, max_instances. Default: 2. Secondary workers - Bounds: 0, max_instances. Default: 0.
        """
        return pulumi.get(self, "min_instances")

    @property
    @pulumi.getter
    def weight(self) -> int:
        """
        Optional. Weight for the instance group, which is used to determine the fraction of total workers in the cluster from this instance group. For example, if primary workers have weight 2, and secondary workers have weight 1, the cluster will have approximately 2 primary workers for each secondary worker.The cluster may not reach the specified balance if constrained by min/max bounds or other autoscaling settings. For example, if max_instances for secondary workers is 0, then only primary workers will be added. The cluster can also be out of balance when created.If weight is not set on any instance group, the cluster will default to equal weight for all groups: the cluster will attempt to maintain an equal number of workers in each group within the configured size bounds for each group. If weight is set for one group only, the cluster will default to zero weight on the unset group. For example if weight is set only on primary workers, the cluster will use primary workers only and no secondary workers.
        """
        return pulumi.get(self, "weight")


@pulumi.output_type
class InstanceGroupConfigResponse(dict):
    """
    The config settings for Compute Engine resources in an instance group, such as a master or worker group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diskConfig":
            suggest = "disk_config"
        elif key == "imageUri":
            suggest = "image_uri"
        elif key == "instanceNames":
            suggest = "instance_names"
        elif key == "instanceReferences":
            suggest = "instance_references"
        elif key == "isPreemptible":
            suggest = "is_preemptible"
        elif key == "machineTypeUri":
            suggest = "machine_type_uri"
        elif key == "managedGroupConfig":
            suggest = "managed_group_config"
        elif key == "minCpuPlatform":
            suggest = "min_cpu_platform"
        elif key == "numInstances":
            suggest = "num_instances"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceGroupConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceGroupConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceGroupConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 accelerators: Sequence['outputs.AcceleratorConfigResponse'],
                 disk_config: 'outputs.DiskConfigResponse',
                 image_uri: str,
                 instance_names: Sequence[str],
                 instance_references: Sequence['outputs.InstanceReferenceResponse'],
                 is_preemptible: bool,
                 machine_type_uri: str,
                 managed_group_config: 'outputs.ManagedGroupConfigResponse',
                 min_cpu_platform: str,
                 num_instances: int,
                 preemptibility: str):
        """
        The config settings for Compute Engine resources in an instance group, such as a master or worker group.
        :param Sequence['AcceleratorConfigResponse'] accelerators: Optional. The Compute Engine accelerator configuration for these instances.
        :param 'DiskConfigResponse' disk_config: Optional. Disk option config settings.
        :param str image_uri: Optional. The Compute Engine image resource used for cluster instances.The URI can represent an image or image family.Image examples: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id] projects/[project_id]/global/images/[image-id] image-idImage family examples. Dataproc will use the most recent image from the family: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name] projects/[project_id]/global/images/family/[custom-image-family-name]If the URI is unspecified, it will be inferred from SoftwareConfig.image_version or the system default.
        :param Sequence[str] instance_names: The list of instance names. Dataproc derives the names from cluster_name, num_instances, and the instance group.
        :param Sequence['InstanceReferenceResponse'] instance_references: List of references to Compute Engine instances.
        :param bool is_preemptible: Specifies that this instance group contains preemptible instances.
        :param str machine_type_uri: Optional. The Compute Engine machine type used for cluster instances.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 n1-standard-2Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, n1-standard-2.
        :param 'ManagedGroupConfigResponse' managed_group_config: The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        :param str min_cpu_platform: Optional. Specifies the minimum cpu platform for the Instance Group. See Dataproc -> Minimum CPU Platform (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        :param int num_instances: Optional. The number of VM instances in the instance group. For HA cluster master_config groups, must be set to 3. For standard cluster master_config groups, must be set to 1.
        :param str preemptibility: Optional. Specifies the preemptibility of the instance group.The default value for master and worker groups is NON_PREEMPTIBLE. This default cannot be changed.The default value for secondary instances is PREEMPTIBLE.
        """
        pulumi.set(__self__, "accelerators", accelerators)
        pulumi.set(__self__, "disk_config", disk_config)
        pulumi.set(__self__, "image_uri", image_uri)
        pulumi.set(__self__, "instance_names", instance_names)
        pulumi.set(__self__, "instance_references", instance_references)
        pulumi.set(__self__, "is_preemptible", is_preemptible)
        pulumi.set(__self__, "machine_type_uri", machine_type_uri)
        pulumi.set(__self__, "managed_group_config", managed_group_config)
        pulumi.set(__self__, "min_cpu_platform", min_cpu_platform)
        pulumi.set(__self__, "num_instances", num_instances)
        pulumi.set(__self__, "preemptibility", preemptibility)

    @property
    @pulumi.getter
    def accelerators(self) -> Sequence['outputs.AcceleratorConfigResponse']:
        """
        Optional. The Compute Engine accelerator configuration for these instances.
        """
        return pulumi.get(self, "accelerators")

    @property
    @pulumi.getter(name="diskConfig")
    def disk_config(self) -> 'outputs.DiskConfigResponse':
        """
        Optional. Disk option config settings.
        """
        return pulumi.get(self, "disk_config")

    @property
    @pulumi.getter(name="imageUri")
    def image_uri(self) -> str:
        """
        Optional. The Compute Engine image resource used for cluster instances.The URI can represent an image or image family.Image examples: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/[image-id] projects/[project_id]/global/images/[image-id] image-idImage family examples. Dataproc will use the most recent image from the family: https://www.googleapis.com/compute/beta/projects/[project_id]/global/images/family/[custom-image-family-name] projects/[project_id]/global/images/family/[custom-image-family-name]If the URI is unspecified, it will be inferred from SoftwareConfig.image_version or the system default.
        """
        return pulumi.get(self, "image_uri")

    @property
    @pulumi.getter(name="instanceNames")
    def instance_names(self) -> Sequence[str]:
        """
        The list of instance names. Dataproc derives the names from cluster_name, num_instances, and the instance group.
        """
        return pulumi.get(self, "instance_names")

    @property
    @pulumi.getter(name="instanceReferences")
    def instance_references(self) -> Sequence['outputs.InstanceReferenceResponse']:
        """
        List of references to Compute Engine instances.
        """
        return pulumi.get(self, "instance_references")

    @property
    @pulumi.getter(name="isPreemptible")
    def is_preemptible(self) -> bool:
        """
        Specifies that this instance group contains preemptible instances.
        """
        return pulumi.get(self, "is_preemptible")

    @property
    @pulumi.getter(name="machineTypeUri")
    def machine_type_uri(self) -> str:
        """
        Optional. The Compute Engine machine type used for cluster instances.A full URL, partial URI, or short name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 projects/[project_id]/zones/us-east1-a/machineTypes/n1-standard-2 n1-standard-2Auto Zone Exception: If you are using the Dataproc Auto Zone Placement (https://cloud.google.com/dataproc/docs/concepts/configuring-clusters/auto-zone#using_auto_zone_placement) feature, you must use the short name of the machine type resource, for example, n1-standard-2.
        """
        return pulumi.get(self, "machine_type_uri")

    @property
    @pulumi.getter(name="managedGroupConfig")
    def managed_group_config(self) -> 'outputs.ManagedGroupConfigResponse':
        """
        The config for Compute Engine Instance Group Manager that manages this group. This is only used for preemptible instance groups.
        """
        return pulumi.get(self, "managed_group_config")

    @property
    @pulumi.getter(name="minCpuPlatform")
    def min_cpu_platform(self) -> str:
        """
        Optional. Specifies the minimum cpu platform for the Instance Group. See Dataproc -> Minimum CPU Platform (https://cloud.google.com/dataproc/docs/concepts/compute/dataproc-min-cpu).
        """
        return pulumi.get(self, "min_cpu_platform")

    @property
    @pulumi.getter(name="numInstances")
    def num_instances(self) -> int:
        """
        Optional. The number of VM instances in the instance group. For HA cluster master_config groups, must be set to 3. For standard cluster master_config groups, must be set to 1.
        """
        return pulumi.get(self, "num_instances")

    @property
    @pulumi.getter
    def preemptibility(self) -> str:
        """
        Optional. Specifies the preemptibility of the instance group.The default value for master and worker groups is NON_PREEMPTIBLE. This default cannot be changed.The default value for secondary instances is PREEMPTIBLE.
        """
        return pulumi.get(self, "preemptibility")


@pulumi.output_type
class InstanceReferenceResponse(dict):
    """
    A reference to a Compute Engine instance.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceId":
            suggest = "instance_id"
        elif key == "instanceName":
            suggest = "instance_name"
        elif key == "publicEciesKey":
            suggest = "public_ecies_key"
        elif key == "publicKey":
            suggest = "public_key"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in InstanceReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        InstanceReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        InstanceReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_id: str,
                 instance_name: str,
                 public_ecies_key: str,
                 public_key: str):
        """
        A reference to a Compute Engine instance.
        :param str instance_id: The unique identifier of the Compute Engine instance.
        :param str instance_name: The user-friendly name of the Compute Engine instance.
        :param str public_ecies_key: The public ECIES key used for sharing data with this instance.
        :param str public_key: The public RSA key used for sharing data with this instance.
        """
        pulumi.set(__self__, "instance_id", instance_id)
        pulumi.set(__self__, "instance_name", instance_name)
        pulumi.set(__self__, "public_ecies_key", public_ecies_key)
        pulumi.set(__self__, "public_key", public_key)

    @property
    @pulumi.getter(name="instanceId")
    def instance_id(self) -> str:
        """
        The unique identifier of the Compute Engine instance.
        """
        return pulumi.get(self, "instance_id")

    @property
    @pulumi.getter(name="instanceName")
    def instance_name(self) -> str:
        """
        The user-friendly name of the Compute Engine instance.
        """
        return pulumi.get(self, "instance_name")

    @property
    @pulumi.getter(name="publicEciesKey")
    def public_ecies_key(self) -> str:
        """
        The public ECIES key used for sharing data with this instance.
        """
        return pulumi.get(self, "public_ecies_key")

    @property
    @pulumi.getter(name="publicKey")
    def public_key(self) -> str:
        """
        The public RSA key used for sharing data with this instance.
        """
        return pulumi.get(self, "public_key")


@pulumi.output_type
class JobPlacementResponse(dict):
    """
    Dataproc job config.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterLabels":
            suggest = "cluster_labels"
        elif key == "clusterName":
            suggest = "cluster_name"
        elif key == "clusterUuid":
            suggest = "cluster_uuid"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobPlacementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobPlacementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobPlacementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_labels: Mapping[str, str],
                 cluster_name: str,
                 cluster_uuid: str):
        """
        Dataproc job config.
        :param Mapping[str, str] cluster_labels: Optional. Cluster labels to identify a cluster where the job will be submitted.
        :param str cluster_name: The name of the cluster where the job will be submitted.
        :param str cluster_uuid: A cluster UUID generated by the Dataproc service when the job is submitted.
        """
        pulumi.set(__self__, "cluster_labels", cluster_labels)
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "cluster_uuid", cluster_uuid)

    @property
    @pulumi.getter(name="clusterLabels")
    def cluster_labels(self) -> Mapping[str, str]:
        """
        Optional. Cluster labels to identify a cluster where the job will be submitted.
        """
        return pulumi.get(self, "cluster_labels")

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The name of the cluster where the job will be submitted.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter(name="clusterUuid")
    def cluster_uuid(self) -> str:
        """
        A cluster UUID generated by the Dataproc service when the job is submitted.
        """
        return pulumi.get(self, "cluster_uuid")


@pulumi.output_type
class JobReferenceResponse(dict):
    """
    Encapsulates the full scoping used to reference a job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jobId":
            suggest = "job_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobReferenceResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobReferenceResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobReferenceResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 job_id: str,
                 project: str):
        """
        Encapsulates the full scoping used to reference a job.
        :param str job_id: Optional. The job ID, which must be unique within the project.The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or hyphens (-). The maximum length is 100 characters.If not specified by the caller, the job ID will be provided by the server.
        :param str project: Optional. The ID of the Google Cloud Platform project that the job belongs to. If specified, must match the request project ID.
        """
        pulumi.set(__self__, "job_id", job_id)
        pulumi.set(__self__, "project", project)

    @property
    @pulumi.getter(name="jobId")
    def job_id(self) -> str:
        """
        Optional. The job ID, which must be unique within the project.The ID must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), or hyphens (-). The maximum length is 100 characters.If not specified by the caller, the job ID will be provided by the server.
        """
        return pulumi.get(self, "job_id")

    @property
    @pulumi.getter
    def project(self) -> str:
        """
        Optional. The ID of the Google Cloud Platform project that the job belongs to. If specified, must match the request project ID.
        """
        return pulumi.get(self, "project")


@pulumi.output_type
class JobSchedulingResponse(dict):
    """
    Job scheduling options.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "maxFailuresPerHour":
            suggest = "max_failures_per_hour"
        elif key == "maxFailuresTotal":
            suggest = "max_failures_total"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobSchedulingResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobSchedulingResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobSchedulingResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 max_failures_per_hour: int,
                 max_failures_total: int):
        """
        Job scheduling options.
        :param int max_failures_per_hour: Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window.Maximum value is 10.Note: Currently, this restartable job option is not supported in Dataproc workflow template (https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template) jobs.
        :param int max_failures_total: Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.Note: Currently, this restartable job option is not supported in Dataproc workflow template (https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template) jobs.
        """
        pulumi.set(__self__, "max_failures_per_hour", max_failures_per_hour)
        pulumi.set(__self__, "max_failures_total", max_failures_total)

    @property
    @pulumi.getter(name="maxFailuresPerHour")
    def max_failures_per_hour(self) -> int:
        """
        Optional. Maximum number of times per hour a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed.A job may be reported as thrashing if driver exits with non-zero code 4 times within 10 minute window.Maximum value is 10.Note: Currently, this restartable job option is not supported in Dataproc workflow template (https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template) jobs.
        """
        return pulumi.get(self, "max_failures_per_hour")

    @property
    @pulumi.getter(name="maxFailuresTotal")
    def max_failures_total(self) -> int:
        """
        Optional. Maximum number of times in total a driver may be restarted as a result of driver exiting with non-zero code before job is reported failed. Maximum value is 240.Note: Currently, this restartable job option is not supported in Dataproc workflow template (https://cloud.google.com/dataproc/docs/concepts/workflows/using-workflows#adding_jobs_to_a_template) jobs.
        """
        return pulumi.get(self, "max_failures_total")


@pulumi.output_type
class JobStatusResponse(dict):
    """
    Dataproc job status.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateStartTime":
            suggest = "state_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in JobStatusResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        JobStatusResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 details: str,
                 state: str,
                 state_start_time: str,
                 substate: str):
        """
        Dataproc job status.
        :param str details: Optional. Output only. Job state details, such as an error description if the state is ERROR.
        :param str state: A state message specifying the overall job state.
        :param str state_start_time: The time when this state was entered.
        :param str substate: Additional state information, which includes status reported by the agent.
        """
        pulumi.set(__self__, "details", details)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_start_time", state_start_time)
        pulumi.set(__self__, "substate", substate)

    @property
    @pulumi.getter
    def details(self) -> str:
        """
        Optional. Output only. Job state details, such as an error description if the state is ERROR.
        """
        return pulumi.get(self, "details")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        A state message specifying the overall job state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> str:
        """
        The time when this state was entered.
        """
        return pulumi.get(self, "state_start_time")

    @property
    @pulumi.getter
    def substate(self) -> str:
        """
        Additional state information, which includes status reported by the agent.
        """
        return pulumi.get(self, "substate")


@pulumi.output_type
class KerberosConfigResponse(dict):
    """
    Specifies Kerberos related configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "crossRealmTrustAdminServer":
            suggest = "cross_realm_trust_admin_server"
        elif key == "crossRealmTrustKdc":
            suggest = "cross_realm_trust_kdc"
        elif key == "crossRealmTrustRealm":
            suggest = "cross_realm_trust_realm"
        elif key == "crossRealmTrustSharedPasswordUri":
            suggest = "cross_realm_trust_shared_password_uri"
        elif key == "enableKerberos":
            suggest = "enable_kerberos"
        elif key == "kdcDbKeyUri":
            suggest = "kdc_db_key_uri"
        elif key == "keyPasswordUri":
            suggest = "key_password_uri"
        elif key == "keystorePasswordUri":
            suggest = "keystore_password_uri"
        elif key == "keystoreUri":
            suggest = "keystore_uri"
        elif key == "kmsKeyUri":
            suggest = "kms_key_uri"
        elif key == "rootPrincipalPasswordUri":
            suggest = "root_principal_password_uri"
        elif key == "tgtLifetimeHours":
            suggest = "tgt_lifetime_hours"
        elif key == "truststorePasswordUri":
            suggest = "truststore_password_uri"
        elif key == "truststoreUri":
            suggest = "truststore_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in KerberosConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        KerberosConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        KerberosConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cross_realm_trust_admin_server: str,
                 cross_realm_trust_kdc: str,
                 cross_realm_trust_realm: str,
                 cross_realm_trust_shared_password_uri: str,
                 enable_kerberos: bool,
                 kdc_db_key_uri: str,
                 key_password_uri: str,
                 keystore_password_uri: str,
                 keystore_uri: str,
                 kms_key_uri: str,
                 realm: str,
                 root_principal_password_uri: str,
                 tgt_lifetime_hours: int,
                 truststore_password_uri: str,
                 truststore_uri: str):
        """
        Specifies Kerberos related configuration.
        :param str cross_realm_trust_admin_server: Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param str cross_realm_trust_kdc: Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        :param str cross_realm_trust_realm: Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        :param str cross_realm_trust_shared_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        :param bool enable_kerberos: Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        :param str kdc_db_key_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        :param str key_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        :param str keystore_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        :param str keystore_uri: Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        :param str kms_key_uri: Optional. The uri of the KMS key used to encrypt various sensitive files.
        :param str realm: Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        :param str root_principal_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        :param int tgt_lifetime_hours: Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        :param str truststore_password_uri: Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        :param str truststore_uri: Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        pulumi.set(__self__, "cross_realm_trust_admin_server", cross_realm_trust_admin_server)
        pulumi.set(__self__, "cross_realm_trust_kdc", cross_realm_trust_kdc)
        pulumi.set(__self__, "cross_realm_trust_realm", cross_realm_trust_realm)
        pulumi.set(__self__, "cross_realm_trust_shared_password_uri", cross_realm_trust_shared_password_uri)
        pulumi.set(__self__, "enable_kerberos", enable_kerberos)
        pulumi.set(__self__, "kdc_db_key_uri", kdc_db_key_uri)
        pulumi.set(__self__, "key_password_uri", key_password_uri)
        pulumi.set(__self__, "keystore_password_uri", keystore_password_uri)
        pulumi.set(__self__, "keystore_uri", keystore_uri)
        pulumi.set(__self__, "kms_key_uri", kms_key_uri)
        pulumi.set(__self__, "realm", realm)
        pulumi.set(__self__, "root_principal_password_uri", root_principal_password_uri)
        pulumi.set(__self__, "tgt_lifetime_hours", tgt_lifetime_hours)
        pulumi.set(__self__, "truststore_password_uri", truststore_password_uri)
        pulumi.set(__self__, "truststore_uri", truststore_uri)

    @property
    @pulumi.getter(name="crossRealmTrustAdminServer")
    def cross_realm_trust_admin_server(self) -> str:
        """
        Optional. The admin server (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_admin_server")

    @property
    @pulumi.getter(name="crossRealmTrustKdc")
    def cross_realm_trust_kdc(self) -> str:
        """
        Optional. The KDC (IP or hostname) for the remote trusted realm in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_kdc")

    @property
    @pulumi.getter(name="crossRealmTrustRealm")
    def cross_realm_trust_realm(self) -> str:
        """
        Optional. The remote realm the Dataproc on-cluster KDC will trust, should the user enable cross realm trust.
        """
        return pulumi.get(self, "cross_realm_trust_realm")

    @property
    @pulumi.getter(name="crossRealmTrustSharedPasswordUri")
    def cross_realm_trust_shared_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the shared password between the on-cluster Kerberos realm and the remote trusted realm, in a cross realm trust relationship.
        """
        return pulumi.get(self, "cross_realm_trust_shared_password_uri")

    @property
    @pulumi.getter(name="enableKerberos")
    def enable_kerberos(self) -> bool:
        """
        Optional. Flag to indicate whether to Kerberize the cluster (default: false). Set this field to true to enable Kerberos on a cluster.
        """
        return pulumi.get(self, "enable_kerberos")

    @property
    @pulumi.getter(name="kdcDbKeyUri")
    def kdc_db_key_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the master key of the KDC database.
        """
        return pulumi.get(self, "kdc_db_key_uri")

    @property
    @pulumi.getter(name="keyPasswordUri")
    def key_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided key. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "key_password_uri")

    @property
    @pulumi.getter(name="keystorePasswordUri")
    def keystore_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided keystore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "keystore_password_uri")

    @property
    @pulumi.getter(name="keystoreUri")
    def keystore_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of the keystore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "keystore_uri")

    @property
    @pulumi.getter(name="kmsKeyUri")
    def kms_key_uri(self) -> str:
        """
        Optional. The uri of the KMS key used to encrypt various sensitive files.
        """
        return pulumi.get(self, "kms_key_uri")

    @property
    @pulumi.getter
    def realm(self) -> str:
        """
        Optional. The name of the on-cluster Kerberos realm. If not specified, the uppercased domain of hostnames will be the realm.
        """
        return pulumi.get(self, "realm")

    @property
    @pulumi.getter(name="rootPrincipalPasswordUri")
    def root_principal_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the root principal password.
        """
        return pulumi.get(self, "root_principal_password_uri")

    @property
    @pulumi.getter(name="tgtLifetimeHours")
    def tgt_lifetime_hours(self) -> int:
        """
        Optional. The lifetime of the ticket granting ticket, in hours. If not specified, or user specifies 0, then default value 10 will be used.
        """
        return pulumi.get(self, "tgt_lifetime_hours")

    @property
    @pulumi.getter(name="truststorePasswordUri")
    def truststore_password_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of a KMS encrypted file containing the password to the user provided truststore. For the self-signed certificate, this password is generated by Dataproc.
        """
        return pulumi.get(self, "truststore_password_uri")

    @property
    @pulumi.getter(name="truststoreUri")
    def truststore_uri(self) -> str:
        """
        Optional. The Cloud Storage URI of the truststore file used for SSL encryption. If not provided, Dataproc will provide a self-signed certificate.
        """
        return pulumi.get(self, "truststore_uri")


@pulumi.output_type
class LifecycleConfigResponse(dict):
    """
    Specifies the cluster auto-delete schedule configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "autoDeleteTime":
            suggest = "auto_delete_time"
        elif key == "autoDeleteTtl":
            suggest = "auto_delete_ttl"
        elif key == "idleDeleteTtl":
            suggest = "idle_delete_ttl"
        elif key == "idleStartTime":
            suggest = "idle_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LifecycleConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LifecycleConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LifecycleConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 auto_delete_time: str,
                 auto_delete_ttl: str,
                 idle_delete_ttl: str,
                 idle_start_time: str):
        """
        Specifies the cluster auto-delete schedule configuration.
        :param str auto_delete_time: Optional. The time when cluster will be auto-deleted (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str auto_delete_ttl: Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str idle_delete_ttl: Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        :param str idle_start_time: The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        pulumi.set(__self__, "auto_delete_time", auto_delete_time)
        pulumi.set(__self__, "auto_delete_ttl", auto_delete_ttl)
        pulumi.set(__self__, "idle_delete_ttl", idle_delete_ttl)
        pulumi.set(__self__, "idle_start_time", idle_start_time)

    @property
    @pulumi.getter(name="autoDeleteTime")
    def auto_delete_time(self) -> str:
        """
        Optional. The time when cluster will be auto-deleted (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_time")

    @property
    @pulumi.getter(name="autoDeleteTtl")
    def auto_delete_ttl(self) -> str:
        """
        Optional. The lifetime duration of cluster. The cluster will be auto-deleted at the end of this period. Minimum value is 10 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "auto_delete_ttl")

    @property
    @pulumi.getter(name="idleDeleteTtl")
    def idle_delete_ttl(self) -> str:
        """
        Optional. The duration to keep the cluster alive while idling (when no jobs are running). Passing this threshold will cause the cluster to be deleted. Minimum value is 5 minutes; maximum value is 14 days (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "idle_delete_ttl")

    @property
    @pulumi.getter(name="idleStartTime")
    def idle_start_time(self) -> str:
        """
        The time when cluster became idle (most recent job finished) and became eligible for deletion due to idleness (see JSON representation of Timestamp (https://developers.google.com/protocol-buffers/docs/proto3#json)).
        """
        return pulumi.get(self, "idle_start_time")


@pulumi.output_type
class LoggingConfigResponse(dict):
    """
    The runtime logging config of the job.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "driverLogLevels":
            suggest = "driver_log_levels"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in LoggingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        LoggingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        LoggingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 driver_log_levels: Mapping[str, str]):
        """
        The runtime logging config of the job.
        :param Mapping[str, str] driver_log_levels: The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        pulumi.set(__self__, "driver_log_levels", driver_log_levels)

    @property
    @pulumi.getter(name="driverLogLevels")
    def driver_log_levels(self) -> Mapping[str, str]:
        """
        The per-package log levels for the driver. This may include "root" package name to configure rootLogger. Examples: 'com.google = FATAL', 'root = INFO', 'org.apache = DEBUG'
        """
        return pulumi.get(self, "driver_log_levels")


@pulumi.output_type
class ManagedClusterResponse(dict):
    """
    Cluster that is managed by the workflow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterName":
            suggest = "cluster_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedClusterResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedClusterResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedClusterResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_name: str,
                 config: 'outputs.ClusterConfigResponse',
                 labels: Mapping[str, str]):
        """
        Cluster that is managed by the workflow.
        :param str cluster_name: The cluster name prefix. A unique cluster name will be formed by appending a random suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        :param 'ClusterConfigResponse' config: The cluster configuration.
        :param Mapping[str, str] labels: Optional. The labels to associate with this cluster.Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given cluster.
        """
        pulumi.set(__self__, "cluster_name", cluster_name)
        pulumi.set(__self__, "config", config)
        pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="clusterName")
    def cluster_name(self) -> str:
        """
        The cluster name prefix. A unique cluster name will be formed by appending a random suffix.The name must contain only lower-case letters (a-z), numbers (0-9), and hyphens (-). Must begin with a letter. Cannot begin or end with hyphen. Must consist of between 2 and 35 characters.
        """
        return pulumi.get(self, "cluster_name")

    @property
    @pulumi.getter
    def config(self) -> 'outputs.ClusterConfigResponse':
        """
        The cluster configuration.
        """
        return pulumi.get(self, "config")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. The labels to associate with this cluster.Label keys must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following PCRE regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given cluster.
        """
        return pulumi.get(self, "labels")


@pulumi.output_type
class ManagedGroupConfigResponse(dict):
    """
    Specifies the resources used to actively manage an instance group.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "instanceGroupManagerName":
            suggest = "instance_group_manager_name"
        elif key == "instanceTemplateName":
            suggest = "instance_template_name"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ManagedGroupConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ManagedGroupConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ManagedGroupConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 instance_group_manager_name: str,
                 instance_template_name: str):
        """
        Specifies the resources used to actively manage an instance group.
        :param str instance_group_manager_name: The name of the Instance Group Manager for this group.
        :param str instance_template_name: The name of the Instance Template used for the Managed Instance Group.
        """
        pulumi.set(__self__, "instance_group_manager_name", instance_group_manager_name)
        pulumi.set(__self__, "instance_template_name", instance_template_name)

    @property
    @pulumi.getter(name="instanceGroupManagerName")
    def instance_group_manager_name(self) -> str:
        """
        The name of the Instance Group Manager for this group.
        """
        return pulumi.get(self, "instance_group_manager_name")

    @property
    @pulumi.getter(name="instanceTemplateName")
    def instance_template_name(self) -> str:
        """
        The name of the Instance Template used for the Managed Instance Group.
        """
        return pulumi.get(self, "instance_template_name")


@pulumi.output_type
class MetastoreConfigResponse(dict):
    """
    Specifies a Metastore configuration.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocMetastoreService":
            suggest = "dataproc_metastore_service"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in MetastoreConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        MetastoreConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        MetastoreConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_metastore_service: str):
        """
        Specifies a Metastore configuration.
        :param str dataproc_metastore_service: Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[dataproc_region]/services/[service-name]
        """
        pulumi.set(__self__, "dataproc_metastore_service", dataproc_metastore_service)

    @property
    @pulumi.getter(name="dataprocMetastoreService")
    def dataproc_metastore_service(self) -> str:
        """
        Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[dataproc_region]/services/[service-name]
        """
        return pulumi.get(self, "dataproc_metastore_service")


@pulumi.output_type
class NamespacedGkeDeploymentTargetResponse(dict):
    """
    A full, namespace-isolated deployment target for an existing GKE cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterNamespace":
            suggest = "cluster_namespace"
        elif key == "targetGkeCluster":
            suggest = "target_gke_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NamespacedGkeDeploymentTargetResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NamespacedGkeDeploymentTargetResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NamespacedGkeDeploymentTargetResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_namespace: str,
                 target_gke_cluster: str):
        """
        A full, namespace-isolated deployment target for an existing GKE cluster.
        :param str cluster_namespace: Optional. A namespace within the GKE cluster to deploy into.
        :param str target_gke_cluster: Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        pulumi.set(__self__, "cluster_namespace", cluster_namespace)
        pulumi.set(__self__, "target_gke_cluster", target_gke_cluster)

    @property
    @pulumi.getter(name="clusterNamespace")
    def cluster_namespace(self) -> str:
        """
        Optional. A namespace within the GKE cluster to deploy into.
        """
        return pulumi.get(self, "cluster_namespace")

    @property
    @pulumi.getter(name="targetGkeCluster")
    def target_gke_cluster(self) -> str:
        """
        Optional. The target GKE cluster to deploy to. Format: 'projects/{project}/locations/{location}/clusters/{cluster_id}'
        """
        return pulumi.get(self, "target_gke_cluster")


@pulumi.output_type
class NodeGroupAffinityResponse(dict):
    """
    Node Group Affinity for clusters using sole-tenant node groups.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "nodeGroupUri":
            suggest = "node_group_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeGroupAffinityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeGroupAffinityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeGroupAffinityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 node_group_uri: str):
        """
        Node Group Affinity for clusters using sole-tenant node groups.
        :param str node_group_uri: The URI of a sole-tenant node group resource (https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on.A full URL, partial URI, or node group name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 node-group-1
        """
        pulumi.set(__self__, "node_group_uri", node_group_uri)

    @property
    @pulumi.getter(name="nodeGroupUri")
    def node_group_uri(self) -> str:
        """
        The URI of a sole-tenant node group resource (https://cloud.google.com/compute/docs/reference/rest/v1/nodeGroups) that the cluster will be created on.A full URL, partial URI, or node group name are valid. Examples: https://www.googleapis.com/compute/v1/projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 projects/[project_id]/zones/us-central1-a/nodeGroups/node-group-1 node-group-1
        """
        return pulumi.get(self, "node_group_uri")


@pulumi.output_type
class NodeInitializationActionResponse(dict):
    """
    Specifies an executable to run on a fully configured node and a timeout period for executable completion.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "executableFile":
            suggest = "executable_file"
        elif key == "executionTimeout":
            suggest = "execution_timeout"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in NodeInitializationActionResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        NodeInitializationActionResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        NodeInitializationActionResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 executable_file: str,
                 execution_timeout: str):
        """
        Specifies an executable to run on a fully configured node and a timeout period for executable completion.
        :param str executable_file: Cloud Storage URI of executable file.
        :param str execution_timeout: Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        pulumi.set(__self__, "executable_file", executable_file)
        pulumi.set(__self__, "execution_timeout", execution_timeout)

    @property
    @pulumi.getter(name="executableFile")
    def executable_file(self) -> str:
        """
        Cloud Storage URI of executable file.
        """
        return pulumi.get(self, "executable_file")

    @property
    @pulumi.getter(name="executionTimeout")
    def execution_timeout(self) -> str:
        """
        Optional. Amount of time executable has to complete. Default is 10 minutes (see JSON representation of Duration (https://developers.google.com/protocol-buffers/docs/proto3#json)).Cluster creation fails with an explanatory error message (the name of the executable that caused the error and the exceeded timeout period) if the executable is not completed at end of the timeout period.
        """
        return pulumi.get(self, "execution_timeout")


@pulumi.output_type
class OrderedJobResponse(dict):
    """
    A job executed by the workflow.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "hadoopJob":
            suggest = "hadoop_job"
        elif key == "hiveJob":
            suggest = "hive_job"
        elif key == "pigJob":
            suggest = "pig_job"
        elif key == "prerequisiteStepIds":
            suggest = "prerequisite_step_ids"
        elif key == "prestoJob":
            suggest = "presto_job"
        elif key == "pysparkJob":
            suggest = "pyspark_job"
        elif key == "sparkJob":
            suggest = "spark_job"
        elif key == "sparkRJob":
            suggest = "spark_r_job"
        elif key == "sparkSqlJob":
            suggest = "spark_sql_job"
        elif key == "stepId":
            suggest = "step_id"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in OrderedJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        OrderedJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        OrderedJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 hadoop_job: 'outputs.HadoopJobResponse',
                 hive_job: 'outputs.HiveJobResponse',
                 labels: Mapping[str, str],
                 pig_job: 'outputs.PigJobResponse',
                 prerequisite_step_ids: Sequence[str],
                 presto_job: 'outputs.PrestoJobResponse',
                 pyspark_job: 'outputs.PySparkJobResponse',
                 scheduling: 'outputs.JobSchedulingResponse',
                 spark_job: 'outputs.SparkJobResponse',
                 spark_r_job: 'outputs.SparkRJobResponse',
                 spark_sql_job: 'outputs.SparkSqlJobResponse',
                 step_id: str):
        """
        A job executed by the workflow.
        :param 'HadoopJobResponse' hadoop_job: Optional. Job is a Hadoop job.
        :param 'HiveJobResponse' hive_job: Optional. Job is a Hive job.
        :param Mapping[str, str] labels: Optional. The labels to associate with this job.Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given job.
        :param 'PigJobResponse' pig_job: Optional. Job is a Pig job.
        :param Sequence[str] prerequisite_step_ids: Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        :param 'PrestoJobResponse' presto_job: Optional. Job is a Presto job.
        :param 'PySparkJobResponse' pyspark_job: Optional. Job is a PySpark job.
        :param 'JobSchedulingResponse' scheduling: Optional. Job scheduling configuration.
        :param 'SparkJobResponse' spark_job: Optional. Job is a Spark job.
        :param 'SparkRJobResponse' spark_r_job: Optional. Job is a SparkR job.
        :param 'SparkSqlJobResponse' spark_sql_job: Optional. Job is a SparkSql job.
        :param str step_id: The step id. The id must be unique among all jobs within the template.The step id is used as prefix for job id, as job goog-dataproc-workflow-step-id label, and in prerequisiteStepIds field from other steps.The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        pulumi.set(__self__, "hadoop_job", hadoop_job)
        pulumi.set(__self__, "hive_job", hive_job)
        pulumi.set(__self__, "labels", labels)
        pulumi.set(__self__, "pig_job", pig_job)
        pulumi.set(__self__, "prerequisite_step_ids", prerequisite_step_ids)
        pulumi.set(__self__, "presto_job", presto_job)
        pulumi.set(__self__, "pyspark_job", pyspark_job)
        pulumi.set(__self__, "scheduling", scheduling)
        pulumi.set(__self__, "spark_job", spark_job)
        pulumi.set(__self__, "spark_r_job", spark_r_job)
        pulumi.set(__self__, "spark_sql_job", spark_sql_job)
        pulumi.set(__self__, "step_id", step_id)

    @property
    @pulumi.getter(name="hadoopJob")
    def hadoop_job(self) -> 'outputs.HadoopJobResponse':
        """
        Optional. Job is a Hadoop job.
        """
        return pulumi.get(self, "hadoop_job")

    @property
    @pulumi.getter(name="hiveJob")
    def hive_job(self) -> 'outputs.HiveJobResponse':
        """
        Optional. Job is a Hive job.
        """
        return pulumi.get(self, "hive_job")

    @property
    @pulumi.getter
    def labels(self) -> Mapping[str, str]:
        """
        Optional. The labels to associate with this job.Label keys must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}{0,62}Label values must be between 1 and 63 characters long, and must conform to the following regular expression: \p{Ll}\p{Lo}\p{N}_-{0,63}No more than 32 labels can be associated with a given job.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter(name="pigJob")
    def pig_job(self) -> 'outputs.PigJobResponse':
        """
        Optional. Job is a Pig job.
        """
        return pulumi.get(self, "pig_job")

    @property
    @pulumi.getter(name="prerequisiteStepIds")
    def prerequisite_step_ids(self) -> Sequence[str]:
        """
        Optional. The optional list of prerequisite job step_ids. If not specified, the job will start at the beginning of workflow.
        """
        return pulumi.get(self, "prerequisite_step_ids")

    @property
    @pulumi.getter(name="prestoJob")
    def presto_job(self) -> 'outputs.PrestoJobResponse':
        """
        Optional. Job is a Presto job.
        """
        return pulumi.get(self, "presto_job")

    @property
    @pulumi.getter(name="pysparkJob")
    def pyspark_job(self) -> 'outputs.PySparkJobResponse':
        """
        Optional. Job is a PySpark job.
        """
        return pulumi.get(self, "pyspark_job")

    @property
    @pulumi.getter
    def scheduling(self) -> 'outputs.JobSchedulingResponse':
        """
        Optional. Job scheduling configuration.
        """
        return pulumi.get(self, "scheduling")

    @property
    @pulumi.getter(name="sparkJob")
    def spark_job(self) -> 'outputs.SparkJobResponse':
        """
        Optional. Job is a Spark job.
        """
        return pulumi.get(self, "spark_job")

    @property
    @pulumi.getter(name="sparkRJob")
    def spark_r_job(self) -> 'outputs.SparkRJobResponse':
        """
        Optional. Job is a SparkR job.
        """
        return pulumi.get(self, "spark_r_job")

    @property
    @pulumi.getter(name="sparkSqlJob")
    def spark_sql_job(self) -> 'outputs.SparkSqlJobResponse':
        """
        Optional. Job is a SparkSql job.
        """
        return pulumi.get(self, "spark_sql_job")

    @property
    @pulumi.getter(name="stepId")
    def step_id(self) -> str:
        """
        The step id. The id must be unique among all jobs within the template.The step id is used as prefix for job id, as job goog-dataproc-workflow-step-id label, and in prerequisiteStepIds field from other steps.The id must contain only letters (a-z, A-Z), numbers (0-9), underscores (_), and hyphens (-). Cannot begin or end with underscore or hyphen. Must consist of between 3 and 50 characters.
        """
        return pulumi.get(self, "step_id")


@pulumi.output_type
class ParameterValidationResponse(dict):
    """
    Configuration for parameter validation.
    """
    def __init__(__self__, *,
                 regex: 'outputs.RegexValidationResponse',
                 values: 'outputs.ValueValidationResponse'):
        """
        Configuration for parameter validation.
        :param 'RegexValidationResponse' regex: Validation based on regular expressions.
        :param 'ValueValidationResponse' values: Validation based on a list of allowed values.
        """
        pulumi.set(__self__, "regex", regex)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def regex(self) -> 'outputs.RegexValidationResponse':
        """
        Validation based on regular expressions.
        """
        return pulumi.get(self, "regex")

    @property
    @pulumi.getter
    def values(self) -> 'outputs.ValueValidationResponse':
        """
        Validation based on a list of allowed values.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class PeripheralsConfigResponse(dict):
    """
    Auxiliary services configuration for a workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "metastoreService":
            suggest = "metastore_service"
        elif key == "sparkHistoryServerConfig":
            suggest = "spark_history_server_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PeripheralsConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PeripheralsConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PeripheralsConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 metastore_service: str,
                 spark_history_server_config: 'outputs.SparkHistoryServerConfigResponse'):
        """
        Auxiliary services configuration for a workload.
        :param str metastore_service: Optional. Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[region]/services/[service_id]
        :param 'SparkHistoryServerConfigResponse' spark_history_server_config: Optional. The Spark History Server configuration for the workload.
        """
        pulumi.set(__self__, "metastore_service", metastore_service)
        pulumi.set(__self__, "spark_history_server_config", spark_history_server_config)

    @property
    @pulumi.getter(name="metastoreService")
    def metastore_service(self) -> str:
        """
        Optional. Resource name of an existing Dataproc Metastore service.Example: projects/[project_id]/locations/[region]/services/[service_id]
        """
        return pulumi.get(self, "metastore_service")

    @property
    @pulumi.getter(name="sparkHistoryServerConfig")
    def spark_history_server_config(self) -> 'outputs.SparkHistoryServerConfigResponse':
        """
        Optional. The Spark History Server configuration for the workload.
        """
        return pulumi.get(self, "spark_history_server_config")


@pulumi.output_type
class PigJobResponse(dict):
    """
    A Dataproc job for running Apache Pig (https://pig.apache.org/) queries on YARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PigJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PigJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PigJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 continue_on_failure: bool,
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse',
                 script_variables: Mapping[str, str]):
        """
        A Dataproc job for running Apache Pig (https://pig.apache.org/) queries on YARN.
        :param bool continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        :param 'LoggingConfigResponse' logging_config: Optional. The runtime log config for job execution.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        :param str query_file_uri: The HCFS URI of the script that contains the Pig queries.
        :param 'QueryListResponse' query_list: A list of queries.
        :param Mapping[str, str] script_variables: Optional. Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
        """
        pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)
        pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> bool:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATH of the Pig Client and Hadoop MapReduce (MR) tasks. Can contain Pig UDFs.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Pig. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/hadoop/conf/*-site.xml, /etc/pig/conf/pig.properties, and classes in user code.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains the Pig queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Mapping[str, str]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Pig command: name=[value]).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class PrestoJobResponse(dict):
    """
    A Dataproc job for running Presto (https://prestosql.io/) queries. IMPORTANT: The Dataproc Presto Optional Component (https://cloud.google.com/dataproc/docs/concepts/components/presto) must be enabled when the cluster is created to submit a Presto job to the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clientTags":
            suggest = "client_tags"
        elif key == "continueOnFailure":
            suggest = "continue_on_failure"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "outputFormat":
            suggest = "output_format"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PrestoJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PrestoJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PrestoJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 client_tags: Sequence[str],
                 continue_on_failure: bool,
                 logging_config: 'outputs.LoggingConfigResponse',
                 output_format: str,
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse'):
        """
        A Dataproc job for running Presto (https://prestosql.io/) queries. IMPORTANT: The Dataproc Presto Optional Component (https://cloud.google.com/dataproc/docs/concepts/components/presto) must be enabled when the cluster is created to submit a Presto job to the cluster.
        :param Sequence[str] client_tags: Optional. Presto client tags to attach to this query
        :param bool continue_on_failure: Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        :param 'LoggingConfigResponse' logging_config: Optional. The runtime log config for job execution.
        :param str output_format: Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        :param Mapping[str, str] properties: Optional. A mapping of property names to values. Used to set Presto session properties (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        :param str query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param 'QueryListResponse' query_list: A list of queries.
        """
        pulumi.set(__self__, "client_tags", client_tags)
        pulumi.set(__self__, "continue_on_failure", continue_on_failure)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "output_format", output_format)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)

    @property
    @pulumi.getter(name="clientTags")
    def client_tags(self) -> Sequence[str]:
        """
        Optional. Presto client tags to attach to this query
        """
        return pulumi.get(self, "client_tags")

    @property
    @pulumi.getter(name="continueOnFailure")
    def continue_on_failure(self) -> bool:
        """
        Optional. Whether to continue executing queries if a query fails. The default value is false. Setting to true can be useful when executing independent parallel queries.
        """
        return pulumi.get(self, "continue_on_failure")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="outputFormat")
    def output_format(self) -> str:
        """
        Optional. The format in which query output will be displayed. See the Presto documentation for supported output formats
        """
        return pulumi.get(self, "output_format")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values. Used to set Presto session properties (https://prestodb.io/docs/current/sql/set-session.html) Equivalent to using the --session flag in the Presto CLI
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")


@pulumi.output_type
class PySparkBatchResponse(dict):
    """
    A configuration for running an Apache PySpark (https://spark.apache.org/docs/latest/api/python/getting_started/quickstart.html) batch workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "mainPythonFileUri":
            suggest = "main_python_file_uri"
        elif key == "pythonFileUris":
            suggest = "python_file_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PySparkBatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PySparkBatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PySparkBatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 main_python_file_uri: str,
                 python_file_uris: Sequence[str]):
        """
        A configuration for running an Apache PySpark (https://spark.apache.org/docs/latest/api/python/getting_started/quickstart.html) batch workload.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments that can be set as batch properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        :param str main_python_file_uri: The HCFS URI of the main Python file to use as the Spark driver. Must be a .py file.
        :param Sequence[str] python_file_uris: Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments that can be set as batch properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> str:
        """
        The HCFS URI of the main Python file to use as the Spark driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")


@pulumi.output_type
class PySparkJobResponse(dict):
    """
    A Dataproc job for running Apache PySpark (https://spark.apache.org/docs/0.9.0/python-programming-guide.html) applications on YARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainPythonFileUri":
            suggest = "main_python_file_uri"
        elif key == "pythonFileUris":
            suggest = "python_file_uris"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in PySparkJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        PySparkJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        PySparkJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_python_file_uri: str,
                 properties: Mapping[str, str],
                 python_file_uris: Sequence[str]):
        """
        A Dataproc job for running Apache PySpark (https://spark.apache.org/docs/0.9.0/python-programming-guide.html) applications on YARN.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        :param 'LoggingConfigResponse' logging_config: Optional. The runtime log config for job execution.
        :param str main_python_file_uri: The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        :param Sequence[str] python_file_uris: Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_python_file_uri", main_python_file_uri)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "python_file_uris", python_file_uris)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Python driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainPythonFileUri")
    def main_python_file_uri(self) -> str:
        """
        The HCFS URI of the main Python file to use as the driver. Must be a .py file.
        """
        return pulumi.get(self, "main_python_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure PySpark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="pythonFileUris")
    def python_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS file URIs of Python files to pass to the PySpark framework. Supported file types: .py, .egg, and .zip.
        """
        return pulumi.get(self, "python_file_uris")


@pulumi.output_type
class QueryListResponse(dict):
    """
    A list of queries to run on a cluster.
    """
    def __init__(__self__, *,
                 queries: Sequence[str]):
        """
        A list of queries to run on a cluster.
        :param Sequence[str] queries: The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } } 
        """
        pulumi.set(__self__, "queries", queries)

    @property
    @pulumi.getter
    def queries(self) -> Sequence[str]:
        """
        The queries to execute. You do not need to end a query expression with a semicolon. Multiple queries can be specified in one string by separating each with a semicolon. Here is an example of a Dataproc API snippet that uses a QueryList to specify a HiveJob: "hiveJob": { "queryList": { "queries": [ "query1", "query2", "query3;query4", ] } } 
        """
        return pulumi.get(self, "queries")


@pulumi.output_type
class RegexValidationResponse(dict):
    """
    Validation based on regular expressions.
    """
    def __init__(__self__, *,
                 regexes: Sequence[str]):
        """
        Validation based on regular expressions.
        :param Sequence[str] regexes: RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        pulumi.set(__self__, "regexes", regexes)

    @property
    @pulumi.getter
    def regexes(self) -> Sequence[str]:
        """
        RE2 regular expressions used to validate the parameter's value. The value must match the regex in its entirety (substring matches are not sufficient).
        """
        return pulumi.get(self, "regexes")


@pulumi.output_type
class ReservationAffinityResponse(dict):
    """
    Reservation Affinity for consuming Zonal reservation.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "consumeReservationType":
            suggest = "consume_reservation_type"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ReservationAffinityResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ReservationAffinityResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 consume_reservation_type: str,
                 key: str,
                 values: Sequence[str]):
        """
        Reservation Affinity for consuming Zonal reservation.
        :param str consume_reservation_type: Optional. Type of reservation to consume
        :param str key: Optional. Corresponds to the label key of reservation resource.
        :param Sequence[str] values: Optional. Corresponds to the label values of reservation resource.
        """
        pulumi.set(__self__, "consume_reservation_type", consume_reservation_type)
        pulumi.set(__self__, "key", key)
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter(name="consumeReservationType")
    def consume_reservation_type(self) -> str:
        """
        Optional. Type of reservation to consume
        """
        return pulumi.get(self, "consume_reservation_type")

    @property
    @pulumi.getter
    def key(self) -> str:
        """
        Optional. Corresponds to the label key of reservation resource.
        """
        return pulumi.get(self, "key")

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        Optional. Corresponds to the label values of reservation resource.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class RuntimeConfigResponse(dict):
    """
    Runtime configuration for a workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "containerImage":
            suggest = "container_image"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 container_image: str,
                 properties: Mapping[str, str],
                 version: str):
        """
        Runtime configuration for a workload.
        :param str container_image: Optional. Optional custom container image for the job runtime environment. If not specified, a default container image will be used.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, which are used to configure workload execution.
        :param str version: Optional. Version of the batch runtime.
        """
        pulumi.set(__self__, "container_image", container_image)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="containerImage")
    def container_image(self) -> str:
        """
        Optional. Optional custom container image for the job runtime environment. If not specified, a default container image will be used.
        """
        return pulumi.get(self, "container_image")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, which are used to configure workload execution.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        Optional. Version of the batch runtime.
        """
        return pulumi.get(self, "version")


@pulumi.output_type
class RuntimeInfoResponse(dict):
    """
    Runtime information about workload execution.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "diagnosticOutputUri":
            suggest = "diagnostic_output_uri"
        elif key == "outputUri":
            suggest = "output_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in RuntimeInfoResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        RuntimeInfoResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        RuntimeInfoResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 diagnostic_output_uri: str,
                 endpoints: Mapping[str, str],
                 output_uri: str):
        """
        Runtime information about workload execution.
        :param str diagnostic_output_uri: A URI pointing to the location of the diagnostics tarball.
        :param Mapping[str, str] endpoints: Map of remote access endpoints (such as web interfaces and APIs) to their URIs.
        :param str output_uri: A URI pointing to the location of the stdout and stderr of the workload.
        """
        pulumi.set(__self__, "diagnostic_output_uri", diagnostic_output_uri)
        pulumi.set(__self__, "endpoints", endpoints)
        pulumi.set(__self__, "output_uri", output_uri)

    @property
    @pulumi.getter(name="diagnosticOutputUri")
    def diagnostic_output_uri(self) -> str:
        """
        A URI pointing to the location of the diagnostics tarball.
        """
        return pulumi.get(self, "diagnostic_output_uri")

    @property
    @pulumi.getter
    def endpoints(self) -> Mapping[str, str]:
        """
        Map of remote access endpoints (such as web interfaces and APIs) to their URIs.
        """
        return pulumi.get(self, "endpoints")

    @property
    @pulumi.getter(name="outputUri")
    def output_uri(self) -> str:
        """
        A URI pointing to the location of the stdout and stderr of the workload.
        """
        return pulumi.get(self, "output_uri")


@pulumi.output_type
class SecurityConfigResponse(dict):
    """
    Security related configuration, including encryption, Kerberos, etc.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "identityConfig":
            suggest = "identity_config"
        elif key == "kerberosConfig":
            suggest = "kerberos_config"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SecurityConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SecurityConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SecurityConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 identity_config: 'outputs.IdentityConfigResponse',
                 kerberos_config: 'outputs.KerberosConfigResponse'):
        """
        Security related configuration, including encryption, Kerberos, etc.
        :param 'IdentityConfigResponse' identity_config: Optional. Identity related configuration, including service account based secure multi-tenancy user mappings.
        :param 'KerberosConfigResponse' kerberos_config: Optional. Kerberos related configuration.
        """
        pulumi.set(__self__, "identity_config", identity_config)
        pulumi.set(__self__, "kerberos_config", kerberos_config)

    @property
    @pulumi.getter(name="identityConfig")
    def identity_config(self) -> 'outputs.IdentityConfigResponse':
        """
        Optional. Identity related configuration, including service account based secure multi-tenancy user mappings.
        """
        return pulumi.get(self, "identity_config")

    @property
    @pulumi.getter(name="kerberosConfig")
    def kerberos_config(self) -> 'outputs.KerberosConfigResponse':
        """
        Optional. Kerberos related configuration.
        """
        return pulumi.get(self, "kerberos_config")


@pulumi.output_type
class ShieldedInstanceConfigResponse(dict):
    """
    Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "enableIntegrityMonitoring":
            suggest = "enable_integrity_monitoring"
        elif key == "enableSecureBoot":
            suggest = "enable_secure_boot"
        elif key == "enableVtpm":
            suggest = "enable_vtpm"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in ShieldedInstanceConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        ShieldedInstanceConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 enable_integrity_monitoring: bool,
                 enable_secure_boot: bool,
                 enable_vtpm: bool):
        """
        Shielded Instance Config for clusters using Compute Engine Shielded VMs (https://cloud.google.com/security/shielded-cloud/shielded-vm).
        :param bool enable_integrity_monitoring: Optional. Defines whether instances have integrity monitoring enabled.
        :param bool enable_secure_boot: Optional. Defines whether instances have Secure Boot enabled.
        :param bool enable_vtpm: Optional. Defines whether instances have the vTPM enabled.
        """
        pulumi.set(__self__, "enable_integrity_monitoring", enable_integrity_monitoring)
        pulumi.set(__self__, "enable_secure_boot", enable_secure_boot)
        pulumi.set(__self__, "enable_vtpm", enable_vtpm)

    @property
    @pulumi.getter(name="enableIntegrityMonitoring")
    def enable_integrity_monitoring(self) -> bool:
        """
        Optional. Defines whether instances have integrity monitoring enabled.
        """
        return pulumi.get(self, "enable_integrity_monitoring")

    @property
    @pulumi.getter(name="enableSecureBoot")
    def enable_secure_boot(self) -> bool:
        """
        Optional. Defines whether instances have Secure Boot enabled.
        """
        return pulumi.get(self, "enable_secure_boot")

    @property
    @pulumi.getter(name="enableVtpm")
    def enable_vtpm(self) -> bool:
        """
        Optional. Defines whether instances have the vTPM enabled.
        """
        return pulumi.get(self, "enable_vtpm")


@pulumi.output_type
class SoftwareConfigResponse(dict):
    """
    Specifies the selection and config of software inside the cluster.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "imageVersion":
            suggest = "image_version"
        elif key == "optionalComponents":
            suggest = "optional_components"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SoftwareConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SoftwareConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SoftwareConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 image_version: str,
                 optional_components: Sequence[str],
                 properties: Mapping[str, str]):
        """
        Specifies the selection and config of software inside the cluster.
        :param str image_version: Optional. The version of software inside the cluster. It must be one of the supported Dataproc Versions (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the "preview" version (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        :param Sequence[str] optional_components: Optional. The set of components to activate on the cluster.
        :param Mapping[str, str] properties: Optional. The properties to set on daemon config files.Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. The following are supported prefixes and their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        pulumi.set(__self__, "image_version", image_version)
        pulumi.set(__self__, "optional_components", optional_components)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="imageVersion")
    def image_version(self) -> str:
        """
        Optional. The version of software inside the cluster. It must be one of the supported Dataproc Versions (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#supported_dataproc_versions), such as "1.2" (including a subminor version, such as "1.2.29"), or the "preview" version (https://cloud.google.com/dataproc/docs/concepts/versioning/dataproc-versions#other_versions). If unspecified, it defaults to the latest Debian version.
        """
        return pulumi.get(self, "image_version")

    @property
    @pulumi.getter(name="optionalComponents")
    def optional_components(self) -> Sequence[str]:
        """
        Optional. The set of components to activate on the cluster.
        """
        return pulumi.get(self, "optional_components")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. The properties to set on daemon config files.Property keys are specified in prefix:property format, for example core:hadoop.tmp.dir. The following are supported prefixes and their mappings: capacity-scheduler: capacity-scheduler.xml core: core-site.xml distcp: distcp-default.xml hdfs: hdfs-site.xml hive: hive-site.xml mapred: mapred-site.xml pig: pig.properties spark: spark-defaults.conf yarn: yarn-site.xmlFor more information, see Cluster properties (https://cloud.google.com/dataproc/docs/concepts/cluster-properties).
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SparkBatchResponse(dict):
    """
    A configuration for running an Apache Spark (http://spark.apache.org/) batch workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkBatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkBatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkBatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 main_class: str,
                 main_jar_file_uri: str):
        """
        A configuration for running an Apache Spark (http://spark.apache.org/) batch workload.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments that can be set as batch properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        :param str main_class: Optional. The name of the driver main class. The jar file that contains the class must be in the classpath or specified in jar_file_uris.
        :param str main_jar_file_uri: Optional. The HCFS URI of the jar file that contains the main class.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "main_class", main_class)
        pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments that can be set as batch properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the classpath of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> str:
        """
        Optional. The name of the driver main class. The jar file that contains the class must be in the classpath or specified in jar_file_uris.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> str:
        """
        Optional. The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")


@pulumi.output_type
class SparkHistoryServerConfigResponse(dict):
    """
    Spark History Server configuration for the workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "dataprocCluster":
            suggest = "dataproc_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkHistoryServerConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkHistoryServerConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkHistoryServerConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 dataproc_cluster: str):
        """
        Spark History Server configuration for the workload.
        :param str dataproc_cluster: Optional. Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.Example: projects/[project_id]/regions/[region]/clusters/[cluster_name]
        """
        pulumi.set(__self__, "dataproc_cluster", dataproc_cluster)

    @property
    @pulumi.getter(name="dataprocCluster")
    def dataproc_cluster(self) -> str:
        """
        Optional. Resource name of an existing Dataproc Cluster to act as a Spark History Server for the workload.Example: projects/[project_id]/regions/[region]/clusters/[cluster_name]
        """
        return pulumi.get(self, "dataproc_cluster")


@pulumi.output_type
class SparkJobResponse(dict):
    """
    A Dataproc job for running Apache Spark (http://spark.apache.org/) applications on YARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainClass":
            suggest = "main_class"
        elif key == "mainJarFileUri":
            suggest = "main_jar_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_class: str,
                 main_jar_file_uri: str,
                 properties: Mapping[str, str]):
        """
        A Dataproc job for running Apache Spark (http://spark.apache.org/) applications on YARN.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        :param 'LoggingConfigResponse' logging_config: Optional. The runtime log config for job execution.
        :param str main_class: The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris.
        :param str main_jar_file_uri: The HCFS URI of the jar file that contains the main class.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_class", main_class)
        pulumi.set(__self__, "main_jar_file_uri", main_jar_file_uri)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to add to the CLASSPATHs of the Spark driver and tasks.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainClass")
    def main_class(self) -> str:
        """
        The name of the driver's main class. The jar file that contains the class must be in the default CLASSPATH or specified in jar_file_uris.
        """
        return pulumi.get(self, "main_class")

    @property
    @pulumi.getter(name="mainJarFileUri")
    def main_jar_file_uri(self) -> str:
        """
        The HCFS URI of the jar file that contains the main class.
        """
        return pulumi.get(self, "main_jar_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Spark. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SparkRBatchResponse(dict):
    """
    A configuration for running an Apache SparkR (https://spark.apache.org/docs/latest/sparkr.html) batch workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "mainRFileUri":
            suggest = "main_r_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkRBatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkRBatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkRBatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 main_r_file_uri: str):
        """
        A configuration for running an Apache SparkR (https://spark.apache.org/docs/latest/sparkr.html) batch workload.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the Spark driver. Do not include arguments that can be set as batch properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor.
        :param str main_r_file_uri: The HCFS URI of the main R file to use as the driver. Must be a .R or .r file.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the Spark driver. Do not include arguments that can be set as batch properties, such as --conf, since a collision can occur that causes an incorrect batch submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> str:
        """
        The HCFS URI of the main R file to use as the driver. Must be a .R or .r file.
        """
        return pulumi.get(self, "main_r_file_uri")


@pulumi.output_type
class SparkRJobResponse(dict):
    """
    A Dataproc job for running Apache SparkR (https://spark.apache.org/docs/latest/sparkr.html) applications on YARN.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "archiveUris":
            suggest = "archive_uris"
        elif key == "fileUris":
            suggest = "file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "mainRFileUri":
            suggest = "main_r_file_uri"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkRJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkRJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkRJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 archive_uris: Sequence[str],
                 args: Sequence[str],
                 file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 main_r_file_uri: str,
                 properties: Mapping[str, str]):
        """
        A Dataproc job for running Apache SparkR (https://spark.apache.org/docs/latest/sparkr.html) applications on YARN.
        :param Sequence[str] archive_uris: Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        :param Sequence[str] args: Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        :param Sequence[str] file_uris: Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        :param 'LoggingConfigResponse' logging_config: Optional. The runtime log config for job execution.
        :param str main_r_file_uri: The HCFS URI of the main R file to use as the driver. Must be a .R file.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        pulumi.set(__self__, "archive_uris", archive_uris)
        pulumi.set(__self__, "args", args)
        pulumi.set(__self__, "file_uris", file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "main_r_file_uri", main_r_file_uri)
        pulumi.set(__self__, "properties", properties)

    @property
    @pulumi.getter(name="archiveUris")
    def archive_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of archives to be extracted into the working directory of each executor. Supported file types: .jar, .tar, .tar.gz, .tgz, and .zip.
        """
        return pulumi.get(self, "archive_uris")

    @property
    @pulumi.getter
    def args(self) -> Sequence[str]:
        """
        Optional. The arguments to pass to the driver. Do not include arguments, such as --conf, that can be set as job properties, since a collision may occur that causes an incorrect job submission.
        """
        return pulumi.get(self, "args")

    @property
    @pulumi.getter(name="fileUris")
    def file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of files to be placed in the working directory of each executor. Useful for naively parallel tasks.
        """
        return pulumi.get(self, "file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter(name="mainRFileUri")
    def main_r_file_uri(self) -> str:
        """
        The HCFS URI of the main R file to use as the driver. Must be a .R file.
        """
        return pulumi.get(self, "main_r_file_uri")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure SparkR. Properties that conflict with values set by the Dataproc API may be overwritten. Can include properties set in /etc/spark/conf/spark-defaults.conf and classes in user code.
        """
        return pulumi.get(self, "properties")


@pulumi.output_type
class SparkSqlBatchResponse(dict):
    """
    A configuration for running Apache Spark SQL (http://spark.apache.org/sql/) queries as a batch workload.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryVariables":
            suggest = "query_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkSqlBatchResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkSqlBatchResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkSqlBatchResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar_file_uris: Sequence[str],
                 query_file_uri: str,
                 query_variables: Mapping[str, str]):
        """
        A configuration for running Apache Spark SQL (http://spark.apache.org/sql/) queries as a batch workload.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param str query_file_uri: The HCFS URI of the script that contains Spark SQL queries to execute.
        :param Mapping[str, str] query_variables: Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_variables", query_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains Spark SQL queries to execute.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryVariables")
    def query_variables(self) -> Mapping[str, str]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        return pulumi.get(self, "query_variables")


@pulumi.output_type
class SparkSqlJobResponse(dict):
    """
    A Dataproc job for running Apache Spark SQL (http://spark.apache.org/sql/) queries.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "jarFileUris":
            suggest = "jar_file_uris"
        elif key == "loggingConfig":
            suggest = "logging_config"
        elif key == "queryFileUri":
            suggest = "query_file_uri"
        elif key == "queryList":
            suggest = "query_list"
        elif key == "scriptVariables":
            suggest = "script_variables"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkSqlJobResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkSqlJobResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkSqlJobResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 jar_file_uris: Sequence[str],
                 logging_config: 'outputs.LoggingConfigResponse',
                 properties: Mapping[str, str],
                 query_file_uri: str,
                 query_list: 'outputs.QueryListResponse',
                 script_variables: Mapping[str, str]):
        """
        A Dataproc job for running Apache Spark SQL (http://spark.apache.org/sql/) queries.
        :param Sequence[str] jar_file_uris: Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        :param 'LoggingConfigResponse' logging_config: Optional. The runtime log config for job execution.
        :param Mapping[str, str] properties: Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        :param str query_file_uri: The HCFS URI of the script that contains SQL queries.
        :param 'QueryListResponse' query_list: A list of queries.
        :param Mapping[str, str] script_variables: Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        pulumi.set(__self__, "jar_file_uris", jar_file_uris)
        pulumi.set(__self__, "logging_config", logging_config)
        pulumi.set(__self__, "properties", properties)
        pulumi.set(__self__, "query_file_uri", query_file_uri)
        pulumi.set(__self__, "query_list", query_list)
        pulumi.set(__self__, "script_variables", script_variables)

    @property
    @pulumi.getter(name="jarFileUris")
    def jar_file_uris(self) -> Sequence[str]:
        """
        Optional. HCFS URIs of jar files to be added to the Spark CLASSPATH.
        """
        return pulumi.get(self, "jar_file_uris")

    @property
    @pulumi.getter(name="loggingConfig")
    def logging_config(self) -> 'outputs.LoggingConfigResponse':
        """
        Optional. The runtime log config for job execution.
        """
        return pulumi.get(self, "logging_config")

    @property
    @pulumi.getter
    def properties(self) -> Mapping[str, str]:
        """
        Optional. A mapping of property names to values, used to configure Spark SQL's SparkConf. Properties that conflict with values set by the Dataproc API may be overwritten.
        """
        return pulumi.get(self, "properties")

    @property
    @pulumi.getter(name="queryFileUri")
    def query_file_uri(self) -> str:
        """
        The HCFS URI of the script that contains SQL queries.
        """
        return pulumi.get(self, "query_file_uri")

    @property
    @pulumi.getter(name="queryList")
    def query_list(self) -> 'outputs.QueryListResponse':
        """
        A list of queries.
        """
        return pulumi.get(self, "query_list")

    @property
    @pulumi.getter(name="scriptVariables")
    def script_variables(self) -> Mapping[str, str]:
        """
        Optional. Mapping of query variable names to values (equivalent to the Spark SQL command: SET name="value";).
        """
        return pulumi.get(self, "script_variables")


@pulumi.output_type
class SparkStandaloneAutoscalingConfigResponse(dict):
    """
    Basic autoscaling configurations for Spark Standalone.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "gracefulDecommissionTimeout":
            suggest = "graceful_decommission_timeout"
        elif key == "scaleDownFactor":
            suggest = "scale_down_factor"
        elif key == "scaleDownMinWorkerFraction":
            suggest = "scale_down_min_worker_fraction"
        elif key == "scaleUpFactor":
            suggest = "scale_up_factor"
        elif key == "scaleUpMinWorkerFraction":
            suggest = "scale_up_min_worker_fraction"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in SparkStandaloneAutoscalingConfigResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        SparkStandaloneAutoscalingConfigResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        SparkStandaloneAutoscalingConfigResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 graceful_decommission_timeout: str,
                 scale_down_factor: float,
                 scale_down_min_worker_fraction: float,
                 scale_up_factor: float,
                 scale_up_min_worker_fraction: float):
        """
        Basic autoscaling configurations for Spark Standalone.
        :param str graceful_decommission_timeout: Timeout for Spark graceful decommissioning of spark workers. Specifies the duration to wait for spark worker to complete spark decomissioning tasks before forcefully removing workers. Only applicable to downscaling operations.Bounds: 0s, 1d.
        :param float scale_down_factor: Fraction of required executors to remove from Spark Serverless clusters. A scale-down factor of 1.0 will result in scaling down so that there are no more executors for the Spark Job.(more aggressive scaling). A scale-down factor closer to 0 will result in a smaller magnitude of scaling donw (less aggressive scaling).Bounds: 0.0, 1.0.
        :param float scale_down_min_worker_fraction: Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        :param float scale_up_factor: Fraction of required workers to add to Spark Standalone clusters. A scale-up factor of 1.0 will result in scaling up so that there are no more required workers for the Spark Job (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling).Bounds: 0.0, 1.0.
        :param float scale_up_min_worker_fraction: Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        pulumi.set(__self__, "graceful_decommission_timeout", graceful_decommission_timeout)
        pulumi.set(__self__, "scale_down_factor", scale_down_factor)
        pulumi.set(__self__, "scale_down_min_worker_fraction", scale_down_min_worker_fraction)
        pulumi.set(__self__, "scale_up_factor", scale_up_factor)
        pulumi.set(__self__, "scale_up_min_worker_fraction", scale_up_min_worker_fraction)

    @property
    @pulumi.getter(name="gracefulDecommissionTimeout")
    def graceful_decommission_timeout(self) -> str:
        """
        Timeout for Spark graceful decommissioning of spark workers. Specifies the duration to wait for spark worker to complete spark decomissioning tasks before forcefully removing workers. Only applicable to downscaling operations.Bounds: 0s, 1d.
        """
        return pulumi.get(self, "graceful_decommission_timeout")

    @property
    @pulumi.getter(name="scaleDownFactor")
    def scale_down_factor(self) -> float:
        """
        Fraction of required executors to remove from Spark Serverless clusters. A scale-down factor of 1.0 will result in scaling down so that there are no more executors for the Spark Job.(more aggressive scaling). A scale-down factor closer to 0 will result in a smaller magnitude of scaling donw (less aggressive scaling).Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_down_factor")

    @property
    @pulumi.getter(name="scaleDownMinWorkerFraction")
    def scale_down_min_worker_fraction(self) -> float:
        """
        Optional. Minimum scale-down threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2 worker scale-down for the cluster to scale. A threshold of 0 means the autoscaler will scale down on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_down_min_worker_fraction")

    @property
    @pulumi.getter(name="scaleUpFactor")
    def scale_up_factor(self) -> float:
        """
        Fraction of required workers to add to Spark Standalone clusters. A scale-up factor of 1.0 will result in scaling up so that there are no more required workers for the Spark Job (more aggressive scaling). A scale-up factor closer to 0 will result in a smaller magnitude of scaling up (less aggressive scaling).Bounds: 0.0, 1.0.
        """
        return pulumi.get(self, "scale_up_factor")

    @property
    @pulumi.getter(name="scaleUpMinWorkerFraction")
    def scale_up_min_worker_fraction(self) -> float:
        """
        Optional. Minimum scale-up threshold as a fraction of total cluster size before scaling occurs. For example, in a 20-worker cluster, a threshold of 0.1 means the autoscaler must recommend at least a 2-worker scale-up for the cluster to scale. A threshold of 0 means the autoscaler will scale up on any recommended change.Bounds: 0.0, 1.0. Default: 0.0.
        """
        return pulumi.get(self, "scale_up_min_worker_fraction")


@pulumi.output_type
class StateHistoryResponse(dict):
    """
    Historical state information.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "stateMessage":
            suggest = "state_message"
        elif key == "stateStartTime":
            suggest = "state_start_time"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in StateHistoryResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        StateHistoryResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        StateHistoryResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 state: str,
                 state_message: str,
                 state_start_time: str):
        """
        Historical state information.
        :param str state: The state of the batch at this point in history.
        :param str state_message: Details about the state at this point in history.
        :param str state_start_time: The time when the batch entered the historical state.
        """
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "state_message", state_message)
        pulumi.set(__self__, "state_start_time", state_start_time)

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The state of the batch at this point in history.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> str:
        """
        Details about the state at this point in history.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="stateStartTime")
    def state_start_time(self) -> str:
        """
        The time when the batch entered the historical state.
        """
        return pulumi.get(self, "state_start_time")


@pulumi.output_type
class TemplateParameterResponse(dict):
    """
    A configurable parameter that replaces one or more fields in the template. Parameterizable fields: - Labels - File uris - Job properties - Job arguments - Script variables - Main class (in HadoopJob and SparkJob) - Zone (in ClusterSelector)
    """
    def __init__(__self__, *,
                 description: str,
                 fields: Sequence[str],
                 name: str,
                 validation: 'outputs.ParameterValidationResponse'):
        """
        A configurable parameter that replaces one or more fields in the template. Parameterizable fields: - Labels - File uris - Job properties - Job arguments - Script variables - Main class (in HadoopJob and SparkJob) - Zone (in ClusterSelector)
        :param str description: Optional. Brief description of the parameter. Must not exceed 1024 characters.
        :param Sequence[str] fields: Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths.A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as placement.clusterSelector.zone.Also, field paths can reference fields using the following syntax: Values in maps can be referenced by key: labels'key' placement.clusterSelector.clusterLabels'key' placement.managedCluster.labels'key' placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key' Jobs in the jobs list can be referenced by step-id: jobs'step-id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri jobs'step-id'.pySparkJob.mainPythonFileUri jobs'step-id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0 jobs'step-id'.hadoopJob.fileUris0 jobs'step-id'.pySparkJob.pythonFileUris0 Items in repeated fields can be referenced by a zero-based index: jobs'step-id'.sparkJob.args0 Other examples: jobs'step-id'.hadoopJob.properties'key' jobs'step-id'.hadoopJob.args0 jobs'step-id'.hiveJob.scriptVariables'key' jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: placement.clusterSelector.clusterLabels jobs'step-id'.sparkJob.args
        :param str name: Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        :param 'ParameterValidationResponse' validation: Optional. Validation rules to be applied to this parameter's value.
        """
        pulumi.set(__self__, "description", description)
        pulumi.set(__self__, "fields", fields)
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "validation", validation)

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        Optional. Brief description of the parameter. Must not exceed 1024 characters.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter
    def fields(self) -> Sequence[str]:
        """
        Paths to all fields that the parameter replaces. A field is allowed to appear in at most one parameter's list of field paths.A field path is similar in syntax to a google.protobuf.FieldMask. For example, a field path that references the zone field of a workflow template's cluster selector would be specified as placement.clusterSelector.zone.Also, field paths can reference fields using the following syntax: Values in maps can be referenced by key: labels'key' placement.clusterSelector.clusterLabels'key' placement.managedCluster.labels'key' placement.clusterSelector.clusterLabels'key' jobs'step-id'.labels'key' Jobs in the jobs list can be referenced by step-id: jobs'step-id'.hadoopJob.mainJarFileUri jobs'step-id'.hiveJob.queryFileUri jobs'step-id'.pySparkJob.mainPythonFileUri jobs'step-id'.hadoopJob.jarFileUris0 jobs'step-id'.hadoopJob.archiveUris0 jobs'step-id'.hadoopJob.fileUris0 jobs'step-id'.pySparkJob.pythonFileUris0 Items in repeated fields can be referenced by a zero-based index: jobs'step-id'.sparkJob.args0 Other examples: jobs'step-id'.hadoopJob.properties'key' jobs'step-id'.hadoopJob.args0 jobs'step-id'.hiveJob.scriptVariables'key' jobs'step-id'.hadoopJob.mainJarFileUri placement.clusterSelector.zoneIt may not be possible to parameterize maps and repeated fields in their entirety since only individual map values and individual items in repeated fields can be referenced. For example, the following field paths are invalid: placement.clusterSelector.clusterLabels jobs'step-id'.sparkJob.args
        """
        return pulumi.get(self, "fields")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        Parameter name. The parameter name is used as the key, and paired with the parameter value, which are passed to the template when the template is instantiated. The name must contain only capital letters (A-Z), numbers (0-9), and underscores (_), and must not start with a number. The maximum length is 40 characters.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def validation(self) -> 'outputs.ParameterValidationResponse':
        """
        Optional. Validation rules to be applied to this parameter's value.
        """
        return pulumi.get(self, "validation")


@pulumi.output_type
class ValueValidationResponse(dict):
    """
    Validation based on a list of allowed values.
    """
    def __init__(__self__, *,
                 values: Sequence[str]):
        """
        Validation based on a list of allowed values.
        :param Sequence[str] values: List of allowed values for the parameter.
        """
        pulumi.set(__self__, "values", values)

    @property
    @pulumi.getter
    def values(self) -> Sequence[str]:
        """
        List of allowed values for the parameter.
        """
        return pulumi.get(self, "values")


@pulumi.output_type
class WorkflowTemplatePlacementResponse(dict):
    """
    Specifies workflow execution target.Either managed_cluster or cluster_selector is required.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "clusterSelector":
            suggest = "cluster_selector"
        elif key == "managedCluster":
            suggest = "managed_cluster"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in WorkflowTemplatePlacementResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        WorkflowTemplatePlacementResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        WorkflowTemplatePlacementResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 cluster_selector: 'outputs.ClusterSelectorResponse',
                 managed_cluster: 'outputs.ManagedClusterResponse'):
        """
        Specifies workflow execution target.Either managed_cluster or cluster_selector is required.
        :param 'ClusterSelectorResponse' cluster_selector: Optional. A selector that chooses target cluster for jobs based on metadata.The selector is evaluated at the time each job is submitted.
        :param 'ManagedClusterResponse' managed_cluster: A cluster that is managed by the workflow.
        """
        pulumi.set(__self__, "cluster_selector", cluster_selector)
        pulumi.set(__self__, "managed_cluster", managed_cluster)

    @property
    @pulumi.getter(name="clusterSelector")
    def cluster_selector(self) -> 'outputs.ClusterSelectorResponse':
        """
        Optional. A selector that chooses target cluster for jobs based on metadata.The selector is evaluated at the time each job is submitted.
        """
        return pulumi.get(self, "cluster_selector")

    @property
    @pulumi.getter(name="managedCluster")
    def managed_cluster(self) -> 'outputs.ManagedClusterResponse':
        """
        A cluster that is managed by the workflow.
        """
        return pulumi.get(self, "managed_cluster")


@pulumi.output_type
class YarnApplicationResponse(dict):
    """
    A YARN application created by a job. Application information is a subset of org.apache.hadoop.yarn.proto.YarnProtos.ApplicationReportProto.Beta Feature: This report is available for testing purposes only. It may be changed before final release.
    """
    @staticmethod
    def __key_warning(key: str):
        suggest = None
        if key == "trackingUrl":
            suggest = "tracking_url"

        if suggest:
            pulumi.log.warn(f"Key '{key}' not found in YarnApplicationResponse. Access the value via the '{suggest}' property getter instead.")

    def __getitem__(self, key: str) -> Any:
        YarnApplicationResponse.__key_warning(key)
        return super().__getitem__(key)

    def get(self, key: str, default = None) -> Any:
        YarnApplicationResponse.__key_warning(key)
        return super().get(key, default)

    def __init__(__self__, *,
                 name: str,
                 progress: float,
                 state: str,
                 tracking_url: str):
        """
        A YARN application created by a job. Application information is a subset of org.apache.hadoop.yarn.proto.YarnProtos.ApplicationReportProto.Beta Feature: This report is available for testing purposes only. It may be changed before final release.
        :param str name: The application name.
        :param float progress: The numerical progress of the application, from 1 to 100.
        :param str state: The application state.
        :param str tracking_url: Optional. The HTTP URL of the ApplicationMaster, HistoryServer, or TimelineServer that provides application-specific information. The URL uses the internal hostname, and requires a proxy server for resolution and, possibly, access.
        """
        pulumi.set(__self__, "name", name)
        pulumi.set(__self__, "progress", progress)
        pulumi.set(__self__, "state", state)
        pulumi.set(__self__, "tracking_url", tracking_url)

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The application name.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def progress(self) -> float:
        """
        The numerical progress of the application, from 1 to 100.
        """
        return pulumi.get(self, "progress")

    @property
    @pulumi.getter
    def state(self) -> str:
        """
        The application state.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="trackingUrl")
    def tracking_url(self) -> str:
        """
        Optional. The HTTP URL of the ApplicationMaster, HistoryServer, or TimelineServer that provides application-specific information. The URL uses the internal hostname, and requires a proxy server for resolution and, possibly, access.
        """
        return pulumi.get(self, "tracking_url")


