# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from . import outputs
from ._inputs import *

__all__ = ['BatchArgs', 'Batch']

@pulumi.input_type
class BatchArgs:
    def __init__(__self__, *,
                 batch_id: Optional[pulumi.Input[str]] = None,
                 environment_config: Optional[pulumi.Input['EnvironmentConfigArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pyspark_batch: Optional[pulumi.Input['PySparkBatchArgs']] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 runtime_config: Optional[pulumi.Input['RuntimeConfigArgs']] = None,
                 spark_batch: Optional[pulumi.Input['SparkBatchArgs']] = None,
                 spark_r_batch: Optional[pulumi.Input['SparkRBatchArgs']] = None,
                 spark_sql_batch: Optional[pulumi.Input['SparkSqlBatchArgs']] = None):
        """
        The set of arguments for constructing a Batch resource.
        :param pulumi.Input['EnvironmentConfigArgs'] environment_config: Optional. Environment configuration for the batch execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. The labels to associate with this batch. Label keys must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a batch.
        :param pulumi.Input['PySparkBatchArgs'] pyspark_batch: Optional. PySpark batch config.
        :param pulumi.Input['RuntimeConfigArgs'] runtime_config: Optional. Runtime configuration for the batch execution.
        :param pulumi.Input['SparkBatchArgs'] spark_batch: Optional. Spark batch config.
        :param pulumi.Input['SparkRBatchArgs'] spark_r_batch: Optional. SparkR batch config.
        :param pulumi.Input['SparkSqlBatchArgs'] spark_sql_batch: Optional. SparkSql batch config.
        """
        if batch_id is not None:
            pulumi.set(__self__, "batch_id", batch_id)
        if environment_config is not None:
            pulumi.set(__self__, "environment_config", environment_config)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if pyspark_batch is not None:
            pulumi.set(__self__, "pyspark_batch", pyspark_batch)
        if request_id is not None:
            pulumi.set(__self__, "request_id", request_id)
        if runtime_config is not None:
            pulumi.set(__self__, "runtime_config", runtime_config)
        if spark_batch is not None:
            pulumi.set(__self__, "spark_batch", spark_batch)
        if spark_r_batch is not None:
            pulumi.set(__self__, "spark_r_batch", spark_r_batch)
        if spark_sql_batch is not None:
            pulumi.set(__self__, "spark_sql_batch", spark_sql_batch)

    @property
    @pulumi.getter(name="batchId")
    def batch_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "batch_id")

    @batch_id.setter
    def batch_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "batch_id", value)

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> Optional[pulumi.Input['EnvironmentConfigArgs']]:
        """
        Optional. Environment configuration for the batch execution.
        """
        return pulumi.get(self, "environment_config")

    @environment_config.setter
    def environment_config(self, value: Optional[pulumi.Input['EnvironmentConfigArgs']]):
        pulumi.set(self, "environment_config", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Optional. The labels to associate with this batch. Label keys must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a batch.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="pysparkBatch")
    def pyspark_batch(self) -> Optional[pulumi.Input['PySparkBatchArgs']]:
        """
        Optional. PySpark batch config.
        """
        return pulumi.get(self, "pyspark_batch")

    @pyspark_batch.setter
    def pyspark_batch(self, value: Optional[pulumi.Input['PySparkBatchArgs']]):
        pulumi.set(self, "pyspark_batch", value)

    @property
    @pulumi.getter(name="requestId")
    def request_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "request_id")

    @request_id.setter
    def request_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "request_id", value)

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> Optional[pulumi.Input['RuntimeConfigArgs']]:
        """
        Optional. Runtime configuration for the batch execution.
        """
        return pulumi.get(self, "runtime_config")

    @runtime_config.setter
    def runtime_config(self, value: Optional[pulumi.Input['RuntimeConfigArgs']]):
        pulumi.set(self, "runtime_config", value)

    @property
    @pulumi.getter(name="sparkBatch")
    def spark_batch(self) -> Optional[pulumi.Input['SparkBatchArgs']]:
        """
        Optional. Spark batch config.
        """
        return pulumi.get(self, "spark_batch")

    @spark_batch.setter
    def spark_batch(self, value: Optional[pulumi.Input['SparkBatchArgs']]):
        pulumi.set(self, "spark_batch", value)

    @property
    @pulumi.getter(name="sparkRBatch")
    def spark_r_batch(self) -> Optional[pulumi.Input['SparkRBatchArgs']]:
        """
        Optional. SparkR batch config.
        """
        return pulumi.get(self, "spark_r_batch")

    @spark_r_batch.setter
    def spark_r_batch(self, value: Optional[pulumi.Input['SparkRBatchArgs']]):
        pulumi.set(self, "spark_r_batch", value)

    @property
    @pulumi.getter(name="sparkSqlBatch")
    def spark_sql_batch(self) -> Optional[pulumi.Input['SparkSqlBatchArgs']]:
        """
        Optional. SparkSql batch config.
        """
        return pulumi.get(self, "spark_sql_batch")

    @spark_sql_batch.setter
    def spark_sql_batch(self, value: Optional[pulumi.Input['SparkSqlBatchArgs']]):
        pulumi.set(self, "spark_sql_batch", value)


class Batch(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_id: Optional[pulumi.Input[str]] = None,
                 environment_config: Optional[pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pyspark_batch: Optional[pulumi.Input[pulumi.InputType['PySparkBatchArgs']]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 runtime_config: Optional[pulumi.Input[pulumi.InputType['RuntimeConfigArgs']]] = None,
                 spark_batch: Optional[pulumi.Input[pulumi.InputType['SparkBatchArgs']]] = None,
                 spark_r_batch: Optional[pulumi.Input[pulumi.InputType['SparkRBatchArgs']]] = None,
                 spark_sql_batch: Optional[pulumi.Input[pulumi.InputType['SparkSqlBatchArgs']]] = None,
                 __props__=None):
        """
        Creates a batch workload that executes asynchronously.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']] environment_config: Optional. Environment configuration for the batch execution.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Optional. The labels to associate with this batch. Label keys must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a batch.
        :param pulumi.Input[pulumi.InputType['PySparkBatchArgs']] pyspark_batch: Optional. PySpark batch config.
        :param pulumi.Input[pulumi.InputType['RuntimeConfigArgs']] runtime_config: Optional. Runtime configuration for the batch execution.
        :param pulumi.Input[pulumi.InputType['SparkBatchArgs']] spark_batch: Optional. Spark batch config.
        :param pulumi.Input[pulumi.InputType['SparkRBatchArgs']] spark_r_batch: Optional. SparkR batch config.
        :param pulumi.Input[pulumi.InputType['SparkSqlBatchArgs']] spark_sql_batch: Optional. SparkSql batch config.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[BatchArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        Creates a batch workload that executes asynchronously.
        Auto-naming is currently not supported for this resource.

        :param str resource_name: The name of the resource.
        :param BatchArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(BatchArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 batch_id: Optional[pulumi.Input[str]] = None,
                 environment_config: Optional[pulumi.Input[pulumi.InputType['EnvironmentConfigArgs']]] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 pyspark_batch: Optional[pulumi.Input[pulumi.InputType['PySparkBatchArgs']]] = None,
                 request_id: Optional[pulumi.Input[str]] = None,
                 runtime_config: Optional[pulumi.Input[pulumi.InputType['RuntimeConfigArgs']]] = None,
                 spark_batch: Optional[pulumi.Input[pulumi.InputType['SparkBatchArgs']]] = None,
                 spark_r_batch: Optional[pulumi.Input[pulumi.InputType['SparkRBatchArgs']]] = None,
                 spark_sql_batch: Optional[pulumi.Input[pulumi.InputType['SparkSqlBatchArgs']]] = None,
                 __props__=None):
        if opts is None:
            opts = pulumi.ResourceOptions()
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.version is None:
            opts.version = _utilities.get_version()
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = BatchArgs.__new__(BatchArgs)

            __props__.__dict__["batch_id"] = batch_id
            __props__.__dict__["environment_config"] = environment_config
            __props__.__dict__["labels"] = labels
            __props__.__dict__["location"] = location
            __props__.__dict__["project"] = project
            __props__.__dict__["pyspark_batch"] = pyspark_batch
            __props__.__dict__["request_id"] = request_id
            __props__.__dict__["runtime_config"] = runtime_config
            __props__.__dict__["spark_batch"] = spark_batch
            __props__.__dict__["spark_r_batch"] = spark_r_batch
            __props__.__dict__["spark_sql_batch"] = spark_sql_batch
            __props__.__dict__["create_time"] = None
            __props__.__dict__["creator"] = None
            __props__.__dict__["name"] = None
            __props__.__dict__["operation"] = None
            __props__.__dict__["runtime_info"] = None
            __props__.__dict__["state"] = None
            __props__.__dict__["state_history"] = None
            __props__.__dict__["state_message"] = None
            __props__.__dict__["state_time"] = None
            __props__.__dict__["uuid"] = None
        super(Batch, __self__).__init__(
            'google-native:dataproc/v1:Batch',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None) -> 'Batch':
        """
        Get an existing Batch resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = BatchArgs.__new__(BatchArgs)

        __props__.__dict__["create_time"] = None
        __props__.__dict__["creator"] = None
        __props__.__dict__["environment_config"] = None
        __props__.__dict__["labels"] = None
        __props__.__dict__["name"] = None
        __props__.__dict__["operation"] = None
        __props__.__dict__["pyspark_batch"] = None
        __props__.__dict__["runtime_config"] = None
        __props__.__dict__["runtime_info"] = None
        __props__.__dict__["spark_batch"] = None
        __props__.__dict__["spark_r_batch"] = None
        __props__.__dict__["spark_sql_batch"] = None
        __props__.__dict__["state"] = None
        __props__.__dict__["state_history"] = None
        __props__.__dict__["state_message"] = None
        __props__.__dict__["state_time"] = None
        __props__.__dict__["uuid"] = None
        return Batch(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> pulumi.Output[str]:
        """
        The time when the batch was created.
        """
        return pulumi.get(self, "create_time")

    @property
    @pulumi.getter
    def creator(self) -> pulumi.Output[str]:
        """
        The email address of the user who created the batch.
        """
        return pulumi.get(self, "creator")

    @property
    @pulumi.getter(name="environmentConfig")
    def environment_config(self) -> pulumi.Output['outputs.EnvironmentConfigResponse']:
        """
        Optional. Environment configuration for the batch execution.
        """
        return pulumi.get(self, "environment_config")

    @property
    @pulumi.getter
    def labels(self) -> pulumi.Output[Mapping[str, str]]:
        """
        Optional. The labels to associate with this batch. Label keys must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). Label values may be empty, but, if present, must contain 1 to 63 characters, and must conform to RFC 1035 (https://www.ietf.org/rfc/rfc1035.txt). No more than 32 labels can be associated with a batch.
        """
        return pulumi.get(self, "labels")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        The resource name of the batch.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def operation(self) -> pulumi.Output[str]:
        """
        The resource name of the operation associated with this batch.
        """
        return pulumi.get(self, "operation")

    @property
    @pulumi.getter(name="pysparkBatch")
    def pyspark_batch(self) -> pulumi.Output['outputs.PySparkBatchResponse']:
        """
        Optional. PySpark batch config.
        """
        return pulumi.get(self, "pyspark_batch")

    @property
    @pulumi.getter(name="runtimeConfig")
    def runtime_config(self) -> pulumi.Output['outputs.RuntimeConfigResponse']:
        """
        Optional. Runtime configuration for the batch execution.
        """
        return pulumi.get(self, "runtime_config")

    @property
    @pulumi.getter(name="runtimeInfo")
    def runtime_info(self) -> pulumi.Output['outputs.RuntimeInfoResponse']:
        """
        Runtime information about batch execution.
        """
        return pulumi.get(self, "runtime_info")

    @property
    @pulumi.getter(name="sparkBatch")
    def spark_batch(self) -> pulumi.Output['outputs.SparkBatchResponse']:
        """
        Optional. Spark batch config.
        """
        return pulumi.get(self, "spark_batch")

    @property
    @pulumi.getter(name="sparkRBatch")
    def spark_r_batch(self) -> pulumi.Output['outputs.SparkRBatchResponse']:
        """
        Optional. SparkR batch config.
        """
        return pulumi.get(self, "spark_r_batch")

    @property
    @pulumi.getter(name="sparkSqlBatch")
    def spark_sql_batch(self) -> pulumi.Output['outputs.SparkSqlBatchResponse']:
        """
        Optional. SparkSql batch config.
        """
        return pulumi.get(self, "spark_sql_batch")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        """
        The state of the batch.
        """
        return pulumi.get(self, "state")

    @property
    @pulumi.getter(name="stateHistory")
    def state_history(self) -> pulumi.Output[Sequence['outputs.StateHistoryResponse']]:
        """
        Historical state information for the batch.
        """
        return pulumi.get(self, "state_history")

    @property
    @pulumi.getter(name="stateMessage")
    def state_message(self) -> pulumi.Output[str]:
        """
        Batch state details, such as a failure description if the state is FAILED.
        """
        return pulumi.get(self, "state_message")

    @property
    @pulumi.getter(name="stateTime")
    def state_time(self) -> pulumi.Output[str]:
        """
        The time when the batch entered a current state.
        """
        return pulumi.get(self, "state_time")

    @property
    @pulumi.getter
    def uuid(self) -> pulumi.Output[str]:
        """
        A batch UUID (Unique Universal Identifier). The service generates this value when it creates the batch.
        """
        return pulumi.get(self, "uuid")

