# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AliasContextArgs',
    'ArtifactArgs',
    'AttestationNoteArgs',
    'AttestationOccurrenceArgs',
    'BindingArgs',
    'BuildNoteArgs',
    'BuildOccurrenceArgs',
    'BuildProvenanceArgs',
    'BuilderConfigArgs',
    'CVSSv3Args',
    'CVSSArgs',
    'CategoryArgs',
    'CisBenchmarkArgs',
    'CloudRepoSourceContextArgs',
    'CommandArgs',
    'CompletenessArgs',
    'ComplianceNoteArgs',
    'ComplianceOccurrenceArgs',
    'ComplianceVersionArgs',
    'DSSEAttestationNoteArgs',
    'DSSEAttestationOccurrenceArgs',
    'DSSEHintArgs',
    'DeploymentNoteArgs',
    'DeploymentOccurrenceArgs',
    'DetailArgs',
    'DiscoveryNoteArgs',
    'DiscoveryOccurrenceArgs',
    'DistributionArgs',
    'EnvelopeSignatureArgs',
    'EnvelopeArgs',
    'ExprArgs',
    'FingerprintArgs',
    'GerritSourceContextArgs',
    'GitSourceContextArgs',
    'HintArgs',
    'IdentityArgs',
    'ImageNoteArgs',
    'ImageOccurrenceArgs',
    'InTotoProvenanceArgs',
    'InTotoStatementArgs',
    'JwtArgs',
    'KnowledgeBaseArgs',
    'LayerArgs',
    'LocationArgs',
    'MaterialArgs',
    'MetadataArgs',
    'NonCompliantFileArgs',
    'PackageIssueArgs',
    'PackageNoteArgs',
    'PackageOccurrenceArgs',
    'ProjectRepoIdArgs',
    'RecipeArgs',
    'RelatedUrlArgs',
    'RepoIdArgs',
    'SignatureArgs',
    'SlsaBuilderArgs',
    'SlsaCompletenessArgs',
    'SlsaMetadataArgs',
    'SlsaProvenanceArgs',
    'SlsaRecipeArgs',
    'SourceContextArgs',
    'SourceArgs',
    'StatusArgs',
    'SubjectArgs',
    'UpgradeDistributionArgs',
    'UpgradeNoteArgs',
    'UpgradeOccurrenceArgs',
    'VersionArgs',
    'VulnerabilityNoteArgs',
    'VulnerabilityOccurrenceArgs',
    'WindowsDetailArgs',
    'WindowsUpdateArgs',
]

@pulumi.input_type
class AliasContextArgs:
    def __init__(__self__, *,
                 kind: Optional[pulumi.Input['AliasContextKind']] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        An alias to a repo revision.
        :param pulumi.Input['AliasContextKind'] kind: The alias kind.
        :param pulumi.Input[str] name: The alias name.
        """
        if kind is not None:
            pulumi.set(__self__, "kind", kind)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def kind(self) -> Optional[pulumi.Input['AliasContextKind']]:
        """
        The alias kind.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: Optional[pulumi.Input['AliasContextKind']]):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The alias name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class ArtifactArgs:
    def __init__(__self__, *,
                 checksum: Optional[pulumi.Input[str]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 names: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Artifact describes a build product.
        :param pulumi.Input[str] checksum: Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        :param pulumi.Input[str] id: Artifact ID, if any; for container images, this will be a URL by digest like `gcr.io/projectID/imagename@sha256:123456`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] names: Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        if checksum is not None:
            pulumi.set(__self__, "checksum", checksum)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if names is not None:
            pulumi.set(__self__, "names", names)

    @property
    @pulumi.getter
    def checksum(self) -> Optional[pulumi.Input[str]]:
        """
        Hash or checksum value of a binary, or Docker Registry 2.0 digest of a container.
        """
        return pulumi.get(self, "checksum")

    @checksum.setter
    def checksum(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "checksum", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Artifact ID, if any; for container images, this will be a URL by digest like `gcr.io/projectID/imagename@sha256:123456`.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter
    def names(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Related artifact names. This may be the path to a binary or jar file, or in the case of a container build, the name used to push the container image to Google Container Registry, as presented to `docker push`. Note that a single Artifact ID can have multiple names, for example if two tags are applied to one image.
        """
        return pulumi.get(self, "names")

    @names.setter
    def names(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "names", value)


@pulumi.input_type
class AttestationNoteArgs:
    def __init__(__self__, *,
                 hint: Optional[pulumi.Input['HintArgs']] = None):
        """
        Note kind that represents a logical attestation "role" or "authority". For example, an organization might have one `Authority` for "QA" and one for "build". This note is intended to act strictly as a grouping mechanism for the attached occurrences (Attestations). This grouping mechanism also provides a security boundary, since IAM ACLs gate the ability for a principle to attach an occurrence to a given note. It also provides a single point of lookup to find all attached attestation occurrences, even if they don't all live in the same project.
        :param pulumi.Input['HintArgs'] hint: Hint hints at the purpose of the attestation authority.
        """
        if hint is not None:
            pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> Optional[pulumi.Input['HintArgs']]:
        """
        Hint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")

    @hint.setter
    def hint(self, value: Optional[pulumi.Input['HintArgs']]):
        pulumi.set(self, "hint", value)


@pulumi.input_type
class AttestationOccurrenceArgs:
    def __init__(__self__, *,
                 serialized_payload: pulumi.Input[str],
                 jwts: Optional[pulumi.Input[Sequence[pulumi.Input['JwtArgs']]]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]]] = None):
        """
        Occurrence that represents a single "attestation". The authenticity of an attestation can be verified using the attached signature. If the verifier trusts the public key of the signer, then verifying the signature is sufficient to establish trust. In this circumstance, the authority to which this attestation is attached is primarily useful for lookup (how to find this attestation if you already know the authority and artifact to be verified) and intent (for which authority this attestation was intended to sign.
        :param pulumi.Input[str] serialized_payload: The serialized payload that is verified by one or more `signatures`.
        :param pulumi.Input[Sequence[pulumi.Input['JwtArgs']]] jwts: One or more JWTs encoding a self-contained attestation. Each JWT encodes the payload that it verifies within the JWT itself. Verifier implementation SHOULD ignore the `serialized_payload` field when verifying these JWTs. If only JWTs are present on this AttestationOccurrence, then the `serialized_payload` SHOULD be left empty. Each JWT SHOULD encode a claim specific to the `resource_uri` of this Occurrence, but this is not validated by Grafeas metadata API implementations. The JWT itself is opaque to Grafeas.
        :param pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]] signatures: One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        pulumi.set(__self__, "serialized_payload", serialized_payload)
        if jwts is not None:
            pulumi.set(__self__, "jwts", jwts)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter(name="serializedPayload")
    def serialized_payload(self) -> pulumi.Input[str]:
        """
        The serialized payload that is verified by one or more `signatures`.
        """
        return pulumi.get(self, "serialized_payload")

    @serialized_payload.setter
    def serialized_payload(self, value: pulumi.Input[str]):
        pulumi.set(self, "serialized_payload", value)

    @property
    @pulumi.getter
    def jwts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['JwtArgs']]]]:
        """
        One or more JWTs encoding a self-contained attestation. Each JWT encodes the payload that it verifies within the JWT itself. Verifier implementation SHOULD ignore the `serialized_payload` field when verifying these JWTs. If only JWTs are present on this AttestationOccurrence, then the `serialized_payload` SHOULD be left empty. Each JWT SHOULD encode a claim specific to the `resource_uri` of this Occurrence, but this is not validated by Grafeas metadata API implementations. The JWT itself is opaque to Grafeas.
        """
        return pulumi.get(self, "jwts")

    @jwts.setter
    def jwts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['JwtArgs']]]]):
        pulumi.set(self, "jwts", value)

    @property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]]]:
        """
        One or more signatures over `serialized_payload`. Verifier implementations should consider this attestation message verified if at least one `signature` verifies `serialized_payload`. See `Signature` in common.proto for more details on signature structure and verification.
        """
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SignatureArgs']]]]):
        pulumi.set(self, "signatures", value)


@pulumi.input_type
class BindingArgs:
    def __init__(__self__, *,
                 condition: Optional[pulumi.Input['ExprArgs']] = None,
                 members: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 role: Optional[pulumi.Input[str]] = None):
        """
        Associates `members`, or principals, with a `role`.
        :param pulumi.Input['ExprArgs'] condition: The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        :param pulumi.Input[Sequence[pulumi.Input[str]]] members: Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        :param pulumi.Input[str] role: Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        if condition is not None:
            pulumi.set(__self__, "condition", condition)
        if members is not None:
            pulumi.set(__self__, "members", members)
        if role is not None:
            pulumi.set(__self__, "role", role)

    @property
    @pulumi.getter
    def condition(self) -> Optional[pulumi.Input['ExprArgs']]:
        """
        The condition that is associated with this binding. If the condition evaluates to `true`, then this binding applies to the current request. If the condition evaluates to `false`, then this binding does not apply to the current request. However, a different role binding might grant the same role to one or more of the principals in this binding. To learn which resources support conditions in their IAM policies, see the [IAM documentation](https://cloud.google.com/iam/help/conditions/resource-policies).
        """
        return pulumi.get(self, "condition")

    @condition.setter
    def condition(self, value: Optional[pulumi.Input['ExprArgs']]):
        pulumi.set(self, "condition", value)

    @property
    @pulumi.getter
    def members(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Specifies the principals requesting access for a Cloud Platform resource. `members` can have the following values: * `allUsers`: A special identifier that represents anyone who is on the internet; with or without a Google account. * `allAuthenticatedUsers`: A special identifier that represents anyone who is authenticated with a Google account or a service account. * `user:{emailid}`: An email address that represents a specific Google account. For example, `alice@example.com` . * `serviceAccount:{emailid}`: An email address that represents a service account. For example, `my-other-app@appspot.gserviceaccount.com`. * `group:{emailid}`: An email address that represents a Google group. For example, `admins@example.com`. * `deleted:user:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a user that has been recently deleted. For example, `alice@example.com?uid=123456789012345678901`. If the user is recovered, this value reverts to `user:{emailid}` and the recovered user retains the role in the binding. * `deleted:serviceAccount:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a service account that has been recently deleted. For example, `my-other-app@appspot.gserviceaccount.com?uid=123456789012345678901`. If the service account is undeleted, this value reverts to `serviceAccount:{emailid}` and the undeleted service account retains the role in the binding. * `deleted:group:{emailid}?uid={uniqueid}`: An email address (plus unique identifier) representing a Google group that has been recently deleted. For example, `admins@example.com?uid=123456789012345678901`. If the group is recovered, this value reverts to `group:{emailid}` and the recovered group retains the role in the binding. * `domain:{domain}`: The G Suite domain (primary) that represents all the users of that domain. For example, `google.com` or `example.com`. 
        """
        return pulumi.get(self, "members")

    @members.setter
    def members(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "members", value)

    @property
    @pulumi.getter
    def role(self) -> Optional[pulumi.Input[str]]:
        """
        Role that is assigned to the list of `members`, or principals. For example, `roles/viewer`, `roles/editor`, or `roles/owner`.
        """
        return pulumi.get(self, "role")

    @role.setter
    def role(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "role", value)


@pulumi.input_type
class BuildNoteArgs:
    def __init__(__self__, *,
                 builder_version: pulumi.Input[str]):
        """
        Note holding the version of the provider's builder and the signature of the provenance message in the build details occurrence.
        :param pulumi.Input[str] builder_version: Immutable. Version of the builder which produced this build.
        """
        pulumi.set(__self__, "builder_version", builder_version)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> pulumi.Input[str]:
        """
        Immutable. Version of the builder which produced this build.
        """
        return pulumi.get(self, "builder_version")

    @builder_version.setter
    def builder_version(self, value: pulumi.Input[str]):
        pulumi.set(self, "builder_version", value)


@pulumi.input_type
class BuildOccurrenceArgs:
    def __init__(__self__, *,
                 intoto_statement: Optional[pulumi.Input['InTotoStatementArgs']] = None,
                 provenance: Optional[pulumi.Input['BuildProvenanceArgs']] = None,
                 provenance_bytes: Optional[pulumi.Input[str]] = None):
        """
        Details of a build occurrence.
        :param pulumi.Input['InTotoStatementArgs'] intoto_statement: In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        :param pulumi.Input['BuildProvenanceArgs'] provenance: The actual provenance for the build.
        :param pulumi.Input[str] provenance_bytes: Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        if intoto_statement is not None:
            pulumi.set(__self__, "intoto_statement", intoto_statement)
        if provenance is not None:
            pulumi.set(__self__, "provenance", provenance)
        if provenance_bytes is not None:
            pulumi.set(__self__, "provenance_bytes", provenance_bytes)

    @property
    @pulumi.getter(name="intotoStatement")
    def intoto_statement(self) -> Optional[pulumi.Input['InTotoStatementArgs']]:
        """
        In-toto Statement representation as defined in spec. The intoto_statement can contain any type of provenance. The serialized payload of the statement can be stored and signed in the Occurrence's envelope.
        """
        return pulumi.get(self, "intoto_statement")

    @intoto_statement.setter
    def intoto_statement(self, value: Optional[pulumi.Input['InTotoStatementArgs']]):
        pulumi.set(self, "intoto_statement", value)

    @property
    @pulumi.getter
    def provenance(self) -> Optional[pulumi.Input['BuildProvenanceArgs']]:
        """
        The actual provenance for the build.
        """
        return pulumi.get(self, "provenance")

    @provenance.setter
    def provenance(self, value: Optional[pulumi.Input['BuildProvenanceArgs']]):
        pulumi.set(self, "provenance", value)

    @property
    @pulumi.getter(name="provenanceBytes")
    def provenance_bytes(self) -> Optional[pulumi.Input[str]]:
        """
        Serialized JSON representation of the provenance, used in generating the build signature in the corresponding build note. After verifying the signature, `provenance_bytes` can be unmarshalled and compared to the provenance to confirm that it is unchanged. A base64-encoded string representation of the provenance bytes is used for the signature in order to interoperate with openssl which expects this format for signature verification. The serialized form is captured both to avoid ambiguity in how the provenance is marshalled to json as well to prevent incompatibilities with future changes.
        """
        return pulumi.get(self, "provenance_bytes")

    @provenance_bytes.setter
    def provenance_bytes(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "provenance_bytes", value)


@pulumi.input_type
class BuildProvenanceArgs:
    def __init__(__self__, *,
                 id: pulumi.Input[str],
                 build_options: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 builder_version: Optional[pulumi.Input[str]] = None,
                 built_artifacts: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]] = None,
                 commands: Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]] = None,
                 create_time: Optional[pulumi.Input[str]] = None,
                 creator: Optional[pulumi.Input[str]] = None,
                 end_time: Optional[pulumi.Input[str]] = None,
                 logs_uri: Optional[pulumi.Input[str]] = None,
                 project: Optional[pulumi.Input[str]] = None,
                 source_provenance: Optional[pulumi.Input['SourceArgs']] = None,
                 start_time: Optional[pulumi.Input[str]] = None,
                 trigger_id: Optional[pulumi.Input[str]] = None):
        """
        Provenance of a build. Contains all information needed to verify the full details about the build from source to completion.
        :param pulumi.Input[str] id: Unique identifier of the build.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] build_options: Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        :param pulumi.Input[str] builder_version: Version string of the builder at the time this build was executed.
        :param pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]] built_artifacts: Output of the build.
        :param pulumi.Input[Sequence[pulumi.Input['CommandArgs']]] commands: Commands requested by the build.
        :param pulumi.Input[str] create_time: Time at which the build was created.
        :param pulumi.Input[str] creator: E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        :param pulumi.Input[str] end_time: Time at which execution of the build was finished.
        :param pulumi.Input[str] logs_uri: URI where any logs for this provenance were written.
        :param pulumi.Input[str] project: ID of the project.
        :param pulumi.Input['SourceArgs'] source_provenance: Details of the Source input to the build.
        :param pulumi.Input[str] start_time: Time at which execution of the build was started.
        :param pulumi.Input[str] trigger_id: Trigger identifier if the build was triggered automatically; empty if not.
        """
        pulumi.set(__self__, "id", id)
        if build_options is not None:
            pulumi.set(__self__, "build_options", build_options)
        if builder_version is not None:
            pulumi.set(__self__, "builder_version", builder_version)
        if built_artifacts is not None:
            pulumi.set(__self__, "built_artifacts", built_artifacts)
        if commands is not None:
            pulumi.set(__self__, "commands", commands)
        if create_time is not None:
            pulumi.set(__self__, "create_time", create_time)
        if creator is not None:
            pulumi.set(__self__, "creator", creator)
        if end_time is not None:
            pulumi.set(__self__, "end_time", end_time)
        if logs_uri is not None:
            pulumi.set(__self__, "logs_uri", logs_uri)
        if project is not None:
            pulumi.set(__self__, "project", project)
        if source_provenance is not None:
            pulumi.set(__self__, "source_provenance", source_provenance)
        if start_time is not None:
            pulumi.set(__self__, "start_time", start_time)
        if trigger_id is not None:
            pulumi.set(__self__, "trigger_id", trigger_id)

    @property
    @pulumi.getter
    def id(self) -> pulumi.Input[str]:
        """
        Unique identifier of the build.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: pulumi.Input[str]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="buildOptions")
    def build_options(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Special options applied to this build. This is a catch-all field where build providers can enter any desired additional details.
        """
        return pulumi.get(self, "build_options")

    @build_options.setter
    def build_options(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "build_options", value)

    @property
    @pulumi.getter(name="builderVersion")
    def builder_version(self) -> Optional[pulumi.Input[str]]:
        """
        Version string of the builder at the time this build was executed.
        """
        return pulumi.get(self, "builder_version")

    @builder_version.setter
    def builder_version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "builder_version", value)

    @property
    @pulumi.getter(name="builtArtifacts")
    def built_artifacts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]]:
        """
        Output of the build.
        """
        return pulumi.get(self, "built_artifacts")

    @built_artifacts.setter
    def built_artifacts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ArtifactArgs']]]]):
        pulumi.set(self, "built_artifacts", value)

    @property
    @pulumi.getter
    def commands(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]]:
        """
        Commands requested by the build.
        """
        return pulumi.get(self, "commands")

    @commands.setter
    def commands(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CommandArgs']]]]):
        pulumi.set(self, "commands", value)

    @property
    @pulumi.getter(name="createTime")
    def create_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which the build was created.
        """
        return pulumi.get(self, "create_time")

    @create_time.setter
    def create_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "create_time", value)

    @property
    @pulumi.getter
    def creator(self) -> Optional[pulumi.Input[str]]:
        """
        E-mail address of the user who initiated this build. Note that this was the user's e-mail address at the time the build was initiated; this address may not represent the same end-user for all time.
        """
        return pulumi.get(self, "creator")

    @creator.setter
    def creator(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "creator", value)

    @property
    @pulumi.getter(name="endTime")
    def end_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which execution of the build was finished.
        """
        return pulumi.get(self, "end_time")

    @end_time.setter
    def end_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "end_time", value)

    @property
    @pulumi.getter(name="logsUri")
    def logs_uri(self) -> Optional[pulumi.Input[str]]:
        """
        URI where any logs for this provenance were written.
        """
        return pulumi.get(self, "logs_uri")

    @logs_uri.setter
    def logs_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "logs_uri", value)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        ID of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="sourceProvenance")
    def source_provenance(self) -> Optional[pulumi.Input['SourceArgs']]:
        """
        Details of the Source input to the build.
        """
        return pulumi.get(self, "source_provenance")

    @source_provenance.setter
    def source_provenance(self, value: Optional[pulumi.Input['SourceArgs']]):
        pulumi.set(self, "source_provenance", value)

    @property
    @pulumi.getter(name="startTime")
    def start_time(self) -> Optional[pulumi.Input[str]]:
        """
        Time at which execution of the build was started.
        """
        return pulumi.get(self, "start_time")

    @start_time.setter
    def start_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "start_time", value)

    @property
    @pulumi.getter(name="triggerId")
    def trigger_id(self) -> Optional[pulumi.Input[str]]:
        """
        Trigger identifier if the build was triggered automatically; empty if not.
        """
        return pulumi.get(self, "trigger_id")

    @trigger_id.setter
    def trigger_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "trigger_id", value)


@pulumi.input_type
class BuilderConfigArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class CVSSv3Args:
    def __init__(__self__, *,
                 attack_complexity: Optional[pulumi.Input['CVSSv3AttackComplexity']] = None,
                 attack_vector: Optional[pulumi.Input['CVSSv3AttackVector']] = None,
                 availability_impact: Optional[pulumi.Input['CVSSv3AvailabilityImpact']] = None,
                 base_score: Optional[pulumi.Input[float]] = None,
                 confidentiality_impact: Optional[pulumi.Input['CVSSv3ConfidentialityImpact']] = None,
                 exploitability_score: Optional[pulumi.Input[float]] = None,
                 impact_score: Optional[pulumi.Input[float]] = None,
                 integrity_impact: Optional[pulumi.Input['CVSSv3IntegrityImpact']] = None,
                 privileges_required: Optional[pulumi.Input['CVSSv3PrivilegesRequired']] = None,
                 scope: Optional[pulumi.Input['CVSSv3Scope']] = None,
                 user_interaction: Optional[pulumi.Input['CVSSv3UserInteraction']] = None):
        """
        Common Vulnerability Scoring System version 3. For details, see https://www.first.org/cvss/specification-document
        :param pulumi.Input['CVSSv3AttackVector'] attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        :param pulumi.Input[float] base_score: The base score is a function of the base metric scores.
        """
        if attack_complexity is not None:
            pulumi.set(__self__, "attack_complexity", attack_complexity)
        if attack_vector is not None:
            pulumi.set(__self__, "attack_vector", attack_vector)
        if availability_impact is not None:
            pulumi.set(__self__, "availability_impact", availability_impact)
        if base_score is not None:
            pulumi.set(__self__, "base_score", base_score)
        if confidentiality_impact is not None:
            pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        if exploitability_score is not None:
            pulumi.set(__self__, "exploitability_score", exploitability_score)
        if impact_score is not None:
            pulumi.set(__self__, "impact_score", impact_score)
        if integrity_impact is not None:
            pulumi.set(__self__, "integrity_impact", integrity_impact)
        if privileges_required is not None:
            pulumi.set(__self__, "privileges_required", privileges_required)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if user_interaction is not None:
            pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> Optional[pulumi.Input['CVSSv3AttackComplexity']]:
        return pulumi.get(self, "attack_complexity")

    @attack_complexity.setter
    def attack_complexity(self, value: Optional[pulumi.Input['CVSSv3AttackComplexity']]):
        pulumi.set(self, "attack_complexity", value)

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> Optional[pulumi.Input['CVSSv3AttackVector']]:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        """
        return pulumi.get(self, "attack_vector")

    @attack_vector.setter
    def attack_vector(self, value: Optional[pulumi.Input['CVSSv3AttackVector']]):
        pulumi.set(self, "attack_vector", value)

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> Optional[pulumi.Input['CVSSv3AvailabilityImpact']]:
        return pulumi.get(self, "availability_impact")

    @availability_impact.setter
    def availability_impact(self, value: Optional[pulumi.Input['CVSSv3AvailabilityImpact']]):
        pulumi.set(self, "availability_impact", value)

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> Optional[pulumi.Input[float]]:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @base_score.setter
    def base_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "base_score", value)

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> Optional[pulumi.Input['CVSSv3ConfidentialityImpact']]:
        return pulumi.get(self, "confidentiality_impact")

    @confidentiality_impact.setter
    def confidentiality_impact(self, value: Optional[pulumi.Input['CVSSv3ConfidentialityImpact']]):
        pulumi.set(self, "confidentiality_impact", value)

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "exploitability_score")

    @exploitability_score.setter
    def exploitability_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "exploitability_score", value)

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "impact_score")

    @impact_score.setter
    def impact_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "impact_score", value)

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> Optional[pulumi.Input['CVSSv3IntegrityImpact']]:
        return pulumi.get(self, "integrity_impact")

    @integrity_impact.setter
    def integrity_impact(self, value: Optional[pulumi.Input['CVSSv3IntegrityImpact']]):
        pulumi.set(self, "integrity_impact", value)

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> Optional[pulumi.Input['CVSSv3PrivilegesRequired']]:
        return pulumi.get(self, "privileges_required")

    @privileges_required.setter
    def privileges_required(self, value: Optional[pulumi.Input['CVSSv3PrivilegesRequired']]):
        pulumi.set(self, "privileges_required", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['CVSSv3Scope']]:
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['CVSSv3Scope']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> Optional[pulumi.Input['CVSSv3UserInteraction']]:
        return pulumi.get(self, "user_interaction")

    @user_interaction.setter
    def user_interaction(self, value: Optional[pulumi.Input['CVSSv3UserInteraction']]):
        pulumi.set(self, "user_interaction", value)


@pulumi.input_type
class CVSSArgs:
    def __init__(__self__, *,
                 attack_complexity: Optional[pulumi.Input['CVSSAttackComplexity']] = None,
                 attack_vector: Optional[pulumi.Input['CVSSAttackVector']] = None,
                 authentication: Optional[pulumi.Input['CVSSAuthentication']] = None,
                 availability_impact: Optional[pulumi.Input['CVSSAvailabilityImpact']] = None,
                 base_score: Optional[pulumi.Input[float]] = None,
                 confidentiality_impact: Optional[pulumi.Input['CVSSConfidentialityImpact']] = None,
                 exploitability_score: Optional[pulumi.Input[float]] = None,
                 impact_score: Optional[pulumi.Input[float]] = None,
                 integrity_impact: Optional[pulumi.Input['CVSSIntegrityImpact']] = None,
                 privileges_required: Optional[pulumi.Input['CVSSPrivilegesRequired']] = None,
                 scope: Optional[pulumi.Input['CVSSScope']] = None,
                 user_interaction: Optional[pulumi.Input['CVSSUserInteraction']] = None):
        """
        Common Vulnerability Scoring System. For details, see https://www.first.org/cvss/specification-document This is a message we will try to use for storing multiple versions of CVSS. The intention is that as new versions of CVSS scores get added, we will be able to modify this message rather than adding new protos for each new version of the score.
        :param pulumi.Input['CVSSAttackVector'] attack_vector: Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        :param pulumi.Input[float] base_score: The base score is a function of the base metric scores.
        """
        if attack_complexity is not None:
            pulumi.set(__self__, "attack_complexity", attack_complexity)
        if attack_vector is not None:
            pulumi.set(__self__, "attack_vector", attack_vector)
        if authentication is not None:
            pulumi.set(__self__, "authentication", authentication)
        if availability_impact is not None:
            pulumi.set(__self__, "availability_impact", availability_impact)
        if base_score is not None:
            pulumi.set(__self__, "base_score", base_score)
        if confidentiality_impact is not None:
            pulumi.set(__self__, "confidentiality_impact", confidentiality_impact)
        if exploitability_score is not None:
            pulumi.set(__self__, "exploitability_score", exploitability_score)
        if impact_score is not None:
            pulumi.set(__self__, "impact_score", impact_score)
        if integrity_impact is not None:
            pulumi.set(__self__, "integrity_impact", integrity_impact)
        if privileges_required is not None:
            pulumi.set(__self__, "privileges_required", privileges_required)
        if scope is not None:
            pulumi.set(__self__, "scope", scope)
        if user_interaction is not None:
            pulumi.set(__self__, "user_interaction", user_interaction)

    @property
    @pulumi.getter(name="attackComplexity")
    def attack_complexity(self) -> Optional[pulumi.Input['CVSSAttackComplexity']]:
        return pulumi.get(self, "attack_complexity")

    @attack_complexity.setter
    def attack_complexity(self, value: Optional[pulumi.Input['CVSSAttackComplexity']]):
        pulumi.set(self, "attack_complexity", value)

    @property
    @pulumi.getter(name="attackVector")
    def attack_vector(self) -> Optional[pulumi.Input['CVSSAttackVector']]:
        """
        Base Metrics Represents the intrinsic characteristics of a vulnerability that are constant over time and across user environments.
        """
        return pulumi.get(self, "attack_vector")

    @attack_vector.setter
    def attack_vector(self, value: Optional[pulumi.Input['CVSSAttackVector']]):
        pulumi.set(self, "attack_vector", value)

    @property
    @pulumi.getter
    def authentication(self) -> Optional[pulumi.Input['CVSSAuthentication']]:
        return pulumi.get(self, "authentication")

    @authentication.setter
    def authentication(self, value: Optional[pulumi.Input['CVSSAuthentication']]):
        pulumi.set(self, "authentication", value)

    @property
    @pulumi.getter(name="availabilityImpact")
    def availability_impact(self) -> Optional[pulumi.Input['CVSSAvailabilityImpact']]:
        return pulumi.get(self, "availability_impact")

    @availability_impact.setter
    def availability_impact(self, value: Optional[pulumi.Input['CVSSAvailabilityImpact']]):
        pulumi.set(self, "availability_impact", value)

    @property
    @pulumi.getter(name="baseScore")
    def base_score(self) -> Optional[pulumi.Input[float]]:
        """
        The base score is a function of the base metric scores.
        """
        return pulumi.get(self, "base_score")

    @base_score.setter
    def base_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "base_score", value)

    @property
    @pulumi.getter(name="confidentialityImpact")
    def confidentiality_impact(self) -> Optional[pulumi.Input['CVSSConfidentialityImpact']]:
        return pulumi.get(self, "confidentiality_impact")

    @confidentiality_impact.setter
    def confidentiality_impact(self, value: Optional[pulumi.Input['CVSSConfidentialityImpact']]):
        pulumi.set(self, "confidentiality_impact", value)

    @property
    @pulumi.getter(name="exploitabilityScore")
    def exploitability_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "exploitability_score")

    @exploitability_score.setter
    def exploitability_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "exploitability_score", value)

    @property
    @pulumi.getter(name="impactScore")
    def impact_score(self) -> Optional[pulumi.Input[float]]:
        return pulumi.get(self, "impact_score")

    @impact_score.setter
    def impact_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "impact_score", value)

    @property
    @pulumi.getter(name="integrityImpact")
    def integrity_impact(self) -> Optional[pulumi.Input['CVSSIntegrityImpact']]:
        return pulumi.get(self, "integrity_impact")

    @integrity_impact.setter
    def integrity_impact(self, value: Optional[pulumi.Input['CVSSIntegrityImpact']]):
        pulumi.set(self, "integrity_impact", value)

    @property
    @pulumi.getter(name="privilegesRequired")
    def privileges_required(self) -> Optional[pulumi.Input['CVSSPrivilegesRequired']]:
        return pulumi.get(self, "privileges_required")

    @privileges_required.setter
    def privileges_required(self, value: Optional[pulumi.Input['CVSSPrivilegesRequired']]):
        pulumi.set(self, "privileges_required", value)

    @property
    @pulumi.getter
    def scope(self) -> Optional[pulumi.Input['CVSSScope']]:
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: Optional[pulumi.Input['CVSSScope']]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="userInteraction")
    def user_interaction(self) -> Optional[pulumi.Input['CVSSUserInteraction']]:
        return pulumi.get(self, "user_interaction")

    @user_interaction.setter
    def user_interaction(self, value: Optional[pulumi.Input['CVSSUserInteraction']]):
        pulumi.set(self, "user_interaction", value)


@pulumi.input_type
class CategoryArgs:
    def __init__(__self__, *,
                 category_id: Optional[pulumi.Input[str]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        The category to which the update belongs.
        :param pulumi.Input[str] category_id: The identifier of the category.
        :param pulumi.Input[str] name: The localized name of the category.
        """
        if category_id is not None:
            pulumi.set(__self__, "category_id", category_id)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter(name="categoryId")
    def category_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier of the category.
        """
        return pulumi.get(self, "category_id")

    @category_id.setter
    def category_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "category_id", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The localized name of the category.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class CisBenchmarkArgs:
    def __init__(__self__, *,
                 profile_level: Optional[pulumi.Input[int]] = None,
                 severity: Optional[pulumi.Input['CisBenchmarkSeverity']] = None):
        """
        A compliance check that is a CIS benchmark.
        """
        if profile_level is not None:
            pulumi.set(__self__, "profile_level", profile_level)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter(name="profileLevel")
    def profile_level(self) -> Optional[pulumi.Input[int]]:
        return pulumi.get(self, "profile_level")

    @profile_level.setter
    def profile_level(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "profile_level", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input['CisBenchmarkSeverity']]:
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input['CisBenchmarkSeverity']]):
        pulumi.set(self, "severity", value)


@pulumi.input_type
class CloudRepoSourceContextArgs:
    def __init__(__self__, *,
                 alias_context: Optional[pulumi.Input['AliasContextArgs']] = None,
                 repo_id: Optional[pulumi.Input['RepoIdArgs']] = None,
                 revision_id: Optional[pulumi.Input[str]] = None):
        """
        A CloudRepoSourceContext denotes a particular revision in a Google Cloud Source Repo.
        :param pulumi.Input['AliasContextArgs'] alias_context: An alias, which may be a branch or tag.
        :param pulumi.Input['RepoIdArgs'] repo_id: The ID of the repo.
        :param pulumi.Input[str] revision_id: A revision ID.
        """
        if alias_context is not None:
            pulumi.set(__self__, "alias_context", alias_context)
        if repo_id is not None:
            pulumi.set(__self__, "repo_id", repo_id)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> Optional[pulumi.Input['AliasContextArgs']]:
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @alias_context.setter
    def alias_context(self, value: Optional[pulumi.Input['AliasContextArgs']]):
        pulumi.set(self, "alias_context", value)

    @property
    @pulumi.getter(name="repoId")
    def repo_id(self) -> Optional[pulumi.Input['RepoIdArgs']]:
        """
        The ID of the repo.
        """
        return pulumi.get(self, "repo_id")

    @repo_id.setter
    def repo_id(self, value: Optional[pulumi.Input['RepoIdArgs']]):
        pulumi.set(self, "repo_id", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        A revision ID.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)


@pulumi.input_type
class CommandArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 args: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 dir: Optional[pulumi.Input[str]] = None,
                 env: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 id: Optional[pulumi.Input[str]] = None,
                 wait_for: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Command describes a step performed as part of the build pipeline.
        :param pulumi.Input[str] name: Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] args: Command-line arguments used when executing this command.
        :param pulumi.Input[str] dir: Working directory (relative to project source root) used when running this command.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] env: Environment variables set before running this command.
        :param pulumi.Input[str] id: Optional unique identifier for this command, used in wait_for to reference this command as a dependency.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] wait_for: The ID(s) of the command(s) that this command depends on.
        """
        pulumi.set(__self__, "name", name)
        if args is not None:
            pulumi.set(__self__, "args", args)
        if dir is not None:
            pulumi.set(__self__, "dir", dir)
        if env is not None:
            pulumi.set(__self__, "env", env)
        if id is not None:
            pulumi.set(__self__, "id", id)
        if wait_for is not None:
            pulumi.set(__self__, "wait_for", wait_for)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Name of the command, as presented on the command line, or if the command is packaged as a Docker container, as presented to `docker pull`.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def args(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Command-line arguments used when executing this command.
        """
        return pulumi.get(self, "args")

    @args.setter
    def args(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "args", value)

    @property
    @pulumi.getter
    def dir(self) -> Optional[pulumi.Input[str]]:
        """
        Working directory (relative to project source root) used when running this command.
        """
        return pulumi.get(self, "dir")

    @dir.setter
    def dir(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "dir", value)

    @property
    @pulumi.getter
    def env(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Environment variables set before running this command.
        """
        return pulumi.get(self, "env")

    @env.setter
    def env(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "env", value)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        """
        Optional unique identifier for this command, used in wait_for to reference this command as a dependency.
        """
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)

    @property
    @pulumi.getter(name="waitFor")
    def wait_for(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The ID(s) of the command(s) that this command depends on.
        """
        return pulumi.get(self, "wait_for")

    @wait_for.setter
    def wait_for(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "wait_for", value)


@pulumi.input_type
class CompletenessArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[bool]] = None,
                 environment: Optional[pulumi.Input[bool]] = None,
                 materials: Optional[pulumi.Input[bool]] = None):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param pulumi.Input[bool] environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param pulumi.Input[bool] materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "materials", value)


@pulumi.input_type
class ComplianceNoteArgs:
    def __init__(__self__, *,
                 cis_benchmark: Optional[pulumi.Input['CisBenchmarkArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 rationale: Optional[pulumi.Input[str]] = None,
                 remediation: Optional[pulumi.Input[str]] = None,
                 scan_instructions: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]]] = None):
        """
        :param pulumi.Input[str] description: A description about this compliance check.
        :param pulumi.Input[str] rationale: A rationale for the existence of this compliance check.
        :param pulumi.Input[str] remediation: A description of remediation steps if the compliance check fails.
        :param pulumi.Input[str] scan_instructions: Serialized scan instructions with a predefined format.
        :param pulumi.Input[str] title: The title that identifies this compliance check.
        :param pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]] version: The OS and config versions the benchmark applies to.
        """
        if cis_benchmark is not None:
            pulumi.set(__self__, "cis_benchmark", cis_benchmark)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if rationale is not None:
            pulumi.set(__self__, "rationale", rationale)
        if remediation is not None:
            pulumi.set(__self__, "remediation", remediation)
        if scan_instructions is not None:
            pulumi.set(__self__, "scan_instructions", scan_instructions)
        if title is not None:
            pulumi.set(__self__, "title", title)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cisBenchmark")
    def cis_benchmark(self) -> Optional[pulumi.Input['CisBenchmarkArgs']]:
        return pulumi.get(self, "cis_benchmark")

    @cis_benchmark.setter
    def cis_benchmark(self, value: Optional[pulumi.Input['CisBenchmarkArgs']]):
        pulumi.set(self, "cis_benchmark", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A description about this compliance check.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def rationale(self) -> Optional[pulumi.Input[str]]:
        """
        A rationale for the existence of this compliance check.
        """
        return pulumi.get(self, "rationale")

    @rationale.setter
    def rationale(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "rationale", value)

    @property
    @pulumi.getter
    def remediation(self) -> Optional[pulumi.Input[str]]:
        """
        A description of remediation steps if the compliance check fails.
        """
        return pulumi.get(self, "remediation")

    @remediation.setter
    def remediation(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "remediation", value)

    @property
    @pulumi.getter(name="scanInstructions")
    def scan_instructions(self) -> Optional[pulumi.Input[str]]:
        """
        Serialized scan instructions with a predefined format.
        """
        return pulumi.get(self, "scan_instructions")

    @scan_instructions.setter
    def scan_instructions(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scan_instructions", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The title that identifies this compliance check.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]]]:
        """
        The OS and config versions the benchmark applies to.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ComplianceVersionArgs']]]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class ComplianceOccurrenceArgs:
    def __init__(__self__, *,
                 non_compliance_reason: Optional[pulumi.Input[str]] = None,
                 non_compliant_files: Optional[pulumi.Input[Sequence[pulumi.Input['NonCompliantFileArgs']]]] = None):
        """
        An indication that the compliance checks in the associated ComplianceNote were not satisfied for particular resources or a specified reason.
        """
        if non_compliance_reason is not None:
            pulumi.set(__self__, "non_compliance_reason", non_compliance_reason)
        if non_compliant_files is not None:
            pulumi.set(__self__, "non_compliant_files", non_compliant_files)

    @property
    @pulumi.getter(name="nonComplianceReason")
    def non_compliance_reason(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "non_compliance_reason")

    @non_compliance_reason.setter
    def non_compliance_reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "non_compliance_reason", value)

    @property
    @pulumi.getter(name="nonCompliantFiles")
    def non_compliant_files(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['NonCompliantFileArgs']]]]:
        return pulumi.get(self, "non_compliant_files")

    @non_compliant_files.setter
    def non_compliant_files(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['NonCompliantFileArgs']]]]):
        pulumi.set(self, "non_compliant_files", value)


@pulumi.input_type
class ComplianceVersionArgs:
    def __init__(__self__, *,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input[str]] = None):
        """
        Describes the CIS benchmark version that is applicable to a given OS and os version.
        :param pulumi.Input[str] cpe_uri: The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        :param pulumi.Input[str] version: The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The CPE URI (https://cpe.mitre.org/specification/) this benchmark is applicable to.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input[str]]:
        """
        The version of the benchmark. This is set to the version of the OS-specific CIS document the benchmark is defined in.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class DSSEAttestationNoteArgs:
    def __init__(__self__, *,
                 hint: Optional[pulumi.Input['DSSEHintArgs']] = None):
        """
        :param pulumi.Input['DSSEHintArgs'] hint: DSSEHint hints at the purpose of the attestation authority.
        """
        if hint is not None:
            pulumi.set(__self__, "hint", hint)

    @property
    @pulumi.getter
    def hint(self) -> Optional[pulumi.Input['DSSEHintArgs']]:
        """
        DSSEHint hints at the purpose of the attestation authority.
        """
        return pulumi.get(self, "hint")

    @hint.setter
    def hint(self, value: Optional[pulumi.Input['DSSEHintArgs']]):
        pulumi.set(self, "hint", value)


@pulumi.input_type
class DSSEAttestationOccurrenceArgs:
    def __init__(__self__, *,
                 envelope: Optional[pulumi.Input['EnvelopeArgs']] = None,
                 statement: Optional[pulumi.Input['InTotoStatementArgs']] = None):
        """
        Deprecated. Prefer to use a regular Occurrence, and populate the Envelope at the top level of the Occurrence.
        :param pulumi.Input['EnvelopeArgs'] envelope: If doing something security critical, make sure to verify the signatures in this metadata.
        """
        if envelope is not None:
            pulumi.set(__self__, "envelope", envelope)
        if statement is not None:
            pulumi.set(__self__, "statement", statement)

    @property
    @pulumi.getter
    def envelope(self) -> Optional[pulumi.Input['EnvelopeArgs']]:
        """
        If doing something security critical, make sure to verify the signatures in this metadata.
        """
        return pulumi.get(self, "envelope")

    @envelope.setter
    def envelope(self, value: Optional[pulumi.Input['EnvelopeArgs']]):
        pulumi.set(self, "envelope", value)

    @property
    @pulumi.getter
    def statement(self) -> Optional[pulumi.Input['InTotoStatementArgs']]:
        return pulumi.get(self, "statement")

    @statement.setter
    def statement(self, value: Optional[pulumi.Input['InTotoStatementArgs']]):
        pulumi.set(self, "statement", value)


@pulumi.input_type
class DSSEHintArgs:
    def __init__(__self__, *,
                 human_readable_name: pulumi.Input[str]):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param pulumi.Input[str] human_readable_name: The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> pulumi.Input[str]:
        """
        The human readable name of this attestation authority, for example "cloudbuild-prod".
        """
        return pulumi.get(self, "human_readable_name")

    @human_readable_name.setter
    def human_readable_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "human_readable_name", value)


@pulumi.input_type
class DeploymentNoteArgs:
    def __init__(__self__, *,
                 resource_uri: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        An artifact that can be deployed in some runtime.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] resource_uri: Resource URI for the artifact being deployed.
        """
        pulumi.set(__self__, "resource_uri", resource_uri)

    @property
    @pulumi.getter(name="resourceUri")
    def resource_uri(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        Resource URI for the artifact being deployed.
        """
        return pulumi.get(self, "resource_uri")

    @resource_uri.setter
    def resource_uri(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "resource_uri", value)


@pulumi.input_type
class DeploymentOccurrenceArgs:
    def __init__(__self__, *,
                 deploy_time: pulumi.Input[str],
                 address: Optional[pulumi.Input[str]] = None,
                 config: Optional[pulumi.Input[str]] = None,
                 platform: Optional[pulumi.Input['DeploymentOccurrencePlatform']] = None,
                 undeploy_time: Optional[pulumi.Input[str]] = None,
                 user_email: Optional[pulumi.Input[str]] = None):
        """
        The period during which some deployable was active in a runtime.
        :param pulumi.Input[str] deploy_time: Beginning of the lifetime of this deployment.
        :param pulumi.Input[str] address: Address of the runtime element hosting this deployment.
        :param pulumi.Input[str] config: Configuration used to create this deployment.
        :param pulumi.Input['DeploymentOccurrencePlatform'] platform: Platform hosting this deployment.
        :param pulumi.Input[str] undeploy_time: End of the lifetime of this deployment.
        :param pulumi.Input[str] user_email: Identity of the user that triggered this deployment.
        """
        pulumi.set(__self__, "deploy_time", deploy_time)
        if address is not None:
            pulumi.set(__self__, "address", address)
        if config is not None:
            pulumi.set(__self__, "config", config)
        if platform is not None:
            pulumi.set(__self__, "platform", platform)
        if undeploy_time is not None:
            pulumi.set(__self__, "undeploy_time", undeploy_time)
        if user_email is not None:
            pulumi.set(__self__, "user_email", user_email)

    @property
    @pulumi.getter(name="deployTime")
    def deploy_time(self) -> pulumi.Input[str]:
        """
        Beginning of the lifetime of this deployment.
        """
        return pulumi.get(self, "deploy_time")

    @deploy_time.setter
    def deploy_time(self, value: pulumi.Input[str]):
        pulumi.set(self, "deploy_time", value)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        Address of the runtime element hosting this deployment.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[str]]:
        """
        Configuration used to create this deployment.
        """
        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter
    def platform(self) -> Optional[pulumi.Input['DeploymentOccurrencePlatform']]:
        """
        Platform hosting this deployment.
        """
        return pulumi.get(self, "platform")

    @platform.setter
    def platform(self, value: Optional[pulumi.Input['DeploymentOccurrencePlatform']]):
        pulumi.set(self, "platform", value)

    @property
    @pulumi.getter(name="undeployTime")
    def undeploy_time(self) -> Optional[pulumi.Input[str]]:
        """
        End of the lifetime of this deployment.
        """
        return pulumi.get(self, "undeploy_time")

    @undeploy_time.setter
    def undeploy_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "undeploy_time", value)

    @property
    @pulumi.getter(name="userEmail")
    def user_email(self) -> Optional[pulumi.Input[str]]:
        """
        Identity of the user that triggered this deployment.
        """
        return pulumi.get(self, "user_email")

    @user_email.setter
    def user_email(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "user_email", value)


@pulumi.input_type
class DetailArgs:
    def __init__(__self__, *,
                 affected_cpe_uri: pulumi.Input[str],
                 affected_package: pulumi.Input[str],
                 affected_version_end: Optional[pulumi.Input['VersionArgs']] = None,
                 affected_version_start: Optional[pulumi.Input['VersionArgs']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 fixed_cpe_uri: Optional[pulumi.Input[str]] = None,
                 fixed_package: Optional[pulumi.Input[str]] = None,
                 fixed_version: Optional[pulumi.Input['VersionArgs']] = None,
                 is_obsolete: Optional[pulumi.Input[bool]] = None,
                 package_type: Optional[pulumi.Input[str]] = None,
                 severity_name: Optional[pulumi.Input[str]] = None,
                 source: Optional[pulumi.Input[str]] = None,
                 source_update_time: Optional[pulumi.Input[str]] = None,
                 vendor: Optional[pulumi.Input[str]] = None):
        """
        A detail for a distro and package affected by this vulnerability and its associated fix (if one is available).
        :param pulumi.Input[str] affected_cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        :param pulumi.Input[str] affected_package: The package this vulnerability affects.
        :param pulumi.Input['VersionArgs'] affected_version_end: The version number at the end of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        :param pulumi.Input['VersionArgs'] affected_version_start: The version number at the start of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        :param pulumi.Input[str] description: A vendor-specific description of this vulnerability.
        :param pulumi.Input[str] fixed_cpe_uri: The distro recommended [CPE URI](https://cpe.mitre.org/specification/) to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_cpe_uri.
        :param pulumi.Input[str] fixed_package: The distro recommended package to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_package.
        :param pulumi.Input['VersionArgs'] fixed_version: The distro recommended version to update to that contains a fix for this vulnerability. Setting this to VersionKind.MAXIMUM means no such version is yet available.
        :param pulumi.Input[bool] is_obsolete: Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        :param pulumi.Input[str] package_type: The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        :param pulumi.Input[str] severity_name: The distro assigned severity of this vulnerability.
        :param pulumi.Input[str] source: The source from which the information in this Detail was obtained.
        :param pulumi.Input[str] source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param pulumi.Input[str] vendor: The name of the vendor of the product.
        """
        pulumi.set(__self__, "affected_cpe_uri", affected_cpe_uri)
        pulumi.set(__self__, "affected_package", affected_package)
        if affected_version_end is not None:
            pulumi.set(__self__, "affected_version_end", affected_version_end)
        if affected_version_start is not None:
            pulumi.set(__self__, "affected_version_start", affected_version_start)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if fixed_cpe_uri is not None:
            pulumi.set(__self__, "fixed_cpe_uri", fixed_cpe_uri)
        if fixed_package is not None:
            pulumi.set(__self__, "fixed_package", fixed_package)
        if fixed_version is not None:
            pulumi.set(__self__, "fixed_version", fixed_version)
        if is_obsolete is not None:
            pulumi.set(__self__, "is_obsolete", is_obsolete)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)
        if severity_name is not None:
            pulumi.set(__self__, "severity_name", severity_name)
        if source is not None:
            pulumi.set(__self__, "source", source)
        if source_update_time is not None:
            pulumi.set(__self__, "source_update_time", source_update_time)
        if vendor is not None:
            pulumi.set(__self__, "vendor", vendor)

    @property
    @pulumi.getter(name="affectedCpeUri")
    def affected_cpe_uri(self) -> pulumi.Input[str]:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        """
        return pulumi.get(self, "affected_cpe_uri")

    @affected_cpe_uri.setter
    def affected_cpe_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "affected_cpe_uri", value)

    @property
    @pulumi.getter(name="affectedPackage")
    def affected_package(self) -> pulumi.Input[str]:
        """
        The package this vulnerability affects.
        """
        return pulumi.get(self, "affected_package")

    @affected_package.setter
    def affected_package(self, value: pulumi.Input[str]):
        pulumi.set(self, "affected_package", value)

    @property
    @pulumi.getter(name="affectedVersionEnd")
    def affected_version_end(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The version number at the end of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        """
        return pulumi.get(self, "affected_version_end")

    @affected_version_end.setter
    def affected_version_end(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "affected_version_end", value)

    @property
    @pulumi.getter(name="affectedVersionStart")
    def affected_version_start(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The version number at the start of an interval in which this vulnerability exists. A vulnerability can affect a package between version numbers that are disjoint sets of intervals (example: [1.0.0-1.1.0], [2.4.6-2.4.8] and [4.5.6-4.6.8]) each of which will be represented in its own Detail. If a specific affected version is provided by a vulnerability database, affected_version_start and affected_version_end will be the same in that Detail.
        """
        return pulumi.get(self, "affected_version_start")

    @affected_version_start.setter
    def affected_version_start(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "affected_version_start", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        A vendor-specific description of this vulnerability.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="fixedCpeUri")
    def fixed_cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The distro recommended [CPE URI](https://cpe.mitre.org/specification/) to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_cpe_uri.
        """
        return pulumi.get(self, "fixed_cpe_uri")

    @fixed_cpe_uri.setter
    def fixed_cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_cpe_uri", value)

    @property
    @pulumi.getter(name="fixedPackage")
    def fixed_package(self) -> Optional[pulumi.Input[str]]:
        """
        The distro recommended package to update to that contains a fix for this vulnerability. It is possible for this to be different from the affected_package.
        """
        return pulumi.get(self, "fixed_package")

    @fixed_package.setter
    def fixed_package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_package", value)

    @property
    @pulumi.getter(name="fixedVersion")
    def fixed_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The distro recommended version to update to that contains a fix for this vulnerability. Setting this to VersionKind.MAXIMUM means no such version is yet available.
        """
        return pulumi.get(self, "fixed_version")

    @fixed_version.setter
    def fixed_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "fixed_version", value)

    @property
    @pulumi.getter(name="isObsolete")
    def is_obsolete(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this detail is obsolete. Occurrences are expected not to point to obsolete details.
        """
        return pulumi.get(self, "is_obsolete")

    @is_obsolete.setter
    def is_obsolete(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "is_obsolete", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)

    @property
    @pulumi.getter(name="severityName")
    def severity_name(self) -> Optional[pulumi.Input[str]]:
        """
        The distro assigned severity of this vulnerability.
        """
        return pulumi.get(self, "severity_name")

    @severity_name.setter
    def severity_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity_name", value)

    @property
    @pulumi.getter
    def source(self) -> Optional[pulumi.Input[str]]:
        """
        The source from which the information in this Detail was obtained.
        """
        return pulumi.get(self, "source")

    @source.setter
    def source(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source", value)

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @source_update_time.setter
    def source_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_update_time", value)

    @property
    @pulumi.getter
    def vendor(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the vendor of the product.
        """
        return pulumi.get(self, "vendor")

    @vendor.setter
    def vendor(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "vendor", value)


@pulumi.input_type
class DiscoveryNoteArgs:
    def __init__(__self__, *,
                 analysis_kind: pulumi.Input['DiscoveryNoteAnalysisKind']):
        """
        A note that indicates a type of analysis a provider would perform. This note exists in a provider's project. A `Discovery` occurrence is created in a consumer's project at the start of analysis.
        :param pulumi.Input['DiscoveryNoteAnalysisKind'] analysis_kind: Immutable. The kind of analysis that is handled by this discovery.
        """
        pulumi.set(__self__, "analysis_kind", analysis_kind)

    @property
    @pulumi.getter(name="analysisKind")
    def analysis_kind(self) -> pulumi.Input['DiscoveryNoteAnalysisKind']:
        """
        Immutable. The kind of analysis that is handled by this discovery.
        """
        return pulumi.get(self, "analysis_kind")

    @analysis_kind.setter
    def analysis_kind(self, value: pulumi.Input['DiscoveryNoteAnalysisKind']):
        pulumi.set(self, "analysis_kind", value)


@pulumi.input_type
class DiscoveryOccurrenceArgs:
    def __init__(__self__, *,
                 analysis_status: Optional[pulumi.Input['DiscoveryOccurrenceAnalysisStatus']] = None,
                 analysis_status_error: Optional[pulumi.Input['StatusArgs']] = None,
                 continuous_analysis: Optional[pulumi.Input['DiscoveryOccurrenceContinuousAnalysis']] = None,
                 cpe: Optional[pulumi.Input[str]] = None,
                 last_scan_time: Optional[pulumi.Input[str]] = None):
        """
        Provides information about the analysis status of a discovered resource.
        :param pulumi.Input['DiscoveryOccurrenceAnalysisStatus'] analysis_status: The status of discovery for the resource.
        :param pulumi.Input['StatusArgs'] analysis_status_error: When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        :param pulumi.Input['DiscoveryOccurrenceContinuousAnalysis'] continuous_analysis: Whether the resource is continuously analyzed.
        :param pulumi.Input[str] cpe: The CPE of the resource being scanned.
        :param pulumi.Input[str] last_scan_time: The last time this resource was scanned.
        """
        if analysis_status is not None:
            pulumi.set(__self__, "analysis_status", analysis_status)
        if analysis_status_error is not None:
            pulumi.set(__self__, "analysis_status_error", analysis_status_error)
        if continuous_analysis is not None:
            pulumi.set(__self__, "continuous_analysis", continuous_analysis)
        if cpe is not None:
            pulumi.set(__self__, "cpe", cpe)
        if last_scan_time is not None:
            pulumi.set(__self__, "last_scan_time", last_scan_time)

    @property
    @pulumi.getter(name="analysisStatus")
    def analysis_status(self) -> Optional[pulumi.Input['DiscoveryOccurrenceAnalysisStatus']]:
        """
        The status of discovery for the resource.
        """
        return pulumi.get(self, "analysis_status")

    @analysis_status.setter
    def analysis_status(self, value: Optional[pulumi.Input['DiscoveryOccurrenceAnalysisStatus']]):
        pulumi.set(self, "analysis_status", value)

    @property
    @pulumi.getter(name="analysisStatusError")
    def analysis_status_error(self) -> Optional[pulumi.Input['StatusArgs']]:
        """
        When an error is encountered this will contain a LocalizedMessage under details to show to the user. The LocalizedMessage is output only and populated by the API.
        """
        return pulumi.get(self, "analysis_status_error")

    @analysis_status_error.setter
    def analysis_status_error(self, value: Optional[pulumi.Input['StatusArgs']]):
        pulumi.set(self, "analysis_status_error", value)

    @property
    @pulumi.getter(name="continuousAnalysis")
    def continuous_analysis(self) -> Optional[pulumi.Input['DiscoveryOccurrenceContinuousAnalysis']]:
        """
        Whether the resource is continuously analyzed.
        """
        return pulumi.get(self, "continuous_analysis")

    @continuous_analysis.setter
    def continuous_analysis(self, value: Optional[pulumi.Input['DiscoveryOccurrenceContinuousAnalysis']]):
        pulumi.set(self, "continuous_analysis", value)

    @property
    @pulumi.getter
    def cpe(self) -> Optional[pulumi.Input[str]]:
        """
        The CPE of the resource being scanned.
        """
        return pulumi.get(self, "cpe")

    @cpe.setter
    def cpe(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe", value)

    @property
    @pulumi.getter(name="lastScanTime")
    def last_scan_time(self) -> Optional[pulumi.Input[str]]:
        """
        The last time this resource was scanned.
        """
        return pulumi.get(self, "last_scan_time")

    @last_scan_time.setter
    def last_scan_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_scan_time", value)


@pulumi.input_type
class DistributionArgs:
    def __init__(__self__, *,
                 cpe_uri: pulumi.Input[str],
                 architecture: Optional[pulumi.Input['DistributionArchitecture']] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 latest_version: Optional[pulumi.Input['VersionArgs']] = None,
                 maintainer: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        This represents a particular channel of distribution for a given package. E.g., Debian's jessie-backports dpkg mirror.
        :param pulumi.Input[str] cpe_uri: The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param pulumi.Input['DistributionArchitecture'] architecture: The CPU architecture for which packages in this distribution channel were built.
        :param pulumi.Input[str] description: The distribution channel-specific description of this package.
        :param pulumi.Input['VersionArgs'] latest_version: The latest available version of this package in this distribution channel.
        :param pulumi.Input[str] maintainer: A freeform string denoting the maintainer of this package.
        :param pulumi.Input[str] url: The distribution channel-specific homepage for this package.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        if architecture is not None:
            pulumi.set(__self__, "architecture", architecture)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if latest_version is not None:
            pulumi.set(__self__, "latest_version", latest_version)
        if maintainer is not None:
            pulumi.set(__self__, "maintainer", maintainer)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> pulumi.Input[str]:
        """
        The cpe_uri in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def architecture(self) -> Optional[pulumi.Input['DistributionArchitecture']]:
        """
        The CPU architecture for which packages in this distribution channel were built.
        """
        return pulumi.get(self, "architecture")

    @architecture.setter
    def architecture(self, value: Optional[pulumi.Input['DistributionArchitecture']]):
        pulumi.set(self, "architecture", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The distribution channel-specific description of this package.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter(name="latestVersion")
    def latest_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The latest available version of this package in this distribution channel.
        """
        return pulumi.get(self, "latest_version")

    @latest_version.setter
    def latest_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "latest_version", value)

    @property
    @pulumi.getter
    def maintainer(self) -> Optional[pulumi.Input[str]]:
        """
        A freeform string denoting the maintainer of this package.
        """
        return pulumi.get(self, "maintainer")

    @maintainer.setter
    def maintainer(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "maintainer", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        The distribution channel-specific homepage for this package.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class EnvelopeSignatureArgs:
    def __init__(__self__, *,
                 keyid: Optional[pulumi.Input[str]] = None,
                 sig: Optional[pulumi.Input[str]] = None):
        if keyid is not None:
            pulumi.set(__self__, "keyid", keyid)
        if sig is not None:
            pulumi.set(__self__, "sig", sig)

    @property
    @pulumi.getter
    def keyid(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "keyid")

    @keyid.setter
    def keyid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "keyid", value)

    @property
    @pulumi.getter
    def sig(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "sig")

    @sig.setter
    def sig(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "sig", value)


@pulumi.input_type
class EnvelopeArgs:
    def __init__(__self__, *,
                 payload: Optional[pulumi.Input[str]] = None,
                 payload_type: Optional[pulumi.Input[str]] = None,
                 signatures: Optional[pulumi.Input[Sequence[pulumi.Input['EnvelopeSignatureArgs']]]] = None):
        """
        MUST match https://github.com/secure-systems-lab/dsse/blob/master/envelope.proto. An authenticated message of arbitrary type.
        """
        if payload is not None:
            pulumi.set(__self__, "payload", payload)
        if payload_type is not None:
            pulumi.set(__self__, "payload_type", payload_type)
        if signatures is not None:
            pulumi.set(__self__, "signatures", signatures)

    @property
    @pulumi.getter
    def payload(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "payload")

    @payload.setter
    def payload(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload", value)

    @property
    @pulumi.getter(name="payloadType")
    def payload_type(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "payload_type")

    @payload_type.setter
    def payload_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "payload_type", value)

    @property
    @pulumi.getter
    def signatures(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['EnvelopeSignatureArgs']]]]:
        return pulumi.get(self, "signatures")

    @signatures.setter
    def signatures(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['EnvelopeSignatureArgs']]]]):
        pulumi.set(self, "signatures", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FingerprintArgs:
    def __init__(__self__, *,
                 v1_name: pulumi.Input[str],
                 v2_blob: pulumi.Input[Sequence[pulumi.Input[str]]]):
        """
        A set of properties that uniquely identify a given Docker image.
        :param pulumi.Input[str] v1_name: The layer ID of the final layer in the Docker image's v1 representation.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] v2_blob: The ordered list of v2 blobs that represent a given image.
        """
        pulumi.set(__self__, "v1_name", v1_name)
        pulumi.set(__self__, "v2_blob", v2_blob)

    @property
    @pulumi.getter(name="v1Name")
    def v1_name(self) -> pulumi.Input[str]:
        """
        The layer ID of the final layer in the Docker image's v1 representation.
        """
        return pulumi.get(self, "v1_name")

    @v1_name.setter
    def v1_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "v1_name", value)

    @property
    @pulumi.getter(name="v2Blob")
    def v2_blob(self) -> pulumi.Input[Sequence[pulumi.Input[str]]]:
        """
        The ordered list of v2 blobs that represent a given image.
        """
        return pulumi.get(self, "v2_blob")

    @v2_blob.setter
    def v2_blob(self, value: pulumi.Input[Sequence[pulumi.Input[str]]]):
        pulumi.set(self, "v2_blob", value)


@pulumi.input_type
class GerritSourceContextArgs:
    def __init__(__self__, *,
                 alias_context: Optional[pulumi.Input['AliasContextArgs']] = None,
                 gerrit_project: Optional[pulumi.Input[str]] = None,
                 host_uri: Optional[pulumi.Input[str]] = None,
                 revision_id: Optional[pulumi.Input[str]] = None):
        """
        A SourceContext referring to a Gerrit project.
        :param pulumi.Input['AliasContextArgs'] alias_context: An alias, which may be a branch or tag.
        :param pulumi.Input[str] gerrit_project: The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        :param pulumi.Input[str] host_uri: The URI of a running Gerrit instance.
        :param pulumi.Input[str] revision_id: A revision (commit) ID.
        """
        if alias_context is not None:
            pulumi.set(__self__, "alias_context", alias_context)
        if gerrit_project is not None:
            pulumi.set(__self__, "gerrit_project", gerrit_project)
        if host_uri is not None:
            pulumi.set(__self__, "host_uri", host_uri)
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)

    @property
    @pulumi.getter(name="aliasContext")
    def alias_context(self) -> Optional[pulumi.Input['AliasContextArgs']]:
        """
        An alias, which may be a branch or tag.
        """
        return pulumi.get(self, "alias_context")

    @alias_context.setter
    def alias_context(self, value: Optional[pulumi.Input['AliasContextArgs']]):
        pulumi.set(self, "alias_context", value)

    @property
    @pulumi.getter(name="gerritProject")
    def gerrit_project(self) -> Optional[pulumi.Input[str]]:
        """
        The full project name within the host. Projects may be nested, so "project/subproject" is a valid project name. The "repo name" is the hostURI/project.
        """
        return pulumi.get(self, "gerrit_project")

    @gerrit_project.setter
    def gerrit_project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "gerrit_project", value)

    @property
    @pulumi.getter(name="hostUri")
    def host_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The URI of a running Gerrit instance.
        """
        return pulumi.get(self, "host_uri")

    @host_uri.setter
    def host_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "host_uri", value)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        A revision (commit) ID.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)


@pulumi.input_type
class GitSourceContextArgs:
    def __init__(__self__, *,
                 revision_id: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        A GitSourceContext denotes a particular revision in a third party Git repository (e.g., GitHub).
        :param pulumi.Input[str] revision_id: Git commit hash.
        :param pulumi.Input[str] url: Git repository URL.
        """
        if revision_id is not None:
            pulumi.set(__self__, "revision_id", revision_id)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter(name="revisionId")
    def revision_id(self) -> Optional[pulumi.Input[str]]:
        """
        Git commit hash.
        """
        return pulumi.get(self, "revision_id")

    @revision_id.setter
    def revision_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision_id", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Git repository URL.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class HintArgs:
    def __init__(__self__, *,
                 human_readable_name: pulumi.Input[str]):
        """
        This submessage provides human-readable hints about the purpose of the authority. Because the name of a note acts as its resource reference, it is important to disambiguate the canonical name of the Note (which might be a UUID for security purposes) from "readable" names more suitable for debug output. Note that these hints should not be used to look up authorities in security sensitive contexts, such as when looking up attestations to verify.
        :param pulumi.Input[str] human_readable_name: The human readable name of this attestation authority, for example "qa".
        """
        pulumi.set(__self__, "human_readable_name", human_readable_name)

    @property
    @pulumi.getter(name="humanReadableName")
    def human_readable_name(self) -> pulumi.Input[str]:
        """
        The human readable name of this attestation authority, for example "qa".
        """
        return pulumi.get(self, "human_readable_name")

    @human_readable_name.setter
    def human_readable_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "human_readable_name", value)


@pulumi.input_type
class IdentityArgs:
    def __init__(__self__, *,
                 revision: Optional[pulumi.Input[int]] = None,
                 update_id: Optional[pulumi.Input[str]] = None):
        """
        The unique identifier of the update.
        :param pulumi.Input[int] revision: The revision number of the update.
        :param pulumi.Input[str] update_id: The revision independent identifier of the update.
        """
        if revision is not None:
            pulumi.set(__self__, "revision", revision)
        if update_id is not None:
            pulumi.set(__self__, "update_id", update_id)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[int]]:
        """
        The revision number of the update.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "revision", value)

    @property
    @pulumi.getter(name="updateId")
    def update_id(self) -> Optional[pulumi.Input[str]]:
        """
        The revision independent identifier of the update.
        """
        return pulumi.get(self, "update_id")

    @update_id.setter
    def update_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "update_id", value)


@pulumi.input_type
class ImageNoteArgs:
    def __init__(__self__, *,
                 fingerprint: pulumi.Input['FingerprintArgs'],
                 resource_url: pulumi.Input[str]):
        """
        Basis describes the base image portion (Note) of the DockerImage relationship. Linked occurrences are derived from this or an equivalent image via: FROM Or an equivalent reference, e.g., a tag of the resource_url.
        :param pulumi.Input['FingerprintArgs'] fingerprint: Immutable. The fingerprint of the base image.
        :param pulumi.Input[str] resource_url: Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        pulumi.set(__self__, "resource_url", resource_url)

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Input['FingerprintArgs']:
        """
        Immutable. The fingerprint of the base image.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: pulumi.Input['FingerprintArgs']):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="resourceUrl")
    def resource_url(self) -> pulumi.Input[str]:
        """
        Immutable. The resource_url for the resource representing the basis of associated occurrence images.
        """
        return pulumi.get(self, "resource_url")

    @resource_url.setter
    def resource_url(self, value: pulumi.Input[str]):
        pulumi.set(self, "resource_url", value)


@pulumi.input_type
class ImageOccurrenceArgs:
    def __init__(__self__, *,
                 fingerprint: pulumi.Input['FingerprintArgs'],
                 layer_info: Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]] = None):
        """
        Details of the derived image portion of the DockerImage relationship. This image would be produced from a Dockerfile with FROM .
        :param pulumi.Input['FingerprintArgs'] fingerprint: The fingerprint of the derived image.
        :param pulumi.Input[Sequence[pulumi.Input['LayerArgs']]] layer_info: This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        pulumi.set(__self__, "fingerprint", fingerprint)
        if layer_info is not None:
            pulumi.set(__self__, "layer_info", layer_info)

    @property
    @pulumi.getter
    def fingerprint(self) -> pulumi.Input['FingerprintArgs']:
        """
        The fingerprint of the derived image.
        """
        return pulumi.get(self, "fingerprint")

    @fingerprint.setter
    def fingerprint(self, value: pulumi.Input['FingerprintArgs']):
        pulumi.set(self, "fingerprint", value)

    @property
    @pulumi.getter(name="layerInfo")
    def layer_info(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]]:
        """
        This contains layer-specific metadata, if populated it has length "distance" and is ordered with [distance] being the layer immediately following the base image and [1] being the final layer.
        """
        return pulumi.get(self, "layer_info")

    @layer_info.setter
    def layer_info(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['LayerArgs']]]]):
        pulumi.set(self, "layer_info", value)


@pulumi.input_type
class InTotoProvenanceArgs:
    def __init__(__self__, *,
                 builder_config: Optional[pulumi.Input['BuilderConfigArgs']] = None,
                 materials: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 metadata: Optional[pulumi.Input['MetadataArgs']] = None,
                 recipe: Optional[pulumi.Input['RecipeArgs']] = None):
        """
        :param pulumi.Input['BuilderConfigArgs'] builder_config: required
        :param pulumi.Input[Sequence[pulumi.Input[str]]] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param pulumi.Input['RecipeArgs'] recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        if builder_config is not None:
            pulumi.set(__self__, "builder_config", builder_config)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if recipe is not None:
            pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter(name="builderConfig")
    def builder_config(self) -> Optional[pulumi.Input['BuilderConfigArgs']]:
        """
        required
        """
        return pulumi.get(self, "builder_config")

    @builder_config.setter
    def builder_config(self, value: Optional[pulumi.Input['BuilderConfigArgs']]):
        pulumi.set(self, "builder_config", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "materials", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['MetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['MetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def recipe(self) -> Optional[pulumi.Input['RecipeArgs']]:
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        return pulumi.get(self, "recipe")

    @recipe.setter
    def recipe(self, value: Optional[pulumi.Input['RecipeArgs']]):
        pulumi.set(self, "recipe", value)


@pulumi.input_type
class InTotoStatementArgs:
    def __init__(__self__, *,
                 predicate_type: Optional[pulumi.Input[str]] = None,
                 provenance: Optional[pulumi.Input['InTotoProvenanceArgs']] = None,
                 slsa_provenance: Optional[pulumi.Input['SlsaProvenanceArgs']] = None,
                 subject: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Spec defined at https://github.com/in-toto/attestation/tree/main/spec#statement The serialized InTotoStatement will be stored as Envelope.payload. Envelope.payloadType is always "application/vnd.in-toto+json".
        :param pulumi.Input[str] predicate_type: "https://slsa.dev/provenance/v0.1" for SlsaProvenance.
        :param pulumi.Input[str] type: Always "https://in-toto.io/Statement/v0.1".
        """
        if predicate_type is not None:
            pulumi.set(__self__, "predicate_type", predicate_type)
        if provenance is not None:
            pulumi.set(__self__, "provenance", provenance)
        if slsa_provenance is not None:
            pulumi.set(__self__, "slsa_provenance", slsa_provenance)
        if subject is not None:
            pulumi.set(__self__, "subject", subject)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="predicateType")
    def predicate_type(self) -> Optional[pulumi.Input[str]]:
        """
        "https://slsa.dev/provenance/v0.1" for SlsaProvenance.
        """
        return pulumi.get(self, "predicate_type")

    @predicate_type.setter
    def predicate_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "predicate_type", value)

    @property
    @pulumi.getter
    def provenance(self) -> Optional[pulumi.Input['InTotoProvenanceArgs']]:
        return pulumi.get(self, "provenance")

    @provenance.setter
    def provenance(self, value: Optional[pulumi.Input['InTotoProvenanceArgs']]):
        pulumi.set(self, "provenance", value)

    @property
    @pulumi.getter(name="slsaProvenance")
    def slsa_provenance(self) -> Optional[pulumi.Input['SlsaProvenanceArgs']]:
        return pulumi.get(self, "slsa_provenance")

    @slsa_provenance.setter
    def slsa_provenance(self, value: Optional[pulumi.Input['SlsaProvenanceArgs']]):
        pulumi.set(self, "slsa_provenance", value)

    @property
    @pulumi.getter
    def subject(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]]:
        return pulumi.get(self, "subject")

    @subject.setter
    def subject(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SubjectArgs']]]]):
        pulumi.set(self, "subject", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        Always "https://in-toto.io/Statement/v0.1".
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class JwtArgs:
    def __init__(__self__, *,
                 compact_jwt: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] compact_jwt: The compact encoding of a JWS, which is always three base64 encoded strings joined by periods. For details, see: https://tools.ietf.org/html/rfc7515.html#section-3.1
        """
        if compact_jwt is not None:
            pulumi.set(__self__, "compact_jwt", compact_jwt)

    @property
    @pulumi.getter(name="compactJwt")
    def compact_jwt(self) -> Optional[pulumi.Input[str]]:
        """
        The compact encoding of a JWS, which is always three base64 encoded strings joined by periods. For details, see: https://tools.ietf.org/html/rfc7515.html#section-3.1
        """
        return pulumi.get(self, "compact_jwt")

    @compact_jwt.setter
    def compact_jwt(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "compact_jwt", value)


@pulumi.input_type
class KnowledgeBaseArgs:
    def __init__(__self__, *,
                 name: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] name: The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
        :param pulumi.Input[str] url: A link to the KB in the [Windows update catalog] (https://www.catalog.update.microsoft.com/).
        """
        if name is not None:
            pulumi.set(__self__, "name", name)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        The KB name (generally of the form KB[0-9]+ (e.g., KB123456)).
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        A link to the KB in the [Windows update catalog] (https://www.catalog.update.microsoft.com/).
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class LayerArgs:
    def __init__(__self__, *,
                 directive: pulumi.Input[str],
                 arguments: Optional[pulumi.Input[str]] = None):
        """
        Layer holds metadata specific to a layer of a Docker image.
        :param pulumi.Input[str] directive: The recovered Dockerfile directive used to construct this layer. See https://docs.docker.com/engine/reference/builder/ for more information.
        :param pulumi.Input[str] arguments: The recovered arguments to the Dockerfile directive.
        """
        pulumi.set(__self__, "directive", directive)
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)

    @property
    @pulumi.getter
    def directive(self) -> pulumi.Input[str]:
        """
        The recovered Dockerfile directive used to construct this layer. See https://docs.docker.com/engine/reference/builder/ for more information.
        """
        return pulumi.get(self, "directive")

    @directive.setter
    def directive(self, value: pulumi.Input[str]):
        pulumi.set(self, "directive", value)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[str]]:
        """
        The recovered arguments to the Dockerfile directive.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "arguments", value)


@pulumi.input_type
class LocationArgs:
    def __init__(__self__, *,
                 cpe_uri: pulumi.Input[str],
                 path: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['VersionArgs']] = None):
        """
        An occurrence of a particular package installation found within a system's filesystem. E.g., glibc was found in `/var/lib/dpkg/status`.
        :param pulumi.Input[str] cpe_uri: The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        :param pulumi.Input[str] path: The path from which we gathered that this package/version is installed.
        :param pulumi.Input['VersionArgs'] version: The version installed at this location.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if version is not None:
            pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> pulumi.Input[str]:
        """
        The CPE URI in [CPE format](https://cpe.mitre.org/specification/) denoting the package manager version distributing a package.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        The path from which we gathered that this package/version is installed.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        The version installed at this location.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "version", value)


@pulumi.input_type
class MaterialArgs:
    def __init__(__self__, *,
                 digest: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 uri: Optional[pulumi.Input[str]] = None):
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if uri is not None:
            pulumi.set(__self__, "uri", uri)

    @property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "digest", value)

    @property
    @pulumi.getter
    def uri(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "uri")

    @uri.setter
    def uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uri", value)


@pulumi.input_type
class MetadataArgs:
    def __init__(__self__, *,
                 build_finished_on: Optional[pulumi.Input[str]] = None,
                 build_invocation_id: Optional[pulumi.Input[str]] = None,
                 build_started_on: Optional[pulumi.Input[str]] = None,
                 completeness: Optional[pulumi.Input['CompletenessArgs']] = None,
                 reproducible: Optional[pulumi.Input[bool]] = None):
        """
        Other properties of the build.
        :param pulumi.Input[str] build_finished_on: The timestamp of when the build completed.
        :param pulumi.Input[str] build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param pulumi.Input[str] build_started_on: The timestamp of when the build started.
        :param pulumi.Input['CompletenessArgs'] completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        if build_finished_on is not None:
            pulumi.set(__self__, "build_finished_on", build_finished_on)
        if build_invocation_id is not None:
            pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        if build_started_on is not None:
            pulumi.set(__self__, "build_started_on", build_started_on)
        if completeness is not None:
            pulumi.set(__self__, "completeness", completeness)
        if reproducible is not None:
            pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @build_finished_on.setter
    def build_finished_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_finished_on", value)

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @build_invocation_id.setter
    def build_invocation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_invocation_id", value)

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @build_started_on.setter
    def build_started_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_started_on", value)

    @property
    @pulumi.getter
    def completeness(self) -> Optional[pulumi.Input['CompletenessArgs']]:
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @completeness.setter
    def completeness(self, value: Optional[pulumi.Input['CompletenessArgs']]):
        pulumi.set(self, "completeness", value)

    @property
    @pulumi.getter
    def reproducible(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")

    @reproducible.setter
    def reproducible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reproducible", value)


@pulumi.input_type
class NonCompliantFileArgs:
    def __init__(__self__, *,
                 display_command: Optional[pulumi.Input[str]] = None,
                 path: Optional[pulumi.Input[str]] = None,
                 reason: Optional[pulumi.Input[str]] = None):
        """
        Details about files that caused a compliance check to fail.
        :param pulumi.Input[str] display_command: Command to display the non-compliant files.
        :param pulumi.Input[str] path: display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'. Empty if `display_command` is set.
        :param pulumi.Input[str] reason: Explains why a file is non compliant for a CIS check.
        """
        if display_command is not None:
            pulumi.set(__self__, "display_command", display_command)
        if path is not None:
            pulumi.set(__self__, "path", path)
        if reason is not None:
            pulumi.set(__self__, "reason", reason)

    @property
    @pulumi.getter(name="displayCommand")
    def display_command(self) -> Optional[pulumi.Input[str]]:
        """
        Command to display the non-compliant files.
        """
        return pulumi.get(self, "display_command")

    @display_command.setter
    def display_command(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "display_command", value)

    @property
    @pulumi.getter
    def path(self) -> Optional[pulumi.Input[str]]:
        """
        display_command is a single command that can be used to display a list of non compliant files. When there is no such command, we can also iterate a list of non compliant file using 'path'. Empty if `display_command` is set.
        """
        return pulumi.get(self, "path")

    @path.setter
    def path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "path", value)

    @property
    @pulumi.getter
    def reason(self) -> Optional[pulumi.Input[str]]:
        """
        Explains why a file is non compliant for a CIS check.
        """
        return pulumi.get(self, "reason")

    @reason.setter
    def reason(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "reason", value)


@pulumi.input_type
class PackageIssueArgs:
    def __init__(__self__, *,
                 affected_cpe_uri: pulumi.Input[str],
                 affected_package: pulumi.Input[str],
                 affected_version: pulumi.Input['VersionArgs'],
                 fixed_version: pulumi.Input['VersionArgs'],
                 fixed_cpe_uri: Optional[pulumi.Input[str]] = None,
                 fixed_package: Optional[pulumi.Input[str]] = None,
                 package_type: Optional[pulumi.Input[str]] = None):
        """
        A detail for a distro and package this vulnerability occurrence was found in and its associated fix (if one is available).
        :param pulumi.Input[str] affected_cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was found in.
        :param pulumi.Input[str] affected_package: The package this vulnerability was found in.
        :param pulumi.Input['VersionArgs'] affected_version: The version of the package that is installed on the resource affected by this vulnerability.
        :param pulumi.Input['VersionArgs'] fixed_version: The version of the package this vulnerability was fixed in. Setting this to VersionKind.MAXIMUM means no fix is yet available.
        :param pulumi.Input[str] fixed_cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was fixed in. It is possible for this to be different from the affected_cpe_uri.
        :param pulumi.Input[str] fixed_package: The package this vulnerability was fixed in. It is possible for this to be different from the affected_package.
        :param pulumi.Input[str] package_type: The type of package (e.g. OS, MAVEN, GO).
        """
        pulumi.set(__self__, "affected_cpe_uri", affected_cpe_uri)
        pulumi.set(__self__, "affected_package", affected_package)
        pulumi.set(__self__, "affected_version", affected_version)
        pulumi.set(__self__, "fixed_version", fixed_version)
        if fixed_cpe_uri is not None:
            pulumi.set(__self__, "fixed_cpe_uri", fixed_cpe_uri)
        if fixed_package is not None:
            pulumi.set(__self__, "fixed_package", fixed_package)
        if package_type is not None:
            pulumi.set(__self__, "package_type", package_type)

    @property
    @pulumi.getter(name="affectedCpeUri")
    def affected_cpe_uri(self) -> pulumi.Input[str]:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was found in.
        """
        return pulumi.get(self, "affected_cpe_uri")

    @affected_cpe_uri.setter
    def affected_cpe_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "affected_cpe_uri", value)

    @property
    @pulumi.getter(name="affectedPackage")
    def affected_package(self) -> pulumi.Input[str]:
        """
        The package this vulnerability was found in.
        """
        return pulumi.get(self, "affected_package")

    @affected_package.setter
    def affected_package(self, value: pulumi.Input[str]):
        pulumi.set(self, "affected_package", value)

    @property
    @pulumi.getter(name="affectedVersion")
    def affected_version(self) -> pulumi.Input['VersionArgs']:
        """
        The version of the package that is installed on the resource affected by this vulnerability.
        """
        return pulumi.get(self, "affected_version")

    @affected_version.setter
    def affected_version(self, value: pulumi.Input['VersionArgs']):
        pulumi.set(self, "affected_version", value)

    @property
    @pulumi.getter(name="fixedVersion")
    def fixed_version(self) -> pulumi.Input['VersionArgs']:
        """
        The version of the package this vulnerability was fixed in. Setting this to VersionKind.MAXIMUM means no fix is yet available.
        """
        return pulumi.get(self, "fixed_version")

    @fixed_version.setter
    def fixed_version(self, value: pulumi.Input['VersionArgs']):
        pulumi.set(self, "fixed_version", value)

    @property
    @pulumi.getter(name="fixedCpeUri")
    def fixed_cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability was fixed in. It is possible for this to be different from the affected_cpe_uri.
        """
        return pulumi.get(self, "fixed_cpe_uri")

    @fixed_cpe_uri.setter
    def fixed_cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_cpe_uri", value)

    @property
    @pulumi.getter(name="fixedPackage")
    def fixed_package(self) -> Optional[pulumi.Input[str]]:
        """
        The package this vulnerability was fixed in. It is possible for this to be different from the affected_package.
        """
        return pulumi.get(self, "fixed_package")

    @fixed_package.setter
    def fixed_package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "fixed_package", value)

    @property
    @pulumi.getter(name="packageType")
    def package_type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package (e.g. OS, MAVEN, GO).
        """
        return pulumi.get(self, "package_type")

    @package_type.setter
    def package_type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package_type", value)


@pulumi.input_type
class PackageNoteArgs:
    def __init__(__self__, *,
                 name: pulumi.Input[str],
                 distribution: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]] = None):
        """
        This represents a particular package that is distributed over various channels. E.g., glibc (aka libc6) is distributed by many, at various versions.
        :param pulumi.Input[str] name: Immutable. The name of the package.
        :param pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]] distribution: The various channels by which a package is distributed.
        """
        pulumi.set(__self__, "name", name)
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        Immutable. The name of the package.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]]:
        """
        The various channels by which a package is distributed.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DistributionArgs']]]]):
        pulumi.set(self, "distribution", value)


@pulumi.input_type
class PackageOccurrenceArgs:
    def __init__(__self__, *,
                 location: pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]):
        """
        Details on how a particular software package was installed on a system.
        :param pulumi.Input[Sequence[pulumi.Input['LocationArgs']]] location: All of the places within the filesystem versions of this package have been found.
        """
        pulumi.set(__self__, "location", location)

    @property
    @pulumi.getter
    def location(self) -> pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]:
        """
        All of the places within the filesystem versions of this package have been found.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: pulumi.Input[Sequence[pulumi.Input['LocationArgs']]]):
        pulumi.set(self, "location", value)


@pulumi.input_type
class ProjectRepoIdArgs:
    def __init__(__self__, *,
                 project: Optional[pulumi.Input[str]] = None,
                 repo_name: Optional[pulumi.Input[str]] = None):
        """
        Selects a repo using a Google Cloud Platform project ID (e.g., winged-cargo-31) and a repo name within that project.
        :param pulumi.Input[str] project: The ID of the project.
        :param pulumi.Input[str] repo_name: The name of the repo. Leave empty for the default repo.
        """
        if project is not None:
            pulumi.set(__self__, "project", project)
        if repo_name is not None:
            pulumi.set(__self__, "repo_name", repo_name)

    @property
    @pulumi.getter
    def project(self) -> Optional[pulumi.Input[str]]:
        """
        The ID of the project.
        """
        return pulumi.get(self, "project")

    @project.setter
    def project(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "project", value)

    @property
    @pulumi.getter(name="repoName")
    def repo_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the repo. Leave empty for the default repo.
        """
        return pulumi.get(self, "repo_name")

    @repo_name.setter
    def repo_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "repo_name", value)


@pulumi.input_type
class RecipeArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 defined_in_material: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Since the arguments field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        :param pulumi.Input[str] defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param pulumi.Input[str] entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Since the environment field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        :param pulumi.Input[str] type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defined_in_material is not None:
            pulumi.set(__self__, "defined_in_material", defined_in_material)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Since the arguments field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> Optional[pulumi.Input[str]]:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @defined_in_material.setter
    def defined_in_material(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "defined_in_material", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Since the environment field can greatly vary in structure, depending on the builder and recipe type, this is of form "Any".
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class RelatedUrlArgs:
    def __init__(__self__, *,
                 label: Optional[pulumi.Input[str]] = None,
                 url: Optional[pulumi.Input[str]] = None):
        """
        Metadata for any related URL information.
        :param pulumi.Input[str] label: Label to describe usage of the URL.
        :param pulumi.Input[str] url: Specific URL associated with the resource.
        """
        if label is not None:
            pulumi.set(__self__, "label", label)
        if url is not None:
            pulumi.set(__self__, "url", url)

    @property
    @pulumi.getter
    def label(self) -> Optional[pulumi.Input[str]]:
        """
        Label to describe usage of the URL.
        """
        return pulumi.get(self, "label")

    @label.setter
    def label(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "label", value)

    @property
    @pulumi.getter
    def url(self) -> Optional[pulumi.Input[str]]:
        """
        Specific URL associated with the resource.
        """
        return pulumi.get(self, "url")

    @url.setter
    def url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "url", value)


@pulumi.input_type
class RepoIdArgs:
    def __init__(__self__, *,
                 project_repo_id: Optional[pulumi.Input['ProjectRepoIdArgs']] = None,
                 uid: Optional[pulumi.Input[str]] = None):
        """
        A unique identifier for a Cloud Repo.
        :param pulumi.Input['ProjectRepoIdArgs'] project_repo_id: A combination of a project ID and a repo name.
        :param pulumi.Input[str] uid: A server-assigned, globally unique identifier.
        """
        if project_repo_id is not None:
            pulumi.set(__self__, "project_repo_id", project_repo_id)
        if uid is not None:
            pulumi.set(__self__, "uid", uid)

    @property
    @pulumi.getter(name="projectRepoId")
    def project_repo_id(self) -> Optional[pulumi.Input['ProjectRepoIdArgs']]:
        """
        A combination of a project ID and a repo name.
        """
        return pulumi.get(self, "project_repo_id")

    @project_repo_id.setter
    def project_repo_id(self, value: Optional[pulumi.Input['ProjectRepoIdArgs']]):
        pulumi.set(self, "project_repo_id", value)

    @property
    @pulumi.getter
    def uid(self) -> Optional[pulumi.Input[str]]:
        """
        A server-assigned, globally unique identifier.
        """
        return pulumi.get(self, "uid")

    @uid.setter
    def uid(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "uid", value)


@pulumi.input_type
class SignatureArgs:
    def __init__(__self__, *,
                 public_key_id: Optional[pulumi.Input[str]] = None,
                 signature: Optional[pulumi.Input[str]] = None):
        """
        Verifiers (e.g. Kritis implementations) MUST verify signatures with respect to the trust anchors defined in policy (e.g. a Kritis policy). Typically this means that the verifier has been configured with a map from `public_key_id` to public key material (and any required parameters, e.g. signing algorithm). In particular, verification implementations MUST NOT treat the signature `public_key_id` as anything more than a key lookup hint. The `public_key_id` DOES NOT validate or authenticate a public key; it only provides a mechanism for quickly selecting a public key ALREADY CONFIGURED on the verifier through a trusted channel. Verification implementations MUST reject signatures in any of the following circumstances: * The `public_key_id` is not recognized by the verifier. * The public key that `public_key_id` refers to does not verify the signature with respect to the payload. The `signature` contents SHOULD NOT be "attached" (where the payload is included with the serialized `signature` bytes). Verifiers MUST ignore any "attached" payload and only verify signatures with respect to explicitly provided payload (e.g. a `payload` field on the proto message that holds this Signature, or the canonical serialization of the proto message that holds this signature).
        :param pulumi.Input[str] public_key_id: The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        :param pulumi.Input[str] signature: The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        if public_key_id is not None:
            pulumi.set(__self__, "public_key_id", public_key_id)
        if signature is not None:
            pulumi.set(__self__, "signature", signature)

    @property
    @pulumi.getter(name="publicKeyId")
    def public_key_id(self) -> Optional[pulumi.Input[str]]:
        """
        The identifier for the public key that verifies this signature. * The `public_key_id` is required. * The `public_key_id` SHOULD be an RFC3986 conformant URI. * When possible, the `public_key_id` SHOULD be an immutable reference, such as a cryptographic digest. Examples of valid `public_key_id`s: OpenPGP V4 public key fingerprint: * "openpgp4fpr:74FAF3B861BDA0870C7B6DEF607E48D2A663AEEA" See https://www.iana.org/assignments/uri-schemes/prov/openpgp4fpr for more details on this scheme. RFC6920 digest-named SubjectPublicKeyInfo (digest of the DER serialization): * "ni:///sha-256;cD9o9Cq6LG3jD0iKXqEi_vdjJGecm_iXkbqVoScViaU" * "nih:///sha-256;703f68f42aba2c6de30f488a5ea122fef76324679c9bf89791ba95a1271589a5"
        """
        return pulumi.get(self, "public_key_id")

    @public_key_id.setter
    def public_key_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "public_key_id", value)

    @property
    @pulumi.getter
    def signature(self) -> Optional[pulumi.Input[str]]:
        """
        The content of the signature, an opaque bytestring. The payload that this signature verifies MUST be unambiguously provided with the Signature during verification. A wrapper message might provide the payload explicitly. Alternatively, a message might have a canonical serialization that can always be unambiguously computed to derive the payload.
        """
        return pulumi.get(self, "signature")

    @signature.setter
    def signature(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "signature", value)


@pulumi.input_type
class SlsaBuilderArgs:
    def __init__(__self__, *,
                 id: Optional[pulumi.Input[str]] = None):
        if id is not None:
            pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "id")

    @id.setter
    def id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "id", value)


@pulumi.input_type
class SlsaCompletenessArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[bool]] = None,
                 environment: Optional[pulumi.Input[bool]] = None,
                 materials: Optional[pulumi.Input[bool]] = None):
        """
        Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] arguments: If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        :param pulumi.Input[bool] environment: If true, the builder claims that recipe.environment is claimed to be complete.
        :param pulumi.Input[bool] materials: If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.arguments is complete, meaning that all external inputs are properly captured in the recipe.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that recipe.environment is claimed to be complete.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that materials are complete, usually through some controls to prevent network access. Sometimes called "hermetic".
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "materials", value)


@pulumi.input_type
class SlsaMetadataArgs:
    def __init__(__self__, *,
                 build_finished_on: Optional[pulumi.Input[str]] = None,
                 build_invocation_id: Optional[pulumi.Input[str]] = None,
                 build_started_on: Optional[pulumi.Input[str]] = None,
                 completeness: Optional[pulumi.Input['SlsaCompletenessArgs']] = None,
                 reproducible: Optional[pulumi.Input[bool]] = None):
        """
        Other properties of the build.
        :param pulumi.Input[str] build_finished_on: The timestamp of when the build completed.
        :param pulumi.Input[str] build_invocation_id: Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        :param pulumi.Input[str] build_started_on: The timestamp of when the build started.
        :param pulumi.Input['SlsaCompletenessArgs'] completeness: Indicates that the builder claims certain fields in this message to be complete.
        :param pulumi.Input[bool] reproducible: If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        if build_finished_on is not None:
            pulumi.set(__self__, "build_finished_on", build_finished_on)
        if build_invocation_id is not None:
            pulumi.set(__self__, "build_invocation_id", build_invocation_id)
        if build_started_on is not None:
            pulumi.set(__self__, "build_started_on", build_started_on)
        if completeness is not None:
            pulumi.set(__self__, "completeness", completeness)
        if reproducible is not None:
            pulumi.set(__self__, "reproducible", reproducible)

    @property
    @pulumi.getter(name="buildFinishedOn")
    def build_finished_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build completed.
        """
        return pulumi.get(self, "build_finished_on")

    @build_finished_on.setter
    def build_finished_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_finished_on", value)

    @property
    @pulumi.getter(name="buildInvocationId")
    def build_invocation_id(self) -> Optional[pulumi.Input[str]]:
        """
        Identifies the particular build invocation, which can be useful for finding associated logs or other ad-hoc analysis. The value SHOULD be globally unique, per in-toto Provenance spec.
        """
        return pulumi.get(self, "build_invocation_id")

    @build_invocation_id.setter
    def build_invocation_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_invocation_id", value)

    @property
    @pulumi.getter(name="buildStartedOn")
    def build_started_on(self) -> Optional[pulumi.Input[str]]:
        """
        The timestamp of when the build started.
        """
        return pulumi.get(self, "build_started_on")

    @build_started_on.setter
    def build_started_on(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "build_started_on", value)

    @property
    @pulumi.getter
    def completeness(self) -> Optional[pulumi.Input['SlsaCompletenessArgs']]:
        """
        Indicates that the builder claims certain fields in this message to be complete.
        """
        return pulumi.get(self, "completeness")

    @completeness.setter
    def completeness(self, value: Optional[pulumi.Input['SlsaCompletenessArgs']]):
        pulumi.set(self, "completeness", value)

    @property
    @pulumi.getter
    def reproducible(self) -> Optional[pulumi.Input[bool]]:
        """
        If true, the builder claims that running the recipe on materials will produce bit-for-bit identical output.
        """
        return pulumi.get(self, "reproducible")

    @reproducible.setter
    def reproducible(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "reproducible", value)


@pulumi.input_type
class SlsaProvenanceArgs:
    def __init__(__self__, *,
                 builder: Optional[pulumi.Input['SlsaBuilderArgs']] = None,
                 materials: Optional[pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]]] = None,
                 metadata: Optional[pulumi.Input['SlsaMetadataArgs']] = None,
                 recipe: Optional[pulumi.Input['SlsaRecipeArgs']] = None):
        """
        :param pulumi.Input['SlsaBuilderArgs'] builder: required
        :param pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]] materials: The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        :param pulumi.Input['SlsaRecipeArgs'] recipe: Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        if builder is not None:
            pulumi.set(__self__, "builder", builder)
        if materials is not None:
            pulumi.set(__self__, "materials", materials)
        if metadata is not None:
            pulumi.set(__self__, "metadata", metadata)
        if recipe is not None:
            pulumi.set(__self__, "recipe", recipe)

    @property
    @pulumi.getter
    def builder(self) -> Optional[pulumi.Input['SlsaBuilderArgs']]:
        """
        required
        """
        return pulumi.get(self, "builder")

    @builder.setter
    def builder(self, value: Optional[pulumi.Input['SlsaBuilderArgs']]):
        pulumi.set(self, "builder", value)

    @property
    @pulumi.getter
    def materials(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]]]:
        """
        The collection of artifacts that influenced the build including sources, dependencies, build tools, base images, and so on. This is considered to be incomplete unless metadata.completeness.materials is true. Unset or null is equivalent to empty.
        """
        return pulumi.get(self, "materials")

    @materials.setter
    def materials(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['MaterialArgs']]]]):
        pulumi.set(self, "materials", value)

    @property
    @pulumi.getter
    def metadata(self) -> Optional[pulumi.Input['SlsaMetadataArgs']]:
        return pulumi.get(self, "metadata")

    @metadata.setter
    def metadata(self, value: Optional[pulumi.Input['SlsaMetadataArgs']]):
        pulumi.set(self, "metadata", value)

    @property
    @pulumi.getter
    def recipe(self) -> Optional[pulumi.Input['SlsaRecipeArgs']]:
        """
        Identifies the configuration used for the build. When combined with materials, this SHOULD fully describe the build, such that re-running this recipe results in bit-for-bit identical output (if the build is reproducible). required
        """
        return pulumi.get(self, "recipe")

    @recipe.setter
    def recipe(self, value: Optional[pulumi.Input['SlsaRecipeArgs']]):
        pulumi.set(self, "recipe", value)


@pulumi.input_type
class SlsaRecipeArgs:
    def __init__(__self__, *,
                 arguments: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 defined_in_material: Optional[pulumi.Input[str]] = None,
                 entry_point: Optional[pulumi.Input[str]] = None,
                 environment: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        Steps taken to build the artifact. For a TaskRun, typically each container corresponds to one step in the recipe.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] arguments: Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        :param pulumi.Input[str] defined_in_material: Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        :param pulumi.Input[str] entry_point: String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] environment: Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        :param pulumi.Input[str] type: URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        if arguments is not None:
            pulumi.set(__self__, "arguments", arguments)
        if defined_in_material is not None:
            pulumi.set(__self__, "defined_in_material", defined_in_material)
        if entry_point is not None:
            pulumi.set(__self__, "entry_point", entry_point)
        if environment is not None:
            pulumi.set(__self__, "environment", environment)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def arguments(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Collection of all external inputs that influenced the build on top of recipe.definedInMaterial and recipe.entryPoint. For example, if the recipe type were "make", then this might be the flags passed to make aside from the target, which is captured in recipe.entryPoint. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "arguments")

    @arguments.setter
    def arguments(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "arguments", value)

    @property
    @pulumi.getter(name="definedInMaterial")
    def defined_in_material(self) -> Optional[pulumi.Input[str]]:
        """
        Index in materials containing the recipe steps that are not implied by recipe.type. For example, if the recipe type were "make", then this would point to the source containing the Makefile, not the make program itself. Set to -1 if the recipe doesn't come from a material, as zero is default unset value for int64.
        """
        return pulumi.get(self, "defined_in_material")

    @defined_in_material.setter
    def defined_in_material(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "defined_in_material", value)

    @property
    @pulumi.getter(name="entryPoint")
    def entry_point(self) -> Optional[pulumi.Input[str]]:
        """
        String identifying the entry point into the build. This is often a path to a configuration file and/or a target label within that file. The syntax and meaning are defined by recipe.type. For example, if the recipe type were "make", then this would reference the directory in which to run make as well as which target to use.
        """
        return pulumi.get(self, "entry_point")

    @entry_point.setter
    def entry_point(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "entry_point", value)

    @property
    @pulumi.getter
    def environment(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Any other builder-controlled inputs necessary for correctly evaluating the recipe. Usually only needed for reproducing the build but not evaluated as part of policy. Depending on the recipe Type, the structure may be different.
        """
        return pulumi.get(self, "environment")

    @environment.setter
    def environment(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "environment", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        URI indicating what type of recipe was performed. It determines the meaning of recipe.entryPoint, recipe.arguments, recipe.environment, and materials.
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class SourceContextArgs:
    def __init__(__self__, *,
                 cloud_repo: Optional[pulumi.Input['CloudRepoSourceContextArgs']] = None,
                 gerrit: Optional[pulumi.Input['GerritSourceContextArgs']] = None,
                 git: Optional[pulumi.Input['GitSourceContextArgs']] = None,
                 labels: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        A SourceContext is a reference to a tree of files. A SourceContext together with a path point to a unique revision of a single file or directory.
        :param pulumi.Input['CloudRepoSourceContextArgs'] cloud_repo: A SourceContext referring to a revision in a Google Cloud Source Repo.
        :param pulumi.Input['GerritSourceContextArgs'] gerrit: A SourceContext referring to a Gerrit project.
        :param pulumi.Input['GitSourceContextArgs'] git: A SourceContext referring to any third party Git repo (e.g., GitHub).
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] labels: Labels with user defined metadata.
        """
        if cloud_repo is not None:
            pulumi.set(__self__, "cloud_repo", cloud_repo)
        if gerrit is not None:
            pulumi.set(__self__, "gerrit", gerrit)
        if git is not None:
            pulumi.set(__self__, "git", git)
        if labels is not None:
            pulumi.set(__self__, "labels", labels)

    @property
    @pulumi.getter(name="cloudRepo")
    def cloud_repo(self) -> Optional[pulumi.Input['CloudRepoSourceContextArgs']]:
        """
        A SourceContext referring to a revision in a Google Cloud Source Repo.
        """
        return pulumi.get(self, "cloud_repo")

    @cloud_repo.setter
    def cloud_repo(self, value: Optional[pulumi.Input['CloudRepoSourceContextArgs']]):
        pulumi.set(self, "cloud_repo", value)

    @property
    @pulumi.getter
    def gerrit(self) -> Optional[pulumi.Input['GerritSourceContextArgs']]:
        """
        A SourceContext referring to a Gerrit project.
        """
        return pulumi.get(self, "gerrit")

    @gerrit.setter
    def gerrit(self, value: Optional[pulumi.Input['GerritSourceContextArgs']]):
        pulumi.set(self, "gerrit", value)

    @property
    @pulumi.getter
    def git(self) -> Optional[pulumi.Input['GitSourceContextArgs']]:
        """
        A SourceContext referring to any third party Git repo (e.g., GitHub).
        """
        return pulumi.get(self, "git")

    @git.setter
    def git(self, value: Optional[pulumi.Input['GitSourceContextArgs']]):
        pulumi.set(self, "git", value)

    @property
    @pulumi.getter
    def labels(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Labels with user defined metadata.
        """
        return pulumi.get(self, "labels")

    @labels.setter
    def labels(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "labels", value)


@pulumi.input_type
class SourceArgs:
    def __init__(__self__, *,
                 additional_contexts: Optional[pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]]] = None,
                 artifact_storage_source_uri: Optional[pulumi.Input[str]] = None,
                 context: Optional[pulumi.Input['SourceContextArgs']] = None,
                 file_hashes: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None):
        """
        Source describes the location of the source used for the build.
        :param pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]] additional_contexts: If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        :param pulumi.Input[str] artifact_storage_source_uri: If provided, the input binary artifacts for the build came from this location.
        :param pulumi.Input['SourceContextArgs'] context: If provided, the source code used for the build came from this location.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] file_hashes: Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        if additional_contexts is not None:
            pulumi.set(__self__, "additional_contexts", additional_contexts)
        if artifact_storage_source_uri is not None:
            pulumi.set(__self__, "artifact_storage_source_uri", artifact_storage_source_uri)
        if context is not None:
            pulumi.set(__self__, "context", context)
        if file_hashes is not None:
            pulumi.set(__self__, "file_hashes", file_hashes)

    @property
    @pulumi.getter(name="additionalContexts")
    def additional_contexts(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]]]:
        """
        If provided, some of the source code used for the build may be found in these locations, in the case where the source repository had multiple remotes or submodules. This list will not include the context specified in the context field.
        """
        return pulumi.get(self, "additional_contexts")

    @additional_contexts.setter
    def additional_contexts(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['SourceContextArgs']]]]):
        pulumi.set(self, "additional_contexts", value)

    @property
    @pulumi.getter(name="artifactStorageSourceUri")
    def artifact_storage_source_uri(self) -> Optional[pulumi.Input[str]]:
        """
        If provided, the input binary artifacts for the build came from this location.
        """
        return pulumi.get(self, "artifact_storage_source_uri")

    @artifact_storage_source_uri.setter
    def artifact_storage_source_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "artifact_storage_source_uri", value)

    @property
    @pulumi.getter
    def context(self) -> Optional[pulumi.Input['SourceContextArgs']]:
        """
        If provided, the source code used for the build came from this location.
        """
        return pulumi.get(self, "context")

    @context.setter
    def context(self, value: Optional[pulumi.Input['SourceContextArgs']]):
        pulumi.set(self, "context", value)

    @property
    @pulumi.getter(name="fileHashes")
    def file_hashes(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Hash(es) of the build source, which can be used to verify that the original source integrity was maintained in the build. The keys to this map are file paths used as build source and the values contain the hash values for those files. If the build source came in a single package such as a gzipped tarfile (.tar.gz), the FileHash will be for the single path to that file.
        """
        return pulumi.get(self, "file_hashes")

    @file_hashes.setter
    def file_hashes(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "file_hashes", value)


@pulumi.input_type
class StatusArgs:
    def __init__(__self__, *,
                 code: Optional[pulumi.Input[int]] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]] = None,
                 message: Optional[pulumi.Input[str]] = None):
        """
        The `Status` type defines a logical error model that is suitable for different programming environments, including REST APIs and RPC APIs. It is used by [gRPC](https://github.com/grpc). Each `Status` message contains three pieces of data: error code, error message, and error details. You can find out more about this error model and how to work with it in the [API Design Guide](https://cloud.google.com/apis/design/errors).
        :param pulumi.Input[int] code: The status code, which should be an enum value of google.rpc.Code.
        :param pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]] details: A list of messages that carry the error details. There is a common set of message types for APIs to use.
        :param pulumi.Input[str] message: A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        if code is not None:
            pulumi.set(__self__, "code", code)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if message is not None:
            pulumi.set(__self__, "message", message)

    @property
    @pulumi.getter
    def code(self) -> Optional[pulumi.Input[int]]:
        """
        The status code, which should be an enum value of google.rpc.Code.
        """
        return pulumi.get(self, "code")

    @code.setter
    def code(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "code", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]:
        """
        A list of messages that carry the error details. There is a common set of message types for APIs to use.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[Mapping[str, pulumi.Input[str]]]]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def message(self) -> Optional[pulumi.Input[str]]:
        """
        A developer-facing error message, which should be in English. Any user-facing error message should be localized and sent in the google.rpc.Status.details field, or localized by the client.
        """
        return pulumi.get(self, "message")

    @message.setter
    def message(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "message", value)


@pulumi.input_type
class SubjectArgs:
    def __init__(__self__, *,
                 digest: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] digest: "": "" Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        """
        if digest is not None:
            pulumi.set(__self__, "digest", digest)
        if name is not None:
            pulumi.set(__self__, "name", name)

    @property
    @pulumi.getter
    def digest(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        "": "" Algorithms can be e.g. sha256, sha512 See https://github.com/in-toto/attestation/blob/main/spec/field_types.md#DigestSet
        """
        return pulumi.get(self, "digest")

    @digest.setter
    def digest(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "digest", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)


@pulumi.input_type
class UpgradeDistributionArgs:
    def __init__(__self__, *,
                 classification: Optional[pulumi.Input[str]] = None,
                 cpe_uri: Optional[pulumi.Input[str]] = None,
                 cve: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 severity: Optional[pulumi.Input[str]] = None):
        """
        The Upgrade Distribution represents metadata about the Upgrade for each operating system (CPE). Some distributions have additional metadata around updates, classifying them into various categories and severities.
        :param pulumi.Input[str] classification: The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed. For Windows the classification is one of the category_ids listed at https://docs.microsoft.com/en-us/previous-versions/windows/desktop/ff357803(v=vs.85)
        :param pulumi.Input[str] cpe_uri: Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] cve: The cve tied to this Upgrade.
        :param pulumi.Input[str] severity: The severity as specified by the upstream operating system.
        """
        if classification is not None:
            pulumi.set(__self__, "classification", classification)
        if cpe_uri is not None:
            pulumi.set(__self__, "cpe_uri", cpe_uri)
        if cve is not None:
            pulumi.set(__self__, "cve", cve)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)

    @property
    @pulumi.getter
    def classification(self) -> Optional[pulumi.Input[str]]:
        """
        The operating system classification of this Upgrade, as specified by the upstream operating system upgrade feed. For Windows the classification is one of the category_ids listed at https://docs.microsoft.com/en-us/previous-versions/windows/desktop/ff357803(v=vs.85)
        """
        return pulumi.get(self, "classification")

    @classification.setter
    def classification(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "classification", value)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> Optional[pulumi.Input[str]]:
        """
        Required - The specific operating system this metadata applies to. See https://cpe.mitre.org/specification/.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter
    def cve(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The cve tied to this Upgrade.
        """
        return pulumi.get(self, "cve")

    @cve.setter
    def cve(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "cve", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input[str]]:
        """
        The severity as specified by the upstream operating system.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "severity", value)


@pulumi.input_type
class UpgradeNoteArgs:
    def __init__(__self__, *,
                 distributions: Optional[pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]]] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 version: Optional[pulumi.Input['VersionArgs']] = None,
                 windows_update: Optional[pulumi.Input['WindowsUpdateArgs']] = None):
        """
        An Upgrade Note represents a potential upgrade of a package to a given version. For each package version combination (i.e. bash 4.0, bash 4.1, bash 4.1.2), there will be an Upgrade Note. For Windows, windows_update field represents the information related to the update.
        :param pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]] distributions: Metadata about the upgrade for each specific operating system.
        :param pulumi.Input[str] package: Required for non-Windows OS. The package this Upgrade is for.
        :param pulumi.Input['VersionArgs'] version: Required for non-Windows OS. The version of the package in machine + human readable form.
        :param pulumi.Input['WindowsUpdateArgs'] windows_update: Required for Windows OS. Represents the metadata about the Windows update.
        """
        if distributions is not None:
            pulumi.set(__self__, "distributions", distributions)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if version is not None:
            pulumi.set(__self__, "version", version)
        if windows_update is not None:
            pulumi.set(__self__, "windows_update", windows_update)

    @property
    @pulumi.getter
    def distributions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]]]:
        """
        Metadata about the upgrade for each specific operating system.
        """
        return pulumi.get(self, "distributions")

    @distributions.setter
    def distributions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['UpgradeDistributionArgs']]]]):
        pulumi.set(self, "distributions", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        Required for non-Windows OS. The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter
    def version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        Required for non-Windows OS. The version of the package in machine + human readable form.
        """
        return pulumi.get(self, "version")

    @version.setter
    def version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "version", value)

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> Optional[pulumi.Input['WindowsUpdateArgs']]:
        """
        Required for Windows OS. Represents the metadata about the Windows update.
        """
        return pulumi.get(self, "windows_update")

    @windows_update.setter
    def windows_update(self, value: Optional[pulumi.Input['WindowsUpdateArgs']]):
        pulumi.set(self, "windows_update", value)


@pulumi.input_type
class UpgradeOccurrenceArgs:
    def __init__(__self__, *,
                 distribution: Optional[pulumi.Input['UpgradeDistributionArgs']] = None,
                 package: Optional[pulumi.Input[str]] = None,
                 parsed_version: Optional[pulumi.Input['VersionArgs']] = None,
                 windows_update: Optional[pulumi.Input['WindowsUpdateArgs']] = None):
        """
        An Upgrade Occurrence represents that a specific resource_url could install a specific upgrade. This presence is supplied via local sources (i.e. it is present in the mirror and the running system has noticed its availability). For Windows, both distribution and windows_update contain information for the Windows update.
        :param pulumi.Input['UpgradeDistributionArgs'] distribution: Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        :param pulumi.Input[str] package: Required for non-Windows OS. The package this Upgrade is for.
        :param pulumi.Input['VersionArgs'] parsed_version: Required for non-Windows OS. The version of the package in a machine + human readable form.
        :param pulumi.Input['WindowsUpdateArgs'] windows_update: Required for Windows OS. Represents the metadata about the Windows update.
        """
        if distribution is not None:
            pulumi.set(__self__, "distribution", distribution)
        if package is not None:
            pulumi.set(__self__, "package", package)
        if parsed_version is not None:
            pulumi.set(__self__, "parsed_version", parsed_version)
        if windows_update is not None:
            pulumi.set(__self__, "windows_update", windows_update)

    @property
    @pulumi.getter
    def distribution(self) -> Optional[pulumi.Input['UpgradeDistributionArgs']]:
        """
        Metadata about the upgrade for available for the specific operating system for the resource_url. This allows efficient filtering, as well as making it easier to use the occurrence.
        """
        return pulumi.get(self, "distribution")

    @distribution.setter
    def distribution(self, value: Optional[pulumi.Input['UpgradeDistributionArgs']]):
        pulumi.set(self, "distribution", value)

    @property
    @pulumi.getter
    def package(self) -> Optional[pulumi.Input[str]]:
        """
        Required for non-Windows OS. The package this Upgrade is for.
        """
        return pulumi.get(self, "package")

    @package.setter
    def package(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "package", value)

    @property
    @pulumi.getter(name="parsedVersion")
    def parsed_version(self) -> Optional[pulumi.Input['VersionArgs']]:
        """
        Required for non-Windows OS. The version of the package in a machine + human readable form.
        """
        return pulumi.get(self, "parsed_version")

    @parsed_version.setter
    def parsed_version(self, value: Optional[pulumi.Input['VersionArgs']]):
        pulumi.set(self, "parsed_version", value)

    @property
    @pulumi.getter(name="windowsUpdate")
    def windows_update(self) -> Optional[pulumi.Input['WindowsUpdateArgs']]:
        """
        Required for Windows OS. Represents the metadata about the Windows update.
        """
        return pulumi.get(self, "windows_update")

    @windows_update.setter
    def windows_update(self, value: Optional[pulumi.Input['WindowsUpdateArgs']]):
        pulumi.set(self, "windows_update", value)


@pulumi.input_type
class VersionArgs:
    def __init__(__self__, *,
                 kind: pulumi.Input['VersionKind'],
                 epoch: Optional[pulumi.Input[int]] = None,
                 full_name: Optional[pulumi.Input[str]] = None,
                 inclusive: Optional[pulumi.Input[bool]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 revision: Optional[pulumi.Input[str]] = None):
        """
        Version contains structured information about the version of a package.
        :param pulumi.Input['VersionKind'] kind: Distinguishes between sentinel MIN/MAX versions and normal versions.
        :param pulumi.Input[int] epoch: Used to correct mistakes in the version numbering scheme.
        :param pulumi.Input[str] full_name: Human readable version string. This string is of the form :- and is only set when kind is NORMAL.
        :param pulumi.Input[bool] inclusive: Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        :param pulumi.Input[str] name: Required only when version kind is NORMAL. The main part of the version name.
        :param pulumi.Input[str] revision: The iteration of the package build from the above version.
        """
        pulumi.set(__self__, "kind", kind)
        if epoch is not None:
            pulumi.set(__self__, "epoch", epoch)
        if full_name is not None:
            pulumi.set(__self__, "full_name", full_name)
        if inclusive is not None:
            pulumi.set(__self__, "inclusive", inclusive)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if revision is not None:
            pulumi.set(__self__, "revision", revision)

    @property
    @pulumi.getter
    def kind(self) -> pulumi.Input['VersionKind']:
        """
        Distinguishes between sentinel MIN/MAX versions and normal versions.
        """
        return pulumi.get(self, "kind")

    @kind.setter
    def kind(self, value: pulumi.Input['VersionKind']):
        pulumi.set(self, "kind", value)

    @property
    @pulumi.getter
    def epoch(self) -> Optional[pulumi.Input[int]]:
        """
        Used to correct mistakes in the version numbering scheme.
        """
        return pulumi.get(self, "epoch")

    @epoch.setter
    def epoch(self, value: Optional[pulumi.Input[int]]):
        pulumi.set(self, "epoch", value)

    @property
    @pulumi.getter(name="fullName")
    def full_name(self) -> Optional[pulumi.Input[str]]:
        """
        Human readable version string. This string is of the form :- and is only set when kind is NORMAL.
        """
        return pulumi.get(self, "full_name")

    @full_name.setter
    def full_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "full_name", value)

    @property
    @pulumi.getter
    def inclusive(self) -> Optional[pulumi.Input[bool]]:
        """
        Whether this version is specifying part of an inclusive range. Grafeas does not have the capability to specify version ranges; instead we have fields that specify start version and end versions. At times this is insufficient - we also need to specify whether the version is included in the range or is excluded from the range. This boolean is expected to be set to true when the version is included in a range.
        """
        return pulumi.get(self, "inclusive")

    @inclusive.setter
    def inclusive(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "inclusive", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Required only when version kind is NORMAL. The main part of the version name.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def revision(self) -> Optional[pulumi.Input[str]]:
        """
        The iteration of the package build from the above version.
        """
        return pulumi.get(self, "revision")

    @revision.setter
    def revision(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "revision", value)


@pulumi.input_type
class VulnerabilityNoteArgs:
    def __init__(__self__, *,
                 cvss_score: Optional[pulumi.Input[float]] = None,
                 cvss_v3: Optional[pulumi.Input['CVSSv3Args']] = None,
                 details: Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]] = None,
                 severity: Optional[pulumi.Input['VulnerabilityNoteSeverity']] = None,
                 source_update_time: Optional[pulumi.Input[str]] = None,
                 windows_details: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]]] = None):
        """
        A security vulnerability that can be found in resources.
        :param pulumi.Input[float] cvss_score: The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
        :param pulumi.Input['CVSSv3Args'] cvss_v3: The full description of the CVSSv3 for this vulnerability.
        :param pulumi.Input[Sequence[pulumi.Input['DetailArgs']]] details: Details of all known distros and packages affected by this vulnerability.
        :param pulumi.Input['VulnerabilityNoteSeverity'] severity: The note provider assigned severity of this vulnerability.
        :param pulumi.Input[str] source_update_time: The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        :param pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]] windows_details: Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        if cvss_score is not None:
            pulumi.set(__self__, "cvss_score", cvss_score)
        if cvss_v3 is not None:
            pulumi.set(__self__, "cvss_v3", cvss_v3)
        if details is not None:
            pulumi.set(__self__, "details", details)
        if severity is not None:
            pulumi.set(__self__, "severity", severity)
        if source_update_time is not None:
            pulumi.set(__self__, "source_update_time", source_update_time)
        if windows_details is not None:
            pulumi.set(__self__, "windows_details", windows_details)

    @property
    @pulumi.getter(name="cvssScore")
    def cvss_score(self) -> Optional[pulumi.Input[float]]:
        """
        The CVSS score of this vulnerability. CVSS score is on a scale of 0 - 10 where 0 indicates low severity and 10 indicates high severity.
        """
        return pulumi.get(self, "cvss_score")

    @cvss_score.setter
    def cvss_score(self, value: Optional[pulumi.Input[float]]):
        pulumi.set(self, "cvss_score", value)

    @property
    @pulumi.getter(name="cvssV3")
    def cvss_v3(self) -> Optional[pulumi.Input['CVSSv3Args']]:
        """
        The full description of the CVSSv3 for this vulnerability.
        """
        return pulumi.get(self, "cvss_v3")

    @cvss_v3.setter
    def cvss_v3(self, value: Optional[pulumi.Input['CVSSv3Args']]):
        pulumi.set(self, "cvss_v3", value)

    @property
    @pulumi.getter
    def details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]]:
        """
        Details of all known distros and packages affected by this vulnerability.
        """
        return pulumi.get(self, "details")

    @details.setter
    def details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['DetailArgs']]]]):
        pulumi.set(self, "details", value)

    @property
    @pulumi.getter
    def severity(self) -> Optional[pulumi.Input['VulnerabilityNoteSeverity']]:
        """
        The note provider assigned severity of this vulnerability.
        """
        return pulumi.get(self, "severity")

    @severity.setter
    def severity(self, value: Optional[pulumi.Input['VulnerabilityNoteSeverity']]):
        pulumi.set(self, "severity", value)

    @property
    @pulumi.getter(name="sourceUpdateTime")
    def source_update_time(self) -> Optional[pulumi.Input[str]]:
        """
        The time this information was last changed at the source. This is an upstream timestamp from the underlying information source - e.g. Ubuntu security tracker.
        """
        return pulumi.get(self, "source_update_time")

    @source_update_time.setter
    def source_update_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "source_update_time", value)

    @property
    @pulumi.getter(name="windowsDetails")
    def windows_details(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]]]:
        """
        Windows details get their own format because the information format and model don't match a normal detail. Specifically Windows updates are done as patches, thus Windows vulnerabilities really are a missing package, rather than a package being at an incorrect version.
        """
        return pulumi.get(self, "windows_details")

    @windows_details.setter
    def windows_details(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['WindowsDetailArgs']]]]):
        pulumi.set(self, "windows_details", value)


@pulumi.input_type
class VulnerabilityOccurrenceArgs:
    def __init__(__self__, *,
                 package_issue: pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]],
                 cvssv3: Optional[pulumi.Input['CVSSArgs']] = None,
                 effective_severity: Optional[pulumi.Input['VulnerabilityOccurrenceEffectiveSeverity']] = None,
                 type: Optional[pulumi.Input[str]] = None):
        """
        An occurrence of a severity vulnerability on a resource.
        :param pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]] package_issue: The set of affected locations and their fixes (if available) within the associated resource.
        :param pulumi.Input['CVSSArgs'] cvssv3: The cvss v3 score for the vulnerability.
        :param pulumi.Input['VulnerabilityOccurrenceEffectiveSeverity'] effective_severity: The distro assigned severity for this vulnerability when it is available, otherwise this is the note provider assigned severity. When there are multiple PackageIssues for this vulnerability, they can have different effective severities because some might be provided by the distro while others are provided by the language ecosystem for a language pack. For this reason, it is advised to use the effective severity on the PackageIssue level. In the case where multiple PackageIssues have differing effective severities, this field should be the highest severity for any of the PackageIssues.
        :param pulumi.Input[str] type: The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        pulumi.set(__self__, "package_issue", package_issue)
        if cvssv3 is not None:
            pulumi.set(__self__, "cvssv3", cvssv3)
        if effective_severity is not None:
            pulumi.set(__self__, "effective_severity", effective_severity)
        if type is not None:
            pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter(name="packageIssue")
    def package_issue(self) -> pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]:
        """
        The set of affected locations and their fixes (if available) within the associated resource.
        """
        return pulumi.get(self, "package_issue")

    @package_issue.setter
    def package_issue(self, value: pulumi.Input[Sequence[pulumi.Input['PackageIssueArgs']]]):
        pulumi.set(self, "package_issue", value)

    @property
    @pulumi.getter
    def cvssv3(self) -> Optional[pulumi.Input['CVSSArgs']]:
        """
        The cvss v3 score for the vulnerability.
        """
        return pulumi.get(self, "cvssv3")

    @cvssv3.setter
    def cvssv3(self, value: Optional[pulumi.Input['CVSSArgs']]):
        pulumi.set(self, "cvssv3", value)

    @property
    @pulumi.getter(name="effectiveSeverity")
    def effective_severity(self) -> Optional[pulumi.Input['VulnerabilityOccurrenceEffectiveSeverity']]:
        """
        The distro assigned severity for this vulnerability when it is available, otherwise this is the note provider assigned severity. When there are multiple PackageIssues for this vulnerability, they can have different effective severities because some might be provided by the distro while others are provided by the language ecosystem for a language pack. For this reason, it is advised to use the effective severity on the PackageIssue level. In the case where multiple PackageIssues have differing effective severities, this field should be the highest severity for any of the PackageIssues.
        """
        return pulumi.get(self, "effective_severity")

    @effective_severity.setter
    def effective_severity(self, value: Optional[pulumi.Input['VulnerabilityOccurrenceEffectiveSeverity']]):
        pulumi.set(self, "effective_severity", value)

    @property
    @pulumi.getter
    def type(self) -> Optional[pulumi.Input[str]]:
        """
        The type of package; whether native or non native (e.g., ruby gems, node.js packages, etc.).
        """
        return pulumi.get(self, "type")

    @type.setter
    def type(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "type", value)


@pulumi.input_type
class WindowsDetailArgs:
    def __init__(__self__, *,
                 cpe_uri: pulumi.Input[str],
                 fixing_kbs: pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]],
                 name: pulumi.Input[str],
                 description: Optional[pulumi.Input[str]] = None):
        """
        :param pulumi.Input[str] cpe_uri: The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        :param pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]] fixing_kbs: The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed KBs presence is considered a fix.
        :param pulumi.Input[str] name: The name of this vulnerability.
        :param pulumi.Input[str] description: The description of this vulnerability.
        """
        pulumi.set(__self__, "cpe_uri", cpe_uri)
        pulumi.set(__self__, "fixing_kbs", fixing_kbs)
        pulumi.set(__self__, "name", name)
        if description is not None:
            pulumi.set(__self__, "description", description)

    @property
    @pulumi.getter(name="cpeUri")
    def cpe_uri(self) -> pulumi.Input[str]:
        """
        The [CPE URI](https://cpe.mitre.org/specification/) this vulnerability affects.
        """
        return pulumi.get(self, "cpe_uri")

    @cpe_uri.setter
    def cpe_uri(self, value: pulumi.Input[str]):
        pulumi.set(self, "cpe_uri", value)

    @property
    @pulumi.getter(name="fixingKbs")
    def fixing_kbs(self) -> pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]]:
        """
        The names of the KBs which have hotfixes to mitigate this vulnerability. Note that there may be multiple hotfixes (and thus multiple KBs) that mitigate a given vulnerability. Currently any listed KBs presence is considered a fix.
        """
        return pulumi.get(self, "fixing_kbs")

    @fixing_kbs.setter
    def fixing_kbs(self, value: pulumi.Input[Sequence[pulumi.Input['KnowledgeBaseArgs']]]):
        pulumi.set(self, "fixing_kbs", value)

    @property
    @pulumi.getter
    def name(self) -> pulumi.Input[str]:
        """
        The name of this vulnerability.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: pulumi.Input[str]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The description of this vulnerability.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)


@pulumi.input_type
class WindowsUpdateArgs:
    def __init__(__self__, *,
                 categories: Optional[pulumi.Input[Sequence[pulumi.Input['CategoryArgs']]]] = None,
                 description: Optional[pulumi.Input[str]] = None,
                 identity: Optional[pulumi.Input['IdentityArgs']] = None,
                 kb_article_ids: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 last_published_timestamp: Optional[pulumi.Input[str]] = None,
                 support_url: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Windows Update represents the metadata about the update for the Windows operating system. The fields in this message come from the Windows Update API documented at https://docs.microsoft.com/en-us/windows/win32/api/wuapi/nn-wuapi-iupdate.
        :param pulumi.Input[Sequence[pulumi.Input['CategoryArgs']]] categories: The list of categories to which the update belongs.
        :param pulumi.Input[str] description: The localized description of the update.
        :param pulumi.Input['IdentityArgs'] identity: Required - The unique identifier for the update.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] kb_article_ids: The Microsoft Knowledge Base article IDs that are associated with the update.
        :param pulumi.Input[str] last_published_timestamp: The last published timestamp of the update.
        :param pulumi.Input[str] support_url: The hyperlink to the support information for the update.
        :param pulumi.Input[str] title: The localized title of the update.
        """
        if categories is not None:
            pulumi.set(__self__, "categories", categories)
        if description is not None:
            pulumi.set(__self__, "description", description)
        if identity is not None:
            pulumi.set(__self__, "identity", identity)
        if kb_article_ids is not None:
            pulumi.set(__self__, "kb_article_ids", kb_article_ids)
        if last_published_timestamp is not None:
            pulumi.set(__self__, "last_published_timestamp", last_published_timestamp)
        if support_url is not None:
            pulumi.set(__self__, "support_url", support_url)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def categories(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CategoryArgs']]]]:
        """
        The list of categories to which the update belongs.
        """
        return pulumi.get(self, "categories")

    @categories.setter
    def categories(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CategoryArgs']]]]):
        pulumi.set(self, "categories", value)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        The localized description of the update.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def identity(self) -> Optional[pulumi.Input['IdentityArgs']]:
        """
        Required - The unique identifier for the update.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: Optional[pulumi.Input['IdentityArgs']]):
        pulumi.set(self, "identity", value)

    @property
    @pulumi.getter(name="kbArticleIds")
    def kb_article_ids(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        The Microsoft Knowledge Base article IDs that are associated with the update.
        """
        return pulumi.get(self, "kb_article_ids")

    @kb_article_ids.setter
    def kb_article_ids(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "kb_article_ids", value)

    @property
    @pulumi.getter(name="lastPublishedTimestamp")
    def last_published_timestamp(self) -> Optional[pulumi.Input[str]]:
        """
        The last published timestamp of the update.
        """
        return pulumi.get(self, "last_published_timestamp")

    @last_published_timestamp.setter
    def last_published_timestamp(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "last_published_timestamp", value)

    @property
    @pulumi.getter(name="supportUrl")
    def support_url(self) -> Optional[pulumi.Input[str]]:
        """
        The hyperlink to the support information for the update.
        """
        return pulumi.get(self, "support_url")

    @support_url.setter
    def support_url(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "support_url", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        The localized title of the update.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


