# coding=utf-8
# *** WARNING: this file was generated by the Pulumi SDK Generator. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from ... import _utilities
from ._enums import *

__all__ = [
    'AccessSelectorArgs',
    'ConditionContextArgs',
    'ExprArgs',
    'FeedOutputConfigArgs',
    'IamPolicyAnalysisQueryArgs',
    'IdentitySelectorArgs',
    'OptionsArgs',
    'PubsubDestinationArgs',
    'QueryContentArgs',
    'ResourceSelectorArgs',
]

@pulumi.input_type
class AccessSelectorArgs:
    def __init__(__self__, *,
                 permissions: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 roles: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None):
        """
        Specifies roles and/or permissions to analyze, to determine both the identities possessing them and the resources they control. If multiple values are specified, results will include roles or permissions matching any of them. The total number of roles and permissions should be equal or less than 10.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] permissions: Optional. The permissions to appear in result.
        :param pulumi.Input[Sequence[pulumi.Input[str]]] roles: Optional. The roles to appear in result.
        """
        if permissions is not None:
            pulumi.set(__self__, "permissions", permissions)
        if roles is not None:
            pulumi.set(__self__, "roles", roles)

    @property
    @pulumi.getter
    def permissions(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The permissions to appear in result.
        """
        return pulumi.get(self, "permissions")

    @permissions.setter
    def permissions(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "permissions", value)

    @property
    @pulumi.getter
    def roles(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        """
        Optional. The roles to appear in result.
        """
        return pulumi.get(self, "roles")

    @roles.setter
    def roles(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "roles", value)


@pulumi.input_type
class ConditionContextArgs:
    def __init__(__self__, *,
                 access_time: Optional[pulumi.Input[str]] = None):
        """
        The IAM conditions context.
        :param pulumi.Input[str] access_time: The hypothetical access timestamp to evaluate IAM conditions. Note that this value must not be earlier than the current time; otherwise, an INVALID_ARGUMENT error will be returned.
        """
        if access_time is not None:
            pulumi.set(__self__, "access_time", access_time)

    @property
    @pulumi.getter(name="accessTime")
    def access_time(self) -> Optional[pulumi.Input[str]]:
        """
        The hypothetical access timestamp to evaluate IAM conditions. Note that this value must not be earlier than the current time; otherwise, an INVALID_ARGUMENT error will be returned.
        """
        return pulumi.get(self, "access_time")

    @access_time.setter
    def access_time(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "access_time", value)


@pulumi.input_type
class ExprArgs:
    def __init__(__self__, *,
                 description: Optional[pulumi.Input[str]] = None,
                 expression: Optional[pulumi.Input[str]] = None,
                 location: Optional[pulumi.Input[str]] = None,
                 title: Optional[pulumi.Input[str]] = None):
        """
        Represents a textual expression in the Common Expression Language (CEL) syntax. CEL is a C-like expression language. The syntax and semantics of CEL are documented at https://github.com/google/cel-spec. Example (Comparison): title: "Summary size limit" description: "Determines if a summary is less than 100 chars" expression: "document.summary.size() < 100" Example (Equality): title: "Requestor is owner" description: "Determines if requestor is the document owner" expression: "document.owner == request.auth.claims.email" Example (Logic): title: "Public documents" description: "Determine whether the document should be publicly visible" expression: "document.type != 'private' && document.type != 'internal'" Example (Data Manipulation): title: "Notification string" description: "Create a notification string with a timestamp." expression: "'New message received at ' + string(document.create_time)" The exact variables and functions that may be referenced within an expression are determined by the service that evaluates it. See the service documentation for additional information.
        :param pulumi.Input[str] description: Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        :param pulumi.Input[str] expression: Textual representation of an expression in Common Expression Language syntax.
        :param pulumi.Input[str] location: Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        :param pulumi.Input[str] title: Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        if description is not None:
            pulumi.set(__self__, "description", description)
        if expression is not None:
            pulumi.set(__self__, "expression", expression)
        if location is not None:
            pulumi.set(__self__, "location", location)
        if title is not None:
            pulumi.set(__self__, "title", title)

    @property
    @pulumi.getter
    def description(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Description of the expression. This is a longer text which describes the expression, e.g. when hovered over it in a UI.
        """
        return pulumi.get(self, "description")

    @description.setter
    def description(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "description", value)

    @property
    @pulumi.getter
    def expression(self) -> Optional[pulumi.Input[str]]:
        """
        Textual representation of an expression in Common Expression Language syntax.
        """
        return pulumi.get(self, "expression")

    @expression.setter
    def expression(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "expression", value)

    @property
    @pulumi.getter
    def location(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. String indicating the location of the expression for error reporting, e.g. a file name and a position in the file.
        """
        return pulumi.get(self, "location")

    @location.setter
    def location(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "location", value)

    @property
    @pulumi.getter
    def title(self) -> Optional[pulumi.Input[str]]:
        """
        Optional. Title for the expression, i.e. a short string describing its purpose. This can be used e.g. in UIs which allow to enter the expression.
        """
        return pulumi.get(self, "title")

    @title.setter
    def title(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "title", value)


@pulumi.input_type
class FeedOutputConfigArgs:
    def __init__(__self__, *,
                 pubsub_destination: Optional[pulumi.Input['PubsubDestinationArgs']] = None):
        """
        Output configuration for asset feed destination.
        :param pulumi.Input['PubsubDestinationArgs'] pubsub_destination: Destination on Pub/Sub.
        """
        if pubsub_destination is not None:
            pulumi.set(__self__, "pubsub_destination", pubsub_destination)

    @property
    @pulumi.getter(name="pubsubDestination")
    def pubsub_destination(self) -> Optional[pulumi.Input['PubsubDestinationArgs']]:
        """
        Destination on Pub/Sub.
        """
        return pulumi.get(self, "pubsub_destination")

    @pubsub_destination.setter
    def pubsub_destination(self, value: Optional[pulumi.Input['PubsubDestinationArgs']]):
        pulumi.set(self, "pubsub_destination", value)


@pulumi.input_type
class IamPolicyAnalysisQueryArgs:
    def __init__(__self__, *,
                 scope: pulumi.Input[str],
                 access_selector: Optional[pulumi.Input['AccessSelectorArgs']] = None,
                 condition_context: Optional[pulumi.Input['ConditionContextArgs']] = None,
                 identity_selector: Optional[pulumi.Input['IdentitySelectorArgs']] = None,
                 options: Optional[pulumi.Input['OptionsArgs']] = None,
                 resource_selector: Optional[pulumi.Input['ResourceSelectorArgs']] = None):
        """
        IAM policy analysis query message.
        :param pulumi.Input[str] scope: The relative name of the root asset. Only resources and IAM policies within the scope will be analyzed. This can only be an organization number (such as "organizations/123"), a folder number (such as "folders/123"), a project ID (such as "projects/my-project-id"), or a project number (such as "projects/12345"). To know how to get organization id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id). To know how to get folder or project id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
        :param pulumi.Input['AccessSelectorArgs'] access_selector: Optional. Specifies roles or permissions for analysis. This is optional.
        :param pulumi.Input['ConditionContextArgs'] condition_context: Optional. The hypothetical context for IAM conditions evaluation.
        :param pulumi.Input['IdentitySelectorArgs'] identity_selector: Optional. Specifies an identity for analysis.
        :param pulumi.Input['OptionsArgs'] options: Optional. The query options.
        :param pulumi.Input['ResourceSelectorArgs'] resource_selector: Optional. Specifies a resource for analysis.
        """
        pulumi.set(__self__, "scope", scope)
        if access_selector is not None:
            pulumi.set(__self__, "access_selector", access_selector)
        if condition_context is not None:
            pulumi.set(__self__, "condition_context", condition_context)
        if identity_selector is not None:
            pulumi.set(__self__, "identity_selector", identity_selector)
        if options is not None:
            pulumi.set(__self__, "options", options)
        if resource_selector is not None:
            pulumi.set(__self__, "resource_selector", resource_selector)

    @property
    @pulumi.getter
    def scope(self) -> pulumi.Input[str]:
        """
        The relative name of the root asset. Only resources and IAM policies within the scope will be analyzed. This can only be an organization number (such as "organizations/123"), a folder number (such as "folders/123"), a project ID (such as "projects/my-project-id"), or a project number (such as "projects/12345"). To know how to get organization id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-organization#retrieving_your_organization_id). To know how to get folder or project id, visit [here ](https://cloud.google.com/resource-manager/docs/creating-managing-folders#viewing_or_listing_folders_and_projects).
        """
        return pulumi.get(self, "scope")

    @scope.setter
    def scope(self, value: pulumi.Input[str]):
        pulumi.set(self, "scope", value)

    @property
    @pulumi.getter(name="accessSelector")
    def access_selector(self) -> Optional[pulumi.Input['AccessSelectorArgs']]:
        """
        Optional. Specifies roles or permissions for analysis. This is optional.
        """
        return pulumi.get(self, "access_selector")

    @access_selector.setter
    def access_selector(self, value: Optional[pulumi.Input['AccessSelectorArgs']]):
        pulumi.set(self, "access_selector", value)

    @property
    @pulumi.getter(name="conditionContext")
    def condition_context(self) -> Optional[pulumi.Input['ConditionContextArgs']]:
        """
        Optional. The hypothetical context for IAM conditions evaluation.
        """
        return pulumi.get(self, "condition_context")

    @condition_context.setter
    def condition_context(self, value: Optional[pulumi.Input['ConditionContextArgs']]):
        pulumi.set(self, "condition_context", value)

    @property
    @pulumi.getter(name="identitySelector")
    def identity_selector(self) -> Optional[pulumi.Input['IdentitySelectorArgs']]:
        """
        Optional. Specifies an identity for analysis.
        """
        return pulumi.get(self, "identity_selector")

    @identity_selector.setter
    def identity_selector(self, value: Optional[pulumi.Input['IdentitySelectorArgs']]):
        pulumi.set(self, "identity_selector", value)

    @property
    @pulumi.getter
    def options(self) -> Optional[pulumi.Input['OptionsArgs']]:
        """
        Optional. The query options.
        """
        return pulumi.get(self, "options")

    @options.setter
    def options(self, value: Optional[pulumi.Input['OptionsArgs']]):
        pulumi.set(self, "options", value)

    @property
    @pulumi.getter(name="resourceSelector")
    def resource_selector(self) -> Optional[pulumi.Input['ResourceSelectorArgs']]:
        """
        Optional. Specifies a resource for analysis.
        """
        return pulumi.get(self, "resource_selector")

    @resource_selector.setter
    def resource_selector(self, value: Optional[pulumi.Input['ResourceSelectorArgs']]):
        pulumi.set(self, "resource_selector", value)


@pulumi.input_type
class IdentitySelectorArgs:
    def __init__(__self__, *,
                 identity: pulumi.Input[str]):
        """
        Specifies an identity for which to determine resource access, based on roles assigned either directly to them or to the groups they belong to, directly or indirectly.
        :param pulumi.Input[str] identity: The identity appear in the form of principals in [IAM policy binding](https://cloud.google.com/iam/reference/rest/v1/Binding). The examples of supported forms are: "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com". Notice that wildcard characters (such as * and ?) are not supported. You must give a specific identity.
        """
        pulumi.set(__self__, "identity", identity)

    @property
    @pulumi.getter
    def identity(self) -> pulumi.Input[str]:
        """
        The identity appear in the form of principals in [IAM policy binding](https://cloud.google.com/iam/reference/rest/v1/Binding). The examples of supported forms are: "user:mike@example.com", "group:admins@example.com", "domain:google.com", "serviceAccount:my-project-id@appspot.gserviceaccount.com". Notice that wildcard characters (such as * and ?) are not supported. You must give a specific identity.
        """
        return pulumi.get(self, "identity")

    @identity.setter
    def identity(self, value: pulumi.Input[str]):
        pulumi.set(self, "identity", value)


@pulumi.input_type
class OptionsArgs:
    def __init__(__self__, *,
                 analyze_service_account_impersonation: Optional[pulumi.Input[bool]] = None,
                 expand_groups: Optional[pulumi.Input[bool]] = None,
                 expand_resources: Optional[pulumi.Input[bool]] = None,
                 expand_roles: Optional[pulumi.Input[bool]] = None,
                 output_group_edges: Optional[pulumi.Input[bool]] = None,
                 output_resource_edges: Optional[pulumi.Input[bool]] = None):
        """
        Contains query options.
        :param pulumi.Input[bool] analyze_service_account_impersonation: Optional. If true, the response will include access analysis from identities to resources via service account impersonation. This is a very expensive operation, because many derived queries will be executed. We highly recommend you use AssetService.AnalyzeIamPolicyLongrunning rpc instead. For example, if the request analyzes for which resources user A has permission P, and there's an IAM policy states user A has iam.serviceAccounts.getAccessToken permission to a service account SA, and there's another IAM policy states service account SA has permission P to a GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Another example, if the request analyzes for who has permission P to a GCP folder F, and there's an IAM policy states user A has iam.serviceAccounts.actAs permission to a service account SA, and there's another IAM policy states service account SA has permission P to the GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Only the following permissions are considered in this analysis: * `iam.serviceAccounts.actAs` * `iam.serviceAccounts.signBlob` * `iam.serviceAccounts.signJwt` * `iam.serviceAccounts.getAccessToken` * `iam.serviceAccounts.getOpenIdToken` * `iam.serviceAccounts.implicitDelegation` Default is false.
        :param pulumi.Input[bool] expand_groups: Optional. If true, the identities section of the result will expand any Google groups appearing in an IAM policy binding. If IamPolicyAnalysisQuery.identity_selector is specified, the identity in the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        :param pulumi.Input[bool] expand_resources: Optional. If true and IamPolicyAnalysisQuery.resource_selector is not specified, the resource section of the result will expand any resource attached to an IAM policy to include resources lower in the resource hierarchy. For example, if the request analyzes for which resources user A has permission P, and the results include an IAM policy with P on a GCP folder, the results will also include resources in that folder with permission P. If true and IamPolicyAnalysisQuery.resource_selector is specified, the resource section of the result will expand the specified resource to include resources lower in the resource hierarchy. Only project or lower resources are supported. Folder and organization resource cannot be used together with this option. For example, if the request analyzes for which users have permission P on a GCP project with this option enabled, the results will include all users who have permission P on that project or any lower resource. Default is false.
        :param pulumi.Input[bool] expand_roles: Optional. If true, the access section of result will expand any roles appearing in IAM policy bindings to include their permissions. If IamPolicyAnalysisQuery.access_selector is specified, the access section of the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        :param pulumi.Input[bool] output_group_edges: Optional. If true, the result will output the relevant membership relationships between groups and other groups, and between groups and principals. Default is false.
        :param pulumi.Input[bool] output_resource_edges: Optional. If true, the result will output the relevant parent/child relationships between resources. Default is false.
        """
        if analyze_service_account_impersonation is not None:
            pulumi.set(__self__, "analyze_service_account_impersonation", analyze_service_account_impersonation)
        if expand_groups is not None:
            pulumi.set(__self__, "expand_groups", expand_groups)
        if expand_resources is not None:
            pulumi.set(__self__, "expand_resources", expand_resources)
        if expand_roles is not None:
            pulumi.set(__self__, "expand_roles", expand_roles)
        if output_group_edges is not None:
            pulumi.set(__self__, "output_group_edges", output_group_edges)
        if output_resource_edges is not None:
            pulumi.set(__self__, "output_resource_edges", output_resource_edges)

    @property
    @pulumi.getter(name="analyzeServiceAccountImpersonation")
    def analyze_service_account_impersonation(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, the response will include access analysis from identities to resources via service account impersonation. This is a very expensive operation, because many derived queries will be executed. We highly recommend you use AssetService.AnalyzeIamPolicyLongrunning rpc instead. For example, if the request analyzes for which resources user A has permission P, and there's an IAM policy states user A has iam.serviceAccounts.getAccessToken permission to a service account SA, and there's another IAM policy states service account SA has permission P to a GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Another example, if the request analyzes for who has permission P to a GCP folder F, and there's an IAM policy states user A has iam.serviceAccounts.actAs permission to a service account SA, and there's another IAM policy states service account SA has permission P to the GCP folder F, then user A potentially has access to the GCP folder F. And those advanced analysis results will be included in AnalyzeIamPolicyResponse.service_account_impersonation_analysis. Only the following permissions are considered in this analysis: * `iam.serviceAccounts.actAs` * `iam.serviceAccounts.signBlob` * `iam.serviceAccounts.signJwt` * `iam.serviceAccounts.getAccessToken` * `iam.serviceAccounts.getOpenIdToken` * `iam.serviceAccounts.implicitDelegation` Default is false.
        """
        return pulumi.get(self, "analyze_service_account_impersonation")

    @analyze_service_account_impersonation.setter
    def analyze_service_account_impersonation(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "analyze_service_account_impersonation", value)

    @property
    @pulumi.getter(name="expandGroups")
    def expand_groups(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, the identities section of the result will expand any Google groups appearing in an IAM policy binding. If IamPolicyAnalysisQuery.identity_selector is specified, the identity in the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        """
        return pulumi.get(self, "expand_groups")

    @expand_groups.setter
    def expand_groups(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expand_groups", value)

    @property
    @pulumi.getter(name="expandResources")
    def expand_resources(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true and IamPolicyAnalysisQuery.resource_selector is not specified, the resource section of the result will expand any resource attached to an IAM policy to include resources lower in the resource hierarchy. For example, if the request analyzes for which resources user A has permission P, and the results include an IAM policy with P on a GCP folder, the results will also include resources in that folder with permission P. If true and IamPolicyAnalysisQuery.resource_selector is specified, the resource section of the result will expand the specified resource to include resources lower in the resource hierarchy. Only project or lower resources are supported. Folder and organization resource cannot be used together with this option. For example, if the request analyzes for which users have permission P on a GCP project with this option enabled, the results will include all users who have permission P on that project or any lower resource. Default is false.
        """
        return pulumi.get(self, "expand_resources")

    @expand_resources.setter
    def expand_resources(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expand_resources", value)

    @property
    @pulumi.getter(name="expandRoles")
    def expand_roles(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, the access section of result will expand any roles appearing in IAM policy bindings to include their permissions. If IamPolicyAnalysisQuery.access_selector is specified, the access section of the result will be determined by the selector, and this flag is not allowed to set. Default is false.
        """
        return pulumi.get(self, "expand_roles")

    @expand_roles.setter
    def expand_roles(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "expand_roles", value)

    @property
    @pulumi.getter(name="outputGroupEdges")
    def output_group_edges(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, the result will output the relevant membership relationships between groups and other groups, and between groups and principals. Default is false.
        """
        return pulumi.get(self, "output_group_edges")

    @output_group_edges.setter
    def output_group_edges(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "output_group_edges", value)

    @property
    @pulumi.getter(name="outputResourceEdges")
    def output_resource_edges(self) -> Optional[pulumi.Input[bool]]:
        """
        Optional. If true, the result will output the relevant parent/child relationships between resources. Default is false.
        """
        return pulumi.get(self, "output_resource_edges")

    @output_resource_edges.setter
    def output_resource_edges(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "output_resource_edges", value)


@pulumi.input_type
class PubsubDestinationArgs:
    def __init__(__self__, *,
                 topic: Optional[pulumi.Input[str]] = None):
        """
        A Pub/Sub destination.
        :param pulumi.Input[str] topic: The name of the Pub/Sub topic to publish to. Example: `projects/PROJECT_ID/topics/TOPIC_ID`.
        """
        if topic is not None:
            pulumi.set(__self__, "topic", topic)

    @property
    @pulumi.getter
    def topic(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the Pub/Sub topic to publish to. Example: `projects/PROJECT_ID/topics/TOPIC_ID`.
        """
        return pulumi.get(self, "topic")

    @topic.setter
    def topic(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "topic", value)


@pulumi.input_type
class QueryContentArgs:
    def __init__(__self__, *,
                 iam_policy_analysis_query: Optional[pulumi.Input['IamPolicyAnalysisQueryArgs']] = None):
        """
        The query content.
        :param pulumi.Input['IamPolicyAnalysisQueryArgs'] iam_policy_analysis_query: An IAM Policy Analysis query, which could be used in the AssetService.AnalyzeIamPolicy rpc or the AssetService.AnalyzeIamPolicyLongrunning rpc.
        """
        if iam_policy_analysis_query is not None:
            pulumi.set(__self__, "iam_policy_analysis_query", iam_policy_analysis_query)

    @property
    @pulumi.getter(name="iamPolicyAnalysisQuery")
    def iam_policy_analysis_query(self) -> Optional[pulumi.Input['IamPolicyAnalysisQueryArgs']]:
        """
        An IAM Policy Analysis query, which could be used in the AssetService.AnalyzeIamPolicy rpc or the AssetService.AnalyzeIamPolicyLongrunning rpc.
        """
        return pulumi.get(self, "iam_policy_analysis_query")

    @iam_policy_analysis_query.setter
    def iam_policy_analysis_query(self, value: Optional[pulumi.Input['IamPolicyAnalysisQueryArgs']]):
        pulumi.set(self, "iam_policy_analysis_query", value)


@pulumi.input_type
class ResourceSelectorArgs:
    def __init__(__self__, *,
                 full_resource_name: pulumi.Input[str]):
        """
        Specifies the resource to analyze for access policies, which may be set directly on the resource, or on ancestors such as organizations, folders or projects.
        :param pulumi.Input[str] full_resource_name: The [full resource name] (https://cloud.google.com/asset-inventory/docs/resource-name-format) of a resource of [supported resource types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
        """
        pulumi.set(__self__, "full_resource_name", full_resource_name)

    @property
    @pulumi.getter(name="fullResourceName")
    def full_resource_name(self) -> pulumi.Input[str]:
        """
        The [full resource name] (https://cloud.google.com/asset-inventory/docs/resource-name-format) of a resource of [supported resource types](https://cloud.google.com/asset-inventory/docs/supported-asset-types#analyzable_asset_types).
        """
        return pulumi.get(self, "full_resource_name")

    @full_resource_name.setter
    def full_resource_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "full_resource_name", value)


